/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.internal.io;

import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.UUID;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.lib.output.FileOutputCommitter;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.io.FileCommitProtocol;
import org.apache.spark.internal.io.FileCommitProtocol$;
import org.apache.spark.internal.io.FileNameSpec;
import org.apache.spark.internal.io.HadoopMapReduceCommitProtocol$;
import org.apache.spark.internal.io.SparkHadoopWriterUtils$;
import org.apache.spark.mapred.SparkHadoopMapRedUtil$;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005-h\u0001\u0002\u0011\"\u00011B\u0001b\u0011\u0001\u0003\u0002\u0003\u0006I\u0001\u0012\u0005\t\u0019\u0002\u0011\t\u0011)A\u0005\t\"AQ\n\u0001B\u0001B\u0003%a\nC\u0003S\u0001\u0011\u00051\u000bC\u0005Y\u0001\u0001\u0007\t\u0019!C\u00053\"I!\r\u0001a\u0001\u0002\u0004%Ia\u0019\u0005\nS\u0002\u0001\r\u0011!Q!\niCqA\u001c\u0001C\u0002\u0013%q\u000e\u0003\u0004q\u0001\u0001\u0006IA\u0014\u0005\bc\u0002\u0001\r\u0011\"\u0003s\u0011\u001dY\b\u00011A\u0005\nqDaA \u0001!B\u0013\u0019\b\"CA\u0001\u0001\u0001\u0007I\u0011BA\u0002\u0011%\tY\u0001\u0001a\u0001\n\u0013\ti\u0001\u0003\u0005\u0002\u0012\u0001\u0001\u000b\u0015BA\u0003\u0011)\t)\u0002\u0001EC\u0002\u0013E\u0011q\u0003\u0005\b\u0003O\u0001A\u0011CA\u0015\u0011\u001d\t)\u0004\u0001C!\u0003oAq!!\u0015\u0001\t\u0003\n\u0019\u0006C\u0004\u0002^\u0001!\t\"a\u0018\t\u000f\u0005\u0015\u0004\u0001\"\u0011\u0002h!9\u00111\u000f\u0001\u0005B\u0005U\u0004bBAI\u0001\u0011\u0005\u00131\u0013\u0005\b\u0003/\u0003A\u0011IAM\u0011\u001d\ti\n\u0001C!\u0003?Cq!a)\u0001\t\u0003\n)kB\u0005\u0002*\u0006\n\t\u0011#\u0001\u0002,\u001aA\u0001%IA\u0001\u0012\u0003\ti\u000b\u0003\u0004S9\u0011\u0005\u0011\u0011\u0019\u0005\n\u0003\u0007d\u0012\u0013!C\u0001\u0003\u000bD\u0011\"a7\u001d\u0003\u0003%I!!8\u0003;!\u000bGm\\8q\u001b\u0006\u0004(+\u001a3vG\u0016\u001cu.\\7jiB\u0013x\u000e^8d_2T!AI\u0012\u0002\u0005%|'B\u0001\u0013&\u0003!Ig\u000e^3s]\u0006d'B\u0001\u0014(\u0003\u0015\u0019\b/\u0019:l\u0015\tA\u0013&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002U\u0005\u0019qN]4\u0004\u0001M!\u0001!L\u0019@!\tqs&D\u0001\"\u0013\t\u0001\u0014E\u0001\nGS2,7i\\7nSR\u0004&o\u001c;pG>d\u0007C\u0001\u001a=\u001d\t\u0019\u0014H\u0004\u00025o5\tQG\u0003\u00027W\u00051AH]8pizJ\u0011\u0001O\u0001\u0006g\u000e\fG.Y\u0005\u0003um\nq\u0001]1dW\u0006<WMC\u00019\u0013\tidH\u0001\u0007TKJL\u0017\r\\5{C\ndWM\u0003\u0002;wA\u0011\u0001)Q\u0007\u0002G%\u0011!i\t\u0002\b\u0019><w-\u001b8h\u0003\u0015QwNY%e!\t)\u0015J\u0004\u0002G\u000fB\u0011AgO\u0005\u0003\u0011n\na\u0001\u0015:fI\u00164\u0017B\u0001&L\u0005\u0019\u0019FO]5oO*\u0011\u0001jO\u0001\u0005a\u0006$\b.A\res:\fW.[2QCJ$\u0018\u000e^5p]>3XM]<sSR,\u0007CA(Q\u001b\u0005Y\u0014BA)<\u0005\u001d\u0011un\u001c7fC:\fa\u0001P5oSRtD\u0003\u0002+V-^\u0003\"A\f\u0001\t\u000b\r#\u0001\u0019\u0001#\t\u000b1#\u0001\u0019\u0001#\t\u000f5#\u0001\u0013!a\u0001\u001d\u0006I1m\\7nSR$XM]\u000b\u00025B\u00111\fY\u0007\u00029*\u0011QLX\u0001\n[\u0006\u0004(/\u001a3vG\u0016T!aX\u0014\u0002\r!\fGm\\8q\u0013\t\tGLA\bPkR\u0004X\u000f^\"p[6LG\u000f^3s\u00035\u0019w.\\7jiR,'o\u0018\u0013fcR\u0011Am\u001a\t\u0003\u001f\u0016L!AZ\u001e\u0003\tUs\u0017\u000e\u001e\u0005\bQ\u001a\t\t\u00111\u0001[\u0003\rAH%M\u0001\u000bG>lW.\u001b;uKJ\u0004\u0003FA\u0004l!\tyE.\u0003\u0002nw\tIAO]1og&,g\u000e^\u0001\rQ\u0006\u001ch+\u00197jIB\u000bG\u000f[\u000b\u0002\u001d\u0006i\u0001.Y:WC2LG\rU1uQ\u0002\n\u0011#\u00193eK\u0012\f%m\u001d)bi\"4\u0015\u000e\\3t+\u0005\u0019\b\u0003\u0002;z\t\u0012k\u0011!\u001e\u0006\u0003m^\fq!\\;uC\ndWM\u0003\u0002yw\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005i,(aA'ba\u0006)\u0012\r\u001a3fI\u0006\u00137\u000fU1uQ\u001aKG.Z:`I\u0015\fHC\u00013~\u0011\u001dA7\"!AA\u0002M\f!#\u00193eK\u0012\f%m\u001d)bi\"4\u0015\u000e\\3tA!\u0012Ab[\u0001\u000fa\u0006\u0014H/\u001b;j_:\u0004\u0016\r\u001e5t+\t\t)\u0001\u0005\u0003u\u0003\u000f!\u0015bAA\u0005k\n\u00191+\u001a;\u0002%A\f'\u000f^5uS>t\u0007+\u0019;ig~#S-\u001d\u000b\u0004I\u0006=\u0001\u0002\u00035\u000f\u0003\u0003\u0005\r!!\u0002\u0002\u001fA\f'\u000f^5uS>t\u0007+\u0019;ig\u0002B#aD6\u0002\u0015M$\u0018mZ5oO\u0012K'/\u0006\u0002\u0002\u001aA!\u00111DA\u0011\u001b\t\tiBC\u0002\u0002 y\u000b!AZ:\n\t\u0005\r\u0012Q\u0004\u0002\u0005!\u0006$\b\u000e\u000b\u0002\u0011W\u0006q1/\u001a;va\u000e{W.\\5ui\u0016\u0014Hc\u0001.\u0002,!9\u0011QF\tA\u0002\u0005=\u0012aB2p]R,\u0007\u0010\u001e\t\u00047\u0006E\u0012bAA\u001a9\n\u0011B+Y:l\u0003R$X-\u001c9u\u0007>tG/\u001a=u\u0003=qWm\u001e+bg.$V-\u001c9GS2,Gc\u0002#\u0002:\u0005u\u0012q\t\u0005\b\u0003w\u0011\u0002\u0019AA\u0018\u0003-!\u0018m]6D_:$X\r\u001f;\t\u000f\u0005}\"\u00031\u0001\u0002B\u0005\u0019A-\u001b:\u0011\t=\u000b\u0019\u0005R\u0005\u0004\u0003\u000bZ$AB(qi&|g\u000eC\u0004\u0002JI\u0001\r!a\u0013\u0002\tM\u0004Xm\u0019\t\u0004]\u00055\u0013bAA(C\taa)\u001b7f\u001d\u0006lWm\u00159fG\u00061b.Z<UCN\\G+Z7q\r&dW-\u00112t!\u0006$\b\u000eF\u0004E\u0003+\n9&a\u0017\t\u000f\u0005m2\u00031\u0001\u00020!1\u0011\u0011L\nA\u0002\u0011\u000b1\"\u00192t_2,H/\u001a#je\"9\u0011\u0011J\nA\u0002\u0005-\u0013aC4fi\u001aKG.\u001a8b[\u0016$R\u0001RA1\u0003GBq!a\u000f\u0015\u0001\u0004\ty\u0003C\u0004\u0002JQ\u0001\r!a\u0013\u0002\u0011M,G/\u001e9K_\n$2\u0001ZA5\u0011\u001d\tY'\u0006a\u0001\u0003[\n!B[8c\u0007>tG/\u001a=u!\rY\u0016qN\u0005\u0004\u0003cb&A\u0003&pE\u000e{g\u000e^3yi\u0006I1m\\7nSRTuN\u0019\u000b\u0006I\u0006]\u0014\u0011\u0010\u0005\b\u0003W2\u0002\u0019AA7\u0011\u001d\tYH\u0006a\u0001\u0003{\n1\u0002^1tW\u000e{W.\\5ugB)!'a \u0002\u0004&\u0019\u0011\u0011\u0011 \u0003\u0007M+\u0017\u000f\u0005\u0003\u0002\u0006\u0006-eb\u0001\u0018\u0002\b&\u0019\u0011\u0011R\u0011\u0002%\u0019KG.Z\"p[6LG\u000f\u0015:pi>\u001cw\u000e\\\u0005\u0005\u0003\u001b\u000byIA\tUCN\\7i\\7nSRlUm]:bO\u0016T1!!#\"\u0003!\t'm\u001c:u\u0015>\u0014Gc\u00013\u0002\u0016\"9\u00111N\fA\u0002\u00055\u0014!C:fiV\u0004H+Y:l)\r!\u00171\u0014\u0005\b\u0003wA\u0002\u0019AA\u0018\u0003)\u0019w.\\7jiR\u000b7o\u001b\u000b\u0005\u0003\u0007\u000b\t\u000bC\u0004\u0002<e\u0001\r!a\f\u0002\u0013\u0005\u0014wN\u001d;UCN\\Gc\u00013\u0002(\"9\u00111\b\u000eA\u0002\u0005=\u0012!\b%bI>|\u0007/T1q%\u0016$WoY3D_6l\u0017\u000e\u001e)s_R|7m\u001c7\u0011\u00059b2#\u0002\u000f\u00020\u0006U\u0006cA(\u00022&\u0019\u00111W\u001e\u0003\r\u0005s\u0017PU3g!\u0011\t9,a0\u000e\u0005\u0005e&b\u0001\u0012\u0002<*\u0011\u0011QX\u0001\u0005U\u00064\u0018-C\u0002>\u0003s#\"!a+\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\t9MK\u0002O\u0003\u0013\\#!a3\u0011\t\u00055\u0017q[\u0007\u0003\u0003\u001fTA!!5\u0002T\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003+\\\u0014AC1o]>$\u0018\r^5p]&!\u0011\u0011\\Ah\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0003?\u0004B!!9\u0002h6\u0011\u00111\u001d\u0006\u0005\u0003K\fY,\u0001\u0003mC:<\u0017\u0002BAu\u0003G\u0014aa\u00142kK\u000e$\b")
public class HadoopMapReduceCommitProtocol
extends FileCommitProtocol
implements Serializable {
    private transient Path stagingDir;
    private final String jobId;
    private final String path;
    private final boolean dynamicPartitionOverwrite;
    private transient OutputCommitter committer;
    private final boolean hasValidPath;
    private transient Map<String, String> addedAbsPathFiles;
    private transient Set<String> partitionPaths;
    private volatile transient boolean bitmap$trans$0;

    public static boolean $lessinit$greater$default$3() {
        return HadoopMapReduceCommitProtocol$.MODULE$.$lessinit$greater$default$3();
    }

    private OutputCommitter committer() {
        return this.committer;
    }

    private void committer_$eq(OutputCommitter x$1) {
        this.committer = x$1;
    }

    private boolean hasValidPath() {
        return this.hasValidPath;
    }

    private Map<String, String> addedAbsPathFiles() {
        return this.addedAbsPathFiles;
    }

    private void addedAbsPathFiles_$eq(Map<String, String> x$1) {
        this.addedAbsPathFiles = x$1;
    }

    private Set<String> partitionPaths() {
        return this.partitionPaths;
    }

    private void partitionPaths_$eq(Set<String> x$1) {
        this.partitionPaths = x$1;
    }

    private Path stagingDir$lzycompute() {
        HadoopMapReduceCommitProtocol hadoopMapReduceCommitProtocol = this;
        synchronized (hadoopMapReduceCommitProtocol) {
            if (!this.bitmap$trans$0) {
                this.stagingDir = FileCommitProtocol$.MODULE$.getStagingDir(this.path, this.jobId);
                this.bitmap$trans$0 = true;
            }
        }
        return this.stagingDir;
    }

    public Path stagingDir() {
        if (!this.bitmap$trans$0) {
            return this.stagingDir$lzycompute();
        }
        return this.stagingDir;
    }

    public OutputCommitter setupCommitter(TaskAttemptContext context) {
        OutputFormat format;
        block0: {
            format = (OutputFormat)context.getOutputFormatClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            OutputFormat outputFormat = format;
            if (!(outputFormat instanceof Configurable)) break block0;
            OutputFormat outputFormat2 = outputFormat;
            ((Configurable)outputFormat2).setConf(context.getConfiguration());
        }
        return format.getOutputCommitter(context);
    }

    @Override
    public String newTaskTempFile(TaskAttemptContext taskContext, Option<String> dir, FileNameSpec spec) {
        Path path;
        String filename = this.getFilename(taskContext, spec);
        OutputCommitter outputCommitter = this.committer();
        if (outputCommitter instanceof FileOutputCommitter) {
            FileOutputCommitter fileOutputCommitter = (FileOutputCommitter)outputCommitter;
            if (this.dynamicPartitionOverwrite) {
                Predef$.MODULE$.assert(dir.isDefined(), (Function0 & Serializable)() -> "The dataset to be written must be partitioned when dynamicPartitionOverwrite is true.");
                v0 = this.partitionPaths().$plus$eq(dir.get());
            } else {
                v0 = BoxedUnit.UNIT;
            }
            path = new Path((String)Option$.MODULE$.apply((Object)fileOutputCommitter.getWorkPath()).map((Function1 & Serializable)x$2 -> x$2.toString()).getOrElse((Function0 & Serializable)() -> $this.path));
        } else {
            path = new Path(this.path);
        }
        Path stagingDir = path;
        return (String)dir.map((Function1 & Serializable)d -> new Path(new Path(stagingDir, d), filename).toString()).getOrElse((Function0 & Serializable)() -> new Path(stagingDir, filename).toString());
    }

    @Override
    public String newTaskTempFileAbsPath(TaskAttemptContext taskContext, String absoluteDir, FileNameSpec spec) {
        String filename = this.getFilename(taskContext, spec);
        String absOutputPath = new Path(absoluteDir, filename).toString();
        String tmpOutputPath = new Path(this.stagingDir(), UUID.randomUUID().toString() + "-" + filename).toString();
        this.addedAbsPathFiles().update((Object)tmpOutputPath, (Object)absOutputPath);
        return tmpOutputPath;
    }

    public String getFilename(TaskAttemptContext taskContext, FileNameSpec spec) {
        int split = taskContext.getTaskAttemptID().getTaskID().getId();
        String basename = taskContext.getConfiguration().get("mapreduce.output.basename", "part");
        return StringOps$.MODULE$.format$extension("%s%s-%05d-%s%s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{spec.prefix(), basename, BoxesRunTime.boxToInteger((int)split), this.jobId, spec.suffix()}));
    }

    @Override
    public void setupJob(JobContext jobContext) {
        JobID jobId = SparkHadoopWriterUtils$.MODULE$.createJobID(new Date(), 0);
        TaskID taskId = new TaskID((org.apache.hadoop.mapreduce.JobID)jobId, TaskType.MAP, 0);
        TaskAttemptID taskAttemptId = new TaskAttemptID(taskId, 0);
        jobContext.getConfiguration().set("mapreduce.job.id", jobId.toString());
        jobContext.getConfiguration().set("mapreduce.task.id", taskAttemptId.getTaskID().toString());
        jobContext.getConfiguration().set("mapreduce.task.attempt.id", taskAttemptId.toString());
        jobContext.getConfiguration().setBoolean("mapreduce.task.ismap", true);
        jobContext.getConfiguration().setInt("mapreduce.task.partition", 0);
        TaskAttemptContextImpl taskAttemptContext = new TaskAttemptContextImpl(jobContext.getConfiguration(), taskAttemptId);
        this.committer_$eq(this.setupCommitter((TaskAttemptContext)taskAttemptContext));
        this.committer().setupJob(jobContext);
    }

    @Override
    public void commitJob(JobContext jobContext, Seq<FileCommitProtocol.TaskCommitMessage> taskCommits) {
        this.committer().commitJob(jobContext);
        if (this.hasValidPath()) {
            Tuple2 tuple2 = ((IterableOps)taskCommits.map((Function1 & Serializable)x$3 -> (Tuple2)x$3.obj())).unzip(Predef$.MODULE$.$conforms());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Seq allAbsPathFiles = (Seq)tuple2._1();
            Seq allPartitionPaths = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)allAbsPathFiles, (Object)allPartitionPaths);
            Seq allAbsPathFiles2 = (Seq)tuple22._1();
            Seq allPartitionPaths2 = (Seq)tuple22._2();
            FileSystem fs = this.stagingDir().getFileSystem(jobContext.getConfiguration());
            scala.collection.immutable.Map filesToMove = (scala.collection.immutable.Map)allAbsPathFiles2.foldLeft(Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Function2 & Serializable)(x$5, x$6) -> (scala.collection.immutable.Map)x$5.$plus$plus((IterableOnce)x$6));
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Committing files staged for absolute locations " + filesToMove);
            scala.collection.immutable.Set absParentPaths = ((IterableOnceOps)filesToMove.values().map((Function1 & Serializable)x$7 -> new Path(x$7).getParent())).toSet();
            if (this.dynamicPartitionOverwrite) {
                this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Clean up absolute partition directories for overwriting: " + absParentPaths);
                absParentPaths.foreach((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)fs.delete(x$8, true)));
            }
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Create absolute parent directories: " + absParentPaths);
            absParentPaths.foreach((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)fs.mkdirs(x$1)));
            filesToMove.withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)HadoopMapReduceCommitProtocol.$anonfun$commitJob$9(check$ifrefutable$1))).foreach((Function1 & Serializable)x$9 -> {
                HadoopMapReduceCommitProtocol.$anonfun$commitJob$10(fs, x$9);
                return BoxedUnit.UNIT;
            });
            if (this.dynamicPartitionOverwrite) {
                scala.collection.immutable.Set partitionPaths = (scala.collection.immutable.Set)allPartitionPaths2.foldLeft(Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), (Function2 & Serializable)(x$10, x$11) -> (scala.collection.immutable.Set)x$10.$plus$plus((IterableOnce)x$11));
                this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Clean up default partition directories for overwriting: " + partitionPaths);
                partitionPaths.foreach((Function1 & Serializable)part -> {
                    HadoopMapReduceCommitProtocol.$anonfun$commitJob$13(this, fs, part);
                    return BoxedUnit.UNIT;
                });
            }
            fs.delete(this.stagingDir(), true);
            return;
        }
    }

    @Override
    public void abortJob(JobContext jobContext) {
        try {
            this.committer().abortJob(jobContext, JobStatus.State.FAILED);
        }
        catch (IOException e) {
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Exception while aborting ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.JOB_ID, jobContext.getJobID())}))), (Throwable)e);
        }
        try {
            if (this.hasValidPath()) {
                FileSystem fs = this.stagingDir().getFileSystem(jobContext.getConfiguration());
                fs.delete(this.stagingDir(), true);
            }
        }
        catch (IOException e) {
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Exception while aborting ", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.JOB_ID, jobContext.getJobID())}))), (Throwable)e);
        }
    }

    @Override
    public void setupTask(TaskAttemptContext taskContext) {
        this.committer_$eq(this.setupCommitter(taskContext));
        this.committer().setupTask(taskContext);
        this.addedAbsPathFiles_$eq((Map<String, String>)((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$)));
        this.partitionPaths_$eq((Set<String>)((Set)Set$.MODULE$.apply((Seq)Nil$.MODULE$)));
    }

    @Override
    public FileCommitProtocol.TaskCommitMessage commitTask(TaskAttemptContext taskContext) {
        TaskAttemptID attemptId = taskContext.getTaskAttemptID();
        this.logTrace((Function0<String>)(Function0 & Serializable)() -> "Commit task " + attemptId);
        SparkHadoopMapRedUtil$.MODULE$.commitTask(this.committer(), taskContext, attemptId.getJobID().getId(), attemptId.getTaskID().getId());
        return new FileCommitProtocol.TaskCommitMessage(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.addedAbsPathFiles().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())), (Object)this.partitionPaths().toSet()));
    }

    @Override
    public void abortTask(TaskAttemptContext taskContext) {
        try {
            this.committer().abortTask(taskContext);
        }
        catch (IOException e) {
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Exception while aborting "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.TASK_ATTEMPT_ID, taskContext.getTaskAttemptID())})))), (Throwable)e);
        }
        try {
            this.addedAbsPathFiles().withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)HadoopMapReduceCommitProtocol.$anonfun$abortTask$2(check$ifrefutable$2))).foreach((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)HadoopMapReduceCommitProtocol.$anonfun$abortTask$3(taskContext, x$12)));
        }
        catch (IOException e) {
            this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Exception while aborting "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ""}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.TASK_ATTEMPT_ID, taskContext.getTaskAttemptID())})))), (Throwable)e);
        }
    }

    public static final /* synthetic */ boolean $anonfun$commitJob$9(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ void $anonfun$commitJob$10(FileSystem fs$1, Tuple2 x$9) {
        Tuple2 tuple2 = x$9;
        if (tuple2 != null) {
            String dst;
            String src = (String)tuple2._1();
            if (!fs$1.rename(new Path(src), new Path(dst = (String)tuple2._2()))) {
                throw new IOException("Failed to rename " + src + " to " + dst + " when committing files staged for absolute locations");
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$commitJob$13(HadoopMapReduceCommitProtocol $this, FileSystem fs$1, String part) {
        Path finalPartPath = new Path($this.path, part);
        Object object = !fs$1.delete(finalPartPath, true) && !fs$1.exists(finalPartPath.getParent()) ? BoxesRunTime.boxToBoolean((boolean)fs$1.mkdirs(finalPartPath.getParent())) : BoxedUnit.UNIT;
        Path stagingPartPath = new Path($this.stagingDir(), part);
        if (!fs$1.rename(stagingPartPath, finalPartPath)) {
            throw new IOException("Failed to rename " + stagingPartPath + " to " + finalPartPath + " when committing files staged for overwriting dynamic partitions");
        }
    }

    public static final /* synthetic */ boolean $anonfun$abortTask$2(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$abortTask$3(TaskAttemptContext taskContext$1, Tuple2 x$12) {
        Tuple2 tuple2 = x$12;
        if (tuple2 != null) {
            String src = (String)tuple2._1();
            Path tmp = new Path(src);
            return tmp.getFileSystem(taskContext$1.getConfiguration()).delete(tmp, false);
        }
        throw new MatchError((Object)tuple2);
    }

    public HadoopMapReduceCommitProtocol(String jobId, String path, boolean dynamicPartitionOverwrite) {
        this.jobId = jobId;
        this.path = path;
        this.dynamicPartitionOverwrite = dynamicPartitionOverwrite;
        this.hasValidPath = Try$.MODULE$.apply((Function0 & Serializable)() -> new Path($this.path)).isSuccess();
        this.addedAbsPathFiles = null;
        this.partitionPaths = null;
    }
}

