/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s;

import io.fabric8.kubernetes.api.model.Pod;
import java.util.Locale;
import java.util.UUID;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.KubernetesDriverConf;
import org.apache.spark.deploy.k8s.KubernetesDriverConf$;
import org.apache.spark.deploy.k8s.KubernetesExecutorConf;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.KubernetesVolumeUtils$;
import org.apache.spark.deploy.k8s.submit.MainAppResource;
import org.apache.spark.resource.ResourceProfile$;
import org.apache.spark.util.Utils$;
import scala.Option;
import scala.Predef$;
import scala.collection.StringOps$;

public final class KubernetesConf$ {
    public static final KubernetesConf$ MODULE$ = new KubernetesConf$();

    public KubernetesDriverConf createDriverConf(SparkConf sparkConf, String appId, MainAppResource mainAppResource, String mainClass, String[] appArgs, Option<String> proxyUser) {
        KubernetesVolumeUtils$.MODULE$.parseVolumesWithPrefix(sparkConf, Config$.MODULE$.KUBERNETES_EXECUTOR_VOLUMES_PREFIX());
        return new KubernetesDriverConf(sparkConf.clone(), appId, mainAppResource, mainClass, appArgs, proxyUser, KubernetesDriverConf$.MODULE$.$lessinit$greater$default$7());
    }

    public KubernetesExecutorConf createExecutorConf(SparkConf sparkConf, String executorId, String appId, Option<Pod> driverPod, int resourceProfileId) {
        return new KubernetesExecutorConf(sparkConf.clone(), appId, executorId, driverPod, resourceProfileId);
    }

    public int createExecutorConf$default$5() {
        return ResourceProfile$.MODULE$.DEFAULT_RESOURCE_PROFILE_ID();
    }

    public String getKubernetesAppId() {
        return "spark-" + UUID.randomUUID().toString().replaceAll("-", "");
    }

    public String getResourceNamePrefix(String appName) {
        String id = KubernetesUtils$.MODULE$.uniqueID(KubernetesUtils$.MODULE$.uniqueID$default$1());
        return (appName + "-" + id).trim().toLowerCase(Locale.ROOT).replaceAll("[^a-z0-9\\-]", "-").replaceAll("-+", "-").replaceAll("^-", "").replaceAll("^[0-9]", "x");
    }

    public String getAppNameLabel(String appName) {
        return StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(Utils$.MODULE$.abbreviate(String.valueOf(appName).trim().toLowerCase(Locale.ROOT).replaceAll("[^a-z0-9\\-]", "-").replaceAll("-+", "-"), "", Config$.MODULE$.KUBERNETES_DNS_LABEL_NAME_MAX_LENGTH())), "-")), "-");
    }

    public String buildKubernetesResourceName(String vendorDomain, String resourceName) {
        return vendorDomain + "/" + resourceName;
    }

    private KubernetesConf$() {
    }
}

