/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy.k8s;

import java.io.Serializable;
import java.util.Map;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkException;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.annotation.Unstable;
import org.apache.spark.deploy.k8s.Config$;
import org.apache.spark.deploy.k8s.Constants$;
import org.apache.spark.deploy.k8s.KubernetesConf;
import org.apache.spark.deploy.k8s.KubernetesConf$;
import org.apache.spark.deploy.k8s.KubernetesDriverConf$;
import org.apache.spark.deploy.k8s.KubernetesUtils$;
import org.apache.spark.deploy.k8s.KubernetesVolumeSpec;
import org.apache.spark.deploy.k8s.KubernetesVolumeUtils$;
import org.apache.spark.deploy.k8s.features.DriverServiceFeatureStep$;
import org.apache.spark.deploy.k8s.submit.MainAppResource;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.package$;
import org.apache.spark.util.Clock;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@Unstable
@DeveloperApi
@ScalaSignature(bytes="\u0006\u0005\u0005Ed\u0001\u0002\u0011\"\u00011B\u0011b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u001f\t\u0011u\u0002!Q1A\u0005\u0002yB\u0001\u0002\u0014\u0001\u0003\u0002\u0003\u0006Ia\u0010\u0005\t\u001b\u0002\u0011)\u0019!C\u0001\u001d\"AQ\u000b\u0001B\u0001B\u0003%q\n\u0003\u0005W\u0001\t\u0015\r\u0011\"\u0001?\u0011!9\u0006A!A!\u0002\u0013y\u0004\u0002\u0003-\u0001\u0005\u000b\u0007I\u0011A-\t\u0011y\u0003!\u0011!Q\u0001\niC\u0001b\u0018\u0001\u0003\u0006\u0004%\t\u0001\u0019\u0005\tI\u0002\u0011\t\u0011)A\u0005C\"AQ\r\u0001B\u0001B\u0003%a\rC\u0003m\u0001\u0011\u0005Q\u000eC\u0003w\u0001\u0011\u0005q\u000f\u0003\u0005|\u0001!\u0015\r\u0011\"\u0001?\u0011\u001da\bA1A\u0005ByBa! \u0001!\u0002\u0013y\u0004\"\u0002@\u0001\t\u0003:\b\"B@\u0001\t\u0003:\bBBA\u0001\u0001\u0011\u0005s\u000f\u0003\u0004\u0002\u0004\u0001!\ta\u001e\u0005\u0007\u0003\u000b\u0001A\u0011A<\t\r\u0005\u001d\u0001\u0001\"\u0011x\u0011\u0019\tI\u0001\u0001C!o\"9\u00111\u0002\u0001\u0005B\u00055\u0001BBA\u0014\u0001\u0011\u0005\u0003\r\u0003\u0004\u0002*\u0001!\tEP\u0004\n\u0003\u001b\n\u0013\u0011!E\u0001\u0003\u001f2\u0001\u0002I\u0011\u0002\u0002#\u0005\u0011\u0011\u000b\u0005\u0007Yv!\t!!\u0017\t\u0013\u0005mS$%A\u0005\u0002\u0005u#\u0001F&vE\u0016\u0014h.\u001a;fg\u0012\u0013\u0018N^3s\u0007>tgM\u0003\u0002#G\u0005\u00191\u000eO:\u000b\u0005\u0011*\u0013A\u00023fa2|\u0017P\u0003\u0002'O\u0005)1\u000f]1sW*\u0011\u0001&K\u0001\u0007CB\f7\r[3\u000b\u0003)\n1a\u001c:h\u0007\u0001\u00192\u0001A\u00172!\tqs&D\u0001\"\u0013\t\u0001\u0014E\u0001\bLk\n,'O\\3uKN\u001cuN\u001c4\u0011\u0005I*T\"A\u001a\u000b\u0005Q*\u0013\u0001C5oi\u0016\u0014h.\u00197\n\u0005Y\u001a$a\u0002'pO\u001eLgnZ\u0001\ngB\f'o[\"p]\u001a\u0004\"!\u000f\u001e\u000e\u0003\u0015J!aO\u0013\u0003\u0013M\u0003\u0018M]6D_:4\u0017BA\u001c0\u0003\u0015\t\u0007\u000f]%e+\u0005y\u0004C\u0001!J\u001d\t\tu\t\u0005\u0002C\u000b6\t1I\u0003\u0002EW\u00051AH]8pizR\u0011AR\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0011\u0016\u000ba\u0001\u0015:fI\u00164\u0017B\u0001&L\u0005\u0019\u0019FO]5oO*\u0011\u0001*R\u0001\u0007CB\u0004\u0018\n\u001a\u0011\u0002\u001f5\f\u0017N\\!qaJ+7o\\;sG\u0016,\u0012a\u0014\t\u0003!Nk\u0011!\u0015\u0006\u0003%\u0006\naa];c[&$\u0018B\u0001+R\u0005=i\u0015-\u001b8BaB\u0014Vm]8ve\u000e,\u0017\u0001E7bS:\f\u0005\u000f\u001d*fg>,(oY3!\u0003%i\u0017-\u001b8DY\u0006\u001c8/\u0001\u0006nC&t7\t\\1tg\u0002\nq!\u00199q\u0003J<7/F\u0001[!\rYFlP\u0007\u0002\u000b&\u0011Q,\u0012\u0002\u0006\u0003J\u0014\u0018-_\u0001\tCB\u0004\u0018I]4tA\u0005I\u0001O]8ysV\u001bXM]\u000b\u0002CB\u00191LY \n\u0005\r,%AB(qi&|g.\u0001\u0006qe>D\u00180V:fe\u0002\nQa\u00197pG.\u0004\"a\u001a6\u000e\u0003!T!![\u0013\u0002\tU$\u0018\u000e\\\u0005\u0003W\"\u0014Qa\u00117pG.\fa\u0001P5oSRtD\u0003\u00038paF\u00148\u000f^;\u0011\u00059\u0002\u0001\"B\u001c\u000e\u0001\u0004A\u0004\"B\u001f\u000e\u0001\u0004y\u0004\"B'\u000e\u0001\u0004y\u0005\"\u0002,\u000e\u0001\u0004y\u0004\"\u0002-\u000e\u0001\u0004Q\u0006\"B0\u000e\u0001\u0004\t\u0007bB3\u000e!\u0003\u0005\rAZ\u0001\u0013IJLg/\u001a:O_\u0012,7+\u001a7fGR|'/F\u0001y!\u0011\u0001\u0015pP \n\u0005i\\%aA'ba\u0006\tBM]5wKJ\u001cVM\u001d<jG\u0016t\u0015-\\3\u0002%I,7o\\;sG\u0016t\u0015-\\3Qe\u00164\u0017\u000e_\u0001\u0014e\u0016\u001cx.\u001e:dK:\u000bW.\u001a)sK\u001aL\u0007\u0010I\u0001\u0007Y\u0006\u0014W\r\\:\u0002\u0017\u0015tg/\u001b:p]6,g\u000e^\u0001\fC:tw\u000e^1uS>t7/A\u0007tKJ4\u0018nY3MC\n,Gn]\u0001\u0013g\u0016\u0014h/[2f\u0003:tw\u000e^1uS>t7/A\ftK\u000e\u0014X\r\u001e(b[\u0016\u001cHk\\'pk:$\b+\u0019;ig\u000692/Z2sKR,eN\u001e(b[\u0016\u001cHk\\&fsJ+gm]\u0001\bm>dW/\\3t+\t\ty\u0001\u0005\u0004\u0002\u0012\u0005m\u0011\u0011\u0005\b\u0005\u0003'\t9BD\u0002C\u0003+I\u0011AR\u0005\u0004\u00033)\u0015a\u00029bG.\fw-Z\u0005\u0005\u0003;\tyBA\u0002TKFT1!!\u0007F!\rq\u00131E\u0005\u0004\u0003K\t#\u0001F&vE\u0016\u0014h.\u001a;fgZ{G.^7f'B,7-A\u0007tG\",G-\u001e7fe:\u000bW.Z\u0001\u0006S6\fw-\u001a\u0015\u0004\u0001\u00055\u0002\u0003BA\u0018\u0003ki!!!\r\u000b\u0007\u0005MR%\u0001\u0006b]:|G/\u0019;j_:LA!a\u000e\u00022\tAQK\\:uC\ndW\rK\u0002\u0001\u0003w\u0001B!a\f\u0002>%!\u0011qHA\u0019\u00051!UM^3m_B,'/\u00119jQ\u0015\u0001\u00111IA%!\u0011\ty#!\u0012\n\t\u0005\u001d\u0013\u0011\u0007\u0002\u0006'&t7-Z\u0011\u0003\u0003\u0017\nQ\u0001\u000e\u00181]A\nAcS;cKJtW\r^3t\tJLg/\u001a:D_:4\u0007C\u0001\u0018\u001e'\ri\u00121\u000b\t\u00047\u0006U\u0013bAA,\u000b\n1\u0011I\\=SK\u001a$\"!a\u0014\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00138+\t\tyFK\u0002g\u0003CZ#!a\u0019\u0011\t\u0005\u0015\u0014QN\u0007\u0003\u0003ORA!!\u001b\u0002l\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003g)\u0015\u0002BA8\u0003O\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0001")
public class KubernetesDriverConf
extends KubernetesConf
implements Logging {
    private String driverServiceName;
    private final String appId;
    private final MainAppResource mainAppResource;
    private final String mainClass;
    private final String[] appArgs;
    private final Option<String> proxyUser;
    private final Clock clock;
    private final String resourceNamePrefix;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    public static Clock $lessinit$greater$default$7() {
        return KubernetesDriverConf$.MODULE$.$lessinit$greater$default$7();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public String appId() {
        return this.appId;
    }

    public MainAppResource mainAppResource() {
        return this.mainAppResource;
    }

    public String mainClass() {
        return this.mainClass;
    }

    public String[] appArgs() {
        return this.appArgs;
    }

    public Option<String> proxyUser() {
        return this.proxyUser;
    }

    public scala.collection.immutable.Map<String, String> driverNodeSelector() {
        return KubernetesUtils$.MODULE$.parsePrefixedKeyValuePairs(super.sparkConf(), Config$.MODULE$.KUBERNETES_DRIVER_NODE_SELECTOR_PREFIX());
    }

    private String driverServiceName$lzycompute() {
        KubernetesDriverConf kubernetesDriverConf = this;
        synchronized (kubernetesDriverConf) {
            if (!this.bitmap$0) {
                String string;
                String preferredServiceName = this.resourceNamePrefix() + DriverServiceFeatureStep$.MODULE$.DRIVER_SVC_POSTFIX();
                if (preferredServiceName.length() <= DriverServiceFeatureStep$.MODULE$.MAX_SERVICE_NAME_LENGTH()) {
                    string = preferredServiceName;
                } else {
                    String randomServiceId = KubernetesUtils$.MODULE$.uniqueID(this.clock);
                    String shorterServiceName = "spark-" + randomServiceId + DriverServiceFeatureStep$.MODULE$.DRIVER_SVC_POSTFIX();
                    this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Driver's hostname would preferably be "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ", but this is too long "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.PREFERRED_SERVICE_NAME, preferredServiceName)}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"(must be <= ", " "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.MAX_SERVICE_NAME_LENGTH, BoxesRunTime.boxToInteger((int)DriverServiceFeatureStep$.MODULE$.MAX_SERVICE_NAME_LENGTH()))}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"characters). Falling back to use "}))).log((Seq)Nil$.MODULE$)).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " as the driver service's name."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.SHORTER_SERVICE_NAME, shorterServiceName)})))));
                    string = shorterServiceName;
                }
                this.driverServiceName = string;
                this.bitmap$0 = true;
            }
        }
        return this.driverServiceName;
    }

    public String driverServiceName() {
        if (!this.bitmap$0) {
            return this.driverServiceName$lzycompute();
        }
        return this.driverServiceName;
    }

    @Override
    public String resourceNamePrefix() {
        return this.resourceNamePrefix;
    }

    @Override
    public scala.collection.immutable.Map<String, String> labels() {
        scala.collection.immutable.Map presetLabels = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_VERSION_LABEL()), (Object)package$.MODULE$.SPARK_VERSION()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_APP_ID_LABEL()), (Object)this.appId()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_APP_NAME_LABEL()), (Object)KubernetesConf$.MODULE$.getAppNameLabel(this.appName())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Constants$.MODULE$.SPARK_ROLE_LABEL()), (Object)Constants$.MODULE$.SPARK_POD_DRIVER_ROLE())}));
        scala.collection.immutable.Map driverCustomLabels = (scala.collection.immutable.Map)KubernetesUtils$.MODULE$.parsePrefixedKeyValuePairs(super.sparkConf(), Config$.MODULE$.KUBERNETES_DRIVER_LABEL_PREFIX()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return new Tuple2((Object)k, (Object)Utils$.MODULE$.substituteAppNExecIds(v, this.appId(), ""));
            }
            throw new MatchError((Object)tuple2);
        });
        presetLabels.keys().foreach((Function1 & Serializable)key -> {
            Predef$.MODULE$.require(!driverCustomLabels.contains((Object)key), (Function0 & Serializable)() -> "Label with key " + key + " is not allowed as it is reserved for Spark bookkeeping operations.");
            return BoxedUnit.UNIT;
        });
        return (scala.collection.immutable.Map)driverCustomLabels.$plus$plus((IterableOnce)presetLabels);
    }

    @Override
    public scala.collection.immutable.Map<String, String> environment() {
        return KubernetesUtils$.MODULE$.parsePrefixedKeyValuePairs(super.sparkConf(), Config$.MODULE$.KUBERNETES_DRIVER_ENV_PREFIX());
    }

    @Override
    public scala.collection.immutable.Map<String, String> annotations() {
        return (scala.collection.immutable.Map)KubernetesUtils$.MODULE$.parsePrefixedKeyValuePairs(super.sparkConf(), Config$.MODULE$.KUBERNETES_DRIVER_ANNOTATION_PREFIX()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                return new Tuple2((Object)k, (Object)Utils$.MODULE$.substituteAppNExecIds(v, this.appId(), ""));
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public scala.collection.immutable.Map<String, String> serviceLabels() {
        return KubernetesUtils$.MODULE$.parsePrefixedKeyValuePairs(super.sparkConf(), Config$.MODULE$.KUBERNETES_DRIVER_SERVICE_LABEL_PREFIX());
    }

    public scala.collection.immutable.Map<String, String> serviceAnnotations() {
        return KubernetesUtils$.MODULE$.parsePrefixedKeyValuePairs(super.sparkConf(), Config$.MODULE$.KUBERNETES_DRIVER_SERVICE_ANNOTATION_PREFIX());
    }

    @Override
    public scala.collection.immutable.Map<String, String> secretNamesToMountPaths() {
        return KubernetesUtils$.MODULE$.parsePrefixedKeyValuePairs(super.sparkConf(), Config$.MODULE$.KUBERNETES_DRIVER_SECRETS_PREFIX());
    }

    @Override
    public scala.collection.immutable.Map<String, String> secretEnvNamesToKeyRefs() {
        return KubernetesUtils$.MODULE$.parsePrefixedKeyValuePairs(super.sparkConf(), Config$.MODULE$.KUBERNETES_DRIVER_SECRET_KEY_REF_PREFIX());
    }

    @Override
    public Seq<KubernetesVolumeSpec> volumes() {
        return KubernetesVolumeUtils$.MODULE$.parseVolumesWithPrefix(super.sparkConf(), Config$.MODULE$.KUBERNETES_DRIVER_VOLUMES_PREFIX());
    }

    @Override
    public Option<String> schedulerName() {
        return Option$.MODULE$.apply(((Option)this.get(Config$.MODULE$.KUBERNETES_DRIVER_SCHEDULER_NAME())).getOrElse((Function0 & Serializable)() -> (String)((Option)this.get(Config$.MODULE$.KUBERNETES_SCHEDULER_NAME())).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())));
    }

    @Override
    public String image() {
        return (String)this.get(Config$.MODULE$.DRIVER_CONTAINER_IMAGE()).map((Function1 & Serializable)opt -> Utils$.MODULE$.substituteSparkVersion(opt)).getOrElse((Function0 & Serializable)() -> {
            throw new SparkException("Must specify the driver container image");
        });
    }

    public KubernetesDriverConf(SparkConf sparkConf, String appId, MainAppResource mainAppResource, String mainClass, String[] appArgs, Option<String> proxyUser, Clock clock) {
        this.appId = appId;
        this.mainAppResource = mainAppResource;
        this.mainClass = mainClass;
        this.appArgs = appArgs;
        this.proxyUser = proxyUser;
        this.clock = clock;
        super(sparkConf);
        Logging.$init$((Logging)this);
        None$ custom = Utils$.MODULE$.isTesting() ? (Option)this.get(Config$.MODULE$.KUBERNETES_DRIVER_POD_NAME_PREFIX()) : None$.MODULE$;
        this.resourceNamePrefix = (String)custom.getOrElse((Function0 & Serializable)() -> KubernetesConf$.MODULE$.getResourceNamePrefix(this.appName()));
    }
}

