/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.resource.v1alpha2;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.resource.v1alpha2.DriverRequests;
import io.fabric8.kubernetes.api.model.resource.v1alpha2.DriverRequestsBuilder;
import io.fabric8.kubernetes.api.model.resource.v1alpha2.DriverRequestsFluent;
import io.fabric8.kubernetes.api.model.resource.v1alpha2.ResourceClaimParameters;
import io.fabric8.kubernetes.api.model.resource.v1alpha2.ResourceClaimParametersReference;
import io.fabric8.kubernetes.api.model.resource.v1alpha2.ResourceClaimParametersReferenceBuilder;
import io.fabric8.kubernetes.api.model.resource.v1alpha2.ResourceClaimParametersReferenceFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ResourceClaimParametersFluent<A extends ResourceClaimParametersFluent<A>>
extends BaseFluent<A> {
    private String apiVersion;
    private ArrayList<DriverRequestsBuilder> driverRequests = new ArrayList();
    private ResourceClaimParametersReferenceBuilder generatedFrom;
    private String kind;
    private ObjectMetaBuilder metadata;
    private Boolean shareable;
    private Map<String, Object> additionalProperties;

    public ResourceClaimParametersFluent() {
    }

    public ResourceClaimParametersFluent(ResourceClaimParameters instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ResourceClaimParameters instance) {
        ResourceClaimParameters resourceClaimParameters = instance = instance != null ? instance : new ResourceClaimParameters();
        if (instance != null) {
            this.withApiVersion(instance.getApiVersion());
            this.withDriverRequests(instance.getDriverRequests());
            this.withGeneratedFrom(instance.getGeneratedFrom());
            this.withKind(instance.getKind());
            this.withMetadata(instance.getMetadata());
            this.withShareable(instance.getShareable());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)((Object)this);
    }

    public boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A addToDriverRequests(int index, DriverRequests item) {
        if (this.driverRequests == null) {
            this.driverRequests = new ArrayList();
        }
        DriverRequestsBuilder builder = new DriverRequestsBuilder(item);
        if (index < 0 || index >= this.driverRequests.size()) {
            this._visitables.get((Object)"driverRequests").add(builder);
            this.driverRequests.add(builder);
        } else {
            this._visitables.get((Object)"driverRequests").add(builder);
            this.driverRequests.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToDriverRequests(int index, DriverRequests item) {
        if (this.driverRequests == null) {
            this.driverRequests = new ArrayList();
        }
        DriverRequestsBuilder builder = new DriverRequestsBuilder(item);
        if (index < 0 || index >= this.driverRequests.size()) {
            this._visitables.get((Object)"driverRequests").add(builder);
            this.driverRequests.add(builder);
        } else {
            this._visitables.get((Object)"driverRequests").add(builder);
            this.driverRequests.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToDriverRequests(DriverRequests ... items) {
        if (this.driverRequests == null) {
            this.driverRequests = new ArrayList();
        }
        for (DriverRequests item : items) {
            DriverRequestsBuilder builder = new DriverRequestsBuilder(item);
            this._visitables.get((Object)"driverRequests").add(builder);
            this.driverRequests.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToDriverRequests(Collection<DriverRequests> items) {
        if (this.driverRequests == null) {
            this.driverRequests = new ArrayList();
        }
        for (DriverRequests item : items) {
            DriverRequestsBuilder builder = new DriverRequestsBuilder(item);
            this._visitables.get((Object)"driverRequests").add(builder);
            this.driverRequests.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromDriverRequests(DriverRequests ... items) {
        if (this.driverRequests == null) {
            return (A)((Object)this);
        }
        for (DriverRequests item : items) {
            DriverRequestsBuilder builder = new DriverRequestsBuilder(item);
            this._visitables.get((Object)"driverRequests").remove((Object)builder);
            this.driverRequests.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromDriverRequests(Collection<DriverRequests> items) {
        if (this.driverRequests == null) {
            return (A)((Object)this);
        }
        for (DriverRequests item : items) {
            DriverRequestsBuilder builder = new DriverRequestsBuilder(item);
            this._visitables.get((Object)"driverRequests").remove((Object)builder);
            this.driverRequests.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromDriverRequests(Predicate<DriverRequestsBuilder> predicate) {
        if (this.driverRequests == null) {
            return (A)((Object)this);
        }
        Iterator<DriverRequestsBuilder> each = this.driverRequests.iterator();
        List visitables = this._visitables.get((Object)"driverRequests");
        while (each.hasNext()) {
            DriverRequestsBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<DriverRequests> buildDriverRequests() {
        return this.driverRequests != null ? ResourceClaimParametersFluent.build(this.driverRequests) : null;
    }

    public DriverRequests buildDriverRequest(int index) {
        return this.driverRequests.get(index).build();
    }

    public DriverRequests buildFirstDriverRequest() {
        return this.driverRequests.get(0).build();
    }

    public DriverRequests buildLastDriverRequest() {
        return this.driverRequests.get(this.driverRequests.size() - 1).build();
    }

    public DriverRequests buildMatchingDriverRequest(Predicate<DriverRequestsBuilder> predicate) {
        for (DriverRequestsBuilder item : this.driverRequests) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingDriverRequest(Predicate<DriverRequestsBuilder> predicate) {
        for (DriverRequestsBuilder item : this.driverRequests) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withDriverRequests(List<DriverRequests> driverRequests) {
        if (this.driverRequests != null) {
            this._visitables.get((Object)"driverRequests").clear();
        }
        if (driverRequests != null) {
            this.driverRequests = new ArrayList();
            for (DriverRequests item : driverRequests) {
                this.addToDriverRequests(item);
            }
        } else {
            this.driverRequests = null;
        }
        return (A)((Object)this);
    }

    public A withDriverRequests(DriverRequests ... driverRequests) {
        if (this.driverRequests != null) {
            this.driverRequests.clear();
            this._visitables.remove((Object)"driverRequests");
        }
        if (driverRequests != null) {
            for (DriverRequests item : driverRequests) {
                this.addToDriverRequests(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasDriverRequests() {
        return this.driverRequests != null && !this.driverRequests.isEmpty();
    }

    public DriverRequestsNested<A> addNewDriverRequest() {
        return new DriverRequestsNested(-1, null);
    }

    public DriverRequestsNested<A> addNewDriverRequestLike(DriverRequests item) {
        return new DriverRequestsNested(-1, item);
    }

    public DriverRequestsNested<A> setNewDriverRequestLike(int index, DriverRequests item) {
        return new DriverRequestsNested(index, item);
    }

    public DriverRequestsNested<A> editDriverRequest(int index) {
        if (this.driverRequests.size() <= index) {
            throw new RuntimeException("Can't edit driverRequests. Index exceeds size.");
        }
        return this.setNewDriverRequestLike(index, this.buildDriverRequest(index));
    }

    public DriverRequestsNested<A> editFirstDriverRequest() {
        if (this.driverRequests.size() == 0) {
            throw new RuntimeException("Can't edit first driverRequests. The list is empty.");
        }
        return this.setNewDriverRequestLike(0, this.buildDriverRequest(0));
    }

    public DriverRequestsNested<A> editLastDriverRequest() {
        int index = this.driverRequests.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last driverRequests. The list is empty.");
        }
        return this.setNewDriverRequestLike(index, this.buildDriverRequest(index));
    }

    public DriverRequestsNested<A> editMatchingDriverRequest(Predicate<DriverRequestsBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.driverRequests.size(); ++i) {
            if (!predicate.test(this.driverRequests.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching driverRequests. No match found.");
        }
        return this.setNewDriverRequestLike(index, this.buildDriverRequest(index));
    }

    public ResourceClaimParametersReference buildGeneratedFrom() {
        return this.generatedFrom != null ? this.generatedFrom.build() : null;
    }

    public A withGeneratedFrom(ResourceClaimParametersReference generatedFrom) {
        this._visitables.remove((Object)"generatedFrom");
        if (generatedFrom != null) {
            this.generatedFrom = new ResourceClaimParametersReferenceBuilder(generatedFrom);
            this._visitables.get((Object)"generatedFrom").add(this.generatedFrom);
        } else {
            this.generatedFrom = null;
            this._visitables.get((Object)"generatedFrom").remove((Object)this.generatedFrom);
        }
        return (A)((Object)this);
    }

    public boolean hasGeneratedFrom() {
        return this.generatedFrom != null;
    }

    public A withNewGeneratedFrom(String apiGroup, String kind, String name) {
        return this.withGeneratedFrom(new ResourceClaimParametersReference(apiGroup, kind, name));
    }

    public GeneratedFromNested<A> withNewGeneratedFrom() {
        return new GeneratedFromNested(null);
    }

    public GeneratedFromNested<A> withNewGeneratedFromLike(ResourceClaimParametersReference item) {
        return new GeneratedFromNested(item);
    }

    public GeneratedFromNested<A> editGeneratedFrom() {
        return this.withNewGeneratedFromLike(Optional.ofNullable(this.buildGeneratedFrom()).orElse(null));
    }

    public GeneratedFromNested<A> editOrNewGeneratedFrom() {
        return this.withNewGeneratedFromLike(Optional.ofNullable(this.buildGeneratedFrom()).orElse(new ResourceClaimParametersReferenceBuilder().build()));
    }

    public GeneratedFromNested<A> editOrNewGeneratedFromLike(ResourceClaimParametersReference item) {
        return this.withNewGeneratedFromLike(Optional.ofNullable(this.buildGeneratedFrom()).orElse(item));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind = kind;
        return (A)((Object)this);
    }

    public boolean hasKind() {
        return this.kind != null;
    }

    public ObjectMeta buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(ObjectMeta metadata) {
        this._visitables.remove((Object)"metadata");
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.get((Object)"metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get((Object)"metadata").remove(this.metadata);
        }
        return (A)((Object)this);
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new ObjectMetaBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public Boolean getShareable() {
        return this.shareable;
    }

    public A withShareable(Boolean shareable) {
        this.shareable = shareable;
        return (A)((Object)this);
    }

    public boolean hasShareable() {
        return this.shareable != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceClaimParametersFluent that = (ResourceClaimParametersFluent)((Object)o);
        if (!Objects.equals(this.apiVersion, that.apiVersion)) {
            return false;
        }
        if (!Objects.equals(this.driverRequests, that.driverRequests)) {
            return false;
        }
        if (!Objects.equals((Object)this.generatedFrom, (Object)that.generatedFrom)) {
            return false;
        }
        if (!Objects.equals(this.kind, that.kind)) {
            return false;
        }
        if (!Objects.equals(this.metadata, that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.shareable, that.shareable)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.apiVersion, this.driverRequests, this.generatedFrom, this.kind, this.metadata, this.shareable, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.driverRequests != null && !this.driverRequests.isEmpty()) {
            sb.append("driverRequests:");
            sb.append(String.valueOf(this.driverRequests) + ",");
        }
        if (this.generatedFrom != null) {
            sb.append("generatedFrom:");
            sb.append(String.valueOf((Object)this.generatedFrom) + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(String.valueOf(this.metadata) + ",");
        }
        if (this.shareable != null) {
            sb.append("shareable:");
            sb.append(this.shareable + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withShareable() {
        return this.withShareable(true);
    }

    public class MetadataNested<N>
    extends ObjectMetaFluent<MetadataNested<N>>
    implements Nested<N> {
        ObjectMetaBuilder builder;

        MetadataNested(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder((ObjectMetaFluent)this, item);
        }

        public N and() {
            return (N)ResourceClaimParametersFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }

    public class GeneratedFromNested<N>
    extends ResourceClaimParametersReferenceFluent<GeneratedFromNested<N>>
    implements Nested<N> {
        ResourceClaimParametersReferenceBuilder builder;

        GeneratedFromNested(ResourceClaimParametersReference item) {
            this.builder = new ResourceClaimParametersReferenceBuilder(this, item);
        }

        public N and() {
            return (N)ResourceClaimParametersFluent.this.withGeneratedFrom(this.builder.build());
        }

        public N endGeneratedFrom() {
            return this.and();
        }
    }

    public class DriverRequestsNested<N>
    extends DriverRequestsFluent<DriverRequestsNested<N>>
    implements Nested<N> {
        DriverRequestsBuilder builder;
        int index;

        DriverRequestsNested(int index, DriverRequests item) {
            this.index = index;
            this.builder = new DriverRequestsBuilder(this, item);
        }

        public N and() {
            return (N)ResourceClaimParametersFluent.this.setToDriverRequests(this.index, this.builder.build());
        }

        public N endDriverRequest() {
            return this.and();
        }
    }
}

