/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jpmml.model;

import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import org.sparkproject.dmg.pmml.PMMLObject;
import org.sparkproject.jpmml.model.Serializer;

public class JavaSerializer
implements Serializer {
    private ClassLoader clazzLoader = null;

    public JavaSerializer() {
        this(null);
    }

    public JavaSerializer(ClassLoader clazzLoader) {
        this.setClassLoader(clazzLoader);
    }

    @Override
    public PMMLObject deserialize(InputStream is) throws ClassNotFoundException, IOException {
        final ClassLoader clazzLoader = this.getClassLoader();
        FilterInputStream safeIs = new FilterInputStream(is){

            @Override
            public void close() {
            }
        };
        try (ObjectInputStream objectIs = new ObjectInputStream(safeIs){

            @Override
            public Class<?> resolveClass(ObjectStreamClass objectStreamClass) throws ClassNotFoundException, IOException {
                Class<?> clazz;
                if (clazzLoader != null && (clazz = Class.forName(objectStreamClass.getName(), false, clazzLoader)) != null) {
                    return clazz;
                }
                return super.resolveClass(objectStreamClass);
            }
        };){
            PMMLObject pMMLObject = (PMMLObject)objectIs.readObject();
            return pMMLObject;
        }
    }

    @Override
    public void serialize(PMMLObject object, OutputStream os) throws IOException {
        FilterOutputStream safeOs = new FilterOutputStream(os){

            @Override
            public void close() throws IOException {
                super.flush();
            }
        };
        try (ObjectOutputStream objectOs = new ObjectOutputStream(safeOs);){
            objectOs.writeObject(object);
            objectOs.flush();
        }
    }

    protected ClassLoader getClassLoader() {
        return this.clazzLoader;
    }

    private void setClassLoader(ClassLoader clazzLoader) {
        this.clazzLoader = clazzLoader;
    }
}

