/*
 * Decompiled with CFR 0.152.
 */
package dev.ludovic.netlib.arpack;

import dev.ludovic.netlib.arpack.ARPACK;
import dev.ludovic.netlib.arpack.F2jARPACK;
import dev.ludovic.netlib.arpack.JNIARPACK;
import dev.ludovic.netlib.arpack.JavaARPACK;
import dev.ludovic.netlib.arpack.NativeARPACK;
import java.util.logging.Logger;

final class InstanceBuilder {
    private static final Logger log = Logger.getLogger(InstanceBuilder.class.getName());
    private static final ARPACK arpack;
    private static final NativeARPACK nativeArpack;
    private static final JavaARPACK javaArpack;

    InstanceBuilder() {
    }

    public static ARPACK arpack() {
        return arpack;
    }

    private static NativeARPACK initializeNative() {
        try {
            return JNIARPACK.getInstance();
        }
        catch (Throwable t) {
            log.warning("Failed to load implementation from:" + JNIARPACK.class.getName());
            return null;
        }
    }

    public static NativeARPACK nativeArpack() {
        if (nativeArpack == null) {
            throw new RuntimeException("Unable to load native implementation");
        }
        return nativeArpack;
    }

    private static JavaARPACK initializeJava() {
        return F2jARPACK.getInstance();
    }

    public static JavaARPACK javaArpack() {
        return javaArpack;
    }

    static {
        nativeArpack = InstanceBuilder.initializeNative();
        javaArpack = InstanceBuilder.initializeJava();
        arpack = nativeArpack != null ? nativeArpack : javaArpack;
    }
}

