/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle.protocol;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import org.apache.spark.network.protocol.Encoders;
import org.apache.spark.network.shuffle.protocol.AbstractFetchShuffleBlocks;
import org.apache.spark.network.shuffle.protocol.BlockTransferMessage;

public class FetchShuffleBlocks
extends AbstractFetchShuffleBlocks {
    public final long[] mapIds;
    public final int[][] reduceIds;
    public final boolean batchFetchEnabled;

    public FetchShuffleBlocks(String appId, String execId, int shuffleId, long[] mapIds, int[][] reduceIds, boolean batchFetchEnabled) {
        super(appId, execId, shuffleId);
        this.mapIds = mapIds;
        this.reduceIds = reduceIds;
        assert (mapIds.length == reduceIds.length);
        this.batchFetchEnabled = batchFetchEnabled;
        if (batchFetchEnabled) {
            for (int[] ids : reduceIds) {
                assert (ids.length == 2);
            }
        }
    }

    @Override
    protected BlockTransferMessage.Type type() {
        return BlockTransferMessage.Type.FETCH_SHUFFLE_BLOCKS;
    }

    public String toString() {
        return "FetchShuffleBlocks[appId=" + this.appId + ",execId=" + this.execId + ",shuffleId=" + this.shuffleId + ",mapIds=" + Arrays.toString(this.mapIds) + ",reduceIds=" + Arrays.deepToString((Object[])this.reduceIds) + ",batchFetchEnabled=" + this.batchFetchEnabled + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FetchShuffleBlocks that = (FetchShuffleBlocks)o;
        if (!super.equals(that)) {
            return false;
        }
        if (this.batchFetchEnabled != that.batchFetchEnabled) {
            return false;
        }
        if (!Arrays.equals(this.mapIds, that.mapIds)) {
            return false;
        }
        return Arrays.deepEquals((Object[])this.reduceIds, (Object[])that.reduceIds);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Arrays.hashCode(this.mapIds);
        result = 31 * result + Arrays.deepHashCode((Object[])this.reduceIds);
        result = 31 * result + (this.batchFetchEnabled ? 1 : 0);
        return result;
    }

    @Override
    public int getNumBlocks() {
        if (this.batchFetchEnabled) {
            return this.mapIds.length;
        }
        int numBlocks = 0;
        for (int[] ids : this.reduceIds) {
            numBlocks += ids.length;
        }
        return numBlocks;
    }

    @Override
    public int encodedLength() {
        int encodedLengthOfReduceIds = 0;
        for (int[] ids : this.reduceIds) {
            encodedLengthOfReduceIds += Encoders.IntArrays.encodedLength((int[])ids);
        }
        return super.encodedLength() + Encoders.LongArrays.encodedLength((long[])this.mapIds) + 4 + encodedLengthOfReduceIds + 1;
    }

    @Override
    public void encode(ByteBuf buf) {
        super.encode(buf);
        Encoders.LongArrays.encode((ByteBuf)buf, (long[])this.mapIds);
        buf.writeInt(this.reduceIds.length);
        for (int[] ids : this.reduceIds) {
            Encoders.IntArrays.encode((ByteBuf)buf, (int[])ids);
        }
        buf.writeBoolean(this.batchFetchEnabled);
    }

    public static FetchShuffleBlocks decode(ByteBuf buf) {
        String appId = Encoders.Strings.decode((ByteBuf)buf);
        String execId = Encoders.Strings.decode((ByteBuf)buf);
        int shuffleId = buf.readInt();
        long[] mapIds = Encoders.LongArrays.decode((ByteBuf)buf);
        int reduceIdsSize = buf.readInt();
        int[][] reduceIds = new int[reduceIdsSize][];
        for (int i = 0; i < reduceIdsSize; ++i) {
            reduceIds[i] = Encoders.IntArrays.decode((ByteBuf)buf);
        }
        boolean batchFetchEnabled = buf.readBoolean();
        return new FetchShuffleBlocks(appId, execId, shuffleId, mapIds, reduceIds, batchFetchEnabled);
    }
}

