/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.impl;

import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.orc.impl.InStream;
import org.apache.orc.impl.IntegerReader;
import org.apache.orc.impl.PositionProvider;
import org.apache.orc.impl.RunLengthIntegerWriterV2;
import org.apache.orc.impl.SerializationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunLengthIntegerReaderV2
implements IntegerReader {
    public static final Logger LOG = LoggerFactory.getLogger(RunLengthIntegerReaderV2.class);
    private InStream input;
    private final boolean signed;
    private final long[] literals = new long[512];
    private int numLiterals = 0;
    private int used = 0;
    private final boolean skipCorrupt;
    private final SerializationUtils utils;
    private RunLengthIntegerWriterV2.EncodingType currentEncoding;
    private static final RunLengthIntegerWriterV2.EncodingType[] encodings = RunLengthIntegerWriterV2.EncodingType.values();

    public RunLengthIntegerReaderV2(InStream input, boolean signed, boolean skipCorrupt) throws IOException {
        this.input = input;
        this.signed = signed;
        this.skipCorrupt = skipCorrupt;
        this.utils = new SerializationUtils();
    }

    private void readValues(boolean ignoreEof) throws IOException {
        int firstByte = this.input.read();
        if (firstByte < 0) {
            if (!ignoreEof) {
                throw new EOFException("Read past end of RLE integer from " + String.valueOf(this.input));
            }
            this.numLiterals = 0;
            this.used = 0;
            return;
        }
        this.currentEncoding = encodings[firstByte >>> 6 & 3];
        switch (this.currentEncoding) {
            case SHORT_REPEAT: {
                this.readShortRepeatValues(firstByte);
                break;
            }
            case DIRECT: {
                this.readDirectValues(firstByte);
                break;
            }
            case PATCHED_BASE: {
                this.readPatchedBaseValues(firstByte);
                break;
            }
            case DELTA: {
                this.readDeltaValues(firstByte);
                break;
            }
            default: {
                throw new IOException("Unknown encoding " + String.valueOf((Object)this.currentEncoding));
            }
        }
    }

    private void readDeltaValues(int firstByte) throws IOException {
        int fb = firstByte >>> 1 & 0x1F;
        if (fb != 0) {
            fb = SerializationUtils.decodeBitWidth(fb);
        }
        int len = (firstByte & 1) << 8;
        len |= this.input.read();
        long firstVal = 0L;
        firstVal = this.signed ? SerializationUtils.readVslong(this.input) : SerializationUtils.readVulong(this.input);
        long prevVal = firstVal;
        this.literals[this.numLiterals++] = firstVal;
        if (fb == 0) {
            long fd = SerializationUtils.readVslong(this.input);
            if (fd == 0L) {
                assert (this.numLiterals == 1);
                Arrays.fill(this.literals, this.numLiterals, this.numLiterals + len, this.literals[0]);
                this.numLiterals += len;
            } else {
                for (int i = 0; i < len; ++i) {
                    this.literals[this.numLiterals++] = this.literals[this.numLiterals - 2] + fd;
                }
            }
        } else {
            long deltaBase = SerializationUtils.readVslong(this.input);
            this.literals[this.numLiterals++] = firstVal + deltaBase;
            prevVal = this.literals[this.numLiterals - 1];
            this.utils.readInts(this.literals, this.numLiterals, --len, fb, this.input);
            while (len > 0) {
                this.literals[this.numLiterals] = deltaBase < 0L ? prevVal - this.literals[this.numLiterals] : prevVal + this.literals[this.numLiterals];
                prevVal = this.literals[this.numLiterals];
                --len;
                ++this.numLiterals;
            }
        }
    }

    private void readPatchedBaseValues(int firstByte) throws IOException {
        long mask;
        int fbo = firstByte >>> 1 & 0x1F;
        int fb = SerializationUtils.decodeBitWidth(fbo);
        int len = (firstByte & 1) << 8;
        len |= this.input.read();
        ++len;
        int thirdByte = this.input.read();
        int bw = thirdByte >>> 5 & 7;
        ++bw;
        int pwo = thirdByte & 0x1F;
        int pw = SerializationUtils.decodeBitWidth(pwo);
        int fourthByte = this.input.read();
        int pgw = fourthByte >>> 5 & 7;
        ++pgw;
        int pl = fourthByte & 0x1F;
        long base = this.utils.bytesToLongBE(this.input, bw);
        if ((base & (mask = 1L << bw * 8 - 1)) != 0L) {
            base &= mask ^ 0xFFFFFFFFFFFFFFFFL;
            base = -base;
        }
        long[] unpacked = new long[len];
        this.utils.readInts(unpacked, 0, len, fb, this.input);
        long[] unpackedPatch = new long[pl];
        if (pw + pgw > 64 && !this.skipCorrupt) {
            throw new IOException("Corruption in ORC data encountered. To skip reading corrupted data, set hive.exec.orc.skip.corrupt.data to true");
        }
        int bitSize = this.utils.getClosestFixedBits(pw + pgw);
        this.utils.readInts(unpackedPatch, 0, pl, bitSize, this.input);
        int patchIdx = 0;
        long currGap = 0L;
        long currPatch = 0L;
        long patchMask = (1L << pw) - 1L;
        currGap = unpackedPatch[patchIdx] >>> pw;
        currPatch = unpackedPatch[patchIdx] & patchMask;
        long actualGap = 0L;
        while (currGap == 255L && currPatch == 0L) {
            actualGap += 255L;
            currGap = unpackedPatch[++patchIdx] >>> pw;
            currPatch = unpackedPatch[patchIdx] & patchMask;
        }
        actualGap += currGap;
        for (int i = 0; i < unpacked.length; ++i) {
            if ((long)i == actualGap) {
                long patchedVal = unpacked[i] | currPatch << fb;
                this.literals[this.numLiterals++] = base + patchedVal;
                if (++patchIdx >= pl) continue;
                currGap = unpackedPatch[patchIdx] >>> pw;
                currPatch = unpackedPatch[patchIdx] & patchMask;
                actualGap = 0L;
                while (currGap == 255L && currPatch == 0L) {
                    actualGap += 255L;
                    currGap = unpackedPatch[++patchIdx] >>> pw;
                    currPatch = unpackedPatch[patchIdx] & patchMask;
                }
                actualGap += currGap;
                actualGap += (long)i;
                continue;
            }
            this.literals[this.numLiterals++] = base + unpacked[i];
        }
    }

    private void readDirectValues(int firstByte) throws IOException {
        int fbo = firstByte >>> 1 & 0x1F;
        int fb = SerializationUtils.decodeBitWidth(fbo);
        int len = (firstByte & 1) << 8;
        len |= this.input.read();
        this.utils.readInts(this.literals, this.numLiterals, ++len, fb, this.input);
        if (this.signed) {
            for (int i = 0; i < len; ++i) {
                this.literals[this.numLiterals] = this.utils.zigzagDecode(this.literals[this.numLiterals]);
                ++this.numLiterals;
            }
        } else {
            this.numLiterals += len;
        }
    }

    private void readShortRepeatValues(int firstByte) throws IOException {
        int size = firstByte >>> 3 & 7;
        int len = firstByte & 7;
        len += 3;
        long val = this.utils.bytesToLongBE(this.input, ++size);
        if (this.signed) {
            val = this.utils.zigzagDecode(val);
        }
        if (this.numLiterals != 0) {
            throw new AssertionError((Object)"readValues called with existing values present");
        }
        for (int i = 0; i < len; ++i) {
            this.literals[i] = val;
        }
        this.numLiterals = len;
    }

    @Override
    public boolean hasNext() throws IOException {
        return this.used != this.numLiterals || this.input.available() > 0;
    }

    @Override
    public long next() throws IOException {
        if (this.used == this.numLiterals) {
            this.numLiterals = 0;
            this.used = 0;
            this.readValues(false);
        }
        long result = this.literals[this.used++];
        return result;
    }

    @Override
    public void seek(PositionProvider index) throws IOException {
        int consumed;
        this.input.seek(index);
        if (consumed != 0) {
            for (consumed = (int)index.getNext(); consumed > 0; consumed -= this.numLiterals) {
                this.numLiterals = 0;
                this.readValues(false);
                this.used = consumed;
            }
        } else {
            this.used = 0;
            this.numLiterals = 0;
        }
    }

    @Override
    public void skip(long numValues) throws IOException {
        while (numValues > 0L) {
            if (this.used == this.numLiterals) {
                this.numLiterals = 0;
                this.used = 0;
                this.readValues(false);
            }
            long consume = Math.min(numValues, (long)(this.numLiterals - this.used));
            this.used = (int)((long)this.used + consume);
            numValues -= consume;
        }
    }

    @Override
    public void nextVector(ColumnVector previous, long[] data, int previousLen) throws IOException {
        if (previous.isRepeating && !previous.noNulls && previous.isNull[0]) {
            return;
        }
        previous.isRepeating = true;
        for (int i = 0; i < previousLen; ++i) {
            data[i] = previous.noNulls || !previous.isNull[i] ? this.next() : 1L;
            if (!previous.isRepeating || i <= 0 || data[0] == data[i] && previous.isNull[0] == previous.isNull[i]) continue;
            previous.isRepeating = false;
        }
    }

    @Override
    public void nextVector(ColumnVector vector, int[] data, int size) throws IOException {
        block3: {
            int batchSize;
            block2: {
                batchSize = Math.min(data.length, size);
                if (!vector.noNulls) break block2;
                for (int r = 0; r < batchSize; ++r) {
                    data[r] = (int)this.next();
                }
                break block3;
            }
            if (vector.isRepeating && vector.isNull[0]) break block3;
            for (int r = 0; r < batchSize; ++r) {
                data[r] = vector.isNull[r] ? 1 : (int)this.next();
            }
        }
    }
}

