/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.errors;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.errors.ErrorAndSolution;
import org.apache.hadoop.hive.ql.exec.errors.RegexErrorHeuristic;
import org.apache.hadoop.mapred.JobConf;

public class MapAggrMemErrorHeuristic
extends RegexErrorHeuristic {
    private static final String OUT_OF_MEMORY_REGEX = "OutOfMemoryError";
    private boolean configMatches = false;

    public MapAggrMemErrorHeuristic() {
        this.setQueryRegex("group by");
        this.getLogRegexes().add(OUT_OF_MEMORY_REGEX);
    }

    @Override
    public void init(String query, JobConf conf) {
        super.init(query, conf);
        this.configMatches = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEMAPSIDEAGGREGATE);
    }

    @Override
    public ErrorAndSolution getErrorAndSolution() {
        List<String> matchingLines;
        ErrorAndSolution es = null;
        if (this.getQueryMatches() && this.configMatches && (matchingLines = this.getRegexToLogLines().get(OUT_OF_MEMORY_REGEX)).size() > 0) {
            String confName = HiveConf.ConfVars.HIVEMAPAGGRHASHMEMORY.toString();
            float confValue = HiveConf.getFloatVar((Configuration)this.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVEMAPAGGRHASHMEMORY);
            es = new ErrorAndSolution("Out of memory due to hash maps used in map-side aggregation.", "Currently " + confName + " is set to " + confValue + ". Try setting it to a lower value. i.e 'set " + confName + " = " + confValue / 2.0f + ";'");
        }
        this.reset();
        return es;
    }
}

