/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentLengthException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.SettableUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorConverter;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableHiveDecimalObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;

@Description(name="decimal", value="_FUNC_(a) - cast a to decimal")
public class GenericUDFToDecimal
extends GenericUDF
implements SettableUDF {
    private transient PrimitiveObjectInspector argumentOI;
    private transient PrimitiveObjectInspectorConverter.HiveDecimalConverter bdConverter;
    private DecimalTypeInfo typeInfo;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length < 1) {
            throw new UDFArgumentLengthException("The function DECIMAL requires at least one argument, got " + arguments.length);
        }
        try {
            this.argumentOI = (PrimitiveObjectInspector)arguments[0];
        }
        catch (ClassCastException e) {
            throw new UDFArgumentException("The function DECIMAL takes only primitive types");
        }
        SettableHiveDecimalObjectInspector outputOI = (SettableHiveDecimalObjectInspector)PrimitiveObjectInspectorFactory.getPrimitiveWritableObjectInspector((PrimitiveTypeInfo)this.typeInfo);
        this.bdConverter = new PrimitiveObjectInspectorConverter.HiveDecimalConverter(this.argumentOI, outputOI);
        return outputOI;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Object o0 = arguments[0].get();
        if (o0 == null) {
            return null;
        }
        return this.bdConverter.convert(o0);
    }

    @Override
    public String getDisplayString(String[] children) {
        assert (children.length == 1);
        StringBuilder sb = new StringBuilder();
        sb.append("CAST( ");
        sb.append(children[0]);
        sb.append(" AS ");
        sb.append(this.typeInfo.getQualifiedName());
        sb.append(")");
        return sb.toString();
    }

    public DecimalTypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    public void setTypeInfo(DecimalTypeInfo typeInfo) {
        this.typeInfo = typeInfo;
    }

    @Override
    public void setTypeInfo(TypeInfo typeInfo) throws UDFArgumentException {
        this.typeInfo = (DecimalTypeInfo)typeInfo;
    }
}

