/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.connect.grpc.netty;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import org.sparkproject.connect.grpc.Attributes;
import org.sparkproject.connect.grpc.Status;
import org.sparkproject.connect.grpc.internal.ManagedClientTransport;

final class ClientTransportLifecycleManager {
    private final ManagedClientTransport.Listener listener;
    private boolean transportReady;
    private boolean transportShutdown;
    private boolean transportInUse;
    private Status shutdownStatus;
    private boolean transportTerminated;

    public ClientTransportLifecycleManager(ManagedClientTransport.Listener listener) {
        this.listener = listener;
    }

    public Attributes filterAttributes(Attributes attributes) {
        if (this.transportReady || this.transportShutdown) {
            return attributes;
        }
        return this.listener.filterTransport(attributes);
    }

    public void notifyReady() {
        if (this.transportReady || this.transportShutdown) {
            return;
        }
        this.transportReady = true;
        this.listener.transportReady();
    }

    public void notifyGracefulShutdown(Status s) {
        if (this.transportShutdown) {
            return;
        }
        this.transportShutdown = true;
        this.listener.transportShutdown(s);
    }

    @CanIgnoreReturnValue
    public boolean notifyShutdown(Status s) {
        this.notifyGracefulShutdown(s);
        if (this.shutdownStatus != null) {
            return false;
        }
        this.shutdownStatus = s;
        return true;
    }

    public void notifyInUse(boolean inUse) {
        if (inUse == this.transportInUse) {
            return;
        }
        this.transportInUse = inUse;
        this.listener.transportInUse(inUse);
    }

    public void notifyTerminated(Status s) {
        if (this.transportTerminated) {
            return;
        }
        this.transportTerminated = true;
        this.notifyShutdown(s);
        this.listener.transportTerminated();
    }

    public Status getShutdownStatus() {
        return this.shutdownStatus;
    }
}

