/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.metrics2.reporters;

import com.codahale.metrics.ConsoleReporter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.storm.daemon.metrics.ClientMetricsUtils;
import org.apache.storm.metrics2.DimensionalReporter;
import org.apache.storm.metrics2.MetricRegistryProvider;
import org.apache.storm.metrics2.filters.StormMetricsFilter;
import org.apache.storm.metrics2.reporters.ScheduledStormReporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleStormReporter
extends ScheduledStormReporter
implements DimensionalReporter.DimensionHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ConsoleStormReporter.class);

    @Override
    public void prepare(MetricRegistry registry, Map<String, Object> topoConf, Map<String, Object> reporterConf) {
        this.init(registry, null, reporterConf);
    }

    @Override
    public void prepare(MetricRegistryProvider metricRegistryProvider, Map<String, Object> topoConf, Map<String, Object> reporterConf) {
        this.init(metricRegistryProvider.getRegistry(), metricRegistryProvider, reporterConf);
    }

    private void init(MetricRegistry registry, MetricRegistryProvider metricRegistryProvider, Map<String, Object> reporterConf) {
        StormMetricsFilter filter;
        TimeUnit durationUnit;
        TimeUnit rateUnit;
        LOG.debug("Preparing ConsoleReporter");
        ConsoleReporter.Builder builder = ConsoleReporter.forRegistry((MetricRegistry)registry);
        builder.outputTo(System.out);
        Locale locale = ClientMetricsUtils.getMetricsReporterLocale(reporterConf);
        if (locale != null) {
            builder.formattedFor(locale);
        }
        if ((rateUnit = ClientMetricsUtils.getMetricsRateUnit(reporterConf)) != null) {
            builder.convertRatesTo(rateUnit);
        }
        if ((durationUnit = ClientMetricsUtils.getMetricsDurationUnit(reporterConf)) != null) {
            builder.convertDurationsTo(durationUnit);
        }
        if ((filter = ConsoleStormReporter.getMetricsFilter(reporterConf)) != null) {
            builder.filter((MetricFilter)filter);
        }
        this.reportingPeriod = ConsoleStormReporter.getReportPeriod(reporterConf);
        this.reportingPeriodUnit = ConsoleStormReporter.getReportPeriodUnit(reporterConf);
        ConsoleReporter consoleReporter = builder.build();
        boolean reportDimensions = ConsoleStormReporter.isReportDimensionsEnabled(reporterConf);
        if (reportDimensions) {
            if (metricRegistryProvider == null) {
                throw new RuntimeException("MetricRegistryProvider is required to enable reporting dimensions");
            }
            if (rateUnit == null) {
                rateUnit = TimeUnit.SECONDS;
            }
            if (durationUnit == null) {
                durationUnit = TimeUnit.MILLISECONDS;
            }
            DimensionalReporter dimensionalReporter = new DimensionalReporter(metricRegistryProvider, (ScheduledReporter)consoleReporter, this, "ConsoleDimensionalReporter", filter, rateUnit, durationUnit, null, true);
            this.reporter = dimensionalReporter;
        } else {
            this.reporter = consoleReporter;
        }
    }

    @Override
    public void setDimensions(Map<String, String> dimensions) {
        System.out.println("Using dimensions: ");
        for (Map.Entry<String, String> entry : dimensions.entrySet()) {
            System.out.println(entry.getKey() + " : " + entry.getValue());
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
    }
}

