/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io.content;

import java.util.Objects;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.MathUtils;
import org.eclipse.jetty.util.StaticException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentSourcePublisher
implements Flow.Publisher<Content.Chunk> {
    private static final Logger LOG = LoggerFactory.getLogger(ContentSourcePublisher.class);
    private final AtomicReference<Content.Source> content;

    public ContentSourcePublisher(Content.Source content) {
        Objects.requireNonNull(content, "Content.Source must not be null");
        this.content = new AtomicReference<Content.Source>(content);
    }

    @Override
    public void subscribe(Flow.Subscriber<? super Content.Chunk> subscriber) {
        Content.Source content = this.content.getAndSet(null);
        if (content != null) {
            this.onSubscribe(subscriber, content);
        } else {
            this.onMultiSubscribe(subscriber);
        }
    }

    private void onSubscribe(Flow.Subscriber<? super Content.Chunk> subscriber, Content.Source content) {
        block3: {
            if (subscriber == null) {
                NullPointerException error = new NullPointerException("Flow.Subscriber must not be null");
                content.fail(error);
                throw error;
            }
            ActiveSubscription subscription = new ActiveSubscription(content, subscriber);
            try {
                subscriber.onSubscribe(subscription);
            }
            catch (Throwable err) {
                subscription.cancel(new SuppressedException(err));
                if (!LOG.isTraceEnabled()) break block3;
                LOG.trace("Flow.Subscriber " + String.valueOf(subscriber) + " violated rule 2.13", err);
            }
        }
    }

    private void onMultiSubscribe(Flow.Subscriber<? super Content.Chunk> subscriber) {
        block3: {
            if (subscriber == null) {
                throw new NullPointerException("Flow.Subscriber must not be null");
            }
            ExhaustedSubscription subscription = new ExhaustedSubscription();
            try {
                subscriber.onSubscribe(subscription);
                subscriber.onError(new IllegalStateException("Content.Source was exhausted."));
            }
            catch (Throwable err) {
                if (!LOG.isTraceEnabled()) break block3;
                LOG.trace("Flow.Subscriber " + String.valueOf(subscriber) + " violated rule 2.13", err);
            }
        }
    }

    private static final class ActiveSubscription
    extends IteratingCallback
    implements Flow.Subscription,
    Runnable {
        private static final long NO_MORE_DEMAND = -1L;
        private static final Throwable COMPLETED = new StaticException("Source.Content read fully");
        private final AtomicReference<Throwable> cancelled = new AtomicReference<Object>(null);
        private final AtomicLong demand = new AtomicLong(0L);
        private Content.Source content;
        private Flow.Subscriber<? super Content.Chunk> subscriber;

        public ActiveSubscription(Content.Source content, Flow.Subscriber<? super Content.Chunk> subscriber) {
            this.content = content;
            this.subscriber = subscriber;
        }

        protected IteratingCallback.Action process() {
            Content.Chunk chunk;
            block14: {
                Throwable cancelled = this.cancelled.get();
                if (cancelled != null) {
                    block13: {
                        this.demand.set(-1L);
                        if (cancelled != COMPLETED) {
                            this.content.fail(cancelled);
                        }
                        this.content = null;
                        try {
                            if (cancelled == COMPLETED) {
                                this.subscriber.onComplete();
                            } else if (!(cancelled instanceof SuppressedException)) {
                                this.subscriber.onError(cancelled);
                            }
                        }
                        catch (Throwable err) {
                            if (!LOG.isTraceEnabled()) break block13;
                            LOG.trace("Flow.Subscriber " + String.valueOf(this.subscriber) + " violated rule 2.13", err);
                        }
                    }
                    this.subscriber = null;
                    return IteratingCallback.Action.SUCCEEDED;
                }
                chunk = this.content.read();
                if (chunk == null) {
                    this.content.demand(this);
                    return IteratingCallback.Action.SCHEDULED;
                }
                if (Content.Chunk.isFailure(chunk)) {
                    this.cancel(chunk.getFailure());
                    chunk.release();
                    return IteratingCallback.Action.IDLE;
                }
                try {
                    this.subscriber.onNext(chunk);
                }
                catch (Throwable err) {
                    this.cancel(new SuppressedException(err));
                    if (!LOG.isTraceEnabled()) break block14;
                    LOG.trace("Flow.Subscriber " + String.valueOf(this.subscriber) + " violated rule 2.13", err);
                }
            }
            chunk.release();
            if (chunk.isLast()) {
                this.cancel(COMPLETED);
                return IteratingCallback.Action.IDLE;
            }
            if (this.demand.decrementAndGet() > 0L) {
                this.iterate();
            }
            return IteratingCallback.Action.IDLE;
        }

        @Override
        public void run() {
            this.succeeded();
        }

        @Override
        public void request(long n) {
            if (this.cancelled.get() != null) {
                return;
            }
            if (n <= 0L) {
                String errorMsg = "Flow.Subscriber " + String.valueOf(this.subscriber) + " violated rule 3.9: non-positive requests are not allowed.";
                this.cancel(new IllegalArgumentException(errorMsg));
                return;
            }
            if (this.demand.updateAndGet(it -> it == -1L ? it : MathUtils.cappedAdd((long)it, (long)n)) != -1L) {
                this.iterate();
            }
        }

        @Override
        public void cancel() {
            this.cancel(new CancelledException());
        }

        public void cancel(Throwable cause) {
            if (this.cancelled.compareAndSet(null, cause)) {
                this.iterate();
            }
        }
    }

    private static class SuppressedException
    extends Exception {
        SuppressedException(String message) {
            super(message);
        }

        SuppressedException(Throwable cause) {
            super(cause.getMessage(), cause);
        }
    }

    private static final class ExhaustedSubscription
    implements Flow.Subscription {
        private ExhaustedSubscription() {
        }

        @Override
        public void request(long n) {
        }

        @Override
        public void cancel() {
        }
    }

    private static class CancelledException
    extends SuppressedException {
        CancelledException() {
            super("Subscription was cancelled");
        }
    }
}

