/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.crypto.jna;

import org.apache.commons.crypto.cipher.CryptoCipher;
import org.apache.commons.crypto.jna.OpenSslJnaCipher;
import org.apache.commons.crypto.jna.OpenSslJnaCryptoRandom;
import org.apache.commons.crypto.jna.OpenSslNativeJna;
import org.apache.commons.crypto.random.CryptoRandom;

public final class OpenSslJna {
    static void debug(String format, Object ... args) {
        if (Boolean.getBoolean("commons.crypto.debug")) {
            System.out.println(String.format(format, args));
        }
    }

    public static Class<? extends CryptoCipher> getCipherClass() {
        return OpenSslJnaCipher.class;
    }

    public static Class<? extends CryptoRandom> getRandomClass() {
        return OpenSslJnaCryptoRandom.class;
    }

    private static void info(String format, Object ... args) {
        System.out.println(String.format(format, args));
    }

    public static Throwable initialisationError() {
        return OpenSslNativeJna.INIT_ERROR;
    }

    public static boolean isEnabled() {
        return OpenSslNativeJna.INIT_OK;
    }

    public static void main(String[] args) {
        OpenSslJna.info("isEnabled(): %s", OpenSslJna.isEnabled());
        Throwable initialisationError = OpenSslJna.initialisationError();
        OpenSslJna.info("initialisationError(): %s", initialisationError);
        if (initialisationError != null) {
            System.err.flush();
            initialisationError.printStackTrace();
        }
    }

    static String OpenSSLVersion(int type) {
        return OpenSslNativeJna.OpenSSLVersion(type);
    }
}

