/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.engine;

import java.io.IOException;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.ruta.engine.RutaModifier;
import org.apache.uima.ruta.engine.StyleMapFactory;

public class StyleMapCreator
extends JCasAnnotator_ImplBase {
    public static final String PARAM_DESCRIPTOR_PATHS = "descriptorPaths";
    @ConfigurationParameter(name="descriptorPaths", mandatory=false)
    private String[] descriptorPaths;
    public static final String PARAM_STYLE_MAP = "styleMap";
    @ConfigurationParameter(name="styleMap", mandatory=false)
    private String styleMapLocation;
    private UimaContext context;
    private StyleMapFactory styleMapFactory;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        if (aContext == null && this.context != null) {
            aContext = this.context;
        }
        if (aContext != null) {
            this.styleMapLocation = (String)aContext.getConfigParameterValue(PARAM_STYLE_MAP);
            this.descriptorPaths = (String[])aContext.getConfigParameterValue(PARAM_DESCRIPTOR_PATHS);
            this.styleMapFactory = new StyleMapFactory();
            this.context = aContext;
        }
    }

    public void process(JCas jcas) throws AnalysisEngineProcessException {
        try {
            String locate = RutaModifier.locate(this.styleMapLocation, this.descriptorPaths, ".xml", false);
            if (locate != null) {
                this.styleMapFactory.createStyleMap(locate, jcas);
            }
        }
        catch (IOException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }
}

