/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Producer;
import org.apache.camel.impl.DefaultAsyncProducer;
import org.apache.camel.impl.InterceptSendToEndpoint;
import org.apache.camel.processor.PipelineHelper;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterceptSendToEndpointProcessor
extends DefaultAsyncProducer {
    private static final Logger LOG = LoggerFactory.getLogger(InterceptSendToEndpointProcessor.class);
    private final InterceptSendToEndpoint endpoint;
    private final Endpoint delegate;
    private final Producer producer;
    private final boolean skip;

    public InterceptSendToEndpointProcessor(InterceptSendToEndpoint endpoint, Endpoint delegate, Producer producer, boolean skip) throws Exception {
        super(delegate);
        this.endpoint = endpoint;
        this.delegate = delegate;
        this.producer = producer;
        this.skip = skip;
    }

    @Override
    public Endpoint getEndpoint() {
        return this.producer.getEndpoint();
    }

    @Override
    public Exchange createExchange() {
        return this.producer.createExchange();
    }

    @Override
    public Exchange createExchange(ExchangePattern pattern) {
        return this.producer.createExchange(pattern);
    }

    @Override
    @Deprecated
    public Exchange createExchange(Exchange exchange) {
        return this.producer.createExchange(exchange);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sending to endpoint: {} is intercepted and detoured to: {} for exchange: {}", new Object[]{this.getEndpoint(), this.endpoint.getDetour(), exchange});
        }
        exchange.getIn().setHeader("CamelInterceptedEndpoint", this.delegate.getEndpointUri());
        if (this.endpoint.getDetour() != null) {
            try {
                this.endpoint.getDetour().process(exchange);
            }
            catch (Exception e) {
                exchange.setException(e);
            }
        }
        if (!PipelineHelper.continueProcessing(exchange, "skip sending to original intended destination: " + this.getEndpoint(), LOG)) {
            callback.done(true);
            return true;
        }
        boolean shouldSkip = this.skip;
        Boolean whenMatches = (Boolean)exchange.removeProperty("CamelInterceptSendToEndpointWhenMatched");
        if (whenMatches != null) {
            boolean bl = shouldSkip = this.skip && whenMatches != false;
        }
        if (!shouldSkip) {
            if (exchange.hasOut()) {
                exchange.setIn(exchange.getOut());
                exchange.setOut(null);
            }
            if (this.producer instanceof AsyncProcessor) {
                AsyncProcessor async = (AsyncProcessor)((Object)this.producer);
                return async.process(exchange, callback);
            }
            try {
                this.producer.process(exchange);
            }
            catch (Exception e) {
                exchange.setException(e);
            }
            callback.done(true);
            return true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Stop() means skip sending exchange to original intended destination: {} for exchange: {}", (Object)this.getEndpoint(), (Object)exchange);
        }
        callback.done(true);
        return true;
    }

    @Override
    public boolean isSingleton() {
        return this.producer.isSingleton();
    }

    @Override
    public void start() throws Exception {
        ServiceHelper.startService(this.endpoint.getDetour());
        ServiceHelper.startService(this.producer);
    }

    @Override
    public void stop() throws Exception {
        ServiceHelper.stopService(this.producer);
    }
}

