Article 3411 of comp.lang.perl:
Xref: feenix.metronet.com comp.lang.perl:3411
Path: feenix.metronet.com!news.utdallas.edu!tamsun.tamu.edu!cs.utexas.edu!uunet!pipex!uknet!edcastle!dcs.ed.ac.uk!kgg
From: kgg@dcs.ed.ac.uk (Kees Goossens)
Newsgroups: comp.lang.perl
Subject: Summary [Re: locking files]
Message-ID: <C8M20A.13r@dcs.ed.ac.uk>
Date: 14 Jun 93 12:14:33 GMT
References: <C8EzGn.KK6@dcs.ed.ac.uk>
Sender: cnews@dcs.ed.ac.uk (UseNet News Admin)
Reply-To: kgg@dcs.ed.ac.uk (Kees Goossens)
Organization: The Lavatory for the Foundations of Computer Science
Lines: 178

In article <C8EzGn.KK6@dcs.ed.ac.uk> kgg@dcs.ed.ac.uk (Kees Goossens) writes:
>I'm trying to write simple lock & unlock routines to guarantee exclusive
>access to a shared file. 
>Both seem to rely on the fact that "link(file,lockfile);" acts as an arbiter 
>in of case simultaneous access.

I got two replies:

From: ajcd@dcs.ed.ac.uk:
>Yes, this is a correct understanding. The real point is that this is the only
>way which will reliably work over NFS mounts. If two machines try to link to
>the same file at once, they will both use NFS remote procedure calls, which go
>to the machine from which the directory is mounted. I'm a little hazy about
>the exact details, but the NFS daemon there arbitrates which gets the first
>request (it may even be that the NFS daemon is single-streamed), and the
>second request to arrive fails.


From: Lol Grant <lol@cisco.com>:
>        The ultimate reference on locking etc. is W. Richard Stevens
>"Unix Network Programming". The "link hack" and a bunch of other
>locking schemes are fully discussed in his book. Linking is not
>guaranteed to be atomic over NFS i.e. you cannot use that scheme if
>your file will be accessed over NFS.
>
>Having implemented my own locking scheme in a perl program, I would
>offer the following: There is no convenient technique which works
>across NFS filesystems.  Sun created lockd to address this problem,
>but I hear such bad reports about bugs in lockd that I have chosen not
>to use it.
>
>My personal opinion is that if you need multi-machine locking, you
>should write your own lock server which runs on a single machine and
>which grants or refuses locks for requesting processes everywhere else
>on your net. In your case, it could even serve blocks to/from the file
>if the overhead were low enough.
>
>This kind of lock arbitrator should be adequate unless you need many
>locks very frequently, but you don't say which platform(s) you are
>running on, so it's hard to be more specific.

As I only need something simple (lock/nolock) I wrote some basic routines.
They're not as flash as say majordomo's locking routines, but they seem to
work with processes on different machines, etc.  Feel free to mutilate this
code into a form which is usable to you.

Thanks to Angus and Lol.

Kees


Note on code: lock, unlock create and remove locks, locked checks if a lock
is present.  exclopen and exclclose are hacky versions resembling open and
close.  I'm not very happy with them, but they'll do for what I want.


#!/usr/local/bin/perl
#
# 11/6/93 Kees Goossens (kgg@dcs.ed.ac.uk)
#
# Routines to lock a file to ensure exclusive access.
# Note that only the owner (a pid on a host) of the lock may unlock the file.
#
# $file.$host.lock$$ is the caller's lock file, 
# $file.lock the lock file ensuring unique access.
# 
# Hardwired constants: 100 attempts (used if tries parameter is omitted);
#		       waiting 3 seconds between each.
#

$lockdebug=0;	# debugging 

#
# exclopen (file: filehandle,mode: string,file: string,[tries: int]): int
# Return 1 if successful (created lock & opened file), 0 otherwise.
#
sub exclopen {
local($FH) = shift;
local($mode) = shift;
local($file) = shift;
local($tries) = shift;

    $tries=100 if $tries < 1;
    if (&lock ($file,$tries)) {
	return 1 if (open($FH,$mode.$file));
	&unlock ($file);
    }
    return 0;
}


#
# exclclose (file: filehandle,file: string): (int,int)
# Return 1 if deleted lock and closed file, 0 otherwise.
# Unsatisfactory because can unlock file with bogus file handle.
#
sub exclclose {
local($FH) = shift;
local($file) = shift;

    if (&unlock ($file)) {
    	close ($FH);
	return 1;
    }
    else {
	return 0;
    }
}


#
# lock (file: string,[tries: int]): int
# Lock file, tring tries times, waiting $interval second each time.
# Return 0 if could not get lock, 1 if successful.
#
sub lock {
local ($file) = shift;
local ($tries) = shift;
local (*LOCK,$try,$host);

    $tries=100 if $tries < 1;
    chop ($host = `hostname`);
    open (LOCK, ">$file.$host.lock$$") || return 0;
    print LOCK "$host $$\n";
    close LOCK;

    while ($try++ < $tries) {
	print "file: $file.$host.lock$$; try: $try\n" if $lockdebug;
	if (link("$file.$host.lock$$","$file.lock")) {
	    unlink ("$file.$host.lock$$") || 
		warn("lock: cannot delete $file.$host.lock$$: $!\n");
	    return 1;
	}
	sleep 3;
    }
    warn("lock: cannot get $file.lock after $tries tries\n");
    unlink ("$file.$host.lock$$") || 
	warn("lock: cannot delete $file.$host.lock$$: $!\n");
    return 0;
}


#
# unlock (file: string): int
# Unlock file. return 1 if successful, 0 if no such lock, couldn't remove lock.
# Note that only the original process can unlock the file.  This may not be
# what you want.  (Of course, can assign anything to $$, but we assume honest
# callers.)
#
sub unlock {
local ($file) = shift;
local ($host);

    chop ($host = `hostname`);
    # Check that we're the owner of the lock:
    return 0 if (&locked($file) ne "$host $$");
    return (unlink("$file.lock") ? 1 : 0);
}


#
# locked (file: string): string
# Return "host pid" of lock owner, "" if not locked.
#
sub locked {
local ($file) = shift;
local ($LOCK,$who);

    return ""  unless (open (LOCK,"<$file.lock"));
    chop ($who=<LOCK>);
    close LOCK;
    return $who;
}
-- 
Kees Goossens                       Keep in Touch with the Dutch:
LFCS, Dept. of Computer Science     JANET: kgg@dcs.ed.ac.uk
University of Edinburgh, Scotland   UUCP:  ..!mcsun!uknet!dcs!kgg
Wiskunde is bouwen in de geest.	--- Luitzen Egbertus Jan Brouwer.


