

From: gt8134b@prism.gatech.EDU (Robert Sanders)

Subject: dlperl in perl5a6
Keywords: perl, dynamic loading, dlperl
Message-ID: <142174@hydra.gatech.EDU>
Date: 2 Mar 94 07:48:56 GMT
Sender: news@prism.gatech.EDU
Lines: 31

Are there any plans to alter perl5 so that the dynamic loading of object files 
can be accomplished with GNU dld-3.2.4 instead of Sun's dlopen()?

As I understand the current dl.c, the dynamically loaded .so file is expected 
to initialize itself by calling the appropriate Perl5 functions such as 
newXSUB().  On systems which don't use dynamic linking in the SunOS sense, 
such as Linux, an executable may not contain any symbol information at all.  
Since the external module would need to resolve its external references
to the Perl5 functions, dl.c wouldn't work with a stripped executable.

Although I think the current scheme is the most powerful one, I still can't
get used to the idea of running an unstripped executable that (on my system)
is 50K larger than the stripped one.  I suppose the non-SunOS dynamic
linking could keep two copies of the perl5 executable around, one for running
and an unstripped version for linkage information, but there is an alternative:
the perl5 binary could pass an array of function pointers to the bootstrap
function of the external module.  Through #defines or other chicanery, the
external module would do all it's perl function invocation by indirection
through this array.  So, newXSUB would look more like *(perlfuncs[NEWXSUB]),
but of course you wouldn't explicitly write that.  Both interfaces could
be supported, but simpler modules could make do with the latter one, and
wouldn't require any runtime link editing magic (well, a little).

Ok, not very palatable, but that's why I'm posting here.  Comments?


--
 _g,  '96 --->>>>>>>>>>   gt8134b@prism.gatech.edu  <<<<<<<<<---  CompSci  ,g_
W@@@W__        |-\      ^        | disclaimer:  <---> "Bow before ZOD!" __W@@@W
W@@@@**~~~'  ro|-<ert s/_\ nders |   who am I???  ^  from Superman  '~~~**@@@@W
`*MV' hi,ocie! |-/ad! /   \ss!!  | ooga ooga!!    |    II (cool)!         `VW*'




From: heading@signal.dra.hmg.gb (Anthony Heading)

Subject: Re: dlperl in perl5a6
Date: 2 Mar 1994 13:10:51 -0000
Organization: Defence Research Agency, UK
Lines: 32
Message-ID: <2l238r$5m5@liszt.dra.hmg.gb>
References: <142174@hydra.gatech.edu>
NNTP-Posting-Host: liszt.dra.hmg.gb
Keywords: perl, dynamic loading, dlperl

In article <142174@hydra.gatech.edu>,
Robert Sanders <gt8134b@prism.gatech.EDU> wrote:
>Although I think the current scheme is the most powerful one, I still can't
>get used to the idea of running an unstripped executable that (on my system)
>is 50K larger than the stripped one.

On most Unixes, the symbol table isn't loaded into memory by default,
so it doesn't cost you any more. And if you are worried, you can strip
everything but the exported symbols, or write a bit of code to strip
even more selectively than that. I've thought about this quite a bit
recently, and I don't think there's anything to be gained by reformatting
the symbol table in a different place, which is basically all that
any variant scheme would do.

The general question of how to configure perl for the various
implementations of dynamic linking is worth thinking about, though.
dld is quite a good model for those systems on which it works, I
think, but the SUNos one also appears on OSF/1, for example, and
NeXTs have a variant of their own.  I'm currently writing a MIPS Ultrix
dynamic linker, especially for perl, so I could follow any or all of
these interfaces, but I'm not sure which is best.

Maybe we should define a generic dl interface, as a front-end for
whichever package is being used? Comments please: we should be able to
work this stuff out for ourselves, and take the load off Larry a little
bit.

Anthony
-- 

------------------
AJR Heading, DRA UK




From: wscott@pdx821 (Wayne Scott)

Subject: Re: dlperl in perl5a6
Date: 2 Mar 1994 17:06:58 GMT
Organization: Intel Corp., Hillsboro, Oregon
Lines: 48
Message-ID: <2l2h3i$arn@ornews.intel.com>
References: <142174@hydra.gatech.edu> <2l238r$5m5@liszt.dra.hmg.gb>
Reply-To: wscott@ichips.intel.com
NNTP-Posting-Host: pdx821.intel.com
Keywords: perl, dynamic loading, dlperl

In article <2l238r$5m5@liszt.dra.hmg.gb>,
Anthony Heading <heading@signal.dra.hmg.gb> wrote:

>The general question of how to configure perl for the various
>implementations of dynamic linking is worth thinking about, though.
>dld is quite a good model for those systems on which it works, I
>think, but the SUNos one also appears on OSF/1, for example, and
>NeXTs have a variant of their own.  I'm currently writing a MIPS Ultrix
>dynamic linker, especially for perl, so I could follow any or all of
>these interfaces, but I'm not sure which is best.
>
>Maybe we should define a generic dl interface, as a front-end for
>whichever package is being used? Comments please: we should be able to
>work this stuff out for ourselves, and take the load off Larry a little
>bit.
>
>Anthony
>-- 
>

I reciently explored the portability for GNU dld because I wanted to
make sure that perl5's dynamic linking can be used by our RS6000s.
Then I discovered that AIX has it own dynamic linking facility that
I should be able to get into a form that Perl can use.

Dld currently (v3.2.3) only works with VAX, Sun3, Sparc, Sequent, and 
Atari ST systems. This is not much more supported then the -ldl library
that Sun uses.


The code for dld is fairly straightforward and we should be able to rewrite 
it to have a different backend for each platform.

The GNU bfd library (included with binutils) is perfectly suited to this
task.  It is a library that reads many different object formats and presents
then to the program in one canonical format.  bfd can also handle all the 
symbol relocating in a Arch independant way.

That is where I stopped this project when I discovered that bfd does not
support XCOFF that AIX (and only AIX) uses.


Maybe someone can do something with this.

-- 
--------
Wayne Scott
wscott@ichips.intel.com		Work #: (503) 696-4165





From: jlemon@netcom.com (Jonathan Lemon)
Subject: Re: dlperl in perl5a6
Message-ID: <jlemonCM28yo.3pr@netcom.com>
Keywords: perl, dynamic loading, dlperl
Organization: Netcom - Online Communication Services (408 241-9760 guest)
References: <142174@hydra.gatech.edu> <2l238r$5m5@liszt.dra.hmg.gb> <2l2h3i$arn@ornews.intel.com>
Date: Wed, 2 Mar 1994 23:23:10 GMT
Lines: 39

In article <2l2h3i$arn@ornews.intel.com> wscott@ichips.intel.com writes:
>In article <2l238r$5m5@liszt.dra.hmg.gb>,
>
>The GNU bfd library (included with binutils) is perfectly suited to this
>task.  It is a library that reads many different object formats and presents
>then to the program in one canonical format.  bfd can also handle all the 
>symbol relocating in a Arch independant way.

As someone who started working on an implementation of dynamic linking 
for the Sequent symmetry last week, I have a few point to add:

Firstly, dld does require the symbol table to be present.  Before using any
dld functions, you have to call dld_init() with the name of the program
being executed.  It then reads the symbol table in from the executable file.

Without this, there's no way to patch the dynamically loaded object file
with the correct offsets, since you don't have any method to find the address
of a loaded symbol.

I dislike this, since some of the administrators at our site like to run 
strip(1) on random binaries whenever they start getting low on disk space.

I considered requiring the loadable file to have no unresolved references
or that (since the symmetry uses COFF files) all references must be resolved
by the archive that the loadable module is contained in.  This means that 
you'd have another copy of printf() and friends loaded into your heap.  
However, since brk(3) uses the ld-defined symbol 'end', I'd have to figure
a way to find the value of end in the current executable.  (For now, I just
punted and went with the symbol table, to get things working)

I was hoping that I could use the GNU bfd library to do most of the dirty
work, but that doesn't appear to be the case; it seems to be designed to 
patch the file as it is written out, rather than patching a 'current' file.  
As it is, I'll probably just steal the relocation patching stuff, which
is about all I need at this point.

I hope to have a working version in a few more weeks, as time permits.  :-)
--
Jonathan




From: heading@signal.dra.hmg.gb (Anthony Heading)

Subject: Re: dlperl in perl5a6
Date: 8 Mar 1994 04:52:46 -0000
Organization: Defence Research Agency, UK
Lines: 55
Message-ID: <2lh0au$gl7@chopin.dra.hmg.gb>
References: <142174@hydra.gatech.edu> <2l238r$5m5@liszt.dra.hmg.gb> <2l2h3i$arn@ornews.intel.com>
NNTP-Posting-Host: chopin.dra.hmg.gb
Keywords: perl, dynamic loading, dlperl

Errm, well. Here are some thoughts about things that people have mentioned
and emailed recently.

I think the GNU bfd library is not worth using: whilst it knows about every
relocation type under the sun, in its current state, it's very oriented
towards file to file binary transmutations. GNU will have a bfd based dld,
but it's a fair way off, I guess.

A couple of people still seem upset about the idea of reading the symbols
from /usr/local/bin/perl. I'd be interested in any informed argument
against this - again it's worth pointing out that you can still strip
the executable selectively, and that the larger file uses no more VM.

Someone suggested looking at Python. It seems that they have chosen as a
reference model a dl implementation for MIPS IRIX, and provided a wrapper
for dld. I haven't examined it in much detail, but since the IRIX implementation
uses ld -A, doesn't support mips small data, and gives no thought to the
idea of unlinking code I'm not stepping back in awe.

There are a couple of questions I have isolated. With regard to dynamic
unlinking:
  a) Do we need it? Should perl support it at all?
  b) Should the behaviour be defined, or should your mileage vary?
It's quite tricky supporting dynamic loading on systems that aren't up
to speed - providing consistent unloading may be more difficult.

Some dl implementations effectively have an overall
symbol table made up from all the objects in the search path - it's
assumed that multiple definitions are common. This is very much just the
shared library paradigm. Others seem to provide a pointer for each loaded
object file, so whilst you must search these explicitly, it allows a 
number of functions with the same name.

On reflection, whilst the latter type is more work for day-to-day C programming,
it's a bonus for perl: it could allow modules to have a @LDPATH array and
so on [such details are just perl module stuff so we can worry about that
later, if indeed Larry hasn't already sussed it]. Again, though, do we need it?
Systems with proper shared libraries will probably never bother with dynamic
loading - if they decide to define a single namespace then the idea of different
linkage for various different modules is going to be problematic...

  a) How many systems have support only for the global stab model?
  b) How many systems have support only for the individual stab model?

Hmm. That's about it. I'm sort of inclined to think that we should take
a minimal intersection of all the features available, and support it as widely
as possible. That means a single link path, undefined handling of multiple symbol
definitions, and no unlinking. And any other miserly choices available.

Thoughts?

Anthony
-- 
AJR Heading, Defence Research Agency, St. Andrews Road, Great Malvern, UK
Email: ajrh@signal.dra.hmg.gb  Tele: +44 684 896066  Fax: +44 684 89438




From: jum@anubis.han.de (Jens-Uwe Mager)

Subject: Re: dlperl in perl5a6
Date: Sun, 6 Mar 94 03:53:17 MET
Message-ID: <0E062001.pu11c1@anubis.han.de>
Reply-To: jum@anubis.han.de (Jens-Uwe Mager)
X-Mailer: uAccess - Macintosh Release: 1.6v2
Lines: 61


In article <2l2h3i$arn@ornews.intel.com> (comp.lang.perl), wscott@pdx821 (Wayne Scott) writes:
> In article <2l238r$5m5@liszt.dra.hmg.gb>,
> Anthony Heading <heading@signal.dra.hmg.gb> wrote:
> 
> >The general question of how to configure perl for the various
> >implementations of dynamic linking is worth thinking about, though.
> >dld is quite a good model for those systems on which it works, I
> >think, but the SUNos one also appears on OSF/1, for example, and
> >NeXTs have a variant of their own.  I'm currently writing a MIPS Ultrix
> >dynamic linker, especially for perl, so I could follow any or all of
> >these interfaces, but I'm not sure which is best.
> >
> >Maybe we should define a generic dl interface, as a front-end for
> >whichever package is being used? Comments please: we should be able to
> >work this stuff out for ourselves, and take the load off Larry a little
> >bit.
> >
> >Anthony
> >-- 
> >
> 
> I reciently explored the portability for GNU dld because I wanted to
> make sure that perl5's dynamic linking can be used by our RS6000s.
> Then I discovered that AIX has it own dynamic linking facility that
> I should be able to get into a form that Perl can use.
> 
> Dld currently (v3.2.3) only works with VAX, Sun3, Sparc, Sequent, and 
> Atari ST systems. This is not much more supported then the -ldl library
> that Sun uses.
> 
> 
> The code for dld is fairly straightforward and we should be able to rewrite 
> it to have a different backend for each platform.
> 
> The GNU bfd library (included with binutils) is perfectly suited to this
> task.  It is a library that reads many different object formats and presents
> then to the program in one canonical format.  bfd can also handle all the 
> symbol relocating in a Arch independant way.
> 
> That is where I stopped this project when I discovered that bfd does not
> support XCOFF that AIX (and only AIX) uses.
> 
> 
> Maybe someone can do something with this.
> 

I have an emulation library available that emulates the dl*() calls on
top of AIX load(). I have posted this stuff several times to
comp.unix.aix already. I would like contribute that to the perl
distribution (how?). I also have a thin layer for HP-UX to offer. The
HP-UX stuff is much simpler then the AIX stuff, as shl_load is very
similar to dlopen.

So, now we probably need a layer on top of dld that works like dlopen
for those pour souls without a decent dynamic linking?

______________________________________________________________________________
Jens-Uwe Mager			jum@anubis.han.de
30177 Hannover			jum@helios.de
Brahmsstr. 3			Tel.: +49 511 660238




From: timbo@ig.co.uk (Tim Bunce)

Subject: Re: dlperl in perl5a6
Keywords: perl, dynamic loading, dlperl
References: <142174@hydra.gatech.edu> <2l238r$5m5@liszt.dra.hmg.gb>
Organisation: Paul Ingram Group, Software Systems, +44 483 424424
Date: Wed, 2 Mar 1994 18:00:07 +0000
Message-ID: <CM1u08.9vL@ig.co.uk>
Sender: usenet@demon.co.uk
Lines: 63

In article <2l238r$5m5@liszt.dra.hmg.gb> heading@signal.dra.hmg.gb (Anthony Heading) writes:
>In article <142174@hydra.gatech.edu>,
>Robert Sanders <gt8134b@prism.gatech.EDU> wrote:
>>Although I think the current scheme is the most powerful one, I still can't
>>get used to the idea of running an unstripped executable that (on my system)
>>is 50K larger than the stripped one.
>
>On most Unixes, the symbol table isn't loaded into memory by default,
>so it doesn't cost you any more. And if you are worried, you can strip
>everything but the exported symbols, or write a bit of code to strip
>even more selectively than that. I've thought about this quite a bit
>recently, and I don't think there's anything to be gained by reformatting
>the symbol table in a different place, which is basically all that
>any variant scheme would do.
Agreed.

>The general question of how to configure perl for the various
>implementations of dynamic linking is worth thinking about, though.
>dld is quite a good model for those systems on which it works, I
>think, but the SUNos one also appears on OSF/1, for example, and
>NeXTs have a variant of their own.  I'm currently writing a MIPS Ultrix
>dynamic linker, especially for perl, so I could follow any or all of
>these interfaces, but I'm not sure which is best.
>
>Maybe we should define a generic dl interface, as a front-end for
>whichever package is being used? Comments please: we should be able to
>work this stuff out for ourselves, and take the load off Larry a little
>bit.
>
I'd start off by talking to Larry about how he has implemented the internal
DynamicLoader package he described awhile ago:

In article <1994Feb6.090401.8009@netlabs.com> Larry writes:
>Let's see, what else is new.  I've also got dynamically loaded
>libraries working on SunOS, though configuring it is going to
>be a nightmare.  Currently my copy slurps in lib/SDBM_File.so when
>it wants to do the dbm tests.  Here's how it works.  When I say
>"require SDBM_File", it reads in SDBM_File.pm:
> 
>    package SDBM_File;
> 
>    require Exporter;
>    @ISA = (Exporter, DynamicLoader);
>    @EXPORT = qw(new fetch store delete firstkey nextkey error clearerr);
> 
>    bootstrap SDBM_File;
>    1;
> 
>If SDBM is already linked in, it calls SDBM_File::bootstrap
>immediately, and the DynamicLoader isn't used.  If SDBM is not yet
>linked in, it ends up looking for the bootstrap method via ISA, and
>finds it in DynamicLoader, which loads in the shared object and
>initializes it.  (The DynamicLoader package is a builtin package,
>which is why we aren't "requiring" DynamicLoader above.  On systems
>that don't support dynamic linking it'll just stub out to an error.)

The hooks are in. If you (or anyone else) has the time to coordinate the
effort then go for it. I'm sure you'll receive a lot of help.

>Anthony

Regards,
Tim Bunce.




From: gt8134b@prism.gatech.EDU (Robert Sanders)

Subject: Re: dlperl in perl5a6
Keywords: perl, dynamic loading, dlperl
Message-ID: <143272@hydra.gatech.EDU>
Date: 6 Mar 94 17:32:32 GMT
References: <142174@hydra.gatech.edu> <2l238r$5m5@liszt.dra.hmg.gb> <CM1u08.9vL@ig.co.uk>
Sender: news@prism.gatech.EDU
Lines: 91

timbo@ig.co.uk (Tim Bunce) writes:

>In article <2l238r$5m5@liszt.dra.hmg.gb> heading@signal.dra.hmg.gb (Anthony Heading) writes:
>>In article <142174@hydra.gatech.edu>,
>>Robert Sanders <gt8134b@prism.gatech.EDU> wrote:
>>>Although I think the current scheme is the most powerful one, I still can't
>>>get used to the idea of running an unstripped executable that (on my system)
>>>is 50K larger than the stripped one.
>>
>>On most Unixes, the symbol table isn't loaded into memory by default,
>>so it doesn't cost you any more. And if you are worried, you can strip

Yes, but until recently I was running on a Very Small Disk, and space was
not plentiful.   However, for perl5a6, the difference between stripped
and just-stripped-enough is only 31K or so out of 390K, so I won't
worry about it.

>>The general question of how to configure perl for the various
>>implementations of dynamic linking is worth thinking about, though.
>>dld is quite a good model for those systems on which it works, I

I agree.  It has all of the functionality of 'ld -A' plus it can
unlink modules from memory.  This is great for testing.

>>think, but the SUNos one also appears on OSF/1, for example, and
>>NeXTs have a variant of their own.  I'm currently writing a MIPS Ultrix
>>dynamic linker, especially for perl, so I could follow any or all of
>>these interfaces, but I'm not sure which is best.

>>Maybe we should define a generic dl interface, as a front-end for
>>whichever package is being used? Comments please: we should be able to
>>work this stuff out for ourselves, and take the load off Larry a little
>>bit.

I was going to post about this once I had given it a little thought.
One thing I'd like to see is having each module export an array of
libraries against which it must be linked.  For example, my SDBM_File.c
differs from Larry's by this much:

     #ifdef GNU_DLD
     char *lib_SDBM_File[] = {
       "libsdbm.a",
       NULL
     };
     #endif

So, after my DynamicLoader::bootstrap loads the object file, if there
are any undefined symbols, it'll go through the package's private list
of libraries and link against those, and then if there are STILL any
undefined symbols, it'll link against the standard system libraries 
(libc and libm right now).  Actually, I'm not really sure I like the
way I do this, as there's not easy way to associate a symbol with
a loaded module, so I also try to link against everything if there
were pre-existing undefined symbols (say, from a previous dynamic
load).  However, dynamic loading shouldn't happen that often, and
performance isn't a big issue yet.

>I'd start off by talking to Larry about how he has implemented the internal
>DynamicLoader package he described awhile ago:

It's very simple and clean.  I figured it out in no time.

>The hooks are in. If you (or anyone else) has the time to coordinate the
>effort then go for it. I'm sure you'll receive a lot of help.

The most important thing for my loader is for each module to export
a "NULL-terminated" array of char* that tells the names of all the
non-standard libraries it must link against.  What is standard will
be determined on each system: libnsl might be considered standard, but
libdbm probably shouldn't.

I think dynamic loading is one of the most important new features
of Perl5.  Almost nobody uses curseperl now, which in my opinion
is caused by their reluctance to install another perl, or to replace
their standard perl.  And even if they did, what if they need to
use sqlperl?  And then cursesqlperl?  Don't get me wrong, I'd much
rather code in Perl than in C, but some things need to be done in C.
Having dynamic loading available on the majority of perl platforms 
will hopefully lead to a wealth of user-contributed extensions that
anyone can use with a minimum of hassle.  Contrast "require Curses"
to recompiling and relinking.

Another issue is a foreign function interface.  Curseperl is mostly
stubbing to C, and I think that's a waste of time.  


--
 _g,  '96 --->>>>>>>>>>   gt8134b@prism.gatech.edu  <<<<<<<<<---  CompSci  ,g_
W@@@W__        |-\      ^        | disclaimer:  <---> "Bow before ZOD!" __W@@@W
W@@@@**~~~'  ro|-<ert s/_\ nders |   who am I???  ^  from Superman  '~~~**@@@@W
`*MV' hi,ocie! |-/ad! /   \ss!!  | ooga ooga!!    |    II (cool)!         `VW*'





From: lwall@netlabs.com (Larry Wall)
Subject: Re: dlperl in perl5a6
Message-ID: <1994Mar2.183356.25905@netlabs.com>
Keywords: perl, dynamic loading, dlperl
Organization: NetLabs, Inc.
References: <142174@hydra.gatech.edu> <2l238r$5m5@liszt.dra.hmg.gb>
Date: Wed, 2 Mar 1994 18:33:56 GMT
Lines: 9

In article <2l238r$5m5@liszt.dra.hmg.gb> heading@signal.dra.hmg.gb (Anthony Heading) writes:
: Maybe we should define a generic dl interface, as a front-end for
: whichever package is being used? Comments please: we should be able to
: work this stuff out for ourselves, and take the load off Larry a little
: bit.

Sounds like a good idea tooo meee...

Larry




From: bet@std.sbi.com (Bennett Todd)

Subject: Re: dlperl in perl5a6
Date: 4 Mar 1994 20:58:44 GMT
Organization: Salomon Brothers, Inc.
Lines: 10
Message-ID: <2l87e4$13i@sbi.sbi.com>
References: <142174@hydra.gatech.edu> <2l238r$5m5@liszt.dra.hmg.gb> <1994Mar2.183356.25905@netlabs.com>
NNTP-Posting-Host: std.sbi.com
Keywords: perl, dynamic loading, dlperl

In article <2l238r$5m5@liszt.dra.hmg.gb> heading@signal.dra.hmg.gb (Anthony Heading) writes:
>Maybe we should define a generic dl interface, as a front-end for
>whichever package is being used?

That's how Python did it. You might want to even pinch their code; it has a
generic front-end, which back-ends against various dynamic linking
facilities, including GNU's and Sun's. ftp.cwi.nl:pub/python.

-Bennett
bet@sbi.com


