Article 8660 of comp.lang.perl:
Xref: feenix.metronet.com comp.lang.perl:8660
Newsgroups: comp.lang.perl
Path: feenix.metronet.com!news.ecn.bgu.edu!usenet.ins.cwru.edu!howland.reston.ans.net!pipex!uknet!comlab.ox.ac.uk!mbeattie
From: mbeattie@black.ox.ac.uk (Malcolm Beattie)
Subject: A few bug reports/fixes for Perl5alpha3
Message-ID: <1993Dec6.101946.20854@black.ox.ac.uk>
Originator: mbeattie@black
Organization: Oxford University Computing Services, Oxford, U.K.
Date: Mon, 6 Dec 1993 10:19:46 GMT
Lines: 82

Over the last two weekends I have been getting started with
writing tkperl with Perl5 usersubs (not relying on Tcl for the
interface---I'll post a status report separately.).
In the process, I've looked hard at how to do usersubs. Here are
a few bugs that I came across on the way. I'll post separately
to explain what I know about Perl 5 usersubs since it has changed
a fair amount from Perl 4 and there weren't extensive examples
there anyway. This is perl5alpha3.

First a couple of typos.
On line 243 of doop.c, we find
            case 'lXXX':
which probably used to be 'l' before some query-replace ran amok.
In the non-varargs version of fatal, around line 781 of util.c,
there is
    message = mess(pat,a1,a2,a3,a4);
    XXX
    fputs(message,stderr);

Now for a couple of problems with automatic structure variables.
In perl_callback() in perl.c (lines 500 on) there is a definition
    BINOP myop;
of an automatic variable. There are two problems with this: firstly
it needs zeroing, since only a few of its fields are explicitly set:
   Zero(&myop, 1, BINOP);
does the trick. (Otherwise, junk in the op_flags field can cause very
strange behaviour.) Secondly, it does
   op = (OP *) &myop
and calls pp_entersubr(). At this point, myop goes out of scope
and can (and does) vanish leaving the op not done. The solution is
to define myop as
    static BINOP myop;
The other problem with perl_callback is that arguments don't get passed
to the called routine unless you add something like
    if (hasargs) myop.op_flags = OPf_STACKED;
I don't know if this is the `right' solution, but it seems to work.
Another automatic BINOP structure that can vanish from scope after
an op = (OP *)&myop is in sv_free() in sv.c at line 1303.
Again, it needs to be
    static BINOP myop;

The next problem might be due to Linux, or to my versions of
libraries and kernel (oldish) of Linux: there are two casts
of doubles to I32 which cause a SIGFPE and core dump my process.
One is at line 3723 of toke.c:
        value = atof(tokenbuf);
->      tryi32 = (I32)value;
        if (!floatit && (double)tryi32 == value)
            sv_setiv(sv,tryi32);
        else
            sv_setnv(sv,value);
and one is at line 111 of sv.c:
        if (SvIOK(sv))
            iv  = SvIV(sv);
        else
->          iv  = (I32)SvNV(sv);

I couldn't find a compile/link option to change this behaviour
(ANSI says the result of such a cast is undefined if it's out
of range for the int) so I surrounded the lines with
fpehand = signal(SIGFPE, SIG_IGN);
and
(void) signal(SIGFPE, fpehand);
with fpehand declared at the start of the block as
VOIDRET (*fpehand)();
That cures it (at significant overhead?).

Lastly, I don't know if this is a bug or a problem with the way I am
initialising my usersubs, but newUSUB() doesn't work unless I do
    allgvs = TRUE;
before calling newUSUB. Swapping the lines
    userinit();
    allgvs = TRUE;
would also cure this but, as I say, I might be missing some other
initialisation step.

--Malcolm

-- 
Malcolm Beattie <mbeattie@black.ox.ac.uk>
Oxford University Computing Services
"Widget. It's got a widget. A lovely widget. A widget it has got." --Jack Dee


Article 8664 of comp.lang.perl:
Xref: feenix.metronet.com comp.lang.perl:8664
Newsgroups: comp.lang.perl
Path: feenix.metronet.com!news.ecn.bgu.edu!usenet.ins.cwru.edu!howland.reston.ans.net!pipex!uknet!comlab.ox.ac.uk!mbeattie
From: mbeattie@black.ox.ac.uk (Malcolm Beattie)
Subject: How I write Perl5 usersubs
Message-ID: <1993Dec6.141322.4482@black.ox.ac.uk>
Originator: mbeattie@black
Organization: Oxford University Computing Services, Oxford, U.K.
Date: Mon, 6 Dec 1993 14:13:22 GMT
Lines: 248

This post explains how I write usersubs in Perl5. It is intended
to be both helpful for those that want to write their own C routines
called from Perl5 and also so that those who know more than I do
about how I'm *supposed* to write them can put me straight.
See my separate post for some fixes I applied to cure some bugs
(at least, I hope they are bugs :-).

Source file format

#include "EXTERN.h"
#include "perl.h"

int Foo P((int, int, int));

userinit()
{
    static char *filename = "fooperl.c";

    allgvs = TRUE; /* needed in Perl5alpha3 because of a bug (?) in perl.c */
    newUSUB("foo", 1234, Foo, filename);
}

int Foo(ix, sp, items)
int ix;
int sp;
int items;
{
    /* see later */
}

Compiling

Assume the above file, fooperl.c, is in a subdirectory of the
root of the Perl5 source tree. Then build fooperl.o with
    cc -I.. -g -c fooperl.c
and link with
    cc -o fooperl fooperl.o ../perl.o ../uperl.o -L.. -lperl -ldbm -lm
Now fooperl is an ordinary Perl, except that you have the extra
command &foo() (notice the `&').

Perl's stack

All arguments to usubs and the resulting returned values
are passed in and out on one global stack. Each entry on
the stack is of type SV* (see later). The stack's location
is available via the global variable `stack'. The stack
starts at AvARRAY(stack), although this value is usually
available in the global variable stack_base (it occasionally
needs refetching though---when the stack grows, it can be
realloc'd and thus move.) Internally, the global variable
stack_sp is the main stack pointer, but the offset from
stack_base gets passed in an argument to a usub and stack_sp
is recalculated from the offset returned, so a usub doesn't
need to use stack_sp if it doesn't want to. The values on the
stack are, as mentioned, of type (SV *) and the SV is Perl's
all-purpose receptacle for any entity. I guess that SV means
scalar value. Here are a few more guesses for various entities whose
names turn up in function calls and macros inside and outside usubs:
PV   pointer value  (usually a char * for strings)
CV   code value
AV   array value
GV   glob value (?)
HV   hash value
IV   integer value
NV   numeric value (double)

SV is a typedef for `struct sv' (see sv.h) , whose main fields
of interest are

ANY     sv_any;   /* ANY is a typedef for `union any' */
SVTYPE  sv_type;  /* SVTYPE is effectively an enum type */
U8      sv_flags; /* U8 is unsigned char. Not usually an interesting field */

The union ANY (see perl.h) has fields
void *any_ptr;
I32  any_i32;    /* an arithmetic type of at least 32 bits */      

SVTYPE above is actually only (a typedef for an) enum type
when DEBUGGING is on, otherwise it's U8, to save space.
The sv_type field records what the SV is `holding' at the time
(it can hold more than one thing at the same time which saves
on multiple conversions to and from different types.) Before
explaining how to convert between an SV as it arrives fresh from
Perl's stack to your usub and the type that you really want, I'll
explain how you pass arguments in and out of your usub.


Arguments to usubs

Here is how I write the start to usub Foo above:

int Foo(ix, sp, items)
int ix;
int sp;
int items;
{
    SV **st = stack_base + sp - items;

On entry to your usub, ix contains the client data that you
cached when you did the newUSUB (1234 if you look at our newUSUB
way above), items contains the number of arguments passed in and
sp the offset from stack_base to the *last* argument. For example,
calling &foo("ONE", "TWO", "THREE") would call Foo with the
stack as follows:

         +-------+
         |       | <--- stack_base
         +-------+
           ...
         +-------+
  st[0]  |       | <--- stack_base + sp - items
         +-------+
  st[1]  | ONE   | 
         +-------+
  st[2]  | TWO   |
         +-------+
  st[3]  | THREE | <--- stack_base + sp
         +-------+

Notice that there is a gap in st[0] for your first return
argument. Return arguments should be put in positions
st[0], st[1], st[2], ... (the stack must be grown past
stack_base + sp if necessary---notice that there's always
room for one return value) and the usub should return
the offset from stack_base of the last return arg
(i.e. (sp - items) if there's only one).
To extend the stack to make room for replycount return
arguments, I do the following:
    
    av_store(stack, sp - items + replycount, Nullsv);
    stack_base = AvARRAY(stack);
    st = stack_base + sp - items; /* recover stack pointer */

which seems to work. All the macros which get used internally
to manipulate the stack (dSP, POPs, EXTEND, PUSHs...) rely on
sp being a *pointer* to the stack position, and I prefer to
get the arguments as st[1], st[2], ... rather than pop them
in reverse. This may not be the way I'm supposed to do it.

Getting arguments in to usubs

The arguments st[1], st[2], ... above arrive as type (SV*)
and need their values obtained as the required type before use.
Here are some of the types which I have discovered and found
useful, and the macros that I found to get at them.
Say sv is of type (SV*), perhaps an argument to a usub that
you've just grabbed from the stack.

0)  If you passed in `undef' as an argument, you must check
    for it before anything else.
    if (sv == &sv_undef) ...
1)  If you know it's a string (or don't want to check), then
    char *str = SvPV(sv);
    This will give you an empty string (not NULL) if sv was,
    in fact, some other type. If sv was `undef', then you get
    a core dump (if I remember correctly) so check for that first.
    You can probably confirm that it's a string with something like
    if (SvTYPE(sv) >= SVt_PV) ...
    I was going to suggest (SvTYPE(sv) == SVt_PV) but I've just
    realised that sv holding multiple types may affect that.
    There's also a macro SvPOK(sv) which checks the sv_flags
    field of *sv but I could't get that to work.

The next two cover numeric (i.e. double) and int.
Warning: these are not interchangeable at usub level. You need
to do the right thing for each type. For example,
&foo(42) will pass in an int, &foo(12.34) will pass in a double but
&foo(6 + 15) will pass in a *double* 21. I suppose that's because
Perl arithmetic gets promoted to doubles all the time.

2)  If you know it's a numeric (i.e. double), then
    double d = SvNV(sv);
    The relevant types seem to be SVt_NV and SVt_PVNV (?).
    Again, there's a macro SVNOK(sv) which I couldn't get to work.
3)  If you know it's an int, then
    I32 i = SvIV(sv);
    The relevant types seem to be SVt_IV and SVt_PVIV (?).
    Again, there's a macro SVIOK(sv) which I couldn't get to work.
There's even a macro SvNIOK(sv) but I couldn't get that to
work either. Just to complicate passing in numbers in even further,
notice that if you pass in a string "456" or "123.4" to a usub,
the above macros won't convert it for you. There is, however,
a routine looks_like_number(sv) in doio.c which will take an sv
string and return true if it looks like a number. If it *does*,
then you can call sv_2nv(sv) which returns a double.

4)  If (SvTYPE(sv) == SVt_REF) then someone passed in a ref
    to something (e.g. \@foo, \%bar, \&baz). Take a look at
    do_print(sv, fp) in doio.c which produces a printable
    representation of an sv and prints it to fp. It uses
    sv_2pv in sv.c which does the conversion of an sv to
    a string representation.
5)  Suppose someone passes in \&somesub (or even "somesub")
    to your usub, and you want to call Perl &somesub from
    you usub. Well, perl_callv and perl_callback in perl.c
    will cope with a string name ("somesub") (at least, once
    the bugs in Perl5alpha3 are fixed---see my separate post.)
    To cope with a sub ref in sv and get its full name
    (e.g. \&somesub to "main'somesub"), do something like

    HV *hv;
    GV *gv, *cachegv;
    char *subname;
    cachegv = (GV *) sv_2cv(sv, &stash, &gv, FALSE);
    if (cachegv == Nullgv)
        fatal("Wasn't a subref");
    gv_fullname(sv, cachegv);
    subname = SvPV(sv);
    
Returning arguments from usubs

I haven't checked in for certain in Perl5 how to check if
you're being called in an array context. From a quick look
at the code, the macro GIMME is probably what to use.
    if (GIMME == G_ARRAY) ...
To store ordinary data as an sv on the stack (say st[i]), I use:
1) To return a char *str (the string is copied for you),
    sv_setpv(st[i], str);

2) To return a double d (an ordinary `1 for success' should
   probably be of this type):
    sv_setnv(st[i], d);

3) To return an int myint,
    sv_setiv(st[i], (I32) myint);

Calling back to perl from a usub

The routines perl_callv and perl_callback in perl.c work OK
once a few things are fixed (see separate posting.)
I'll probably try putting together a routine which calls
back to a cached gv without doing a gv_fullname and then
a perl_callback (which calls gv_fetchpv). This may well be
faster and will probably be useful so that I can cache a
gv in a widget record in tkperl and optimise callbacks that way.
One advantage of tkperl is that fast event callbacks should
make a tkperl application `feel' faster than a Tcl/Tk one.

If anyone knows anything about Perl5 internals and wants to
correct or expand on any of the above, please do so---that's
partly why I'm posting.

--Malcolm

-- 
Malcolm Beattie <mbeattie@black.ox.ac.uk>
Oxford University Computing Services
"Widget. It's got a widget. A lovely widget. A widget it has got." --Jack Dee


Article 8702 of comp.lang.perl:
Xref: feenix.metronet.com comp.lang.perl:8702
Newsgroups: comp.lang.perl
Path: feenix.metronet.com!news.utdallas.edu!corpgate!bnrgate!nott!torn!howland.reston.ans.net!pipex!uknet!comlab.ox.ac.uk!mbeattie
From: mbeattie@black.ox.ac.uk (Malcolm Beattie)
Subject: Re: A few bug reports/fixes for Perl5alpha3
Message-ID: <1993Dec7.103829.15575@black.ox.ac.uk>
Originator: mbeattie@black
Organization: Oxford University Computing Services, Oxford, U.K.
References: <1993Dec6.101946.20854@black.ox.ac.uk>
Date: Tue, 7 Dec 1993 10:38:29 GMT
Lines: 60

In article <1993Dec6.101946.20854@black.ox.ac.uk> mbeattie@black.ox.ac.uk (Malcolm Beattie) writes:
>Over the last two weekends I have been getting started with
>writing tkperl with Perl5 usersubs (not relying on Tcl for the
>interface---I'll post a status report separately.).
>In the process, I've looked hard at how to do usersubs. Here are
>a few bugs that I came across on the way. I'll post separately
>to explain what I know about Perl 5 usersubs since it has changed
>a fair amount from Perl 4 and there weren't extensive examples
>there anyway. This is perl5alpha3.
[...]
>Now for a couple of problems with automatic structure variables.
>In perl_callback() in perl.c (lines 500 on) there is a definition
>    BINOP myop;
>of an automatic variable. There are two problems with this: firstly
>it needs zeroing, since only a few of its fields are explicitly set:
>   Zero(&myop, 1, BINOP);
>does the trick. (Otherwise, junk in the op_flags field can cause very
>strange behaviour.) 

This is true.

>		     Secondly, it does
>   op = (OP *) &myop
>and calls pp_entersubr(). At this point, myop goes out of scope
>and can (and does) vanish leaving the op not done. The solution is
>to define myop as
>    static BINOP myop;

This explanation is rubbish---of *course* it's possible to do
   int foo; do_something_to(&foo);
The strange thing is that I singlestepped through the code
with gdb under Linux and fields of *op did vanish on entering
pp_entersubr. Adding the `static' cured it (but stops perl_callback
from being reentrant between calls which do/do not take arguments).
I don't know the real explanation: I can't reproduce the failure
under SunOS 4.1.1.

>Another automatic BINOP structure that can vanish from scope after
>an op = (OP *)&myop is in sv_free() in sv.c at line 1303.
>Again, it needs to be
>    static BINOP myop;

Again: wrong explanation but I'm sure I saw the problem...

One more typo I noticed (at least, I hope it is...):
In sv.c there's a function
   I32 sv_2iv(sv)
which at lines 529--530 has:
        if (SvPOK(sv) && SvLEN(sv))
            return atof(SvPV(sv));
Presumably that should be atol [sic] as used lower in the
function (atol not atoi because I32 is long on machines
with sizeof int < 4).

--Malcolm

-- 
Malcolm Beattie <mbeattie@black.ox.ac.uk>
Oxford University Computing Services
"Widget. It's got a widget. A lovely widget. A widget it has got." --Jack Dee


Article 8707 of comp.lang.perl:
Xref: feenix.metronet.com comp.lang.perl:8707
Newsgroups: comp.lang.perl
Path: feenix.metronet.com!news.ecn.bgu.edu!usenet.ins.cwru.edu!howland.reston.ans.net!newsserver.jvnc.net!netnews.upenn.edu!netnews.cc.lehigh.edu!lafcol!doughera
From: doughera@lafcol.lafayette.edu (Andy Dougherty)
Subject: Re: A few bug reports/fixes for Perl5alpha3
Originator: news@lafcol
Message-ID: <1993Dec7.142911.42765@Lehigh.EDU>
Sender: usenet@Lehigh.EDU
Date: Tue, 7 Dec 1993 14:29:11 GMT
References: <1993Dec6.101946.20854@black.ox.ac.uk>
Nntp-Posting-Host: lafcol
Organization: Lafayette College, Easton PA
Lines: 31

In article <1993Dec6.101946.20854@black.ox.ac.uk> mbeattie@black.ox.ac.uk (Malcolm Beattie) writes:
> [ . . . ]
>This is perl5alpha3.
>
>First a couple of typos.  [ omitted here. ]
>
>The next problem might be due to Linux, or to my versions of
>libraries and kernel (oldish) of Linux: there are two casts
>of doubles to I32 which cause a SIGFPE and core dump my process.
>One is at line 3723 of toke.c:
>->      tryi32 = (I32)value;
>and one is at line 111 of sv.c:
>->          iv  = (I32)SvNV(sv);
>

This appears to be generic in 386-based Unix (Or at least SysV-flavored
Unix.)  I have the same problem on Interactive SysVr3 version 3.0.1.
It shows up as a failure in the base/lex.t test.

The best solution I've thought of is to do something like what is done
for CAST_NEG_FLOAT in util.c, where special code is used if the
compiler/operating system/cpu can't handle casting of weird negative
floats to long.  I haven't written one yet, but the version used in
util.c should be a reasonable model.  (I may not have the exact names
right--my perl5 sources are offline because I needed the disk space to
build and install the latest gcc.)

-- 
Andy Dougherty
INTERNET:  doughera@lafcol.lafayette.edu
BITNET:    doughera@lafayett


Article 8757 of comp.lang.perl:
Xref: feenix.metronet.com comp.lang.perl:8757
Newsgroups: comp.lang.perl
Path: feenix.metronet.com!news.ecn.bgu.edu!usenet.ins.cwru.edu!magnus.acs.ohio-state.edu!math.ohio-state.edu!sol.ctr.columbia.edu!emory!europa.eng.gtefsd.com!uunet!olivea!pagesat!news.cerf.net!netlabs!lwall
From: lwall@netlabs.com (Larry Wall)
Subject: Re: A few bug reports/fixes for Perl5alpha3
Message-ID: <1993Dec9.004817.12233@netlabs.com>
Sender: news@netlabs.com
Nntp-Posting-Host: scalpel.netlabs.com
Organization: NetLabs, Inc.
References: <1993Dec6.101946.20854@black.ox.ac.uk> <1993Dec7.103829.15575@black.ox.ac.uk>
Date: Thu, 9 Dec 1993 00:48:17 GMT
Lines: 19

In article <1993Dec7.103829.15575@black.ox.ac.uk> mbeattie@black.ox.ac.uk (Malcolm Beattie) writes:
: One more typo I noticed (at least, I hope it is...):
: In sv.c there's a function
:    I32 sv_2iv(sv)
: which at lines 529--530 has:
:         if (SvPOK(sv) && SvLEN(sv))
:             return atof(SvPV(sv));
: Presumably that should be atol [sic] as used lower in the
: function (atol not atoi because I32 is long on machines
: with sizeof int < 4).

Yup, cut and paste error.  Thanks.  Actually, it should probably be

	return (I32)atol(SvPV(sv));

on the off chance that you're on an Alpha.  I haven't quite decided how
to deal with 64-bit longs yet...

Larry


Article 8755 of comp.lang.perl:
Xref: feenix.metronet.com comp.lang.perl:8755
Newsgroups: comp.lang.perl
Path: feenix.metronet.com!news.ecn.bgu.edu!usenet.ins.cwru.edu!eff!news.umbc.edu!europa.eng.gtefsd.com!wx.gtegsc.com!news.cerf.net!netlabs!lwall
From: lwall@netlabs.com (Larry Wall)
Subject: Re: A few bug reports/fixes for Perl5alpha3
Message-ID: <1993Dec8.195927.7071@netlabs.com>
Sender: news@netlabs.com
Nntp-Posting-Host: scalpel.netlabs.com
Organization: NetLabs, Inc.
References: <1993Dec6.101946.20854@black.ox.ac.uk>
Date: Wed, 8 Dec 1993 19:59:27 GMT
Lines: 108

In article <1993Dec6.101946.20854@black.ox.ac.uk> mbeattie@black.ox.ac.uk (Malcolm Beattie) writes:
: Over the last two weekends I have been getting started with
: writing tkperl with Perl5 usersubs (not relying on Tcl for the
: interface---I'll post a status report separately.).
: In the process, I've looked hard at how to do usersubs. Here are
: a few bugs that I came across on the way. I'll post separately
: to explain what I know about Perl 5 usersubs since it has changed
: a fair amount from Perl 4 and there weren't extensive examples
: there anyway. This is perl5alpha3.
: 
: First a couple of typos.
: On line 243 of doop.c, we find
:             case 'lXXX':
: which probably used to be 'l' before some query-replace ran amok.

Yup, I already spotted that one.

: In the non-varargs version of fatal, around line 781 of util.c,
: there is
:     message = mess(pat,a1,a2,a3,a4);
:     XXX
:     fputs(message,stderr);

That one I hadn't spotted.

: Now for a couple of problems with automatic structure variables.
: In perl_callback() in perl.c (lines 500 on) there is a definition
:     BINOP myop;
: of an automatic variable. There are two problems with this: firstly
: it needs zeroing, since only a few of its fields are explicitly set:
:    Zero(&myop, 1, BINOP);
: does the trick. (Otherwise, junk in the op_flags field can cause very
: strange behaviour.)

Fair enough.

: Secondly, it does
:    op = (OP *) &myop
: and calls pp_entersubr(). At this point, myop goes out of scope
: and can (and does) vanish leaving the op not done. The solution is
: to define myop as
:     static BINOP myop;

I don't buy this.  What do you mean by "goes out of scope"?  It
certainly doesn't go out of the dynamic scope--myop exists on the stack
for as long as the subroutine is being called.  If you can't pass
a pointer to a stack value into a function your C compiler is in trouble.

On top of which, you've just precluded any recursive use of perl_callback().

: The other problem with perl_callback is that arguments don't get passed
: to the called routine unless you add something like
:     if (hasargs) myop.op_flags = OPf_STACKED;
: I don't know if this is the `right' solution, but it seems to work.

It looks reasonable to me.

: Another automatic BINOP structure that can vanish from scope after
: an op = (OP *)&myop is in sv_free() in sv.c at line 1303.
: Again, it needs to be
:     static BINOP myop;

Again, I don't buy that one.  Is there something I'm not seeing?

: The next problem might be due to Linux, or to my versions of
: libraries and kernel (oldish) of Linux: there are two casts
: of doubles to I32 which cause a SIGFPE and core dump my process.
: One is at line 3723 of toke.c:
:         value = atof(tokenbuf);
: ->      tryi32 = (I32)value;
:         if (!floatit && (double)tryi32 == value)
:             sv_setiv(sv,tryi32);
:         else
:             sv_setnv(sv,value);
: and one is at line 111 of sv.c:
:         if (SvIOK(sv))
:             iv  = SvIV(sv);
:         else
: ->          iv  = (I32)SvNV(sv);
: 
: I couldn't find a compile/link option to change this behaviour
: (ANSI says the result of such a cast is undefined if it's out
: of range for the int) so I surrounded the lines with
: fpehand = signal(SIGFPE, SIG_IGN);
: and
: (void) signal(SIGFPE, fpehand);
: with fpehand declared at the start of the block as
: VOIDRET (*fpehand)();
: That cures it (at significant overhead?).

I'm not sure what to do with that one in the long term.

: Lastly, I don't know if this is a bug or a problem with the way I am
: initialising my usersubs, but newUSUB() doesn't work unless I do
:     allgvs = TRUE;
: before calling newUSUB. Swapping the lines
:     userinit();
:     allgvs = TRUE;
: would also cure this but, as I say, I might be missing some other
: initialisation step.

I'll reverse them.  In fact, I may remove allgvs entirely--the need for
it has largely gone away, now that most magical variables are magicalized
on first mention, rather than just before execution.

Thanks.

Larry


Article 8756 of comp.lang.perl:
Xref: feenix.metronet.com comp.lang.perl:8756
Newsgroups: comp.lang.perl
Path: feenix.metronet.com!news.ecn.bgu.edu!usenet.ins.cwru.edu!eff!news.umbc.edu!europa.eng.gtefsd.com!wx.gtegsc.com!news.cerf.net!netlabs!lwall
From: lwall@netlabs.com (Larry Wall)
Subject: Re: How I write Perl5 usersubs
Message-ID: <1993Dec8.205923.7916@netlabs.com>
Sender: news@netlabs.com
Nntp-Posting-Host: scalpel.netlabs.com
Organization: NetLabs, Inc.
References: <1993Dec6.141322.4482@black.ox.ac.uk>
Date: Wed, 8 Dec 1993 20:59:23 GMT
Lines: 229

In article <1993Dec6.141322.4482@black.ox.ac.uk> mbeattie@black.ox.ac.uk (Malcolm Beattie) writes:
:     allgvs = TRUE; /* needed in Perl5alpha3 because of a bug (?) in perl.c */

That'll have to be taken back out for alpha4.

: Compiling
: 
: Assume the above file, fooperl.c, is in a subdirectory of the
: root of the Perl5 source tree. Then build fooperl.o with
:     cc -I.. -g -c fooperl.c
: and link with
:     cc -o fooperl fooperl.o ../perl.o ../uperl.o -L.. -lperl -ldbm -lm
: Now fooperl is an ordinary Perl, except that you have the extra
: command &foo() (notice the `&').

The & will be optional in Perl 5.  You can use all predefined routines
(including usersubs) as if they were builtins.

: Perl's stack
: 
: The values on the
: stack are, as mentioned, of type (SV *) and the SV is Perl's
: all-purpose receptacle for any entity. I guess that SV means
: scalar value.

Yes.  Internally, everything is an SV* of some sort or other.  (Except
filehandles, and they probably ought to be.)

: Here are a few more guesses for various entities whose
: names turn up in function calls and macros inside and outside usubs:
: GV   glob value (?)

That's correct.

: SV is a typedef for `struct sv' (see sv.h) , whose main fields
: of interest are
: 
: ANY     sv_any;   /* ANY is a typedef for `union any' */
: SVTYPE  sv_type;  /* SVTYPE is effectively an enum type */
: U8      sv_flags; /* U8 is unsigned char. Not usually an interesting field */
: 
: The union ANY (see perl.h) has fields
: void *any_ptr;
: I32  any_i32;    /* an arithmetic type of at least 32 bits */      

It turned out I didn't need the ANY there, so sv_any is back to being a
simple void*.

: SVTYPE above is actually only (a typedef for an) enum type
: when DEBUGGING is on, otherwise it's U8, to save space.

Yeah, gdb has nicer printouts when you use an enum, but ANSI C likes to
use a whole integer to store it.

: Notice that there is a gap in st[0] for your first return
: argument. Return arguments should be put in positions
: st[0], st[1], st[2], ...

Yes, st[0] is where the subroutine reference was passed in.  I could have
made Perl 5 push the sub reference on after the arguments, but Perl 4
already was working this way, so I left it alone.

: To extend the stack to make room for replycount return
: arguments, I do the following:
:     
:     av_store(stack, sp - items + replycount, Nullsv);
:     stack_base = AvARRAY(stack);
:     st = stack_base + sp - items; /* recover stack pointer */

You should also recalculate stack_sp and stack_max.  We should supply
a macro to do this--see EXTEND in pp.h.  Note that EXTEND just recalculates
sp, which later gets poked back into stack_sp by the RETURN macro, which
calls the PUTBACK macro.

: which seems to work. All the macros which get used internally
: to manipulate the stack (dSP, POPs, EXTEND, PUSHs...) rely on
: sp being a *pointer* to the stack position, and I prefer to
: get the arguments as st[1], st[2], ... rather than pop them
: in reverse. This may not be the way I'm supposed to do it.

I intend that the old mechanism still work with minimal modification.
It would also be possible to write using the pp.c style, though we'd
have to redefine the NORMAL macro.

: 0)  If you passed in `undef' as an argument, you must check
:     for it before anything else.
:     if (sv == &sv_undef) ...

If you want to know if the value is defined, use SvOK(sv).  There
are undefined values that aren't &sv_undef.

: 1)  If you know it's a string (or don't want to check), then
:     char *str = SvPV(sv);
:     This will give you an empty string (not NULL) if sv was,
:     in fact, some other type. If sv was `undef', then you get
:     a core dump (if I remember correctly) so check for that first.

If you want it converted automatically, use SvPVn instead of SvPV.  This
will do the right thing on undef.  (The "n" stands for new, as in, make
a new one if there isn't one.  Many other macros come in "n" and non-"n"
versions.)

:     You can probably confirm that it's a string with something like
:     if (SvTYPE(sv) >= SVt_PV) ...

If you want to confirm it's a defined string, use SvPOK(sv).  Similarly,
SvNOK(sv) says there's a numeric (double) value, and SvIOK(sv) says
there's an integer value.  Usually though you just use SvPVn(sv),
SvNVn(sv) and SvIVn(sv) if you want a char*, a double, or an I32
(respectively) and the conversion is automatic.

:     I was going to suggest (SvTYPE(sv) == SVt_PV) but I've just
:     realised that sv holding multiple types may affect that.
:     There's also a macro SvPOK(sv) which checks the sv_flags
:     field of *sv but I could't get that to work.

Oughta work.  We need to make it work if it doesn't.

: The next two cover numeric (i.e. double) and int.
: Warning: these are not interchangeable at usub level. You need
: to do the right thing for each type. For example,
: &foo(42) will pass in an int, &foo(12.34) will pass in a double but
: &foo(6 + 15) will pass in a *double* 21. I suppose that's because
: Perl arithmetic gets promoted to doubles all the time.

Yes.  Though the optimizer may fix some of those someday.  You'll note in
opcode.pl that there's an intadd opcode, which is heavily underused.

: 2)  If you know it's a numeric (i.e. double), then
:     double d = SvNV(sv);
:     The relevant types seem to be SVt_NV and SVt_PVNV (?).
:     Again, there's a macro SVNOK(sv) which I couldn't get to work.

Gotta make it work.  But use SvNVn.

: 3)  If you know it's an int, then
:     I32 i = SvIV(sv);
:     The relevant types seem to be SVt_IV and SVt_PVIV (?).
:     Again, there's a macro SVIOK(sv) which I couldn't get to work.

Gotta make it work.  But use SvIVn.

: There's even a macro SvNIOK(sv) but I couldn't get that to
: work either. Just to complicate passing in numbers in even further,
: notice that if you pass in a string "456" or "123.4" to a usub,
: the above macros won't convert it for you. There is, however,
: a routine looks_like_number(sv) in doio.c which will take an sv
: string and return true if it looks like a number. If it *does*,
: then you can call sv_2nv(sv) which returns a double.

If you use the "n" macros this is all automatic.

: 4)  If (SvTYPE(sv) == SVt_REF) then someone passed in a ref
:     to something (e.g. \@foo, \%bar, \&baz). Take a look at
:     do_print(sv, fp) in doio.c which produces a printable
:     representation of an sv and prints it to fp. It uses
:     sv_2pv in sv.c which does the conversion of an sv to
:     a string representation.

The incantation for dereferencing a reference is

	sv = (SV*)SvANY(sv);

Then you just treat sv as you ordinarily would.

: 5)  Suppose someone passes in \&somesub (or even "somesub")
:     to your usub, and you want to call Perl &somesub from
:     you usub. Well, perl_callv and perl_callback in perl.c
:     will cope with a string name ("somesub") (at least, once
:     the bugs in Perl5alpha3 are fixed---see my separate post.)
:     To cope with a sub ref in sv and get its full name
:     (e.g. \&somesub to "main'somesub"), do something like
: 
:     HV *hv;
:     GV *gv, *cachegv;
:     char *subname;
:     cachegv = (GV *) sv_2cv(sv, &stash, &gv, FALSE);
:     if (cachegv == Nullgv)
:         fatal("Wasn't a subref");
:     gv_fullname(sv, cachegv);
:     subname = SvPV(sv);

We need a variant on perl_callback that takes a CV* instead of a name.
Why use the pointer to do the lookup when you already have the pointer?

: Returning arguments from usubs
: 
: I haven't checked in for certain in Perl5 how to check if
: you're being called in an array context. From a quick look
: at the code, the macro GIMME is probably what to use.
:     if (GIMME == G_ARRAY) ...

That should work.

: To store ordinary data as an sv on the stack (say st[i]), I use:
: 1) To return a char *str (the string is copied for you),
:     sv_setpv(st[i], str);
: 
: 2) To return a double d (an ordinary `1 for success' should
:    probably be of this type):
:     sv_setnv(st[i], d);
: 
: 3) To return an int myint,
:     sv_setiv(st[i], (I32) myint);

That's right.  If you know the length of a char*, use sv_setpvn(st[i],str,len).
Hmm.  The "n" doesn't mean the same thing there.  Hmm...

: Calling back to perl from a usub
: 
: The routines perl_callv and perl_callback in perl.c work OK
: once a few things are fixed (see separate posting.)
: I'll probably try putting together a routine which calls
: back to a cached gv without doing a gv_fullname and then
: a perl_callback (which calls gv_fetchpv). This may well be
: faster and will probably be useful so that I can cache a
: gv in a widget record in tkperl and optimise callbacks that way.
: One advantage of tkperl is that fast event callbacks should
: make a tkperl application `feel' faster than a Tcl/Tk one.

It'd be even faster if instead of the GV you cache the CV.  But then
you lose name info if you want to use "caller".

: If anyone knows anything about Perl5 internals and wants to
: correct or expand on any of the above, please do so---that's
: partly why I'm posting.

Maybe I should get you guys to go through and insert comments for me...  :-)

Larry


Article 8794 of comp.lang.perl:
Xref: feenix.metronet.com comp.lang.perl:8794
Newsgroups: comp.lang.perl
Path: feenix.metronet.com!news.ecn.bgu.edu!usenet.ins.cwru.edu!howland.reston.ans.net!pipex!uknet!comlab.ox.ac.uk!mbeattie
From: mbeattie@black.ox.ac.uk (Malcolm Beattie)
Subject: Re: A few bug reports/fixes for Perl5alpha3
Message-ID: <1993Dec10.112924.6456@black.ox.ac.uk>
Originator: mbeattie@black
Organization: Oxford University Computing Services, Oxford, U.K.
References: <1993Dec6.101946.20854@black.ox.ac.uk> <1993Dec8.195927.7071@netlabs.com>
Date: Fri, 10 Dec 1993 11:29:24 GMT
Lines: 78

In article <1993Dec8.195927.7071@netlabs.com> lwall@netlabs.com (Larry Wall) writes:
>In article <1993Dec6.101946.20854@black.ox.ac.uk> mbeattie@black.ox.ac.uk (Malcolm Beattie) writes:
>: Now for a couple of problems with automatic structure variables.
>: In perl_callback() in perl.c (lines 500 on) there is a definition
>:     BINOP myop;
>: of an automatic variable. There are two problems with this: firstly
>: it needs zeroing, since only a few of its fields are explicitly set:
>:    Zero(&myop, 1, BINOP);
>: does the trick. (Otherwise, junk in the op_flags field can cause very
>: strange behaviour.)
>
>Fair enough.
>
>: Secondly, it does
>:    op = (OP *) &myop
>: and calls pp_entersubr(). At this point, myop goes out of scope
>: and can (and does) vanish leaving the op not done. The solution is
>: to define myop as
>:     static BINOP myop;
>
>I don't buy this.  What do you mean by "goes out of scope"?  It
>certainly doesn't go out of the dynamic scope--myop exists on the stack
>for as long as the subroutine is being called.  If you can't pass
>a pointer to a stack value into a function your C compiler is in trouble.

The day after I wrote this I realised my explanation was total
rubbish but my posted followup seems to have vanished without
trace after the NNTP server's disk filled up. Since then, I've
discovered the (rather subtle) cause, and it's cured quite a few
little problems I'd been having which I'd assumed were due to my
misunderstanding how to drive Perl5.

I built Perl5 with -DDEBUGGING but didn't compile my own source
files with -DDEBUGGING. [Oh God, it all sounds so obvious now I
write it down.] As mentioned elsewhere, the debugging flag changes
the types used in various structures from enum (int) to char or
short. I had set myop.op_flags to a non-zero number, done
op = (OP *)&myop and singlestepping in gdb into pp_entersubr
suddenly found that op->op_flags was zero. Most mysterious.
With the different alignment constraints, the fields of the
structure had been arranged differently/padded so that the op_flags
field of *my* BINOP structure was different from that in the
already compiled Perl object code. I hope this sorry tale
prevents others from running up against the same problem: always
compile your own code with DEBUGGING set the same as the Perl build.

>On top of which, you've just precluded any recursive use of perl_callback().

Interestingly, the op structure stays the same (other than the
op_flags according as whether you do/don't want to pass args.
I may just define a global BINOP argop and BINOP noargop to
save having a new one each time: I've got to do a CV or GV version
of perl_callback anyway for Tk event callbacks.

>: I couldn't find a compile/link option to change this behaviour
>: (ANSI says the result of such a cast is undefined if it's out
>: of range for the int) so I surrounded the lines with
>: fpehand = signal(SIGFPE, SIG_IGN);
>: and
>: (void) signal(SIGFPE, fpehand);
>: with fpehand declared at the start of the block as
>: VOIDRET (*fpehand)();
>: That cures it (at significant overhead?).
>
>I'm not sure what to do with that one in the long term.

Maybe I'm just doing things the hard way. If nothing else is
worried about SIGFPE, then putting a single
(void) signal(SIGFPE, SIG_IGN);
at the top would probably cure it.

--Malcolm


-- 
Malcolm Beattie <mbeattie@black.ox.ac.uk>
Oxford University Computing Services
"Widget. It's got a widget. A lovely widget. A widget it has got." --Jack Dee


