package Daje::Tools::JWT;
use Mojo::Base -base,  -signatures, -async_await;
use v5.42;

# NAME
# ====
#
# Daje::Tools::JWT - It's module for JWT's
#
# SYNOPSIS
# ========
#
#     use Daje::Tools::JWT;
#
# DESCRIPTION
# ===========
#
# Daje::Tools::JWT is ...
#
# LICENSE
# =======
#
# Copyright (C) janeskil1525.
#
# This library is free software; you can redistribute it and/or modify
# it under the same terms as Perl itself.
#
# AUTHOR
# ======
#
# janeskil1525 E<lt>janeskil1525@gmail.comE<gt>
#
#

use Mojo::JWT;

our $VERSION = "0.10";

has 'secret' => qw { lK1leAbOxGmUKdVmuMKbJtD7ru1wd2V9Y5e58zLPlL5UI4GP1AETmd7eZ3MRZEP };

async sub encode_jwt_p($self, $claim) {

    my $secret = $self->secret();
    my $jwt = Mojo::JWT->new(claims => $claim, secret => $secret)->encode;

    return $jwt
}

async sub decode_jwt_p($self, $jwt) {

    my $secret = $self->secret();
    my $claims = Mojo::JWT->new(secret => $secret)->decode($jwt);

    return $claims;
}

sub encode_jwt($self, $claim) {

    my $secret = $self->secret();
    my $jwt = Mojo::JWT->new(claims => $claim, secret => $secret)->encode;

    return $jwt
}

sub decode_jwt($self, $jwt) {

    my $secret = $self->secret();
    my $claims = Mojo::JWT->new(secret => $secret)->decode($jwt);

    return $claims;
}

sub companise_pkey ($self, $token) {

    my $jwt_hash = $self->decode_jwt($token);

    return $jwt_hash->{companies_companies_pkey};
}

sub companies_users_pkey ($self, $token) {

    my $jwt_hash = $self->decode_jwt($token);

    return ($jwt_hash->{companies_companies_pkey}, $jwt_hash->{users_users_pkey});
}


1;
__END__




#################### pod generated by Pod::Autopod - keep this line to make pod updates possible ####################

=head1 NAME


Daje::Tools::JWT - It's module for JWT's



=head1 SYNOPSIS


    use Daje::Tools::JWT;



=head1 DESCRIPTION


Daje::Tools::JWT is ...



=head1 REQUIRES

L<Mojo::JWT> 

L<Data::Dumper> 

L<Mojo::Base> 


=head1 METHODS

=head2 companies_users_pkey

 companies_users_pkey();

=head2 companise_pkey

 companise_pkey();

=head2 decode_jwt($self,

 decode_jwt($self,();

=head2 encode_jwt($self,

 encode_jwt($self,();


=head1 AUTHOR


janeskil1525 E<lt>janeskil1525@gmail.comE<gt>




=head1 LICENSE


Copyright (C) janeskil1525.

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.



=cut

