package WebService::TypePad::Object::Base;
use strict;
use warnings;
use WebService::TypePad::Util::Coerce;
use base qw(WebService::TypePad::Object);

1;

=head1 NAME

WebService::TypePad::Object::Base - Perl representation of TypePad's Base object type

=head1 SYNOPSIS

    use WebService::TypePad::Object::Base;
    my $base = WebService::TypePad::Object::Base->new();

=head1 DESCRIPTION

This is a Perl representation of TypePad's Base object type.
For more information about this type and its parameters, see L<the documentation on TypePad's developer site|http://www.typepad.com/services/apidocs/objecttypes/Base>.

=head1 PROPERTIES

Each of these properties has an accessor method which will retrieve the property's value when called with no arguments or set the property's value when called with one argument.

=head1 SEE ALSO

=over 1

=item * L<http://www.typepad.com/services/apidocs/objecttypes/Base>

=back
