/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock.memcached.protocol;

import java.nio.ByteBuffer;
import org.couchbase.mock.memcached.protocol.BinaryCommand;
import org.couchbase.mock.memcached.protocol.ErrorCode;

public class BinaryResponse {
    private static final byte MAGIC = -127;
    private static final byte DATA_TYPE = 0;
    final ByteBuffer buffer;

    BinaryResponse(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    BinaryResponse(BinaryCommand command, ErrorCode errorCode, int extraLength, int keyLength, int dataLength, long cas) {
        this.buffer = BinaryResponse.createAndRewind(command, errorCode, extraLength, keyLength, dataLength, cas);
    }

    public BinaryResponse(BinaryCommand command, ErrorCode errorCode) {
        this.buffer = BinaryResponse.createAndRewind(command, errorCode, 0, 0, 0, 0L);
    }

    private static ByteBuffer createAndRewind(BinaryCommand command, ErrorCode errorCode, int extraLength, int keyLength, int dataLength, long cas) {
        ByteBuffer message = BinaryResponse.create(command, errorCode, extraLength, keyLength, dataLength, cas);
        message.rewind();
        return message;
    }

    static ByteBuffer create(BinaryCommand command, ErrorCode errorCode, int extraLength, int keyLength, int dataLength, long cas) {
        ByteBuffer message = ByteBuffer.allocate(24 + extraLength + keyLength + dataLength);
        message.put((byte)-127);
        message.put((byte)command.getComCode().cc());
        message.putShort((short)keyLength);
        message.put((byte)extraLength);
        message.put((byte)0);
        message.putShort(errorCode.value());
        message.putInt(dataLength + keyLength + extraLength);
        message.putInt(command.getOpaque());
        message.putLong(cas);
        return message;
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }
}

