/* SPDX-License-Identifier: GPL-2.0-only */

#ifndef _SOC_QUALCOMM_SC7280_ADDRESS_MAP_H_
#define _SOC_QUALCOMM_SC7280_ADDRESS_MAP_H_

#include <stdint.h>

#define AOSS_CC_BASE			0x0C2A0000
#define DISP_CC_BASE			0x0AF00000
#define GCC_BASE			0x00100000
#define L3_PLL_BASE			0x18284000
#define QSPI_BASE			0x088DC000
#define SHRM_SPROC_BASE			0x09051000
#define SILVER_PLL_BASE			0x18280000
#define TLMM_TILE_BASE			0x0F100000

/* SC7280 QSPI GPIO PINS */
#define QSPI_CS				GPIO(15)
#define QSPI_DATA_0			GPIO(12)
#define QSPI_DATA_1			GPIO(13)
#define QSPI_CLK			GPIO(14)

#define GPIO_FUNC_QSPI_DATA_0		GPIO12_FUNC_QSPI_DATA_0
#define GPIO_FUNC_QSPI_DATA_1		GPIO13_FUNC_QSPI_DATA_1
#define GPIO_FUNC_QSPI_CLK		GPIO14_FUNC_QSPI_CLK

/* SDHC TLMM Registers */
#define SDC1_TLMM_CFG_ADDR		0x0F1B3000
#define SDC2_TLMM_CFG_ADDR		0x0F1B4000

/*
 * QUP SERIAL ENGINE BASE ADDRESSES
 */
/* QUPV3_0 */
#define QUP_SERIAL0_BASE		0x00980000
#define QUP_SERIAL1_BASE		0x00984000
#define QUP_SERIAL2_BASE		0x00988000
#define QUP_SERIAL3_BASE		0x0098C000
#define QUP_SERIAL4_BASE		0x00990000
#define QUP_SERIAL5_BASE		0x00994000
#define QUP_SERIAL6_BASE		0x00998000
#define QUP_SERIAL7_BASE		0x0099C000
#define QUP_WRAP0_BASE			0x009C0000
#define QUP_0_GSI_BASE			0x00904000

/* QUPV3_1 */
#define QUP_SERIAL8_BASE		0x00A80000
#define QUP_SERIAL9_BASE		0x00A84000
#define QUP_SERIAL10_BASE		0x00A88000
#define QUP_SERIAL11_BASE		0x00A8C000
#define QUP_SERIAL12_BASE		0x00A90000
#define QUP_SERIAL13_BASE		0x00A94000
#define QUP_SERIAL14_BASE		0x00A98000
#define QUP_SERIAL15_BASE		0x00A9C000
#define QUP_WRAP1_BASE			0x00AC0000
#define QUP_1_GSI_BASE			0x00A04000

/* QUPV3_2 - Dummy Entry */
#define QUP_WRAP2_BASE			0x00000000

#define EPSSTOP_EPSS_TOP		0x18598000
#define EPSSFAST_BASE_ADDR		0x18580000

/*
 * USB BASE ADDRESSES
 */
#define HS_USB_PRIM_PHY_BASE		0x088e3000
#define QMP_PHY_QSERDES_COM_REG_BASE	0x088e9000
#define QMP_PHY_QSERDES_TX_REG_BASE	0x088e9200
#define QMP_PHY_QSERDES_RX_REG_BASE	0x088e9400
#define QMP_PHY_PCS_REG_BASE		0x088e9c00
#define USB_HOST_DWC3_BASE		0x0a60c100

/* PCIE_1 */
#define PCIE1_PCIE_PARF                 0x01C08000
#define PCIE1_GEN3X2_PCIE_DBI           0x40000000
#define PCIE1_GEN3X2_PCIE_ELBI          0x40000F20
#define PCIE1_GEN3X2_DWC_PCIE_DM_IATU   0x40001000
#define PCIE1_SPACE_END_ADDR		0x60000000
#define PCIE1_BCR			0x18D000

/* QMP PCIE_1 PHY */
#define PCIE_1_QMP_PHY			0x01C0E000

/* QMP PHY, Serdes,Tx, Rx and PCS register definitions */
#define PCIE1_QMP_PHY_PCS_COM		0x01C0EA00
#define PCE1_QPHY_SERDES		0x01C0E000
#define PCE1_QPHY_TX0			0x01C0E200
#define PCE1_QPHY_RX0			0x01C0E400
#define PCE1_QPHY_TX1			0x01C0E600
#define PCE1_QPHY_RX1			0x01C0E800
#define PCE1_QPHY_PCS_MISC		0x01C0EE00

/* PHY BCR */
#define GCC_PCIE_1_PHY_BCR		0x18E01C

/* eMMC base address */
#define SDC1_HC_BASE 0x007C4000

#endif /*  __SOC_QUALCOMM_SC7280_ADDRESS_MAP_H__ */
