/** @file

Copyright (c) 2019, Intel Corporation. All rights reserved.<BR>

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above copyright notice, this
  list of conditions and the following disclaimer in the documentation and/or
  other materials provided with the distribution.
* Neither the name of Intel Corporation nor the names of its contributors may
  be used to endorse or promote products derived from this software without
  specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
  THE POSSIBILITY OF SUCH DAMAGE.

  This file is automatically generated. Please do NOT modify !!!

**/

#ifndef __FSPMUPD_H__
#define __FSPMUPD_H__

#include <FspUpd.h>

#pragma pack(1)


#define MAX_NODE_NUM     1
#define MAX_CHANNELS_NUM 4
#define MAX_DIMMS_NUM    1

#define MAX_PROFILE_NUM     4 // number of memory profiles supported
#define MAX_XMP_PROFILE_NUM 2 // number of XMP profiles supported

//
// Matches MAX_SPD_SAVE define in MRC
//
#ifndef MAX_SPD_SAVE
#define MAX_SPD_SAVE 29
#endif

#define MRC_DDR_TYPE_LPDDR4   6
#define MRC_DDR_TYPE_DDR4     7

//
// MRC version description.
//
typedef struct {
  UINT8  Major;     ///< Major version number
  UINT8  Minor;     ///< Minor version number
  UINT8  Rev;       ///< Revision number
  UINT8  Build;     ///< Build number
} SiMrcVersion;

//
// DIMM timings
//
typedef struct {
  UINT32 tCK;       ///< Memory cycle time, in femtoseconds.
  UINT16 NMode;     ///< Number of tCK cycles for the channel DIMM's command rate mode.
  UINT16 tCL;       ///< Number of tCK cycles for the channel DIMM's CAS latency.
  UINT16 tCWL;      ///< Number of tCK cycles for the channel DIMM's minimum CAS write latency time.
  UINT16 tFAW;      ///< Number of tCK cycles for the channel DIMM's minimum four activate window delay time.
  UINT16 tRAS;      ///< Number of tCK cycles for the channel DIMM's minimum active to precharge delay time.
  UINT16 tRCDtRP;   ///< Number of tCK cycles for the channel DIMM's minimum RAS# to CAS# delay time and Row Precharge delay time.
  UINT16 tREFI;     ///< Number of tCK cycles for the channel DIMM's minimum Average Periodic Refresh Interval.
  UINT16 tRFC;      ///< Number of tCK cycles for the channel DIMM's minimum refresh recovery delay time.
  UINT16 tRFCpb;    ///< Number of tCK cycles for the channel DIMM's minimum per bank refresh recovery delay time.
  UINT16 tRFC2;     ///< Number of tCK cycles for the channel DIMM's minimum refresh recovery delay time.
  UINT16 tRFC4;     ///< Number of tCK cycles for the channel DIMM's minimum refresh recovery delay time.
  UINT16 tRPab;     ///< Number of tCK cycles for the channel DIMM's minimum row precharge delay time for all banks.
  UINT16 tRRD;      ///< Number of tCK cycles for the channel DIMM's minimum row active to row active delay time.
  UINT16 tRRD_L;    ///< Number of tCK cycles for the channel DIMM's minimum row active to row active delay time for same bank groups.
  UINT16 tRRD_S;    ///< Number of tCK cycles for the channel DIMM's minimum row active to row active delay time for different bank groups.
  UINT16 tRTP;      ///< Number of tCK cycles for the channel DIMM's minimum internal read to precharge command delay time.
  UINT16 tWR;       ///< Number of tCK cycles for the channel DIMM's minimum write recovery time.
  UINT16 tWTR;      ///< Number of tCK cycles for the channel DIMM's minimum internal write to read command delay time.
  UINT16 tWTR_L;    ///< Number of tCK cycles for the channel DIMM's minimum internal write to read command delay time for same bank groups.
  UINT16 tWTR_S;    ///< Number of tCK cycles for the channel DIMM's minimum internal write to read command delay time for different bank groups.
  UINT16 tCCD_L;  ///< Number of tCK cycles for the channel DIMM's minimum CAS-to-CAS delay for same bank group.
} MRC_CH_TIMING;

///
/// Memory SMBIOS & OC Memory Data Hob
///
typedef struct {
  UINT8             Status;                 ///< See MrcDimmStatus for the definition of this field.
  UINT8             DimmId;
  UINT32            DimmCapacity;           ///< DIMM size in MBytes.
  UINT16            MfgId;
  UINT8             ModulePartNum[20];      ///< Module part number for DDR3 is 18 bytes however for DRR4 20 bytes as per JEDEC Spec, so reserving 20 bytes
  UINT8             RankInDimm;             ///< The number of ranks in this DIMM.
  UINT8             SpdDramDeviceType;      ///< Save SPD DramDeviceType information needed for SMBIOS structure creation.
  UINT8             SpdModuleType;          ///< Save SPD ModuleType information needed for SMBIOS structure creation.
  UINT8             SpdModuleMemoryBusWidth;///< Save SPD ModuleMemoryBusWidth information needed for SMBIOS structure creation.
  UINT8             SpdSave[MAX_SPD_SAVE];  ///< Save SPD Manufacturing information needed for SMBIOS structure creation.
} DIMM_INFO;

typedef struct {
  UINT8             Status;                  ///< Indicates whether this channel should be used.
  UINT8             ChannelId;
  UINT8             DimmCount;               ///< Number of valid DIMMs that exist in the channel.
  MRC_CH_TIMING     Timing[MAX_PROFILE_NUM]; ///< The channel timing values.
  DIMM_INFO         DimmInfo[MAX_DIMMS_NUM]; ///< Save the DIMM output characteristics.
} CHANNEL_INFO;

typedef struct {
  UINT8             Status;                  ///< Indicates whether this controller should be used.
  UINT16            DeviceId;                ///< The PCI device id of this memory controller.
  UINT8             RevisionId;              ///< The PCI revision id of this memory controller.
  UINT8             ChannelCount;            ///< Number of valid channels that exist on the controller.
  CHANNEL_INFO      ChannelInfo[MAX_CHANNELS_NUM];     ///< The following are channel level definitions.
} CONTROLLER_INFO;

typedef struct {
  UINT8             Revision;
  UINT16            DataWidth;              ///< Data width, in bits, of this memory device
  /** As defined in SMBIOS 3.0 spec
    Section 7.18.2 and Table 75
  **/
  UINT8             MemoryType;             ///< DDR type: DDR3, DDR4, or LPDDR3
  UINT16            MaximumMemoryClockSpeed;///< The maximum capable speed of the device, in megahertz (MHz)
  UINT16            ConfiguredMemoryClockSpeed; ///< The configured clock speed to the memory device, in megahertz (MHz)
  /** As defined in SMBIOS 3.0 spec
    Section 7.17.3 and Table 72
  **/
  UINT8             ErrorCorrectionType;

  SiMrcVersion      Version;
  BOOLEAN           EccSupport;
  UINT8             MemoryProfile;
  UINT32            TotalPhysicalMemorySize;
  UINT32            DefaultXmptCK[MAX_XMP_PROFILE_NUM];///< Stores the tCK value read from SPD XMP profiles if they exist.
  UINT8             XmpProfileEnable;                  ///< If XMP capable DIMMs are detected, this will indicate which XMP Profiles are common among all DIMMs.
  UINT8             Ratio;
  UINT8             RefClk;
  UINT32            VddVoltage[MAX_PROFILE_NUM];
  CONTROLLER_INFO   Controller[MAX_NODE_NUM];
} FSP_SMBIOS_MEMORY_INFO;

typedef struct {
  UINT16     TotalNumberOfSockets;
  UINT16     CurrentSocketNumber;
  UINT8      ProcessorType;                 ///< ENUM defined in SMBIOS Spec v3.0 Section 7.5.1
  /** This info is used for both ProcessorFamily and ProcessorFamily2 fields
      See ENUM defined in SMBIOS Spec v3.0 Section 7.5.2
  **/
  UINT16     ProcessorFamily;
  UINT8      ProcessorManufacturerStrIndex; ///< Index of the String in the String Buffer
  UINT64     ProcessorId;                   ///< ENUM defined in SMBIOS Spec v3.0 Section 7.5.3
  UINT8      ProcessorVersionStrIndex;      ///< Index of the String in the String Buffer
  UINT8      Voltage;                       ///< Format defined in SMBIOS Spec v3.0 Section 7.5.4
  UINT16     ExternalClockInMHz;            ///< External Clock Frequency. Set to 0 if unknown.
  UINT16     CurrentSpeedInMHz;             ///< Snapshot of current processor speed during boot
  UINT8      Status;                        ///< Format defined in the SMBIOS Spec v3.0 Table 21
  UINT8      ProcessorUpgrade;              ///< ENUM defined in SMBIOS Spec v3.0 Section 7.5.5
  /** This info is used for both CoreCount & CoreCount2 fields
      See detailed description in SMBIOS Spec v3.0 Section 7.5.6
  **/
  UINT16     CoreCount;
  /** This info is used for both CoreEnabled & CoreEnabled2 fields
      See detailed description in SMBIOS Spec v3.0 Section 7.5.7
  **/
  UINT16     EnabledCoreCount;
  /** This info is used for both ThreadCount & ThreadCount2 fields
      See detailed description in SMBIOS Spec v3.0 Section 7.5.8
  **/
  UINT16     ThreadCount;
  UINT16     ProcessorCharacteristics;      ///< Format defined in SMBIOS Spec v3.0 Section 7.5.9
  /**
  String Buffer - each string terminated by NULL "0x00"
  String buffer terminated by double NULL "0x0000"
  **/
} FSP_SMBIOS_PROCESSOR_INFO;

typedef struct {
  UINT16     ProcessorSocketNumber;
  UINT16     NumberOfCacheLevels;         ///< Based on Number of Cache Types L1/L2/L3
  UINT8      SocketDesignationStrIndex;   ///< String Index in the string Buffer. Example "L1-CACHE"
  UINT16     CacheConfiguration;          ///< Format defined in SMBIOS Spec v3.0 Section7.8 Table36
  UINT16     MaxCacheSize;                ///< Format defined in SMBIOS Spec v3.0 Section7.8.1
  UINT16     InstalledSize;               ///< Format defined in SMBIOS Spec v3.0 Section7.8.1
  UINT16     SupportedSramType;           ///< Format defined in SMBIOS Spec v3.0 Section7.8.2
  UINT16     CurrentSramType;             ///< Format defined in SMBIOS Spec v3.0 Section7.8.2
  UINT8      CacheSpeed;                  ///< Cache Speed in nanoseconds. 0 if speed is unknown.
  UINT8      ErrorCorrectionType;         ///< ENUM Format defined in SMBIOS Spec v3.0 Section 7.8.3
  UINT8      SystemCacheType;             ///< ENUM Format defined in SMBIOS Spec v3.0 Section 7.8.4
  UINT8      Associativity;               ///< ENUM Format defined in SMBIOS Spec v3.0 Section 7.8.5
  /**
  String Buffer - each string terminated by NULL "0x00"
  String buffer terminated by double NULL "0x0000"
  **/
} FSP_SMBIOS_CACHE_INFO;


/** Fsp M Configuration
**/
typedef struct {

/** Offset 0x0040 - Debug Serial Port Base address
  Debug serial port base address. This option will be used only when the 'Serial Port
  Debug Device' option is set to 'External Device'. 0x00000000(Default).
**/
  UINT32                      SerialDebugPortAddress;

/** Offset 0x0044 - Debug Serial Port Type
  16550 compatible debug serial port resource type. NONE means no serial port support.
  0x02:MMIO(Default).
  0:NONE, 1:I/O, 2:MMIO
**/
  UINT8                       SerialDebugPortType;

/** Offset 0x0045 - Serial Port Debug Device
  Select active serial port device for debug. For SOC UART devices,'Debug Serial Port
  Base' options will be ignored. 0x02:SOC UART2(Default).
  0:SOC UART0, 1:SOC UART1, 2:SOC UART2, 3:External Device
**/
  UINT8                       SerialDebugPortDevice;

/** Offset 0x0046 - Debug Serial Port Stride Size
  Debug serial port register map stride size in bytes. 0x00:1, 0x02:4(Default).
  0:1, 2:4
**/
  UINT8                       SerialDebugPortStrideSize;

/** Offset 0x0047 - Memory Fast Boot
  Enable/Disable MRC fast boot support. 0x00:Disable, 0x01:Enable(Default).
  $EN_DIS
**/
  UINT8                       MrcFastBoot;

/** Offset 0x0048 - Integrated Graphics Device
  Enable : Enable Integrated Graphics Device (IGD) when selected as the Primary Video
  Adaptor. Disable: Always disable IGD. 0x00:Disable, 0x01:Enable(Default).
  $EN_DIS
**/
  UINT8                       Igd;

/** Offset 0x0049 - DVMT Pre-Allocated
  Select DVMT 5.0 Pre-Allocated (Fixed) Graphics Memory size used by the Internal
  Graphics Device. 0x02:64 MB(Default).
  0x02:64 MB, 0x03:96 MB, 0x04:128 MB, 0x05:160 MB, 0x06:192 MB, 0x07:224 MB, 0x08:256
  MB, 0x09:288 MB, 0x0A:320 MB, 0x0B:352 MB, 0x0C:384 MB, 0x0D:416 MB, 0x0E:448 MB,
  0x0F:480 MB, 0x10:512 MB
**/
  UINT8                       IgdDvmt50PreAlloc;

/** Offset 0x004A - Aperture Size
  Select the Aperture Size used by the Internal Graphics Device. 0x1:128 MB(Default),
  0x2:256 MB, 0x3:512 MB.
  0x1:128 MB, 0x2:256 MB, 0x3:512 MB
**/
  UINT8                       IgdApertureSize;

/** Offset 0x004B - GTT Size
  Select the GTT Size used by the Internal Graphics Device. 0x1:2 MB, 0x2:4 MB, 0x3:8
  MB(Default).
  0x1:2 MB, 0x2:4 MB, 0x3:8 MB
**/
  UINT8                       GttSize;

/** Offset 0x004C - Primary Display
  Select which of IGD/PCI Graphics device should be Primary Display. 0x0:AUTO(Default),
  0x2:IGD, 0x3:PCI
  0x0:AUTO, 0x2:IGD, 0x3:PCI
**/
  UINT8                       PrimaryVideoAdaptor;

/** Offset 0x004D - Package
  NOTE: Specifies CA Mapping for all technologies. Supported CA Mappings: 0 - SODIMM(Default);
  1 - BGA; 2 - BGA mirrored (LPDDR3 only); 3 - SODIMM/UDIMM with Rank 1 Mirrored
  (DDR3L); Refer to the IAFW spec for specific details about each CA mapping.
  0x0:SODIMM, 0x1:BGA, 0x2:BGA mirrored (LPDDR3 only), 0x3:SODIMM/UDIMM with Rank
  1 Mirrored (DDR3L)
**/
  UINT8                       Package;

/** Offset 0x004E - Profile
  Profile list. 0x15(Default).
  0x01:LPDDR3_1333_10_12_12, 0x02:LPDDR3_1600_12_15_15, 0x03:LPDDR3_1866_14_17_17,
  0x04:LPDDR4_1600_14_15_15, 0x05:LPDDR4_1866_20_17_17, 0x06:LPDDR4_2133_20_20_20,
  0x07:LPDDR4_2400_24_22_22, 0x08:LPDDR4_2666_24_24_24, 0x09:LPDDR4_3200_28_29_29,
  0x0A:DDR4_1600_10_10_10, 0x0B:DDR4_1600_11_11_11, 0x0C:DDR4_1600_12_12_12, 0x0D:DDR4_1866_12_12_12,
  0x0E:DDR4_1866_13_13_13, 0x0F:DDR4_1866_14_14_14, 0x10:DDR4_2133_14_14_14, 0x11:DDR4_2133_15_15_15,
  0x12:DDR4_2133_16_16_16, 0x13:DDR4_2400_15_15_15, 0x14:DDR4_2400_16_16_16, 0x15:DDR4_2400_17_17_17,
  0x16:DDR4_2400_18_18_18, 0x17:DDR4_2666_17_17_17, 0x18:DDR4_2666_18_18_18, 0x19:DDR4_2666_19_19_19,
  0x1A:DDR4_2666_20_20_20
**/
  UINT8                       Profile;

/** Offset 0x004F - MemoryDown
  Memory Down. 0x0(Default).
  0x0:No, 0x1:Yes, 0x2:1MD+SODIMM (for DDR3L/4 only) ACRD, 0x3:1x32 LPDDR4
**/
  UINT8                       MemoryDown;

/** Offset 0x0050 - DDR3LPageSize
  NOTE: Only for memory down (soldered down memory with no SPD). 0x01:1KB(Default), 0x02:2KB.
  0x1:1KB, 0x2:2KB
**/
  UINT8                       DDR3LPageSize;

/** Offset 0x0051 - DDR3LASR
  NOTE: Only for memory down. This is specific to ddr3l and used for refresh adjustment
  in Self Refresh, does not affect LP4. 0x00:Not Supported(Default), 0x01:Supported.
  0x0:Not Supported, 0x1:Supported
**/
  UINT8                       DDR3LASR;

/** Offset 0x0052 - ScramblerSupport
  Scrambler Support -  Enable or disable the memory scrambler. Data scrambling is
  provided as a means to increase signal integrity/reduce RFI generated by the DRAM
  interface. This is achieved by randomizing seed that encodes/decodes memory data
  so repeating a worse case pattern is hard to repeat. 00: Disable Scrambler Support,
  01: Enable Scrambler Support
  $EN_DIS
**/
  UINT8                       ScramblerSupport;

/** Offset 0x0053 - InterleavedMode
  This field is ignored if one of the PnP channel configurations is used. If the memory
  configuration is different, then the field is used directly to populate. 0x00:Disable(Default),
  0x02:Enable.
  0x0:Disable, 0x2:Enable
**/
  UINT8                       InterleavedMode;

/** Offset 0x0054 - ChannelHashMask
  ChannelHashMask and SliceHashMask allow for the channel hashing algorithm to be
  modified. These inputs are not used for configurations where an optimized ChannelHashMask
  has been provided by the PnP validation teams. 0x00(Default).
**/
  UINT16                      ChannelHashMask;

/** Offset 0x0056 - SliceHashMask
  ChannelHashMask and SliceHashMask allow for the channel hashing algorithm to be
  modified. These inputs are not used for configurations where an optimized ChannelHashMask
  has been provided by the PnP validation teams. 0x00(Default).
**/
  UINT16                      SliceHashMask;

/** Offset 0x0058 - ChannelsSlicesEnable
  ChannelSlicesEnable field is not used at all on BXTP. The Channel Slice Configuration
  is calculated internally based on the enabled channel configuration. 0x00:Disable(Default),
  0x01:Enable.
  $EN_DIS
**/
  UINT8                       ChannelsSlicesEnable;

/** Offset 0x0059 - MinRefRate2xEnable
  Provided as a means to defend against Row-Hammer attacks. 0x00:Disable(Default),
  0x01:Enable.
  $EN_DIS
**/
  UINT8                       MinRefRate2xEnable;

/** Offset 0x005A - DualRankSupportEnable
  Dual Rank Support Enable. 0x00:Disable, 0x01:Enable(Default).
  $EN_DIS
**/
  UINT8                       DualRankSupportEnable;

/** Offset 0x005B - RmtMode
  Rank Margin Tool Mode. 0x00(Default), 0x3(Enabled).
  0x0:Disabled, 0x3:Enabled
**/
  UINT8                       RmtMode;

/** Offset 0x005C - MemorySizeLimit
  Memory Size Limit: This value is used to restrict the total amount of memory and
  the calculations based on it. Value is in MB. Example encodings are: 0x400 = 1GB,
  0x800 = 2GB, 0x1000 = 4GB, 0x2000 8GB. 0x0000(Default)
**/
  UINT16                      MemorySizeLimit;

/** Offset 0x005E - LowMemoryMaxValue
  Low Memory Max Value: This value is used to restrict the amount of memory below
  4GB and the calculations based on it. Value is in MB.Example encodings are: 0x400
  = 1GB, 0x800 = 2GB, 0x1000 = 4GB, 0x2000 8GB. 0x0000(Default).
**/
  UINT16                      LowMemoryMaxValue;

/** Offset 0x0060 - HighMemoryMaxValue
  High Memory Max Value: This value is used to restrict the amount of memory above
  4GB and the calculations based on it. Value is in MB. Example encodings are: 0x0400:1GB,
  0x0800:2GB, 0x1000:4GB, 0x2000:8GB. 0x00(Default).
**/
  UINT16                      HighMemoryMaxValue;

/** Offset 0x0062 - DisableFastBoot
  00:Disabled; Use saved training data (if valid) after first boot(Default), 01:Enabled;
  Full re-train of memory on every boot.
  $EN_DIS
**/
  UINT8                       DisableFastBoot;

/** Offset 0x0063 - DIMM0SPDAddress
  DIMM0 SPD Address (NOTE: Only for DDR3L only. Please put 0 for MemoryDown. 0xA0(Default).
**/
  UINT8                       DIMM0SPDAddress;

/** Offset 0x0064 - DIMM1SPDAddress
  DIMM1 SPD Address (NOTE: Only for DDR3L only. Please put 0 for MemoryDown. 0xA4(Default).
**/
  UINT8                       DIMM1SPDAddress;

/** Offset 0x0065 - Ch0_RankEnable
  NOTE: Only for memory down. This is a bit mask which specifies what ranks are enabled.
  NOTE: Only for memory down (soldered down memory with no SPD): BIT[0] Enable Rank
  0:  Must be set to 1 to enable use of this rank; BIT1[1] Enable Rank 1:  Must be
  set to 1 to enable use of this rank.
**/
  UINT8                       Ch0_RankEnable;

/** Offset 0x0066 - Ch0_DeviceWidth
  NOTE: Only for memory down. Must specify the DRAM device width per DRAM channel
  (not to be confused with the SoC Memory Channel width which is always x32 for LPDDR3\LPDDR4
  and x64 for DDR3L). LPDDR4 devices typically have two channels per die and a x16
  device width: 00 - x8; 01 - x16; 10 - x32; 11 - x64
  0x00:x8, 0x01:x16, 0x02:x32, 0x03:x64
**/
  UINT8                       Ch0_DeviceWidth;

/** Offset 0x0067 - Ch0_DramDensity
  NOTE: Only for memory down. For LPDDR3 and LPDDR4: Must specify the DRAM device
  density per rank (per Chip Select). The simplest way of identifying the density
  per rank is to divide the total SoC memory channel density by the number of ranks.
  For DDR3L: Must specify the DRAM device density per DRAM device. For example, an
  8GB 2Rx8 configuration will utilize sixteen 4Gb density DRAMS. In this configuration,
  a 4Gb density setting would be selected in the MRC: 000 - 4Gb; 001 - 6Gb; 010 -
  8Gb; 011 - 12Gb; 100 - 16Gb; 101 - 2Gb; 110-111 - Reserved
  0x00:4Gb, 0x01:6Gb, 0x02:8Gb, 0x03:12Gb, 0x04:16Gb
**/
  UINT8                       Ch0_DramDensity;

/** Offset 0x0068 - Ch0_Option
  BIT[0] Rank Select Interleaving Enable.  See Address Mapping section for full description:
  0 - Rank Select Interleaving disabled; 1 - Rank Select Interleaving enabled. BIT[1]
  Bank Address Hashing Enable. See Address Mapping section for full description:
  0 - Bank Address Hashing disabled; 1 - Bank Address Hashing enabled. BIT[2] CH1
  CLK Disable. Disables the CH1 CLK PHY Signal when set to 1. This is used on board
  designs where the CH1 CLK is not routed and left floating or stubbed out: 0 - CH1
  CLK is enabled; 1 -  CH1 CLK is disabled. BIT[3] Reserved; BIT[5:4] This register
  specifies the address mapping to be used: 00 - 1KB (A); 01 - 2KB (B)
**/
  UINT8                       Ch0_Option;

/** Offset 0x0069 - Ch0_OdtConfig
  BIT[0] Change the READ ODT strength, for SOC termination during a READ transaction,
  ON DQ BITs: 0 - WEAK_ODT_CONFIG (default); 1 - STRONG_ODT_CONFIG; BIT[4:1] - Reserved;
  BIT[5] nWR config: 0 - nWR6; 1 - nWR24 (default); BIT[31:6] - Reserved
**/
  UINT8                       Ch0_OdtConfig;

/** Offset 0x006A - Ch0_TristateClk1
  Not used
**/
  UINT8                       Ch0_TristateClk1;

/** Offset 0x006B - Ch0_Mode2N
  DDR3L Only: Configures the DDR3L command timing mode. 2N Mode is a stretched command
  mode that provides more setup and hold time for DRAM commands on the DRAM command
  bus. This is useful for platforms with unusual CMD bus routing or marginal signal
  integrity: 0 - Auto (1N or 2N mode is automatically selected during Command and
  Control training), 1 - Force 2N Mode
  0x0:Auto, 0x1:Force 2N CMD Timing Mode
**/
  UINT8                       Ch0_Mode2N;

/** Offset 0x006C - Ch0_OdtLevels
  Parameter used to determine if ODT will be held high or low: 0 - ODT Connected to
  SoC, 1 - ODT held high
**/
  UINT8                       Ch0_OdtLevels;

/** Offset 0x006D - Ch1_RankEnable
  NOTE: Only for memory down. This is a bit mask which specifies what ranks are enabled.
  NOTE: Only for memory down (soldered down memory with no SPD): BIT[0] Enable Rank
  0:  Must be set to 1 to enable use of this rank; BIT1[1] Enable Rank 1:  Must be
  set to 1 to enable use of this rank.
**/
  UINT8                       Ch1_RankEnable;

/** Offset 0x006E - Ch1_DeviceWidth
  NOTE: Only for memory down. Must specify the DRAM device width per DRAM channel
  (not to be confused with the SoC Memory Channel width which is always x32 for LPDDR3\LPDDR4
  and x64 for DDR3L). LPDDR4 devices typically have two channels per die and a x16
  device width: 00 - x8; 01 - x16; 10 - x32; 11 - x64
  0x00:x8, 0x01:x16, 0x02:x32, 0x03:x64
**/
  UINT8                       Ch1_DeviceWidth;

/** Offset 0x006F - Ch1_DramDensity
  NOTE: Only for memory down. For LPDDR3 and LPDDR4: Must specify the DRAM device
  density per rank (per Chip Select). The simplest way of identifying the density
  per rank is to divide the total SoC memory channel density by the number of ranks.
  For DDR3L: Must specify the DRAM device density per DRAM device. For example, an
  8GB 2Rx8 configuration will utilize sixteen 4Gb density DRAMS. In this configuration,
  a 4Gb density setting would be selected in the MRC: 000 - 4Gb; 001 - 6Gb; 010 -
  8Gb; 011 - 12Gb; 100 - 16Gb; 101 - 2Gb; 110-111 - Reserved
  0x00:4Gb, 0x01:6Gb, 0x02:8Gb, 0x03:12Gb, 0x04:16Gb
**/
  UINT8                       Ch1_DramDensity;

/** Offset 0x0070 - Ch1_Option
  BIT[0] Rank Select Interleaving Enable.  See Address Mapping section for full description:
  0 - Rank Select Interleaving disabled; 1 - Rank Select Interleaving enabled. BIT[1]
  Bank Address Hashing Enable. See Address Mapping section for full description:
  0 - Bank Address Hashing disabled; 1 - Bank Address Hashing enabled. BIT[2] CH1
  CLK Disable. Disables the CH1 CLK PHY Signal when set to 1. This is used on board
  designs where the CH1 CLK is not routed and left floating or stubbed out: 0 - CH1
  CLK is enabled; 1 -  CH1 CLK is disabled. BIT[3] Reserved; BIT[5:4] This register
  specifies the address mapping to be used: 00 - 1KB (A); 01 - 2KB (B)
**/
  UINT8                       Ch1_Option;

/** Offset 0x0071 - Ch1_OdtConfig
  BIT[0] Change the READ ODT strength, for SOC termination during a READ transaction,
  ON DQ BITs: 0 - WEAK_ODT_CONFIG (default); 1 - STRONG_ODT_CONFIG; BIT[4:1] - Reserved;
  BIT[5] nWR config: 0 - nWR6; 1 - nWR24 (default); BIT[31:6] - Reserved
**/
  UINT8                       Ch1_OdtConfig;

/** Offset 0x0072 - Ch1_TristateClk1
  Not used
**/
  UINT8                       Ch1_TristateClk1;

/** Offset 0x0073 - Ch1_Mode2N
  DDR3L Only: Configures the DDR3L command timing mode. 2N Mode is a stretched command
  mode that provides more setup and hold time for DRAM commands on the DRAM command
  bus. This is useful for platforms with unusual CMD bus routing or marginal signal
  integrity: 0 - Auto (1N or 2N mode is automatically selected during Command and
  Control training), 1 - Force 2N Mode
  0x0:Auto, 0x1:Force 2N CMD Timing Mode
**/
  UINT8                       Ch1_Mode2N;

/** Offset 0x0074 - Ch1_OdtLevels
  DDR3L Only: Parameter used to determine if ODT will be held high or low: 0 - ODT_AB_HIGH_LOW
  (default), 1 - ODT_AB_HIGH_HIGH
**/
  UINT8                       Ch1_OdtLevels;

/** Offset 0x0075 - Ch2_RankEnable
  NOTE: Only for memory down. This is a bit mask which specifies what ranks are enabled.
  NOTE: Only for memory down (soldered down memory with no SPD): BIT[0] Enable Rank
  0:  Must be set to 1 to enable use of this rank; BIT1[1] Enable Rank 1:  Must be
  set to 1 to enable use of this rank.
**/
  UINT8                       Ch2_RankEnable;

/** Offset 0x0076 - Ch2_DeviceWidth
  NOTE: Only for memory down. Must specify the DRAM device width per DRAM channel
  (not to be confused with the SoC Memory Channel width which is always x32 for LPDDR3\LPDDR4
  and x64 for DDR3L). LPDDR4 devices typically have two channels per die and a x16
  device width: 00 - x8; 01 - x16; 10 - x32; 11 - x64
  0x00:x8, 0x01:x16, 0x02:x32, 0x03:x64
**/
  UINT8                       Ch2_DeviceWidth;

/** Offset 0x0077 - Ch2_DramDensity
  NOTE: Only for memory down. For LPDDR3 and LPDDR4: Must specify the DRAM device
  density per rank (per Chip Select). The simplest way of identifying the density
  per rank is to divide the total SoC memory channel density by the number of ranks.
  For DDR3L: Must specify the DRAM device density per DRAM device. For example, an
  8GB 2Rx8 configuration will utilize sixteen 4Gb density DRAMS. In this configuration,
  a 4Gb density setting would be selected in the MRC: 000 - 4Gb; 001 - 6Gb; 010 -
  8Gb; 011 - 12Gb; 100 - 16Gb; 101 - 2Gb; 110-111 - Reserved
  0x00:4Gb, 0x01:6Gb, 0x02:8Gb, 0x03:12Gb, 0x04:16Gb
**/
  UINT8                       Ch2_DramDensity;

/** Offset 0x0078 - Ch2_Option
  BIT[0] Rank Select Interleaving Enable.  See Address Mapping section for full description:
  0 - Rank Select Interleaving disabled; 1 - Rank Select Interleaving enabled. BIT[1]
  Bank Address Hashing Enable. See Address Mapping section for full description:
  0 - Bank Address Hashing disabled; 1 - Bank Address Hashing enabled. BIT[2] CH1
  CLK Disable. Disables the CH1 CLK PHY Signal when set to 1. This is used on board
  designs where the CH1 CLK is not routed and left floating or stubbed out: 0 - CH1
  CLK is enabled; 1 -  CH1 CLK is disabled. BIT[3] Reserved; BIT[5:4] This register
  specifies the address mapping to be used: 00 - 1KB (A); 01 - 2KB (B)
**/
  UINT8                       Ch2_Option;

/** Offset 0x0079 - Ch2_OdtConfig
  BIT[0] Change the READ ODT strength, for SOC termination during a READ transaction,
  ON DQ BITs: 0 - WEAK_ODT_CONFIG (default); 1 - STRONG_ODT_CONFIG; BIT[4:1] - Reserved;
  BIT[5] nWR config: 0 - nWR6; 1 - nWR24 (default); BIT[31:6] - Reserved
**/
  UINT8                       Ch2_OdtConfig;

/** Offset 0x007A - Ch2_TristateClk1
  Not used
**/
  UINT8                       Ch2_TristateClk1;

/** Offset 0x007B - Ch2_Mode2N
  DDR3L Only: Configures the DDR3L command timing mode. 2N Mode is a stretched command
  mode that provides more setup and hold time for DRAM commands on the DRAM command
  bus. This is useful for platforms with unusual CMD bus routing or marginal signal
  integrity: 0 - Auto (1N or 2N mode is automatically selected during Command and
  Control training), 1 - Force 2N Mode
  0x0:Auto, 0x1:Force 2N CMD Timing Mode
**/
  UINT8                       Ch2_Mode2N;

/** Offset 0x007C - Ch2_OdtLevels
  DDR3L Only: Parameter used to determine if ODT will be held high or low: 0 - ODT_AB_HIGH_LOW
  (default), 1 - ODT_AB_HIGH_HIGH
**/
  UINT8                       Ch2_OdtLevels;

/** Offset 0x007D - Ch3_RankEnable
  NOTE: Only for memory down. This is a bit mask which specifies what ranks are enabled.
  NOTE: Only for memory down (soldered down memory with no SPD): BIT[0] Enable Rank
  0:  Must be set to 1 to enable use of this rank; BIT1[1] Enable Rank 1:  Must be
  set to 1 to enable use of this rank.
**/
  UINT8                       Ch3_RankEnable;

/** Offset 0x007E - Ch3_DeviceWidth
  NOTE: Only for memory down. Must specify the DRAM device width per DRAM channel
  (not to be confused with the SoC Memory Channel width which is always x32 for LPDDR3\LPDDR4
  and x64 for DDR3L). LPDDR4 devices typically have two channels per die and a x16
  device width: 00 - x8; 01 - x16; 10 - x32; 11 - x64
  0x00:x8, 0x01:x16, 0x02:x32, 0x03:x64
**/
  UINT8                       Ch3_DeviceWidth;

/** Offset 0x007F - Ch3_DramDensity
  NOTE: Only for memory down. For LPDDR3 and LPDDR4: Must specify the DRAM device
  density per rank (per Chip Select). The simplest way of identifying the density
  per rank is to divide the total SoC memory channel density by the number of ranks.
  For DDR3L: Must specify the DRAM device density per DRAM device. For example, an
  8GB 2Rx8 configuration will utilize sixteen 4Gb density DRAMS. In this configuration,
  a 4Gb density setting would be selected in the MRC: 000 - 4Gb; 001 - 6Gb; 010 -
  8Gb; 011 - 12Gb; 100 - 16Gb; 101 - 2Gb; 110-111 - Reserved
  0x00:4Gb, 0x01:6Gb, 0x02:8Gb, 0x03:12Gb, 0x04:16Gb
**/
  UINT8                       Ch3_DramDensity;

/** Offset 0x0080 - Ch3_Option
  BIT[0] Rank Select Interleaving Enable.  See Address Mapping section for full description:
  0 - Rank Select Interleaving disabled; 1 - Rank Select Interleaving enabled. BIT[1]
  Bank Address Hashing Enable. See Address Mapping section for full description:
  0 - Bank Address Hashing disabled; 1 - Bank Address Hashing enabled. BIT[2] CH1
  CLK Disable. Disables the CH1 CLK PHY Signal when set to 1. This is used on board
  designs where the CH1 CLK is not routed and left floating or stubbed out: 0 - CH1
  CLK is enabled; 1 -  CH1 CLK is disabled. BIT[3] Reserved; BIT[5:4] This register
  specifies the address mapping to be used: 00 - 1KB (A); 01 - 2KB (B)
**/
  UINT8                       Ch3_Option;

/** Offset 0x0081 - Ch3_OdtConfig
  BIT[0] Change the READ ODT strength, for SOC termination during a READ transaction,
  ON DQ BITs: 0 - WEAK_ODT_CONFIG (default); 1 - STRONG_ODT_CONFIG; BIT[4:1] - Reserved;
  BIT[5] nWR config: 0 - nWR6; 1 - nWR24 (default); BIT[31:6] - Reserved
**/
  UINT8                       Ch3_OdtConfig;

/** Offset 0x0082 - Ch3_TristateClk1
  Not used
**/
  UINT8                       Ch3_TristateClk1;

/** Offset 0x0083 - Ch3_Mode2N
  DDR3L Only: Configures the DDR3L command timing mode. 2N Mode is a stretched command
  mode that provides more setup and hold time for DRAM commands on the DRAM command
  bus. This is useful for platforms with unusual CMD bus routing or marginal signal
  integrity: 0 - Auto (1N or 2N mode is automatically selected during Command and
  Control training), 1 - Force 2N Mode
  0x0:Auto, 0x1:Force 2N CMD Timing Mode
**/
  UINT8                       Ch3_Mode2N;

/** Offset 0x0084 - Ch3_OdtLevels
  DDR3L Only: Parameter used to determine if ODT will be held high or low: 0 - ODT_AB_HIGH_LOW
  (default), 1 - ODT_AB_HIGH_HIGH
**/
  UINT8                       Ch3_OdtLevels;

/** Offset 0x0085 - RmtCheckRun
  Parameter used to determine whether to run the margin check. Bit 0 is used for MINIMUM
  MARGIN CHECK and bit 1 is used for DEGRADE MARGIN CHECK
**/
  UINT8                       RmtCheckRun;

/** Offset 0x0086 - RmtMarginCheckScaleHighThreshold
  Percentage used to determine the margin tolerances over the failing margin.
**/
  UINT16                      RmtMarginCheckScaleHighThreshold;

/** Offset 0x0088 - Ch0_Bit_swizzling
  Channel 0 PHY to DUnit DQ mapping (only used if not 1-1 mapping)Range: 0-32. Frequently
  asked questions: Q: The DQS (strobes) need to go with the corresponding byte lanes
  on the DDR module. Are the DQS being swapped around as well? Ans: Yes, DQ strobes
  need to follow the DQ byte lane they correspond too. So for example if you have
  DQ[7:0] swapped with DQ[15:8], DQS0 pair also need to be swapped with DQS1 pair.
  Also, the spreadsheet used for Amenia is essentially a swizzle value lookup that
  specifies what DRAM DQ bit a particular SoC DQ bit is connected to. Some confusion
  can arrise from the fact that the indexes to the array do not necessarily map 1:1
  to an SoC DQ pin. For example, the CH0 array at index 0 maps to SoC DQB8. The value
  of 9 at index 0 tells us that SoC DQB8 is connected to DRAM DQA9. Q: The PDG indicates
  a 2 physical channels need to be stuffed and operated together. Are the CHx_A and
  CHx_B physical channels operated in tandem or completely separate? If separate,
  why requirement of pairing them? Ans: We have 2 PHY instances on the SoC each supporting
  up to 2 x32 LP4 channels. If you have 4 channels both PHYs are active, but if you
  have 2 channels in order to power gate one PHY, those two channel populated must
  be on one PHY instance. So yes all channels are independent of each other, but
  there are some restrictions on how they need to be populated. Q: How is it that
  an LPDDR4 device is identified as having a x16 width when all 32-bits are used
  at the same time with a single chip select? That's effectively a x32 device. Ans:LPDDR4
  DRAM devices are x16. Each die has 2 x16 devices on them. To make a x32 channel
  the CS of the two devices in the same die are connected together to make a single
  rank of one x32 channel (SDP). The second die in the DDP package makes the second rank.
**/
  UINT8                       Ch0_Bit_swizzling[32];

/** Offset 0x00A8 - Ch1_Bit_swizzling
  Channel 1 PHY to DUnit DQ mapping (only used if not 1-1 mapping)Range: 0-32.
**/
  UINT8                       Ch1_Bit_swizzling[32];

/** Offset 0x00C8 - Ch2_Bit_swizzling
  Channel 2 PHY to DUnit DQ mapping (only used if not 1-1 mapping)Range: 0-32.
**/
  UINT8                       Ch2_Bit_swizzling[32];

/** Offset 0x00E8 - Ch3_Bit_swizzling
  Channel 3 PHY to DUnit DQ mapping (only used if not 1-1 mapping)Range: 0-32.
**/
  UINT8                       Ch3_Bit_swizzling[32];

/** Offset 0x0108 - MsgLevelMask
  32 bits used to mask out debug messages. Masking out bit 0 mask all other messages.
**/
  UINT32                      MsgLevelMask;

/** Offset 0x010C
**/
  UINT8                       UnusedUpdSpace0[4];

/** Offset 0x0110 - PreMem GPIO Pin Number for each table
  Number of Pins in each PreMem GPIO Table. 0(Default).
**/
  UINT8                       PreMemGpioTablePinNum[4];

/** Offset 0x0114 - PreMem GPIO Table Pointer
  Pointer to Array of pointers to PreMem GPIO Table. 0x00000000(Default).
**/
  UINT32                      PreMemGpioTablePtr;

/** Offset 0x0118 - PreMem GPIO Table Entry Number. Currently maximum entry number is 4
  Number of Entries in PreMem GPIO Table. 0(Default).
**/
  UINT8                       PreMemGpioTableEntryNum;

/** Offset 0x0119 - Enhance the port 8xh decoding
  Enable/Disable Enhance the port 8xh decoding. 0:Disable, 1:Enable(Default).
  $EN_DIS
**/
  UINT8                       EnhancePort8xhDecoding;

/** Offset 0x011A - SPD Data Write
  Enable/Disable SPD data write on the SMBUS. 0x00:Disable(Default), 0x01:Enable.
  $EN_DIS
**/
  UINT8                       SpdWriteEnable;

/** Offset 0x011B - MRC Training Data Saving
  Enable/Disable MRC training data saving in FSP. 0x00:Disable(Default), 0x01:Enable.
  $EN_DIS
**/
  UINT8                       MrcDataSaving;

/** Offset 0x011C - OEM File Loading Address
  Determine the memory base address to load a specified file from CSE file system
  after memory is available.
**/
  UINT32                      OemLoadingBase;

/** Offset 0x0120
**/
  UINT8                       Reserved[16];

/** Offset 0x0130
**/
  VOID*                       MrcBootDataPtr;

/** Offset 0x0134 - eMMC Trace Length
  Select eMMC trace length to load OEM file from when loading OEM file name is specified.
  0x0:Long(Default), 0x1:Short.
  0x0:Long, 0x1:Short
**/
  UINT8                       eMMCTraceLen;

/** Offset 0x0135 - Skip CSE RBP to support zero sized IBB
  Enable/Disable skip CSE RBP for bootloader which loads IBB without assistance of
  CSE. 0x00:Disable(Default), 0x01:Enable.
  $EN_DIS
**/
  UINT8                       SkipCseRbp;

/** Offset 0x0136 - Trace Hub Enable
  Disable Npk/Host Debugger/Target Debugger. 0:Disable(Default), 1:Host Debugger,
  2:Target Debugger.
  0:Disable, 1:Host Debugger, 2:Target Debugger
**/
  UINT8                       TraceHubEn;

/** Offset 0x0137 - FW Trace Enable
  Enable/Disable FW Trace. 0:Disable, 1:Enable(Default).
  $EN_DIS
**/
  UINT8                       FwTraceEn;

/** Offset 0x0138 - FW Trace Destination
  FW Trace Destination. 1-NPK_TRACE_TO_MEMORY, 2-NPK_TRACE_TO_DCI, 3-NPK_TRACE_TO_BSSB,
  4-NPK_TRACE_TO_PTI(Default).
**/
  UINT8                       FwTraceDestination;

/** Offset 0x0139 - NPK Recovery Dump
  Enable/Disable NPK Recovery Dump. 0:Disable(Default), 1:Enable.
  $EN_DIS
**/
  UINT8                       RecoverDump;

/** Offset 0x013A - Memory Region 0 Buffer WrapAround
  Memory Region 0 Buffer WrapAround. 0-n0-warp, 1-warp(Default).
**/
  UINT8                       Msc0Wrap;

/** Offset 0x013B - Memory Region 1 Buffer WrapAround
  Memory Region 1 Buffer WrapAround. 0-n0-warp, 1-warp(Default).
**/
  UINT8                       Msc1Wrap;

/** Offset 0x013C - Memory Region 0 Buffer Size
  Memory Region 0 Buffer Size. 0-0MB(Default), 1-1MB, 2-8MB, 3-64MB, 4-128MB, 5-256MB,
  6-512MB, 7-1GB.
**/
  UINT32                      Msc0Size;

/** Offset 0x0140 - Memory Region 1 Buffer Size
  Memory Region 1 Buffer Size, 0-0MB(Default), 1-1MB, 2-8MB, 3-64MB, 4-128MB, 5-256MB,
  6-512MB, 7-1GB.
**/
  UINT32                      Msc1Size;

/** Offset 0x0144 - PTI Mode
  PTI Mode. 0-0ff, 1-x4(Default), 2-x8, 3-x12, 4-x16.
**/
  UINT8                       PtiMode;

/** Offset 0x0145 - PTI Training
  PTI Training. 0-off(Default), 1-6=1-6.
**/
  UINT8                       PtiTraining;

/** Offset 0x0146 - PTI Speed
  PTI Speed. 0-full, 1-half, 2-quarter(Default).
**/
  UINT8                       PtiSpeed;

/** Offset 0x0147 - Punit Message Level
  Punit Message Output Verbosity Level. 0, 1(Default), 2-4=2-4.
**/
  UINT8                       PunitMlvl;

/** Offset 0x0148 - PMC Message Level
  PMC Message Output Verbosity Level. 0, 1(Default), 2-4=2-4.
**/
  UINT8                       PmcMlvl;

/** Offset 0x0149 - SW Trace Enable
  Enable/Disable SW Trace. 0:Disable(Default), 1:Enable.
  $EN_DIS
**/
  UINT8                       SwTraceEn;

/** Offset 0x014A - SGX mode
  Select SGX mode. 0:Disable, 1:Enable, 2:Software control (default)
  0:Disable, 1:Enable, 2:Software control (default)
**/
  UINT8                       EnableSgx;

/** Offset 0x014B - Periodic Retraining Disable
  Periodic Retraining Disable - This option allows customers to disable LPDDR4 Periodic
  Retraining for debug purposes. Periodic Retraining should be enabled in production.
  Periodic retraining allows the platform to operate reliably over a larger voltage
  and temperature range. This field has no effect for DDR3L and LPDDR3 memory type
  configurations. 0x00: Enable Periodic Retraining (default); 0x01: Disable Periodic
  Retraining (debug configuration only)
  0x0:Enabled, 0x1:Disabled
**/
  UINT8                       PeriodicRetrainingDisable;

/** Offset 0x014C - PRMRR size
  PRMRR size. 0:Invalid (default), 1:32MB, 2:64MB 3:128MB
  0:Invalid (default), 1:32MB, 2:64MB 3:128MB
**/
  UINT32                      PrmrrSize;

/** Offset 0x0150 - Enable Reset System
  Enable FSP to trigger reset instead of returning reset request. 0x00: Return the
  Return Status from FSP if a reset is required. (default); 0x01: Perform Reset inside
  FSP instead of returning from the API.
  0x0:Disabled, 0x1:Eabled
**/
  UINT8                       EnableResetSystem;

/** Offset 0x0151 - Enable HECI2 in S3 resume path
  Enable HECI2 in S3 resume path. 0x00: Skip HECI2 initialization in S3 resume. ;
  0x01: Enable HECI2 in S3 resume path.(Default)
  0x0:Disabled, 0x1:Eabled
**/
  UINT8                       EnableS3Heci2;

/** Offset 0x0152 - PCI Express Root Port
  Control the PCI Express Root Port . 0:Disable, 1:Enable, 2:Auto(Default).
**/
  UINT8                       PcieRootPortEn[6];

/** Offset 0x0158 - PCIE SLOT Power Enable Assert Time - PFET.
  ACPI Timer Ticker to measure when PCIE Slot Power is enabled through PFET. FSP will
  wait for 100ms for the power to be stable, before de-asserting PERST bin. Customer
  who designed the board PCIE slot Power automatically enabled, can pass value of
  zero here.
**/
  UINT64                      StartTimerTickerOfPfetAssert;

/** Offset 0x0160
**/
  VOID*                       VariableNvsBufferPtr;

/** Offset 0x0164 - PERST pin for RootPort 0
  Address for PERST pin for Rootport 0. For Intel RVP, address of N_GPIO_105. 0x00C507D0(Default).
**/
  UINT32                      RootPort0Perst;

/** Offset 0x0168 - PERST pin for RootPort 1
  Address for PERST pin for Rootport 1. For Intel RVP, address of  A_GPIO_163. 0x00C90670(Default).
**/
  UINT32                      RootPort1Perst;

/** Offset 0x016C - PERST pin for RootPort 2
  Address for PERST pin for Rootport 2. For Intel RVP, address of N_GPIO_137. 0x00C509D0(Default).
**/
  UINT32                      RootPort2Perst;

/** Offset 0x0170 - PERST pin for RootPort 3
  Address for PERST pin for Rootport 3.
**/
  UINT32                      RootPort3Perst;

/** Offset 0x0174 - PERST pin for RootPort 4
  Address for PERST pin for Rootport 4. For Intel RVP, address of  SCC_GPIO_210. 0x00C806D0(Default).
**/
  UINT32                      RootPort4Perst;

/** Offset 0x0178 - PERST pin for RootPort 5
  Address for PERST pin for Rootport 5.
**/
  UINT32                      RootPort5Perst;

/** Offset 0x017C - CpuPeiApWakeupBufferAddr
  Address for PERST pin for Rootport 5.
**/
  UINT32                      CpuPeiApWakeupBufferAddr;

/** Offset 0x0180 - SkipPciePowerSequence
  UPD To Skip PciePowerSequence, set this UPD to 0 by default on windows.
**/
  UINT8                       SkipPciePowerSequence;

/** Offset 0x0181
**/
  UINT8                       RevAligmentFspmUpd[7];

/** Offset 0x0188 - SkipMemoryTestUpd
  UPD To Skip CpuMemoryTest, set this UPD to 0 by default on windows.
**/
  UINT8                       SkipMemoryTestUpd;

/** Offset 0x0189
**/
  UINT8                       ReservedFspmUpd[7];
} FSP_M_CONFIG;

/** Fsp M UPD Configuration
**/
typedef struct {

/** Offset 0x0000
**/
  FSP_UPD_HEADER              FspUpdHeader;

/** Offset 0x0020
**/
  FSPM_ARCH_UPD               FspmArchUpd;

/** Offset 0x0040
**/
  FSP_M_CONFIG                FspmConfig;

/** Offset 0x0190
**/
  UINT8                       UnusedUpdSpace1[118];

/** Offset 0x0206
**/
  UINT16                      UpdTerminator;
} FSPM_UPD;

#pragma pack()

#endif
