import dataclasses
from typing import Generic, Optional, Type, List

from debputy.util import T

ALL_DEBPUTY_CONFIG_OPTIONS: list["DebputyConfigOption"] = []


@dataclasses.dataclass(slots=True, frozen=True)
class DebputyConfigOption(Generic[T]):
    config_name: str
    value_type: type[T]
    default_value: T | None = None

    def __post_init__(self) -> None:
        ALL_DEBPUTY_CONFIG_OPTIONS.append(self)


DCO_SPELLCHECK_COMMENTS = DebputyConfigOption(
    "diagnostics.spellchecking.spellcheck-comments",
    bool,
    default_value=True,
)
