/****************************************************************
 *								*
 *	Copyright 2007 Fidelity Information Services, Inc	*
 *								*
 *	This source code contains the intellectual property	*
 *	of its copyright holder(s), and is made available	*
 *	under a license.  If you do not know the terms of	*
 *	the license, please stop and do not read further.	*
 *								*
 ****************************************************************/

/* Opcodes: */
I386_OP(ADD,Eb_Gb,0x00)
I386_OP(ADD,Ev_Gv,0x01)
I386_OP(ADD,Gb_Eb,0x02)
I386_OP(ADD,Gv_Ev,0x03)
I386_OP(ADD,AL_Ib,0x04)
I386_OP(ADD,eAX_Iv,0x05)
I386_OP(PUSH,ES,0x06)
I386_OP(POP,ES,0x07)

I386_OP(OR,Eb_Gb,0x08)
I386_OP(OR,Ev_Gv,0x09)
I386_OP(OR,Gb_Eb,0x0a)
I386_OP(OR,Gv_Ev,0x0b)
I386_OP(OR,AL_Ib,0x0c)
I386_OP(OR,eAX_Iv,0x0d)
I386_OP(PUSH,CS,0x0e)
I386_OP(Two_Byte_Escape,Prefix,0x0f)

I386_OP(ADC,Eb_Gb,0x10)
I386_OP(ADC,Ev_Gv,0x11)
I386_OP(ADC,Gb_Eb,0x12)
I386_OP(ADC,Gv_Ev,0x13)
I386_OP(ADC,AL_Ib,0x14)
I386_OP(ADC,eAX_Iv,0x15)
I386_OP(PUSH,SS,0x16)
I386_OP(POP,SS,0x17)

I386_OP(SBB,Eb_Gb,0x18)
I386_OP(SBB,Ev_Gv,0x19)
I386_OP(SBB,Gb_Eb,0x1a)
I386_OP(SBB,Gv_Ev,0x1b)
I386_OP(SBB,AL_Ib,0x1c)
I386_OP(SBB,eAX_Iv,0x1d)
I386_OP(PUSH,DS,0x1e)
I386_OP(POP,DS,0x1f)

I386_OP(AND,Eb_Gb,0x20)
I386_OP(AND,Ev_Gv,0x21)
I386_OP(AND,Gb_Eb,0x22)
I386_OP(AND,Gv_Ev,0x23)
I386_OP(AND,AL_Ib,0x24)
I386_OP(AND,eAX_Iv,0x25)
I386_OP(SEG,ES,0x26)
I386_OP(DAA,_,0x27)

I386_OP(SUB,Eb_Gb,0x28)
I386_OP(SUB,Ev_Gv,0x29)
I386_OP(SUB,Gb_Eb,0x2a)
I386_OP(SUB,Gv_Ev,0x2b)
I386_OP(SUB,AL_Ib,0x2c)
I386_OP(SUB,eAX_Iv,0x2d)
I386_OP(SEG,CS,0x2e)
I386_OP(DAS,_,0x2f)

I386_OP(XOR,Eb_Gb,0x30)
I386_OP(XOR,Ev_Gv,0x31)
I386_OP(XOR,Gb_Eb,0x32)
I386_OP(XOR,Gv_Ev,0x33)
I386_OP(XOR,AL_Ib,0x34)
I386_OP(XOR,eAX_Iv,0x35)
I386_OP(SEG,SS,0x36)
I386_OP(AAA,_,0x37)

I386_OP(CMP,Eb_Gb,0x38)
I386_OP(CMP,Ev_Gv,0x39)
I386_OP(CMP,Gb_Eb,0x3a)
I386_OP(CMP,Gv_Ev,0x3b)
I386_OP(CMP,AL_Ib,0x3c)
I386_OP(CMP,eAX_Iv,0x3d)
I386_OP(SEG,DS,0x3e)
I386_OP(AAS,_,0x3f)
/* On x86-64, these opcodes are used as REX Prefixes.. *
 * the one byte INC and DEC instructions are not there in the 64 bit mode !!! *
 */
#ifndef __x86_64
I386_OP(INC,eAX,0x40)
I386_OP(INC,eCX,0x41)
I386_OP(INC,eDX,0x42)
I386_OP(INC,eBX,0x43)
I386_OP(INC,eSP,0x44)
I386_OP(INC,eBP,0x45)
I386_OP(INC,eSI,0x46)
I386_OP(INC,eDI,0x47)

I386_OP(DEC,eAX,0x48)
I386_OP(DEC,eCX,0x49)
I386_OP(DEC,eDX,0x4a)
I386_OP(DEC,eBX,0x4b)
I386_OP(DEC,eSP,0x4c)
I386_OP(DEC,eBP,0x4d)
I386_OP(DEC,eSI,0x4e)
I386_OP(DEC,eDI,0x4f)
#else

I386_OP(REX_PREFIX,None,0x40)
I386_OP(REX_PREFIX,_B,0x41)
I386_OP(REX_PREFIX,_X,0x42)
I386_OP(REX_PREFIX,_X_B,0x43)
I386_OP(REX_PREFIX,_R,0x44)
I386_OP(REX_PREFIX,_R_B,0x45)
I386_OP(REX_PREFIX,_R_X,0x46)
I386_OP(REX_PREFIX,_R_X_B,0x47)

I386_OP(REX_PREFIX,_W,0x48)
I386_OP(REX_PREFIX,_W_B,0x49)
I386_OP(REX_PREFIX,_W_X,0x4a)
I386_OP(REX_PREFIX,_W_X_B,0x4b)
I386_OP(REX_PREFIX,_W_R,0x4c)
I386_OP(REX_PREFIX,_W_R_B,0x4d)
I386_OP(REX_PREFIX,_W_R_X,0x4e)
I386_OP(REX_PREFIX,_W_R_X_B,0x4f)
#endif 			/* 	__x86_64 */

I386_OP(PUSH,eAX,0x50)
I386_OP(PUSH,eCX,0x51)
I386_OP(PUSH,eDX,0x52)
I386_OP(PUSH,eBX,0x53)
I386_OP(PUSH,eSP,0x54)
I386_OP(PUSH,eBP,0x55)
I386_OP(PUSH,eSI,0x56)
I386_OP(PUSH,eDI,0x57)

I386_OP(POP,eAX,0x58)
I386_OP(POP,eCX,0x59)
I386_OP(POP,eDX,0x5a)
I386_OP(POP,eBX,0x5b)
I386_OP(POP,eSP,0x5c)
I386_OP(POP,eBP,0x5d)
I386_OP(POP,eSI,0x5e)
I386_OP(POP,eDI,0x5f)

I386_OP(PUSHA,_,0x60)
I386_OP(POPA,_,0x61)
I386_OP(BOUND,Gv_Ma,0x62)
#ifdef __i386
I386_OP(ARPL,Ew_Rw,0x63)
#else /* __x86_64 */
I386_OP(MOVSXD,Gv_Ev,0x63)
#endif /* __i386 */
I386_OP(SEG,FS,0x64)
I386_OP(SEG,GS,0x65)
I386_OP(Operand_Size,Prefix,0x66)
I386_OP(Address_Size,Prefix,0x67)

I386_OP(PUSH,Iv,0x68)
I386_OP(IMUL,GvEvIv,0x69)
I386_OP(PUSH,Ib,0x6a)
I386_OP(IMUL,GvEvIb,0x6b)
I386_OP(INSB,Yb_DX,0x6c)
I386_OP(INSW_D,Yv_DX,0x6d)
I386_OP(OUTSB,DX_Xb,0x6e)
I386_OP(OUTSW_D,DX_Xv,0x6f)

I386_OP(JO,Jb,0x70)
I386_OP(JNO,Jb,0x71)
I386_OP(JB,Jb,0x72)
I386_OP(JNB,Jb,0x73)
I386_OP(JZ,Jb,0x74)
I386_OP(JNZ,Jb,0x75)
I386_OP(JBE,Jb,0x76)
I386_OP(JNBE,Jb,0x77)

I386_OP(JS,Jb,0x78)
I386_OP(JNS,Jb,0x79)
I386_OP(JP,Jb,0x7a)
I386_OP(JNP,Jb,0x7b)
I386_OP(JL,Jb,0x7c)
I386_OP(JNL,Jb,0x7d)
I386_OP(JLE,Jb,0x7e)
I386_OP(JNLE,Jb,0x7f)

I386_OP(Grp1,Eb_Ib_Prefix,0x80)
I386_OP(Grp1,Ev_Iv_Prefix,0x81)
I386_OP(MOVB,AL_imm8,0x82)
I386_OP(Grp1,Ev_Ib_Prefix,0x83)
I386_OP(TEST,Eb_Gb,0x84)
I386_OP(TEST,Ev_Gv,0x85)
I386_OP(XCHG,Eb_Gb,0x86)
I386_OP(XCHG,Ev_Gv,0x87)

I386_OP(MOV,Eb_Gb,0x88)
I386_OP(MOV,Ev_Gv,0x89)
I386_OP(MOV,Gb_Eb,0x8a)
I386_OP(MOV,Gv_Ev,0x8b)
I386_OP(MOV,Ew_Sw,0x8c)
I386_OP(LEA,Gv_M,0x8d)
I386_OP(MOV,Sw_Ew,0x8e)
I386_OP(POP,Ev,0x8f)

I386_OP(NOP,_,0x90)
I386_OP(XCHG,eCX,0x91)
I386_OP(XCHG,eDX,0x92)
I386_OP(XCHG,eBX,0x93)
I386_OP(XCHG,eSP,0x94)
I386_OP(XCHG,eBP,0x95)
I386_OP(XCHG,eSI,0x96)
I386_OP(XCHG,eDI,0x97)

I386_OP(CBW,_,0x98)
I386_OP(CWD,_,0x99)
I386_OP(CALL,Ap,0x9a)
I386_OP(WAIT,_,0x9b)
I386_OP(PUSHF,Fv,0x9c)
I386_OP(POPF,Fv,0x9d)
I386_OP(SAHF,_,0x9e)
I386_OP(LAHF,_,0x9f)

I386_OP(MOV,AL_Ob,0xa0)
I386_OP(MOV,eAX_Ov,0xa1)
I386_OP(MOV,Ob_AL,0xa2)
I386_OP(MOV,Ov_eAX,0xa3)
I386_OP(MOVSB,Xb_Yb,0xa4)
I386_OP(MOVSW_D,Xv_Yv,0xa5)
I386_OP(CMPSB,Xb_Yb,0xa6)
I386_OP(CMPSW_D,Xv_Yv,0xa7)

I386_OP(TEST,AL_Ib,0xa8)
I386_OP(TEST,eAX_Iv,0xa9)
I386_OP(STOSB,Yb_AL,0xaa)
I386_OP(STOSW_D,Yv_eAX,0xab)
I386_OP(LODSB,AL_Xb,0xac)
I386_OP(LODSW_D,eAX_Xv,0xad)
I386_OP(SCASB,AL_Xb,0xae)
I386_OP(SCASW_D,eAX_Xv,0xaf)

I386_OP(MOV,AL,0xb0)
I386_OP(MOV,CL,0xb1)
I386_OP(MOV,DL,0xb2)
I386_OP(MOV,BL,0xb3)
I386_OP(MOV,AH,0xb4)
I386_OP(MOV,CH,0xb5)
I386_OP(MOV,DH,0xb6)
I386_OP(MOV,BH,0xb7)

I386_OP(MOV,eAX,0xb8)
I386_OP(MOV,eCX,0xb9)
I386_OP(MOV,eDX,0xba)
I386_OP(MOV,eBX,0xbb)
I386_OP(MOV,eSP,0xbc)
I386_OP(MOV,eBP,0xbd)
I386_OP(MOV,eSI,0xbe)
I386_OP(MOV,eDI,0xbf)

I386_OP(Grp2,Eb_Ib_Prefix,0xc0)
I386_OP(Grp2,Ev_Iv_Prefix,0xc1)
I386_OP(RET,near_Iw,0xc2)
I386_OP(RET,near,0xc3)
I386_OP(LES,Gv_Mp,0xc4)
I386_OP(LDS,Gv_Mp,0xc5)
I386_OP(MOV,Eb_Ib,0xc6)
I386_OP(MOV,Ev_Iv,0xc7)

I386_OP(ENTER,Iw_IB,0xc8)
I386_OP(LEAVE,_,0xc9)
I386_OP(RET,far_Iw,0xca)
I386_OP(RET,far,0xcb)
I386_OP(INT,3,0xcc)
I386_OP(INT,Ib,0xcd)
I386_OP(INTO,_,0xce)
I386_OP(IRET,_,0xcf)

I386_OP(Grp2,Eb_1_Prefix,0xd0)
I386_OP(Grp2,Ev_1_Prefix,0xd1)
I386_OP(Grp2,Eb_CL_Prefix,0xd2)
I386_OP(Grp2,Ev_CL_Prefix,0xd3)
I386_OP(AAM,_,0xd4)
I386_OP(AAD,_,0xd5)
I386_OP(INVALID_OP,D6,0xd6)
I386_OP(XLAT,_,0xd7)

I386_OP(ESC,0,0xd8)
I386_OP(ESC,1,0xd9)
I386_OP(ESC,2,0xda)
I386_OP(ESC,3,0xdb)
I386_OP(ESC,4,0xdc)
I386_OP(ESC,5,0xdd)
I386_OP(ESC,6,0xde)
I386_OP(ESC,7,0xdf)

I386_OP(LOOPNE,Jb,0xe0)
I386_OP(LOOPE,Jb,0xe1)
I386_OP(LOOP,Jb,0xe2)
I386_OP(JCXZ,Jb,0xe3)
I386_OP(IN,AL_Ib,0xe4)
I386_OP(IN,eAX_Ib,0xe5)
I386_OP(OUT,Ib_AL,0xe6)
I386_OP(OUT,Ib_eAX,0xe7)

I386_OP(CALL,Jv,0xe8)
I386_OP(JMP,Jv,0xe9)
I386_OP(JMP,Ap,0xea)
I386_OP(JMP,Jb,0xeb)
I386_OP(IN,AL_DX,0xec)
I386_OP(IN,eAX_DX,0xed)
I386_OP(OUT,DX_AL,0xee)
I386_OP(OUT,DX_eAX,0xef)

I386_OP(LOCK,Prefix,0xf0)
I386_OP(INVALID_OP,F1,0xf1)
I386_OP(REPNE,Prefix,0xf2)
I386_OP(REP_E,Prefix,0xf3)
I386_OP(HLT,_,0xf4)
I386_OP(CMC,_,0xf5)
I386_OP(Grp3,Eb_Prefix,0xf6)
I386_OP(Grp3,Ev_Prefix,0xf7)

I386_OP(CLC,_,0xf8)
I386_OP(STC,_,0xf9)
I386_OP(CLI,_,0xfa)
I386_OP(STI,_,0xfb)
I386_OP(CLD,_,0xfc)
I386_OP(STD,_,0xfd)
I386_OP(Grp4,Prefix,0xfe)
I386_OP(Grp5,Prefix,0xff)
