//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/appplatform/armappplatform/v2"
	"net/http"
	"net/url"
	"reflect"
	"regexp"
)

// DeploymentsServer is a fake server for instances of the armappplatform.DeploymentsClient type.
type DeploymentsServer struct {
	// BeginCreateOrUpdate is the fake for method DeploymentsClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated, http.StatusAccepted
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, serviceName string, appName string, deploymentName string, deploymentResource armappplatform.DeploymentResource, options *armappplatform.DeploymentsClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armappplatform.DeploymentsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method DeploymentsClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, serviceName string, appName string, deploymentName string, options *armappplatform.DeploymentsClientBeginDeleteOptions) (resp azfake.PollerResponder[armappplatform.DeploymentsClientDeleteResponse], errResp azfake.ErrorResponder)

	// BeginDisableRemoteDebugging is the fake for method DeploymentsClient.BeginDisableRemoteDebugging
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginDisableRemoteDebugging func(ctx context.Context, resourceGroupName string, serviceName string, appName string, deploymentName string, options *armappplatform.DeploymentsClientBeginDisableRemoteDebuggingOptions) (resp azfake.PollerResponder[armappplatform.DeploymentsClientDisableRemoteDebuggingResponse], errResp azfake.ErrorResponder)

	// BeginEnableRemoteDebugging is the fake for method DeploymentsClient.BeginEnableRemoteDebugging
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginEnableRemoteDebugging func(ctx context.Context, resourceGroupName string, serviceName string, appName string, deploymentName string, options *armappplatform.DeploymentsClientBeginEnableRemoteDebuggingOptions) (resp azfake.PollerResponder[armappplatform.DeploymentsClientEnableRemoteDebuggingResponse], errResp azfake.ErrorResponder)

	// BeginGenerateHeapDump is the fake for method DeploymentsClient.BeginGenerateHeapDump
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginGenerateHeapDump func(ctx context.Context, resourceGroupName string, serviceName string, appName string, deploymentName string, diagnosticParameters armappplatform.DiagnosticParameters, options *armappplatform.DeploymentsClientBeginGenerateHeapDumpOptions) (resp azfake.PollerResponder[armappplatform.DeploymentsClientGenerateHeapDumpResponse], errResp azfake.ErrorResponder)

	// BeginGenerateThreadDump is the fake for method DeploymentsClient.BeginGenerateThreadDump
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginGenerateThreadDump func(ctx context.Context, resourceGroupName string, serviceName string, appName string, deploymentName string, diagnosticParameters armappplatform.DiagnosticParameters, options *armappplatform.DeploymentsClientBeginGenerateThreadDumpOptions) (resp azfake.PollerResponder[armappplatform.DeploymentsClientGenerateThreadDumpResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method DeploymentsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, serviceName string, appName string, deploymentName string, options *armappplatform.DeploymentsClientGetOptions) (resp azfake.Responder[armappplatform.DeploymentsClientGetResponse], errResp azfake.ErrorResponder)

	// GetLogFileURL is the fake for method DeploymentsClient.GetLogFileURL
	// HTTP status codes to indicate success: http.StatusOK, http.StatusNoContent
	GetLogFileURL func(ctx context.Context, resourceGroupName string, serviceName string, appName string, deploymentName string, options *armappplatform.DeploymentsClientGetLogFileURLOptions) (resp azfake.Responder[armappplatform.DeploymentsClientGetLogFileURLResponse], errResp azfake.ErrorResponder)

	// GetRemoteDebuggingConfig is the fake for method DeploymentsClient.GetRemoteDebuggingConfig
	// HTTP status codes to indicate success: http.StatusOK
	GetRemoteDebuggingConfig func(ctx context.Context, resourceGroupName string, serviceName string, appName string, deploymentName string, options *armappplatform.DeploymentsClientGetRemoteDebuggingConfigOptions) (resp azfake.Responder[armappplatform.DeploymentsClientGetRemoteDebuggingConfigResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method DeploymentsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, serviceName string, appName string, options *armappplatform.DeploymentsClientListOptions) (resp azfake.PagerResponder[armappplatform.DeploymentsClientListResponse])

	// NewListForClusterPager is the fake for method DeploymentsClient.NewListForClusterPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListForClusterPager func(resourceGroupName string, serviceName string, options *armappplatform.DeploymentsClientListForClusterOptions) (resp azfake.PagerResponder[armappplatform.DeploymentsClientListForClusterResponse])

	// BeginRestart is the fake for method DeploymentsClient.BeginRestart
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginRestart func(ctx context.Context, resourceGroupName string, serviceName string, appName string, deploymentName string, options *armappplatform.DeploymentsClientBeginRestartOptions) (resp azfake.PollerResponder[armappplatform.DeploymentsClientRestartResponse], errResp azfake.ErrorResponder)

	// BeginStart is the fake for method DeploymentsClient.BeginStart
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginStart func(ctx context.Context, resourceGroupName string, serviceName string, appName string, deploymentName string, options *armappplatform.DeploymentsClientBeginStartOptions) (resp azfake.PollerResponder[armappplatform.DeploymentsClientStartResponse], errResp azfake.ErrorResponder)

	// BeginStartJFR is the fake for method DeploymentsClient.BeginStartJFR
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginStartJFR func(ctx context.Context, resourceGroupName string, serviceName string, appName string, deploymentName string, diagnosticParameters armappplatform.DiagnosticParameters, options *armappplatform.DeploymentsClientBeginStartJFROptions) (resp azfake.PollerResponder[armappplatform.DeploymentsClientStartJFRResponse], errResp azfake.ErrorResponder)

	// BeginStop is the fake for method DeploymentsClient.BeginStop
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginStop func(ctx context.Context, resourceGroupName string, serviceName string, appName string, deploymentName string, options *armappplatform.DeploymentsClientBeginStopOptions) (resp azfake.PollerResponder[armappplatform.DeploymentsClientStopResponse], errResp azfake.ErrorResponder)

	// BeginUpdate is the fake for method DeploymentsClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginUpdate func(ctx context.Context, resourceGroupName string, serviceName string, appName string, deploymentName string, deploymentResource armappplatform.DeploymentResource, options *armappplatform.DeploymentsClientBeginUpdateOptions) (resp azfake.PollerResponder[armappplatform.DeploymentsClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewDeploymentsServerTransport creates a new instance of DeploymentsServerTransport with the provided implementation.
// The returned DeploymentsServerTransport instance is connected to an instance of armappplatform.DeploymentsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewDeploymentsServerTransport(srv *DeploymentsServer) *DeploymentsServerTransport {
	return &DeploymentsServerTransport{
		srv:                         srv,
		beginCreateOrUpdate:         newTracker[azfake.PollerResponder[armappplatform.DeploymentsClientCreateOrUpdateResponse]](),
		beginDelete:                 newTracker[azfake.PollerResponder[armappplatform.DeploymentsClientDeleteResponse]](),
		beginDisableRemoteDebugging: newTracker[azfake.PollerResponder[armappplatform.DeploymentsClientDisableRemoteDebuggingResponse]](),
		beginEnableRemoteDebugging:  newTracker[azfake.PollerResponder[armappplatform.DeploymentsClientEnableRemoteDebuggingResponse]](),
		beginGenerateHeapDump:       newTracker[azfake.PollerResponder[armappplatform.DeploymentsClientGenerateHeapDumpResponse]](),
		beginGenerateThreadDump:     newTracker[azfake.PollerResponder[armappplatform.DeploymentsClientGenerateThreadDumpResponse]](),
		newListPager:                newTracker[azfake.PagerResponder[armappplatform.DeploymentsClientListResponse]](),
		newListForClusterPager:      newTracker[azfake.PagerResponder[armappplatform.DeploymentsClientListForClusterResponse]](),
		beginRestart:                newTracker[azfake.PollerResponder[armappplatform.DeploymentsClientRestartResponse]](),
		beginStart:                  newTracker[azfake.PollerResponder[armappplatform.DeploymentsClientStartResponse]](),
		beginStartJFR:               newTracker[azfake.PollerResponder[armappplatform.DeploymentsClientStartJFRResponse]](),
		beginStop:                   newTracker[azfake.PollerResponder[armappplatform.DeploymentsClientStopResponse]](),
		beginUpdate:                 newTracker[azfake.PollerResponder[armappplatform.DeploymentsClientUpdateResponse]](),
	}
}

// DeploymentsServerTransport connects instances of armappplatform.DeploymentsClient to instances of DeploymentsServer.
// Don't use this type directly, use NewDeploymentsServerTransport instead.
type DeploymentsServerTransport struct {
	srv                         *DeploymentsServer
	beginCreateOrUpdate         *tracker[azfake.PollerResponder[armappplatform.DeploymentsClientCreateOrUpdateResponse]]
	beginDelete                 *tracker[azfake.PollerResponder[armappplatform.DeploymentsClientDeleteResponse]]
	beginDisableRemoteDebugging *tracker[azfake.PollerResponder[armappplatform.DeploymentsClientDisableRemoteDebuggingResponse]]
	beginEnableRemoteDebugging  *tracker[azfake.PollerResponder[armappplatform.DeploymentsClientEnableRemoteDebuggingResponse]]
	beginGenerateHeapDump       *tracker[azfake.PollerResponder[armappplatform.DeploymentsClientGenerateHeapDumpResponse]]
	beginGenerateThreadDump     *tracker[azfake.PollerResponder[armappplatform.DeploymentsClientGenerateThreadDumpResponse]]
	newListPager                *tracker[azfake.PagerResponder[armappplatform.DeploymentsClientListResponse]]
	newListForClusterPager      *tracker[azfake.PagerResponder[armappplatform.DeploymentsClientListForClusterResponse]]
	beginRestart                *tracker[azfake.PollerResponder[armappplatform.DeploymentsClientRestartResponse]]
	beginStart                  *tracker[azfake.PollerResponder[armappplatform.DeploymentsClientStartResponse]]
	beginStartJFR               *tracker[azfake.PollerResponder[armappplatform.DeploymentsClientStartJFRResponse]]
	beginStop                   *tracker[azfake.PollerResponder[armappplatform.DeploymentsClientStopResponse]]
	beginUpdate                 *tracker[azfake.PollerResponder[armappplatform.DeploymentsClientUpdateResponse]]
}

// Do implements the policy.Transporter interface for DeploymentsServerTransport.
func (d *DeploymentsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "DeploymentsClient.BeginCreateOrUpdate":
		resp, err = d.dispatchBeginCreateOrUpdate(req)
	case "DeploymentsClient.BeginDelete":
		resp, err = d.dispatchBeginDelete(req)
	case "DeploymentsClient.BeginDisableRemoteDebugging":
		resp, err = d.dispatchBeginDisableRemoteDebugging(req)
	case "DeploymentsClient.BeginEnableRemoteDebugging":
		resp, err = d.dispatchBeginEnableRemoteDebugging(req)
	case "DeploymentsClient.BeginGenerateHeapDump":
		resp, err = d.dispatchBeginGenerateHeapDump(req)
	case "DeploymentsClient.BeginGenerateThreadDump":
		resp, err = d.dispatchBeginGenerateThreadDump(req)
	case "DeploymentsClient.Get":
		resp, err = d.dispatchGet(req)
	case "DeploymentsClient.GetLogFileURL":
		resp, err = d.dispatchGetLogFileURL(req)
	case "DeploymentsClient.GetRemoteDebuggingConfig":
		resp, err = d.dispatchGetRemoteDebuggingConfig(req)
	case "DeploymentsClient.NewListPager":
		resp, err = d.dispatchNewListPager(req)
	case "DeploymentsClient.NewListForClusterPager":
		resp, err = d.dispatchNewListForClusterPager(req)
	case "DeploymentsClient.BeginRestart":
		resp, err = d.dispatchBeginRestart(req)
	case "DeploymentsClient.BeginStart":
		resp, err = d.dispatchBeginStart(req)
	case "DeploymentsClient.BeginStartJFR":
		resp, err = d.dispatchBeginStartJFR(req)
	case "DeploymentsClient.BeginStop":
		resp, err = d.dispatchBeginStop(req)
	case "DeploymentsClient.BeginUpdate":
		resp, err = d.dispatchBeginUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (d *DeploymentsServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if d.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := d.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AppPlatform/Spring/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/apps/(?P<appName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/deployments/(?P<deploymentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armappplatform.DeploymentResource](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
		if err != nil {
			return nil, err
		}
		appNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("appName")])
		if err != nil {
			return nil, err
		}
		deploymentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, serviceNameParam, appNameParam, deploymentNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		d.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated, http.StatusAccepted}, resp.StatusCode) {
		d.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		d.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (d *DeploymentsServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if d.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := d.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AppPlatform/Spring/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/apps/(?P<appName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/deployments/(?P<deploymentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
		if err != nil {
			return nil, err
		}
		appNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("appName")])
		if err != nil {
			return nil, err
		}
		deploymentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginDelete(req.Context(), resourceGroupNameParam, serviceNameParam, appNameParam, deploymentNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		d.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		d.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		d.beginDelete.remove(req)
	}

	return resp, nil
}

func (d *DeploymentsServerTransport) dispatchBeginDisableRemoteDebugging(req *http.Request) (*http.Response, error) {
	if d.srv.BeginDisableRemoteDebugging == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDisableRemoteDebugging not implemented")}
	}
	beginDisableRemoteDebugging := d.beginDisableRemoteDebugging.get(req)
	if beginDisableRemoteDebugging == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AppPlatform/Spring/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/apps/(?P<appName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/deployments/(?P<deploymentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/disableRemoteDebugging`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
		if err != nil {
			return nil, err
		}
		appNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("appName")])
		if err != nil {
			return nil, err
		}
		deploymentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginDisableRemoteDebugging(req.Context(), resourceGroupNameParam, serviceNameParam, appNameParam, deploymentNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDisableRemoteDebugging = &respr
		d.beginDisableRemoteDebugging.add(req, beginDisableRemoteDebugging)
	}

	resp, err := server.PollerResponderNext(beginDisableRemoteDebugging, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		d.beginDisableRemoteDebugging.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDisableRemoteDebugging) {
		d.beginDisableRemoteDebugging.remove(req)
	}

	return resp, nil
}

func (d *DeploymentsServerTransport) dispatchBeginEnableRemoteDebugging(req *http.Request) (*http.Response, error) {
	if d.srv.BeginEnableRemoteDebugging == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginEnableRemoteDebugging not implemented")}
	}
	beginEnableRemoteDebugging := d.beginEnableRemoteDebugging.get(req)
	if beginEnableRemoteDebugging == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AppPlatform/Spring/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/apps/(?P<appName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/deployments/(?P<deploymentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/enableRemoteDebugging`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armappplatform.RemoteDebuggingPayload](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
		if err != nil {
			return nil, err
		}
		appNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("appName")])
		if err != nil {
			return nil, err
		}
		deploymentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentName")])
		if err != nil {
			return nil, err
		}
		var options *armappplatform.DeploymentsClientBeginEnableRemoteDebuggingOptions
		if !reflect.ValueOf(body).IsZero() {
			options = &armappplatform.DeploymentsClientBeginEnableRemoteDebuggingOptions{
				RemoteDebuggingPayload: &body,
			}
		}
		respr, errRespr := d.srv.BeginEnableRemoteDebugging(req.Context(), resourceGroupNameParam, serviceNameParam, appNameParam, deploymentNameParam, options)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginEnableRemoteDebugging = &respr
		d.beginEnableRemoteDebugging.add(req, beginEnableRemoteDebugging)
	}

	resp, err := server.PollerResponderNext(beginEnableRemoteDebugging, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		d.beginEnableRemoteDebugging.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginEnableRemoteDebugging) {
		d.beginEnableRemoteDebugging.remove(req)
	}

	return resp, nil
}

func (d *DeploymentsServerTransport) dispatchBeginGenerateHeapDump(req *http.Request) (*http.Response, error) {
	if d.srv.BeginGenerateHeapDump == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginGenerateHeapDump not implemented")}
	}
	beginGenerateHeapDump := d.beginGenerateHeapDump.get(req)
	if beginGenerateHeapDump == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AppPlatform/Spring/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/apps/(?P<appName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/deployments/(?P<deploymentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/generateHeapDump`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armappplatform.DiagnosticParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
		if err != nil {
			return nil, err
		}
		appNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("appName")])
		if err != nil {
			return nil, err
		}
		deploymentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginGenerateHeapDump(req.Context(), resourceGroupNameParam, serviceNameParam, appNameParam, deploymentNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginGenerateHeapDump = &respr
		d.beginGenerateHeapDump.add(req, beginGenerateHeapDump)
	}

	resp, err := server.PollerResponderNext(beginGenerateHeapDump, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		d.beginGenerateHeapDump.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginGenerateHeapDump) {
		d.beginGenerateHeapDump.remove(req)
	}

	return resp, nil
}

func (d *DeploymentsServerTransport) dispatchBeginGenerateThreadDump(req *http.Request) (*http.Response, error) {
	if d.srv.BeginGenerateThreadDump == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginGenerateThreadDump not implemented")}
	}
	beginGenerateThreadDump := d.beginGenerateThreadDump.get(req)
	if beginGenerateThreadDump == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AppPlatform/Spring/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/apps/(?P<appName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/deployments/(?P<deploymentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/generateThreadDump`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armappplatform.DiagnosticParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
		if err != nil {
			return nil, err
		}
		appNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("appName")])
		if err != nil {
			return nil, err
		}
		deploymentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginGenerateThreadDump(req.Context(), resourceGroupNameParam, serviceNameParam, appNameParam, deploymentNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginGenerateThreadDump = &respr
		d.beginGenerateThreadDump.add(req, beginGenerateThreadDump)
	}

	resp, err := server.PollerResponderNext(beginGenerateThreadDump, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		d.beginGenerateThreadDump.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginGenerateThreadDump) {
		d.beginGenerateThreadDump.remove(req)
	}

	return resp, nil
}

func (d *DeploymentsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if d.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AppPlatform/Spring/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/apps/(?P<appName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/deployments/(?P<deploymentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
	if err != nil {
		return nil, err
	}
	appNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("appName")])
	if err != nil {
		return nil, err
	}
	deploymentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.Get(req.Context(), resourceGroupNameParam, serviceNameParam, appNameParam, deploymentNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DeploymentResource, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DeploymentsServerTransport) dispatchGetLogFileURL(req *http.Request) (*http.Response, error) {
	if d.srv.GetLogFileURL == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetLogFileURL not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AppPlatform/Spring/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/apps/(?P<appName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/deployments/(?P<deploymentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/getLogFileUrl`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
	if err != nil {
		return nil, err
	}
	appNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("appName")])
	if err != nil {
		return nil, err
	}
	deploymentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.GetLogFileURL(req.Context(), resourceGroupNameParam, serviceNameParam, appNameParam, deploymentNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).LogFileURLResponse, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DeploymentsServerTransport) dispatchGetRemoteDebuggingConfig(req *http.Request) (*http.Response, error) {
	if d.srv.GetRemoteDebuggingConfig == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetRemoteDebuggingConfig not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AppPlatform/Spring/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/apps/(?P<appName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/deployments/(?P<deploymentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/getRemoteDebuggingConfig`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
	if err != nil {
		return nil, err
	}
	appNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("appName")])
	if err != nil {
		return nil, err
	}
	deploymentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.GetRemoteDebuggingConfig(req.Context(), resourceGroupNameParam, serviceNameParam, appNameParam, deploymentNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).RemoteDebugging, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DeploymentsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := d.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AppPlatform/Spring/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/apps/(?P<appName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/deployments`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 4 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
		if err != nil {
			return nil, err
		}
		appNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("appName")])
		if err != nil {
			return nil, err
		}
		versionEscaped := qp["version"]
		versionParam := make([]string, len(versionEscaped))
		for i, v := range versionEscaped {
			u, unescapeErr := url.QueryUnescape(v)
			if unescapeErr != nil {
				return nil, unescapeErr
			}
			versionParam[i] = u
		}
		var options *armappplatform.DeploymentsClientListOptions
		if len(versionParam) > 0 {
			options = &armappplatform.DeploymentsClientListOptions{
				Version: versionParam,
			}
		}
		resp := d.srv.NewListPager(resourceGroupNameParam, serviceNameParam, appNameParam, options)
		newListPager = &resp
		d.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armappplatform.DeploymentsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		d.newListPager.remove(req)
	}
	return resp, nil
}

func (d *DeploymentsServerTransport) dispatchNewListForClusterPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListForClusterPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListForClusterPager not implemented")}
	}
	newListForClusterPager := d.newListForClusterPager.get(req)
	if newListForClusterPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AppPlatform/Spring/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/deployments`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
		if err != nil {
			return nil, err
		}
		versionEscaped := qp["version"]
		versionParam := make([]string, len(versionEscaped))
		for i, v := range versionEscaped {
			u, unescapeErr := url.QueryUnescape(v)
			if unescapeErr != nil {
				return nil, unescapeErr
			}
			versionParam[i] = u
		}
		var options *armappplatform.DeploymentsClientListForClusterOptions
		if len(versionParam) > 0 {
			options = &armappplatform.DeploymentsClientListForClusterOptions{
				Version: versionParam,
			}
		}
		resp := d.srv.NewListForClusterPager(resourceGroupNameParam, serviceNameParam, options)
		newListForClusterPager = &resp
		d.newListForClusterPager.add(req, newListForClusterPager)
		server.PagerResponderInjectNextLinks(newListForClusterPager, req, func(page *armappplatform.DeploymentsClientListForClusterResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListForClusterPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListForClusterPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListForClusterPager) {
		d.newListForClusterPager.remove(req)
	}
	return resp, nil
}

func (d *DeploymentsServerTransport) dispatchBeginRestart(req *http.Request) (*http.Response, error) {
	if d.srv.BeginRestart == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginRestart not implemented")}
	}
	beginRestart := d.beginRestart.get(req)
	if beginRestart == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AppPlatform/Spring/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/apps/(?P<appName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/deployments/(?P<deploymentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/restart`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
		if err != nil {
			return nil, err
		}
		appNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("appName")])
		if err != nil {
			return nil, err
		}
		deploymentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginRestart(req.Context(), resourceGroupNameParam, serviceNameParam, appNameParam, deploymentNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginRestart = &respr
		d.beginRestart.add(req, beginRestart)
	}

	resp, err := server.PollerResponderNext(beginRestart, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		d.beginRestart.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginRestart) {
		d.beginRestart.remove(req)
	}

	return resp, nil
}

func (d *DeploymentsServerTransport) dispatchBeginStart(req *http.Request) (*http.Response, error) {
	if d.srv.BeginStart == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginStart not implemented")}
	}
	beginStart := d.beginStart.get(req)
	if beginStart == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AppPlatform/Spring/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/apps/(?P<appName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/deployments/(?P<deploymentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/start`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
		if err != nil {
			return nil, err
		}
		appNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("appName")])
		if err != nil {
			return nil, err
		}
		deploymentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginStart(req.Context(), resourceGroupNameParam, serviceNameParam, appNameParam, deploymentNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginStart = &respr
		d.beginStart.add(req, beginStart)
	}

	resp, err := server.PollerResponderNext(beginStart, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		d.beginStart.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginStart) {
		d.beginStart.remove(req)
	}

	return resp, nil
}

func (d *DeploymentsServerTransport) dispatchBeginStartJFR(req *http.Request) (*http.Response, error) {
	if d.srv.BeginStartJFR == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginStartJFR not implemented")}
	}
	beginStartJFR := d.beginStartJFR.get(req)
	if beginStartJFR == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AppPlatform/Spring/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/apps/(?P<appName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/deployments/(?P<deploymentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/startJFR`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armappplatform.DiagnosticParameters](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
		if err != nil {
			return nil, err
		}
		appNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("appName")])
		if err != nil {
			return nil, err
		}
		deploymentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginStartJFR(req.Context(), resourceGroupNameParam, serviceNameParam, appNameParam, deploymentNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginStartJFR = &respr
		d.beginStartJFR.add(req, beginStartJFR)
	}

	resp, err := server.PollerResponderNext(beginStartJFR, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		d.beginStartJFR.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginStartJFR) {
		d.beginStartJFR.remove(req)
	}

	return resp, nil
}

func (d *DeploymentsServerTransport) dispatchBeginStop(req *http.Request) (*http.Response, error) {
	if d.srv.BeginStop == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginStop not implemented")}
	}
	beginStop := d.beginStop.get(req)
	if beginStop == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AppPlatform/Spring/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/apps/(?P<appName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/deployments/(?P<deploymentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/stop`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
		if err != nil {
			return nil, err
		}
		appNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("appName")])
		if err != nil {
			return nil, err
		}
		deploymentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginStop(req.Context(), resourceGroupNameParam, serviceNameParam, appNameParam, deploymentNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginStop = &respr
		d.beginStop.add(req, beginStop)
	}

	resp, err := server.PollerResponderNext(beginStop, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		d.beginStop.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginStop) {
		d.beginStop.remove(req)
	}

	return resp, nil
}

func (d *DeploymentsServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if d.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := d.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.AppPlatform/Spring/(?P<serviceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/apps/(?P<appName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/deployments/(?P<deploymentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armappplatform.DeploymentResource](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		serviceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("serviceName")])
		if err != nil {
			return nil, err
		}
		appNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("appName")])
		if err != nil {
			return nil, err
		}
		deploymentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("deploymentName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := d.srv.BeginUpdate(req.Context(), resourceGroupNameParam, serviceNameParam, appNameParam, deploymentNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		d.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		d.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		d.beginUpdate.remove(req)
	}

	return resp, nil
}
