//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armbotservice_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/botservice/armbotservice"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/botservice/resource-manager/Microsoft.BotService/stable/2022-09-15/examples/ListServiceProviders.json
func ExampleBotConnectionClient_ListServiceProviders() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbotservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewBotConnectionClient().ListServiceProviders(ctx, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ServiceProviderResponseList = armbotservice.ServiceProviderResponseList{
	// 	Value: []*armbotservice.ServiceProvider{
	// 		{
	// 			Properties: &armbotservice.ServiceProviderProperties{
	// 				DevPortalURL: to.Ptr("sampleDevPortalUrl"),
	// 				DisplayName: to.Ptr("sample service provider display name"),
	// 				IconURL: to.Ptr("sampleIconUrl"),
	// 				ID: to.Ptr("sampleServiceProviderId"),
	// 				Parameters: []*armbotservice.ServiceProviderParameter{
	// 					{
	// 						Name: to.Ptr("sampleParameterName"),
	// 						Type: to.Ptr("sampleParameterType"),
	// 						Description: to.Ptr("sampleDescription"),
	// 						Default: to.Ptr("sampleDefaultValue"),
	// 						DisplayName: to.Ptr("sampleDisplayName"),
	// 						HelpURL: to.Ptr("sampleHelpUrl"),
	// 				}},
	// 				ServiceProviderName: to.Ptr("sampleServiceProvider"),
	// 			},
	// 	}},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/botservice/resource-manager/Microsoft.BotService/stable/2022-09-15/examples/GetConnection.json
func ExampleBotConnectionClient_ListWithSecrets() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbotservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewBotConnectionClient().ListWithSecrets(ctx, "OneResourceGroupName", "samplebotname", "sampleConnection", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ConnectionSetting = armbotservice.ConnectionSetting{
	// 	Name: to.Ptr("sampleConnection"),
	// 	Etag: to.Ptr("etag1"),
	// 	ID: to.Ptr("/subscriptions/subscription-id/resourceGroups/OneResourceGroupName/providers/Microsoft.BotService/botServices/samplebotname/connections/sampleConnection"),
	// 	Location: to.Ptr("global"),
	// 	Properties: &armbotservice.ConnectionSettingProperties{
	// 		ClientID: to.Ptr("sampleclientid"),
	// 		Parameters: []*armbotservice.ConnectionSettingParameter{
	// 			{
	// 				Key: to.Ptr("key1"),
	// 				Value: to.Ptr("value1"),
	// 			},
	// 			{
	// 				Key: to.Ptr("key2"),
	// 				Value: to.Ptr("value2"),
	// 		}},
	// 		Scopes: to.Ptr("samplescope"),
	// 		ServiceProviderDisplayName: to.Ptr("serviceProviderDisplayName"),
	// 		ServiceProviderID: to.Ptr("serviceproviderid"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/botservice/resource-manager/Microsoft.BotService/stable/2022-09-15/examples/PutConnection.json
func ExampleBotConnectionClient_Create() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbotservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewBotConnectionClient().Create(ctx, "OneResourceGroupName", "samplebotname", "sampleConnection", armbotservice.ConnectionSetting{
		Etag:     to.Ptr("etag1"),
		Location: to.Ptr("West US"),
		Properties: &armbotservice.ConnectionSettingProperties{
			ClientID:     to.Ptr("sampleclientid"),
			ClientSecret: to.Ptr("samplesecret"),
			Parameters: []*armbotservice.ConnectionSettingParameter{
				{
					Key:   to.Ptr("key1"),
					Value: to.Ptr("value1"),
				},
				{
					Key:   to.Ptr("key2"),
					Value: to.Ptr("value2"),
				}},
			Scopes:            to.Ptr("samplescope"),
			ServiceProviderID: to.Ptr("serviceproviderid"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ConnectionSetting = armbotservice.ConnectionSetting{
	// 	Name: to.Ptr("sampleConnection"),
	// 	Etag: to.Ptr("etag1"),
	// 	ID: to.Ptr("/subscriptions/subscription-id/resourceGroups/OneResourceGroupName/providers/Microsoft.BotService/botServices/samplebotname/connections/sampleConnection"),
	// 	Location: to.Ptr("global"),
	// 	Properties: &armbotservice.ConnectionSettingProperties{
	// 		ClientID: to.Ptr("sampleclientid"),
	// 		Parameters: []*armbotservice.ConnectionSettingParameter{
	// 			{
	// 				Key: to.Ptr("key1"),
	// 				Value: to.Ptr("value1"),
	// 			},
	// 			{
	// 				Key: to.Ptr("key2"),
	// 				Value: to.Ptr("value2"),
	// 		}},
	// 		Scopes: to.Ptr("samplescope"),
	// 		ServiceProviderDisplayName: to.Ptr("serviceProviderDisplayName"),
	// 		ServiceProviderID: to.Ptr("serviceproviderid"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/botservice/resource-manager/Microsoft.BotService/stable/2022-09-15/examples/UpdateConnection.json
func ExampleBotConnectionClient_Update() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbotservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewBotConnectionClient().Update(ctx, "OneResourceGroupName", "samplebotname", "sampleConnection", armbotservice.ConnectionSetting{
		Etag:     to.Ptr("etag1"),
		Location: to.Ptr("global"),
		Properties: &armbotservice.ConnectionSettingProperties{
			ClientID:     to.Ptr("sampleclientid"),
			ClientSecret: to.Ptr("samplesecret"),
			Parameters: []*armbotservice.ConnectionSettingParameter{
				{
					Key:   to.Ptr("key1"),
					Value: to.Ptr("value1"),
				},
				{
					Key:   to.Ptr("key2"),
					Value: to.Ptr("value2"),
				}},
			Scopes:                     to.Ptr("samplescope"),
			ServiceProviderDisplayName: to.Ptr("serviceProviderDisplayName"),
			ServiceProviderID:          to.Ptr("serviceproviderid"),
		},
	}, nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ConnectionSetting = armbotservice.ConnectionSetting{
	// 	Name: to.Ptr("sampleConnection"),
	// 	ID: to.Ptr("/subscriptions/subscription-id/resourceGroups/OneResourceGroupName/providers/Microsoft.BotService/botServices/samplebotname/connections/sampleConnection"),
	// 	Location: to.Ptr("global"),
	// 	Properties: &armbotservice.ConnectionSettingProperties{
	// 		ClientID: to.Ptr("sampleclientid"),
	// 		Parameters: []*armbotservice.ConnectionSettingParameter{
	// 			{
	// 				Key: to.Ptr("key1"),
	// 				Value: to.Ptr("value1"),
	// 			},
	// 			{
	// 				Key: to.Ptr("key2"),
	// 				Value: to.Ptr("value2"),
	// 		}},
	// 		Scopes: to.Ptr("samplescope"),
	// 		ServiceProviderDisplayName: to.Ptr("serviceProviderDisplayName"),
	// 		ServiceProviderID: to.Ptr("serviceproviderid"),
	// 	},
	// }
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/botservice/resource-manager/Microsoft.BotService/stable/2022-09-15/examples/DeleteConnection.json
func ExampleBotConnectionClient_Delete() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbotservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	_, err = clientFactory.NewBotConnectionClient().Delete(ctx, "OneResourceGroupName", "samplebotname", "sampleConnection", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/e7bf3adfa2d5e5cdbb804eec35279501794f461c/specification/botservice/resource-manager/Microsoft.BotService/stable/2022-09-15/examples/ListConnectionsByBotService.json
func ExampleBotConnectionClient_NewListByBotServicePager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armbotservice.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewBotConnectionClient().NewListByBotServicePager("OneResourceGroupName", "samplebotname", nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ConnectionSettingResponseList = armbotservice.ConnectionSettingResponseList{
		// 	Value: []*armbotservice.ConnectionSetting{
		// 		{
		// 			Name: to.Ptr("sampleConnection"),
		// 			ID: to.Ptr("/subscriptions/subscription-id/providers/Microsoft.BotService/botServices"),
		// 			Properties: &armbotservice.ConnectionSettingProperties{
		// 				ClientID: to.Ptr("sampleclientid"),
		// 				Parameters: []*armbotservice.ConnectionSettingParameter{
		// 					{
		// 						Key: to.Ptr("key1"),
		// 						Value: to.Ptr("value1"),
		// 					},
		// 					{
		// 						Key: to.Ptr("key2"),
		// 						Value: to.Ptr("value2"),
		// 				}},
		// 				Scopes: to.Ptr("samplescope"),
		// 				ServiceProviderID: to.Ptr("serviceproviderid"),
		// 			},
		// 	}},
		// }
	}
}
