//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/hybriddatamanager/armhybriddatamanager"
	"net/http"
	"net/url"
	"regexp"
)

// DataStoreTypesServer is a fake server for instances of the armhybriddatamanager.DataStoreTypesClient type.
type DataStoreTypesServer struct {
	// Get is the fake for method DataStoreTypesClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, dataStoreTypeName string, resourceGroupName string, dataManagerName string, options *armhybriddatamanager.DataStoreTypesClientGetOptions) (resp azfake.Responder[armhybriddatamanager.DataStoreTypesClientGetResponse], errResp azfake.ErrorResponder)

	// NewListByDataManagerPager is the fake for method DataStoreTypesClient.NewListByDataManagerPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByDataManagerPager func(resourceGroupName string, dataManagerName string, options *armhybriddatamanager.DataStoreTypesClientListByDataManagerOptions) (resp azfake.PagerResponder[armhybriddatamanager.DataStoreTypesClientListByDataManagerResponse])
}

// NewDataStoreTypesServerTransport creates a new instance of DataStoreTypesServerTransport with the provided implementation.
// The returned DataStoreTypesServerTransport instance is connected to an instance of armhybriddatamanager.DataStoreTypesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewDataStoreTypesServerTransport(srv *DataStoreTypesServer) *DataStoreTypesServerTransport {
	return &DataStoreTypesServerTransport{
		srv:                       srv,
		newListByDataManagerPager: newTracker[azfake.PagerResponder[armhybriddatamanager.DataStoreTypesClientListByDataManagerResponse]](),
	}
}

// DataStoreTypesServerTransport connects instances of armhybriddatamanager.DataStoreTypesClient to instances of DataStoreTypesServer.
// Don't use this type directly, use NewDataStoreTypesServerTransport instead.
type DataStoreTypesServerTransport struct {
	srv                       *DataStoreTypesServer
	newListByDataManagerPager *tracker[azfake.PagerResponder[armhybriddatamanager.DataStoreTypesClientListByDataManagerResponse]]
}

// Do implements the policy.Transporter interface for DataStoreTypesServerTransport.
func (d *DataStoreTypesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "DataStoreTypesClient.Get":
		resp, err = d.dispatchGet(req)
	case "DataStoreTypesClient.NewListByDataManagerPager":
		resp, err = d.dispatchNewListByDataManagerPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (d *DataStoreTypesServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if d.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HybridData/dataManagers/(?P<dataManagerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/dataStoreTypes/(?P<dataStoreTypeName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	dataStoreTypeNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataStoreTypeName")])
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	dataManagerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataManagerName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := d.srv.Get(req.Context(), dataStoreTypeNameParam, resourceGroupNameParam, dataManagerNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DataStoreType, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (d *DataStoreTypesServerTransport) dispatchNewListByDataManagerPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListByDataManagerPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByDataManagerPager not implemented")}
	}
	newListByDataManagerPager := d.newListByDataManagerPager.get(req)
	if newListByDataManagerPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.HybridData/dataManagers/(?P<dataManagerName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/dataStoreTypes`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		dataManagerNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("dataManagerName")])
		if err != nil {
			return nil, err
		}
		resp := d.srv.NewListByDataManagerPager(resourceGroupNameParam, dataManagerNameParam, nil)
		newListByDataManagerPager = &resp
		d.newListByDataManagerPager.add(req, newListByDataManagerPager)
		server.PagerResponderInjectNextLinks(newListByDataManagerPager, req, func(page *armhybriddatamanager.DataStoreTypesClientListByDataManagerResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByDataManagerPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListByDataManagerPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByDataManagerPager) {
		d.newListByDataManagerPager.remove(req)
	}
	return resp, nil
}
