//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmigrate

import "time"

// AssessedDisk - A disk assessed for an assessment.
type AssessedDisk struct {
	// READ-ONLY; User friendly name of the assessed disk.
	DisplayName *string

	// READ-ONLY; Gigabytes of storage provided by the recommended Azure disk size.
	GigabytesForRecommendedDiskSize *int32

	// READ-ONLY; Gigabytes of storage provisioned for this disk.
	GigabytesProvisioned *float64

	// READ-ONLY; Disk throughput in MegaBytes per second.
	MegabytesPerSecondOfRead *float64

	// READ-ONLY; Disk throughput in MegaBytes per second.
	MegabytesPerSecondOfWrite *float64

	// READ-ONLY; Estimated aggregate storage cost for a 31-day month for this disk.
	MonthlyStorageCost *float64

	// READ-ONLY; Name of the assessed disk.
	Name *string

	// READ-ONLY; Number of read operations per second for the disk.
	NumberOfReadOperationsPerSecond *float64

	// READ-ONLY; Number of read and write operations per second for the disk.
	NumberOfWriteOperationsPerSecond *float64

	// READ-ONLY; Recommended Azure size for the disk, given utilization data and preferences set on Assessment.
	RecommendedDiskSize *AzureDiskSize

	// READ-ONLY; Storage type selected for this disk.
	RecommendedDiskType *AzureDiskType

	// READ-ONLY; Whether this disk is suitable for Azure.
	Suitability *CloudSuitability

	// READ-ONLY; If disk is suitable to be migrate but some conditions/checks were not considered while calculating suitability,
	// this explains the details.
	SuitabilityDetail *AzureDiskSuitabilityDetail

	// READ-ONLY; If disk is not suitable to be migrated, this explains the reasons and mitigation steps.
	SuitabilityExplanation *AzureDiskSuitabilityExplanation
}

// AssessedMachine - A machine evaluated as part of an assessment.
type AssessedMachine struct {
	// For optimistic concurrency control.
	ETag *string

	// Properties of an assessed machine.
	Properties *AssessedMachineProperties

	// READ-ONLY; Path reference to this assessed machine.
	// /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/groups/{groupName}/assessments/{assessmentName}/assessedMachines/{assessedMachineName}
	ID *string

	// READ-ONLY; Name of the machine.
	Name *string

	// READ-ONLY; Type of the object = [Microsoft.Migrate/assessmentProjects/groups/assessments/assessedMachines].
	Type *string
}

// AssessedMachineProperties - Properties of an assessed machine.
type AssessedMachineProperties struct {
	// READ-ONLY; Boot type of the machine.
	BootType *MachineBootType

	// READ-ONLY; Confidence rating of assessed machine.
	ConfidenceRatingInPercentage *float64

	// READ-ONLY; Time when this machine was created. Date-Time represented in ISO-8601 format.
	CreatedTimestamp *time.Time

	// READ-ONLY; ARM ID of the discovered machine.
	DatacenterMachineArmID *string

	// READ-ONLY; ARM ID of the discovered datacenter.
	DatacenterManagementServerArmID *string

	// READ-ONLY; Name of the server hosting the datacenter management solution.
	DatacenterManagementServerName *string

	// READ-ONLY; Description of the machine
	Description *string

	// READ-ONLY; Dictionary of disks attached to the machine. Key is ID of disk. Value is a disk object.
	Disks map[string]*AssessedDisk

	// READ-ONLY; User readable name of the machine as defined by the user in their private datacenter.
	DisplayName *string

	// READ-ONLY; Memory in Megabytes.
	MegabytesOfMemory *float64

	// READ-ONLY; Megabytes of memory in the Recommended Azure VM Size.
	MegabytesOfMemoryForRecommendedSize *float64

	// READ-ONLY; Monthly network cost estimate for the network adapters that are attached to this machine as a group, for a 31-day
	// month.
	MonthlyBandwidthCost *float64

	// READ-ONLY; Compute Cost for a 31-day month, if the machine is migrated to Azure with the Recommended Size.
	MonthlyComputeCostForRecommendedSize *float64

	// READ-ONLY; Monthly premium storage cost estimate for the disks that are attached to this machine as a group, for a 31-day
	// month.
	MonthlyPremiumStorageCost *float64

	// READ-ONLY; Monthly standard SSD storage cost estimate for the disks that are attached to this machine as a group, for a
	// 31-day month.
	MonthlyStandardSSDStorageCost *float64

	// READ-ONLY; Monthly storage cost estimate for the disks that are attached to this machine as a group, for a 31-day month.
	MonthlyStorageCost *float64

	// READ-ONLY; Dictionary of network adapters attached to the machine. Key is name of the adapter. Value is a network adapter
	// object.
	NetworkAdapters map[string]*AssessedNetworkAdapter

	// READ-ONLY; Processor count.
	NumberOfCores *int32

	// READ-ONLY; Number of CPU cores in the Recommended Azure VM Size.
	NumberOfCoresForRecommendedSize *int32

	// READ-ONLY; Operating System name of the machine.
	OperatingSystemName *string

	// READ-ONLY; Operating System type of the machine.
	OperatingSystemType *string

	// READ-ONLY; Operating System version of the machine.
	OperatingSystemVersion *string

	// READ-ONLY; Utilization percentage of the processor core as observed in the private data center, in the Time Range selected
	// on Assessment, reported as the Percentile value based on the percentile number selected
	// in assessment.
	PercentageCoresUtilization *float64

	// READ-ONLY; Utilization percentage of the memory as observed in the private data center, in the Time Range selected on Assessment,
	// reported as the Percentile value based on the percentile number selected in
	// assessment.
	PercentageMemoryUtilization *float64

	// READ-ONLY; Recommended Azure size for this machine.
	RecommendedSize *AzureVMSize

	// READ-ONLY; Whether machine is suitable for migration to Azure.
	Suitability *CloudSuitability

	// READ-ONLY; If machine is not suitable for cloud, this explains the reasons.
	SuitabilityDetail *AzureVMSuitabilityDetail

	// READ-ONLY; If machine is not ready to be migrated, this explains the reasons and mitigation steps.
	SuitabilityExplanation *AzureVMSuitabilityExplanation

	// READ-ONLY; Time when this machine was last updated. Date-Time represented in ISO-8601 format.
	UpdatedTimestamp *time.Time
}

// AssessedMachineResultList - List of assessed machines.
type AssessedMachineResultList struct {
	NextLink *string

	// List of assessed machines.
	Value []*AssessedMachine
}

// AssessedNetworkAdapter - A network adapter assessed for an assessment.
type AssessedNetworkAdapter struct {
	// Gigabytes transmitted through this adapter each month.
	NetGigabytesTransmittedPerMonth *float64

	// READ-ONLY; User friendly name of the assessed network adapter.
	DisplayName *string

	// READ-ONLY; List of IP Addresses on the network adapter.
	IPAddresses []*string

	// READ-ONLY; MAC Address of the network adapter.
	MacAddress *string

	// READ-ONLY; Adapter throughput for incoming traffic in MegaBytes per second.
	MegabytesPerSecondReceived *float64

	// READ-ONLY; Adapter throughput for outgoing traffic in MegaBytes per second.
	MegabytesPerSecondTransmitted *float64

	// READ-ONLY; Monthly cost estimate for network bandwidth used by this network adapter.
	MonthlyBandwidthCosts *float64

	// READ-ONLY; Whether this adapter is suitable for Azure.
	Suitability *CloudSuitability

	// READ-ONLY; If network adapter is not suitable for cloud, this explains the reasons.
	SuitabilityDetail *AzureNetworkAdapterSuitabilityDetail

	// READ-ONLY; If network adapter is suitable, this explains the reasons and mitigation steps.
	SuitabilityExplanation *AzureNetworkAdapterSuitabilityExplanation
}

// Assessment - An assessment created for a group in the Migration project.
type Assessment struct {
	// REQUIRED; Properties of the assessment.
	Properties *AssessmentProperties

	// For optimistic concurrency control.
	ETag *string

	// READ-ONLY; Path reference to this assessment.
	// /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/groups/{groupName}/assessment/{assessmentName}
	ID *string

	// READ-ONLY; Unique name of an assessment.
	Name *string

	// READ-ONLY; Type of the object = [Microsoft.Migrate/assessmentProjects/groups/assessments].
	Type *string
}

// AssessmentOptions - Assessment options.
type AssessmentOptions struct {
	// REQUIRED; Properties of the assessment options.
	Properties *AssessmentOptionsProperties

	// READ-ONLY; Unique identifier of an assessment options.
	ID *string

	// READ-ONLY; Unique name of an assessment options.
	Name *string
}

// AssessmentOptionsProperties - Assessment options properties.
type AssessmentOptionsProperties struct {
	// READ-ONLY; List of supported currencies for reserved instances.
	ReservedInstanceSupportedCurrencies []*string

	// READ-ONLY; List of supported Azure regions for reserved instances.
	ReservedInstanceSupportedLocations []*string

	// READ-ONLY; List of supported Azure offer codes for reserved instances.
	ReservedInstanceSupportedOffers []*string

	// READ-ONLY; List of supported VM Families.
	ReservedInstanceVMFamilies []*string

	// READ-ONLY; Dictionary of VM families grouped by vm family name describing the targeted azure locations of VM family and
	// the category of the family.
	VMFamilies []*VMFamily
}

// AssessmentOptionsResultList - List of API operations.
type AssessmentOptionsResultList struct {
	// List of operations.
	Value []*AssessmentOptions
}

// AssessmentProperties - Properties of an assessment.
type AssessmentProperties struct {
	// REQUIRED; Storage type selected for this disk.
	AzureDiskType *AzureDiskType

	// REQUIRED; AHUB discount on windows virtual machines.
	AzureHybridUseBenefit *AzureHybridUseBenefit

	// REQUIRED; Target Azure location for which the machines should be assessed. These enums are the same as used by Compute
	// API.
	AzureLocation *AzureLocation

	// REQUIRED; Offer code according to which cost estimation is done.
	AzureOfferCode *AzureOfferCode

	// REQUIRED; Pricing tier for Size evaluation.
	AzurePricingTier *AzurePricingTier

	// REQUIRED; Storage Redundancy type offered by Azure.
	AzureStorageRedundancy *AzureStorageRedundancy

	// REQUIRED; List of azure VM families.
	AzureVMFamilies []*AzureVMFamily

	// REQUIRED; Currency to report prices in.
	Currency *Currency

	// REQUIRED; Custom discount percentage to be applied on final costs. Can be in the range [0, 100].
	DiscountPercentage *float64

	// REQUIRED; Percentile of performance data used to recommend Azure size.
	Percentile *Percentile

	// REQUIRED; Azure reserved instance.
	ReservedInstance *ReservedInstance

	// REQUIRED; Scaling factor used over utilization data to add a performance buffer for new machines to be created in Azure.
	// Min Value = 1.0, Max value = 1.9, Default = 1.3.
	ScalingFactor *float64

	// REQUIRED; Assessment sizing criterion.
	SizingCriterion *AssessmentSizingCriterion

	// REQUIRED; User configurable setting that describes the status of the assessment.
	Stage *AssessmentStage

	// REQUIRED; Time range of performance data used to recommend a size.
	TimeRange *TimeRange

	// REQUIRED; Specify the duration for which the VMs are up in the on-premises environment.
	VMUptime *VMUptime

	// READ-ONLY; Confidence rating percentage for assessment. Can be in the range [0, 100].
	ConfidenceRatingInPercentage *float64

	// READ-ONLY; Time when this project was created. Date-Time represented in ISO-8601 format.
	CreatedTimestamp *time.Time

	// READ-ONLY; Enterprise agreement subscription arm id.
	EaSubscriptionID *string

	// READ-ONLY; Monthly network cost estimate for the machines that are part of this assessment as a group, for a 31-day month.
	MonthlyBandwidthCost *float64

	// READ-ONLY; Monthly compute cost estimate for the machines that are part of this assessment as a group, for a 31-day month.
	MonthlyComputeCost *float64

	// READ-ONLY; Monthly premium storage cost estimate for the machines that are part of this assessment as a group, for a 31-day
	// month.
	MonthlyPremiumStorageCost *float64

	// READ-ONLY; Monthly standard SSD storage cost estimate for the machines that are part of this assessment as a group, for
	// a 31-day month.
	MonthlyStandardSSDStorageCost *float64

	// READ-ONLY; Monthly storage cost estimate for the machines that are part of this assessment as a group, for a 31-day month.
	MonthlyStorageCost *float64

	// READ-ONLY; Number of assessed machines part of this assessment.
	NumberOfMachines *int32

	// READ-ONLY; End time to consider performance data for assessment
	PerfDataEndTime *time.Time

	// READ-ONLY; Start time to consider performance data for assessment
	PerfDataStartTime *time.Time

	// READ-ONLY; Time when the Azure Prices were queried. Date-Time represented in ISO-8601 format.
	PricesTimestamp *time.Time

	// READ-ONLY; Whether the assessment has been created and is valid.
	Status *AssessmentStatus

	// READ-ONLY; Time when this project was last updated. Date-Time represented in ISO-8601 format.
	UpdatedTimestamp *time.Time
}

// AssessmentResultList - List of assessments.
type AssessmentResultList struct {
	// List of assessments.
	Value []*Assessment
}

type CollectorAgentProperties struct {
	SpnDetails *CollectorBodyAgentSpnProperties

	// READ-ONLY
	ID *string

	// READ-ONLY
	LastHeartbeatUTC *time.Time

	// READ-ONLY
	Version *string
}

type CollectorBodyAgentSpnProperties struct {
	// Application/client Id for the service principal with which the on-premise management/data plane components would communicate
	// with our Azure services.
	ApplicationID *string

	// Intended audience for the service principal.
	Audience *string

	// AAD Authority URL which was used to request the token for the service principal.
	Authority *string

	// Object Id of the service principal with which the on-premise management/data plane components would communicate with our
	// Azure services.
	ObjectID *string

	// Tenant Id for the service principal with which the on-premise management/data plane components would communicate with our
	// Azure services.
	TenantID *string
}

type CollectorProperties struct {
	AgentProperties *CollectorAgentProperties

	// The ARM id of the discovery service site.
	DiscoverySiteID *string

	// READ-ONLY; Time when this collector was created. Date-Time represented in ISO-8601 format.
	CreatedTimestamp *string

	// READ-ONLY; Time when this collector was updated. Date-Time represented in ISO-8601 format.
	UpdatedTimestamp *string
}

// Disk - A disk discovered on a machine.
type Disk struct {
	// READ-ONLY; User friendly name of the disk.
	DisplayName *string

	// READ-ONLY; Gigabytes of storage provisioned for this disk.
	GigabytesAllocated *float64
}

// DownloadURL - Download URL for assessment report.
type DownloadURL struct {
	// READ-ONLY; Hyperlink to download report.
	AssessmentReportURL *string

	// READ-ONLY; Expiry date of download url.
	ExpirationTime *time.Time
}

// Group - A group created in a Migration project.
type Group struct {
	// REQUIRED; Properties of the group.
	Properties *GroupProperties

	// For optimistic concurrency control.
	ETag *string

	// READ-ONLY; Path reference to this group. /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/groups/{groupName}
	ID *string

	// READ-ONLY; Name of the group.
	Name *string

	// READ-ONLY; Type of the object = [Microsoft.Migrate/assessmentProjects/groups].
	Type *string
}

// GroupBodyProperties - Body properties of group update.
type GroupBodyProperties struct {
	// List of machine names that are part of this group.
	Machines []*string

	// Whether to add or remove the machines.
	OperationType *GroupUpdateOperation
}

// GroupProperties - Properties of group resource.
type GroupProperties struct {
	// The type of group.
	GroupType *string

	// READ-ONLY; If the assessments are in running state.
	AreAssessmentsRunning *bool

	// READ-ONLY; List of References to Assessments created on this group.
	Assessments []*string

	// READ-ONLY; Time when this group was created. Date-Time represented in ISO-8601 format.
	CreatedTimestamp *time.Time

	// READ-ONLY; Whether the group has been created and is valid.
	GroupStatus *GroupStatus

	// READ-ONLY; Number of machines part of this group.
	MachineCount *int32

	// READ-ONLY; Time when this group was last updated. Date-Time represented in ISO-8601 format.
	UpdatedTimestamp *time.Time
}

// GroupResultList - List of groups.
type GroupResultList struct {
	// List of groups.
	Value []*Group
}

type HyperVCollector struct {
	ETag       *string
	Properties *CollectorProperties

	// READ-ONLY
	ID *string

	// READ-ONLY
	Name *string

	// READ-ONLY
	Type *string
}

// HyperVCollectorList - List of Hyper-V collectors.
type HyperVCollectorList struct {
	// List of Hyper-V collectors.
	Value []*HyperVCollector
}

type ImportCollector struct {
	ETag       *string
	Properties *ImportCollectorProperties

	// READ-ONLY
	ID *string

	// READ-ONLY
	Name *string

	// READ-ONLY
	Type *string
}

// ImportCollectorList - List of Import collectors.
type ImportCollectorList struct {
	// List of Import collectors.
	Value []*ImportCollector
}

type ImportCollectorProperties struct {
	DiscoverySiteID *string

	// READ-ONLY
	CreatedTimestamp *string

	// READ-ONLY
	UpdatedTimestamp *string
}

// Machine - A machine in a migration project.
type Machine struct {
	// For optimistic concurrency control.
	ETag *string

	// Properties of the machine.
	Properties *MachineProperties

	// READ-ONLY; Path reference to this machine. /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/machines/{machineName}
	ID *string

	// READ-ONLY; Name of the machine. It is a GUID which is unique identifier of machine in private data center. For user-readable
	// name, we have a displayName property on this machine.
	Name *string

	// READ-ONLY; Type of the object = [Microsoft.Migrate/assessmentProjects/machines].
	Type *string
}

// MachineProperties - Properties of a machine.
type MachineProperties struct {
	// READ-ONLY; Boot type of the machine.
	BootType *MachineBootType

	// READ-ONLY; Time when this machine was created. Date-Time represented in ISO-8601 format.
	CreatedTimestamp *time.Time

	// READ-ONLY; ARM ID of the data center as tracked by the Microsoft.OffAzure.
	DatacenterManagementServerArmID *string

	// READ-ONLY; Name of the server hosting the datacenter management solution.
	DatacenterManagementServerName *string

	// READ-ONLY; Description of the machine
	Description *string

	// READ-ONLY; ARM ID of the machine as tracked by the Microsoft.OffAzure.
	DiscoveryMachineArmID *string

	// READ-ONLY; Dictionary of disks attached to the machine. Key is ID of disk. Value is a disk object
	Disks map[string]*Disk

	// READ-ONLY; User readable name of the machine as defined by the user in their private datacenter.
	DisplayName *string

	// READ-ONLY; List of references to the groups that the machine is member of.
	Groups []*string

	// READ-ONLY; Memory in Megabytes.
	MegabytesOfMemory *float32

	// READ-ONLY; Dictionary of network adapters attached to the machine. Key is ID of network adapter. Value is a network adapter
	// object
	NetworkAdapters map[string]*NetworkAdapter

	// READ-ONLY; Processor count.
	NumberOfCores *int32

	// READ-ONLY; Operating System name of the machine.
	OperatingSystemName *string

	// READ-ONLY; Operating System type of the machine.
	OperatingSystemType *string

	// READ-ONLY; Operating System version of the machine.
	OperatingSystemVersion *string

	// READ-ONLY; Time when this machine was last updated. Date-Time represented in ISO-8601 format.
	UpdatedTimestamp *time.Time
}

// MachineResultList - List of machines.
type MachineResultList struct {
	NextLink *string

	// List of machines.
	Value []*Machine
}

// NetworkAdapter - A network adapter discovered on a machine.
type NetworkAdapter struct {
	// READ-ONLY; User friendly name of the network adapter.
	DisplayName *string

	// READ-ONLY; List of IP Addresses on the network adapter.
	IPAddresses []*string

	// READ-ONLY; MAC Address of the network adapter.
	MacAddress *string
}

// Operation - A REST API operation supported by the provider.
type Operation struct {
	// READ-ONLY; Displayable properties of the operation.
	Display *OperationDisplay

	// READ-ONLY; Name of the operation.
	Name *string

	// READ-ONLY; Origin of the operation.
	Origin *string
}

// OperationDisplay - Displayable properties of the operation.
type OperationDisplay struct {
	// READ-ONLY; Description of the operation.
	Description *string

	// READ-ONLY; Operation Type.
	Operation *string

	// READ-ONLY; Provider of the operation.
	Provider *string

	// READ-ONLY; Resource operated on by the operation.
	Resource *string
}

// OperationResultList - List of API operations.
type OperationResultList struct {
	// List of operations.
	Value []*Operation
}

// PrivateEndpointConnection - A private endpoint connection for a project.
type PrivateEndpointConnection struct {
	// REQUIRED; Properties of the private endpoint endpoint connection.
	Properties *PrivateEndpointConnectionProperties

	// For optimistic concurrency control.
	ETag *string

	// READ-ONLY; Path reference to this private endpoint endpoint connection.
	// /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/privateEndpointConnections/{privateEndpointConnectionName}
	ID *string

	// READ-ONLY; Name of the private endpoint endpoint connection.
	Name *string

	// READ-ONLY; Type of the object = [Microsoft.Migrate/assessmentProjects/privateEndpointConnections].
	Type *string
}

// PrivateEndpointConnectionCollection - A collection of private endpoint connections for a project.
type PrivateEndpointConnectionCollection struct {
	// READ-ONLY
	NextLink *string

	// READ-ONLY; A list of private endpoint connections for a project.
	Value []*PrivateEndpointConnection
}

// PrivateEndpointConnectionProperties - Private endpoint connection properties.
type PrivateEndpointConnectionProperties struct {
	// State of the private endpoint connection.
	PrivateLinkServiceConnectionState *PrivateLinkServiceConnectionState

	// READ-ONLY; ARM id for the private endpoint resource corresponding to the connection.
	PrivateEndpoint *ResourceID

	// READ-ONLY; Indicates whether there is an ongoing operation on the private endpoint.
	ProvisioningState *PrivateEndpointConnectionPropertiesProvisioningState
}

// PrivateLinkResource - A private link resource for a project for which a private endpoint can be created.
type PrivateLinkResource struct {
	// READ-ONLY; Path reference to this private link resource.
	// /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}/privateLinkResources/{privateLinkResourceName}
	ID *string

	// READ-ONLY; Name of the private link resource.
	Name *string

	// READ-ONLY; Properties of the private link resource.
	Properties *PrivateLinkResourceProperties

	// READ-ONLY; Type of the object = [Microsoft.Migrate/assessmentProjects/privateLinkResources].
	Type *string
}

// PrivateLinkResourceCollection - A list of private link resources
type PrivateLinkResourceCollection struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string

	// READ-ONLY; Array of results.
	Value []*PrivateLinkResource
}

// PrivateLinkResourceProperties - Properties of a private link resource.
type PrivateLinkResourceProperties struct {
	// READ-ONLY; The private link resource group id.
	GroupID *string

	// READ-ONLY; The private link resource required member names.
	RequiredMembers []*string

	// READ-ONLY; Required DNS zone names of the the private link resource.
	RequiredZoneNames []*string
}

// PrivateLinkServiceConnectionState - State of a private endpoint connection.
type PrivateLinkServiceConnectionState struct {
	// Actions required on the private endpoint connection.
	ActionsRequired *string

	// Description of the private endpoint connection.
	Description *string

	// Connection status of the private endpoint connection.
	Status *PrivateLinkServiceConnectionStateStatus
}

// Project - Azure Migrate Project.
type Project struct {
	// For optimistic concurrency control.
	ETag *string

	// Azure location in which project is created.
	Location *string

	// Properties of the project.
	Properties *ProjectProperties

	// Tags provided by Azure Tagging service.
	Tags any

	// READ-ONLY; Path reference to this project /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Migrate/assessmentProjects/{projectName}
	ID *string

	// READ-ONLY; Name of the project.
	Name *string

	// READ-ONLY; Type of the object = [Microsoft.Migrate/assessmentProjects].
	Type *string
}

// ProjectProperties - Properties of a project.
type ProjectProperties struct {
	// Assessment solution ARM id tracked by Microsoft.Migrate/migrateProjects.
	AssessmentSolutionID *string

	// The ARM id of the storage account used for interactions when public access is disabled.
	CustomerStorageAccountArmID *string

	// The ARM id of service map workspace created by customer.
	CustomerWorkspaceID *string

	// Location of service map workspace created by customer.
	CustomerWorkspaceLocation *string

	// Assessment project status.
	ProjectStatus *ProjectStatus

	// This value can be set to 'enabled' to avoid breaking changes on existing customer resources and templates. If set to 'disabled',
	// traffic over public interface is not allowed, and private endpoint
	// connections would be the exclusive access method.
	PublicNetworkAccess *string

	// READ-ONLY; Time when this project was created. Date-Time represented in ISO-8601 format.
	CreatedTimestamp *time.Time

	// READ-ONLY; Time when last assessment was created. Date-Time represented in ISO-8601 format. This value will be null until
	// assessment is created.
	LastAssessmentTimestamp *time.Time

	// READ-ONLY; Number of assessments created in the project.
	NumberOfAssessments *int32

	// READ-ONLY; Number of groups created in the project.
	NumberOfGroups *int32

	// READ-ONLY; Number of machines in the project.
	NumberOfMachines *int32

	// READ-ONLY; The list of private endpoint connections to the project.
	PrivateEndpointConnections []*PrivateEndpointConnection

	// READ-ONLY; Provisioning state of the project.
	ProvisioningState *ProvisioningState

	// READ-ONLY; Endpoint at which the collector agent can call agent REST API.
	ServiceEndpoint *string

	// READ-ONLY; Time when this project was last updated. Date-Time represented in ISO-8601 format.
	UpdatedTimestamp *time.Time
}

// ProjectResultList - List of projects.
type ProjectResultList struct {
	NextLink *string

	// List of projects.
	Value []*Project
}

// ResourceID - ARM id for a resource.
type ResourceID struct {
	// READ-ONLY
	ID *string
}

type ServerCollector struct {
	ETag       *string
	Properties *CollectorProperties

	// READ-ONLY
	ID *string

	// READ-ONLY
	Name *string

	// READ-ONLY
	Type *string
}

// ServerCollectorList - List of Server collectors.
type ServerCollectorList struct {
	// List of Server collectors.
	Value []*ServerCollector
}

// UpdateGroupBody - Properties of group update.
type UpdateGroupBody struct {
	// For optimistic concurrency control.
	ETag *string

	// Properties of the group.
	Properties *GroupBodyProperties
}

// VMFamily - VM family name, the list of targeted azure locations and the category of the family.
type VMFamily struct {
	// READ-ONLY; Category of the VM family.
	Category []*string

	// READ-ONLY; Name of the VM family.
	FamilyName *string

	// READ-ONLY; List of Azure regions.
	TargetLocations []*string
}

type VMUptime struct {
	// Number of days in a month for VM uptime.
	DaysPerMonth *int32

	// Number of hours per day for VM uptime.
	HoursPerDay *int32
}

type VMwareCollector struct {
	ETag       *string
	Properties *CollectorProperties

	// READ-ONLY
	ID *string

	// READ-ONLY
	Name *string

	// READ-ONLY
	Type *string
}

// VMwareCollectorList - List of VMware collectors.
type VMwareCollectorList struct {
	// List of VMware collectors.
	Value []*VMwareCollector
}
