//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/selfhelp/armselfhelp/v2"
	"net/http"
	"net/url"
	"regexp"
)

// DiscoverySolutionServer is a fake server for instances of the armselfhelp.DiscoverySolutionClient type.
type DiscoverySolutionServer struct {
	// NewListPager is the fake for method DiscoverySolutionClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(scope string, options *armselfhelp.DiscoverySolutionClientListOptions) (resp azfake.PagerResponder[armselfhelp.DiscoverySolutionClientListResponse])
}

// NewDiscoverySolutionServerTransport creates a new instance of DiscoverySolutionServerTransport with the provided implementation.
// The returned DiscoverySolutionServerTransport instance is connected to an instance of armselfhelp.DiscoverySolutionClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewDiscoverySolutionServerTransport(srv *DiscoverySolutionServer) *DiscoverySolutionServerTransport {
	return &DiscoverySolutionServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armselfhelp.DiscoverySolutionClientListResponse]](),
	}
}

// DiscoverySolutionServerTransport connects instances of armselfhelp.DiscoverySolutionClient to instances of DiscoverySolutionServer.
// Don't use this type directly, use NewDiscoverySolutionServerTransport instead.
type DiscoverySolutionServerTransport struct {
	srv          *DiscoverySolutionServer
	newListPager *tracker[azfake.PagerResponder[armselfhelp.DiscoverySolutionClientListResponse]]
}

// Do implements the policy.Transporter interface for DiscoverySolutionServerTransport.
func (d *DiscoverySolutionServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "DiscoverySolutionClient.NewListPager":
		resp, err = d.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (d *DiscoverySolutionServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if d.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := d.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Help/discoverySolutions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
		if err != nil {
			return nil, err
		}
		filterUnescaped, err := url.QueryUnescape(qp.Get("$filter"))
		if err != nil {
			return nil, err
		}
		filterParam := getOptional(filterUnescaped)
		skiptokenUnescaped, err := url.QueryUnescape(qp.Get("$skiptoken"))
		if err != nil {
			return nil, err
		}
		skiptokenParam := getOptional(skiptokenUnescaped)
		var options *armselfhelp.DiscoverySolutionClientListOptions
		if filterParam != nil || skiptokenParam != nil {
			options = &armselfhelp.DiscoverySolutionClientListOptions{
				Filter:    filterParam,
				Skiptoken: skiptokenParam,
			}
		}
		resp := d.srv.NewListPager(scopeParam, options)
		newListPager = &resp
		d.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armselfhelp.DiscoverySolutionClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		d.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		d.newListPager.remove(req)
	}
	return resp, nil
}
