//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/sql/armsql/v2"
	"net/http"
	"net/url"
	"regexp"
)

// ManagedDatabaseVulnerabilityAssessmentScansServer is a fake server for instances of the armsql.ManagedDatabaseVulnerabilityAssessmentScansClient type.
type ManagedDatabaseVulnerabilityAssessmentScansServer struct {
	// Export is the fake for method ManagedDatabaseVulnerabilityAssessmentScansClient.Export
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	Export func(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, vulnerabilityAssessmentName armsql.VulnerabilityAssessmentName, scanID string, options *armsql.ManagedDatabaseVulnerabilityAssessmentScansClientExportOptions) (resp azfake.Responder[armsql.ManagedDatabaseVulnerabilityAssessmentScansClientExportResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ManagedDatabaseVulnerabilityAssessmentScansClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, vulnerabilityAssessmentName armsql.VulnerabilityAssessmentName, scanID string, options *armsql.ManagedDatabaseVulnerabilityAssessmentScansClientGetOptions) (resp azfake.Responder[armsql.ManagedDatabaseVulnerabilityAssessmentScansClientGetResponse], errResp azfake.ErrorResponder)

	// BeginInitiateScan is the fake for method ManagedDatabaseVulnerabilityAssessmentScansClient.BeginInitiateScan
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted
	BeginInitiateScan func(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, vulnerabilityAssessmentName armsql.VulnerabilityAssessmentName, scanID string, options *armsql.ManagedDatabaseVulnerabilityAssessmentScansClientBeginInitiateScanOptions) (resp azfake.PollerResponder[armsql.ManagedDatabaseVulnerabilityAssessmentScansClientInitiateScanResponse], errResp azfake.ErrorResponder)

	// NewListByDatabasePager is the fake for method ManagedDatabaseVulnerabilityAssessmentScansClient.NewListByDatabasePager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByDatabasePager func(resourceGroupName string, managedInstanceName string, databaseName string, vulnerabilityAssessmentName armsql.VulnerabilityAssessmentName, options *armsql.ManagedDatabaseVulnerabilityAssessmentScansClientListByDatabaseOptions) (resp azfake.PagerResponder[armsql.ManagedDatabaseVulnerabilityAssessmentScansClientListByDatabaseResponse])
}

// NewManagedDatabaseVulnerabilityAssessmentScansServerTransport creates a new instance of ManagedDatabaseVulnerabilityAssessmentScansServerTransport with the provided implementation.
// The returned ManagedDatabaseVulnerabilityAssessmentScansServerTransport instance is connected to an instance of armsql.ManagedDatabaseVulnerabilityAssessmentScansClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewManagedDatabaseVulnerabilityAssessmentScansServerTransport(srv *ManagedDatabaseVulnerabilityAssessmentScansServer) *ManagedDatabaseVulnerabilityAssessmentScansServerTransport {
	return &ManagedDatabaseVulnerabilityAssessmentScansServerTransport{
		srv:                    srv,
		beginInitiateScan:      newTracker[azfake.PollerResponder[armsql.ManagedDatabaseVulnerabilityAssessmentScansClientInitiateScanResponse]](),
		newListByDatabasePager: newTracker[azfake.PagerResponder[armsql.ManagedDatabaseVulnerabilityAssessmentScansClientListByDatabaseResponse]](),
	}
}

// ManagedDatabaseVulnerabilityAssessmentScansServerTransport connects instances of armsql.ManagedDatabaseVulnerabilityAssessmentScansClient to instances of ManagedDatabaseVulnerabilityAssessmentScansServer.
// Don't use this type directly, use NewManagedDatabaseVulnerabilityAssessmentScansServerTransport instead.
type ManagedDatabaseVulnerabilityAssessmentScansServerTransport struct {
	srv                    *ManagedDatabaseVulnerabilityAssessmentScansServer
	beginInitiateScan      *tracker[azfake.PollerResponder[armsql.ManagedDatabaseVulnerabilityAssessmentScansClientInitiateScanResponse]]
	newListByDatabasePager *tracker[azfake.PagerResponder[armsql.ManagedDatabaseVulnerabilityAssessmentScansClientListByDatabaseResponse]]
}

// Do implements the policy.Transporter interface for ManagedDatabaseVulnerabilityAssessmentScansServerTransport.
func (m *ManagedDatabaseVulnerabilityAssessmentScansServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ManagedDatabaseVulnerabilityAssessmentScansClient.Export":
		resp, err = m.dispatchExport(req)
	case "ManagedDatabaseVulnerabilityAssessmentScansClient.Get":
		resp, err = m.dispatchGet(req)
	case "ManagedDatabaseVulnerabilityAssessmentScansClient.BeginInitiateScan":
		resp, err = m.dispatchBeginInitiateScan(req)
	case "ManagedDatabaseVulnerabilityAssessmentScansClient.NewListByDatabasePager":
		resp, err = m.dispatchNewListByDatabasePager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (m *ManagedDatabaseVulnerabilityAssessmentScansServerTransport) dispatchExport(req *http.Request) (*http.Response, error) {
	if m.srv.Export == nil {
		return nil, &nonRetriableError{errors.New("fake for method Export not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/managedInstances/(?P<managedInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/vulnerabilityAssessments/(?P<vulnerabilityAssessmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/scans/(?P<scanId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/export`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	managedInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedInstanceName")])
	if err != nil {
		return nil, err
	}
	databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
	if err != nil {
		return nil, err
	}
	vulnerabilityAssessmentNameParam, err := parseWithCast(matches[regex.SubexpIndex("vulnerabilityAssessmentName")], func(v string) (armsql.VulnerabilityAssessmentName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armsql.VulnerabilityAssessmentName(p), nil
	})
	if err != nil {
		return nil, err
	}
	scanIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("scanId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.Export(req.Context(), resourceGroupNameParam, managedInstanceNameParam, databaseNameParam, vulnerabilityAssessmentNameParam, scanIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK, http.StatusCreated}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).DatabaseVulnerabilityAssessmentScansExport, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *ManagedDatabaseVulnerabilityAssessmentScansServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if m.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/managedInstances/(?P<managedInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/vulnerabilityAssessments/(?P<vulnerabilityAssessmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/scans/(?P<scanId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 6 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	managedInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedInstanceName")])
	if err != nil {
		return nil, err
	}
	databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
	if err != nil {
		return nil, err
	}
	vulnerabilityAssessmentNameParam, err := parseWithCast(matches[regex.SubexpIndex("vulnerabilityAssessmentName")], func(v string) (armsql.VulnerabilityAssessmentName, error) {
		p, unescapeErr := url.PathUnescape(v)
		if unescapeErr != nil {
			return "", unescapeErr
		}
		return armsql.VulnerabilityAssessmentName(p), nil
	})
	if err != nil {
		return nil, err
	}
	scanIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("scanId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := m.srv.Get(req.Context(), resourceGroupNameParam, managedInstanceNameParam, databaseNameParam, vulnerabilityAssessmentNameParam, scanIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).VulnerabilityAssessmentScanRecord, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (m *ManagedDatabaseVulnerabilityAssessmentScansServerTransport) dispatchBeginInitiateScan(req *http.Request) (*http.Response, error) {
	if m.srv.BeginInitiateScan == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginInitiateScan not implemented")}
	}
	beginInitiateScan := m.beginInitiateScan.get(req)
	if beginInitiateScan == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/managedInstances/(?P<managedInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/vulnerabilityAssessments/(?P<vulnerabilityAssessmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/scans/(?P<scanId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/initiateScan`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 6 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managedInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedInstanceName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		vulnerabilityAssessmentNameParam, err := parseWithCast(matches[regex.SubexpIndex("vulnerabilityAssessmentName")], func(v string) (armsql.VulnerabilityAssessmentName, error) {
			p, unescapeErr := url.PathUnescape(v)
			if unescapeErr != nil {
				return "", unescapeErr
			}
			return armsql.VulnerabilityAssessmentName(p), nil
		})
		if err != nil {
			return nil, err
		}
		scanIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("scanId")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := m.srv.BeginInitiateScan(req.Context(), resourceGroupNameParam, managedInstanceNameParam, databaseNameParam, vulnerabilityAssessmentNameParam, scanIDParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginInitiateScan = &respr
		m.beginInitiateScan.add(req, beginInitiateScan)
	}

	resp, err := server.PollerResponderNext(beginInitiateScan, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted}, resp.StatusCode) {
		m.beginInitiateScan.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginInitiateScan) {
		m.beginInitiateScan.remove(req)
	}

	return resp, nil
}

func (m *ManagedDatabaseVulnerabilityAssessmentScansServerTransport) dispatchNewListByDatabasePager(req *http.Request) (*http.Response, error) {
	if m.srv.NewListByDatabasePager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByDatabasePager not implemented")}
	}
	newListByDatabasePager := m.newListByDatabasePager.get(req)
	if newListByDatabasePager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/managedInstances/(?P<managedInstanceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/databases/(?P<databaseName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/vulnerabilityAssessments/(?P<vulnerabilityAssessmentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/scans`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		managedInstanceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("managedInstanceName")])
		if err != nil {
			return nil, err
		}
		databaseNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("databaseName")])
		if err != nil {
			return nil, err
		}
		vulnerabilityAssessmentNameParam, err := parseWithCast(matches[regex.SubexpIndex("vulnerabilityAssessmentName")], func(v string) (armsql.VulnerabilityAssessmentName, error) {
			p, unescapeErr := url.PathUnescape(v)
			if unescapeErr != nil {
				return "", unescapeErr
			}
			return armsql.VulnerabilityAssessmentName(p), nil
		})
		if err != nil {
			return nil, err
		}
		resp := m.srv.NewListByDatabasePager(resourceGroupNameParam, managedInstanceNameParam, databaseNameParam, vulnerabilityAssessmentNameParam, nil)
		newListByDatabasePager = &resp
		m.newListByDatabasePager.add(req, newListByDatabasePager)
		server.PagerResponderInjectNextLinks(newListByDatabasePager, req, func(page *armsql.ManagedDatabaseVulnerabilityAssessmentScansClientListByDatabaseResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByDatabasePager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		m.newListByDatabasePager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByDatabasePager) {
		m.newListByDatabasePager.remove(req)
	}
	return resp, nil
}
