# Omegon EQ500-X Equatorial Mount
## Installation
The Omegon EQ500-X Equatorial Mount driver is included with libindi >= 1.7.8. Install with:
```
$ sudo add-apt-repository ppa:mutlaqja/ppa
$ sudo apt-get update
$ sudo apt-get install libindi1
```
## Features
The Omegon EQ500-X Equatorial Mount driver supports:
* 4 Slew Rates (max, find, center and guide)
* Single sidereal tracking rate
* Goto coordinates (via software adjustment)
* Sync coordinates
* Abort movement
* Location configuration (used for initial sync)
* Pier side
* Simulation mode
* Timed pulse guiding
## Operation
* Install the Omegon EQ500-X Equatorial Mount with its pad connected.
* Orient the right ascension axis towards the pole using either visual alignment or an external alignment tool.
* Rotate the right ascension axis so that the telescope is on top, and declination axis so that the telescope looks at the pole.
* Lock axes firmly.
* Power on the mount using the side button on the pad to select your hemisphere.
* Plug the USB cable from the pad to the host computer.
* By default, the pad is recognized as a serial adapter on port /dev/ttyUSB0 (9600 bauds, 8 bits, no parity, 1 stop bit).
* Execute indiserver with driver `indi_eq500x` using the method of your choice.
* When you connect the driver after powering up the mount, the initial position is synced to the local sidereal time of the location your client.
## Issues
* To improve the precision of the goto feature, the driver provides software adjustment but the performance of the algorithm may suffer from high load on the host.
* The mount does not offer pulse guiding through LX200 Mg commands, instead a software timed guide pulse is used.
* Goto movements are expected to always go through the meridian opposite to the pole.
* However, neither the mount nor the driver will prevent manual movement or tracking through the pole meridian.
* The driver is unable to read the firmware version for compatibility verification.
