/*
 * Copyright (C) 2017  Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
 * AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#ifndef _nbio_7_0_SH_MASK_HEADER
#define _nbio_7_0_SH_MASK_HEADER


// addressBlock: nbio_iohub_nb_nbcfg_nb_cfgdec
//NB_NBCFG0_NB_VENDOR_ID
#define NB_NBCFG0_NB_VENDOR_ID__VENDOR_ID__SHIFT                                                              0x0
#define NB_NBCFG0_NB_VENDOR_ID__VENDOR_ID_MASK                                                                0xFFFFL
//NB_NBCFG0_NB_DEVICE_ID
#define NB_NBCFG0_NB_DEVICE_ID__DEVICE_ID__SHIFT                                                              0x0
#define NB_NBCFG0_NB_DEVICE_ID__DEVICE_ID_MASK                                                                0xFFFFL
//NB_NBCFG0_NB_COMMAND
#define NB_NBCFG0_NB_COMMAND__IO_ACCESS_EN__SHIFT                                                             0x0
#define NB_NBCFG0_NB_COMMAND__MEM_ACCESS_EN__SHIFT                                                            0x1
#define NB_NBCFG0_NB_COMMAND__BUS_MASTER_EN__SHIFT                                                            0x2
#define NB_NBCFG0_NB_COMMAND__IO_ACCESS_EN_MASK                                                               0x0001L
#define NB_NBCFG0_NB_COMMAND__MEM_ACCESS_EN_MASK                                                              0x0002L
#define NB_NBCFG0_NB_COMMAND__BUS_MASTER_EN_MASK                                                              0x0004L
//NB_NBCFG0_NB_STATUS
#define NB_NBCFG0_NB_STATUS__CAP_LIST__SHIFT                                                                  0x4
#define NB_NBCFG0_NB_STATUS__RECEIVED_TARGET_ABORT__SHIFT                                                     0xc
#define NB_NBCFG0_NB_STATUS__RECEIVED_MASTER_ABORT__SHIFT                                                     0xd
#define NB_NBCFG0_NB_STATUS__CAP_LIST_MASK                                                                    0x0010L
#define NB_NBCFG0_NB_STATUS__RECEIVED_TARGET_ABORT_MASK                                                       0x1000L
#define NB_NBCFG0_NB_STATUS__RECEIVED_MASTER_ABORT_MASK                                                       0x2000L
//NB_NBCFG0_NB_REVISION_ID
#define NB_NBCFG0_NB_REVISION_ID__MINOR_REV_ID__SHIFT                                                         0x0
#define NB_NBCFG0_NB_REVISION_ID__MAJOR_REV_ID__SHIFT                                                         0x4
#define NB_NBCFG0_NB_REVISION_ID__MINOR_REV_ID_MASK                                                           0x0FL
#define NB_NBCFG0_NB_REVISION_ID__MAJOR_REV_ID_MASK                                                           0xF0L
//NB_NBCFG0_NB_REGPROG_INF
#define NB_NBCFG0_NB_REGPROG_INF__REG_LEVEL_PROG_INF__SHIFT                                                   0x0
#define NB_NBCFG0_NB_REGPROG_INF__REG_LEVEL_PROG_INF_MASK                                                     0xFFL
//NB_NBCFG0_NB_SUB_CLASS
#define NB_NBCFG0_NB_SUB_CLASS__SUB_CLASS_INF__SHIFT                                                          0x0
#define NB_NBCFG0_NB_SUB_CLASS__SUB_CLASS_INF_MASK                                                            0xFFL
//NB_NBCFG0_NB_BASE_CODE
#define NB_NBCFG0_NB_BASE_CODE__BASE_CLASS_CODE__SHIFT                                                        0x0
#define NB_NBCFG0_NB_BASE_CODE__BASE_CLASS_CODE_MASK                                                          0xFFL
//NB_NBCFG0_NB_CACHE_LINE
#define NB_NBCFG0_NB_CACHE_LINE__CACHE_LINE_SIZE__SHIFT                                                       0x0
#define NB_NBCFG0_NB_CACHE_LINE__CACHE_LINE_SIZE_MASK                                                         0xFFL
//NB_NBCFG0_NB_LATENCY
#define NB_NBCFG0_NB_LATENCY__LATENCY_TIMER__SHIFT                                                            0x0
#define NB_NBCFG0_NB_LATENCY__LATENCY_TIMER_MASK                                                              0xFFL
//NB_NBCFG0_NB_HEADER
#define NB_NBCFG0_NB_HEADER__HEADER_TYPE__SHIFT                                                               0x0
#define NB_NBCFG0_NB_HEADER__DEVICE_TYPE__SHIFT                                                               0x7
#define NB_NBCFG0_NB_HEADER__HEADER_TYPE_MASK                                                                 0x7FL
#define NB_NBCFG0_NB_HEADER__DEVICE_TYPE_MASK                                                                 0x80L
//NB_NBCFG0_NB_ADAPTER_ID
#define NB_NBCFG0_NB_ADAPTER_ID__SUBSYSTEM_VENDOR_ID__SHIFT                                                   0x0
#define NB_NBCFG0_NB_ADAPTER_ID__SUBSYSTEM_ID__SHIFT                                                          0x10
#define NB_NBCFG0_NB_ADAPTER_ID__SUBSYSTEM_VENDOR_ID_MASK                                                     0x0000FFFFL
#define NB_NBCFG0_NB_ADAPTER_ID__SUBSYSTEM_ID_MASK                                                            0xFFFF0000L
//NB_NBCFG0_NB_CAPABILITIES_PTR
#define NB_NBCFG0_NB_CAPABILITIES_PTR__CAP_PTR__SHIFT                                                         0x0
#define NB_NBCFG0_NB_CAPABILITIES_PTR__CAP_PTR_MASK                                                           0x000000FFL
//NB_NBCFG0_NB_HEADER_W
#define NB_NBCFG0_NB_HEADER_W__DEVICE_TYPE__SHIFT                                                             0x7
#define NB_NBCFG0_NB_HEADER_W__DEVICE_TYPE_MASK                                                               0x00000080L
//NB_NBCFG0_NB_PCI_CTRL
#define NB_NBCFG0_NB_PCI_CTRL__PMEDis__SHIFT                                                                  0x4
#define NB_NBCFG0_NB_PCI_CTRL__SErrDis__SHIFT                                                                 0x5
#define NB_NBCFG0_NB_PCI_CTRL__MMIOEnable__SHIFT                                                              0x17
#define NB_NBCFG0_NB_PCI_CTRL__HPDis__SHIFT                                                                   0x1a
#define NB_NBCFG0_NB_PCI_CTRL__PMEDis_MASK                                                                    0x00000010L
#define NB_NBCFG0_NB_PCI_CTRL__SErrDis_MASK                                                                   0x00000020L
#define NB_NBCFG0_NB_PCI_CTRL__MMIOEnable_MASK                                                                0x00800000L
#define NB_NBCFG0_NB_PCI_CTRL__HPDis_MASK                                                                     0x04000000L
//NB_NBCFG0_NB_ADAPTER_ID_W
#define NB_NBCFG0_NB_ADAPTER_ID_W__SUBSYSTEM_VENDOR_ID__SHIFT                                                 0x0
#define NB_NBCFG0_NB_ADAPTER_ID_W__SUBSYSTEM_ID__SHIFT                                                        0x10
#define NB_NBCFG0_NB_ADAPTER_ID_W__SUBSYSTEM_VENDOR_ID_MASK                                                   0x0000FFFFL
#define NB_NBCFG0_NB_ADAPTER_ID_W__SUBSYSTEM_ID_MASK                                                          0xFFFF0000L
//NB_NBCFG0_NB_SMN_INDEX_EXTENSION_0
#define NB_NBCFG0_NB_SMN_INDEX_EXTENSION_0__NB_SMN_INDEX_EXTENSION_0__SHIFT                                   0x0
#define NB_NBCFG0_NB_SMN_INDEX_EXTENSION_0__NB_SMN_INDEX_EXTENSION_0_MASK                                     0x0000000FL
//NB_NBCFG0_NB_SMN_INDEX_0
#define NB_NBCFG0_NB_SMN_INDEX_0__NB_SMN_INDEX_0__SHIFT                                                       0x0
#define NB_NBCFG0_NB_SMN_INDEX_0__NB_SMN_INDEX_0_MASK                                                         0xFFFFFFFFL
//NB_NBCFG0_NB_SMN_DATA_0
#define NB_NBCFG0_NB_SMN_DATA_0__NB_SMN_DATA_0__SHIFT                                                         0x0
#define NB_NBCFG0_NB_SMN_DATA_0__NB_SMN_DATA_0_MASK                                                           0xFFFFFFFFL
//NB_NBCFG0_NBCFG_SCRATCH_0
#define NB_NBCFG0_NBCFG_SCRATCH_0__NBCFG_SCRATCH_0__SHIFT                                                     0x0
#define NB_NBCFG0_NBCFG_SCRATCH_0__NBCFG_SCRATCH_0_MASK                                                       0xFFFFFFFFL
//NB_NBCFG0_NBCFG_SCRATCH_1
#define NB_NBCFG0_NBCFG_SCRATCH_1__NBCFG_SCRATCH_1__SHIFT                                                     0x0
#define NB_NBCFG0_NBCFG_SCRATCH_1__NBCFG_SCRATCH_1_MASK                                                       0xFFFFFFFFL
//NB_NBCFG0_NBCFG_SCRATCH_2
#define NB_NBCFG0_NBCFG_SCRATCH_2__NBCFG_SCRATCH_2__SHIFT                                                     0x0
#define NB_NBCFG0_NBCFG_SCRATCH_2__NBCFG_SCRATCH_2_MASK                                                       0xFFFFFFFFL
//NB_NBCFG0_NBCFG_SCRATCH_3
#define NB_NBCFG0_NBCFG_SCRATCH_3__NBCFG_SCRATCH_3__SHIFT                                                     0x0
#define NB_NBCFG0_NBCFG_SCRATCH_3__NBCFG_SCRATCH_3_MASK                                                       0xFFFFFFFFL
//NB_NBCFG0_NBCFG_SCRATCH_4
#define NB_NBCFG0_NBCFG_SCRATCH_4__NBCFG_SCRATCH_4__SHIFT                                                     0x0
#define NB_NBCFG0_NBCFG_SCRATCH_4__NBCFG_SCRATCH_4_MASK                                                       0xFFFFFFFFL
//NB_NBCFG0_NB_PCI_ARB
#define NB_NBCFG0_NB_PCI_ARB__VGA_HOLE__SHIFT                                                                 0x3
#define NB_NBCFG0_NB_PCI_ARB__PMEMode__SHIFT                                                                  0x8
#define NB_NBCFG0_NB_PCI_ARB__PMETurnOff__SHIFT                                                               0x9
#define NB_NBCFG0_NB_PCI_ARB__PMETOAckStatus__SHIFT                                                           0xa
#define NB_NBCFG0_NB_PCI_ARB__PMETarget__SHIFT                                                                0x10
#define NB_NBCFG0_NB_PCI_ARB__VGA_HOLE_MASK                                                                   0x00000008L
#define NB_NBCFG0_NB_PCI_ARB__PMEMode_MASK                                                                    0x00000100L
#define NB_NBCFG0_NB_PCI_ARB__PMETurnOff_MASK                                                                 0x00000200L
#define NB_NBCFG0_NB_PCI_ARB__PMETOAckStatus_MASK                                                             0x00000400L
#define NB_NBCFG0_NB_PCI_ARB__PMETarget_MASK                                                                  0x00FF0000L
//NB_NBCFG0_NB_DRAM_SLOT1_BASE
#define NB_NBCFG0_NB_DRAM_SLOT1_BASE__DRAM_BASE__SHIFT                                                        0x17
#define NB_NBCFG0_NB_DRAM_SLOT1_BASE__DRAM_BASE_MASK                                                          0xFF800000L
//NB_NBCFG0_NB_TOP_OF_DRAM_SLOT1
#define NB_NBCFG0_NB_TOP_OF_DRAM_SLOT1__TOP_OF_DRAM_BIT_32__SHIFT                                             0x0
#define NB_NBCFG0_NB_TOP_OF_DRAM_SLOT1__TOP_OF_DRAM__SHIFT                                                    0x17
#define NB_NBCFG0_NB_TOP_OF_DRAM_SLOT1__TOP_OF_DRAM_BIT_32_MASK                                               0x00000001L
#define NB_NBCFG0_NB_TOP_OF_DRAM_SLOT1__TOP_OF_DRAM_MASK                                                      0xFF800000L
//NB_NBCFG0_NB_SMN_INDEX_EXTENSION_1
#define NB_NBCFG0_NB_SMN_INDEX_EXTENSION_1__NB_SMN_INDEX_EXTENSION_1__SHIFT                                   0x0
#define NB_NBCFG0_NB_SMN_INDEX_EXTENSION_1__NB_SMN_INDEX_EXTENSION_1_MASK                                     0x0000000FL
//NB_NBCFG0_NB_SMN_INDEX_1
#define NB_NBCFG0_NB_SMN_INDEX_1__NB_SMN_INDEX_1__SHIFT                                                       0x0
#define NB_NBCFG0_NB_SMN_INDEX_1__NB_SMN_INDEX_1_MASK                                                         0xFFFFFFFFL
//NB_NBCFG0_NB_SMN_DATA_1
#define NB_NBCFG0_NB_SMN_DATA_1__NB_SMN_DATA_1__SHIFT                                                         0x0
#define NB_NBCFG0_NB_SMN_DATA_1__NB_SMN_DATA_1_MASK                                                           0xFFFFFFFFL
//NB_NBCFG0_NB_INDEX_DATA_MUTEX0
#define NB_NBCFG0_NB_INDEX_DATA_MUTEX0__NB_INDEX_DATA_MUTEX0__SHIFT                                           0x0
#define NB_NBCFG0_NB_INDEX_DATA_MUTEX0__NB_INDEX_DATA_MUTEX0_UNLOCK__SHIFT                                    0x1f
#define NB_NBCFG0_NB_INDEX_DATA_MUTEX0__NB_INDEX_DATA_MUTEX0_MASK                                             0x7FFFFFFFL
#define NB_NBCFG0_NB_INDEX_DATA_MUTEX0__NB_INDEX_DATA_MUTEX0_UNLOCK_MASK                                      0x80000000L
//NB_NBCFG0_NB_INDEX_DATA_MUTEX1
#define NB_NBCFG0_NB_INDEX_DATA_MUTEX1__NB_INDEX_DATA_MUTEX1__SHIFT                                           0x0
#define NB_NBCFG0_NB_INDEX_DATA_MUTEX1__NB_INDEX_DATA_MUTEX1_UNLOCK__SHIFT                                    0x1f
#define NB_NBCFG0_NB_INDEX_DATA_MUTEX1__NB_INDEX_DATA_MUTEX1_MASK                                             0x7FFFFFFFL
#define NB_NBCFG0_NB_INDEX_DATA_MUTEX1__NB_INDEX_DATA_MUTEX1_UNLOCK_MASK                                      0x80000000L
//NB_NBCFG0_NB_SMN_INDEX_EXTENSION_2
#define NB_NBCFG0_NB_SMN_INDEX_EXTENSION_2__NB_SMN_INDEX_EXTENSION_2__SHIFT                                   0x0
#define NB_NBCFG0_NB_SMN_INDEX_EXTENSION_2__NB_SMN_INDEX_EXTENSION_2_MASK                                     0x0000000FL
//NB_NBCFG0_NB_SMN_INDEX_2
#define NB_NBCFG0_NB_SMN_INDEX_2__NB_SMN_INDEX_2__SHIFT                                                       0x0
#define NB_NBCFG0_NB_SMN_INDEX_2__NB_SMN_INDEX_2_MASK                                                         0xFFFFFFFFL
//NB_NBCFG0_NB_SMN_DATA_2
#define NB_NBCFG0_NB_SMN_DATA_2__NB_SMN_DATA_2__SHIFT                                                         0x0
#define NB_NBCFG0_NB_SMN_DATA_2__NB_SMN_DATA_2_MASK                                                           0xFFFFFFFFL
//NB_NBCFG0_NB_SMN_INDEX_EXTENSION_3
#define NB_NBCFG0_NB_SMN_INDEX_EXTENSION_3__NB_SMN_INDEX_EXTENSION_3__SHIFT                                   0x0
#define NB_NBCFG0_NB_SMN_INDEX_EXTENSION_3__NB_SMN_INDEX_EXTENSION_3_MASK                                     0x0000000FL
//NB_NBCFG0_NB_SMN_INDEX_3
#define NB_NBCFG0_NB_SMN_INDEX_3__NB_SMN_INDEX_3__SHIFT                                                       0x0
#define NB_NBCFG0_NB_SMN_INDEX_3__NB_SMN_INDEX_3_MASK                                                         0xFFFFFFFFL
//NB_NBCFG0_NB_SMN_DATA_3
#define NB_NBCFG0_NB_SMN_DATA_3__NB_SMN_DATA_3__SHIFT                                                         0x0
#define NB_NBCFG0_NB_SMN_DATA_3__NB_SMN_DATA_3_MASK                                                           0xFFFFFFFFL
//NB_NBCFG0_NB_SMN_INDEX_EXTENSION_4
#define NB_NBCFG0_NB_SMN_INDEX_EXTENSION_4__NB_SMN_INDEX_EXTENSION_4__SHIFT                                   0x0
#define NB_NBCFG0_NB_SMN_INDEX_EXTENSION_4__NB_SMN_INDEX_EXTENSION_4_MASK                                     0x0000000FL
//NB_NBCFG0_NB_SMN_INDEX_4
#define NB_NBCFG0_NB_SMN_INDEX_4__NB_SMN_INDEX_4__SHIFT                                                       0x0
#define NB_NBCFG0_NB_SMN_INDEX_4__NB_SMN_INDEX_4_MASK                                                         0xFFFFFFFFL
//NB_NBCFG0_NB_SMN_DATA_4
#define NB_NBCFG0_NB_SMN_DATA_4__NB_SMN_DATA_4__SHIFT                                                         0x0
#define NB_NBCFG0_NB_SMN_DATA_4__NB_SMN_DATA_4_MASK                                                           0xFFFFFFFFL
//NB_NBCFG0_NB_SMN_INDEX_EXTENSION_5
#define NB_NBCFG0_NB_SMN_INDEX_EXTENSION_5__NB_SMN_INDEX_EXTENSION_5__SHIFT                                   0x0
#define NB_NBCFG0_NB_SMN_INDEX_EXTENSION_5__NB_SMN_INDEX_EXTENSION_5_MASK                                     0x0000000FL
//NB_NBCFG0_NB_SMN_INDEX_5
#define NB_NBCFG0_NB_SMN_INDEX_5__NB_SMN_INDEX_5__SHIFT                                                       0x0
#define NB_NBCFG0_NB_SMN_INDEX_5__NB_SMN_INDEX_5_MASK                                                         0xFFFFFFFFL
//NB_NBCFG0_NB_SMN_DATA_5
#define NB_NBCFG0_NB_SMN_DATA_5__NB_SMN_DATA_5__SHIFT                                                         0x0
#define NB_NBCFG0_NB_SMN_DATA_5__NB_SMN_DATA_5_MASK                                                           0xFFFFFFFFL
//NB_NBCFG0_NB_PERF_CNT_CTRL
#define NB_NBCFG0_NB_PERF_CNT_CTRL__GLOBE_CNT_EN__SHIFT                                                       0x0
#define NB_NBCFG0_NB_PERF_CNT_CTRL__GLOBE_SHADOW_WR__SHIFT                                                    0x1
#define NB_NBCFG0_NB_PERF_CNT_CTRL__GLOBE_PERF_RESET__SHIFT                                                   0x2
#define NB_NBCFG0_NB_PERF_CNT_CTRL__GLOBE_SHADOW_DELAY__SHIFT                                                 0x8
#define NB_NBCFG0_NB_PERF_CNT_CTRL__GLOBE_SHADOW_DELAY_EN__SHIFT                                              0xf
#define NB_NBCFG0_NB_PERF_CNT_CTRL__GLOBE_PERF_RESET_DELAY__SHIFT                                             0x10
#define NB_NBCFG0_NB_PERF_CNT_CTRL__GLOBE_PERF_RESET_DELAY_EN__SHIFT                                          0x17
#define NB_NBCFG0_NB_PERF_CNT_CTRL__GLOBE_CNT_EN_MASK                                                         0x00000001L
#define NB_NBCFG0_NB_PERF_CNT_CTRL__GLOBE_SHADOW_WR_MASK                                                      0x00000002L
#define NB_NBCFG0_NB_PERF_CNT_CTRL__GLOBE_PERF_RESET_MASK                                                     0x00000004L
#define NB_NBCFG0_NB_PERF_CNT_CTRL__GLOBE_SHADOW_DELAY_MASK                                                   0x00000F00L
#define NB_NBCFG0_NB_PERF_CNT_CTRL__GLOBE_SHADOW_DELAY_EN_MASK                                                0x00008000L
#define NB_NBCFG0_NB_PERF_CNT_CTRL__GLOBE_PERF_RESET_DELAY_MASK                                               0x000F0000L
#define NB_NBCFG0_NB_PERF_CNT_CTRL__GLOBE_PERF_RESET_DELAY_EN_MASK                                            0x00800000L
//NB_NBCFG0_NB_SMN_INDEX_6
#define NB_NBCFG0_NB_SMN_INDEX_6__NB_SMN_INDEX_6__SHIFT                                                       0x0
#define NB_NBCFG0_NB_SMN_INDEX_6__NB_SMN_INDEX_6_MASK                                                         0xFFFFFFFFL
//NB_NBCFG0_NB_SMN_DATA_6
#define NB_NBCFG0_NB_SMN_DATA_6__NB_SMN_DATA_6__SHIFT                                                         0x0
#define NB_NBCFG0_NB_SMN_DATA_6__NB_SMN_DATA_6_MASK                                                           0xFFFFFFFFL


// addressBlock: nbio_iohub_iommu_l2_iommul2cfg
//IOMMU_L2_0_IOMMU_VENDOR_ID
#define IOMMU_L2_0_IOMMU_VENDOR_ID__VENDOR_ID__SHIFT                                                          0x0
#define IOMMU_L2_0_IOMMU_VENDOR_ID__VENDOR_ID_MASK                                                            0xFFFFL
//IOMMU_L2_0_IOMMU_DEVICE_ID
#define IOMMU_L2_0_IOMMU_DEVICE_ID__DEVICE_ID__SHIFT                                                          0x0
#define IOMMU_L2_0_IOMMU_DEVICE_ID__DEVICE_ID_MASK                                                            0xFFFFL
//IOMMU_L2_0_IOMMU_COMMAND
#define IOMMU_L2_0_IOMMU_COMMAND__IO_ACCESS_EN__SHIFT                                                         0x0
#define IOMMU_L2_0_IOMMU_COMMAND__MEM_ACCESS_EN__SHIFT                                                        0x1
#define IOMMU_L2_0_IOMMU_COMMAND__BUS_MASTER_EN__SHIFT                                                        0x2
#define IOMMU_L2_0_IOMMU_COMMAND__Reserved1__SHIFT                                                            0x3
#define IOMMU_L2_0_IOMMU_COMMAND__PARITY_ERROR_EN__SHIFT                                                      0x6
#define IOMMU_L2_0_IOMMU_COMMAND__Reserved0__SHIFT                                                            0x7
#define IOMMU_L2_0_IOMMU_COMMAND__SERR_EN__SHIFT                                                              0x8
#define IOMMU_L2_0_IOMMU_COMMAND__Reserved2__SHIFT                                                            0x9
#define IOMMU_L2_0_IOMMU_COMMAND__INTERRUPT_DIS__SHIFT                                                        0xa
#define IOMMU_L2_0_IOMMU_COMMAND__Reserved__SHIFT                                                             0xb
#define IOMMU_L2_0_IOMMU_COMMAND__IO_ACCESS_EN_MASK                                                           0x0001L
#define IOMMU_L2_0_IOMMU_COMMAND__MEM_ACCESS_EN_MASK                                                          0x0002L
#define IOMMU_L2_0_IOMMU_COMMAND__BUS_MASTER_EN_MASK                                                          0x0004L
#define IOMMU_L2_0_IOMMU_COMMAND__Reserved1_MASK                                                              0x0038L
#define IOMMU_L2_0_IOMMU_COMMAND__PARITY_ERROR_EN_MASK                                                        0x0040L
#define IOMMU_L2_0_IOMMU_COMMAND__Reserved0_MASK                                                              0x0080L
#define IOMMU_L2_0_IOMMU_COMMAND__SERR_EN_MASK                                                                0x0100L
#define IOMMU_L2_0_IOMMU_COMMAND__Reserved2_MASK                                                              0x0200L
#define IOMMU_L2_0_IOMMU_COMMAND__INTERRUPT_DIS_MASK                                                          0x0400L
#define IOMMU_L2_0_IOMMU_COMMAND__Reserved_MASK                                                               0xF800L
//IOMMU_L2_0_IOMMU_STATUS
#define IOMMU_L2_0_IOMMU_STATUS__Reserved__SHIFT                                                              0x0
#define IOMMU_L2_0_IOMMU_STATUS__INT_Status__SHIFT                                                            0x3
#define IOMMU_L2_0_IOMMU_STATUS__CAP_LIST__SHIFT                                                              0x4
#define IOMMU_L2_0_IOMMU_STATUS__Reserved1__SHIFT                                                             0x5
#define IOMMU_L2_0_IOMMU_STATUS__MASTER_DATA_ERROR__SHIFT                                                     0x8
#define IOMMU_L2_0_IOMMU_STATUS__Reserved2__SHIFT                                                             0x9
#define IOMMU_L2_0_IOMMU_STATUS__SIGNAL_TARGET_ABORT__SHIFT                                                   0xb
#define IOMMU_L2_0_IOMMU_STATUS__RECEIVED_TARGET_ABORT__SHIFT                                                 0xc
#define IOMMU_L2_0_IOMMU_STATUS__RECEIVED_MASTER_ABORT__SHIFT                                                 0xd
#define IOMMU_L2_0_IOMMU_STATUS__SIGNALED_SYSTEM_ERROR__SHIFT                                                 0xe
#define IOMMU_L2_0_IOMMU_STATUS__PARITY_ERROR_DETECTED__SHIFT                                                 0xf
#define IOMMU_L2_0_IOMMU_STATUS__Reserved_MASK                                                                0x0007L
#define IOMMU_L2_0_IOMMU_STATUS__INT_Status_MASK                                                              0x0008L
#define IOMMU_L2_0_IOMMU_STATUS__CAP_LIST_MASK                                                                0x0010L
#define IOMMU_L2_0_IOMMU_STATUS__Reserved1_MASK                                                               0x00E0L
#define IOMMU_L2_0_IOMMU_STATUS__MASTER_DATA_ERROR_MASK                                                       0x0100L
#define IOMMU_L2_0_IOMMU_STATUS__Reserved2_MASK                                                               0x0600L
#define IOMMU_L2_0_IOMMU_STATUS__SIGNAL_TARGET_ABORT_MASK                                                     0x0800L
#define IOMMU_L2_0_IOMMU_STATUS__RECEIVED_TARGET_ABORT_MASK                                                   0x1000L
#define IOMMU_L2_0_IOMMU_STATUS__RECEIVED_MASTER_ABORT_MASK                                                   0x2000L
#define IOMMU_L2_0_IOMMU_STATUS__SIGNALED_SYSTEM_ERROR_MASK                                                   0x4000L
#define IOMMU_L2_0_IOMMU_STATUS__PARITY_ERROR_DETECTED_MASK                                                   0x8000L
//IOMMU_L2_0_IOMMU_REVISION_ID
#define IOMMU_L2_0_IOMMU_REVISION_ID__MINOR_REV_ID__SHIFT                                                     0x0
#define IOMMU_L2_0_IOMMU_REVISION_ID__MAJOR_REV_ID__SHIFT                                                     0x4
#define IOMMU_L2_0_IOMMU_REVISION_ID__MINOR_REV_ID_MASK                                                       0x0FL
#define IOMMU_L2_0_IOMMU_REVISION_ID__MAJOR_REV_ID_MASK                                                       0xF0L
//IOMMU_L2_0_IOMMU_REGPROG_INF
#define IOMMU_L2_0_IOMMU_REGPROG_INF__REG_LEVEL_PROG_INF__SHIFT                                               0x0
#define IOMMU_L2_0_IOMMU_REGPROG_INF__REG_LEVEL_PROG_INF_MASK                                                 0xFFL
//IOMMU_L2_0_IOMMU_SUB_CLASS
#define IOMMU_L2_0_IOMMU_SUB_CLASS__SUB_CLASS_INF__SHIFT                                                      0x0
#define IOMMU_L2_0_IOMMU_SUB_CLASS__SUB_CLASS_INF_MASK                                                        0xFFL
//IOMMU_L2_0_IOMMU_BASE_CODE
#define IOMMU_L2_0_IOMMU_BASE_CODE__BASE_CLASS_CODE__SHIFT                                                    0x0
#define IOMMU_L2_0_IOMMU_BASE_CODE__BASE_CLASS_CODE_MASK                                                      0xFFL
//IOMMU_L2_0_IOMMU_CACHE_LINE
#define IOMMU_L2_0_IOMMU_CACHE_LINE__CACHE_LINE_SIZE__SHIFT                                                   0x0
#define IOMMU_L2_0_IOMMU_CACHE_LINE__CACHE_LINE_SIZE_MASK                                                     0xFFL
//IOMMU_L2_0_IOMMU_LATENCY
#define IOMMU_L2_0_IOMMU_LATENCY__LATENCY__SHIFT                                                              0x0
#define IOMMU_L2_0_IOMMU_LATENCY__LATENCY_MASK                                                                0xFFL
//IOMMU_L2_0_IOMMU_HEADER
#define IOMMU_L2_0_IOMMU_HEADER__HEADER_TYPE__SHIFT                                                           0x0
#define IOMMU_L2_0_IOMMU_HEADER__HEADER_TYPE_MASK                                                             0xFFL
//IOMMU_L2_0_IOMMU_BIST
#define IOMMU_L2_0_IOMMU_BIST__BIST_COMP__SHIFT                                                               0x0
#define IOMMU_L2_0_IOMMU_BIST__BIST_STRT__SHIFT                                                               0x6
#define IOMMU_L2_0_IOMMU_BIST__BIST_CAP__SHIFT                                                                0x7
#define IOMMU_L2_0_IOMMU_BIST__BIST_COMP_MASK                                                                 0x0FL
#define IOMMU_L2_0_IOMMU_BIST__BIST_STRT_MASK                                                                 0x40L
#define IOMMU_L2_0_IOMMU_BIST__BIST_CAP_MASK                                                                  0x80L
//IOMMU_L2_0_IOMMU_ADAPTER_ID
#define IOMMU_L2_0_IOMMU_ADAPTER_ID__SUBSYSTEM_VENDOR_ID__SHIFT                                               0x0
#define IOMMU_L2_0_IOMMU_ADAPTER_ID__SUBSYSTEM_ID__SHIFT                                                      0x10
#define IOMMU_L2_0_IOMMU_ADAPTER_ID__SUBSYSTEM_VENDOR_ID_MASK                                                 0x0000FFFFL
#define IOMMU_L2_0_IOMMU_ADAPTER_ID__SUBSYSTEM_ID_MASK                                                        0xFFFF0000L
//IOMMU_L2_0_IOMMU_CAPABILITIES_PTR
#define IOMMU_L2_0_IOMMU_CAPABILITIES_PTR__CAP_PTR__SHIFT                                                     0x0
#define IOMMU_L2_0_IOMMU_CAPABILITIES_PTR__CAP_PTR_MASK                                                       0x000000FFL
//IOMMU_L2_0_IOMMU_INTERRUPT_LINE
#define IOMMU_L2_0_IOMMU_INTERRUPT_LINE__INTERRUPT_LINE__SHIFT                                                0x0
#define IOMMU_L2_0_IOMMU_INTERRUPT_LINE__INTERRUPT_LINE_MASK                                                  0xFFL
//IOMMU_L2_0_IOMMU_INTERRUPT_PIN
#define IOMMU_L2_0_IOMMU_INTERRUPT_PIN__INTERRUPT_PIN__SHIFT                                                  0x0
#define IOMMU_L2_0_IOMMU_INTERRUPT_PIN__INTERRUPT_PIN_MASK                                                    0xFFL
//IOMMU_L2_0_IOMMU_CAP_HEADER
#define IOMMU_L2_0_IOMMU_CAP_HEADER__IOMMU_CAP_ID__SHIFT                                                      0x0
#define IOMMU_L2_0_IOMMU_CAP_HEADER__IOMMU_CAP_PTR__SHIFT                                                     0x8
#define IOMMU_L2_0_IOMMU_CAP_HEADER__IOMMU_CAP_TYPE__SHIFT                                                    0x10
#define IOMMU_L2_0_IOMMU_CAP_HEADER__IOMMU_CAP_REV__SHIFT                                                     0x13
#define IOMMU_L2_0_IOMMU_CAP_HEADER__IOMMU_IO_TLBSUP__SHIFT                                                   0x18
#define IOMMU_L2_0_IOMMU_CAP_HEADER__IOMMU_HT_TUNNEL_SUP__SHIFT                                               0x19
#define IOMMU_L2_0_IOMMU_CAP_HEADER__IOMMU_NP_CACHE__SHIFT                                                    0x1a
#define IOMMU_L2_0_IOMMU_CAP_HEADER__IOMMU_EFR_SUP__SHIFT                                                     0x1b
#define IOMMU_L2_0_IOMMU_CAP_HEADER__IOMMU_CAP_EXT__SHIFT                                                     0x1c
#define IOMMU_L2_0_IOMMU_CAP_HEADER__Reserved__SHIFT                                                          0x1d
#define IOMMU_L2_0_IOMMU_CAP_HEADER__IOMMU_CAP_ID_MASK                                                        0x000000FFL
#define IOMMU_L2_0_IOMMU_CAP_HEADER__IOMMU_CAP_PTR_MASK                                                       0x0000FF00L
#define IOMMU_L2_0_IOMMU_CAP_HEADER__IOMMU_CAP_TYPE_MASK                                                      0x00070000L
#define IOMMU_L2_0_IOMMU_CAP_HEADER__IOMMU_CAP_REV_MASK                                                       0x00F80000L
#define IOMMU_L2_0_IOMMU_CAP_HEADER__IOMMU_IO_TLBSUP_MASK                                                     0x01000000L
#define IOMMU_L2_0_IOMMU_CAP_HEADER__IOMMU_HT_TUNNEL_SUP_MASK                                                 0x02000000L
#define IOMMU_L2_0_IOMMU_CAP_HEADER__IOMMU_NP_CACHE_MASK                                                      0x04000000L
#define IOMMU_L2_0_IOMMU_CAP_HEADER__IOMMU_EFR_SUP_MASK                                                       0x08000000L
#define IOMMU_L2_0_IOMMU_CAP_HEADER__IOMMU_CAP_EXT_MASK                                                       0x10000000L
#define IOMMU_L2_0_IOMMU_CAP_HEADER__Reserved_MASK                                                            0xE0000000L
//IOMMU_L2_0_IOMMU_CAP_BASE_LO
#define IOMMU_L2_0_IOMMU_CAP_BASE_LO__IOMMU_ENABLE__SHIFT                                                     0x0
#define IOMMU_L2_0_IOMMU_CAP_BASE_LO__Reserved__SHIFT                                                         0x1
#define IOMMU_L2_0_IOMMU_CAP_BASE_LO__IOMMU_BASE_ADDR_LO__SHIFT                                               0x13
#define IOMMU_L2_0_IOMMU_CAP_BASE_LO__IOMMU_ENABLE_MASK                                                       0x00000001L
#define IOMMU_L2_0_IOMMU_CAP_BASE_LO__Reserved_MASK                                                           0x00003FFEL
#define IOMMU_L2_0_IOMMU_CAP_BASE_LO__IOMMU_BASE_ADDR_LO_MASK                                                 0xFFF80000L
//IOMMU_L2_0_IOMMU_CAP_BASE_HI
#define IOMMU_L2_0_IOMMU_CAP_BASE_HI__IOMMU_BASE_ADDR_HI__SHIFT                                               0x0
#define IOMMU_L2_0_IOMMU_CAP_BASE_HI__IOMMU_BASE_ADDR_HI_MASK                                                 0xFFFFFFFFL
//IOMMU_L2_0_IOMMU_CAP_RANGE
#define IOMMU_L2_0_IOMMU_CAP_RANGE__IOMMU_UNIT_ID__SHIFT                                                      0x0
#define IOMMU_L2_0_IOMMU_CAP_RANGE__Reserved__SHIFT                                                           0x5
#define IOMMU_L2_0_IOMMU_CAP_RANGE__IOMMU_RNG_VALID__SHIFT                                                    0x7
#define IOMMU_L2_0_IOMMU_CAP_RANGE__IOMMU_BUS_NUMBER__SHIFT                                                   0x8
#define IOMMU_L2_0_IOMMU_CAP_RANGE__IOMMU_FIRST_DEVICE__SHIFT                                                 0x10
#define IOMMU_L2_0_IOMMU_CAP_RANGE__IOMMU_LAST_DEVICE__SHIFT                                                  0x18
#define IOMMU_L2_0_IOMMU_CAP_RANGE__IOMMU_UNIT_ID_MASK                                                        0x0000001FL
#define IOMMU_L2_0_IOMMU_CAP_RANGE__Reserved_MASK                                                             0x00000060L
#define IOMMU_L2_0_IOMMU_CAP_RANGE__IOMMU_RNG_VALID_MASK                                                      0x00000080L
#define IOMMU_L2_0_IOMMU_CAP_RANGE__IOMMU_BUS_NUMBER_MASK                                                     0x0000FF00L
#define IOMMU_L2_0_IOMMU_CAP_RANGE__IOMMU_FIRST_DEVICE_MASK                                                   0x00FF0000L
#define IOMMU_L2_0_IOMMU_CAP_RANGE__IOMMU_LAST_DEVICE_MASK                                                    0xFF000000L
//IOMMU_L2_0_IOMMU_CAP_MISC
#define IOMMU_L2_0_IOMMU_CAP_MISC__IOMMU_MSI_NUM__SHIFT                                                       0x0
#define IOMMU_L2_0_IOMMU_CAP_MISC__IOMMU_GVA_SIZE__SHIFT                                                      0x5
#define IOMMU_L2_0_IOMMU_CAP_MISC__IOMMU_PA_SIZE__SHIFT                                                       0x8
#define IOMMU_L2_0_IOMMU_CAP_MISC__IOMMU_VA_SIZE__SHIFT                                                       0xf
#define IOMMU_L2_0_IOMMU_CAP_MISC__IOMMU_HT_ATS_RESV__SHIFT                                                   0x16
#define IOMMU_L2_0_IOMMU_CAP_MISC__Reserved1__SHIFT                                                           0x17
#define IOMMU_L2_0_IOMMU_CAP_MISC__IOMMU_MSI_NUM_PPR__SHIFT                                                   0x1b
#define IOMMU_L2_0_IOMMU_CAP_MISC__IOMMU_MSI_NUM_MASK                                                         0x0000001FL
#define IOMMU_L2_0_IOMMU_CAP_MISC__IOMMU_GVA_SIZE_MASK                                                        0x000000E0L
#define IOMMU_L2_0_IOMMU_CAP_MISC__IOMMU_PA_SIZE_MASK                                                         0x00007F00L
#define IOMMU_L2_0_IOMMU_CAP_MISC__IOMMU_VA_SIZE_MASK                                                         0x003F8000L
#define IOMMU_L2_0_IOMMU_CAP_MISC__IOMMU_HT_ATS_RESV_MASK                                                     0x00400000L
#define IOMMU_L2_0_IOMMU_CAP_MISC__Reserved1_MASK                                                             0x07800000L
#define IOMMU_L2_0_IOMMU_CAP_MISC__IOMMU_MSI_NUM_PPR_MASK                                                     0xF8000000L
//IOMMU_L2_0_IOMMU_CAP_MISC_1
#define IOMMU_L2_0_IOMMU_CAP_MISC_1__IOMMU_MSI_NUM_GA__SHIFT                                                  0x0
#define IOMMU_L2_0_IOMMU_CAP_MISC_1__IOMMU_ARCH_MODE__SHIFT                                                   0x5
#define IOMMU_L2_0_IOMMU_CAP_MISC_1__DVM_MODE__SHIFT                                                          0x6
#define IOMMU_L2_0_IOMMU_CAP_MISC_1__SMMUMMIO_EN__SHIFT                                                       0xf
#define IOMMU_L2_0_IOMMU_CAP_MISC_1__SMMUMMIO_LOCK__SHIFT                                                     0x1f
#define IOMMU_L2_0_IOMMU_CAP_MISC_1__IOMMU_MSI_NUM_GA_MASK                                                    0x0000001FL
#define IOMMU_L2_0_IOMMU_CAP_MISC_1__IOMMU_ARCH_MODE_MASK                                                     0x00000020L
#define IOMMU_L2_0_IOMMU_CAP_MISC_1__DVM_MODE_MASK                                                            0x000000C0L
#define IOMMU_L2_0_IOMMU_CAP_MISC_1__SMMUMMIO_EN_MASK                                                         0x00008000L
#define IOMMU_L2_0_IOMMU_CAP_MISC_1__SMMUMMIO_LOCK_MASK                                                       0x80000000L
//IOMMU_L2_0_IOMMU_MSI_CAP
#define IOMMU_L2_0_IOMMU_MSI_CAP__MSI_CAP_ID__SHIFT                                                           0x0
#define IOMMU_L2_0_IOMMU_MSI_CAP__MSI_CAP_PTR__SHIFT                                                          0x8
#define IOMMU_L2_0_IOMMU_MSI_CAP__MSI_EN__SHIFT                                                               0x10
#define IOMMU_L2_0_IOMMU_MSI_CAP__MSI_MULT_MESS_CAP__SHIFT                                                    0x11
#define IOMMU_L2_0_IOMMU_MSI_CAP__MSI_MULT_MESS_EN__SHIFT                                                     0x14
#define IOMMU_L2_0_IOMMU_MSI_CAP__MSI_64_EN__SHIFT                                                            0x17
#define IOMMU_L2_0_IOMMU_MSI_CAP__Reserved__SHIFT                                                             0x18
#define IOMMU_L2_0_IOMMU_MSI_CAP__MSI_CAP_ID_MASK                                                             0x000000FFL
#define IOMMU_L2_0_IOMMU_MSI_CAP__MSI_CAP_PTR_MASK                                                            0x0000FF00L
#define IOMMU_L2_0_IOMMU_MSI_CAP__MSI_EN_MASK                                                                 0x00010000L
#define IOMMU_L2_0_IOMMU_MSI_CAP__MSI_MULT_MESS_CAP_MASK                                                      0x000E0000L
#define IOMMU_L2_0_IOMMU_MSI_CAP__MSI_MULT_MESS_EN_MASK                                                       0x00700000L
#define IOMMU_L2_0_IOMMU_MSI_CAP__MSI_64_EN_MASK                                                              0x00800000L
#define IOMMU_L2_0_IOMMU_MSI_CAP__Reserved_MASK                                                               0xFF000000L
//IOMMU_L2_0_IOMMU_MSI_ADDR_LO
#define IOMMU_L2_0_IOMMU_MSI_ADDR_LO__Reserved__SHIFT                                                         0x0
#define IOMMU_L2_0_IOMMU_MSI_ADDR_LO__MSI_ADDR_LO__SHIFT                                                      0x2
#define IOMMU_L2_0_IOMMU_MSI_ADDR_LO__Reserved_MASK                                                           0x00000003L
#define IOMMU_L2_0_IOMMU_MSI_ADDR_LO__MSI_ADDR_LO_MASK                                                        0xFFFFFFFCL
//IOMMU_L2_0_IOMMU_MSI_ADDR_HI
#define IOMMU_L2_0_IOMMU_MSI_ADDR_HI__MSI_ADDR_HI__SHIFT                                                      0x0
#define IOMMU_L2_0_IOMMU_MSI_ADDR_HI__MSI_ADDR_HI_MASK                                                        0xFFFFFFFFL
//IOMMU_L2_0_IOMMU_MSI_DATA
#define IOMMU_L2_0_IOMMU_MSI_DATA__MSI_DATA__SHIFT                                                            0x0
#define IOMMU_L2_0_IOMMU_MSI_DATA__Reserved__SHIFT                                                            0x10
#define IOMMU_L2_0_IOMMU_MSI_DATA__MSI_DATA_MASK                                                              0x0000FFFFL
#define IOMMU_L2_0_IOMMU_MSI_DATA__Reserved_MASK                                                              0xFFFF0000L
//IOMMU_L2_0_IOMMU_MSI_MAPPING_CAP
#define IOMMU_L2_0_IOMMU_MSI_MAPPING_CAP__MSI_MAP_CAP_ID__SHIFT                                               0x0
#define IOMMU_L2_0_IOMMU_MSI_MAPPING_CAP__MSI_MAP_CAP_PTR__SHIFT                                              0x8
#define IOMMU_L2_0_IOMMU_MSI_MAPPING_CAP__MSI_MAP_EN__SHIFT                                                   0x10
#define IOMMU_L2_0_IOMMU_MSI_MAPPING_CAP__MSI_MAP_FIXD__SHIFT                                                 0x11
#define IOMMU_L2_0_IOMMU_MSI_MAPPING_CAP__MSI_MAP_RSV__SHIFT                                                  0x12
#define IOMMU_L2_0_IOMMU_MSI_MAPPING_CAP__MSI_MAP_CAP_TYPE__SHIFT                                             0x1b
#define IOMMU_L2_0_IOMMU_MSI_MAPPING_CAP__MSI_MAP_CAP_ID_MASK                                                 0x000000FFL
#define IOMMU_L2_0_IOMMU_MSI_MAPPING_CAP__MSI_MAP_CAP_PTR_MASK                                                0x0000FF00L
#define IOMMU_L2_0_IOMMU_MSI_MAPPING_CAP__MSI_MAP_EN_MASK                                                     0x00010000L
#define IOMMU_L2_0_IOMMU_MSI_MAPPING_CAP__MSI_MAP_FIXD_MASK                                                   0x00020000L
#define IOMMU_L2_0_IOMMU_MSI_MAPPING_CAP__MSI_MAP_RSV_MASK                                                    0x07FC0000L
#define IOMMU_L2_0_IOMMU_MSI_MAPPING_CAP__MSI_MAP_CAP_TYPE_MASK                                               0xF8000000L
//IOMMU_L2_0_IOMMU_ADAPTER_ID_W
#define IOMMU_L2_0_IOMMU_ADAPTER_ID_W__SUBSYSTEM_VENDOR_ID_W__SHIFT                                           0x0
#define IOMMU_L2_0_IOMMU_ADAPTER_ID_W__SUBSYSTEM_ID_W__SHIFT                                                  0x10
#define IOMMU_L2_0_IOMMU_ADAPTER_ID_W__SUBSYSTEM_VENDOR_ID_W_MASK                                             0x0000FFFFL
#define IOMMU_L2_0_IOMMU_ADAPTER_ID_W__SUBSYSTEM_ID_W_MASK                                                    0xFFFF0000L
//IOMMU_L2_0_IOMMU_CONTROL_W
#define IOMMU_L2_0_IOMMU_CONTROL_W__INTERRUPT_PIN_W__SHIFT                                                    0x0
#define IOMMU_L2_0_IOMMU_CONTROL_W__MINOR_REV_ID_W__SHIFT                                                     0x4
#define IOMMU_L2_0_IOMMU_CONTROL_W__IO_TLBSUP_W__SHIFT                                                        0x8
#define IOMMU_L2_0_IOMMU_CONTROL_W__EFR_SUP_W__SHIFT                                                          0x9
#define IOMMU_L2_0_IOMMU_CONTROL_W__MSI_MULT_MESS_CAP_W__SHIFT                                                0xa
#define IOMMU_L2_0_IOMMU_CONTROL_W__IOMMU_CAP_EXT_W__SHIFT                                                    0xd
#define IOMMU_L2_0_IOMMU_CONTROL_W__INTERRUPT_PIN_W_MASK                                                      0x00000007L
#define IOMMU_L2_0_IOMMU_CONTROL_W__MINOR_REV_ID_W_MASK                                                       0x000000F0L
#define IOMMU_L2_0_IOMMU_CONTROL_W__IO_TLBSUP_W_MASK                                                          0x00000100L
#define IOMMU_L2_0_IOMMU_CONTROL_W__EFR_SUP_W_MASK                                                            0x00000200L
#define IOMMU_L2_0_IOMMU_CONTROL_W__MSI_MULT_MESS_CAP_W_MASK                                                  0x00001C00L
#define IOMMU_L2_0_IOMMU_CONTROL_W__IOMMU_CAP_EXT_W_MASK                                                      0x00002000L
//IOMMU_L2_0_IOMMU_MMIO_CONTROL0_W
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL0_W__PREF_SUP_W__SHIFT                                                   0x0
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL0_W__PPR_SUP_W__SHIFT                                                    0x1
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL0_W__Reserved3__SHIFT                                                    0x2
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL0_W__NX_SUP_W__SHIFT                                                     0x3
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL0_W__GT_SUP_W__SHIFT                                                     0x4
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL0_W__Reserved2__SHIFT                                                    0x5
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL0_W__IA_SUP_W__SHIFT                                                     0x6
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL0_W__GA_SUP_W__SHIFT                                                     0x7
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL0_W__HE_SUP_W__SHIFT                                                     0x8
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL0_W__PC_SUP_W__SHIFT                                                     0x9
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL0_W__HATS_W__SHIFT                                                       0xa
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL0_W__US_SUP_W__SHIFT                                                     0xc
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL0_W__Reserved5__SHIFT                                                    0xd
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL0_W__GAM_SUP_W__SHIFT                                                    0x15
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL0_W__PPRF_W__SHIFT                                                       0x18
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL0_W__Reserved6__SHIFT                                                    0x1a
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL0_W__EVENTF_W__SHIFT                                                     0x1c
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL0_W__GLX_SUP_W__SHIFT                                                    0x1e
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL0_W__PREF_SUP_W_MASK                                                     0x00000001L
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL0_W__PPR_SUP_W_MASK                                                      0x00000002L
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL0_W__Reserved3_MASK                                                      0x00000004L
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL0_W__NX_SUP_W_MASK                                                       0x00000008L
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL0_W__GT_SUP_W_MASK                                                       0x00000010L
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL0_W__Reserved2_MASK                                                      0x00000020L
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL0_W__IA_SUP_W_MASK                                                       0x00000040L
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL0_W__GA_SUP_W_MASK                                                       0x00000080L
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL0_W__HE_SUP_W_MASK                                                       0x00000100L
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL0_W__PC_SUP_W_MASK                                                       0x00000200L
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL0_W__HATS_W_MASK                                                         0x00000C00L
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL0_W__US_SUP_W_MASK                                                       0x00001000L
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL0_W__Reserved5_MASK                                                      0x001FE000L
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL0_W__GAM_SUP_W_MASK                                                      0x00E00000L
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL0_W__PPRF_W_MASK                                                         0x03000000L
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL0_W__Reserved6_MASK                                                      0x0C000000L
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL0_W__EVENTF_W_MASK                                                       0x30000000L
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL0_W__GLX_SUP_W_MASK                                                      0xC0000000L
//IOMMU_L2_0_IOMMU_MMIO_CONTROL1_W
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL1_W__PAS_MAX_W__SHIFT                                                    0x0
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL1_W__Reserved1__SHIFT                                                    0x4
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL1_W__DTE_seg_W__SHIFT                                                    0x6
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL1_W__PPR_OVERFLOW_EARLY_SUP_W__SHIFT                                     0x8
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL1_W__PPR_AUTORESP_SUP_W__SHIFT                                           0x9
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL1_W__BLOCK_STOPMARK_SUP_W__SHIFT                                         0xa
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL1_W__MARCnum_SUP_W__SHIFT                                                0xb
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL1_W__SNOOP_ATTRS_SUP_W__SHIFT                                            0xd
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL1_W__GIo_SUP_W__SHIFT                                                    0xe
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL1_W__HA_SUP_W__SHIFT                                                     0xf
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL1_W__EPH_SUP_W__SHIFT                                                    0x10
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL1_W__ATTRFW_SUP_W__SHIFT                                                 0x11
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL1_W__V2_HD_DIS_SUP_W__SHIFT                                              0x12
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL1_W__InvIotlbTypeSup_W__SHIFT                                            0x13
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL1_W__HD_SUP_W__SHIFT                                                     0x14
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL1_W__Reserved__SHIFT                                                     0x15
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL1_W__PAS_MAX_W_MASK                                                      0x0000000FL
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL1_W__Reserved1_MASK                                                      0x00000030L
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL1_W__DTE_seg_W_MASK                                                      0x000000C0L
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL1_W__PPR_OVERFLOW_EARLY_SUP_W_MASK                                       0x00000100L
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL1_W__PPR_AUTORESP_SUP_W_MASK                                             0x00000200L
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL1_W__BLOCK_STOPMARK_SUP_W_MASK                                           0x00000400L
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL1_W__MARCnum_SUP_W_MASK                                                  0x00001800L
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL1_W__SNOOP_ATTRS_SUP_W_MASK                                              0x00002000L
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL1_W__GIo_SUP_W_MASK                                                      0x00004000L
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL1_W__HA_SUP_W_MASK                                                       0x00008000L
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL1_W__EPH_SUP_W_MASK                                                      0x00010000L
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL1_W__ATTRFW_SUP_W_MASK                                                   0x00020000L
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL1_W__V2_HD_DIS_SUP_W_MASK                                                0x00040000L
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL1_W__InvIotlbTypeSup_W_MASK                                              0x00080000L
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL1_W__HD_SUP_W_MASK                                                       0x00100000L
#define IOMMU_L2_0_IOMMU_MMIO_CONTROL1_W__Reserved_MASK                                                       0xFFE00000L
//IOMMU_L2_0_IOMMU_RANGE_W
#define IOMMU_L2_0_IOMMU_RANGE_W__Reserved__SHIFT                                                             0x0
#define IOMMU_L2_0_IOMMU_RANGE_W__RNG_VALID_W__SHIFT                                                          0x7
#define IOMMU_L2_0_IOMMU_RANGE_W__BUS_NUMBER_W__SHIFT                                                         0x8
#define IOMMU_L2_0_IOMMU_RANGE_W__FIRST_DEVICE_W__SHIFT                                                       0x10
#define IOMMU_L2_0_IOMMU_RANGE_W__LAST_DEVICE_W__SHIFT                                                        0x18
#define IOMMU_L2_0_IOMMU_RANGE_W__Reserved_MASK                                                               0x0000007FL
#define IOMMU_L2_0_IOMMU_RANGE_W__RNG_VALID_W_MASK                                                            0x00000080L
#define IOMMU_L2_0_IOMMU_RANGE_W__BUS_NUMBER_W_MASK                                                           0x0000FF00L
#define IOMMU_L2_0_IOMMU_RANGE_W__FIRST_DEVICE_W_MASK                                                         0x00FF0000L
#define IOMMU_L2_0_IOMMU_RANGE_W__LAST_DEVICE_W_MASK                                                          0xFF000000L
//IOMMU_L2_0_IOMMU_DSFX_CONTROL
#define IOMMU_L2_0_IOMMU_DSFX_CONTROL__DSFXSup__SHIFT                                                         0x0
#define IOMMU_L2_0_IOMMU_DSFX_CONTROL__REVISION_MINOR__SHIFT                                                  0x18
#define IOMMU_L2_0_IOMMU_DSFX_CONTROL__REVISION_MAJOR__SHIFT                                                  0x1c
#define IOMMU_L2_0_IOMMU_DSFX_CONTROL__DSFXSup_MASK                                                           0x00FFFFFFL
#define IOMMU_L2_0_IOMMU_DSFX_CONTROL__REVISION_MINOR_MASK                                                    0x0F000000L
#define IOMMU_L2_0_IOMMU_DSFX_CONTROL__REVISION_MAJOR_MASK                                                    0xF0000000L
//IOMMU_L2_0_IOMMU_DSSX_DUMMY_0
#define IOMMU_L2_0_IOMMU_DSSX_DUMMY_0__DSSX_status_set__SHIFT                                                 0x0
#define IOMMU_L2_0_IOMMU_DSSX_DUMMY_0__Reserved__SHIFT                                                        0x18
#define IOMMU_L2_0_IOMMU_DSSX_DUMMY_0__DSSX_status_set_MASK                                                   0x00FFFFFFL
#define IOMMU_L2_0_IOMMU_DSSX_DUMMY_0__Reserved_MASK                                                          0xFF000000L
//IOMMU_L2_0_IOMMU_DSCX_DUMMY_0
#define IOMMU_L2_0_IOMMU_DSCX_DUMMY_0__DSCX_CNTRL_set__SHIFT                                                  0x0
#define IOMMU_L2_0_IOMMU_DSCX_DUMMY_0__Reserved__SHIFT                                                        0x18
#define IOMMU_L2_0_IOMMU_DSCX_DUMMY_0__DSCX_CNTRL_set_MASK                                                    0x00FFFFFFL
#define IOMMU_L2_0_IOMMU_DSCX_DUMMY_0__Reserved_MASK                                                          0xFF000000L
//IOMMU_L2_0_L2B_POISON_DVM_CNTRL
#define IOMMU_L2_0_L2B_POISON_DVM_CNTRL__DVM_POISON_RESP_MODE__SHIFT                                          0x0
#define IOMMU_L2_0_L2B_POISON_DVM_CNTRL__DVM_POISON_RESP_MODE_MASK                                            0x00000003L
//IOMMU_L2_0_L2_IOHC_DmaReq_Stall_Control
#define IOMMU_L2_0_L2_IOHC_DmaReq_Stall_Control__StallNPReqEn__SHIFT                                          0x0
#define IOMMU_L2_0_L2_IOHC_DmaReq_Stall_Control__StallPReqEn__SHIFT                                           0x2
#define IOMMU_L2_0_L2_IOHC_DmaReq_Stall_Control__StallMemReqEn__SHIFT                                         0x8
#define IOMMU_L2_0_L2_IOHC_DmaReq_Stall_Control__StallHRT1ReqEn__SHIFT                                        0xe
#define IOMMU_L2_0_L2_IOHC_DmaReq_Stall_Control__StallNPReqEn_MASK                                            0x00000003L
#define IOMMU_L2_0_L2_IOHC_DmaReq_Stall_Control__StallPReqEn_MASK                                             0x0000000CL
#define IOMMU_L2_0_L2_IOHC_DmaReq_Stall_Control__StallMemReqEn_MASK                                           0x00000300L
#define IOMMU_L2_0_L2_IOHC_DmaReq_Stall_Control__StallHRT1ReqEn_MASK                                          0x0000C000L
//IOMMU_L2_0_IOHC_L2_HostRsp_Stall_Control
#define IOMMU_L2_0_IOHC_L2_HostRsp_Stall_Control__StallUpRdRspEn__SHIFT                                       0x4
#define IOMMU_L2_0_IOHC_L2_HostRsp_Stall_Control__StallUpRdRspEn_MASK                                         0x00000030L
//IOMMU_L2_0_SMMU_MMIO_IDR0_W
#define IOMMU_L2_0_SMMU_MMIO_IDR0_W__S2P_W__SHIFT                                                             0x0
#define IOMMU_L2_0_SMMU_MMIO_IDR0_W__S1P_W__SHIFT                                                             0x1
#define IOMMU_L2_0_SMMU_MMIO_IDR0_W__TTF_W__SHIFT                                                             0x2
#define IOMMU_L2_0_SMMU_MMIO_IDR0_W__COHACC_W__SHIFT                                                          0x4
#define IOMMU_L2_0_SMMU_MMIO_IDR0_W__BTM_W__SHIFT                                                             0x5
#define IOMMU_L2_0_SMMU_MMIO_IDR0_W__HTTU_W__SHIFT                                                            0x6
#define IOMMU_L2_0_SMMU_MMIO_IDR0_W__DORMHINT_W__SHIFT                                                        0x8
#define IOMMU_L2_0_SMMU_MMIO_IDR0_W__Hyp_W__SHIFT                                                             0x9
#define IOMMU_L2_0_SMMU_MMIO_IDR0_W__ATS_W__SHIFT                                                             0xa
#define IOMMU_L2_0_SMMU_MMIO_IDR0_W__PERFCTRS_W__SHIFT                                                        0xb
#define IOMMU_L2_0_SMMU_MMIO_IDR0_W__ASID16_W__SHIFT                                                          0xc
#define IOMMU_L2_0_SMMU_MMIO_IDR0_W__MSI_W__SHIFT                                                             0xd
#define IOMMU_L2_0_SMMU_MMIO_IDR0_W__SEV_W__SHIFT                                                             0xe
#define IOMMU_L2_0_SMMU_MMIO_IDR0_W__ATOS_W__SHIFT                                                            0xf
#define IOMMU_L2_0_SMMU_MMIO_IDR0_W__PRI_W__SHIFT                                                             0x10
#define IOMMU_L2_0_SMMU_MMIO_IDR0_W__VMW_W__SHIFT                                                             0x11
#define IOMMU_L2_0_SMMU_MMIO_IDR0_W__VMID16_W__SHIFT                                                          0x12
#define IOMMU_L2_0_SMMU_MMIO_IDR0_W__CD2L_W__SHIFT                                                            0x13
#define IOMMU_L2_0_SMMU_MMIO_IDR0_W__VATOS_W__SHIFT                                                           0x14
#define IOMMU_L2_0_SMMU_MMIO_IDR0_W__TTENDIAN_W__SHIFT                                                        0x15
#define IOMMU_L2_0_SMMU_MMIO_IDR0_W__STALL_MODEL_W__SHIFT                                                     0x18
#define IOMMU_L2_0_SMMU_MMIO_IDR0_W__TERM_MODEL_W__SHIFT                                                      0x1a
#define IOMMU_L2_0_SMMU_MMIO_IDR0_W__ST_LEVEL_W__SHIFT                                                        0x1b
#define IOMMU_L2_0_SMMU_MMIO_IDR0_W__RAS_W__SHIFT                                                             0x1d
#define IOMMU_L2_0_SMMU_MMIO_IDR0_W__S2P_W_MASK                                                               0x00000001L
#define IOMMU_L2_0_SMMU_MMIO_IDR0_W__S1P_W_MASK                                                               0x00000002L
#define IOMMU_L2_0_SMMU_MMIO_IDR0_W__TTF_W_MASK                                                               0x0000000CL
#define IOMMU_L2_0_SMMU_MMIO_IDR0_W__COHACC_W_MASK                                                            0x00000010L
#define IOMMU_L2_0_SMMU_MMIO_IDR0_W__BTM_W_MASK                                                               0x00000020L
#define IOMMU_L2_0_SMMU_MMIO_IDR0_W__HTTU_W_MASK                                                              0x000000C0L
#define IOMMU_L2_0_SMMU_MMIO_IDR0_W__DORMHINT_W_MASK                                                          0x00000100L
#define IOMMU_L2_0_SMMU_MMIO_IDR0_W__Hyp_W_MASK                                                               0x00000200L
#define IOMMU_L2_0_SMMU_MMIO_IDR0_W__ATS_W_MASK                                                               0x00000400L
#define IOMMU_L2_0_SMMU_MMIO_IDR0_W__PERFCTRS_W_MASK                                                          0x00000800L
#define IOMMU_L2_0_SMMU_MMIO_IDR0_W__ASID16_W_MASK                                                            0x00001000L
#define IOMMU_L2_0_SMMU_MMIO_IDR0_W__MSI_W_MASK                                                               0x00002000L
#define IOMMU_L2_0_SMMU_MMIO_IDR0_W__SEV_W_MASK                                                               0x00004000L
#define IOMMU_L2_0_SMMU_MMIO_IDR0_W__ATOS_W_MASK                                                              0x00008000L
#define IOMMU_L2_0_SMMU_MMIO_IDR0_W__PRI_W_MASK                                                               0x00010000L
#define IOMMU_L2_0_SMMU_MMIO_IDR0_W__VMW_W_MASK                                                               0x00020000L
#define IOMMU_L2_0_SMMU_MMIO_IDR0_W__VMID16_W_MASK                                                            0x00040000L
#define IOMMU_L2_0_SMMU_MMIO_IDR0_W__CD2L_W_MASK                                                              0x00080000L
#define IOMMU_L2_0_SMMU_MMIO_IDR0_W__VATOS_W_MASK                                                             0x00100000L
#define IOMMU_L2_0_SMMU_MMIO_IDR0_W__TTENDIAN_W_MASK                                                          0x00600000L
#define IOMMU_L2_0_SMMU_MMIO_IDR0_W__STALL_MODEL_W_MASK                                                       0x03000000L
#define IOMMU_L2_0_SMMU_MMIO_IDR0_W__TERM_MODEL_W_MASK                                                        0x04000000L
#define IOMMU_L2_0_SMMU_MMIO_IDR0_W__ST_LEVEL_W_MASK                                                          0x18000000L
#define IOMMU_L2_0_SMMU_MMIO_IDR0_W__RAS_W_MASK                                                               0x20000000L
//IOMMU_L2_0_SMMU_MMIO_IDR1_W
#define IOMMU_L2_0_SMMU_MMIO_IDR1_W__SIDSIZE_W__SHIFT                                                         0x0
#define IOMMU_L2_0_SMMU_MMIO_IDR1_W__SSIDSIZE_W__SHIFT                                                        0x6
#define IOMMU_L2_0_SMMU_MMIO_IDR1_W__PRIQS_W__SHIFT                                                           0xb
#define IOMMU_L2_0_SMMU_MMIO_IDR1_W__EVENTQS_W__SHIFT                                                         0x10
#define IOMMU_L2_0_SMMU_MMIO_IDR1_W__CMDQS_W__SHIFT                                                           0x15
#define IOMMU_L2_0_SMMU_MMIO_IDR1_W__ATTR_PERMS_OVR_W__SHIFT                                                  0x1a
#define IOMMU_L2_0_SMMU_MMIO_IDR1_W__ATTR_TYPES_OVR_W__SHIFT                                                  0x1b
#define IOMMU_L2_0_SMMU_MMIO_IDR1_W__REL_W__SHIFT                                                             0x1c
#define IOMMU_L2_0_SMMU_MMIO_IDR1_W__QUEUES_PRESET_W__SHIFT                                                   0x1d
#define IOMMU_L2_0_SMMU_MMIO_IDR1_W__TABLES_PRESET_W__SHIFT                                                   0x1e
#define IOMMU_L2_0_SMMU_MMIO_IDR1_W__SIDSIZE_W_MASK                                                           0x0000003FL
#define IOMMU_L2_0_SMMU_MMIO_IDR1_W__SSIDSIZE_W_MASK                                                          0x000007C0L
#define IOMMU_L2_0_SMMU_MMIO_IDR1_W__PRIQS_W_MASK                                                             0x0000F800L
#define IOMMU_L2_0_SMMU_MMIO_IDR1_W__EVENTQS_W_MASK                                                           0x001F0000L
#define IOMMU_L2_0_SMMU_MMIO_IDR1_W__CMDQS_W_MASK                                                             0x03E00000L
#define IOMMU_L2_0_SMMU_MMIO_IDR1_W__ATTR_PERMS_OVR_W_MASK                                                    0x04000000L
#define IOMMU_L2_0_SMMU_MMIO_IDR1_W__ATTR_TYPES_OVR_W_MASK                                                    0x08000000L
#define IOMMU_L2_0_SMMU_MMIO_IDR1_W__REL_W_MASK                                                               0x10000000L
#define IOMMU_L2_0_SMMU_MMIO_IDR1_W__QUEUES_PRESET_W_MASK                                                     0x20000000L
#define IOMMU_L2_0_SMMU_MMIO_IDR1_W__TABLES_PRESET_W_MASK                                                     0x40000000L
//IOMMU_L2_0_SMMU_MMIO_IDR2_W
#define IOMMU_L2_0_SMMU_MMIO_IDR2_W__BA_VATOS_W__SHIFT                                                        0x0
#define IOMMU_L2_0_SMMU_MMIO_IDR2_W__BA_RAS_W__SHIFT                                                          0xa
#define IOMMU_L2_0_SMMU_MMIO_IDR2_W__BA_VATOS_W_MASK                                                          0x000003FFL
#define IOMMU_L2_0_SMMU_MMIO_IDR2_W__BA_RAS_W_MASK                                                            0x000FFC00L
//IOMMU_L2_0_SMMU_MMIO_IDR3_W
#define IOMMU_L2_0_SMMU_MMIO_IDR3_W__HAD_W__SHIFT                                                             0x2
#define IOMMU_L2_0_SMMU_MMIO_IDR3_W__HAD_W_MASK                                                               0x00000004L
//IOMMU_L2_0_SMMU_MMIO_IDR5_W
#define IOMMU_L2_0_SMMU_MMIO_IDR5_W__OAS_W__SHIFT                                                             0x0
#define IOMMU_L2_0_SMMU_MMIO_IDR5_W__GRAN4K_W__SHIFT                                                          0x4
#define IOMMU_L2_0_SMMU_MMIO_IDR5_W__GRAN16K_W__SHIFT                                                         0x5
#define IOMMU_L2_0_SMMU_MMIO_IDR5_W__GRAN64K_W__SHIFT                                                         0x6
#define IOMMU_L2_0_SMMU_MMIO_IDR5_W__STALL_MAX_W__SHIFT                                                       0x10
#define IOMMU_L2_0_SMMU_MMIO_IDR5_W__OAS_W_MASK                                                               0x00000007L
#define IOMMU_L2_0_SMMU_MMIO_IDR5_W__GRAN4K_W_MASK                                                            0x00000010L
#define IOMMU_L2_0_SMMU_MMIO_IDR5_W__GRAN16K_W_MASK                                                           0x00000020L
#define IOMMU_L2_0_SMMU_MMIO_IDR5_W__GRAN64K_W_MASK                                                           0x00000040L
#define IOMMU_L2_0_SMMU_MMIO_IDR5_W__STALL_MAX_W_MASK                                                         0xFFFF0000L
//IOMMU_L2_0_SMMU_MMIO_IIDR_W
#define IOMMU_L2_0_SMMU_MMIO_IIDR_W__Implementer_W__SHIFT                                                     0x0
#define IOMMU_L2_0_SMMU_MMIO_IIDR_W__Revision_W__SHIFT                                                        0xc
#define IOMMU_L2_0_SMMU_MMIO_IIDR_W__Variant_W__SHIFT                                                         0x10
#define IOMMU_L2_0_SMMU_MMIO_IIDR_W__ProductID_W__SHIFT                                                       0x14
#define IOMMU_L2_0_SMMU_MMIO_IIDR_W__Implementer_W_MASK                                                       0x00000FFFL
#define IOMMU_L2_0_SMMU_MMIO_IIDR_W__Revision_W_MASK                                                          0x0000F000L
#define IOMMU_L2_0_SMMU_MMIO_IIDR_W__Variant_W_MASK                                                           0x000F0000L
#define IOMMU_L2_0_SMMU_MMIO_IIDR_W__ProductID_W_MASK                                                         0xFFF00000L
//IOMMU_L2_0_SMMU_AIDR_W
#define IOMMU_L2_0_SMMU_AIDR_W__ArchMinorRev_W__SHIFT                                                         0x0
#define IOMMU_L2_0_SMMU_AIDR_W__ArchMajorRev_W__SHIFT                                                         0x4
#define IOMMU_L2_0_SMMU_AIDR_W__ArchMinorRev_W_MASK                                                           0x0000000FL
#define IOMMU_L2_0_SMMU_AIDR_W__ArchMajorRev_W_MASK                                                           0x000000F0L


// addressBlock: nbio_nbif0_bif_cfg_dev0_rc_bifcfgdecp
//BIF_CFG_DEV0_RC0_VENDOR_ID
#define BIF_CFG_DEV0_RC0_VENDOR_ID__VENDOR_ID__SHIFT                                                          0x0
#define BIF_CFG_DEV0_RC0_VENDOR_ID__VENDOR_ID_MASK                                                            0xFFFFL
//BIF_CFG_DEV0_RC0_DEVICE_ID
#define BIF_CFG_DEV0_RC0_DEVICE_ID__DEVICE_ID__SHIFT                                                          0x0
#define BIF_CFG_DEV0_RC0_DEVICE_ID__DEVICE_ID_MASK                                                            0xFFFFL
//BIF_CFG_DEV0_RC0_COMMAND
#define BIF_CFG_DEV0_RC0_COMMAND__IOEN_DN__SHIFT                                                              0x0
#define BIF_CFG_DEV0_RC0_COMMAND__MEMEN_DN__SHIFT                                                             0x1
#define BIF_CFG_DEV0_RC0_COMMAND__BUS_MASTER_EN__SHIFT                                                        0x2
#define BIF_CFG_DEV0_RC0_COMMAND__SPECIAL_CYCLE_EN__SHIFT                                                     0x3
#define BIF_CFG_DEV0_RC0_COMMAND__MEM_WRITE_INVALIDATE_EN__SHIFT                                              0x4
#define BIF_CFG_DEV0_RC0_COMMAND__PAL_SNOOP_EN__SHIFT                                                         0x5
#define BIF_CFG_DEV0_RC0_COMMAND__PARITY_ERROR_RESPONSE__SHIFT                                                0x6
#define BIF_CFG_DEV0_RC0_COMMAND__AD_STEPPING__SHIFT                                                          0x7
#define BIF_CFG_DEV0_RC0_COMMAND__SERR_EN__SHIFT                                                              0x8
#define BIF_CFG_DEV0_RC0_COMMAND__FAST_B2B_EN__SHIFT                                                          0x9
#define BIF_CFG_DEV0_RC0_COMMAND__INT_DIS__SHIFT                                                              0xa
#define BIF_CFG_DEV0_RC0_COMMAND__IOEN_DN_MASK                                                                0x0001L
#define BIF_CFG_DEV0_RC0_COMMAND__MEMEN_DN_MASK                                                               0x0002L
#define BIF_CFG_DEV0_RC0_COMMAND__BUS_MASTER_EN_MASK                                                          0x0004L
#define BIF_CFG_DEV0_RC0_COMMAND__SPECIAL_CYCLE_EN_MASK                                                       0x0008L
#define BIF_CFG_DEV0_RC0_COMMAND__MEM_WRITE_INVALIDATE_EN_MASK                                                0x0010L
#define BIF_CFG_DEV0_RC0_COMMAND__PAL_SNOOP_EN_MASK                                                           0x0020L
#define BIF_CFG_DEV0_RC0_COMMAND__PARITY_ERROR_RESPONSE_MASK                                                  0x0040L
#define BIF_CFG_DEV0_RC0_COMMAND__AD_STEPPING_MASK                                                            0x0080L
#define BIF_CFG_DEV0_RC0_COMMAND__SERR_EN_MASK                                                                0x0100L
#define BIF_CFG_DEV0_RC0_COMMAND__FAST_B2B_EN_MASK                                                            0x0200L
#define BIF_CFG_DEV0_RC0_COMMAND__INT_DIS_MASK                                                                0x0400L
//BIF_CFG_DEV0_RC0_STATUS
#define BIF_CFG_DEV0_RC0_STATUS__INT_STATUS__SHIFT                                                            0x3
#define BIF_CFG_DEV0_RC0_STATUS__CAP_LIST__SHIFT                                                              0x4
#define BIF_CFG_DEV0_RC0_STATUS__PCI_66_EN__SHIFT                                                             0x5
#define BIF_CFG_DEV0_RC0_STATUS__FAST_BACK_CAPABLE__SHIFT                                                     0x7
#define BIF_CFG_DEV0_RC0_STATUS__MASTER_DATA_PARITY_ERROR__SHIFT                                              0x8
#define BIF_CFG_DEV0_RC0_STATUS__DEVSEL_TIMING__SHIFT                                                         0x9
#define BIF_CFG_DEV0_RC0_STATUS__SIGNAL_TARGET_ABORT__SHIFT                                                   0xb
#define BIF_CFG_DEV0_RC0_STATUS__RECEIVED_TARGET_ABORT__SHIFT                                                 0xc
#define BIF_CFG_DEV0_RC0_STATUS__RECEIVED_MASTER_ABORT__SHIFT                                                 0xd
#define BIF_CFG_DEV0_RC0_STATUS__SIGNALED_SYSTEM_ERROR__SHIFT                                                 0xe
#define BIF_CFG_DEV0_RC0_STATUS__PARITY_ERROR_DETECTED__SHIFT                                                 0xf
#define BIF_CFG_DEV0_RC0_STATUS__INT_STATUS_MASK                                                              0x0008L
#define BIF_CFG_DEV0_RC0_STATUS__CAP_LIST_MASK                                                                0x0010L
#define BIF_CFG_DEV0_RC0_STATUS__PCI_66_EN_MASK                                                               0x0020L
#define BIF_CFG_DEV0_RC0_STATUS__FAST_BACK_CAPABLE_MASK                                                       0x0080L
#define BIF_CFG_DEV0_RC0_STATUS__MASTER_DATA_PARITY_ERROR_MASK                                                0x0100L
#define BIF_CFG_DEV0_RC0_STATUS__DEVSEL_TIMING_MASK                                                           0x0600L
#define BIF_CFG_DEV0_RC0_STATUS__SIGNAL_TARGET_ABORT_MASK                                                     0x0800L
#define BIF_CFG_DEV0_RC0_STATUS__RECEIVED_TARGET_ABORT_MASK                                                   0x1000L
#define BIF_CFG_DEV0_RC0_STATUS__RECEIVED_MASTER_ABORT_MASK                                                   0x2000L
#define BIF_CFG_DEV0_RC0_STATUS__SIGNALED_SYSTEM_ERROR_MASK                                                   0x4000L
#define BIF_CFG_DEV0_RC0_STATUS__PARITY_ERROR_DETECTED_MASK                                                   0x8000L
//BIF_CFG_DEV0_RC0_REVISION_ID
#define BIF_CFG_DEV0_RC0_REVISION_ID__MINOR_REV_ID__SHIFT                                                     0x0
#define BIF_CFG_DEV0_RC0_REVISION_ID__MAJOR_REV_ID__SHIFT                                                     0x4
#define BIF_CFG_DEV0_RC0_REVISION_ID__MINOR_REV_ID_MASK                                                       0x0FL
#define BIF_CFG_DEV0_RC0_REVISION_ID__MAJOR_REV_ID_MASK                                                       0xF0L
//BIF_CFG_DEV0_RC0_PROG_INTERFACE
#define BIF_CFG_DEV0_RC0_PROG_INTERFACE__PROG_INTERFACE__SHIFT                                                0x0
#define BIF_CFG_DEV0_RC0_PROG_INTERFACE__PROG_INTERFACE_MASK                                                  0xFFL
//BIF_CFG_DEV0_RC0_SUB_CLASS
#define BIF_CFG_DEV0_RC0_SUB_CLASS__SUB_CLASS__SHIFT                                                          0x0
#define BIF_CFG_DEV0_RC0_SUB_CLASS__SUB_CLASS_MASK                                                            0xFFL
//BIF_CFG_DEV0_RC0_BASE_CLASS
#define BIF_CFG_DEV0_RC0_BASE_CLASS__BASE_CLASS__SHIFT                                                        0x0
#define BIF_CFG_DEV0_RC0_BASE_CLASS__BASE_CLASS_MASK                                                          0xFFL
//BIF_CFG_DEV0_RC0_CACHE_LINE
#define BIF_CFG_DEV0_RC0_CACHE_LINE__CACHE_LINE_SIZE__SHIFT                                                   0x0
#define BIF_CFG_DEV0_RC0_CACHE_LINE__CACHE_LINE_SIZE_MASK                                                     0xFFL
//BIF_CFG_DEV0_RC0_LATENCY
#define BIF_CFG_DEV0_RC0_LATENCY__LATENCY_TIMER__SHIFT                                                        0x0
#define BIF_CFG_DEV0_RC0_LATENCY__LATENCY_TIMER_MASK                                                          0xFFL
//BIF_CFG_DEV0_RC0_HEADER
#define BIF_CFG_DEV0_RC0_HEADER__HEADER_TYPE__SHIFT                                                           0x0
#define BIF_CFG_DEV0_RC0_HEADER__DEVICE_TYPE__SHIFT                                                           0x7
#define BIF_CFG_DEV0_RC0_HEADER__HEADER_TYPE_MASK                                                             0x7FL
#define BIF_CFG_DEV0_RC0_HEADER__DEVICE_TYPE_MASK                                                             0x80L
//BIF_CFG_DEV0_RC0_BIST
#define BIF_CFG_DEV0_RC0_BIST__BIST_COMP__SHIFT                                                               0x0
#define BIF_CFG_DEV0_RC0_BIST__BIST_STRT__SHIFT                                                               0x6
#define BIF_CFG_DEV0_RC0_BIST__BIST_CAP__SHIFT                                                                0x7
#define BIF_CFG_DEV0_RC0_BIST__BIST_COMP_MASK                                                                 0x0FL
#define BIF_CFG_DEV0_RC0_BIST__BIST_STRT_MASK                                                                 0x40L
#define BIF_CFG_DEV0_RC0_BIST__BIST_CAP_MASK                                                                  0x80L
//BIF_CFG_DEV0_RC0_BASE_ADDR_1
#define BIF_CFG_DEV0_RC0_BASE_ADDR_1__BASE_ADDR__SHIFT                                                        0x0
#define BIF_CFG_DEV0_RC0_BASE_ADDR_1__BASE_ADDR_MASK                                                          0xFFFFFFFFL
//BIF_CFG_DEV0_RC0_SUB_BUS_NUMBER_LATENCY
#define BIF_CFG_DEV0_RC0_SUB_BUS_NUMBER_LATENCY__PRIMARY_BUS__SHIFT                                           0x0
#define BIF_CFG_DEV0_RC0_SUB_BUS_NUMBER_LATENCY__SECONDARY_BUS__SHIFT                                         0x8
#define BIF_CFG_DEV0_RC0_SUB_BUS_NUMBER_LATENCY__SUB_BUS_NUM__SHIFT                                           0x10
#define BIF_CFG_DEV0_RC0_SUB_BUS_NUMBER_LATENCY__SECONDARY_LATENCY_TIMER__SHIFT                               0x18
#define BIF_CFG_DEV0_RC0_SUB_BUS_NUMBER_LATENCY__PRIMARY_BUS_MASK                                             0x000000FFL
#define BIF_CFG_DEV0_RC0_SUB_BUS_NUMBER_LATENCY__SECONDARY_BUS_MASK                                           0x0000FF00L
#define BIF_CFG_DEV0_RC0_SUB_BUS_NUMBER_LATENCY__SUB_BUS_NUM_MASK                                             0x00FF0000L
#define BIF_CFG_DEV0_RC0_SUB_BUS_NUMBER_LATENCY__SECONDARY_LATENCY_TIMER_MASK                                 0xFF000000L
//BIF_CFG_DEV0_RC0_IO_BASE_LIMIT
#define BIF_CFG_DEV0_RC0_IO_BASE_LIMIT__IO_BASE_TYPE__SHIFT                                                   0x0
#define BIF_CFG_DEV0_RC0_IO_BASE_LIMIT__IO_BASE__SHIFT                                                        0x4
#define BIF_CFG_DEV0_RC0_IO_BASE_LIMIT__IO_LIMIT_TYPE__SHIFT                                                  0x8
#define BIF_CFG_DEV0_RC0_IO_BASE_LIMIT__IO_LIMIT__SHIFT                                                       0xc
#define BIF_CFG_DEV0_RC0_IO_BASE_LIMIT__IO_BASE_TYPE_MASK                                                     0x000FL
#define BIF_CFG_DEV0_RC0_IO_BASE_LIMIT__IO_BASE_MASK                                                          0x00F0L
#define BIF_CFG_DEV0_RC0_IO_BASE_LIMIT__IO_LIMIT_TYPE_MASK                                                    0x0F00L
#define BIF_CFG_DEV0_RC0_IO_BASE_LIMIT__IO_LIMIT_MASK                                                         0xF000L
//BIF_CFG_DEV0_RC0_SECONDARY_STATUS
#define BIF_CFG_DEV0_RC0_SECONDARY_STATUS__CAP_LIST__SHIFT                                                    0x4
#define BIF_CFG_DEV0_RC0_SECONDARY_STATUS__PCI_66_EN__SHIFT                                                   0x5
#define BIF_CFG_DEV0_RC0_SECONDARY_STATUS__FAST_BACK_CAPABLE__SHIFT                                           0x7
#define BIF_CFG_DEV0_RC0_SECONDARY_STATUS__MASTER_DATA_PARITY_ERROR__SHIFT                                    0x8
#define BIF_CFG_DEV0_RC0_SECONDARY_STATUS__DEVSEL_TIMING__SHIFT                                               0x9
#define BIF_CFG_DEV0_RC0_SECONDARY_STATUS__SIGNAL_TARGET_ABORT__SHIFT                                         0xb
#define BIF_CFG_DEV0_RC0_SECONDARY_STATUS__RECEIVED_TARGET_ABORT__SHIFT                                       0xc
#define BIF_CFG_DEV0_RC0_SECONDARY_STATUS__RECEIVED_MASTER_ABORT__SHIFT                                       0xd
#define BIF_CFG_DEV0_RC0_SECONDARY_STATUS__RECEIVED_SYSTEM_ERROR__SHIFT                                       0xe
#define BIF_CFG_DEV0_RC0_SECONDARY_STATUS__PARITY_ERROR_DETECTED__SHIFT                                       0xf
#define BIF_CFG_DEV0_RC0_SECONDARY_STATUS__CAP_LIST_MASK                                                      0x0010L
#define BIF_CFG_DEV0_RC0_SECONDARY_STATUS__PCI_66_EN_MASK                                                     0x0020L
#define BIF_CFG_DEV0_RC0_SECONDARY_STATUS__FAST_BACK_CAPABLE_MASK                                             0x0080L
#define BIF_CFG_DEV0_RC0_SECONDARY_STATUS__MASTER_DATA_PARITY_ERROR_MASK                                      0x0100L
#define BIF_CFG_DEV0_RC0_SECONDARY_STATUS__DEVSEL_TIMING_MASK                                                 0x0600L
#define BIF_CFG_DEV0_RC0_SECONDARY_STATUS__SIGNAL_TARGET_ABORT_MASK                                           0x0800L
#define BIF_CFG_DEV0_RC0_SECONDARY_STATUS__RECEIVED_TARGET_ABORT_MASK                                         0x1000L
#define BIF_CFG_DEV0_RC0_SECONDARY_STATUS__RECEIVED_MASTER_ABORT_MASK                                         0x2000L
#define BIF_CFG_DEV0_RC0_SECONDARY_STATUS__RECEIVED_SYSTEM_ERROR_MASK                                         0x4000L
#define BIF_CFG_DEV0_RC0_SECONDARY_STATUS__PARITY_ERROR_DETECTED_MASK                                         0x8000L
//BIF_CFG_DEV0_RC0_MEM_BASE_LIMIT
#define BIF_CFG_DEV0_RC0_MEM_BASE_LIMIT__MEM_BASE_TYPE__SHIFT                                                 0x0
#define BIF_CFG_DEV0_RC0_MEM_BASE_LIMIT__MEM_BASE_31_20__SHIFT                                                0x4
#define BIF_CFG_DEV0_RC0_MEM_BASE_LIMIT__MEM_LIMIT_TYPE__SHIFT                                                0x10
#define BIF_CFG_DEV0_RC0_MEM_BASE_LIMIT__MEM_LIMIT_31_20__SHIFT                                               0x14
#define BIF_CFG_DEV0_RC0_MEM_BASE_LIMIT__MEM_BASE_TYPE_MASK                                                   0x0000000FL
#define BIF_CFG_DEV0_RC0_MEM_BASE_LIMIT__MEM_BASE_31_20_MASK                                                  0x0000FFF0L
#define BIF_CFG_DEV0_RC0_MEM_BASE_LIMIT__MEM_LIMIT_TYPE_MASK                                                  0x000F0000L
#define BIF_CFG_DEV0_RC0_MEM_BASE_LIMIT__MEM_LIMIT_31_20_MASK                                                 0xFFF00000L
//BIF_CFG_DEV0_RC0_PREF_BASE_LIMIT
#define BIF_CFG_DEV0_RC0_PREF_BASE_LIMIT__PREF_MEM_BASE_TYPE__SHIFT                                           0x0
#define BIF_CFG_DEV0_RC0_PREF_BASE_LIMIT__PREF_MEM_BASE_31_20__SHIFT                                          0x4
#define BIF_CFG_DEV0_RC0_PREF_BASE_LIMIT__PREF_MEM_LIMIT_TYPE__SHIFT                                          0x10
#define BIF_CFG_DEV0_RC0_PREF_BASE_LIMIT__PREF_MEM_LIMIT_31_20__SHIFT                                         0x14
#define BIF_CFG_DEV0_RC0_PREF_BASE_LIMIT__PREF_MEM_BASE_TYPE_MASK                                             0x0000000FL
#define BIF_CFG_DEV0_RC0_PREF_BASE_LIMIT__PREF_MEM_BASE_31_20_MASK                                            0x0000FFF0L
#define BIF_CFG_DEV0_RC0_PREF_BASE_LIMIT__PREF_MEM_LIMIT_TYPE_MASK                                            0x000F0000L
#define BIF_CFG_DEV0_RC0_PREF_BASE_LIMIT__PREF_MEM_LIMIT_31_20_MASK                                           0xFFF00000L
//BIF_CFG_DEV0_RC0_PREF_BASE_UPPER
#define BIF_CFG_DEV0_RC0_PREF_BASE_UPPER__PREF_BASE_UPPER__SHIFT                                              0x0
#define BIF_CFG_DEV0_RC0_PREF_BASE_UPPER__PREF_BASE_UPPER_MASK                                                0xFFFFFFFFL
//BIF_CFG_DEV0_RC0_PREF_LIMIT_UPPER
#define BIF_CFG_DEV0_RC0_PREF_LIMIT_UPPER__PREF_LIMIT_UPPER__SHIFT                                            0x0
#define BIF_CFG_DEV0_RC0_PREF_LIMIT_UPPER__PREF_LIMIT_UPPER_MASK                                              0xFFFFFFFFL
//BIF_CFG_DEV0_RC0_IO_BASE_LIMIT_HI
#define BIF_CFG_DEV0_RC0_IO_BASE_LIMIT_HI__IO_BASE_31_16__SHIFT                                               0x0
#define BIF_CFG_DEV0_RC0_IO_BASE_LIMIT_HI__IO_LIMIT_31_16__SHIFT                                              0x10
#define BIF_CFG_DEV0_RC0_IO_BASE_LIMIT_HI__IO_BASE_31_16_MASK                                                 0x0000FFFFL
#define BIF_CFG_DEV0_RC0_IO_BASE_LIMIT_HI__IO_LIMIT_31_16_MASK                                                0xFFFF0000L
//BIF_CFG_DEV0_RC0_CAP_PTR
#define BIF_CFG_DEV0_RC0_CAP_PTR__CAP_PTR__SHIFT                                                              0x0
#define BIF_CFG_DEV0_RC0_CAP_PTR__CAP_PTR_MASK                                                                0x000000FFL
//BIF_CFG_DEV0_RC0_INTERRUPT_LINE
#define BIF_CFG_DEV0_RC0_INTERRUPT_LINE__INTERRUPT_LINE__SHIFT                                                0x0
#define BIF_CFG_DEV0_RC0_INTERRUPT_LINE__INTERRUPT_LINE_MASK                                                  0xFFL
//BIF_CFG_DEV0_RC0_INTERRUPT_PIN
#define BIF_CFG_DEV0_RC0_INTERRUPT_PIN__INTERRUPT_PIN__SHIFT                                                  0x0
#define BIF_CFG_DEV0_RC0_INTERRUPT_PIN__INTERRUPT_PIN_MASK                                                    0xFFL
//BIF_CFG_DEV0_RC0_IRQ_BRIDGE_CNTL
#define BIF_CFG_DEV0_RC0_IRQ_BRIDGE_CNTL__PARITY_RESPONSE_EN__SHIFT                                           0x0
#define BIF_CFG_DEV0_RC0_IRQ_BRIDGE_CNTL__SERR_EN__SHIFT                                                      0x1
#define BIF_CFG_DEV0_RC0_IRQ_BRIDGE_CNTL__ISA_EN__SHIFT                                                       0x2
#define BIF_CFG_DEV0_RC0_IRQ_BRIDGE_CNTL__VGA_EN__SHIFT                                                       0x3
#define BIF_CFG_DEV0_RC0_IRQ_BRIDGE_CNTL__VGA_DEC__SHIFT                                                      0x4
#define BIF_CFG_DEV0_RC0_IRQ_BRIDGE_CNTL__MASTER_ABORT_MODE__SHIFT                                            0x5
#define BIF_CFG_DEV0_RC0_IRQ_BRIDGE_CNTL__SECONDARY_BUS_RESET__SHIFT                                          0x6
#define BIF_CFG_DEV0_RC0_IRQ_BRIDGE_CNTL__FAST_B2B_EN__SHIFT                                                  0x7
#define BIF_CFG_DEV0_RC0_IRQ_BRIDGE_CNTL__PARITY_RESPONSE_EN_MASK                                             0x0001L
#define BIF_CFG_DEV0_RC0_IRQ_BRIDGE_CNTL__SERR_EN_MASK                                                        0x0002L
#define BIF_CFG_DEV0_RC0_IRQ_BRIDGE_CNTL__ISA_EN_MASK                                                         0x0004L
#define BIF_CFG_DEV0_RC0_IRQ_BRIDGE_CNTL__VGA_EN_MASK                                                         0x0008L
#define BIF_CFG_DEV0_RC0_IRQ_BRIDGE_CNTL__VGA_DEC_MASK                                                        0x0010L
#define BIF_CFG_DEV0_RC0_IRQ_BRIDGE_CNTL__MASTER_ABORT_MODE_MASK                                              0x0020L
#define BIF_CFG_DEV0_RC0_IRQ_BRIDGE_CNTL__SECONDARY_BUS_RESET_MASK                                            0x0040L
#define BIF_CFG_DEV0_RC0_IRQ_BRIDGE_CNTL__FAST_B2B_EN_MASK                                                    0x0080L
//BIF_CFG_DEV0_RC0_EXT_BRIDGE_CNTL
#define BIF_CFG_DEV0_RC0_EXT_BRIDGE_CNTL__IO_PORT_80_EN__SHIFT                                                0x0
#define BIF_CFG_DEV0_RC0_EXT_BRIDGE_CNTL__IO_PORT_80_EN_MASK                                                  0x01L
//BIF_CFG_DEV0_RC0_PMI_CAP_LIST
#define BIF_CFG_DEV0_RC0_PMI_CAP_LIST__CAP_ID__SHIFT                                                          0x0
#define BIF_CFG_DEV0_RC0_PMI_CAP_LIST__NEXT_PTR__SHIFT                                                        0x8
#define BIF_CFG_DEV0_RC0_PMI_CAP_LIST__CAP_ID_MASK                                                            0x00FFL
#define BIF_CFG_DEV0_RC0_PMI_CAP_LIST__NEXT_PTR_MASK                                                          0xFF00L
//BIF_CFG_DEV0_RC0_PMI_CAP
#define BIF_CFG_DEV0_RC0_PMI_CAP__VERSION__SHIFT                                                              0x0
#define BIF_CFG_DEV0_RC0_PMI_CAP__PME_CLOCK__SHIFT                                                            0x3
#define BIF_CFG_DEV0_RC0_PMI_CAP__DEV_SPECIFIC_INIT__SHIFT                                                    0x5
#define BIF_CFG_DEV0_RC0_PMI_CAP__AUX_CURRENT__SHIFT                                                          0x6
#define BIF_CFG_DEV0_RC0_PMI_CAP__D1_SUPPORT__SHIFT                                                           0x9
#define BIF_CFG_DEV0_RC0_PMI_CAP__D2_SUPPORT__SHIFT                                                           0xa
#define BIF_CFG_DEV0_RC0_PMI_CAP__PME_SUPPORT__SHIFT                                                          0xb
#define BIF_CFG_DEV0_RC0_PMI_CAP__VERSION_MASK                                                                0x0007L
#define BIF_CFG_DEV0_RC0_PMI_CAP__PME_CLOCK_MASK                                                              0x0008L
#define BIF_CFG_DEV0_RC0_PMI_CAP__DEV_SPECIFIC_INIT_MASK                                                      0x0020L
#define BIF_CFG_DEV0_RC0_PMI_CAP__AUX_CURRENT_MASK                                                            0x01C0L
#define BIF_CFG_DEV0_RC0_PMI_CAP__D1_SUPPORT_MASK                                                             0x0200L
#define BIF_CFG_DEV0_RC0_PMI_CAP__D2_SUPPORT_MASK                                                             0x0400L
#define BIF_CFG_DEV0_RC0_PMI_CAP__PME_SUPPORT_MASK                                                            0xF800L
//BIF_CFG_DEV0_RC0_PMI_STATUS_CNTL
#define BIF_CFG_DEV0_RC0_PMI_STATUS_CNTL__POWER_STATE__SHIFT                                                  0x0
#define BIF_CFG_DEV0_RC0_PMI_STATUS_CNTL__NO_SOFT_RESET__SHIFT                                                0x3
#define BIF_CFG_DEV0_RC0_PMI_STATUS_CNTL__PME_EN__SHIFT                                                       0x8
#define BIF_CFG_DEV0_RC0_PMI_STATUS_CNTL__DATA_SELECT__SHIFT                                                  0x9
#define BIF_CFG_DEV0_RC0_PMI_STATUS_CNTL__DATA_SCALE__SHIFT                                                   0xd
#define BIF_CFG_DEV0_RC0_PMI_STATUS_CNTL__PME_STATUS__SHIFT                                                   0xf
#define BIF_CFG_DEV0_RC0_PMI_STATUS_CNTL__B2_B3_SUPPORT__SHIFT                                                0x16
#define BIF_CFG_DEV0_RC0_PMI_STATUS_CNTL__BUS_PWR_EN__SHIFT                                                   0x17
#define BIF_CFG_DEV0_RC0_PMI_STATUS_CNTL__PMI_DATA__SHIFT                                                     0x18
#define BIF_CFG_DEV0_RC0_PMI_STATUS_CNTL__POWER_STATE_MASK                                                    0x00000003L
#define BIF_CFG_DEV0_RC0_PMI_STATUS_CNTL__NO_SOFT_RESET_MASK                                                  0x00000008L
#define BIF_CFG_DEV0_RC0_PMI_STATUS_CNTL__PME_EN_MASK                                                         0x00000100L
#define BIF_CFG_DEV0_RC0_PMI_STATUS_CNTL__DATA_SELECT_MASK                                                    0x00001E00L
#define BIF_CFG_DEV0_RC0_PMI_STATUS_CNTL__DATA_SCALE_MASK                                                     0x00006000L
#define BIF_CFG_DEV0_RC0_PMI_STATUS_CNTL__PME_STATUS_MASK                                                     0x00008000L
#define BIF_CFG_DEV0_RC0_PMI_STATUS_CNTL__B2_B3_SUPPORT_MASK                                                  0x00400000L
#define BIF_CFG_DEV0_RC0_PMI_STATUS_CNTL__BUS_PWR_EN_MASK                                                     0x00800000L
#define BIF_CFG_DEV0_RC0_PMI_STATUS_CNTL__PMI_DATA_MASK                                                       0xFF000000L
//BIF_CFG_DEV0_RC0_PCIE_CAP_LIST
#define BIF_CFG_DEV0_RC0_PCIE_CAP_LIST__CAP_ID__SHIFT                                                         0x0
#define BIF_CFG_DEV0_RC0_PCIE_CAP_LIST__NEXT_PTR__SHIFT                                                       0x8
#define BIF_CFG_DEV0_RC0_PCIE_CAP_LIST__CAP_ID_MASK                                                           0x00FFL
#define BIF_CFG_DEV0_RC0_PCIE_CAP_LIST__NEXT_PTR_MASK                                                         0xFF00L
//BIF_CFG_DEV0_RC0_PCIE_CAP
#define BIF_CFG_DEV0_RC0_PCIE_CAP__VERSION__SHIFT                                                             0x0
#define BIF_CFG_DEV0_RC0_PCIE_CAP__DEVICE_TYPE__SHIFT                                                         0x4
#define BIF_CFG_DEV0_RC0_PCIE_CAP__SLOT_IMPLEMENTED__SHIFT                                                    0x8
#define BIF_CFG_DEV0_RC0_PCIE_CAP__INT_MESSAGE_NUM__SHIFT                                                     0x9
#define BIF_CFG_DEV0_RC0_PCIE_CAP__VERSION_MASK                                                               0x000FL
#define BIF_CFG_DEV0_RC0_PCIE_CAP__DEVICE_TYPE_MASK                                                           0x00F0L
#define BIF_CFG_DEV0_RC0_PCIE_CAP__SLOT_IMPLEMENTED_MASK                                                      0x0100L
#define BIF_CFG_DEV0_RC0_PCIE_CAP__INT_MESSAGE_NUM_MASK                                                       0x3E00L
//BIF_CFG_DEV0_RC0_DEVICE_CAP
#define BIF_CFG_DEV0_RC0_DEVICE_CAP__MAX_PAYLOAD_SUPPORT__SHIFT                                               0x0
#define BIF_CFG_DEV0_RC0_DEVICE_CAP__PHANTOM_FUNC__SHIFT                                                      0x3
#define BIF_CFG_DEV0_RC0_DEVICE_CAP__EXTENDED_TAG__SHIFT                                                      0x5
#define BIF_CFG_DEV0_RC0_DEVICE_CAP__L0S_ACCEPTABLE_LATENCY__SHIFT                                            0x6
#define BIF_CFG_DEV0_RC0_DEVICE_CAP__L1_ACCEPTABLE_LATENCY__SHIFT                                             0x9
#define BIF_CFG_DEV0_RC0_DEVICE_CAP__ROLE_BASED_ERR_REPORTING__SHIFT                                          0xf
#define BIF_CFG_DEV0_RC0_DEVICE_CAP__CAPTURED_SLOT_POWER_LIMIT__SHIFT                                         0x12
#define BIF_CFG_DEV0_RC0_DEVICE_CAP__CAPTURED_SLOT_POWER_SCALE__SHIFT                                         0x1a
#define BIF_CFG_DEV0_RC0_DEVICE_CAP__FLR_CAPABLE__SHIFT                                                       0x1c
#define BIF_CFG_DEV0_RC0_DEVICE_CAP__MAX_PAYLOAD_SUPPORT_MASK                                                 0x00000007L
#define BIF_CFG_DEV0_RC0_DEVICE_CAP__PHANTOM_FUNC_MASK                                                        0x00000018L
#define BIF_CFG_DEV0_RC0_DEVICE_CAP__EXTENDED_TAG_MASK                                                        0x00000020L
#define BIF_CFG_DEV0_RC0_DEVICE_CAP__L0S_ACCEPTABLE_LATENCY_MASK                                              0x000001C0L
#define BIF_CFG_DEV0_RC0_DEVICE_CAP__L1_ACCEPTABLE_LATENCY_MASK                                               0x00000E00L
#define BIF_CFG_DEV0_RC0_DEVICE_CAP__ROLE_BASED_ERR_REPORTING_MASK                                            0x00008000L
#define BIF_CFG_DEV0_RC0_DEVICE_CAP__CAPTURED_SLOT_POWER_LIMIT_MASK                                           0x03FC0000L
#define BIF_CFG_DEV0_RC0_DEVICE_CAP__CAPTURED_SLOT_POWER_SCALE_MASK                                           0x0C000000L
#define BIF_CFG_DEV0_RC0_DEVICE_CAP__FLR_CAPABLE_MASK                                                         0x10000000L
//BIF_CFG_DEV0_RC0_DEVICE_CNTL
#define BIF_CFG_DEV0_RC0_DEVICE_CNTL__CORR_ERR_EN__SHIFT                                                      0x0
#define BIF_CFG_DEV0_RC0_DEVICE_CNTL__NON_FATAL_ERR_EN__SHIFT                                                 0x1
#define BIF_CFG_DEV0_RC0_DEVICE_CNTL__FATAL_ERR_EN__SHIFT                                                     0x2
#define BIF_CFG_DEV0_RC0_DEVICE_CNTL__USR_REPORT_EN__SHIFT                                                    0x3
#define BIF_CFG_DEV0_RC0_DEVICE_CNTL__RELAXED_ORD_EN__SHIFT                                                   0x4
#define BIF_CFG_DEV0_RC0_DEVICE_CNTL__MAX_PAYLOAD_SIZE__SHIFT                                                 0x5
#define BIF_CFG_DEV0_RC0_DEVICE_CNTL__EXTENDED_TAG_EN__SHIFT                                                  0x8
#define BIF_CFG_DEV0_RC0_DEVICE_CNTL__PHANTOM_FUNC_EN__SHIFT                                                  0x9
#define BIF_CFG_DEV0_RC0_DEVICE_CNTL__AUX_POWER_PM_EN__SHIFT                                                  0xa
#define BIF_CFG_DEV0_RC0_DEVICE_CNTL__NO_SNOOP_EN__SHIFT                                                      0xb
#define BIF_CFG_DEV0_RC0_DEVICE_CNTL__MAX_READ_REQUEST_SIZE__SHIFT                                            0xc
#define BIF_CFG_DEV0_RC0_DEVICE_CNTL__BRIDGE_CFG_RETRY_EN__SHIFT                                              0xf
#define BIF_CFG_DEV0_RC0_DEVICE_CNTL__CORR_ERR_EN_MASK                                                        0x0001L
#define BIF_CFG_DEV0_RC0_DEVICE_CNTL__NON_FATAL_ERR_EN_MASK                                                   0x0002L
#define BIF_CFG_DEV0_RC0_DEVICE_CNTL__FATAL_ERR_EN_MASK                                                       0x0004L
#define BIF_CFG_DEV0_RC0_DEVICE_CNTL__USR_REPORT_EN_MASK                                                      0x0008L
#define BIF_CFG_DEV0_RC0_DEVICE_CNTL__RELAXED_ORD_EN_MASK                                                     0x0010L
#define BIF_CFG_DEV0_RC0_DEVICE_CNTL__MAX_PAYLOAD_SIZE_MASK                                                   0x00E0L
#define BIF_CFG_DEV0_RC0_DEVICE_CNTL__EXTENDED_TAG_EN_MASK                                                    0x0100L
#define BIF_CFG_DEV0_RC0_DEVICE_CNTL__PHANTOM_FUNC_EN_MASK                                                    0x0200L
#define BIF_CFG_DEV0_RC0_DEVICE_CNTL__AUX_POWER_PM_EN_MASK                                                    0x0400L
#define BIF_CFG_DEV0_RC0_DEVICE_CNTL__NO_SNOOP_EN_MASK                                                        0x0800L
#define BIF_CFG_DEV0_RC0_DEVICE_CNTL__MAX_READ_REQUEST_SIZE_MASK                                              0x7000L
#define BIF_CFG_DEV0_RC0_DEVICE_CNTL__BRIDGE_CFG_RETRY_EN_MASK                                                0x8000L
//BIF_CFG_DEV0_RC0_DEVICE_STATUS
#define BIF_CFG_DEV0_RC0_DEVICE_STATUS__CORR_ERR__SHIFT                                                       0x0
#define BIF_CFG_DEV0_RC0_DEVICE_STATUS__NON_FATAL_ERR__SHIFT                                                  0x1
#define BIF_CFG_DEV0_RC0_DEVICE_STATUS__FATAL_ERR__SHIFT                                                      0x2
#define BIF_CFG_DEV0_RC0_DEVICE_STATUS__USR_DETECTED__SHIFT                                                   0x3
#define BIF_CFG_DEV0_RC0_DEVICE_STATUS__AUX_PWR__SHIFT                                                        0x4
#define BIF_CFG_DEV0_RC0_DEVICE_STATUS__TRANSACTIONS_PEND__SHIFT                                              0x5
#define BIF_CFG_DEV0_RC0_DEVICE_STATUS__CORR_ERR_MASK                                                         0x0001L
#define BIF_CFG_DEV0_RC0_DEVICE_STATUS__NON_FATAL_ERR_MASK                                                    0x0002L
#define BIF_CFG_DEV0_RC0_DEVICE_STATUS__FATAL_ERR_MASK                                                        0x0004L
#define BIF_CFG_DEV0_RC0_DEVICE_STATUS__USR_DETECTED_MASK                                                     0x0008L
#define BIF_CFG_DEV0_RC0_DEVICE_STATUS__AUX_PWR_MASK                                                          0x0010L
#define BIF_CFG_DEV0_RC0_DEVICE_STATUS__TRANSACTIONS_PEND_MASK                                                0x0020L
//BIF_CFG_DEV0_RC0_LINK_CAP
#define BIF_CFG_DEV0_RC0_LINK_CAP__LINK_SPEED__SHIFT                                                          0x0
#define BIF_CFG_DEV0_RC0_LINK_CAP__LINK_WIDTH__SHIFT                                                          0x4
#define BIF_CFG_DEV0_RC0_LINK_CAP__PM_SUPPORT__SHIFT                                                          0xa
#define BIF_CFG_DEV0_RC0_LINK_CAP__L0S_EXIT_LATENCY__SHIFT                                                    0xc
#define BIF_CFG_DEV0_RC0_LINK_CAP__L1_EXIT_LATENCY__SHIFT                                                     0xf
#define BIF_CFG_DEV0_RC0_LINK_CAP__CLOCK_POWER_MANAGEMENT__SHIFT                                              0x12
#define BIF_CFG_DEV0_RC0_LINK_CAP__SURPRISE_DOWN_ERR_REPORTING__SHIFT                                         0x13
#define BIF_CFG_DEV0_RC0_LINK_CAP__DL_ACTIVE_REPORTING_CAPABLE__SHIFT                                         0x14
#define BIF_CFG_DEV0_RC0_LINK_CAP__LINK_BW_NOTIFICATION_CAP__SHIFT                                            0x15
#define BIF_CFG_DEV0_RC0_LINK_CAP__ASPM_OPTIONALITY_COMPLIANCE__SHIFT                                         0x16
#define BIF_CFG_DEV0_RC0_LINK_CAP__PORT_NUMBER__SHIFT                                                         0x18
#define BIF_CFG_DEV0_RC0_LINK_CAP__LINK_SPEED_MASK                                                            0x0000000FL
#define BIF_CFG_DEV0_RC0_LINK_CAP__LINK_WIDTH_MASK                                                            0x000003F0L
#define BIF_CFG_DEV0_RC0_LINK_CAP__PM_SUPPORT_MASK                                                            0x00000C00L
#define BIF_CFG_DEV0_RC0_LINK_CAP__L0S_EXIT_LATENCY_MASK                                                      0x00007000L
#define BIF_CFG_DEV0_RC0_LINK_CAP__L1_EXIT_LATENCY_MASK                                                       0x00038000L
#define BIF_CFG_DEV0_RC0_LINK_CAP__CLOCK_POWER_MANAGEMENT_MASK                                                0x00040000L
#define BIF_CFG_DEV0_RC0_LINK_CAP__SURPRISE_DOWN_ERR_REPORTING_MASK                                           0x00080000L
#define BIF_CFG_DEV0_RC0_LINK_CAP__DL_ACTIVE_REPORTING_CAPABLE_MASK                                           0x00100000L
#define BIF_CFG_DEV0_RC0_LINK_CAP__LINK_BW_NOTIFICATION_CAP_MASK                                              0x00200000L
#define BIF_CFG_DEV0_RC0_LINK_CAP__ASPM_OPTIONALITY_COMPLIANCE_MASK                                           0x00400000L
#define BIF_CFG_DEV0_RC0_LINK_CAP__PORT_NUMBER_MASK                                                           0xFF000000L
//BIF_CFG_DEV0_RC0_LINK_CNTL
#define BIF_CFG_DEV0_RC0_LINK_CNTL__PM_CONTROL__SHIFT                                                         0x0
#define BIF_CFG_DEV0_RC0_LINK_CNTL__READ_CPL_BOUNDARY__SHIFT                                                  0x3
#define BIF_CFG_DEV0_RC0_LINK_CNTL__LINK_DIS__SHIFT                                                           0x4
#define BIF_CFG_DEV0_RC0_LINK_CNTL__RETRAIN_LINK__SHIFT                                                       0x5
#define BIF_CFG_DEV0_RC0_LINK_CNTL__COMMON_CLOCK_CFG__SHIFT                                                   0x6
#define BIF_CFG_DEV0_RC0_LINK_CNTL__EXTENDED_SYNC__SHIFT                                                      0x7
#define BIF_CFG_DEV0_RC0_LINK_CNTL__CLOCK_POWER_MANAGEMENT_EN__SHIFT                                          0x8
#define BIF_CFG_DEV0_RC0_LINK_CNTL__HW_AUTONOMOUS_WIDTH_DISABLE__SHIFT                                        0x9
#define BIF_CFG_DEV0_RC0_LINK_CNTL__LINK_BW_MANAGEMENT_INT_EN__SHIFT                                          0xa
#define BIF_CFG_DEV0_RC0_LINK_CNTL__LINK_AUTONOMOUS_BW_INT_EN__SHIFT                                          0xb
#define BIF_CFG_DEV0_RC0_LINK_CNTL__PM_CONTROL_MASK                                                           0x0003L
#define BIF_CFG_DEV0_RC0_LINK_CNTL__READ_CPL_BOUNDARY_MASK                                                    0x0008L
#define BIF_CFG_DEV0_RC0_LINK_CNTL__LINK_DIS_MASK                                                             0x0010L
#define BIF_CFG_DEV0_RC0_LINK_CNTL__RETRAIN_LINK_MASK                                                         0x0020L
#define BIF_CFG_DEV0_RC0_LINK_CNTL__COMMON_CLOCK_CFG_MASK                                                     0x0040L
#define BIF_CFG_DEV0_RC0_LINK_CNTL__EXTENDED_SYNC_MASK                                                        0x0080L
#define BIF_CFG_DEV0_RC0_LINK_CNTL__CLOCK_POWER_MANAGEMENT_EN_MASK                                            0x0100L
#define BIF_CFG_DEV0_RC0_LINK_CNTL__HW_AUTONOMOUS_WIDTH_DISABLE_MASK                                          0x0200L
#define BIF_CFG_DEV0_RC0_LINK_CNTL__LINK_BW_MANAGEMENT_INT_EN_MASK                                            0x0400L
#define BIF_CFG_DEV0_RC0_LINK_CNTL__LINK_AUTONOMOUS_BW_INT_EN_MASK                                            0x0800L
//BIF_CFG_DEV0_RC0_LINK_STATUS
#define BIF_CFG_DEV0_RC0_LINK_STATUS__CURRENT_LINK_SPEED__SHIFT                                               0x0
#define BIF_CFG_DEV0_RC0_LINK_STATUS__NEGOTIATED_LINK_WIDTH__SHIFT                                            0x4
#define BIF_CFG_DEV0_RC0_LINK_STATUS__LINK_TRAINING__SHIFT                                                    0xb
#define BIF_CFG_DEV0_RC0_LINK_STATUS__SLOT_CLOCK_CFG__SHIFT                                                   0xc
#define BIF_CFG_DEV0_RC0_LINK_STATUS__DL_ACTIVE__SHIFT                                                        0xd
#define BIF_CFG_DEV0_RC0_LINK_STATUS__LINK_BW_MANAGEMENT_STATUS__SHIFT                                        0xe
#define BIF_CFG_DEV0_RC0_LINK_STATUS__LINK_AUTONOMOUS_BW_STATUS__SHIFT                                        0xf
#define BIF_CFG_DEV0_RC0_LINK_STATUS__CURRENT_LINK_SPEED_MASK                                                 0x000FL
#define BIF_CFG_DEV0_RC0_LINK_STATUS__NEGOTIATED_LINK_WIDTH_MASK                                              0x03F0L
#define BIF_CFG_DEV0_RC0_LINK_STATUS__LINK_TRAINING_MASK                                                      0x0800L
#define BIF_CFG_DEV0_RC0_LINK_STATUS__SLOT_CLOCK_CFG_MASK                                                     0x1000L
#define BIF_CFG_DEV0_RC0_LINK_STATUS__DL_ACTIVE_MASK                                                          0x2000L
#define BIF_CFG_DEV0_RC0_LINK_STATUS__LINK_BW_MANAGEMENT_STATUS_MASK                                          0x4000L
#define BIF_CFG_DEV0_RC0_LINK_STATUS__LINK_AUTONOMOUS_BW_STATUS_MASK                                          0x8000L
//BIF_CFG_DEV0_RC0_SLOT_CAP
#define BIF_CFG_DEV0_RC0_SLOT_CAP__ATTN_BUTTON_PRESENT__SHIFT                                                 0x0
#define BIF_CFG_DEV0_RC0_SLOT_CAP__PWR_CONTROLLER_PRESENT__SHIFT                                              0x1
#define BIF_CFG_DEV0_RC0_SLOT_CAP__MRL_SENSOR_PRESENT__SHIFT                                                  0x2
#define BIF_CFG_DEV0_RC0_SLOT_CAP__ATTN_INDICATOR_PRESENT__SHIFT                                              0x3
#define BIF_CFG_DEV0_RC0_SLOT_CAP__PWR_INDICATOR_PRESENT__SHIFT                                               0x4
#define BIF_CFG_DEV0_RC0_SLOT_CAP__HOTPLUG_SURPRISE__SHIFT                                                    0x5
#define BIF_CFG_DEV0_RC0_SLOT_CAP__HOTPLUG_CAPABLE__SHIFT                                                     0x6
#define BIF_CFG_DEV0_RC0_SLOT_CAP__SLOT_PWR_LIMIT_VALUE__SHIFT                                                0x7
#define BIF_CFG_DEV0_RC0_SLOT_CAP__SLOT_PWR_LIMIT_SCALE__SHIFT                                                0xf
#define BIF_CFG_DEV0_RC0_SLOT_CAP__ELECTROMECH_INTERLOCK_PRESENT__SHIFT                                       0x11
#define BIF_CFG_DEV0_RC0_SLOT_CAP__NO_COMMAND_COMPLETED_SUPPORTED__SHIFT                                      0x12
#define BIF_CFG_DEV0_RC0_SLOT_CAP__PHYSICAL_SLOT_NUM__SHIFT                                                   0x13
#define BIF_CFG_DEV0_RC0_SLOT_CAP__ATTN_BUTTON_PRESENT_MASK                                                   0x00000001L
#define BIF_CFG_DEV0_RC0_SLOT_CAP__PWR_CONTROLLER_PRESENT_MASK                                                0x00000002L
#define BIF_CFG_DEV0_RC0_SLOT_CAP__MRL_SENSOR_PRESENT_MASK                                                    0x00000004L
#define BIF_CFG_DEV0_RC0_SLOT_CAP__ATTN_INDICATOR_PRESENT_MASK                                                0x00000008L
#define BIF_CFG_DEV0_RC0_SLOT_CAP__PWR_INDICATOR_PRESENT_MASK                                                 0x00000010L
#define BIF_CFG_DEV0_RC0_SLOT_CAP__HOTPLUG_SURPRISE_MASK                                                      0x00000020L
#define BIF_CFG_DEV0_RC0_SLOT_CAP__HOTPLUG_CAPABLE_MASK                                                       0x00000040L
#define BIF_CFG_DEV0_RC0_SLOT_CAP__SLOT_PWR_LIMIT_VALUE_MASK                                                  0x00007F80L
#define BIF_CFG_DEV0_RC0_SLOT_CAP__SLOT_PWR_LIMIT_SCALE_MASK                                                  0x00018000L
#define BIF_CFG_DEV0_RC0_SLOT_CAP__ELECTROMECH_INTERLOCK_PRESENT_MASK                                         0x00020000L
#define BIF_CFG_DEV0_RC0_SLOT_CAP__NO_COMMAND_COMPLETED_SUPPORTED_MASK                                        0x00040000L
#define BIF_CFG_DEV0_RC0_SLOT_CAP__PHYSICAL_SLOT_NUM_MASK                                                     0xFFF80000L
//BIF_CFG_DEV0_RC0_SLOT_CNTL
#define BIF_CFG_DEV0_RC0_SLOT_CNTL__ATTN_BUTTON_PRESSED_EN__SHIFT                                             0x0
#define BIF_CFG_DEV0_RC0_SLOT_CNTL__PWR_FAULT_DETECTED_EN__SHIFT                                              0x1
#define BIF_CFG_DEV0_RC0_SLOT_CNTL__MRL_SENSOR_CHANGED_EN__SHIFT                                              0x2
#define BIF_CFG_DEV0_RC0_SLOT_CNTL__PRESENCE_DETECT_CHANGED_EN__SHIFT                                         0x3
#define BIF_CFG_DEV0_RC0_SLOT_CNTL__COMMAND_COMPLETED_INTR_EN__SHIFT                                          0x4
#define BIF_CFG_DEV0_RC0_SLOT_CNTL__HOTPLUG_INTR_EN__SHIFT                                                    0x5
#define BIF_CFG_DEV0_RC0_SLOT_CNTL__ATTN_INDICATOR_CNTL__SHIFT                                                0x6
#define BIF_CFG_DEV0_RC0_SLOT_CNTL__PWR_INDICATOR_CNTL__SHIFT                                                 0x8
#define BIF_CFG_DEV0_RC0_SLOT_CNTL__PWR_CONTROLLER_CNTL__SHIFT                                                0xa
#define BIF_CFG_DEV0_RC0_SLOT_CNTL__ELECTROMECH_INTERLOCK_CNTL__SHIFT                                         0xb
#define BIF_CFG_DEV0_RC0_SLOT_CNTL__DL_STATE_CHANGED_EN__SHIFT                                                0xc
#define BIF_CFG_DEV0_RC0_SLOT_CNTL__ATTN_BUTTON_PRESSED_EN_MASK                                               0x0001L
#define BIF_CFG_DEV0_RC0_SLOT_CNTL__PWR_FAULT_DETECTED_EN_MASK                                                0x0002L
#define BIF_CFG_DEV0_RC0_SLOT_CNTL__MRL_SENSOR_CHANGED_EN_MASK                                                0x0004L
#define BIF_CFG_DEV0_RC0_SLOT_CNTL__PRESENCE_DETECT_CHANGED_EN_MASK                                           0x0008L
#define BIF_CFG_DEV0_RC0_SLOT_CNTL__COMMAND_COMPLETED_INTR_EN_MASK                                            0x0010L
#define BIF_CFG_DEV0_RC0_SLOT_CNTL__HOTPLUG_INTR_EN_MASK                                                      0x0020L
#define BIF_CFG_DEV0_RC0_SLOT_CNTL__ATTN_INDICATOR_CNTL_MASK                                                  0x00C0L
#define BIF_CFG_DEV0_RC0_SLOT_CNTL__PWR_INDICATOR_CNTL_MASK                                                   0x0300L
#define BIF_CFG_DEV0_RC0_SLOT_CNTL__PWR_CONTROLLER_CNTL_MASK                                                  0x0400L
#define BIF_CFG_DEV0_RC0_SLOT_CNTL__ELECTROMECH_INTERLOCK_CNTL_MASK                                           0x0800L
#define BIF_CFG_DEV0_RC0_SLOT_CNTL__DL_STATE_CHANGED_EN_MASK                                                  0x1000L
//BIF_CFG_DEV0_RC0_SLOT_STATUS
#define BIF_CFG_DEV0_RC0_SLOT_STATUS__ATTN_BUTTON_PRESSED__SHIFT                                              0x0
#define BIF_CFG_DEV0_RC0_SLOT_STATUS__PWR_FAULT_DETECTED__SHIFT                                               0x1
#define BIF_CFG_DEV0_RC0_SLOT_STATUS__MRL_SENSOR_CHANGED__SHIFT                                               0x2
#define BIF_CFG_DEV0_RC0_SLOT_STATUS__PRESENCE_DETECT_CHANGED__SHIFT                                          0x3
#define BIF_CFG_DEV0_RC0_SLOT_STATUS__COMMAND_COMPLETED__SHIFT                                                0x4
#define BIF_CFG_DEV0_RC0_SLOT_STATUS__MRL_SENSOR_STATE__SHIFT                                                 0x5
#define BIF_CFG_DEV0_RC0_SLOT_STATUS__PRESENCE_DETECT_STATE__SHIFT                                            0x6
#define BIF_CFG_DEV0_RC0_SLOT_STATUS__ELECTROMECH_INTERLOCK_STATUS__SHIFT                                     0x7
#define BIF_CFG_DEV0_RC0_SLOT_STATUS__DL_STATE_CHANGED__SHIFT                                                 0x8
#define BIF_CFG_DEV0_RC0_SLOT_STATUS__ATTN_BUTTON_PRESSED_MASK                                                0x0001L
#define BIF_CFG_DEV0_RC0_SLOT_STATUS__PWR_FAULT_DETECTED_MASK                                                 0x0002L
#define BIF_CFG_DEV0_RC0_SLOT_STATUS__MRL_SENSOR_CHANGED_MASK                                                 0x0004L
#define BIF_CFG_DEV0_RC0_SLOT_STATUS__PRESENCE_DETECT_CHANGED_MASK                                            0x0008L
#define BIF_CFG_DEV0_RC0_SLOT_STATUS__COMMAND_COMPLETED_MASK                                                  0x0010L
#define BIF_CFG_DEV0_RC0_SLOT_STATUS__MRL_SENSOR_STATE_MASK                                                   0x0020L
#define BIF_CFG_DEV0_RC0_SLOT_STATUS__PRESENCE_DETECT_STATE_MASK                                              0x0040L
#define BIF_CFG_DEV0_RC0_SLOT_STATUS__ELECTROMECH_INTERLOCK_STATUS_MASK                                       0x0080L
#define BIF_CFG_DEV0_RC0_SLOT_STATUS__DL_STATE_CHANGED_MASK                                                   0x0100L
//BIF_CFG_DEV0_RC0_ROOT_CNTL
#define BIF_CFG_DEV0_RC0_ROOT_CNTL__SERR_ON_CORR_ERR_EN__SHIFT                                                0x0
#define BIF_CFG_DEV0_RC0_ROOT_CNTL__SERR_ON_NONFATAL_ERR_EN__SHIFT                                            0x1
#define BIF_CFG_DEV0_RC0_ROOT_CNTL__SERR_ON_FATAL_ERR_EN__SHIFT                                               0x2
#define BIF_CFG_DEV0_RC0_ROOT_CNTL__PM_INTERRUPT_EN__SHIFT                                                    0x3
#define BIF_CFG_DEV0_RC0_ROOT_CNTL__CRS_SOFTWARE_VISIBILITY_EN__SHIFT                                         0x4
#define BIF_CFG_DEV0_RC0_ROOT_CNTL__SERR_ON_CORR_ERR_EN_MASK                                                  0x0001L
#define BIF_CFG_DEV0_RC0_ROOT_CNTL__SERR_ON_NONFATAL_ERR_EN_MASK                                              0x0002L
#define BIF_CFG_DEV0_RC0_ROOT_CNTL__SERR_ON_FATAL_ERR_EN_MASK                                                 0x0004L
#define BIF_CFG_DEV0_RC0_ROOT_CNTL__PM_INTERRUPT_EN_MASK                                                      0x0008L
#define BIF_CFG_DEV0_RC0_ROOT_CNTL__CRS_SOFTWARE_VISIBILITY_EN_MASK                                           0x0010L
//BIF_CFG_DEV0_RC0_ROOT_CAP
#define BIF_CFG_DEV0_RC0_ROOT_CAP__CRS_SOFTWARE_VISIBILITY__SHIFT                                             0x0
#define BIF_CFG_DEV0_RC0_ROOT_CAP__CRS_SOFTWARE_VISIBILITY_MASK                                               0x0001L
//BIF_CFG_DEV0_RC0_ROOT_STATUS
#define BIF_CFG_DEV0_RC0_ROOT_STATUS__PME_REQUESTOR_ID__SHIFT                                                 0x0
#define BIF_CFG_DEV0_RC0_ROOT_STATUS__PME_STATUS__SHIFT                                                       0x10
#define BIF_CFG_DEV0_RC0_ROOT_STATUS__PME_PENDING__SHIFT                                                      0x11
#define BIF_CFG_DEV0_RC0_ROOT_STATUS__PME_REQUESTOR_ID_MASK                                                   0x0000FFFFL
#define BIF_CFG_DEV0_RC0_ROOT_STATUS__PME_STATUS_MASK                                                         0x00010000L
#define BIF_CFG_DEV0_RC0_ROOT_STATUS__PME_PENDING_MASK                                                        0x00020000L
//BIF_CFG_DEV0_RC0_DEVICE_CAP2
#define BIF_CFG_DEV0_RC0_DEVICE_CAP2__CPL_TIMEOUT_RANGE_SUPPORTED__SHIFT                                      0x0
#define BIF_CFG_DEV0_RC0_DEVICE_CAP2__CPL_TIMEOUT_DIS_SUPPORTED__SHIFT                                        0x4
#define BIF_CFG_DEV0_RC0_DEVICE_CAP2__ARI_FORWARDING_SUPPORTED__SHIFT                                         0x5
#define BIF_CFG_DEV0_RC0_DEVICE_CAP2__ATOMICOP_ROUTING_SUPPORTED__SHIFT                                       0x6
#define BIF_CFG_DEV0_RC0_DEVICE_CAP2__ATOMICOP_32CMPLT_SUPPORTED__SHIFT                                       0x7
#define BIF_CFG_DEV0_RC0_DEVICE_CAP2__ATOMICOP_64CMPLT_SUPPORTED__SHIFT                                       0x8
#define BIF_CFG_DEV0_RC0_DEVICE_CAP2__CAS128_CMPLT_SUPPORTED__SHIFT                                           0x9
#define BIF_CFG_DEV0_RC0_DEVICE_CAP2__NO_RO_ENABLED_P2P_PASSING__SHIFT                                        0xa
#define BIF_CFG_DEV0_RC0_DEVICE_CAP2__LTR_SUPPORTED__SHIFT                                                    0xb
#define BIF_CFG_DEV0_RC0_DEVICE_CAP2__TPH_CPLR_SUPPORTED__SHIFT                                               0xc
#define BIF_CFG_DEV0_RC0_DEVICE_CAP2__OBFF_SUPPORTED__SHIFT                                                   0x12
#define BIF_CFG_DEV0_RC0_DEVICE_CAP2__EXTENDED_FMT_FIELD_SUPPORTED__SHIFT                                     0x14
#define BIF_CFG_DEV0_RC0_DEVICE_CAP2__END_END_TLP_PREFIX_SUPPORTED__SHIFT                                     0x15
#define BIF_CFG_DEV0_RC0_DEVICE_CAP2__MAX_END_END_TLP_PREFIXES__SHIFT                                         0x16
#define BIF_CFG_DEV0_RC0_DEVICE_CAP2__CPL_TIMEOUT_RANGE_SUPPORTED_MASK                                        0x0000000FL
#define BIF_CFG_DEV0_RC0_DEVICE_CAP2__CPL_TIMEOUT_DIS_SUPPORTED_MASK                                          0x00000010L
#define BIF_CFG_DEV0_RC0_DEVICE_CAP2__ARI_FORWARDING_SUPPORTED_MASK                                           0x00000020L
#define BIF_CFG_DEV0_RC0_DEVICE_CAP2__ATOMICOP_ROUTING_SUPPORTED_MASK                                         0x00000040L
#define BIF_CFG_DEV0_RC0_DEVICE_CAP2__ATOMICOP_32CMPLT_SUPPORTED_MASK                                         0x00000080L
#define BIF_CFG_DEV0_RC0_DEVICE_CAP2__ATOMICOP_64CMPLT_SUPPORTED_MASK                                         0x00000100L
#define BIF_CFG_DEV0_RC0_DEVICE_CAP2__CAS128_CMPLT_SUPPORTED_MASK                                             0x00000200L
#define BIF_CFG_DEV0_RC0_DEVICE_CAP2__NO_RO_ENABLED_P2P_PASSING_MASK                                          0x00000400L
#define BIF_CFG_DEV0_RC0_DEVICE_CAP2__LTR_SUPPORTED_MASK                                                      0x00000800L
#define BIF_CFG_DEV0_RC0_DEVICE_CAP2__TPH_CPLR_SUPPORTED_MASK                                                 0x00003000L
#define BIF_CFG_DEV0_RC0_DEVICE_CAP2__OBFF_SUPPORTED_MASK                                                     0x000C0000L
#define BIF_CFG_DEV0_RC0_DEVICE_CAP2__EXTENDED_FMT_FIELD_SUPPORTED_MASK                                       0x00100000L
#define BIF_CFG_DEV0_RC0_DEVICE_CAP2__END_END_TLP_PREFIX_SUPPORTED_MASK                                       0x00200000L
#define BIF_CFG_DEV0_RC0_DEVICE_CAP2__MAX_END_END_TLP_PREFIXES_MASK                                           0x00C00000L
//BIF_CFG_DEV0_RC0_DEVICE_CNTL2
#define BIF_CFG_DEV0_RC0_DEVICE_CNTL2__CPL_TIMEOUT_VALUE__SHIFT                                               0x0
#define BIF_CFG_DEV0_RC0_DEVICE_CNTL2__CPL_TIMEOUT_DIS__SHIFT                                                 0x4
#define BIF_CFG_DEV0_RC0_DEVICE_CNTL2__ARI_FORWARDING_EN__SHIFT                                               0x5
#define BIF_CFG_DEV0_RC0_DEVICE_CNTL2__ATOMICOP_REQUEST_EN__SHIFT                                             0x6
#define BIF_CFG_DEV0_RC0_DEVICE_CNTL2__ATOMICOP_EGRESS_BLOCKING__SHIFT                                        0x7
#define BIF_CFG_DEV0_RC0_DEVICE_CNTL2__IDO_REQUEST_ENABLE__SHIFT                                              0x8
#define BIF_CFG_DEV0_RC0_DEVICE_CNTL2__IDO_COMPLETION_ENABLE__SHIFT                                           0x9
#define BIF_CFG_DEV0_RC0_DEVICE_CNTL2__LTR_EN__SHIFT                                                          0xa
#define BIF_CFG_DEV0_RC0_DEVICE_CNTL2__OBFF_EN__SHIFT                                                         0xd
#define BIF_CFG_DEV0_RC0_DEVICE_CNTL2__END_END_TLP_PREFIX_BLOCKING__SHIFT                                     0xf
#define BIF_CFG_DEV0_RC0_DEVICE_CNTL2__CPL_TIMEOUT_VALUE_MASK                                                 0x000FL
#define BIF_CFG_DEV0_RC0_DEVICE_CNTL2__CPL_TIMEOUT_DIS_MASK                                                   0x0010L
#define BIF_CFG_DEV0_RC0_DEVICE_CNTL2__ARI_FORWARDING_EN_MASK                                                 0x0020L
#define BIF_CFG_DEV0_RC0_DEVICE_CNTL2__ATOMICOP_REQUEST_EN_MASK                                               0x0040L
#define BIF_CFG_DEV0_RC0_DEVICE_CNTL2__ATOMICOP_EGRESS_BLOCKING_MASK                                          0x0080L
#define BIF_CFG_DEV0_RC0_DEVICE_CNTL2__IDO_REQUEST_ENABLE_MASK                                                0x0100L
#define BIF_CFG_DEV0_RC0_DEVICE_CNTL2__IDO_COMPLETION_ENABLE_MASK                                             0x0200L
#define BIF_CFG_DEV0_RC0_DEVICE_CNTL2__LTR_EN_MASK                                                            0x0400L
#define BIF_CFG_DEV0_RC0_DEVICE_CNTL2__OBFF_EN_MASK                                                           0x6000L
#define BIF_CFG_DEV0_RC0_DEVICE_CNTL2__END_END_TLP_PREFIX_BLOCKING_MASK                                       0x8000L
//BIF_CFG_DEV0_RC0_DEVICE_STATUS2
#define BIF_CFG_DEV0_RC0_DEVICE_STATUS2__RESERVED__SHIFT                                                      0x0
#define BIF_CFG_DEV0_RC0_DEVICE_STATUS2__RESERVED_MASK                                                        0xFFFFL
//BIF_CFG_DEV0_RC0_LINK_CAP2
#define BIF_CFG_DEV0_RC0_LINK_CAP2__SUPPORTED_LINK_SPEED__SHIFT                                               0x1
#define BIF_CFG_DEV0_RC0_LINK_CAP2__CROSSLINK_SUPPORTED__SHIFT                                                0x8
#define BIF_CFG_DEV0_RC0_LINK_CAP2__RESERVED__SHIFT                                                           0x9
#define BIF_CFG_DEV0_RC0_LINK_CAP2__SUPPORTED_LINK_SPEED_MASK                                                 0x000000FEL
#define BIF_CFG_DEV0_RC0_LINK_CAP2__CROSSLINK_SUPPORTED_MASK                                                  0x00000100L
#define BIF_CFG_DEV0_RC0_LINK_CAP2__RESERVED_MASK                                                             0xFFFFFE00L
//BIF_CFG_DEV0_RC0_LINK_CNTL2
#define BIF_CFG_DEV0_RC0_LINK_CNTL2__TARGET_LINK_SPEED__SHIFT                                                 0x0
#define BIF_CFG_DEV0_RC0_LINK_CNTL2__ENTER_COMPLIANCE__SHIFT                                                  0x4
#define BIF_CFG_DEV0_RC0_LINK_CNTL2__HW_AUTONOMOUS_SPEED_DISABLE__SHIFT                                       0x5
#define BIF_CFG_DEV0_RC0_LINK_CNTL2__SELECTABLE_DEEMPHASIS__SHIFT                                             0x6
#define BIF_CFG_DEV0_RC0_LINK_CNTL2__XMIT_MARGIN__SHIFT                                                       0x7
#define BIF_CFG_DEV0_RC0_LINK_CNTL2__ENTER_MOD_COMPLIANCE__SHIFT                                              0xa
#define BIF_CFG_DEV0_RC0_LINK_CNTL2__COMPLIANCE_SOS__SHIFT                                                    0xb
#define BIF_CFG_DEV0_RC0_LINK_CNTL2__COMPLIANCE_DEEMPHASIS__SHIFT                                             0xc
#define BIF_CFG_DEV0_RC0_LINK_CNTL2__TARGET_LINK_SPEED_MASK                                                   0x000FL
#define BIF_CFG_DEV0_RC0_LINK_CNTL2__ENTER_COMPLIANCE_MASK                                                    0x0010L
#define BIF_CFG_DEV0_RC0_LINK_CNTL2__HW_AUTONOMOUS_SPEED_DISABLE_MASK                                         0x0020L
#define BIF_CFG_DEV0_RC0_LINK_CNTL2__SELECTABLE_DEEMPHASIS_MASK                                               0x0040L
#define BIF_CFG_DEV0_RC0_LINK_CNTL2__XMIT_MARGIN_MASK                                                         0x0380L
#define BIF_CFG_DEV0_RC0_LINK_CNTL2__ENTER_MOD_COMPLIANCE_MASK                                                0x0400L
#define BIF_CFG_DEV0_RC0_LINK_CNTL2__COMPLIANCE_SOS_MASK                                                      0x0800L
#define BIF_CFG_DEV0_RC0_LINK_CNTL2__COMPLIANCE_DEEMPHASIS_MASK                                               0xF000L
//BIF_CFG_DEV0_RC0_LINK_STATUS2
#define BIF_CFG_DEV0_RC0_LINK_STATUS2__CUR_DEEMPHASIS_LEVEL__SHIFT                                            0x0
#define BIF_CFG_DEV0_RC0_LINK_STATUS2__EQUALIZATION_COMPLETE__SHIFT                                           0x1
#define BIF_CFG_DEV0_RC0_LINK_STATUS2__EQUALIZATION_PHASE1_SUCCESS__SHIFT                                     0x2
#define BIF_CFG_DEV0_RC0_LINK_STATUS2__EQUALIZATION_PHASE2_SUCCESS__SHIFT                                     0x3
#define BIF_CFG_DEV0_RC0_LINK_STATUS2__EQUALIZATION_PHASE3_SUCCESS__SHIFT                                     0x4
#define BIF_CFG_DEV0_RC0_LINK_STATUS2__LINK_EQUALIZATION_REQUEST__SHIFT                                       0x5
#define BIF_CFG_DEV0_RC0_LINK_STATUS2__CUR_DEEMPHASIS_LEVEL_MASK                                              0x0001L
#define BIF_CFG_DEV0_RC0_LINK_STATUS2__EQUALIZATION_COMPLETE_MASK                                             0x0002L
#define BIF_CFG_DEV0_RC0_LINK_STATUS2__EQUALIZATION_PHASE1_SUCCESS_MASK                                       0x0004L
#define BIF_CFG_DEV0_RC0_LINK_STATUS2__EQUALIZATION_PHASE2_SUCCESS_MASK                                       0x0008L
#define BIF_CFG_DEV0_RC0_LINK_STATUS2__EQUALIZATION_PHASE3_SUCCESS_MASK                                       0x0010L
#define BIF_CFG_DEV0_RC0_LINK_STATUS2__LINK_EQUALIZATION_REQUEST_MASK                                         0x0020L
//BIF_CFG_DEV0_RC0_SLOT_CAP2
#define BIF_CFG_DEV0_RC0_SLOT_CAP2__RESERVED__SHIFT                                                           0x0
#define BIF_CFG_DEV0_RC0_SLOT_CAP2__RESERVED_MASK                                                             0xFFFFFFFFL
//BIF_CFG_DEV0_RC0_SLOT_CNTL2
#define BIF_CFG_DEV0_RC0_SLOT_CNTL2__RESERVED__SHIFT                                                          0x0
#define BIF_CFG_DEV0_RC0_SLOT_CNTL2__RESERVED_MASK                                                            0xFFFFL
//BIF_CFG_DEV0_RC0_SLOT_STATUS2
#define BIF_CFG_DEV0_RC0_SLOT_STATUS2__RESERVED__SHIFT                                                        0x0
#define BIF_CFG_DEV0_RC0_SLOT_STATUS2__RESERVED_MASK                                                          0xFFFFL
//BIF_CFG_DEV0_RC0_MSI_CAP_LIST
#define BIF_CFG_DEV0_RC0_MSI_CAP_LIST__CAP_ID__SHIFT                                                          0x0
#define BIF_CFG_DEV0_RC0_MSI_CAP_LIST__NEXT_PTR__SHIFT                                                        0x8
#define BIF_CFG_DEV0_RC0_MSI_CAP_LIST__CAP_ID_MASK                                                            0x00FFL
#define BIF_CFG_DEV0_RC0_MSI_CAP_LIST__NEXT_PTR_MASK                                                          0xFF00L
//BIF_CFG_DEV0_RC0_MSI_MSG_CNTL
#define BIF_CFG_DEV0_RC0_MSI_MSG_CNTL__MSI_EN__SHIFT                                                          0x0
#define BIF_CFG_DEV0_RC0_MSI_MSG_CNTL__MSI_MULTI_CAP__SHIFT                                                   0x1
#define BIF_CFG_DEV0_RC0_MSI_MSG_CNTL__MSI_MULTI_EN__SHIFT                                                    0x4
#define BIF_CFG_DEV0_RC0_MSI_MSG_CNTL__MSI_64BIT__SHIFT                                                       0x7
#define BIF_CFG_DEV0_RC0_MSI_MSG_CNTL__MSI_PERVECTOR_MASKING_CAP__SHIFT                                       0x8
#define BIF_CFG_DEV0_RC0_MSI_MSG_CNTL__MSI_EN_MASK                                                            0x0001L
#define BIF_CFG_DEV0_RC0_MSI_MSG_CNTL__MSI_MULTI_CAP_MASK                                                     0x000EL
#define BIF_CFG_DEV0_RC0_MSI_MSG_CNTL__MSI_MULTI_EN_MASK                                                      0x0070L
#define BIF_CFG_DEV0_RC0_MSI_MSG_CNTL__MSI_64BIT_MASK                                                         0x0080L
#define BIF_CFG_DEV0_RC0_MSI_MSG_CNTL__MSI_PERVECTOR_MASKING_CAP_MASK                                         0x0100L
//BIF_CFG_DEV0_RC0_MSI_MSG_ADDR_LO
#define BIF_CFG_DEV0_RC0_MSI_MSG_ADDR_LO__MSI_MSG_ADDR_LO__SHIFT                                              0x2
#define BIF_CFG_DEV0_RC0_MSI_MSG_ADDR_LO__MSI_MSG_ADDR_LO_MASK                                                0xFFFFFFFCL
//BIF_CFG_DEV0_RC0_MSI_MSG_ADDR_HI
#define BIF_CFG_DEV0_RC0_MSI_MSG_ADDR_HI__MSI_MSG_ADDR_HI__SHIFT                                              0x0
#define BIF_CFG_DEV0_RC0_MSI_MSG_ADDR_HI__MSI_MSG_ADDR_HI_MASK                                                0xFFFFFFFFL
//BIF_CFG_DEV0_RC0_MSI_MSG_DATA
#define BIF_CFG_DEV0_RC0_MSI_MSG_DATA__MSI_DATA__SHIFT                                                        0x0
#define BIF_CFG_DEV0_RC0_MSI_MSG_DATA__MSI_DATA_MASK                                                          0x0000FFFFL
//BIF_CFG_DEV0_RC0_MSI_MSG_DATA_64
#define BIF_CFG_DEV0_RC0_MSI_MSG_DATA_64__MSI_DATA_64__SHIFT                                                  0x0
#define BIF_CFG_DEV0_RC0_MSI_MSG_DATA_64__MSI_DATA_64_MASK                                                    0x0000FFFFL
//BIF_CFG_DEV0_RC0_SSID_CAP_LIST
#define BIF_CFG_DEV0_RC0_SSID_CAP_LIST__CAP_ID__SHIFT                                                         0x0
#define BIF_CFG_DEV0_RC0_SSID_CAP_LIST__NEXT_PTR__SHIFT                                                       0x8
#define BIF_CFG_DEV0_RC0_SSID_CAP_LIST__CAP_ID_MASK                                                           0x00FFL
#define BIF_CFG_DEV0_RC0_SSID_CAP_LIST__NEXT_PTR_MASK                                                         0xFF00L
//BIF_CFG_DEV0_RC0_SSID_CAP
#define BIF_CFG_DEV0_RC0_SSID_CAP__SUBSYSTEM_VENDOR_ID__SHIFT                                                 0x0
#define BIF_CFG_DEV0_RC0_SSID_CAP__SUBSYSTEM_ID__SHIFT                                                        0x10
#define BIF_CFG_DEV0_RC0_SSID_CAP__SUBSYSTEM_VENDOR_ID_MASK                                                   0x0000FFFFL
#define BIF_CFG_DEV0_RC0_SSID_CAP__SUBSYSTEM_ID_MASK                                                          0xFFFF0000L
//BIF_CFG_DEV0_RC0_MSI_MAP_CAP_LIST
#define BIF_CFG_DEV0_RC0_MSI_MAP_CAP_LIST__CAP_ID__SHIFT                                                      0x0
#define BIF_CFG_DEV0_RC0_MSI_MAP_CAP_LIST__NEXT_PTR__SHIFT                                                    0x8
#define BIF_CFG_DEV0_RC0_MSI_MAP_CAP_LIST__CAP_ID_MASK                                                        0x00FFL
#define BIF_CFG_DEV0_RC0_MSI_MAP_CAP_LIST__NEXT_PTR_MASK                                                      0xFF00L
//BIF_CFG_DEV0_RC0_MSI_MAP_CAP
#define BIF_CFG_DEV0_RC0_MSI_MAP_CAP__EN__SHIFT                                                               0x0
#define BIF_CFG_DEV0_RC0_MSI_MAP_CAP__FIXD__SHIFT                                                             0x1
#define BIF_CFG_DEV0_RC0_MSI_MAP_CAP__CAP_TYPE__SHIFT                                                         0xb
#define BIF_CFG_DEV0_RC0_MSI_MAP_CAP__EN_MASK                                                                 0x0001L
#define BIF_CFG_DEV0_RC0_MSI_MAP_CAP__FIXD_MASK                                                               0x0002L
#define BIF_CFG_DEV0_RC0_MSI_MAP_CAP__CAP_TYPE_MASK                                                           0xF800L
//BIF_CFG_DEV0_RC0_MSI_MAP_ADDR_LO
#define BIF_CFG_DEV0_RC0_MSI_MAP_ADDR_LO__MSI_MAP_ADDR_LO__SHIFT                                              0x14
#define BIF_CFG_DEV0_RC0_MSI_MAP_ADDR_LO__MSI_MAP_ADDR_LO_MASK                                                0xFFF00000L
//BIF_CFG_DEV0_RC0_MSI_MAP_ADDR_HI
#define BIF_CFG_DEV0_RC0_MSI_MAP_ADDR_HI__MSI_MAP_ADDR_HI__SHIFT                                              0x0
#define BIF_CFG_DEV0_RC0_MSI_MAP_ADDR_HI__MSI_MAP_ADDR_HI_MASK                                                0xFFFFFFFFL
//BIF_CFG_DEV0_RC0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST
#define BIF_CFG_DEV0_RC0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_ID__SHIFT                                     0x0
#define BIF_CFG_DEV0_RC0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_VER__SHIFT                                    0x10
#define BIF_CFG_DEV0_RC0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__NEXT_PTR__SHIFT                                   0x14
#define BIF_CFG_DEV0_RC0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_ID_MASK                                       0x0000FFFFL
#define BIF_CFG_DEV0_RC0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_VER_MASK                                      0x000F0000L
#define BIF_CFG_DEV0_RC0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__NEXT_PTR_MASK                                     0xFFF00000L
//BIF_CFG_DEV0_RC0_PCIE_VENDOR_SPECIFIC_HDR
#define BIF_CFG_DEV0_RC0_PCIE_VENDOR_SPECIFIC_HDR__VSEC_ID__SHIFT                                             0x0
#define BIF_CFG_DEV0_RC0_PCIE_VENDOR_SPECIFIC_HDR__VSEC_REV__SHIFT                                            0x10
#define BIF_CFG_DEV0_RC0_PCIE_VENDOR_SPECIFIC_HDR__VSEC_LENGTH__SHIFT                                         0x14
#define BIF_CFG_DEV0_RC0_PCIE_VENDOR_SPECIFIC_HDR__VSEC_ID_MASK                                               0x0000FFFFL
#define BIF_CFG_DEV0_RC0_PCIE_VENDOR_SPECIFIC_HDR__VSEC_REV_MASK                                              0x000F0000L
#define BIF_CFG_DEV0_RC0_PCIE_VENDOR_SPECIFIC_HDR__VSEC_LENGTH_MASK                                           0xFFF00000L
//BIF_CFG_DEV0_RC0_PCIE_VENDOR_SPECIFIC1
#define BIF_CFG_DEV0_RC0_PCIE_VENDOR_SPECIFIC1__SCRATCH__SHIFT                                                0x0
#define BIF_CFG_DEV0_RC0_PCIE_VENDOR_SPECIFIC1__SCRATCH_MASK                                                  0xFFFFFFFFL
//BIF_CFG_DEV0_RC0_PCIE_VENDOR_SPECIFIC2
#define BIF_CFG_DEV0_RC0_PCIE_VENDOR_SPECIFIC2__SCRATCH__SHIFT                                                0x0
#define BIF_CFG_DEV0_RC0_PCIE_VENDOR_SPECIFIC2__SCRATCH_MASK                                                  0xFFFFFFFFL
//BIF_CFG_DEV0_RC0_PCIE_VC_ENH_CAP_LIST
#define BIF_CFG_DEV0_RC0_PCIE_VC_ENH_CAP_LIST__CAP_ID__SHIFT                                                  0x0
#define BIF_CFG_DEV0_RC0_PCIE_VC_ENH_CAP_LIST__CAP_VER__SHIFT                                                 0x10
#define BIF_CFG_DEV0_RC0_PCIE_VC_ENH_CAP_LIST__NEXT_PTR__SHIFT                                                0x14
#define BIF_CFG_DEV0_RC0_PCIE_VC_ENH_CAP_LIST__CAP_ID_MASK                                                    0x0000FFFFL
#define BIF_CFG_DEV0_RC0_PCIE_VC_ENH_CAP_LIST__CAP_VER_MASK                                                   0x000F0000L
#define BIF_CFG_DEV0_RC0_PCIE_VC_ENH_CAP_LIST__NEXT_PTR_MASK                                                  0xFFF00000L
//BIF_CFG_DEV0_RC0_PCIE_PORT_VC_CAP_REG1
#define BIF_CFG_DEV0_RC0_PCIE_PORT_VC_CAP_REG1__EXT_VC_COUNT__SHIFT                                           0x0
#define BIF_CFG_DEV0_RC0_PCIE_PORT_VC_CAP_REG1__LOW_PRIORITY_EXT_VC_COUNT__SHIFT                              0x4
#define BIF_CFG_DEV0_RC0_PCIE_PORT_VC_CAP_REG1__REF_CLK__SHIFT                                                0x8
#define BIF_CFG_DEV0_RC0_PCIE_PORT_VC_CAP_REG1__PORT_ARB_TABLE_ENTRY_SIZE__SHIFT                              0xa
#define BIF_CFG_DEV0_RC0_PCIE_PORT_VC_CAP_REG1__EXT_VC_COUNT_MASK                                             0x00000007L
#define BIF_CFG_DEV0_RC0_PCIE_PORT_VC_CAP_REG1__LOW_PRIORITY_EXT_VC_COUNT_MASK                                0x00000070L
#define BIF_CFG_DEV0_RC0_PCIE_PORT_VC_CAP_REG1__REF_CLK_MASK                                                  0x00000300L
#define BIF_CFG_DEV0_RC0_PCIE_PORT_VC_CAP_REG1__PORT_ARB_TABLE_ENTRY_SIZE_MASK                                0x00000C00L
//BIF_CFG_DEV0_RC0_PCIE_PORT_VC_CAP_REG2
#define BIF_CFG_DEV0_RC0_PCIE_PORT_VC_CAP_REG2__VC_ARB_CAP__SHIFT                                             0x0
#define BIF_CFG_DEV0_RC0_PCIE_PORT_VC_CAP_REG2__VC_ARB_TABLE_OFFSET__SHIFT                                    0x18
#define BIF_CFG_DEV0_RC0_PCIE_PORT_VC_CAP_REG2__VC_ARB_CAP_MASK                                               0x000000FFL
#define BIF_CFG_DEV0_RC0_PCIE_PORT_VC_CAP_REG2__VC_ARB_TABLE_OFFSET_MASK                                      0xFF000000L
//BIF_CFG_DEV0_RC0_PCIE_PORT_VC_CNTL
#define BIF_CFG_DEV0_RC0_PCIE_PORT_VC_CNTL__LOAD_VC_ARB_TABLE__SHIFT                                          0x0
#define BIF_CFG_DEV0_RC0_PCIE_PORT_VC_CNTL__VC_ARB_SELECT__SHIFT                                              0x1
#define BIF_CFG_DEV0_RC0_PCIE_PORT_VC_CNTL__LOAD_VC_ARB_TABLE_MASK                                            0x0001L
#define BIF_CFG_DEV0_RC0_PCIE_PORT_VC_CNTL__VC_ARB_SELECT_MASK                                                0x000EL
//BIF_CFG_DEV0_RC0_PCIE_PORT_VC_STATUS
#define BIF_CFG_DEV0_RC0_PCIE_PORT_VC_STATUS__VC_ARB_TABLE_STATUS__SHIFT                                      0x0
#define BIF_CFG_DEV0_RC0_PCIE_PORT_VC_STATUS__VC_ARB_TABLE_STATUS_MASK                                        0x0001L
//BIF_CFG_DEV0_RC0_PCIE_VC0_RESOURCE_CAP
#define BIF_CFG_DEV0_RC0_PCIE_VC0_RESOURCE_CAP__PORT_ARB_CAP__SHIFT                                           0x0
#define BIF_CFG_DEV0_RC0_PCIE_VC0_RESOURCE_CAP__REJECT_SNOOP_TRANS__SHIFT                                     0xf
#define BIF_CFG_DEV0_RC0_PCIE_VC0_RESOURCE_CAP__MAX_TIME_SLOTS__SHIFT                                         0x10
#define BIF_CFG_DEV0_RC0_PCIE_VC0_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET__SHIFT                                  0x18
#define BIF_CFG_DEV0_RC0_PCIE_VC0_RESOURCE_CAP__PORT_ARB_CAP_MASK                                             0x000000FFL
#define BIF_CFG_DEV0_RC0_PCIE_VC0_RESOURCE_CAP__REJECT_SNOOP_TRANS_MASK                                       0x00008000L
#define BIF_CFG_DEV0_RC0_PCIE_VC0_RESOURCE_CAP__MAX_TIME_SLOTS_MASK                                           0x003F0000L
#define BIF_CFG_DEV0_RC0_PCIE_VC0_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET_MASK                                    0xFF000000L
//BIF_CFG_DEV0_RC0_PCIE_VC0_RESOURCE_CNTL
#define BIF_CFG_DEV0_RC0_PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC0__SHIFT                                         0x0
#define BIF_CFG_DEV0_RC0_PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC1_7__SHIFT                                       0x1
#define BIF_CFG_DEV0_RC0_PCIE_VC0_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE__SHIFT                                   0x10
#define BIF_CFG_DEV0_RC0_PCIE_VC0_RESOURCE_CNTL__PORT_ARB_SELECT__SHIFT                                       0x11
#define BIF_CFG_DEV0_RC0_PCIE_VC0_RESOURCE_CNTL__VC_ID__SHIFT                                                 0x18
#define BIF_CFG_DEV0_RC0_PCIE_VC0_RESOURCE_CNTL__VC_ENABLE__SHIFT                                             0x1f
#define BIF_CFG_DEV0_RC0_PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC0_MASK                                           0x00000001L
#define BIF_CFG_DEV0_RC0_PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC1_7_MASK                                         0x000000FEL
#define BIF_CFG_DEV0_RC0_PCIE_VC0_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE_MASK                                     0x00010000L
#define BIF_CFG_DEV0_RC0_PCIE_VC0_RESOURCE_CNTL__PORT_ARB_SELECT_MASK                                         0x000E0000L
#define BIF_CFG_DEV0_RC0_PCIE_VC0_RESOURCE_CNTL__VC_ID_MASK                                                   0x07000000L
#define BIF_CFG_DEV0_RC0_PCIE_VC0_RESOURCE_CNTL__VC_ENABLE_MASK                                               0x80000000L
//BIF_CFG_DEV0_RC0_PCIE_VC0_RESOURCE_STATUS
#define BIF_CFG_DEV0_RC0_PCIE_VC0_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS__SHIFT                               0x0
#define BIF_CFG_DEV0_RC0_PCIE_VC0_RESOURCE_STATUS__VC_NEGOTIATION_PENDING__SHIFT                              0x1
#define BIF_CFG_DEV0_RC0_PCIE_VC0_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS_MASK                                 0x0001L
#define BIF_CFG_DEV0_RC0_PCIE_VC0_RESOURCE_STATUS__VC_NEGOTIATION_PENDING_MASK                                0x0002L
//BIF_CFG_DEV0_RC0_PCIE_VC1_RESOURCE_CAP
#define BIF_CFG_DEV0_RC0_PCIE_VC1_RESOURCE_CAP__PORT_ARB_CAP__SHIFT                                           0x0
#define BIF_CFG_DEV0_RC0_PCIE_VC1_RESOURCE_CAP__REJECT_SNOOP_TRANS__SHIFT                                     0xf
#define BIF_CFG_DEV0_RC0_PCIE_VC1_RESOURCE_CAP__MAX_TIME_SLOTS__SHIFT                                         0x10
#define BIF_CFG_DEV0_RC0_PCIE_VC1_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET__SHIFT                                  0x18
#define BIF_CFG_DEV0_RC0_PCIE_VC1_RESOURCE_CAP__PORT_ARB_CAP_MASK                                             0x000000FFL
#define BIF_CFG_DEV0_RC0_PCIE_VC1_RESOURCE_CAP__REJECT_SNOOP_TRANS_MASK                                       0x00008000L
#define BIF_CFG_DEV0_RC0_PCIE_VC1_RESOURCE_CAP__MAX_TIME_SLOTS_MASK                                           0x003F0000L
#define BIF_CFG_DEV0_RC0_PCIE_VC1_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET_MASK                                    0xFF000000L
//BIF_CFG_DEV0_RC0_PCIE_VC1_RESOURCE_CNTL
#define BIF_CFG_DEV0_RC0_PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC0__SHIFT                                         0x0
#define BIF_CFG_DEV0_RC0_PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC1_7__SHIFT                                       0x1
#define BIF_CFG_DEV0_RC0_PCIE_VC1_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE__SHIFT                                   0x10
#define BIF_CFG_DEV0_RC0_PCIE_VC1_RESOURCE_CNTL__PORT_ARB_SELECT__SHIFT                                       0x11
#define BIF_CFG_DEV0_RC0_PCIE_VC1_RESOURCE_CNTL__VC_ID__SHIFT                                                 0x18
#define BIF_CFG_DEV0_RC0_PCIE_VC1_RESOURCE_CNTL__VC_ENABLE__SHIFT                                             0x1f
#define BIF_CFG_DEV0_RC0_PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC0_MASK                                           0x00000001L
#define BIF_CFG_DEV0_RC0_PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC1_7_MASK                                         0x000000FEL
#define BIF_CFG_DEV0_RC0_PCIE_VC1_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE_MASK                                     0x00010000L
#define BIF_CFG_DEV0_RC0_PCIE_VC1_RESOURCE_CNTL__PORT_ARB_SELECT_MASK                                         0x000E0000L
#define BIF_CFG_DEV0_RC0_PCIE_VC1_RESOURCE_CNTL__VC_ID_MASK                                                   0x07000000L
#define BIF_CFG_DEV0_RC0_PCIE_VC1_RESOURCE_CNTL__VC_ENABLE_MASK                                               0x80000000L
//BIF_CFG_DEV0_RC0_PCIE_VC1_RESOURCE_STATUS
#define BIF_CFG_DEV0_RC0_PCIE_VC1_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS__SHIFT                               0x0
#define BIF_CFG_DEV0_RC0_PCIE_VC1_RESOURCE_STATUS__VC_NEGOTIATION_PENDING__SHIFT                              0x1
#define BIF_CFG_DEV0_RC0_PCIE_VC1_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS_MASK                                 0x0001L
#define BIF_CFG_DEV0_RC0_PCIE_VC1_RESOURCE_STATUS__VC_NEGOTIATION_PENDING_MASK                                0x0002L
//BIF_CFG_DEV0_RC0_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST
#define BIF_CFG_DEV0_RC0_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_ID__SHIFT                                      0x0
#define BIF_CFG_DEV0_RC0_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_VER__SHIFT                                     0x10
#define BIF_CFG_DEV0_RC0_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__NEXT_PTR__SHIFT                                    0x14
#define BIF_CFG_DEV0_RC0_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_ID_MASK                                        0x0000FFFFL
#define BIF_CFG_DEV0_RC0_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_VER_MASK                                       0x000F0000L
#define BIF_CFG_DEV0_RC0_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__NEXT_PTR_MASK                                      0xFFF00000L
//BIF_CFG_DEV0_RC0_PCIE_DEV_SERIAL_NUM_DW1
#define BIF_CFG_DEV0_RC0_PCIE_DEV_SERIAL_NUM_DW1__SERIAL_NUMBER_LO__SHIFT                                     0x0
#define BIF_CFG_DEV0_RC0_PCIE_DEV_SERIAL_NUM_DW1__SERIAL_NUMBER_LO_MASK                                       0xFFFFFFFFL
//BIF_CFG_DEV0_RC0_PCIE_DEV_SERIAL_NUM_DW2
#define BIF_CFG_DEV0_RC0_PCIE_DEV_SERIAL_NUM_DW2__SERIAL_NUMBER_HI__SHIFT                                     0x0
#define BIF_CFG_DEV0_RC0_PCIE_DEV_SERIAL_NUM_DW2__SERIAL_NUMBER_HI_MASK                                       0xFFFFFFFFL
//BIF_CFG_DEV0_RC0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST
#define BIF_CFG_DEV0_RC0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_ID__SHIFT                                         0x0
#define BIF_CFG_DEV0_RC0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_VER__SHIFT                                        0x10
#define BIF_CFG_DEV0_RC0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__NEXT_PTR__SHIFT                                       0x14
#define BIF_CFG_DEV0_RC0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_ID_MASK                                           0x0000FFFFL
#define BIF_CFG_DEV0_RC0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_VER_MASK                                          0x000F0000L
#define BIF_CFG_DEV0_RC0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__NEXT_PTR_MASK                                         0xFFF00000L
//BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_STATUS
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_STATUS__DLP_ERR_STATUS__SHIFT                                        0x4
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_STATUS__SURPDN_ERR_STATUS__SHIFT                                     0x5
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_STATUS__PSN_ERR_STATUS__SHIFT                                        0xc
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_STATUS__FC_ERR_STATUS__SHIFT                                         0xd
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_STATUS__CPL_TIMEOUT_STATUS__SHIFT                                    0xe
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_STATUS__CPL_ABORT_ERR_STATUS__SHIFT                                  0xf
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_STATUS__UNEXP_CPL_STATUS__SHIFT                                      0x10
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_STATUS__RCV_OVFL_STATUS__SHIFT                                       0x11
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_STATUS__MAL_TLP_STATUS__SHIFT                                        0x12
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_STATUS__ECRC_ERR_STATUS__SHIFT                                       0x13
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_STATUS__UNSUPP_REQ_ERR_STATUS__SHIFT                                 0x14
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_STATUS__ACS_VIOLATION_STATUS__SHIFT                                  0x15
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_STATUS__UNCORR_INT_ERR_STATUS__SHIFT                                 0x16
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_STATUS__MC_BLOCKED_TLP_STATUS__SHIFT                                 0x17
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_STATUS__ATOMICOP_EGRESS_BLOCKED_STATUS__SHIFT                        0x18
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_STATUS__TLP_PREFIX_BLOCKED_ERR_STATUS__SHIFT                         0x19
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_STATUS__DLP_ERR_STATUS_MASK                                          0x00000010L
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_STATUS__SURPDN_ERR_STATUS_MASK                                       0x00000020L
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_STATUS__PSN_ERR_STATUS_MASK                                          0x00001000L
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_STATUS__FC_ERR_STATUS_MASK                                           0x00002000L
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_STATUS__CPL_TIMEOUT_STATUS_MASK                                      0x00004000L
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_STATUS__CPL_ABORT_ERR_STATUS_MASK                                    0x00008000L
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_STATUS__UNEXP_CPL_STATUS_MASK                                        0x00010000L
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_STATUS__RCV_OVFL_STATUS_MASK                                         0x00020000L
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_STATUS__MAL_TLP_STATUS_MASK                                          0x00040000L
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_STATUS__ECRC_ERR_STATUS_MASK                                         0x00080000L
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_STATUS__UNSUPP_REQ_ERR_STATUS_MASK                                   0x00100000L
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_STATUS__ACS_VIOLATION_STATUS_MASK                                    0x00200000L
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_STATUS__UNCORR_INT_ERR_STATUS_MASK                                   0x00400000L
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_STATUS__MC_BLOCKED_TLP_STATUS_MASK                                   0x00800000L
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_STATUS__ATOMICOP_EGRESS_BLOCKED_STATUS_MASK                          0x01000000L
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_STATUS__TLP_PREFIX_BLOCKED_ERR_STATUS_MASK                           0x02000000L
//BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_MASK
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_MASK__DLP_ERR_MASK__SHIFT                                            0x4
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_MASK__SURPDN_ERR_MASK__SHIFT                                         0x5
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_MASK__PSN_ERR_MASK__SHIFT                                            0xc
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_MASK__FC_ERR_MASK__SHIFT                                             0xd
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_MASK__CPL_TIMEOUT_MASK__SHIFT                                        0xe
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_MASK__CPL_ABORT_ERR_MASK__SHIFT                                      0xf
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_MASK__UNEXP_CPL_MASK__SHIFT                                          0x10
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_MASK__RCV_OVFL_MASK__SHIFT                                           0x11
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_MASK__MAL_TLP_MASK__SHIFT                                            0x12
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_MASK__ECRC_ERR_MASK__SHIFT                                           0x13
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_MASK__UNSUPP_REQ_ERR_MASK__SHIFT                                     0x14
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_MASK__ACS_VIOLATION_MASK__SHIFT                                      0x15
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_MASK__UNCORR_INT_ERR_MASK__SHIFT                                     0x16
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_MASK__MC_BLOCKED_TLP_MASK__SHIFT                                     0x17
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_MASK__ATOMICOP_EGRESS_BLOCKED_MASK__SHIFT                            0x18
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_MASK__TLP_PREFIX_BLOCKED_ERR_MASK__SHIFT                             0x19
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_MASK__DLP_ERR_MASK_MASK                                              0x00000010L
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_MASK__SURPDN_ERR_MASK_MASK                                           0x00000020L
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_MASK__PSN_ERR_MASK_MASK                                              0x00001000L
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_MASK__FC_ERR_MASK_MASK                                               0x00002000L
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_MASK__CPL_TIMEOUT_MASK_MASK                                          0x00004000L
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_MASK__CPL_ABORT_ERR_MASK_MASK                                        0x00008000L
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_MASK__UNEXP_CPL_MASK_MASK                                            0x00010000L
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_MASK__RCV_OVFL_MASK_MASK                                             0x00020000L
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_MASK__MAL_TLP_MASK_MASK                                              0x00040000L
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_MASK__ECRC_ERR_MASK_MASK                                             0x00080000L
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_MASK__UNSUPP_REQ_ERR_MASK_MASK                                       0x00100000L
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_MASK__ACS_VIOLATION_MASK_MASK                                        0x00200000L
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_MASK__UNCORR_INT_ERR_MASK_MASK                                       0x00400000L
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_MASK__MC_BLOCKED_TLP_MASK_MASK                                       0x00800000L
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_MASK__ATOMICOP_EGRESS_BLOCKED_MASK_MASK                              0x01000000L
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_MASK__TLP_PREFIX_BLOCKED_ERR_MASK_MASK                               0x02000000L
//BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_SEVERITY
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_SEVERITY__DLP_ERR_SEVERITY__SHIFT                                    0x4
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_SEVERITY__SURPDN_ERR_SEVERITY__SHIFT                                 0x5
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_SEVERITY__PSN_ERR_SEVERITY__SHIFT                                    0xc
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_SEVERITY__FC_ERR_SEVERITY__SHIFT                                     0xd
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_SEVERITY__CPL_TIMEOUT_SEVERITY__SHIFT                                0xe
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_SEVERITY__CPL_ABORT_ERR_SEVERITY__SHIFT                              0xf
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_SEVERITY__UNEXP_CPL_SEVERITY__SHIFT                                  0x10
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_SEVERITY__RCV_OVFL_SEVERITY__SHIFT                                   0x11
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_SEVERITY__MAL_TLP_SEVERITY__SHIFT                                    0x12
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_SEVERITY__ECRC_ERR_SEVERITY__SHIFT                                   0x13
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_SEVERITY__UNSUPP_REQ_ERR_SEVERITY__SHIFT                             0x14
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_SEVERITY__ACS_VIOLATION_SEVERITY__SHIFT                              0x15
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_SEVERITY__UNCORR_INT_ERR_SEVERITY__SHIFT                             0x16
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_SEVERITY__MC_BLOCKED_TLP_SEVERITY__SHIFT                             0x17
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_SEVERITY__ATOMICOP_EGRESS_BLOCKED_SEVERITY__SHIFT                    0x18
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_SEVERITY__TLP_PREFIX_BLOCKED_ERR_SEVERITY__SHIFT                     0x19
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_SEVERITY__DLP_ERR_SEVERITY_MASK                                      0x00000010L
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_SEVERITY__SURPDN_ERR_SEVERITY_MASK                                   0x00000020L
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_SEVERITY__PSN_ERR_SEVERITY_MASK                                      0x00001000L
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_SEVERITY__FC_ERR_SEVERITY_MASK                                       0x00002000L
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_SEVERITY__CPL_TIMEOUT_SEVERITY_MASK                                  0x00004000L
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_SEVERITY__CPL_ABORT_ERR_SEVERITY_MASK                                0x00008000L
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_SEVERITY__UNEXP_CPL_SEVERITY_MASK                                    0x00010000L
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_SEVERITY__RCV_OVFL_SEVERITY_MASK                                     0x00020000L
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_SEVERITY__MAL_TLP_SEVERITY_MASK                                      0x00040000L
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_SEVERITY__ECRC_ERR_SEVERITY_MASK                                     0x00080000L
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_SEVERITY__UNSUPP_REQ_ERR_SEVERITY_MASK                               0x00100000L
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_SEVERITY__ACS_VIOLATION_SEVERITY_MASK                                0x00200000L
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_SEVERITY__UNCORR_INT_ERR_SEVERITY_MASK                               0x00400000L
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_SEVERITY__MC_BLOCKED_TLP_SEVERITY_MASK                               0x00800000L
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_SEVERITY__ATOMICOP_EGRESS_BLOCKED_SEVERITY_MASK                      0x01000000L
#define BIF_CFG_DEV0_RC0_PCIE_UNCORR_ERR_SEVERITY__TLP_PREFIX_BLOCKED_ERR_SEVERITY_MASK                       0x02000000L
//BIF_CFG_DEV0_RC0_PCIE_CORR_ERR_STATUS
#define BIF_CFG_DEV0_RC0_PCIE_CORR_ERR_STATUS__RCV_ERR_STATUS__SHIFT                                          0x0
#define BIF_CFG_DEV0_RC0_PCIE_CORR_ERR_STATUS__BAD_TLP_STATUS__SHIFT                                          0x6
#define BIF_CFG_DEV0_RC0_PCIE_CORR_ERR_STATUS__BAD_DLLP_STATUS__SHIFT                                         0x7
#define BIF_CFG_DEV0_RC0_PCIE_CORR_ERR_STATUS__REPLAY_NUM_ROLLOVER_STATUS__SHIFT                              0x8
#define BIF_CFG_DEV0_RC0_PCIE_CORR_ERR_STATUS__REPLAY_TIMER_TIMEOUT_STATUS__SHIFT                             0xc
#define BIF_CFG_DEV0_RC0_PCIE_CORR_ERR_STATUS__ADVISORY_NONFATAL_ERR_STATUS__SHIFT                            0xd
#define BIF_CFG_DEV0_RC0_PCIE_CORR_ERR_STATUS__CORR_INT_ERR_STATUS__SHIFT                                     0xe
#define BIF_CFG_DEV0_RC0_PCIE_CORR_ERR_STATUS__HDR_LOG_OVFL_STATUS__SHIFT                                     0xf
#define BIF_CFG_DEV0_RC0_PCIE_CORR_ERR_STATUS__RCV_ERR_STATUS_MASK                                            0x00000001L
#define BIF_CFG_DEV0_RC0_PCIE_CORR_ERR_STATUS__BAD_TLP_STATUS_MASK                                            0x00000040L
#define BIF_CFG_DEV0_RC0_PCIE_CORR_ERR_STATUS__BAD_DLLP_STATUS_MASK                                           0x00000080L
#define BIF_CFG_DEV0_RC0_PCIE_CORR_ERR_STATUS__REPLAY_NUM_ROLLOVER_STATUS_MASK                                0x00000100L
#define BIF_CFG_DEV0_RC0_PCIE_CORR_ERR_STATUS__REPLAY_TIMER_TIMEOUT_STATUS_MASK                               0x00001000L
#define BIF_CFG_DEV0_RC0_PCIE_CORR_ERR_STATUS__ADVISORY_NONFATAL_ERR_STATUS_MASK                              0x00002000L
#define BIF_CFG_DEV0_RC0_PCIE_CORR_ERR_STATUS__CORR_INT_ERR_STATUS_MASK                                       0x00004000L
#define BIF_CFG_DEV0_RC0_PCIE_CORR_ERR_STATUS__HDR_LOG_OVFL_STATUS_MASK                                       0x00008000L
//BIF_CFG_DEV0_RC0_PCIE_CORR_ERR_MASK
#define BIF_CFG_DEV0_RC0_PCIE_CORR_ERR_MASK__RCV_ERR_MASK__SHIFT                                              0x0
#define BIF_CFG_DEV0_RC0_PCIE_CORR_ERR_MASK__BAD_TLP_MASK__SHIFT                                              0x6
#define BIF_CFG_DEV0_RC0_PCIE_CORR_ERR_MASK__BAD_DLLP_MASK__SHIFT                                             0x7
#define BIF_CFG_DEV0_RC0_PCIE_CORR_ERR_MASK__REPLAY_NUM_ROLLOVER_MASK__SHIFT                                  0x8
#define BIF_CFG_DEV0_RC0_PCIE_CORR_ERR_MASK__REPLAY_TIMER_TIMEOUT_MASK__SHIFT                                 0xc
#define BIF_CFG_DEV0_RC0_PCIE_CORR_ERR_MASK__ADVISORY_NONFATAL_ERR_MASK__SHIFT                                0xd
#define BIF_CFG_DEV0_RC0_PCIE_CORR_ERR_MASK__CORR_INT_ERR_MASK__SHIFT                                         0xe
#define BIF_CFG_DEV0_RC0_PCIE_CORR_ERR_MASK__HDR_LOG_OVFL_MASK__SHIFT                                         0xf
#define BIF_CFG_DEV0_RC0_PCIE_CORR_ERR_MASK__RCV_ERR_MASK_MASK                                                0x00000001L
#define BIF_CFG_DEV0_RC0_PCIE_CORR_ERR_MASK__BAD_TLP_MASK_MASK                                                0x00000040L
#define BIF_CFG_DEV0_RC0_PCIE_CORR_ERR_MASK__BAD_DLLP_MASK_MASK                                               0x00000080L
#define BIF_CFG_DEV0_RC0_PCIE_CORR_ERR_MASK__REPLAY_NUM_ROLLOVER_MASK_MASK                                    0x00000100L
#define BIF_CFG_DEV0_RC0_PCIE_CORR_ERR_MASK__REPLAY_TIMER_TIMEOUT_MASK_MASK                                   0x00001000L
#define BIF_CFG_DEV0_RC0_PCIE_CORR_ERR_MASK__ADVISORY_NONFATAL_ERR_MASK_MASK                                  0x00002000L
#define BIF_CFG_DEV0_RC0_PCIE_CORR_ERR_MASK__CORR_INT_ERR_MASK_MASK                                           0x00004000L
#define BIF_CFG_DEV0_RC0_PCIE_CORR_ERR_MASK__HDR_LOG_OVFL_MASK_MASK                                           0x00008000L
//BIF_CFG_DEV0_RC0_PCIE_ADV_ERR_CAP_CNTL
#define BIF_CFG_DEV0_RC0_PCIE_ADV_ERR_CAP_CNTL__FIRST_ERR_PTR__SHIFT                                          0x0
#define BIF_CFG_DEV0_RC0_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_CAP__SHIFT                                           0x5
#define BIF_CFG_DEV0_RC0_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_EN__SHIFT                                            0x6
#define BIF_CFG_DEV0_RC0_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_CAP__SHIFT                                         0x7
#define BIF_CFG_DEV0_RC0_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_EN__SHIFT                                          0x8
#define BIF_CFG_DEV0_RC0_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_CAP__SHIFT                                     0x9
#define BIF_CFG_DEV0_RC0_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_EN__SHIFT                                      0xa
#define BIF_CFG_DEV0_RC0_PCIE_ADV_ERR_CAP_CNTL__TLP_PREFIX_LOG_PRESENT__SHIFT                                 0xb
#define BIF_CFG_DEV0_RC0_PCIE_ADV_ERR_CAP_CNTL__FIRST_ERR_PTR_MASK                                            0x0000001FL
#define BIF_CFG_DEV0_RC0_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_CAP_MASK                                             0x00000020L
#define BIF_CFG_DEV0_RC0_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_EN_MASK                                              0x00000040L
#define BIF_CFG_DEV0_RC0_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_CAP_MASK                                           0x00000080L
#define BIF_CFG_DEV0_RC0_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_EN_MASK                                            0x00000100L
#define BIF_CFG_DEV0_RC0_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_CAP_MASK                                       0x00000200L
#define BIF_CFG_DEV0_RC0_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_EN_MASK                                        0x00000400L
#define BIF_CFG_DEV0_RC0_PCIE_ADV_ERR_CAP_CNTL__TLP_PREFIX_LOG_PRESENT_MASK                                   0x00000800L
//BIF_CFG_DEV0_RC0_PCIE_HDR_LOG0
#define BIF_CFG_DEV0_RC0_PCIE_HDR_LOG0__TLP_HDR__SHIFT                                                        0x0
#define BIF_CFG_DEV0_RC0_PCIE_HDR_LOG0__TLP_HDR_MASK                                                          0xFFFFFFFFL
//BIF_CFG_DEV0_RC0_PCIE_HDR_LOG1
#define BIF_CFG_DEV0_RC0_PCIE_HDR_LOG1__TLP_HDR__SHIFT                                                        0x0
#define BIF_CFG_DEV0_RC0_PCIE_HDR_LOG1__TLP_HDR_MASK                                                          0xFFFFFFFFL
//BIF_CFG_DEV0_RC0_PCIE_HDR_LOG2
#define BIF_CFG_DEV0_RC0_PCIE_HDR_LOG2__TLP_HDR__SHIFT                                                        0x0
#define BIF_CFG_DEV0_RC0_PCIE_HDR_LOG2__TLP_HDR_MASK                                                          0xFFFFFFFFL
//BIF_CFG_DEV0_RC0_PCIE_HDR_LOG3
#define BIF_CFG_DEV0_RC0_PCIE_HDR_LOG3__TLP_HDR__SHIFT                                                        0x0
#define BIF_CFG_DEV0_RC0_PCIE_HDR_LOG3__TLP_HDR_MASK                                                          0xFFFFFFFFL
//BIF_CFG_DEV0_RC0_PCIE_ROOT_ERR_CMD
#define BIF_CFG_DEV0_RC0_PCIE_ROOT_ERR_CMD__CORR_ERR_REP_EN__SHIFT                                            0x0
#define BIF_CFG_DEV0_RC0_PCIE_ROOT_ERR_CMD__NONFATAL_ERR_REP_EN__SHIFT                                        0x1
#define BIF_CFG_DEV0_RC0_PCIE_ROOT_ERR_CMD__FATAL_ERR_REP_EN__SHIFT                                           0x2
#define BIF_CFG_DEV0_RC0_PCIE_ROOT_ERR_CMD__CORR_ERR_REP_EN_MASK                                              0x00000001L
#define BIF_CFG_DEV0_RC0_PCIE_ROOT_ERR_CMD__NONFATAL_ERR_REP_EN_MASK                                          0x00000002L
#define BIF_CFG_DEV0_RC0_PCIE_ROOT_ERR_CMD__FATAL_ERR_REP_EN_MASK                                             0x00000004L
//BIF_CFG_DEV0_RC0_PCIE_ROOT_ERR_STATUS
#define BIF_CFG_DEV0_RC0_PCIE_ROOT_ERR_STATUS__ERR_CORR_RCVD__SHIFT                                           0x0
#define BIF_CFG_DEV0_RC0_PCIE_ROOT_ERR_STATUS__MULT_ERR_CORR_RCVD__SHIFT                                      0x1
#define BIF_CFG_DEV0_RC0_PCIE_ROOT_ERR_STATUS__ERR_FATAL_NONFATAL_RCVD__SHIFT                                 0x2
#define BIF_CFG_DEV0_RC0_PCIE_ROOT_ERR_STATUS__MULT_ERR_FATAL_NONFATAL_RCVD__SHIFT                            0x3
#define BIF_CFG_DEV0_RC0_PCIE_ROOT_ERR_STATUS__FIRST_UNCORRECTABLE_FATAL__SHIFT                               0x4
#define BIF_CFG_DEV0_RC0_PCIE_ROOT_ERR_STATUS__NONFATAL_ERROR_MSG_RCVD__SHIFT                                 0x5
#define BIF_CFG_DEV0_RC0_PCIE_ROOT_ERR_STATUS__FATAL_ERROR_MSG_RCVD__SHIFT                                    0x6
#define BIF_CFG_DEV0_RC0_PCIE_ROOT_ERR_STATUS__ADV_ERR_INT_MSG_NUM__SHIFT                                     0x1b
#define BIF_CFG_DEV0_RC0_PCIE_ROOT_ERR_STATUS__ERR_CORR_RCVD_MASK                                             0x00000001L
#define BIF_CFG_DEV0_RC0_PCIE_ROOT_ERR_STATUS__MULT_ERR_CORR_RCVD_MASK                                        0x00000002L
#define BIF_CFG_DEV0_RC0_PCIE_ROOT_ERR_STATUS__ERR_FATAL_NONFATAL_RCVD_MASK                                   0x00000004L
#define BIF_CFG_DEV0_RC0_PCIE_ROOT_ERR_STATUS__MULT_ERR_FATAL_NONFATAL_RCVD_MASK                              0x00000008L
#define BIF_CFG_DEV0_RC0_PCIE_ROOT_ERR_STATUS__FIRST_UNCORRECTABLE_FATAL_MASK                                 0x00000010L
#define BIF_CFG_DEV0_RC0_PCIE_ROOT_ERR_STATUS__NONFATAL_ERROR_MSG_RCVD_MASK                                   0x00000020L
#define BIF_CFG_DEV0_RC0_PCIE_ROOT_ERR_STATUS__FATAL_ERROR_MSG_RCVD_MASK                                      0x00000040L
#define BIF_CFG_DEV0_RC0_PCIE_ROOT_ERR_STATUS__ADV_ERR_INT_MSG_NUM_MASK                                       0xF8000000L
//BIF_CFG_DEV0_RC0_PCIE_ERR_SRC_ID
#define BIF_CFG_DEV0_RC0_PCIE_ERR_SRC_ID__ERR_CORR_SRC_ID__SHIFT                                              0x0
#define BIF_CFG_DEV0_RC0_PCIE_ERR_SRC_ID__ERR_FATAL_NONFATAL_SRC_ID__SHIFT                                    0x10
#define BIF_CFG_DEV0_RC0_PCIE_ERR_SRC_ID__ERR_CORR_SRC_ID_MASK                                                0x0000FFFFL
#define BIF_CFG_DEV0_RC0_PCIE_ERR_SRC_ID__ERR_FATAL_NONFATAL_SRC_ID_MASK                                      0xFFFF0000L
//BIF_CFG_DEV0_RC0_PCIE_TLP_PREFIX_LOG0
#define BIF_CFG_DEV0_RC0_PCIE_TLP_PREFIX_LOG0__TLP_PREFIX__SHIFT                                              0x0
#define BIF_CFG_DEV0_RC0_PCIE_TLP_PREFIX_LOG0__TLP_PREFIX_MASK                                                0xFFFFFFFFL
//BIF_CFG_DEV0_RC0_PCIE_TLP_PREFIX_LOG1
#define BIF_CFG_DEV0_RC0_PCIE_TLP_PREFIX_LOG1__TLP_PREFIX__SHIFT                                              0x0
#define BIF_CFG_DEV0_RC0_PCIE_TLP_PREFIX_LOG1__TLP_PREFIX_MASK                                                0xFFFFFFFFL
//BIF_CFG_DEV0_RC0_PCIE_TLP_PREFIX_LOG2
#define BIF_CFG_DEV0_RC0_PCIE_TLP_PREFIX_LOG2__TLP_PREFIX__SHIFT                                              0x0
#define BIF_CFG_DEV0_RC0_PCIE_TLP_PREFIX_LOG2__TLP_PREFIX_MASK                                                0xFFFFFFFFL
//BIF_CFG_DEV0_RC0_PCIE_TLP_PREFIX_LOG3
#define BIF_CFG_DEV0_RC0_PCIE_TLP_PREFIX_LOG3__TLP_PREFIX__SHIFT                                              0x0
#define BIF_CFG_DEV0_RC0_PCIE_TLP_PREFIX_LOG3__TLP_PREFIX_MASK                                                0xFFFFFFFFL
//BIF_CFG_DEV0_RC0_PCIE_SECONDARY_ENH_CAP_LIST
#define BIF_CFG_DEV0_RC0_PCIE_SECONDARY_ENH_CAP_LIST__CAP_ID__SHIFT                                           0x0
#define BIF_CFG_DEV0_RC0_PCIE_SECONDARY_ENH_CAP_LIST__CAP_VER__SHIFT                                          0x10
#define BIF_CFG_DEV0_RC0_PCIE_SECONDARY_ENH_CAP_LIST__NEXT_PTR__SHIFT                                         0x14
#define BIF_CFG_DEV0_RC0_PCIE_SECONDARY_ENH_CAP_LIST__CAP_ID_MASK                                             0x0000FFFFL
#define BIF_CFG_DEV0_RC0_PCIE_SECONDARY_ENH_CAP_LIST__CAP_VER_MASK                                            0x000F0000L
#define BIF_CFG_DEV0_RC0_PCIE_SECONDARY_ENH_CAP_LIST__NEXT_PTR_MASK                                           0xFFF00000L
//BIF_CFG_DEV0_RC0_PCIE_LINK_CNTL3
#define BIF_CFG_DEV0_RC0_PCIE_LINK_CNTL3__PERFORM_EQUALIZATION__SHIFT                                         0x0
#define BIF_CFG_DEV0_RC0_PCIE_LINK_CNTL3__LINK_EQUALIZATION_REQ_INT_EN__SHIFT                                 0x1
#define BIF_CFG_DEV0_RC0_PCIE_LINK_CNTL3__RESERVED__SHIFT                                                     0x2
#define BIF_CFG_DEV0_RC0_PCIE_LINK_CNTL3__PERFORM_EQUALIZATION_MASK                                           0x00000001L
#define BIF_CFG_DEV0_RC0_PCIE_LINK_CNTL3__LINK_EQUALIZATION_REQ_INT_EN_MASK                                   0x00000002L
#define BIF_CFG_DEV0_RC0_PCIE_LINK_CNTL3__RESERVED_MASK                                                       0xFFFFFFFCL
//BIF_CFG_DEV0_RC0_PCIE_LANE_ERROR_STATUS
#define BIF_CFG_DEV0_RC0_PCIE_LANE_ERROR_STATUS__LANE_ERROR_STATUS_BITS__SHIFT                                0x0
#define BIF_CFG_DEV0_RC0_PCIE_LANE_ERROR_STATUS__RESERVED__SHIFT                                              0x10
#define BIF_CFG_DEV0_RC0_PCIE_LANE_ERROR_STATUS__LANE_ERROR_STATUS_BITS_MASK                                  0x0000FFFFL
#define BIF_CFG_DEV0_RC0_PCIE_LANE_ERROR_STATUS__RESERVED_MASK                                                0xFFFF0000L
//BIF_CFG_DEV0_RC0_PCIE_LANE_0_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_RC0_PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                      0x0
#define BIF_CFG_DEV0_RC0_PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                 0x4
#define BIF_CFG_DEV0_RC0_PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                        0x8
#define BIF_CFG_DEV0_RC0_PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                   0xc
#define BIF_CFG_DEV0_RC0_PCIE_LANE_0_EQUALIZATION_CNTL__RESERVED__SHIFT                                       0xf
#define BIF_CFG_DEV0_RC0_PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                        0x000FL
#define BIF_CFG_DEV0_RC0_PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                   0x0070L
#define BIF_CFG_DEV0_RC0_PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                          0x0F00L
#define BIF_CFG_DEV0_RC0_PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                     0x7000L
#define BIF_CFG_DEV0_RC0_PCIE_LANE_0_EQUALIZATION_CNTL__RESERVED_MASK                                         0x8000L
//BIF_CFG_DEV0_RC0_PCIE_LANE_1_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_RC0_PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                      0x0
#define BIF_CFG_DEV0_RC0_PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                 0x4
#define BIF_CFG_DEV0_RC0_PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                        0x8
#define BIF_CFG_DEV0_RC0_PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                   0xc
#define BIF_CFG_DEV0_RC0_PCIE_LANE_1_EQUALIZATION_CNTL__RESERVED__SHIFT                                       0xf
#define BIF_CFG_DEV0_RC0_PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                        0x000FL
#define BIF_CFG_DEV0_RC0_PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                   0x0070L
#define BIF_CFG_DEV0_RC0_PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                          0x0F00L
#define BIF_CFG_DEV0_RC0_PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                     0x7000L
#define BIF_CFG_DEV0_RC0_PCIE_LANE_1_EQUALIZATION_CNTL__RESERVED_MASK                                         0x8000L
//BIF_CFG_DEV0_RC0_PCIE_LANE_2_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_RC0_PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                      0x0
#define BIF_CFG_DEV0_RC0_PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                 0x4
#define BIF_CFG_DEV0_RC0_PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                        0x8
#define BIF_CFG_DEV0_RC0_PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                   0xc
#define BIF_CFG_DEV0_RC0_PCIE_LANE_2_EQUALIZATION_CNTL__RESERVED__SHIFT                                       0xf
#define BIF_CFG_DEV0_RC0_PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                        0x000FL
#define BIF_CFG_DEV0_RC0_PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                   0x0070L
#define BIF_CFG_DEV0_RC0_PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                          0x0F00L
#define BIF_CFG_DEV0_RC0_PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                     0x7000L
#define BIF_CFG_DEV0_RC0_PCIE_LANE_2_EQUALIZATION_CNTL__RESERVED_MASK                                         0x8000L
//BIF_CFG_DEV0_RC0_PCIE_LANE_3_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_RC0_PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                      0x0
#define BIF_CFG_DEV0_RC0_PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                 0x4
#define BIF_CFG_DEV0_RC0_PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                        0x8
#define BIF_CFG_DEV0_RC0_PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                   0xc
#define BIF_CFG_DEV0_RC0_PCIE_LANE_3_EQUALIZATION_CNTL__RESERVED__SHIFT                                       0xf
#define BIF_CFG_DEV0_RC0_PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                        0x000FL
#define BIF_CFG_DEV0_RC0_PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                   0x0070L
#define BIF_CFG_DEV0_RC0_PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                          0x0F00L
#define BIF_CFG_DEV0_RC0_PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                     0x7000L
#define BIF_CFG_DEV0_RC0_PCIE_LANE_3_EQUALIZATION_CNTL__RESERVED_MASK                                         0x8000L
//BIF_CFG_DEV0_RC0_PCIE_LANE_4_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_RC0_PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                      0x0
#define BIF_CFG_DEV0_RC0_PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                 0x4
#define BIF_CFG_DEV0_RC0_PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                        0x8
#define BIF_CFG_DEV0_RC0_PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                   0xc
#define BIF_CFG_DEV0_RC0_PCIE_LANE_4_EQUALIZATION_CNTL__RESERVED__SHIFT                                       0xf
#define BIF_CFG_DEV0_RC0_PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                        0x000FL
#define BIF_CFG_DEV0_RC0_PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                   0x0070L
#define BIF_CFG_DEV0_RC0_PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                          0x0F00L
#define BIF_CFG_DEV0_RC0_PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                     0x7000L
#define BIF_CFG_DEV0_RC0_PCIE_LANE_4_EQUALIZATION_CNTL__RESERVED_MASK                                         0x8000L
//BIF_CFG_DEV0_RC0_PCIE_LANE_5_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_RC0_PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                      0x0
#define BIF_CFG_DEV0_RC0_PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                 0x4
#define BIF_CFG_DEV0_RC0_PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                        0x8
#define BIF_CFG_DEV0_RC0_PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                   0xc
#define BIF_CFG_DEV0_RC0_PCIE_LANE_5_EQUALIZATION_CNTL__RESERVED__SHIFT                                       0xf
#define BIF_CFG_DEV0_RC0_PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                        0x000FL
#define BIF_CFG_DEV0_RC0_PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                   0x0070L
#define BIF_CFG_DEV0_RC0_PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                          0x0F00L
#define BIF_CFG_DEV0_RC0_PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                     0x7000L
#define BIF_CFG_DEV0_RC0_PCIE_LANE_5_EQUALIZATION_CNTL__RESERVED_MASK                                         0x8000L
//BIF_CFG_DEV0_RC0_PCIE_LANE_6_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_RC0_PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                      0x0
#define BIF_CFG_DEV0_RC0_PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                 0x4
#define BIF_CFG_DEV0_RC0_PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                        0x8
#define BIF_CFG_DEV0_RC0_PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                   0xc
#define BIF_CFG_DEV0_RC0_PCIE_LANE_6_EQUALIZATION_CNTL__RESERVED__SHIFT                                       0xf
#define BIF_CFG_DEV0_RC0_PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                        0x000FL
#define BIF_CFG_DEV0_RC0_PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                   0x0070L
#define BIF_CFG_DEV0_RC0_PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                          0x0F00L
#define BIF_CFG_DEV0_RC0_PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                     0x7000L
#define BIF_CFG_DEV0_RC0_PCIE_LANE_6_EQUALIZATION_CNTL__RESERVED_MASK                                         0x8000L
//BIF_CFG_DEV0_RC0_PCIE_LANE_7_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_RC0_PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                      0x0
#define BIF_CFG_DEV0_RC0_PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                 0x4
#define BIF_CFG_DEV0_RC0_PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                        0x8
#define BIF_CFG_DEV0_RC0_PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                   0xc
#define BIF_CFG_DEV0_RC0_PCIE_LANE_7_EQUALIZATION_CNTL__RESERVED__SHIFT                                       0xf
#define BIF_CFG_DEV0_RC0_PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                        0x000FL
#define BIF_CFG_DEV0_RC0_PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                   0x0070L
#define BIF_CFG_DEV0_RC0_PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                          0x0F00L
#define BIF_CFG_DEV0_RC0_PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                     0x7000L
#define BIF_CFG_DEV0_RC0_PCIE_LANE_7_EQUALIZATION_CNTL__RESERVED_MASK                                         0x8000L
//BIF_CFG_DEV0_RC0_PCIE_LANE_8_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_RC0_PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                      0x0
#define BIF_CFG_DEV0_RC0_PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                 0x4
#define BIF_CFG_DEV0_RC0_PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                        0x8
#define BIF_CFG_DEV0_RC0_PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                   0xc
#define BIF_CFG_DEV0_RC0_PCIE_LANE_8_EQUALIZATION_CNTL__RESERVED__SHIFT                                       0xf
#define BIF_CFG_DEV0_RC0_PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                        0x000FL
#define BIF_CFG_DEV0_RC0_PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                   0x0070L
#define BIF_CFG_DEV0_RC0_PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                          0x0F00L
#define BIF_CFG_DEV0_RC0_PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                     0x7000L
#define BIF_CFG_DEV0_RC0_PCIE_LANE_8_EQUALIZATION_CNTL__RESERVED_MASK                                         0x8000L
//BIF_CFG_DEV0_RC0_PCIE_LANE_9_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_RC0_PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                      0x0
#define BIF_CFG_DEV0_RC0_PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                 0x4
#define BIF_CFG_DEV0_RC0_PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                        0x8
#define BIF_CFG_DEV0_RC0_PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                   0xc
#define BIF_CFG_DEV0_RC0_PCIE_LANE_9_EQUALIZATION_CNTL__RESERVED__SHIFT                                       0xf
#define BIF_CFG_DEV0_RC0_PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                        0x000FL
#define BIF_CFG_DEV0_RC0_PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                   0x0070L
#define BIF_CFG_DEV0_RC0_PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                          0x0F00L
#define BIF_CFG_DEV0_RC0_PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                     0x7000L
#define BIF_CFG_DEV0_RC0_PCIE_LANE_9_EQUALIZATION_CNTL__RESERVED_MASK                                         0x8000L
//BIF_CFG_DEV0_RC0_PCIE_LANE_10_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_RC0_PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                     0x0
#define BIF_CFG_DEV0_RC0_PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                0x4
#define BIF_CFG_DEV0_RC0_PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                       0x8
#define BIF_CFG_DEV0_RC0_PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                  0xc
#define BIF_CFG_DEV0_RC0_PCIE_LANE_10_EQUALIZATION_CNTL__RESERVED__SHIFT                                      0xf
#define BIF_CFG_DEV0_RC0_PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                       0x000FL
#define BIF_CFG_DEV0_RC0_PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                  0x0070L
#define BIF_CFG_DEV0_RC0_PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                         0x0F00L
#define BIF_CFG_DEV0_RC0_PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                    0x7000L
#define BIF_CFG_DEV0_RC0_PCIE_LANE_10_EQUALIZATION_CNTL__RESERVED_MASK                                        0x8000L
//BIF_CFG_DEV0_RC0_PCIE_LANE_11_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_RC0_PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                     0x0
#define BIF_CFG_DEV0_RC0_PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                0x4
#define BIF_CFG_DEV0_RC0_PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                       0x8
#define BIF_CFG_DEV0_RC0_PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                  0xc
#define BIF_CFG_DEV0_RC0_PCIE_LANE_11_EQUALIZATION_CNTL__RESERVED__SHIFT                                      0xf
#define BIF_CFG_DEV0_RC0_PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                       0x000FL
#define BIF_CFG_DEV0_RC0_PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                  0x0070L
#define BIF_CFG_DEV0_RC0_PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                         0x0F00L
#define BIF_CFG_DEV0_RC0_PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                    0x7000L
#define BIF_CFG_DEV0_RC0_PCIE_LANE_11_EQUALIZATION_CNTL__RESERVED_MASK                                        0x8000L
//BIF_CFG_DEV0_RC0_PCIE_LANE_12_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_RC0_PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                     0x0
#define BIF_CFG_DEV0_RC0_PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                0x4
#define BIF_CFG_DEV0_RC0_PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                       0x8
#define BIF_CFG_DEV0_RC0_PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                  0xc
#define BIF_CFG_DEV0_RC0_PCIE_LANE_12_EQUALIZATION_CNTL__RESERVED__SHIFT                                      0xf
#define BIF_CFG_DEV0_RC0_PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                       0x000FL
#define BIF_CFG_DEV0_RC0_PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                  0x0070L
#define BIF_CFG_DEV0_RC0_PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                         0x0F00L
#define BIF_CFG_DEV0_RC0_PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                    0x7000L
#define BIF_CFG_DEV0_RC0_PCIE_LANE_12_EQUALIZATION_CNTL__RESERVED_MASK                                        0x8000L
//BIF_CFG_DEV0_RC0_PCIE_LANE_13_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_RC0_PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                     0x0
#define BIF_CFG_DEV0_RC0_PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                0x4
#define BIF_CFG_DEV0_RC0_PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                       0x8
#define BIF_CFG_DEV0_RC0_PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                  0xc
#define BIF_CFG_DEV0_RC0_PCIE_LANE_13_EQUALIZATION_CNTL__RESERVED__SHIFT                                      0xf
#define BIF_CFG_DEV0_RC0_PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                       0x000FL
#define BIF_CFG_DEV0_RC0_PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                  0x0070L
#define BIF_CFG_DEV0_RC0_PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                         0x0F00L
#define BIF_CFG_DEV0_RC0_PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                    0x7000L
#define BIF_CFG_DEV0_RC0_PCIE_LANE_13_EQUALIZATION_CNTL__RESERVED_MASK                                        0x8000L
//BIF_CFG_DEV0_RC0_PCIE_LANE_14_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_RC0_PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                     0x0
#define BIF_CFG_DEV0_RC0_PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                0x4
#define BIF_CFG_DEV0_RC0_PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                       0x8
#define BIF_CFG_DEV0_RC0_PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                  0xc
#define BIF_CFG_DEV0_RC0_PCIE_LANE_14_EQUALIZATION_CNTL__RESERVED__SHIFT                                      0xf
#define BIF_CFG_DEV0_RC0_PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                       0x000FL
#define BIF_CFG_DEV0_RC0_PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                  0x0070L
#define BIF_CFG_DEV0_RC0_PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                         0x0F00L
#define BIF_CFG_DEV0_RC0_PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                    0x7000L
#define BIF_CFG_DEV0_RC0_PCIE_LANE_14_EQUALIZATION_CNTL__RESERVED_MASK                                        0x8000L
//BIF_CFG_DEV0_RC0_PCIE_LANE_15_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_RC0_PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                     0x0
#define BIF_CFG_DEV0_RC0_PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                0x4
#define BIF_CFG_DEV0_RC0_PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                       0x8
#define BIF_CFG_DEV0_RC0_PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                  0xc
#define BIF_CFG_DEV0_RC0_PCIE_LANE_15_EQUALIZATION_CNTL__RESERVED__SHIFT                                      0xf
#define BIF_CFG_DEV0_RC0_PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                       0x000FL
#define BIF_CFG_DEV0_RC0_PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                  0x0070L
#define BIF_CFG_DEV0_RC0_PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                         0x0F00L
#define BIF_CFG_DEV0_RC0_PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                    0x7000L
#define BIF_CFG_DEV0_RC0_PCIE_LANE_15_EQUALIZATION_CNTL__RESERVED_MASK                                        0x8000L
//BIF_CFG_DEV0_RC0_PCIE_ACS_ENH_CAP_LIST
#define BIF_CFG_DEV0_RC0_PCIE_ACS_ENH_CAP_LIST__CAP_ID__SHIFT                                                 0x0
#define BIF_CFG_DEV0_RC0_PCIE_ACS_ENH_CAP_LIST__CAP_VER__SHIFT                                                0x10
#define BIF_CFG_DEV0_RC0_PCIE_ACS_ENH_CAP_LIST__NEXT_PTR__SHIFT                                               0x14
#define BIF_CFG_DEV0_RC0_PCIE_ACS_ENH_CAP_LIST__CAP_ID_MASK                                                   0x0000FFFFL
#define BIF_CFG_DEV0_RC0_PCIE_ACS_ENH_CAP_LIST__CAP_VER_MASK                                                  0x000F0000L
#define BIF_CFG_DEV0_RC0_PCIE_ACS_ENH_CAP_LIST__NEXT_PTR_MASK                                                 0xFFF00000L
//BIF_CFG_DEV0_RC0_PCIE_ACS_CAP
#define BIF_CFG_DEV0_RC0_PCIE_ACS_CAP__SOURCE_VALIDATION__SHIFT                                               0x0
#define BIF_CFG_DEV0_RC0_PCIE_ACS_CAP__TRANSLATION_BLOCKING__SHIFT                                            0x1
#define BIF_CFG_DEV0_RC0_PCIE_ACS_CAP__P2P_REQUEST_REDIRECT__SHIFT                                            0x2
#define BIF_CFG_DEV0_RC0_PCIE_ACS_CAP__P2P_COMPLETION_REDIRECT__SHIFT                                         0x3
#define BIF_CFG_DEV0_RC0_PCIE_ACS_CAP__UPSTREAM_FORWARDING__SHIFT                                             0x4
#define BIF_CFG_DEV0_RC0_PCIE_ACS_CAP__P2P_EGRESS_CONTROL__SHIFT                                              0x5
#define BIF_CFG_DEV0_RC0_PCIE_ACS_CAP__DIRECT_TRANSLATED_P2P__SHIFT                                           0x6
#define BIF_CFG_DEV0_RC0_PCIE_ACS_CAP__EGRESS_CONTROL_VECTOR_SIZE__SHIFT                                      0x8
#define BIF_CFG_DEV0_RC0_PCIE_ACS_CAP__SOURCE_VALIDATION_MASK                                                 0x0001L
#define BIF_CFG_DEV0_RC0_PCIE_ACS_CAP__TRANSLATION_BLOCKING_MASK                                              0x0002L
#define BIF_CFG_DEV0_RC0_PCIE_ACS_CAP__P2P_REQUEST_REDIRECT_MASK                                              0x0004L
#define BIF_CFG_DEV0_RC0_PCIE_ACS_CAP__P2P_COMPLETION_REDIRECT_MASK                                           0x0008L
#define BIF_CFG_DEV0_RC0_PCIE_ACS_CAP__UPSTREAM_FORWARDING_MASK                                               0x0010L
#define BIF_CFG_DEV0_RC0_PCIE_ACS_CAP__P2P_EGRESS_CONTROL_MASK                                                0x0020L
#define BIF_CFG_DEV0_RC0_PCIE_ACS_CAP__DIRECT_TRANSLATED_P2P_MASK                                             0x0040L
#define BIF_CFG_DEV0_RC0_PCIE_ACS_CAP__EGRESS_CONTROL_VECTOR_SIZE_MASK                                        0xFF00L
//BIF_CFG_DEV0_RC0_PCIE_ACS_CNTL
#define BIF_CFG_DEV0_RC0_PCIE_ACS_CNTL__SOURCE_VALIDATION_EN__SHIFT                                           0x0
#define BIF_CFG_DEV0_RC0_PCIE_ACS_CNTL__TRANSLATION_BLOCKING_EN__SHIFT                                        0x1
#define BIF_CFG_DEV0_RC0_PCIE_ACS_CNTL__P2P_REQUEST_REDIRECT_EN__SHIFT                                        0x2
#define BIF_CFG_DEV0_RC0_PCIE_ACS_CNTL__P2P_COMPLETION_REDIRECT_EN__SHIFT                                     0x3
#define BIF_CFG_DEV0_RC0_PCIE_ACS_CNTL__UPSTREAM_FORWARDING_EN__SHIFT                                         0x4
#define BIF_CFG_DEV0_RC0_PCIE_ACS_CNTL__P2P_EGRESS_CONTROL_EN__SHIFT                                          0x5
#define BIF_CFG_DEV0_RC0_PCIE_ACS_CNTL__DIRECT_TRANSLATED_P2P_EN__SHIFT                                       0x6
#define BIF_CFG_DEV0_RC0_PCIE_ACS_CNTL__SOURCE_VALIDATION_EN_MASK                                             0x0001L
#define BIF_CFG_DEV0_RC0_PCIE_ACS_CNTL__TRANSLATION_BLOCKING_EN_MASK                                          0x0002L
#define BIF_CFG_DEV0_RC0_PCIE_ACS_CNTL__P2P_REQUEST_REDIRECT_EN_MASK                                          0x0004L
#define BIF_CFG_DEV0_RC0_PCIE_ACS_CNTL__P2P_COMPLETION_REDIRECT_EN_MASK                                       0x0008L
#define BIF_CFG_DEV0_RC0_PCIE_ACS_CNTL__UPSTREAM_FORWARDING_EN_MASK                                           0x0010L
#define BIF_CFG_DEV0_RC0_PCIE_ACS_CNTL__P2P_EGRESS_CONTROL_EN_MASK                                            0x0020L
#define BIF_CFG_DEV0_RC0_PCIE_ACS_CNTL__DIRECT_TRANSLATED_P2P_EN_MASK                                         0x0040L


// addressBlock: nbio_nbif0_bif_cfg_dev1_rc_bifcfgdecp
//BIF_CFG_DEV1_RC0_VENDOR_ID
#define BIF_CFG_DEV1_RC0_VENDOR_ID__VENDOR_ID__SHIFT                                                          0x0
#define BIF_CFG_DEV1_RC0_VENDOR_ID__VENDOR_ID_MASK                                                            0xFFFFL
//BIF_CFG_DEV1_RC0_DEVICE_ID
#define BIF_CFG_DEV1_RC0_DEVICE_ID__DEVICE_ID__SHIFT                                                          0x0
#define BIF_CFG_DEV1_RC0_DEVICE_ID__DEVICE_ID_MASK                                                            0xFFFFL
//BIF_CFG_DEV1_RC0_COMMAND
#define BIF_CFG_DEV1_RC0_COMMAND__IOEN_DN__SHIFT                                                              0x0
#define BIF_CFG_DEV1_RC0_COMMAND__MEMEN_DN__SHIFT                                                             0x1
#define BIF_CFG_DEV1_RC0_COMMAND__BUS_MASTER_EN__SHIFT                                                        0x2
#define BIF_CFG_DEV1_RC0_COMMAND__SPECIAL_CYCLE_EN__SHIFT                                                     0x3
#define BIF_CFG_DEV1_RC0_COMMAND__MEM_WRITE_INVALIDATE_EN__SHIFT                                              0x4
#define BIF_CFG_DEV1_RC0_COMMAND__PAL_SNOOP_EN__SHIFT                                                         0x5
#define BIF_CFG_DEV1_RC0_COMMAND__PARITY_ERROR_RESPONSE__SHIFT                                                0x6
#define BIF_CFG_DEV1_RC0_COMMAND__AD_STEPPING__SHIFT                                                          0x7
#define BIF_CFG_DEV1_RC0_COMMAND__SERR_EN__SHIFT                                                              0x8
#define BIF_CFG_DEV1_RC0_COMMAND__FAST_B2B_EN__SHIFT                                                          0x9
#define BIF_CFG_DEV1_RC0_COMMAND__INT_DIS__SHIFT                                                              0xa
#define BIF_CFG_DEV1_RC0_COMMAND__IOEN_DN_MASK                                                                0x0001L
#define BIF_CFG_DEV1_RC0_COMMAND__MEMEN_DN_MASK                                                               0x0002L
#define BIF_CFG_DEV1_RC0_COMMAND__BUS_MASTER_EN_MASK                                                          0x0004L
#define BIF_CFG_DEV1_RC0_COMMAND__SPECIAL_CYCLE_EN_MASK                                                       0x0008L
#define BIF_CFG_DEV1_RC0_COMMAND__MEM_WRITE_INVALIDATE_EN_MASK                                                0x0010L
#define BIF_CFG_DEV1_RC0_COMMAND__PAL_SNOOP_EN_MASK                                                           0x0020L
#define BIF_CFG_DEV1_RC0_COMMAND__PARITY_ERROR_RESPONSE_MASK                                                  0x0040L
#define BIF_CFG_DEV1_RC0_COMMAND__AD_STEPPING_MASK                                                            0x0080L
#define BIF_CFG_DEV1_RC0_COMMAND__SERR_EN_MASK                                                                0x0100L
#define BIF_CFG_DEV1_RC0_COMMAND__FAST_B2B_EN_MASK                                                            0x0200L
#define BIF_CFG_DEV1_RC0_COMMAND__INT_DIS_MASK                                                                0x0400L
//BIF_CFG_DEV1_RC0_STATUS
#define BIF_CFG_DEV1_RC0_STATUS__INT_STATUS__SHIFT                                                            0x3
#define BIF_CFG_DEV1_RC0_STATUS__CAP_LIST__SHIFT                                                              0x4
#define BIF_CFG_DEV1_RC0_STATUS__PCI_66_EN__SHIFT                                                             0x5
#define BIF_CFG_DEV1_RC0_STATUS__FAST_BACK_CAPABLE__SHIFT                                                     0x7
#define BIF_CFG_DEV1_RC0_STATUS__MASTER_DATA_PARITY_ERROR__SHIFT                                              0x8
#define BIF_CFG_DEV1_RC0_STATUS__DEVSEL_TIMING__SHIFT                                                         0x9
#define BIF_CFG_DEV1_RC0_STATUS__SIGNAL_TARGET_ABORT__SHIFT                                                   0xb
#define BIF_CFG_DEV1_RC0_STATUS__RECEIVED_TARGET_ABORT__SHIFT                                                 0xc
#define BIF_CFG_DEV1_RC0_STATUS__RECEIVED_MASTER_ABORT__SHIFT                                                 0xd
#define BIF_CFG_DEV1_RC0_STATUS__SIGNALED_SYSTEM_ERROR__SHIFT                                                 0xe
#define BIF_CFG_DEV1_RC0_STATUS__PARITY_ERROR_DETECTED__SHIFT                                                 0xf
#define BIF_CFG_DEV1_RC0_STATUS__INT_STATUS_MASK                                                              0x0008L
#define BIF_CFG_DEV1_RC0_STATUS__CAP_LIST_MASK                                                                0x0010L
#define BIF_CFG_DEV1_RC0_STATUS__PCI_66_EN_MASK                                                               0x0020L
#define BIF_CFG_DEV1_RC0_STATUS__FAST_BACK_CAPABLE_MASK                                                       0x0080L
#define BIF_CFG_DEV1_RC0_STATUS__MASTER_DATA_PARITY_ERROR_MASK                                                0x0100L
#define BIF_CFG_DEV1_RC0_STATUS__DEVSEL_TIMING_MASK                                                           0x0600L
#define BIF_CFG_DEV1_RC0_STATUS__SIGNAL_TARGET_ABORT_MASK                                                     0x0800L
#define BIF_CFG_DEV1_RC0_STATUS__RECEIVED_TARGET_ABORT_MASK                                                   0x1000L
#define BIF_CFG_DEV1_RC0_STATUS__RECEIVED_MASTER_ABORT_MASK                                                   0x2000L
#define BIF_CFG_DEV1_RC0_STATUS__SIGNALED_SYSTEM_ERROR_MASK                                                   0x4000L
#define BIF_CFG_DEV1_RC0_STATUS__PARITY_ERROR_DETECTED_MASK                                                   0x8000L
//BIF_CFG_DEV1_RC0_REVISION_ID
#define BIF_CFG_DEV1_RC0_REVISION_ID__MINOR_REV_ID__SHIFT                                                     0x0
#define BIF_CFG_DEV1_RC0_REVISION_ID__MAJOR_REV_ID__SHIFT                                                     0x4
#define BIF_CFG_DEV1_RC0_REVISION_ID__MINOR_REV_ID_MASK                                                       0x0FL
#define BIF_CFG_DEV1_RC0_REVISION_ID__MAJOR_REV_ID_MASK                                                       0xF0L
//BIF_CFG_DEV1_RC0_PROG_INTERFACE
#define BIF_CFG_DEV1_RC0_PROG_INTERFACE__PROG_INTERFACE__SHIFT                                                0x0
#define BIF_CFG_DEV1_RC0_PROG_INTERFACE__PROG_INTERFACE_MASK                                                  0xFFL
//BIF_CFG_DEV1_RC0_SUB_CLASS
#define BIF_CFG_DEV1_RC0_SUB_CLASS__SUB_CLASS__SHIFT                                                          0x0
#define BIF_CFG_DEV1_RC0_SUB_CLASS__SUB_CLASS_MASK                                                            0xFFL
//BIF_CFG_DEV1_RC0_BASE_CLASS
#define BIF_CFG_DEV1_RC0_BASE_CLASS__BASE_CLASS__SHIFT                                                        0x0
#define BIF_CFG_DEV1_RC0_BASE_CLASS__BASE_CLASS_MASK                                                          0xFFL
//BIF_CFG_DEV1_RC0_CACHE_LINE
#define BIF_CFG_DEV1_RC0_CACHE_LINE__CACHE_LINE_SIZE__SHIFT                                                   0x0
#define BIF_CFG_DEV1_RC0_CACHE_LINE__CACHE_LINE_SIZE_MASK                                                     0xFFL
//BIF_CFG_DEV1_RC0_LATENCY
#define BIF_CFG_DEV1_RC0_LATENCY__LATENCY_TIMER__SHIFT                                                        0x0
#define BIF_CFG_DEV1_RC0_LATENCY__LATENCY_TIMER_MASK                                                          0xFFL
//BIF_CFG_DEV1_RC0_HEADER
#define BIF_CFG_DEV1_RC0_HEADER__HEADER_TYPE__SHIFT                                                           0x0
#define BIF_CFG_DEV1_RC0_HEADER__DEVICE_TYPE__SHIFT                                                           0x7
#define BIF_CFG_DEV1_RC0_HEADER__HEADER_TYPE_MASK                                                             0x7FL
#define BIF_CFG_DEV1_RC0_HEADER__DEVICE_TYPE_MASK                                                             0x80L
//BIF_CFG_DEV1_RC0_BIST
#define BIF_CFG_DEV1_RC0_BIST__BIST_COMP__SHIFT                                                               0x0
#define BIF_CFG_DEV1_RC0_BIST__BIST_STRT__SHIFT                                                               0x6
#define BIF_CFG_DEV1_RC0_BIST__BIST_CAP__SHIFT                                                                0x7
#define BIF_CFG_DEV1_RC0_BIST__BIST_COMP_MASK                                                                 0x0FL
#define BIF_CFG_DEV1_RC0_BIST__BIST_STRT_MASK                                                                 0x40L
#define BIF_CFG_DEV1_RC0_BIST__BIST_CAP_MASK                                                                  0x80L
//BIF_CFG_DEV1_RC0_BASE_ADDR_1
#define BIF_CFG_DEV1_RC0_BASE_ADDR_1__BASE_ADDR__SHIFT                                                        0x0
#define BIF_CFG_DEV1_RC0_BASE_ADDR_1__BASE_ADDR_MASK                                                          0xFFFFFFFFL
//BIF_CFG_DEV1_RC0_SUB_BUS_NUMBER_LATENCY
#define BIF_CFG_DEV1_RC0_SUB_BUS_NUMBER_LATENCY__PRIMARY_BUS__SHIFT                                           0x0
#define BIF_CFG_DEV1_RC0_SUB_BUS_NUMBER_LATENCY__SECONDARY_BUS__SHIFT                                         0x8
#define BIF_CFG_DEV1_RC0_SUB_BUS_NUMBER_LATENCY__SUB_BUS_NUM__SHIFT                                           0x10
#define BIF_CFG_DEV1_RC0_SUB_BUS_NUMBER_LATENCY__SECONDARY_LATENCY_TIMER__SHIFT                               0x18
#define BIF_CFG_DEV1_RC0_SUB_BUS_NUMBER_LATENCY__PRIMARY_BUS_MASK                                             0x000000FFL
#define BIF_CFG_DEV1_RC0_SUB_BUS_NUMBER_LATENCY__SECONDARY_BUS_MASK                                           0x0000FF00L
#define BIF_CFG_DEV1_RC0_SUB_BUS_NUMBER_LATENCY__SUB_BUS_NUM_MASK                                             0x00FF0000L
#define BIF_CFG_DEV1_RC0_SUB_BUS_NUMBER_LATENCY__SECONDARY_LATENCY_TIMER_MASK                                 0xFF000000L
//BIF_CFG_DEV1_RC0_IO_BASE_LIMIT
#define BIF_CFG_DEV1_RC0_IO_BASE_LIMIT__IO_BASE_TYPE__SHIFT                                                   0x0
#define BIF_CFG_DEV1_RC0_IO_BASE_LIMIT__IO_BASE__SHIFT                                                        0x4
#define BIF_CFG_DEV1_RC0_IO_BASE_LIMIT__IO_LIMIT_TYPE__SHIFT                                                  0x8
#define BIF_CFG_DEV1_RC0_IO_BASE_LIMIT__IO_LIMIT__SHIFT                                                       0xc
#define BIF_CFG_DEV1_RC0_IO_BASE_LIMIT__IO_BASE_TYPE_MASK                                                     0x000FL
#define BIF_CFG_DEV1_RC0_IO_BASE_LIMIT__IO_BASE_MASK                                                          0x00F0L
#define BIF_CFG_DEV1_RC0_IO_BASE_LIMIT__IO_LIMIT_TYPE_MASK                                                    0x0F00L
#define BIF_CFG_DEV1_RC0_IO_BASE_LIMIT__IO_LIMIT_MASK                                                         0xF000L
//BIF_CFG_DEV1_RC0_SECONDARY_STATUS
#define BIF_CFG_DEV1_RC0_SECONDARY_STATUS__CAP_LIST__SHIFT                                                    0x4
#define BIF_CFG_DEV1_RC0_SECONDARY_STATUS__PCI_66_EN__SHIFT                                                   0x5
#define BIF_CFG_DEV1_RC0_SECONDARY_STATUS__FAST_BACK_CAPABLE__SHIFT                                           0x7
#define BIF_CFG_DEV1_RC0_SECONDARY_STATUS__MASTER_DATA_PARITY_ERROR__SHIFT                                    0x8
#define BIF_CFG_DEV1_RC0_SECONDARY_STATUS__DEVSEL_TIMING__SHIFT                                               0x9
#define BIF_CFG_DEV1_RC0_SECONDARY_STATUS__SIGNAL_TARGET_ABORT__SHIFT                                         0xb
#define BIF_CFG_DEV1_RC0_SECONDARY_STATUS__RECEIVED_TARGET_ABORT__SHIFT                                       0xc
#define BIF_CFG_DEV1_RC0_SECONDARY_STATUS__RECEIVED_MASTER_ABORT__SHIFT                                       0xd
#define BIF_CFG_DEV1_RC0_SECONDARY_STATUS__RECEIVED_SYSTEM_ERROR__SHIFT                                       0xe
#define BIF_CFG_DEV1_RC0_SECONDARY_STATUS__PARITY_ERROR_DETECTED__SHIFT                                       0xf
#define BIF_CFG_DEV1_RC0_SECONDARY_STATUS__CAP_LIST_MASK                                                      0x0010L
#define BIF_CFG_DEV1_RC0_SECONDARY_STATUS__PCI_66_EN_MASK                                                     0x0020L
#define BIF_CFG_DEV1_RC0_SECONDARY_STATUS__FAST_BACK_CAPABLE_MASK                                             0x0080L
#define BIF_CFG_DEV1_RC0_SECONDARY_STATUS__MASTER_DATA_PARITY_ERROR_MASK                                      0x0100L
#define BIF_CFG_DEV1_RC0_SECONDARY_STATUS__DEVSEL_TIMING_MASK                                                 0x0600L
#define BIF_CFG_DEV1_RC0_SECONDARY_STATUS__SIGNAL_TARGET_ABORT_MASK                                           0x0800L
#define BIF_CFG_DEV1_RC0_SECONDARY_STATUS__RECEIVED_TARGET_ABORT_MASK                                         0x1000L
#define BIF_CFG_DEV1_RC0_SECONDARY_STATUS__RECEIVED_MASTER_ABORT_MASK                                         0x2000L
#define BIF_CFG_DEV1_RC0_SECONDARY_STATUS__RECEIVED_SYSTEM_ERROR_MASK                                         0x4000L
#define BIF_CFG_DEV1_RC0_SECONDARY_STATUS__PARITY_ERROR_DETECTED_MASK                                         0x8000L
//BIF_CFG_DEV1_RC0_MEM_BASE_LIMIT
#define BIF_CFG_DEV1_RC0_MEM_BASE_LIMIT__MEM_BASE_TYPE__SHIFT                                                 0x0
#define BIF_CFG_DEV1_RC0_MEM_BASE_LIMIT__MEM_BASE_31_20__SHIFT                                                0x4
#define BIF_CFG_DEV1_RC0_MEM_BASE_LIMIT__MEM_LIMIT_TYPE__SHIFT                                                0x10
#define BIF_CFG_DEV1_RC0_MEM_BASE_LIMIT__MEM_LIMIT_31_20__SHIFT                                               0x14
#define BIF_CFG_DEV1_RC0_MEM_BASE_LIMIT__MEM_BASE_TYPE_MASK                                                   0x0000000FL
#define BIF_CFG_DEV1_RC0_MEM_BASE_LIMIT__MEM_BASE_31_20_MASK                                                  0x0000FFF0L
#define BIF_CFG_DEV1_RC0_MEM_BASE_LIMIT__MEM_LIMIT_TYPE_MASK                                                  0x000F0000L
#define BIF_CFG_DEV1_RC0_MEM_BASE_LIMIT__MEM_LIMIT_31_20_MASK                                                 0xFFF00000L
//BIF_CFG_DEV1_RC0_PREF_BASE_LIMIT
#define BIF_CFG_DEV1_RC0_PREF_BASE_LIMIT__PREF_MEM_BASE_TYPE__SHIFT                                           0x0
#define BIF_CFG_DEV1_RC0_PREF_BASE_LIMIT__PREF_MEM_BASE_31_20__SHIFT                                          0x4
#define BIF_CFG_DEV1_RC0_PREF_BASE_LIMIT__PREF_MEM_LIMIT_TYPE__SHIFT                                          0x10
#define BIF_CFG_DEV1_RC0_PREF_BASE_LIMIT__PREF_MEM_LIMIT_31_20__SHIFT                                         0x14
#define BIF_CFG_DEV1_RC0_PREF_BASE_LIMIT__PREF_MEM_BASE_TYPE_MASK                                             0x0000000FL
#define BIF_CFG_DEV1_RC0_PREF_BASE_LIMIT__PREF_MEM_BASE_31_20_MASK                                            0x0000FFF0L
#define BIF_CFG_DEV1_RC0_PREF_BASE_LIMIT__PREF_MEM_LIMIT_TYPE_MASK                                            0x000F0000L
#define BIF_CFG_DEV1_RC0_PREF_BASE_LIMIT__PREF_MEM_LIMIT_31_20_MASK                                           0xFFF00000L
//BIF_CFG_DEV1_RC0_PREF_BASE_UPPER
#define BIF_CFG_DEV1_RC0_PREF_BASE_UPPER__PREF_BASE_UPPER__SHIFT                                              0x0
#define BIF_CFG_DEV1_RC0_PREF_BASE_UPPER__PREF_BASE_UPPER_MASK                                                0xFFFFFFFFL
//BIF_CFG_DEV1_RC0_PREF_LIMIT_UPPER
#define BIF_CFG_DEV1_RC0_PREF_LIMIT_UPPER__PREF_LIMIT_UPPER__SHIFT                                            0x0
#define BIF_CFG_DEV1_RC0_PREF_LIMIT_UPPER__PREF_LIMIT_UPPER_MASK                                              0xFFFFFFFFL
//BIF_CFG_DEV1_RC0_IO_BASE_LIMIT_HI
#define BIF_CFG_DEV1_RC0_IO_BASE_LIMIT_HI__IO_BASE_31_16__SHIFT                                               0x0
#define BIF_CFG_DEV1_RC0_IO_BASE_LIMIT_HI__IO_LIMIT_31_16__SHIFT                                              0x10
#define BIF_CFG_DEV1_RC0_IO_BASE_LIMIT_HI__IO_BASE_31_16_MASK                                                 0x0000FFFFL
#define BIF_CFG_DEV1_RC0_IO_BASE_LIMIT_HI__IO_LIMIT_31_16_MASK                                                0xFFFF0000L
//BIF_CFG_DEV1_RC0_CAP_PTR
#define BIF_CFG_DEV1_RC0_CAP_PTR__CAP_PTR__SHIFT                                                              0x0
#define BIF_CFG_DEV1_RC0_CAP_PTR__CAP_PTR_MASK                                                                0x000000FFL
//BIF_CFG_DEV1_RC0_INTERRUPT_LINE
#define BIF_CFG_DEV1_RC0_INTERRUPT_LINE__INTERRUPT_LINE__SHIFT                                                0x0
#define BIF_CFG_DEV1_RC0_INTERRUPT_LINE__INTERRUPT_LINE_MASK                                                  0xFFL
//BIF_CFG_DEV1_RC0_INTERRUPT_PIN
#define BIF_CFG_DEV1_RC0_INTERRUPT_PIN__INTERRUPT_PIN__SHIFT                                                  0x0
#define BIF_CFG_DEV1_RC0_INTERRUPT_PIN__INTERRUPT_PIN_MASK                                                    0xFFL
//BIF_CFG_DEV1_RC0_IRQ_BRIDGE_CNTL
#define BIF_CFG_DEV1_RC0_IRQ_BRIDGE_CNTL__PARITY_RESPONSE_EN__SHIFT                                           0x0
#define BIF_CFG_DEV1_RC0_IRQ_BRIDGE_CNTL__SERR_EN__SHIFT                                                      0x1
#define BIF_CFG_DEV1_RC0_IRQ_BRIDGE_CNTL__ISA_EN__SHIFT                                                       0x2
#define BIF_CFG_DEV1_RC0_IRQ_BRIDGE_CNTL__VGA_EN__SHIFT                                                       0x3
#define BIF_CFG_DEV1_RC0_IRQ_BRIDGE_CNTL__VGA_DEC__SHIFT                                                      0x4
#define BIF_CFG_DEV1_RC0_IRQ_BRIDGE_CNTL__MASTER_ABORT_MODE__SHIFT                                            0x5
#define BIF_CFG_DEV1_RC0_IRQ_BRIDGE_CNTL__SECONDARY_BUS_RESET__SHIFT                                          0x6
#define BIF_CFG_DEV1_RC0_IRQ_BRIDGE_CNTL__FAST_B2B_EN__SHIFT                                                  0x7
#define BIF_CFG_DEV1_RC0_IRQ_BRIDGE_CNTL__PARITY_RESPONSE_EN_MASK                                             0x0001L
#define BIF_CFG_DEV1_RC0_IRQ_BRIDGE_CNTL__SERR_EN_MASK                                                        0x0002L
#define BIF_CFG_DEV1_RC0_IRQ_BRIDGE_CNTL__ISA_EN_MASK                                                         0x0004L
#define BIF_CFG_DEV1_RC0_IRQ_BRIDGE_CNTL__VGA_EN_MASK                                                         0x0008L
#define BIF_CFG_DEV1_RC0_IRQ_BRIDGE_CNTL__VGA_DEC_MASK                                                        0x0010L
#define BIF_CFG_DEV1_RC0_IRQ_BRIDGE_CNTL__MASTER_ABORT_MODE_MASK                                              0x0020L
#define BIF_CFG_DEV1_RC0_IRQ_BRIDGE_CNTL__SECONDARY_BUS_RESET_MASK                                            0x0040L
#define BIF_CFG_DEV1_RC0_IRQ_BRIDGE_CNTL__FAST_B2B_EN_MASK                                                    0x0080L
//BIF_CFG_DEV1_RC0_EXT_BRIDGE_CNTL
#define BIF_CFG_DEV1_RC0_EXT_BRIDGE_CNTL__IO_PORT_80_EN__SHIFT                                                0x0
#define BIF_CFG_DEV1_RC0_EXT_BRIDGE_CNTL__IO_PORT_80_EN_MASK                                                  0x01L
//BIF_CFG_DEV1_RC0_PMI_CAP_LIST
#define BIF_CFG_DEV1_RC0_PMI_CAP_LIST__CAP_ID__SHIFT                                                          0x0
#define BIF_CFG_DEV1_RC0_PMI_CAP_LIST__NEXT_PTR__SHIFT                                                        0x8
#define BIF_CFG_DEV1_RC0_PMI_CAP_LIST__CAP_ID_MASK                                                            0x00FFL
#define BIF_CFG_DEV1_RC0_PMI_CAP_LIST__NEXT_PTR_MASK                                                          0xFF00L
//BIF_CFG_DEV1_RC0_PMI_CAP
#define BIF_CFG_DEV1_RC0_PMI_CAP__VERSION__SHIFT                                                              0x0
#define BIF_CFG_DEV1_RC0_PMI_CAP__PME_CLOCK__SHIFT                                                            0x3
#define BIF_CFG_DEV1_RC0_PMI_CAP__DEV_SPECIFIC_INIT__SHIFT                                                    0x5
#define BIF_CFG_DEV1_RC0_PMI_CAP__AUX_CURRENT__SHIFT                                                          0x6
#define BIF_CFG_DEV1_RC0_PMI_CAP__D1_SUPPORT__SHIFT                                                           0x9
#define BIF_CFG_DEV1_RC0_PMI_CAP__D2_SUPPORT__SHIFT                                                           0xa
#define BIF_CFG_DEV1_RC0_PMI_CAP__PME_SUPPORT__SHIFT                                                          0xb
#define BIF_CFG_DEV1_RC0_PMI_CAP__VERSION_MASK                                                                0x0007L
#define BIF_CFG_DEV1_RC0_PMI_CAP__PME_CLOCK_MASK                                                              0x0008L
#define BIF_CFG_DEV1_RC0_PMI_CAP__DEV_SPECIFIC_INIT_MASK                                                      0x0020L
#define BIF_CFG_DEV1_RC0_PMI_CAP__AUX_CURRENT_MASK                                                            0x01C0L
#define BIF_CFG_DEV1_RC0_PMI_CAP__D1_SUPPORT_MASK                                                             0x0200L
#define BIF_CFG_DEV1_RC0_PMI_CAP__D2_SUPPORT_MASK                                                             0x0400L
#define BIF_CFG_DEV1_RC0_PMI_CAP__PME_SUPPORT_MASK                                                            0xF800L
//BIF_CFG_DEV1_RC0_PMI_STATUS_CNTL
#define BIF_CFG_DEV1_RC0_PMI_STATUS_CNTL__POWER_STATE__SHIFT                                                  0x0
#define BIF_CFG_DEV1_RC0_PMI_STATUS_CNTL__NO_SOFT_RESET__SHIFT                                                0x3
#define BIF_CFG_DEV1_RC0_PMI_STATUS_CNTL__PME_EN__SHIFT                                                       0x8
#define BIF_CFG_DEV1_RC0_PMI_STATUS_CNTL__DATA_SELECT__SHIFT                                                  0x9
#define BIF_CFG_DEV1_RC0_PMI_STATUS_CNTL__DATA_SCALE__SHIFT                                                   0xd
#define BIF_CFG_DEV1_RC0_PMI_STATUS_CNTL__PME_STATUS__SHIFT                                                   0xf
#define BIF_CFG_DEV1_RC0_PMI_STATUS_CNTL__B2_B3_SUPPORT__SHIFT                                                0x16
#define BIF_CFG_DEV1_RC0_PMI_STATUS_CNTL__BUS_PWR_EN__SHIFT                                                   0x17
#define BIF_CFG_DEV1_RC0_PMI_STATUS_CNTL__PMI_DATA__SHIFT                                                     0x18
#define BIF_CFG_DEV1_RC0_PMI_STATUS_CNTL__POWER_STATE_MASK                                                    0x00000003L
#define BIF_CFG_DEV1_RC0_PMI_STATUS_CNTL__NO_SOFT_RESET_MASK                                                  0x00000008L
#define BIF_CFG_DEV1_RC0_PMI_STATUS_CNTL__PME_EN_MASK                                                         0x00000100L
#define BIF_CFG_DEV1_RC0_PMI_STATUS_CNTL__DATA_SELECT_MASK                                                    0x00001E00L
#define BIF_CFG_DEV1_RC0_PMI_STATUS_CNTL__DATA_SCALE_MASK                                                     0x00006000L
#define BIF_CFG_DEV1_RC0_PMI_STATUS_CNTL__PME_STATUS_MASK                                                     0x00008000L
#define BIF_CFG_DEV1_RC0_PMI_STATUS_CNTL__B2_B3_SUPPORT_MASK                                                  0x00400000L
#define BIF_CFG_DEV1_RC0_PMI_STATUS_CNTL__BUS_PWR_EN_MASK                                                     0x00800000L
#define BIF_CFG_DEV1_RC0_PMI_STATUS_CNTL__PMI_DATA_MASK                                                       0xFF000000L
//BIF_CFG_DEV1_RC0_PCIE_CAP_LIST
#define BIF_CFG_DEV1_RC0_PCIE_CAP_LIST__CAP_ID__SHIFT                                                         0x0
#define BIF_CFG_DEV1_RC0_PCIE_CAP_LIST__NEXT_PTR__SHIFT                                                       0x8
#define BIF_CFG_DEV1_RC0_PCIE_CAP_LIST__CAP_ID_MASK                                                           0x00FFL
#define BIF_CFG_DEV1_RC0_PCIE_CAP_LIST__NEXT_PTR_MASK                                                         0xFF00L
//BIF_CFG_DEV1_RC0_PCIE_CAP
#define BIF_CFG_DEV1_RC0_PCIE_CAP__VERSION__SHIFT                                                             0x0
#define BIF_CFG_DEV1_RC0_PCIE_CAP__DEVICE_TYPE__SHIFT                                                         0x4
#define BIF_CFG_DEV1_RC0_PCIE_CAP__SLOT_IMPLEMENTED__SHIFT                                                    0x8
#define BIF_CFG_DEV1_RC0_PCIE_CAP__INT_MESSAGE_NUM__SHIFT                                                     0x9
#define BIF_CFG_DEV1_RC0_PCIE_CAP__VERSION_MASK                                                               0x000FL
#define BIF_CFG_DEV1_RC0_PCIE_CAP__DEVICE_TYPE_MASK                                                           0x00F0L
#define BIF_CFG_DEV1_RC0_PCIE_CAP__SLOT_IMPLEMENTED_MASK                                                      0x0100L
#define BIF_CFG_DEV1_RC0_PCIE_CAP__INT_MESSAGE_NUM_MASK                                                       0x3E00L
//BIF_CFG_DEV1_RC0_DEVICE_CAP
#define BIF_CFG_DEV1_RC0_DEVICE_CAP__MAX_PAYLOAD_SUPPORT__SHIFT                                               0x0
#define BIF_CFG_DEV1_RC0_DEVICE_CAP__PHANTOM_FUNC__SHIFT                                                      0x3
#define BIF_CFG_DEV1_RC0_DEVICE_CAP__EXTENDED_TAG__SHIFT                                                      0x5
#define BIF_CFG_DEV1_RC0_DEVICE_CAP__L0S_ACCEPTABLE_LATENCY__SHIFT                                            0x6
#define BIF_CFG_DEV1_RC0_DEVICE_CAP__L1_ACCEPTABLE_LATENCY__SHIFT                                             0x9
#define BIF_CFG_DEV1_RC0_DEVICE_CAP__ROLE_BASED_ERR_REPORTING__SHIFT                                          0xf
#define BIF_CFG_DEV1_RC0_DEVICE_CAP__CAPTURED_SLOT_POWER_LIMIT__SHIFT                                         0x12
#define BIF_CFG_DEV1_RC0_DEVICE_CAP__CAPTURED_SLOT_POWER_SCALE__SHIFT                                         0x1a
#define BIF_CFG_DEV1_RC0_DEVICE_CAP__FLR_CAPABLE__SHIFT                                                       0x1c
#define BIF_CFG_DEV1_RC0_DEVICE_CAP__MAX_PAYLOAD_SUPPORT_MASK                                                 0x00000007L
#define BIF_CFG_DEV1_RC0_DEVICE_CAP__PHANTOM_FUNC_MASK                                                        0x00000018L
#define BIF_CFG_DEV1_RC0_DEVICE_CAP__EXTENDED_TAG_MASK                                                        0x00000020L
#define BIF_CFG_DEV1_RC0_DEVICE_CAP__L0S_ACCEPTABLE_LATENCY_MASK                                              0x000001C0L
#define BIF_CFG_DEV1_RC0_DEVICE_CAP__L1_ACCEPTABLE_LATENCY_MASK                                               0x00000E00L
#define BIF_CFG_DEV1_RC0_DEVICE_CAP__ROLE_BASED_ERR_REPORTING_MASK                                            0x00008000L
#define BIF_CFG_DEV1_RC0_DEVICE_CAP__CAPTURED_SLOT_POWER_LIMIT_MASK                                           0x03FC0000L
#define BIF_CFG_DEV1_RC0_DEVICE_CAP__CAPTURED_SLOT_POWER_SCALE_MASK                                           0x0C000000L
#define BIF_CFG_DEV1_RC0_DEVICE_CAP__FLR_CAPABLE_MASK                                                         0x10000000L
//BIF_CFG_DEV1_RC0_DEVICE_CNTL
#define BIF_CFG_DEV1_RC0_DEVICE_CNTL__CORR_ERR_EN__SHIFT                                                      0x0
#define BIF_CFG_DEV1_RC0_DEVICE_CNTL__NON_FATAL_ERR_EN__SHIFT                                                 0x1
#define BIF_CFG_DEV1_RC0_DEVICE_CNTL__FATAL_ERR_EN__SHIFT                                                     0x2
#define BIF_CFG_DEV1_RC0_DEVICE_CNTL__USR_REPORT_EN__SHIFT                                                    0x3
#define BIF_CFG_DEV1_RC0_DEVICE_CNTL__RELAXED_ORD_EN__SHIFT                                                   0x4
#define BIF_CFG_DEV1_RC0_DEVICE_CNTL__MAX_PAYLOAD_SIZE__SHIFT                                                 0x5
#define BIF_CFG_DEV1_RC0_DEVICE_CNTL__EXTENDED_TAG_EN__SHIFT                                                  0x8
#define BIF_CFG_DEV1_RC0_DEVICE_CNTL__PHANTOM_FUNC_EN__SHIFT                                                  0x9
#define BIF_CFG_DEV1_RC0_DEVICE_CNTL__AUX_POWER_PM_EN__SHIFT                                                  0xa
#define BIF_CFG_DEV1_RC0_DEVICE_CNTL__NO_SNOOP_EN__SHIFT                                                      0xb
#define BIF_CFG_DEV1_RC0_DEVICE_CNTL__MAX_READ_REQUEST_SIZE__SHIFT                                            0xc
#define BIF_CFG_DEV1_RC0_DEVICE_CNTL__BRIDGE_CFG_RETRY_EN__SHIFT                                              0xf
#define BIF_CFG_DEV1_RC0_DEVICE_CNTL__CORR_ERR_EN_MASK                                                        0x0001L
#define BIF_CFG_DEV1_RC0_DEVICE_CNTL__NON_FATAL_ERR_EN_MASK                                                   0x0002L
#define BIF_CFG_DEV1_RC0_DEVICE_CNTL__FATAL_ERR_EN_MASK                                                       0x0004L
#define BIF_CFG_DEV1_RC0_DEVICE_CNTL__USR_REPORT_EN_MASK                                                      0x0008L
#define BIF_CFG_DEV1_RC0_DEVICE_CNTL__RELAXED_ORD_EN_MASK                                                     0x0010L
#define BIF_CFG_DEV1_RC0_DEVICE_CNTL__MAX_PAYLOAD_SIZE_MASK                                                   0x00E0L
#define BIF_CFG_DEV1_RC0_DEVICE_CNTL__EXTENDED_TAG_EN_MASK                                                    0x0100L
#define BIF_CFG_DEV1_RC0_DEVICE_CNTL__PHANTOM_FUNC_EN_MASK                                                    0x0200L
#define BIF_CFG_DEV1_RC0_DEVICE_CNTL__AUX_POWER_PM_EN_MASK                                                    0x0400L
#define BIF_CFG_DEV1_RC0_DEVICE_CNTL__NO_SNOOP_EN_MASK                                                        0x0800L
#define BIF_CFG_DEV1_RC0_DEVICE_CNTL__MAX_READ_REQUEST_SIZE_MASK                                              0x7000L
#define BIF_CFG_DEV1_RC0_DEVICE_CNTL__BRIDGE_CFG_RETRY_EN_MASK                                                0x8000L
//BIF_CFG_DEV1_RC0_DEVICE_STATUS
#define BIF_CFG_DEV1_RC0_DEVICE_STATUS__CORR_ERR__SHIFT                                                       0x0
#define BIF_CFG_DEV1_RC0_DEVICE_STATUS__NON_FATAL_ERR__SHIFT                                                  0x1
#define BIF_CFG_DEV1_RC0_DEVICE_STATUS__FATAL_ERR__SHIFT                                                      0x2
#define BIF_CFG_DEV1_RC0_DEVICE_STATUS__USR_DETECTED__SHIFT                                                   0x3
#define BIF_CFG_DEV1_RC0_DEVICE_STATUS__AUX_PWR__SHIFT                                                        0x4
#define BIF_CFG_DEV1_RC0_DEVICE_STATUS__TRANSACTIONS_PEND__SHIFT                                              0x5
#define BIF_CFG_DEV1_RC0_DEVICE_STATUS__CORR_ERR_MASK                                                         0x0001L
#define BIF_CFG_DEV1_RC0_DEVICE_STATUS__NON_FATAL_ERR_MASK                                                    0x0002L
#define BIF_CFG_DEV1_RC0_DEVICE_STATUS__FATAL_ERR_MASK                                                        0x0004L
#define BIF_CFG_DEV1_RC0_DEVICE_STATUS__USR_DETECTED_MASK                                                     0x0008L
#define BIF_CFG_DEV1_RC0_DEVICE_STATUS__AUX_PWR_MASK                                                          0x0010L
#define BIF_CFG_DEV1_RC0_DEVICE_STATUS__TRANSACTIONS_PEND_MASK                                                0x0020L
//BIF_CFG_DEV1_RC0_LINK_CAP
#define BIF_CFG_DEV1_RC0_LINK_CAP__LINK_SPEED__SHIFT                                                          0x0
#define BIF_CFG_DEV1_RC0_LINK_CAP__LINK_WIDTH__SHIFT                                                          0x4
#define BIF_CFG_DEV1_RC0_LINK_CAP__PM_SUPPORT__SHIFT                                                          0xa
#define BIF_CFG_DEV1_RC0_LINK_CAP__L0S_EXIT_LATENCY__SHIFT                                                    0xc
#define BIF_CFG_DEV1_RC0_LINK_CAP__L1_EXIT_LATENCY__SHIFT                                                     0xf
#define BIF_CFG_DEV1_RC0_LINK_CAP__CLOCK_POWER_MANAGEMENT__SHIFT                                              0x12
#define BIF_CFG_DEV1_RC0_LINK_CAP__SURPRISE_DOWN_ERR_REPORTING__SHIFT                                         0x13
#define BIF_CFG_DEV1_RC0_LINK_CAP__DL_ACTIVE_REPORTING_CAPABLE__SHIFT                                         0x14
#define BIF_CFG_DEV1_RC0_LINK_CAP__LINK_BW_NOTIFICATION_CAP__SHIFT                                            0x15
#define BIF_CFG_DEV1_RC0_LINK_CAP__ASPM_OPTIONALITY_COMPLIANCE__SHIFT                                         0x16
#define BIF_CFG_DEV1_RC0_LINK_CAP__PORT_NUMBER__SHIFT                                                         0x18
#define BIF_CFG_DEV1_RC0_LINK_CAP__LINK_SPEED_MASK                                                            0x0000000FL
#define BIF_CFG_DEV1_RC0_LINK_CAP__LINK_WIDTH_MASK                                                            0x000003F0L
#define BIF_CFG_DEV1_RC0_LINK_CAP__PM_SUPPORT_MASK                                                            0x00000C00L
#define BIF_CFG_DEV1_RC0_LINK_CAP__L0S_EXIT_LATENCY_MASK                                                      0x00007000L
#define BIF_CFG_DEV1_RC0_LINK_CAP__L1_EXIT_LATENCY_MASK                                                       0x00038000L
#define BIF_CFG_DEV1_RC0_LINK_CAP__CLOCK_POWER_MANAGEMENT_MASK                                                0x00040000L
#define BIF_CFG_DEV1_RC0_LINK_CAP__SURPRISE_DOWN_ERR_REPORTING_MASK                                           0x00080000L
#define BIF_CFG_DEV1_RC0_LINK_CAP__DL_ACTIVE_REPORTING_CAPABLE_MASK                                           0x00100000L
#define BIF_CFG_DEV1_RC0_LINK_CAP__LINK_BW_NOTIFICATION_CAP_MASK                                              0x00200000L
#define BIF_CFG_DEV1_RC0_LINK_CAP__ASPM_OPTIONALITY_COMPLIANCE_MASK                                           0x00400000L
#define BIF_CFG_DEV1_RC0_LINK_CAP__PORT_NUMBER_MASK                                                           0xFF000000L
//BIF_CFG_DEV1_RC0_LINK_CNTL
#define BIF_CFG_DEV1_RC0_LINK_CNTL__PM_CONTROL__SHIFT                                                         0x0
#define BIF_CFG_DEV1_RC0_LINK_CNTL__READ_CPL_BOUNDARY__SHIFT                                                  0x3
#define BIF_CFG_DEV1_RC0_LINK_CNTL__LINK_DIS__SHIFT                                                           0x4
#define BIF_CFG_DEV1_RC0_LINK_CNTL__RETRAIN_LINK__SHIFT                                                       0x5
#define BIF_CFG_DEV1_RC0_LINK_CNTL__COMMON_CLOCK_CFG__SHIFT                                                   0x6
#define BIF_CFG_DEV1_RC0_LINK_CNTL__EXTENDED_SYNC__SHIFT                                                      0x7
#define BIF_CFG_DEV1_RC0_LINK_CNTL__CLOCK_POWER_MANAGEMENT_EN__SHIFT                                          0x8
#define BIF_CFG_DEV1_RC0_LINK_CNTL__HW_AUTONOMOUS_WIDTH_DISABLE__SHIFT                                        0x9
#define BIF_CFG_DEV1_RC0_LINK_CNTL__LINK_BW_MANAGEMENT_INT_EN__SHIFT                                          0xa
#define BIF_CFG_DEV1_RC0_LINK_CNTL__LINK_AUTONOMOUS_BW_INT_EN__SHIFT                                          0xb
#define BIF_CFG_DEV1_RC0_LINK_CNTL__PM_CONTROL_MASK                                                           0x0003L
#define BIF_CFG_DEV1_RC0_LINK_CNTL__READ_CPL_BOUNDARY_MASK                                                    0x0008L
#define BIF_CFG_DEV1_RC0_LINK_CNTL__LINK_DIS_MASK                                                             0x0010L
#define BIF_CFG_DEV1_RC0_LINK_CNTL__RETRAIN_LINK_MASK                                                         0x0020L
#define BIF_CFG_DEV1_RC0_LINK_CNTL__COMMON_CLOCK_CFG_MASK                                                     0x0040L
#define BIF_CFG_DEV1_RC0_LINK_CNTL__EXTENDED_SYNC_MASK                                                        0x0080L
#define BIF_CFG_DEV1_RC0_LINK_CNTL__CLOCK_POWER_MANAGEMENT_EN_MASK                                            0x0100L
#define BIF_CFG_DEV1_RC0_LINK_CNTL__HW_AUTONOMOUS_WIDTH_DISABLE_MASK                                          0x0200L
#define BIF_CFG_DEV1_RC0_LINK_CNTL__LINK_BW_MANAGEMENT_INT_EN_MASK                                            0x0400L
#define BIF_CFG_DEV1_RC0_LINK_CNTL__LINK_AUTONOMOUS_BW_INT_EN_MASK                                            0x0800L
//BIF_CFG_DEV1_RC0_LINK_STATUS
#define BIF_CFG_DEV1_RC0_LINK_STATUS__CURRENT_LINK_SPEED__SHIFT                                               0x0
#define BIF_CFG_DEV1_RC0_LINK_STATUS__NEGOTIATED_LINK_WIDTH__SHIFT                                            0x4
#define BIF_CFG_DEV1_RC0_LINK_STATUS__LINK_TRAINING__SHIFT                                                    0xb
#define BIF_CFG_DEV1_RC0_LINK_STATUS__SLOT_CLOCK_CFG__SHIFT                                                   0xc
#define BIF_CFG_DEV1_RC0_LINK_STATUS__DL_ACTIVE__SHIFT                                                        0xd
#define BIF_CFG_DEV1_RC0_LINK_STATUS__LINK_BW_MANAGEMENT_STATUS__SHIFT                                        0xe
#define BIF_CFG_DEV1_RC0_LINK_STATUS__LINK_AUTONOMOUS_BW_STATUS__SHIFT                                        0xf
#define BIF_CFG_DEV1_RC0_LINK_STATUS__CURRENT_LINK_SPEED_MASK                                                 0x000FL
#define BIF_CFG_DEV1_RC0_LINK_STATUS__NEGOTIATED_LINK_WIDTH_MASK                                              0x03F0L
#define BIF_CFG_DEV1_RC0_LINK_STATUS__LINK_TRAINING_MASK                                                      0x0800L
#define BIF_CFG_DEV1_RC0_LINK_STATUS__SLOT_CLOCK_CFG_MASK                                                     0x1000L
#define BIF_CFG_DEV1_RC0_LINK_STATUS__DL_ACTIVE_MASK                                                          0x2000L
#define BIF_CFG_DEV1_RC0_LINK_STATUS__LINK_BW_MANAGEMENT_STATUS_MASK                                          0x4000L
#define BIF_CFG_DEV1_RC0_LINK_STATUS__LINK_AUTONOMOUS_BW_STATUS_MASK                                          0x8000L
//BIF_CFG_DEV1_RC0_SLOT_CAP
#define BIF_CFG_DEV1_RC0_SLOT_CAP__ATTN_BUTTON_PRESENT__SHIFT                                                 0x0
#define BIF_CFG_DEV1_RC0_SLOT_CAP__PWR_CONTROLLER_PRESENT__SHIFT                                              0x1
#define BIF_CFG_DEV1_RC0_SLOT_CAP__MRL_SENSOR_PRESENT__SHIFT                                                  0x2
#define BIF_CFG_DEV1_RC0_SLOT_CAP__ATTN_INDICATOR_PRESENT__SHIFT                                              0x3
#define BIF_CFG_DEV1_RC0_SLOT_CAP__PWR_INDICATOR_PRESENT__SHIFT                                               0x4
#define BIF_CFG_DEV1_RC0_SLOT_CAP__HOTPLUG_SURPRISE__SHIFT                                                    0x5
#define BIF_CFG_DEV1_RC0_SLOT_CAP__HOTPLUG_CAPABLE__SHIFT                                                     0x6
#define BIF_CFG_DEV1_RC0_SLOT_CAP__SLOT_PWR_LIMIT_VALUE__SHIFT                                                0x7
#define BIF_CFG_DEV1_RC0_SLOT_CAP__SLOT_PWR_LIMIT_SCALE__SHIFT                                                0xf
#define BIF_CFG_DEV1_RC0_SLOT_CAP__ELECTROMECH_INTERLOCK_PRESENT__SHIFT                                       0x11
#define BIF_CFG_DEV1_RC0_SLOT_CAP__NO_COMMAND_COMPLETED_SUPPORTED__SHIFT                                      0x12
#define BIF_CFG_DEV1_RC0_SLOT_CAP__PHYSICAL_SLOT_NUM__SHIFT                                                   0x13
#define BIF_CFG_DEV1_RC0_SLOT_CAP__ATTN_BUTTON_PRESENT_MASK                                                   0x00000001L
#define BIF_CFG_DEV1_RC0_SLOT_CAP__PWR_CONTROLLER_PRESENT_MASK                                                0x00000002L
#define BIF_CFG_DEV1_RC0_SLOT_CAP__MRL_SENSOR_PRESENT_MASK                                                    0x00000004L
#define BIF_CFG_DEV1_RC0_SLOT_CAP__ATTN_INDICATOR_PRESENT_MASK                                                0x00000008L
#define BIF_CFG_DEV1_RC0_SLOT_CAP__PWR_INDICATOR_PRESENT_MASK                                                 0x00000010L
#define BIF_CFG_DEV1_RC0_SLOT_CAP__HOTPLUG_SURPRISE_MASK                                                      0x00000020L
#define BIF_CFG_DEV1_RC0_SLOT_CAP__HOTPLUG_CAPABLE_MASK                                                       0x00000040L
#define BIF_CFG_DEV1_RC0_SLOT_CAP__SLOT_PWR_LIMIT_VALUE_MASK                                                  0x00007F80L
#define BIF_CFG_DEV1_RC0_SLOT_CAP__SLOT_PWR_LIMIT_SCALE_MASK                                                  0x00018000L
#define BIF_CFG_DEV1_RC0_SLOT_CAP__ELECTROMECH_INTERLOCK_PRESENT_MASK                                         0x00020000L
#define BIF_CFG_DEV1_RC0_SLOT_CAP__NO_COMMAND_COMPLETED_SUPPORTED_MASK                                        0x00040000L
#define BIF_CFG_DEV1_RC0_SLOT_CAP__PHYSICAL_SLOT_NUM_MASK                                                     0xFFF80000L
//BIF_CFG_DEV1_RC0_SLOT_CNTL
#define BIF_CFG_DEV1_RC0_SLOT_CNTL__ATTN_BUTTON_PRESSED_EN__SHIFT                                             0x0
#define BIF_CFG_DEV1_RC0_SLOT_CNTL__PWR_FAULT_DETECTED_EN__SHIFT                                              0x1
#define BIF_CFG_DEV1_RC0_SLOT_CNTL__MRL_SENSOR_CHANGED_EN__SHIFT                                              0x2
#define BIF_CFG_DEV1_RC0_SLOT_CNTL__PRESENCE_DETECT_CHANGED_EN__SHIFT                                         0x3
#define BIF_CFG_DEV1_RC0_SLOT_CNTL__COMMAND_COMPLETED_INTR_EN__SHIFT                                          0x4
#define BIF_CFG_DEV1_RC0_SLOT_CNTL__HOTPLUG_INTR_EN__SHIFT                                                    0x5
#define BIF_CFG_DEV1_RC0_SLOT_CNTL__ATTN_INDICATOR_CNTL__SHIFT                                                0x6
#define BIF_CFG_DEV1_RC0_SLOT_CNTL__PWR_INDICATOR_CNTL__SHIFT                                                 0x8
#define BIF_CFG_DEV1_RC0_SLOT_CNTL__PWR_CONTROLLER_CNTL__SHIFT                                                0xa
#define BIF_CFG_DEV1_RC0_SLOT_CNTL__ELECTROMECH_INTERLOCK_CNTL__SHIFT                                         0xb
#define BIF_CFG_DEV1_RC0_SLOT_CNTL__DL_STATE_CHANGED_EN__SHIFT                                                0xc
#define BIF_CFG_DEV1_RC0_SLOT_CNTL__ATTN_BUTTON_PRESSED_EN_MASK                                               0x0001L
#define BIF_CFG_DEV1_RC0_SLOT_CNTL__PWR_FAULT_DETECTED_EN_MASK                                                0x0002L
#define BIF_CFG_DEV1_RC0_SLOT_CNTL__MRL_SENSOR_CHANGED_EN_MASK                                                0x0004L
#define BIF_CFG_DEV1_RC0_SLOT_CNTL__PRESENCE_DETECT_CHANGED_EN_MASK                                           0x0008L
#define BIF_CFG_DEV1_RC0_SLOT_CNTL__COMMAND_COMPLETED_INTR_EN_MASK                                            0x0010L
#define BIF_CFG_DEV1_RC0_SLOT_CNTL__HOTPLUG_INTR_EN_MASK                                                      0x0020L
#define BIF_CFG_DEV1_RC0_SLOT_CNTL__ATTN_INDICATOR_CNTL_MASK                                                  0x00C0L
#define BIF_CFG_DEV1_RC0_SLOT_CNTL__PWR_INDICATOR_CNTL_MASK                                                   0x0300L
#define BIF_CFG_DEV1_RC0_SLOT_CNTL__PWR_CONTROLLER_CNTL_MASK                                                  0x0400L
#define BIF_CFG_DEV1_RC0_SLOT_CNTL__ELECTROMECH_INTERLOCK_CNTL_MASK                                           0x0800L
#define BIF_CFG_DEV1_RC0_SLOT_CNTL__DL_STATE_CHANGED_EN_MASK                                                  0x1000L
//BIF_CFG_DEV1_RC0_SLOT_STATUS
#define BIF_CFG_DEV1_RC0_SLOT_STATUS__ATTN_BUTTON_PRESSED__SHIFT                                              0x0
#define BIF_CFG_DEV1_RC0_SLOT_STATUS__PWR_FAULT_DETECTED__SHIFT                                               0x1
#define BIF_CFG_DEV1_RC0_SLOT_STATUS__MRL_SENSOR_CHANGED__SHIFT                                               0x2
#define BIF_CFG_DEV1_RC0_SLOT_STATUS__PRESENCE_DETECT_CHANGED__SHIFT                                          0x3
#define BIF_CFG_DEV1_RC0_SLOT_STATUS__COMMAND_COMPLETED__SHIFT                                                0x4
#define BIF_CFG_DEV1_RC0_SLOT_STATUS__MRL_SENSOR_STATE__SHIFT                                                 0x5
#define BIF_CFG_DEV1_RC0_SLOT_STATUS__PRESENCE_DETECT_STATE__SHIFT                                            0x6
#define BIF_CFG_DEV1_RC0_SLOT_STATUS__ELECTROMECH_INTERLOCK_STATUS__SHIFT                                     0x7
#define BIF_CFG_DEV1_RC0_SLOT_STATUS__DL_STATE_CHANGED__SHIFT                                                 0x8
#define BIF_CFG_DEV1_RC0_SLOT_STATUS__ATTN_BUTTON_PRESSED_MASK                                                0x0001L
#define BIF_CFG_DEV1_RC0_SLOT_STATUS__PWR_FAULT_DETECTED_MASK                                                 0x0002L
#define BIF_CFG_DEV1_RC0_SLOT_STATUS__MRL_SENSOR_CHANGED_MASK                                                 0x0004L
#define BIF_CFG_DEV1_RC0_SLOT_STATUS__PRESENCE_DETECT_CHANGED_MASK                                            0x0008L
#define BIF_CFG_DEV1_RC0_SLOT_STATUS__COMMAND_COMPLETED_MASK                                                  0x0010L
#define BIF_CFG_DEV1_RC0_SLOT_STATUS__MRL_SENSOR_STATE_MASK                                                   0x0020L
#define BIF_CFG_DEV1_RC0_SLOT_STATUS__PRESENCE_DETECT_STATE_MASK                                              0x0040L
#define BIF_CFG_DEV1_RC0_SLOT_STATUS__ELECTROMECH_INTERLOCK_STATUS_MASK                                       0x0080L
#define BIF_CFG_DEV1_RC0_SLOT_STATUS__DL_STATE_CHANGED_MASK                                                   0x0100L
//BIF_CFG_DEV1_RC0_ROOT_CNTL
#define BIF_CFG_DEV1_RC0_ROOT_CNTL__SERR_ON_CORR_ERR_EN__SHIFT                                                0x0
#define BIF_CFG_DEV1_RC0_ROOT_CNTL__SERR_ON_NONFATAL_ERR_EN__SHIFT                                            0x1
#define BIF_CFG_DEV1_RC0_ROOT_CNTL__SERR_ON_FATAL_ERR_EN__SHIFT                                               0x2
#define BIF_CFG_DEV1_RC0_ROOT_CNTL__PM_INTERRUPT_EN__SHIFT                                                    0x3
#define BIF_CFG_DEV1_RC0_ROOT_CNTL__CRS_SOFTWARE_VISIBILITY_EN__SHIFT                                         0x4
#define BIF_CFG_DEV1_RC0_ROOT_CNTL__SERR_ON_CORR_ERR_EN_MASK                                                  0x0001L
#define BIF_CFG_DEV1_RC0_ROOT_CNTL__SERR_ON_NONFATAL_ERR_EN_MASK                                              0x0002L
#define BIF_CFG_DEV1_RC0_ROOT_CNTL__SERR_ON_FATAL_ERR_EN_MASK                                                 0x0004L
#define BIF_CFG_DEV1_RC0_ROOT_CNTL__PM_INTERRUPT_EN_MASK                                                      0x0008L
#define BIF_CFG_DEV1_RC0_ROOT_CNTL__CRS_SOFTWARE_VISIBILITY_EN_MASK                                           0x0010L
//BIF_CFG_DEV1_RC0_ROOT_CAP
#define BIF_CFG_DEV1_RC0_ROOT_CAP__CRS_SOFTWARE_VISIBILITY__SHIFT                                             0x0
#define BIF_CFG_DEV1_RC0_ROOT_CAP__CRS_SOFTWARE_VISIBILITY_MASK                                               0x0001L
//BIF_CFG_DEV1_RC0_ROOT_STATUS
#define BIF_CFG_DEV1_RC0_ROOT_STATUS__PME_REQUESTOR_ID__SHIFT                                                 0x0
#define BIF_CFG_DEV1_RC0_ROOT_STATUS__PME_STATUS__SHIFT                                                       0x10
#define BIF_CFG_DEV1_RC0_ROOT_STATUS__PME_PENDING__SHIFT                                                      0x11
#define BIF_CFG_DEV1_RC0_ROOT_STATUS__PME_REQUESTOR_ID_MASK                                                   0x0000FFFFL
#define BIF_CFG_DEV1_RC0_ROOT_STATUS__PME_STATUS_MASK                                                         0x00010000L
#define BIF_CFG_DEV1_RC0_ROOT_STATUS__PME_PENDING_MASK                                                        0x00020000L
//BIF_CFG_DEV1_RC0_DEVICE_CAP2
#define BIF_CFG_DEV1_RC0_DEVICE_CAP2__CPL_TIMEOUT_RANGE_SUPPORTED__SHIFT                                      0x0
#define BIF_CFG_DEV1_RC0_DEVICE_CAP2__CPL_TIMEOUT_DIS_SUPPORTED__SHIFT                                        0x4
#define BIF_CFG_DEV1_RC0_DEVICE_CAP2__ARI_FORWARDING_SUPPORTED__SHIFT                                         0x5
#define BIF_CFG_DEV1_RC0_DEVICE_CAP2__ATOMICOP_ROUTING_SUPPORTED__SHIFT                                       0x6
#define BIF_CFG_DEV1_RC0_DEVICE_CAP2__ATOMICOP_32CMPLT_SUPPORTED__SHIFT                                       0x7
#define BIF_CFG_DEV1_RC0_DEVICE_CAP2__ATOMICOP_64CMPLT_SUPPORTED__SHIFT                                       0x8
#define BIF_CFG_DEV1_RC0_DEVICE_CAP2__CAS128_CMPLT_SUPPORTED__SHIFT                                           0x9
#define BIF_CFG_DEV1_RC0_DEVICE_CAP2__NO_RO_ENABLED_P2P_PASSING__SHIFT                                        0xa
#define BIF_CFG_DEV1_RC0_DEVICE_CAP2__LTR_SUPPORTED__SHIFT                                                    0xb
#define BIF_CFG_DEV1_RC0_DEVICE_CAP2__TPH_CPLR_SUPPORTED__SHIFT                                               0xc
#define BIF_CFG_DEV1_RC0_DEVICE_CAP2__OBFF_SUPPORTED__SHIFT                                                   0x12
#define BIF_CFG_DEV1_RC0_DEVICE_CAP2__EXTENDED_FMT_FIELD_SUPPORTED__SHIFT                                     0x14
#define BIF_CFG_DEV1_RC0_DEVICE_CAP2__END_END_TLP_PREFIX_SUPPORTED__SHIFT                                     0x15
#define BIF_CFG_DEV1_RC0_DEVICE_CAP2__MAX_END_END_TLP_PREFIXES__SHIFT                                         0x16
#define BIF_CFG_DEV1_RC0_DEVICE_CAP2__CPL_TIMEOUT_RANGE_SUPPORTED_MASK                                        0x0000000FL
#define BIF_CFG_DEV1_RC0_DEVICE_CAP2__CPL_TIMEOUT_DIS_SUPPORTED_MASK                                          0x00000010L
#define BIF_CFG_DEV1_RC0_DEVICE_CAP2__ARI_FORWARDING_SUPPORTED_MASK                                           0x00000020L
#define BIF_CFG_DEV1_RC0_DEVICE_CAP2__ATOMICOP_ROUTING_SUPPORTED_MASK                                         0x00000040L
#define BIF_CFG_DEV1_RC0_DEVICE_CAP2__ATOMICOP_32CMPLT_SUPPORTED_MASK                                         0x00000080L
#define BIF_CFG_DEV1_RC0_DEVICE_CAP2__ATOMICOP_64CMPLT_SUPPORTED_MASK                                         0x00000100L
#define BIF_CFG_DEV1_RC0_DEVICE_CAP2__CAS128_CMPLT_SUPPORTED_MASK                                             0x00000200L
#define BIF_CFG_DEV1_RC0_DEVICE_CAP2__NO_RO_ENABLED_P2P_PASSING_MASK                                          0x00000400L
#define BIF_CFG_DEV1_RC0_DEVICE_CAP2__LTR_SUPPORTED_MASK                                                      0x00000800L
#define BIF_CFG_DEV1_RC0_DEVICE_CAP2__TPH_CPLR_SUPPORTED_MASK                                                 0x00003000L
#define BIF_CFG_DEV1_RC0_DEVICE_CAP2__OBFF_SUPPORTED_MASK                                                     0x000C0000L
#define BIF_CFG_DEV1_RC0_DEVICE_CAP2__EXTENDED_FMT_FIELD_SUPPORTED_MASK                                       0x00100000L
#define BIF_CFG_DEV1_RC0_DEVICE_CAP2__END_END_TLP_PREFIX_SUPPORTED_MASK                                       0x00200000L
#define BIF_CFG_DEV1_RC0_DEVICE_CAP2__MAX_END_END_TLP_PREFIXES_MASK                                           0x00C00000L
//BIF_CFG_DEV1_RC0_DEVICE_CNTL2
#define BIF_CFG_DEV1_RC0_DEVICE_CNTL2__CPL_TIMEOUT_VALUE__SHIFT                                               0x0
#define BIF_CFG_DEV1_RC0_DEVICE_CNTL2__CPL_TIMEOUT_DIS__SHIFT                                                 0x4
#define BIF_CFG_DEV1_RC0_DEVICE_CNTL2__ARI_FORWARDING_EN__SHIFT                                               0x5
#define BIF_CFG_DEV1_RC0_DEVICE_CNTL2__ATOMICOP_REQUEST_EN__SHIFT                                             0x6
#define BIF_CFG_DEV1_RC0_DEVICE_CNTL2__ATOMICOP_EGRESS_BLOCKING__SHIFT                                        0x7
#define BIF_CFG_DEV1_RC0_DEVICE_CNTL2__IDO_REQUEST_ENABLE__SHIFT                                              0x8
#define BIF_CFG_DEV1_RC0_DEVICE_CNTL2__IDO_COMPLETION_ENABLE__SHIFT                                           0x9
#define BIF_CFG_DEV1_RC0_DEVICE_CNTL2__LTR_EN__SHIFT                                                          0xa
#define BIF_CFG_DEV1_RC0_DEVICE_CNTL2__OBFF_EN__SHIFT                                                         0xd
#define BIF_CFG_DEV1_RC0_DEVICE_CNTL2__END_END_TLP_PREFIX_BLOCKING__SHIFT                                     0xf
#define BIF_CFG_DEV1_RC0_DEVICE_CNTL2__CPL_TIMEOUT_VALUE_MASK                                                 0x000FL
#define BIF_CFG_DEV1_RC0_DEVICE_CNTL2__CPL_TIMEOUT_DIS_MASK                                                   0x0010L
#define BIF_CFG_DEV1_RC0_DEVICE_CNTL2__ARI_FORWARDING_EN_MASK                                                 0x0020L
#define BIF_CFG_DEV1_RC0_DEVICE_CNTL2__ATOMICOP_REQUEST_EN_MASK                                               0x0040L
#define BIF_CFG_DEV1_RC0_DEVICE_CNTL2__ATOMICOP_EGRESS_BLOCKING_MASK                                          0x0080L
#define BIF_CFG_DEV1_RC0_DEVICE_CNTL2__IDO_REQUEST_ENABLE_MASK                                                0x0100L
#define BIF_CFG_DEV1_RC0_DEVICE_CNTL2__IDO_COMPLETION_ENABLE_MASK                                             0x0200L
#define BIF_CFG_DEV1_RC0_DEVICE_CNTL2__LTR_EN_MASK                                                            0x0400L
#define BIF_CFG_DEV1_RC0_DEVICE_CNTL2__OBFF_EN_MASK                                                           0x6000L
#define BIF_CFG_DEV1_RC0_DEVICE_CNTL2__END_END_TLP_PREFIX_BLOCKING_MASK                                       0x8000L
//BIF_CFG_DEV1_RC0_DEVICE_STATUS2
#define BIF_CFG_DEV1_RC0_DEVICE_STATUS2__RESERVED__SHIFT                                                      0x0
#define BIF_CFG_DEV1_RC0_DEVICE_STATUS2__RESERVED_MASK                                                        0xFFFFL
//BIF_CFG_DEV1_RC0_LINK_CAP2
#define BIF_CFG_DEV1_RC0_LINK_CAP2__SUPPORTED_LINK_SPEED__SHIFT                                               0x1
#define BIF_CFG_DEV1_RC0_LINK_CAP2__CROSSLINK_SUPPORTED__SHIFT                                                0x8
#define BIF_CFG_DEV1_RC0_LINK_CAP2__RESERVED__SHIFT                                                           0x9
#define BIF_CFG_DEV1_RC0_LINK_CAP2__SUPPORTED_LINK_SPEED_MASK                                                 0x000000FEL
#define BIF_CFG_DEV1_RC0_LINK_CAP2__CROSSLINK_SUPPORTED_MASK                                                  0x00000100L
#define BIF_CFG_DEV1_RC0_LINK_CAP2__RESERVED_MASK                                                             0xFFFFFE00L
//BIF_CFG_DEV1_RC0_LINK_CNTL2
#define BIF_CFG_DEV1_RC0_LINK_CNTL2__TARGET_LINK_SPEED__SHIFT                                                 0x0
#define BIF_CFG_DEV1_RC0_LINK_CNTL2__ENTER_COMPLIANCE__SHIFT                                                  0x4
#define BIF_CFG_DEV1_RC0_LINK_CNTL2__HW_AUTONOMOUS_SPEED_DISABLE__SHIFT                                       0x5
#define BIF_CFG_DEV1_RC0_LINK_CNTL2__SELECTABLE_DEEMPHASIS__SHIFT                                             0x6
#define BIF_CFG_DEV1_RC0_LINK_CNTL2__XMIT_MARGIN__SHIFT                                                       0x7
#define BIF_CFG_DEV1_RC0_LINK_CNTL2__ENTER_MOD_COMPLIANCE__SHIFT                                              0xa
#define BIF_CFG_DEV1_RC0_LINK_CNTL2__COMPLIANCE_SOS__SHIFT                                                    0xb
#define BIF_CFG_DEV1_RC0_LINK_CNTL2__COMPLIANCE_DEEMPHASIS__SHIFT                                             0xc
#define BIF_CFG_DEV1_RC0_LINK_CNTL2__TARGET_LINK_SPEED_MASK                                                   0x000FL
#define BIF_CFG_DEV1_RC0_LINK_CNTL2__ENTER_COMPLIANCE_MASK                                                    0x0010L
#define BIF_CFG_DEV1_RC0_LINK_CNTL2__HW_AUTONOMOUS_SPEED_DISABLE_MASK                                         0x0020L
#define BIF_CFG_DEV1_RC0_LINK_CNTL2__SELECTABLE_DEEMPHASIS_MASK                                               0x0040L
#define BIF_CFG_DEV1_RC0_LINK_CNTL2__XMIT_MARGIN_MASK                                                         0x0380L
#define BIF_CFG_DEV1_RC0_LINK_CNTL2__ENTER_MOD_COMPLIANCE_MASK                                                0x0400L
#define BIF_CFG_DEV1_RC0_LINK_CNTL2__COMPLIANCE_SOS_MASK                                                      0x0800L
#define BIF_CFG_DEV1_RC0_LINK_CNTL2__COMPLIANCE_DEEMPHASIS_MASK                                               0xF000L
//BIF_CFG_DEV1_RC0_LINK_STATUS2
#define BIF_CFG_DEV1_RC0_LINK_STATUS2__CUR_DEEMPHASIS_LEVEL__SHIFT                                            0x0
#define BIF_CFG_DEV1_RC0_LINK_STATUS2__EQUALIZATION_COMPLETE__SHIFT                                           0x1
#define BIF_CFG_DEV1_RC0_LINK_STATUS2__EQUALIZATION_PHASE1_SUCCESS__SHIFT                                     0x2
#define BIF_CFG_DEV1_RC0_LINK_STATUS2__EQUALIZATION_PHASE2_SUCCESS__SHIFT                                     0x3
#define BIF_CFG_DEV1_RC0_LINK_STATUS2__EQUALIZATION_PHASE3_SUCCESS__SHIFT                                     0x4
#define BIF_CFG_DEV1_RC0_LINK_STATUS2__LINK_EQUALIZATION_REQUEST__SHIFT                                       0x5
#define BIF_CFG_DEV1_RC0_LINK_STATUS2__CUR_DEEMPHASIS_LEVEL_MASK                                              0x0001L
#define BIF_CFG_DEV1_RC0_LINK_STATUS2__EQUALIZATION_COMPLETE_MASK                                             0x0002L
#define BIF_CFG_DEV1_RC0_LINK_STATUS2__EQUALIZATION_PHASE1_SUCCESS_MASK                                       0x0004L
#define BIF_CFG_DEV1_RC0_LINK_STATUS2__EQUALIZATION_PHASE2_SUCCESS_MASK                                       0x0008L
#define BIF_CFG_DEV1_RC0_LINK_STATUS2__EQUALIZATION_PHASE3_SUCCESS_MASK                                       0x0010L
#define BIF_CFG_DEV1_RC0_LINK_STATUS2__LINK_EQUALIZATION_REQUEST_MASK                                         0x0020L
//BIF_CFG_DEV1_RC0_SLOT_CAP2
#define BIF_CFG_DEV1_RC0_SLOT_CAP2__RESERVED__SHIFT                                                           0x0
#define BIF_CFG_DEV1_RC0_SLOT_CAP2__RESERVED_MASK                                                             0xFFFFFFFFL
//BIF_CFG_DEV1_RC0_SLOT_CNTL2
#define BIF_CFG_DEV1_RC0_SLOT_CNTL2__RESERVED__SHIFT                                                          0x0
#define BIF_CFG_DEV1_RC0_SLOT_CNTL2__RESERVED_MASK                                                            0xFFFFL
//BIF_CFG_DEV1_RC0_SLOT_STATUS2
#define BIF_CFG_DEV1_RC0_SLOT_STATUS2__RESERVED__SHIFT                                                        0x0
#define BIF_CFG_DEV1_RC0_SLOT_STATUS2__RESERVED_MASK                                                          0xFFFFL
//BIF_CFG_DEV1_RC0_MSI_CAP_LIST
#define BIF_CFG_DEV1_RC0_MSI_CAP_LIST__CAP_ID__SHIFT                                                          0x0
#define BIF_CFG_DEV1_RC0_MSI_CAP_LIST__NEXT_PTR__SHIFT                                                        0x8
#define BIF_CFG_DEV1_RC0_MSI_CAP_LIST__CAP_ID_MASK                                                            0x00FFL
#define BIF_CFG_DEV1_RC0_MSI_CAP_LIST__NEXT_PTR_MASK                                                          0xFF00L
//BIF_CFG_DEV1_RC0_MSI_MSG_CNTL
#define BIF_CFG_DEV1_RC0_MSI_MSG_CNTL__MSI_EN__SHIFT                                                          0x0
#define BIF_CFG_DEV1_RC0_MSI_MSG_CNTL__MSI_MULTI_CAP__SHIFT                                                   0x1
#define BIF_CFG_DEV1_RC0_MSI_MSG_CNTL__MSI_MULTI_EN__SHIFT                                                    0x4
#define BIF_CFG_DEV1_RC0_MSI_MSG_CNTL__MSI_64BIT__SHIFT                                                       0x7
#define BIF_CFG_DEV1_RC0_MSI_MSG_CNTL__MSI_PERVECTOR_MASKING_CAP__SHIFT                                       0x8
#define BIF_CFG_DEV1_RC0_MSI_MSG_CNTL__MSI_EN_MASK                                                            0x0001L
#define BIF_CFG_DEV1_RC0_MSI_MSG_CNTL__MSI_MULTI_CAP_MASK                                                     0x000EL
#define BIF_CFG_DEV1_RC0_MSI_MSG_CNTL__MSI_MULTI_EN_MASK                                                      0x0070L
#define BIF_CFG_DEV1_RC0_MSI_MSG_CNTL__MSI_64BIT_MASK                                                         0x0080L
#define BIF_CFG_DEV1_RC0_MSI_MSG_CNTL__MSI_PERVECTOR_MASKING_CAP_MASK                                         0x0100L
//BIF_CFG_DEV1_RC0_MSI_MSG_ADDR_LO
#define BIF_CFG_DEV1_RC0_MSI_MSG_ADDR_LO__MSI_MSG_ADDR_LO__SHIFT                                              0x2
#define BIF_CFG_DEV1_RC0_MSI_MSG_ADDR_LO__MSI_MSG_ADDR_LO_MASK                                                0xFFFFFFFCL
//BIF_CFG_DEV1_RC0_MSI_MSG_ADDR_HI
#define BIF_CFG_DEV1_RC0_MSI_MSG_ADDR_HI__MSI_MSG_ADDR_HI__SHIFT                                              0x0
#define BIF_CFG_DEV1_RC0_MSI_MSG_ADDR_HI__MSI_MSG_ADDR_HI_MASK                                                0xFFFFFFFFL
//BIF_CFG_DEV1_RC0_MSI_MSG_DATA
#define BIF_CFG_DEV1_RC0_MSI_MSG_DATA__MSI_DATA__SHIFT                                                        0x0
#define BIF_CFG_DEV1_RC0_MSI_MSG_DATA__MSI_DATA_MASK                                                          0x0000FFFFL
//BIF_CFG_DEV1_RC0_MSI_MSG_DATA_64
#define BIF_CFG_DEV1_RC0_MSI_MSG_DATA_64__MSI_DATA_64__SHIFT                                                  0x0
#define BIF_CFG_DEV1_RC0_MSI_MSG_DATA_64__MSI_DATA_64_MASK                                                    0x0000FFFFL
//BIF_CFG_DEV1_RC0_SSID_CAP_LIST
#define BIF_CFG_DEV1_RC0_SSID_CAP_LIST__CAP_ID__SHIFT                                                         0x0
#define BIF_CFG_DEV1_RC0_SSID_CAP_LIST__NEXT_PTR__SHIFT                                                       0x8
#define BIF_CFG_DEV1_RC0_SSID_CAP_LIST__CAP_ID_MASK                                                           0x00FFL
#define BIF_CFG_DEV1_RC0_SSID_CAP_LIST__NEXT_PTR_MASK                                                         0xFF00L
//BIF_CFG_DEV1_RC0_SSID_CAP
#define BIF_CFG_DEV1_RC0_SSID_CAP__SUBSYSTEM_VENDOR_ID__SHIFT                                                 0x0
#define BIF_CFG_DEV1_RC0_SSID_CAP__SUBSYSTEM_ID__SHIFT                                                        0x10
#define BIF_CFG_DEV1_RC0_SSID_CAP__SUBSYSTEM_VENDOR_ID_MASK                                                   0x0000FFFFL
#define BIF_CFG_DEV1_RC0_SSID_CAP__SUBSYSTEM_ID_MASK                                                          0xFFFF0000L
//BIF_CFG_DEV1_RC0_MSI_MAP_CAP_LIST
#define BIF_CFG_DEV1_RC0_MSI_MAP_CAP_LIST__CAP_ID__SHIFT                                                      0x0
#define BIF_CFG_DEV1_RC0_MSI_MAP_CAP_LIST__NEXT_PTR__SHIFT                                                    0x8
#define BIF_CFG_DEV1_RC0_MSI_MAP_CAP_LIST__CAP_ID_MASK                                                        0x00FFL
#define BIF_CFG_DEV1_RC0_MSI_MAP_CAP_LIST__NEXT_PTR_MASK                                                      0xFF00L
//BIF_CFG_DEV1_RC0_MSI_MAP_CAP
#define BIF_CFG_DEV1_RC0_MSI_MAP_CAP__EN__SHIFT                                                               0x0
#define BIF_CFG_DEV1_RC0_MSI_MAP_CAP__FIXD__SHIFT                                                             0x1
#define BIF_CFG_DEV1_RC0_MSI_MAP_CAP__CAP_TYPE__SHIFT                                                         0xb
#define BIF_CFG_DEV1_RC0_MSI_MAP_CAP__EN_MASK                                                                 0x0001L
#define BIF_CFG_DEV1_RC0_MSI_MAP_CAP__FIXD_MASK                                                               0x0002L
#define BIF_CFG_DEV1_RC0_MSI_MAP_CAP__CAP_TYPE_MASK                                                           0xF800L
//BIF_CFG_DEV1_RC0_MSI_MAP_ADDR_LO
#define BIF_CFG_DEV1_RC0_MSI_MAP_ADDR_LO__MSI_MAP_ADDR_LO__SHIFT                                              0x14
#define BIF_CFG_DEV1_RC0_MSI_MAP_ADDR_LO__MSI_MAP_ADDR_LO_MASK                                                0xFFF00000L
//BIF_CFG_DEV1_RC0_MSI_MAP_ADDR_HI
#define BIF_CFG_DEV1_RC0_MSI_MAP_ADDR_HI__MSI_MAP_ADDR_HI__SHIFT                                              0x0
#define BIF_CFG_DEV1_RC0_MSI_MAP_ADDR_HI__MSI_MAP_ADDR_HI_MASK                                                0xFFFFFFFFL
//BIF_CFG_DEV1_RC0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST
#define BIF_CFG_DEV1_RC0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_ID__SHIFT                                     0x0
#define BIF_CFG_DEV1_RC0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_VER__SHIFT                                    0x10
#define BIF_CFG_DEV1_RC0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__NEXT_PTR__SHIFT                                   0x14
#define BIF_CFG_DEV1_RC0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_ID_MASK                                       0x0000FFFFL
#define BIF_CFG_DEV1_RC0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_VER_MASK                                      0x000F0000L
#define BIF_CFG_DEV1_RC0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__NEXT_PTR_MASK                                     0xFFF00000L
//BIF_CFG_DEV1_RC0_PCIE_VENDOR_SPECIFIC_HDR
#define BIF_CFG_DEV1_RC0_PCIE_VENDOR_SPECIFIC_HDR__VSEC_ID__SHIFT                                             0x0
#define BIF_CFG_DEV1_RC0_PCIE_VENDOR_SPECIFIC_HDR__VSEC_REV__SHIFT                                            0x10
#define BIF_CFG_DEV1_RC0_PCIE_VENDOR_SPECIFIC_HDR__VSEC_LENGTH__SHIFT                                         0x14
#define BIF_CFG_DEV1_RC0_PCIE_VENDOR_SPECIFIC_HDR__VSEC_ID_MASK                                               0x0000FFFFL
#define BIF_CFG_DEV1_RC0_PCIE_VENDOR_SPECIFIC_HDR__VSEC_REV_MASK                                              0x000F0000L
#define BIF_CFG_DEV1_RC0_PCIE_VENDOR_SPECIFIC_HDR__VSEC_LENGTH_MASK                                           0xFFF00000L
//BIF_CFG_DEV1_RC0_PCIE_VENDOR_SPECIFIC1
#define BIF_CFG_DEV1_RC0_PCIE_VENDOR_SPECIFIC1__SCRATCH__SHIFT                                                0x0
#define BIF_CFG_DEV1_RC0_PCIE_VENDOR_SPECIFIC1__SCRATCH_MASK                                                  0xFFFFFFFFL
//BIF_CFG_DEV1_RC0_PCIE_VENDOR_SPECIFIC2
#define BIF_CFG_DEV1_RC0_PCIE_VENDOR_SPECIFIC2__SCRATCH__SHIFT                                                0x0
#define BIF_CFG_DEV1_RC0_PCIE_VENDOR_SPECIFIC2__SCRATCH_MASK                                                  0xFFFFFFFFL
//BIF_CFG_DEV1_RC0_PCIE_VC_ENH_CAP_LIST
#define BIF_CFG_DEV1_RC0_PCIE_VC_ENH_CAP_LIST__CAP_ID__SHIFT                                                  0x0
#define BIF_CFG_DEV1_RC0_PCIE_VC_ENH_CAP_LIST__CAP_VER__SHIFT                                                 0x10
#define BIF_CFG_DEV1_RC0_PCIE_VC_ENH_CAP_LIST__NEXT_PTR__SHIFT                                                0x14
#define BIF_CFG_DEV1_RC0_PCIE_VC_ENH_CAP_LIST__CAP_ID_MASK                                                    0x0000FFFFL
#define BIF_CFG_DEV1_RC0_PCIE_VC_ENH_CAP_LIST__CAP_VER_MASK                                                   0x000F0000L
#define BIF_CFG_DEV1_RC0_PCIE_VC_ENH_CAP_LIST__NEXT_PTR_MASK                                                  0xFFF00000L
//BIF_CFG_DEV1_RC0_PCIE_PORT_VC_CAP_REG1
#define BIF_CFG_DEV1_RC0_PCIE_PORT_VC_CAP_REG1__EXT_VC_COUNT__SHIFT                                           0x0
#define BIF_CFG_DEV1_RC0_PCIE_PORT_VC_CAP_REG1__LOW_PRIORITY_EXT_VC_COUNT__SHIFT                              0x4
#define BIF_CFG_DEV1_RC0_PCIE_PORT_VC_CAP_REG1__REF_CLK__SHIFT                                                0x8
#define BIF_CFG_DEV1_RC0_PCIE_PORT_VC_CAP_REG1__PORT_ARB_TABLE_ENTRY_SIZE__SHIFT                              0xa
#define BIF_CFG_DEV1_RC0_PCIE_PORT_VC_CAP_REG1__EXT_VC_COUNT_MASK                                             0x00000007L
#define BIF_CFG_DEV1_RC0_PCIE_PORT_VC_CAP_REG1__LOW_PRIORITY_EXT_VC_COUNT_MASK                                0x00000070L
#define BIF_CFG_DEV1_RC0_PCIE_PORT_VC_CAP_REG1__REF_CLK_MASK                                                  0x00000300L
#define BIF_CFG_DEV1_RC0_PCIE_PORT_VC_CAP_REG1__PORT_ARB_TABLE_ENTRY_SIZE_MASK                                0x00000C00L
//BIF_CFG_DEV1_RC0_PCIE_PORT_VC_CAP_REG2
#define BIF_CFG_DEV1_RC0_PCIE_PORT_VC_CAP_REG2__VC_ARB_CAP__SHIFT                                             0x0
#define BIF_CFG_DEV1_RC0_PCIE_PORT_VC_CAP_REG2__VC_ARB_TABLE_OFFSET__SHIFT                                    0x18
#define BIF_CFG_DEV1_RC0_PCIE_PORT_VC_CAP_REG2__VC_ARB_CAP_MASK                                               0x000000FFL
#define BIF_CFG_DEV1_RC0_PCIE_PORT_VC_CAP_REG2__VC_ARB_TABLE_OFFSET_MASK                                      0xFF000000L
//BIF_CFG_DEV1_RC0_PCIE_PORT_VC_CNTL
#define BIF_CFG_DEV1_RC0_PCIE_PORT_VC_CNTL__LOAD_VC_ARB_TABLE__SHIFT                                          0x0
#define BIF_CFG_DEV1_RC0_PCIE_PORT_VC_CNTL__VC_ARB_SELECT__SHIFT                                              0x1
#define BIF_CFG_DEV1_RC0_PCIE_PORT_VC_CNTL__LOAD_VC_ARB_TABLE_MASK                                            0x0001L
#define BIF_CFG_DEV1_RC0_PCIE_PORT_VC_CNTL__VC_ARB_SELECT_MASK                                                0x000EL
//BIF_CFG_DEV1_RC0_PCIE_PORT_VC_STATUS
#define BIF_CFG_DEV1_RC0_PCIE_PORT_VC_STATUS__VC_ARB_TABLE_STATUS__SHIFT                                      0x0
#define BIF_CFG_DEV1_RC0_PCIE_PORT_VC_STATUS__VC_ARB_TABLE_STATUS_MASK                                        0x0001L
//BIF_CFG_DEV1_RC0_PCIE_VC0_RESOURCE_CAP
#define BIF_CFG_DEV1_RC0_PCIE_VC0_RESOURCE_CAP__PORT_ARB_CAP__SHIFT                                           0x0
#define BIF_CFG_DEV1_RC0_PCIE_VC0_RESOURCE_CAP__REJECT_SNOOP_TRANS__SHIFT                                     0xf
#define BIF_CFG_DEV1_RC0_PCIE_VC0_RESOURCE_CAP__MAX_TIME_SLOTS__SHIFT                                         0x10
#define BIF_CFG_DEV1_RC0_PCIE_VC0_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET__SHIFT                                  0x18
#define BIF_CFG_DEV1_RC0_PCIE_VC0_RESOURCE_CAP__PORT_ARB_CAP_MASK                                             0x000000FFL
#define BIF_CFG_DEV1_RC0_PCIE_VC0_RESOURCE_CAP__REJECT_SNOOP_TRANS_MASK                                       0x00008000L
#define BIF_CFG_DEV1_RC0_PCIE_VC0_RESOURCE_CAP__MAX_TIME_SLOTS_MASK                                           0x003F0000L
#define BIF_CFG_DEV1_RC0_PCIE_VC0_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET_MASK                                    0xFF000000L
//BIF_CFG_DEV1_RC0_PCIE_VC0_RESOURCE_CNTL
#define BIF_CFG_DEV1_RC0_PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC0__SHIFT                                         0x0
#define BIF_CFG_DEV1_RC0_PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC1_7__SHIFT                                       0x1
#define BIF_CFG_DEV1_RC0_PCIE_VC0_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE__SHIFT                                   0x10
#define BIF_CFG_DEV1_RC0_PCIE_VC0_RESOURCE_CNTL__PORT_ARB_SELECT__SHIFT                                       0x11
#define BIF_CFG_DEV1_RC0_PCIE_VC0_RESOURCE_CNTL__VC_ID__SHIFT                                                 0x18
#define BIF_CFG_DEV1_RC0_PCIE_VC0_RESOURCE_CNTL__VC_ENABLE__SHIFT                                             0x1f
#define BIF_CFG_DEV1_RC0_PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC0_MASK                                           0x00000001L
#define BIF_CFG_DEV1_RC0_PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC1_7_MASK                                         0x000000FEL
#define BIF_CFG_DEV1_RC0_PCIE_VC0_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE_MASK                                     0x00010000L
#define BIF_CFG_DEV1_RC0_PCIE_VC0_RESOURCE_CNTL__PORT_ARB_SELECT_MASK                                         0x000E0000L
#define BIF_CFG_DEV1_RC0_PCIE_VC0_RESOURCE_CNTL__VC_ID_MASK                                                   0x07000000L
#define BIF_CFG_DEV1_RC0_PCIE_VC0_RESOURCE_CNTL__VC_ENABLE_MASK                                               0x80000000L
//BIF_CFG_DEV1_RC0_PCIE_VC0_RESOURCE_STATUS
#define BIF_CFG_DEV1_RC0_PCIE_VC0_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS__SHIFT                               0x0
#define BIF_CFG_DEV1_RC0_PCIE_VC0_RESOURCE_STATUS__VC_NEGOTIATION_PENDING__SHIFT                              0x1
#define BIF_CFG_DEV1_RC0_PCIE_VC0_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS_MASK                                 0x0001L
#define BIF_CFG_DEV1_RC0_PCIE_VC0_RESOURCE_STATUS__VC_NEGOTIATION_PENDING_MASK                                0x0002L
//BIF_CFG_DEV1_RC0_PCIE_VC1_RESOURCE_CAP
#define BIF_CFG_DEV1_RC0_PCIE_VC1_RESOURCE_CAP__PORT_ARB_CAP__SHIFT                                           0x0
#define BIF_CFG_DEV1_RC0_PCIE_VC1_RESOURCE_CAP__REJECT_SNOOP_TRANS__SHIFT                                     0xf
#define BIF_CFG_DEV1_RC0_PCIE_VC1_RESOURCE_CAP__MAX_TIME_SLOTS__SHIFT                                         0x10
#define BIF_CFG_DEV1_RC0_PCIE_VC1_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET__SHIFT                                  0x18
#define BIF_CFG_DEV1_RC0_PCIE_VC1_RESOURCE_CAP__PORT_ARB_CAP_MASK                                             0x000000FFL
#define BIF_CFG_DEV1_RC0_PCIE_VC1_RESOURCE_CAP__REJECT_SNOOP_TRANS_MASK                                       0x00008000L
#define BIF_CFG_DEV1_RC0_PCIE_VC1_RESOURCE_CAP__MAX_TIME_SLOTS_MASK                                           0x003F0000L
#define BIF_CFG_DEV1_RC0_PCIE_VC1_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET_MASK                                    0xFF000000L
//BIF_CFG_DEV1_RC0_PCIE_VC1_RESOURCE_CNTL
#define BIF_CFG_DEV1_RC0_PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC0__SHIFT                                         0x0
#define BIF_CFG_DEV1_RC0_PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC1_7__SHIFT                                       0x1
#define BIF_CFG_DEV1_RC0_PCIE_VC1_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE__SHIFT                                   0x10
#define BIF_CFG_DEV1_RC0_PCIE_VC1_RESOURCE_CNTL__PORT_ARB_SELECT__SHIFT                                       0x11
#define BIF_CFG_DEV1_RC0_PCIE_VC1_RESOURCE_CNTL__VC_ID__SHIFT                                                 0x18
#define BIF_CFG_DEV1_RC0_PCIE_VC1_RESOURCE_CNTL__VC_ENABLE__SHIFT                                             0x1f
#define BIF_CFG_DEV1_RC0_PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC0_MASK                                           0x00000001L
#define BIF_CFG_DEV1_RC0_PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC1_7_MASK                                         0x000000FEL
#define BIF_CFG_DEV1_RC0_PCIE_VC1_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE_MASK                                     0x00010000L
#define BIF_CFG_DEV1_RC0_PCIE_VC1_RESOURCE_CNTL__PORT_ARB_SELECT_MASK                                         0x000E0000L
#define BIF_CFG_DEV1_RC0_PCIE_VC1_RESOURCE_CNTL__VC_ID_MASK                                                   0x07000000L
#define BIF_CFG_DEV1_RC0_PCIE_VC1_RESOURCE_CNTL__VC_ENABLE_MASK                                               0x80000000L
//BIF_CFG_DEV1_RC0_PCIE_VC1_RESOURCE_STATUS
#define BIF_CFG_DEV1_RC0_PCIE_VC1_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS__SHIFT                               0x0
#define BIF_CFG_DEV1_RC0_PCIE_VC1_RESOURCE_STATUS__VC_NEGOTIATION_PENDING__SHIFT                              0x1
#define BIF_CFG_DEV1_RC0_PCIE_VC1_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS_MASK                                 0x0001L
#define BIF_CFG_DEV1_RC0_PCIE_VC1_RESOURCE_STATUS__VC_NEGOTIATION_PENDING_MASK                                0x0002L
//BIF_CFG_DEV1_RC0_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST
#define BIF_CFG_DEV1_RC0_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_ID__SHIFT                                      0x0
#define BIF_CFG_DEV1_RC0_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_VER__SHIFT                                     0x10
#define BIF_CFG_DEV1_RC0_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__NEXT_PTR__SHIFT                                    0x14
#define BIF_CFG_DEV1_RC0_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_ID_MASK                                        0x0000FFFFL
#define BIF_CFG_DEV1_RC0_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_VER_MASK                                       0x000F0000L
#define BIF_CFG_DEV1_RC0_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__NEXT_PTR_MASK                                      0xFFF00000L
//BIF_CFG_DEV1_RC0_PCIE_DEV_SERIAL_NUM_DW1
#define BIF_CFG_DEV1_RC0_PCIE_DEV_SERIAL_NUM_DW1__SERIAL_NUMBER_LO__SHIFT                                     0x0
#define BIF_CFG_DEV1_RC0_PCIE_DEV_SERIAL_NUM_DW1__SERIAL_NUMBER_LO_MASK                                       0xFFFFFFFFL
//BIF_CFG_DEV1_RC0_PCIE_DEV_SERIAL_NUM_DW2
#define BIF_CFG_DEV1_RC0_PCIE_DEV_SERIAL_NUM_DW2__SERIAL_NUMBER_HI__SHIFT                                     0x0
#define BIF_CFG_DEV1_RC0_PCIE_DEV_SERIAL_NUM_DW2__SERIAL_NUMBER_HI_MASK                                       0xFFFFFFFFL
//BIF_CFG_DEV1_RC0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST
#define BIF_CFG_DEV1_RC0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_ID__SHIFT                                         0x0
#define BIF_CFG_DEV1_RC0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_VER__SHIFT                                        0x10
#define BIF_CFG_DEV1_RC0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__NEXT_PTR__SHIFT                                       0x14
#define BIF_CFG_DEV1_RC0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_ID_MASK                                           0x0000FFFFL
#define BIF_CFG_DEV1_RC0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_VER_MASK                                          0x000F0000L
#define BIF_CFG_DEV1_RC0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__NEXT_PTR_MASK                                         0xFFF00000L
//BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_STATUS
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_STATUS__DLP_ERR_STATUS__SHIFT                                        0x4
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_STATUS__SURPDN_ERR_STATUS__SHIFT                                     0x5
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_STATUS__PSN_ERR_STATUS__SHIFT                                        0xc
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_STATUS__FC_ERR_STATUS__SHIFT                                         0xd
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_STATUS__CPL_TIMEOUT_STATUS__SHIFT                                    0xe
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_STATUS__CPL_ABORT_ERR_STATUS__SHIFT                                  0xf
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_STATUS__UNEXP_CPL_STATUS__SHIFT                                      0x10
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_STATUS__RCV_OVFL_STATUS__SHIFT                                       0x11
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_STATUS__MAL_TLP_STATUS__SHIFT                                        0x12
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_STATUS__ECRC_ERR_STATUS__SHIFT                                       0x13
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_STATUS__UNSUPP_REQ_ERR_STATUS__SHIFT                                 0x14
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_STATUS__ACS_VIOLATION_STATUS__SHIFT                                  0x15
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_STATUS__UNCORR_INT_ERR_STATUS__SHIFT                                 0x16
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_STATUS__MC_BLOCKED_TLP_STATUS__SHIFT                                 0x17
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_STATUS__ATOMICOP_EGRESS_BLOCKED_STATUS__SHIFT                        0x18
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_STATUS__TLP_PREFIX_BLOCKED_ERR_STATUS__SHIFT                         0x19
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_STATUS__DLP_ERR_STATUS_MASK                                          0x00000010L
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_STATUS__SURPDN_ERR_STATUS_MASK                                       0x00000020L
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_STATUS__PSN_ERR_STATUS_MASK                                          0x00001000L
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_STATUS__FC_ERR_STATUS_MASK                                           0x00002000L
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_STATUS__CPL_TIMEOUT_STATUS_MASK                                      0x00004000L
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_STATUS__CPL_ABORT_ERR_STATUS_MASK                                    0x00008000L
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_STATUS__UNEXP_CPL_STATUS_MASK                                        0x00010000L
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_STATUS__RCV_OVFL_STATUS_MASK                                         0x00020000L
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_STATUS__MAL_TLP_STATUS_MASK                                          0x00040000L
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_STATUS__ECRC_ERR_STATUS_MASK                                         0x00080000L
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_STATUS__UNSUPP_REQ_ERR_STATUS_MASK                                   0x00100000L
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_STATUS__ACS_VIOLATION_STATUS_MASK                                    0x00200000L
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_STATUS__UNCORR_INT_ERR_STATUS_MASK                                   0x00400000L
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_STATUS__MC_BLOCKED_TLP_STATUS_MASK                                   0x00800000L
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_STATUS__ATOMICOP_EGRESS_BLOCKED_STATUS_MASK                          0x01000000L
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_STATUS__TLP_PREFIX_BLOCKED_ERR_STATUS_MASK                           0x02000000L
//BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_MASK
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_MASK__DLP_ERR_MASK__SHIFT                                            0x4
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_MASK__SURPDN_ERR_MASK__SHIFT                                         0x5
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_MASK__PSN_ERR_MASK__SHIFT                                            0xc
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_MASK__FC_ERR_MASK__SHIFT                                             0xd
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_MASK__CPL_TIMEOUT_MASK__SHIFT                                        0xe
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_MASK__CPL_ABORT_ERR_MASK__SHIFT                                      0xf
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_MASK__UNEXP_CPL_MASK__SHIFT                                          0x10
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_MASK__RCV_OVFL_MASK__SHIFT                                           0x11
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_MASK__MAL_TLP_MASK__SHIFT                                            0x12
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_MASK__ECRC_ERR_MASK__SHIFT                                           0x13
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_MASK__UNSUPP_REQ_ERR_MASK__SHIFT                                     0x14
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_MASK__ACS_VIOLATION_MASK__SHIFT                                      0x15
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_MASK__UNCORR_INT_ERR_MASK__SHIFT                                     0x16
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_MASK__MC_BLOCKED_TLP_MASK__SHIFT                                     0x17
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_MASK__ATOMICOP_EGRESS_BLOCKED_MASK__SHIFT                            0x18
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_MASK__TLP_PREFIX_BLOCKED_ERR_MASK__SHIFT                             0x19
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_MASK__DLP_ERR_MASK_MASK                                              0x00000010L
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_MASK__SURPDN_ERR_MASK_MASK                                           0x00000020L
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_MASK__PSN_ERR_MASK_MASK                                              0x00001000L
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_MASK__FC_ERR_MASK_MASK                                               0x00002000L
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_MASK__CPL_TIMEOUT_MASK_MASK                                          0x00004000L
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_MASK__CPL_ABORT_ERR_MASK_MASK                                        0x00008000L
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_MASK__UNEXP_CPL_MASK_MASK                                            0x00010000L
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_MASK__RCV_OVFL_MASK_MASK                                             0x00020000L
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_MASK__MAL_TLP_MASK_MASK                                              0x00040000L
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_MASK__ECRC_ERR_MASK_MASK                                             0x00080000L
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_MASK__UNSUPP_REQ_ERR_MASK_MASK                                       0x00100000L
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_MASK__ACS_VIOLATION_MASK_MASK                                        0x00200000L
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_MASK__UNCORR_INT_ERR_MASK_MASK                                       0x00400000L
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_MASK__MC_BLOCKED_TLP_MASK_MASK                                       0x00800000L
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_MASK__ATOMICOP_EGRESS_BLOCKED_MASK_MASK                              0x01000000L
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_MASK__TLP_PREFIX_BLOCKED_ERR_MASK_MASK                               0x02000000L
//BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_SEVERITY
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_SEVERITY__DLP_ERR_SEVERITY__SHIFT                                    0x4
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_SEVERITY__SURPDN_ERR_SEVERITY__SHIFT                                 0x5
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_SEVERITY__PSN_ERR_SEVERITY__SHIFT                                    0xc
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_SEVERITY__FC_ERR_SEVERITY__SHIFT                                     0xd
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_SEVERITY__CPL_TIMEOUT_SEVERITY__SHIFT                                0xe
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_SEVERITY__CPL_ABORT_ERR_SEVERITY__SHIFT                              0xf
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_SEVERITY__UNEXP_CPL_SEVERITY__SHIFT                                  0x10
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_SEVERITY__RCV_OVFL_SEVERITY__SHIFT                                   0x11
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_SEVERITY__MAL_TLP_SEVERITY__SHIFT                                    0x12
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_SEVERITY__ECRC_ERR_SEVERITY__SHIFT                                   0x13
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_SEVERITY__UNSUPP_REQ_ERR_SEVERITY__SHIFT                             0x14
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_SEVERITY__ACS_VIOLATION_SEVERITY__SHIFT                              0x15
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_SEVERITY__UNCORR_INT_ERR_SEVERITY__SHIFT                             0x16
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_SEVERITY__MC_BLOCKED_TLP_SEVERITY__SHIFT                             0x17
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_SEVERITY__ATOMICOP_EGRESS_BLOCKED_SEVERITY__SHIFT                    0x18
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_SEVERITY__TLP_PREFIX_BLOCKED_ERR_SEVERITY__SHIFT                     0x19
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_SEVERITY__DLP_ERR_SEVERITY_MASK                                      0x00000010L
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_SEVERITY__SURPDN_ERR_SEVERITY_MASK                                   0x00000020L
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_SEVERITY__PSN_ERR_SEVERITY_MASK                                      0x00001000L
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_SEVERITY__FC_ERR_SEVERITY_MASK                                       0x00002000L
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_SEVERITY__CPL_TIMEOUT_SEVERITY_MASK                                  0x00004000L
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_SEVERITY__CPL_ABORT_ERR_SEVERITY_MASK                                0x00008000L
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_SEVERITY__UNEXP_CPL_SEVERITY_MASK                                    0x00010000L
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_SEVERITY__RCV_OVFL_SEVERITY_MASK                                     0x00020000L
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_SEVERITY__MAL_TLP_SEVERITY_MASK                                      0x00040000L
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_SEVERITY__ECRC_ERR_SEVERITY_MASK                                     0x00080000L
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_SEVERITY__UNSUPP_REQ_ERR_SEVERITY_MASK                               0x00100000L
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_SEVERITY__ACS_VIOLATION_SEVERITY_MASK                                0x00200000L
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_SEVERITY__UNCORR_INT_ERR_SEVERITY_MASK                               0x00400000L
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_SEVERITY__MC_BLOCKED_TLP_SEVERITY_MASK                               0x00800000L
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_SEVERITY__ATOMICOP_EGRESS_BLOCKED_SEVERITY_MASK                      0x01000000L
#define BIF_CFG_DEV1_RC0_PCIE_UNCORR_ERR_SEVERITY__TLP_PREFIX_BLOCKED_ERR_SEVERITY_MASK                       0x02000000L
//BIF_CFG_DEV1_RC0_PCIE_CORR_ERR_STATUS
#define BIF_CFG_DEV1_RC0_PCIE_CORR_ERR_STATUS__RCV_ERR_STATUS__SHIFT                                          0x0
#define BIF_CFG_DEV1_RC0_PCIE_CORR_ERR_STATUS__BAD_TLP_STATUS__SHIFT                                          0x6
#define BIF_CFG_DEV1_RC0_PCIE_CORR_ERR_STATUS__BAD_DLLP_STATUS__SHIFT                                         0x7
#define BIF_CFG_DEV1_RC0_PCIE_CORR_ERR_STATUS__REPLAY_NUM_ROLLOVER_STATUS__SHIFT                              0x8
#define BIF_CFG_DEV1_RC0_PCIE_CORR_ERR_STATUS__REPLAY_TIMER_TIMEOUT_STATUS__SHIFT                             0xc
#define BIF_CFG_DEV1_RC0_PCIE_CORR_ERR_STATUS__ADVISORY_NONFATAL_ERR_STATUS__SHIFT                            0xd
#define BIF_CFG_DEV1_RC0_PCIE_CORR_ERR_STATUS__CORR_INT_ERR_STATUS__SHIFT                                     0xe
#define BIF_CFG_DEV1_RC0_PCIE_CORR_ERR_STATUS__HDR_LOG_OVFL_STATUS__SHIFT                                     0xf
#define BIF_CFG_DEV1_RC0_PCIE_CORR_ERR_STATUS__RCV_ERR_STATUS_MASK                                            0x00000001L
#define BIF_CFG_DEV1_RC0_PCIE_CORR_ERR_STATUS__BAD_TLP_STATUS_MASK                                            0x00000040L
#define BIF_CFG_DEV1_RC0_PCIE_CORR_ERR_STATUS__BAD_DLLP_STATUS_MASK                                           0x00000080L
#define BIF_CFG_DEV1_RC0_PCIE_CORR_ERR_STATUS__REPLAY_NUM_ROLLOVER_STATUS_MASK                                0x00000100L
#define BIF_CFG_DEV1_RC0_PCIE_CORR_ERR_STATUS__REPLAY_TIMER_TIMEOUT_STATUS_MASK                               0x00001000L
#define BIF_CFG_DEV1_RC0_PCIE_CORR_ERR_STATUS__ADVISORY_NONFATAL_ERR_STATUS_MASK                              0x00002000L
#define BIF_CFG_DEV1_RC0_PCIE_CORR_ERR_STATUS__CORR_INT_ERR_STATUS_MASK                                       0x00004000L
#define BIF_CFG_DEV1_RC0_PCIE_CORR_ERR_STATUS__HDR_LOG_OVFL_STATUS_MASK                                       0x00008000L
//BIF_CFG_DEV1_RC0_PCIE_CORR_ERR_MASK
#define BIF_CFG_DEV1_RC0_PCIE_CORR_ERR_MASK__RCV_ERR_MASK__SHIFT                                              0x0
#define BIF_CFG_DEV1_RC0_PCIE_CORR_ERR_MASK__BAD_TLP_MASK__SHIFT                                              0x6
#define BIF_CFG_DEV1_RC0_PCIE_CORR_ERR_MASK__BAD_DLLP_MASK__SHIFT                                             0x7
#define BIF_CFG_DEV1_RC0_PCIE_CORR_ERR_MASK__REPLAY_NUM_ROLLOVER_MASK__SHIFT                                  0x8
#define BIF_CFG_DEV1_RC0_PCIE_CORR_ERR_MASK__REPLAY_TIMER_TIMEOUT_MASK__SHIFT                                 0xc
#define BIF_CFG_DEV1_RC0_PCIE_CORR_ERR_MASK__ADVISORY_NONFATAL_ERR_MASK__SHIFT                                0xd
#define BIF_CFG_DEV1_RC0_PCIE_CORR_ERR_MASK__CORR_INT_ERR_MASK__SHIFT                                         0xe
#define BIF_CFG_DEV1_RC0_PCIE_CORR_ERR_MASK__HDR_LOG_OVFL_MASK__SHIFT                                         0xf
#define BIF_CFG_DEV1_RC0_PCIE_CORR_ERR_MASK__RCV_ERR_MASK_MASK                                                0x00000001L
#define BIF_CFG_DEV1_RC0_PCIE_CORR_ERR_MASK__BAD_TLP_MASK_MASK                                                0x00000040L
#define BIF_CFG_DEV1_RC0_PCIE_CORR_ERR_MASK__BAD_DLLP_MASK_MASK                                               0x00000080L
#define BIF_CFG_DEV1_RC0_PCIE_CORR_ERR_MASK__REPLAY_NUM_ROLLOVER_MASK_MASK                                    0x00000100L
#define BIF_CFG_DEV1_RC0_PCIE_CORR_ERR_MASK__REPLAY_TIMER_TIMEOUT_MASK_MASK                                   0x00001000L
#define BIF_CFG_DEV1_RC0_PCIE_CORR_ERR_MASK__ADVISORY_NONFATAL_ERR_MASK_MASK                                  0x00002000L
#define BIF_CFG_DEV1_RC0_PCIE_CORR_ERR_MASK__CORR_INT_ERR_MASK_MASK                                           0x00004000L
#define BIF_CFG_DEV1_RC0_PCIE_CORR_ERR_MASK__HDR_LOG_OVFL_MASK_MASK                                           0x00008000L
//BIF_CFG_DEV1_RC0_PCIE_ADV_ERR_CAP_CNTL
#define BIF_CFG_DEV1_RC0_PCIE_ADV_ERR_CAP_CNTL__FIRST_ERR_PTR__SHIFT                                          0x0
#define BIF_CFG_DEV1_RC0_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_CAP__SHIFT                                           0x5
#define BIF_CFG_DEV1_RC0_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_EN__SHIFT                                            0x6
#define BIF_CFG_DEV1_RC0_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_CAP__SHIFT                                         0x7
#define BIF_CFG_DEV1_RC0_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_EN__SHIFT                                          0x8
#define BIF_CFG_DEV1_RC0_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_CAP__SHIFT                                     0x9
#define BIF_CFG_DEV1_RC0_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_EN__SHIFT                                      0xa
#define BIF_CFG_DEV1_RC0_PCIE_ADV_ERR_CAP_CNTL__TLP_PREFIX_LOG_PRESENT__SHIFT                                 0xb
#define BIF_CFG_DEV1_RC0_PCIE_ADV_ERR_CAP_CNTL__FIRST_ERR_PTR_MASK                                            0x0000001FL
#define BIF_CFG_DEV1_RC0_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_CAP_MASK                                             0x00000020L
#define BIF_CFG_DEV1_RC0_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_EN_MASK                                              0x00000040L
#define BIF_CFG_DEV1_RC0_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_CAP_MASK                                           0x00000080L
#define BIF_CFG_DEV1_RC0_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_EN_MASK                                            0x00000100L
#define BIF_CFG_DEV1_RC0_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_CAP_MASK                                       0x00000200L
#define BIF_CFG_DEV1_RC0_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_EN_MASK                                        0x00000400L
#define BIF_CFG_DEV1_RC0_PCIE_ADV_ERR_CAP_CNTL__TLP_PREFIX_LOG_PRESENT_MASK                                   0x00000800L
//BIF_CFG_DEV1_RC0_PCIE_HDR_LOG0
#define BIF_CFG_DEV1_RC0_PCIE_HDR_LOG0__TLP_HDR__SHIFT                                                        0x0
#define BIF_CFG_DEV1_RC0_PCIE_HDR_LOG0__TLP_HDR_MASK                                                          0xFFFFFFFFL
//BIF_CFG_DEV1_RC0_PCIE_HDR_LOG1
#define BIF_CFG_DEV1_RC0_PCIE_HDR_LOG1__TLP_HDR__SHIFT                                                        0x0
#define BIF_CFG_DEV1_RC0_PCIE_HDR_LOG1__TLP_HDR_MASK                                                          0xFFFFFFFFL
//BIF_CFG_DEV1_RC0_PCIE_HDR_LOG2
#define BIF_CFG_DEV1_RC0_PCIE_HDR_LOG2__TLP_HDR__SHIFT                                                        0x0
#define BIF_CFG_DEV1_RC0_PCIE_HDR_LOG2__TLP_HDR_MASK                                                          0xFFFFFFFFL
//BIF_CFG_DEV1_RC0_PCIE_HDR_LOG3
#define BIF_CFG_DEV1_RC0_PCIE_HDR_LOG3__TLP_HDR__SHIFT                                                        0x0
#define BIF_CFG_DEV1_RC0_PCIE_HDR_LOG3__TLP_HDR_MASK                                                          0xFFFFFFFFL
//BIF_CFG_DEV1_RC0_PCIE_ROOT_ERR_CMD
#define BIF_CFG_DEV1_RC0_PCIE_ROOT_ERR_CMD__CORR_ERR_REP_EN__SHIFT                                            0x0
#define BIF_CFG_DEV1_RC0_PCIE_ROOT_ERR_CMD__NONFATAL_ERR_REP_EN__SHIFT                                        0x1
#define BIF_CFG_DEV1_RC0_PCIE_ROOT_ERR_CMD__FATAL_ERR_REP_EN__SHIFT                                           0x2
#define BIF_CFG_DEV1_RC0_PCIE_ROOT_ERR_CMD__CORR_ERR_REP_EN_MASK                                              0x00000001L
#define BIF_CFG_DEV1_RC0_PCIE_ROOT_ERR_CMD__NONFATAL_ERR_REP_EN_MASK                                          0x00000002L
#define BIF_CFG_DEV1_RC0_PCIE_ROOT_ERR_CMD__FATAL_ERR_REP_EN_MASK                                             0x00000004L
//BIF_CFG_DEV1_RC0_PCIE_ROOT_ERR_STATUS
#define BIF_CFG_DEV1_RC0_PCIE_ROOT_ERR_STATUS__ERR_CORR_RCVD__SHIFT                                           0x0
#define BIF_CFG_DEV1_RC0_PCIE_ROOT_ERR_STATUS__MULT_ERR_CORR_RCVD__SHIFT                                      0x1
#define BIF_CFG_DEV1_RC0_PCIE_ROOT_ERR_STATUS__ERR_FATAL_NONFATAL_RCVD__SHIFT                                 0x2
#define BIF_CFG_DEV1_RC0_PCIE_ROOT_ERR_STATUS__MULT_ERR_FATAL_NONFATAL_RCVD__SHIFT                            0x3
#define BIF_CFG_DEV1_RC0_PCIE_ROOT_ERR_STATUS__FIRST_UNCORRECTABLE_FATAL__SHIFT                               0x4
#define BIF_CFG_DEV1_RC0_PCIE_ROOT_ERR_STATUS__NONFATAL_ERROR_MSG_RCVD__SHIFT                                 0x5
#define BIF_CFG_DEV1_RC0_PCIE_ROOT_ERR_STATUS__FATAL_ERROR_MSG_RCVD__SHIFT                                    0x6
#define BIF_CFG_DEV1_RC0_PCIE_ROOT_ERR_STATUS__ADV_ERR_INT_MSG_NUM__SHIFT                                     0x1b
#define BIF_CFG_DEV1_RC0_PCIE_ROOT_ERR_STATUS__ERR_CORR_RCVD_MASK                                             0x00000001L
#define BIF_CFG_DEV1_RC0_PCIE_ROOT_ERR_STATUS__MULT_ERR_CORR_RCVD_MASK                                        0x00000002L
#define BIF_CFG_DEV1_RC0_PCIE_ROOT_ERR_STATUS__ERR_FATAL_NONFATAL_RCVD_MASK                                   0x00000004L
#define BIF_CFG_DEV1_RC0_PCIE_ROOT_ERR_STATUS__MULT_ERR_FATAL_NONFATAL_RCVD_MASK                              0x00000008L
#define BIF_CFG_DEV1_RC0_PCIE_ROOT_ERR_STATUS__FIRST_UNCORRECTABLE_FATAL_MASK                                 0x00000010L
#define BIF_CFG_DEV1_RC0_PCIE_ROOT_ERR_STATUS__NONFATAL_ERROR_MSG_RCVD_MASK                                   0x00000020L
#define BIF_CFG_DEV1_RC0_PCIE_ROOT_ERR_STATUS__FATAL_ERROR_MSG_RCVD_MASK                                      0x00000040L
#define BIF_CFG_DEV1_RC0_PCIE_ROOT_ERR_STATUS__ADV_ERR_INT_MSG_NUM_MASK                                       0xF8000000L
//BIF_CFG_DEV1_RC0_PCIE_ERR_SRC_ID
#define BIF_CFG_DEV1_RC0_PCIE_ERR_SRC_ID__ERR_CORR_SRC_ID__SHIFT                                              0x0
#define BIF_CFG_DEV1_RC0_PCIE_ERR_SRC_ID__ERR_FATAL_NONFATAL_SRC_ID__SHIFT                                    0x10
#define BIF_CFG_DEV1_RC0_PCIE_ERR_SRC_ID__ERR_CORR_SRC_ID_MASK                                                0x0000FFFFL
#define BIF_CFG_DEV1_RC0_PCIE_ERR_SRC_ID__ERR_FATAL_NONFATAL_SRC_ID_MASK                                      0xFFFF0000L
//BIF_CFG_DEV1_RC0_PCIE_TLP_PREFIX_LOG0
#define BIF_CFG_DEV1_RC0_PCIE_TLP_PREFIX_LOG0__TLP_PREFIX__SHIFT                                              0x0
#define BIF_CFG_DEV1_RC0_PCIE_TLP_PREFIX_LOG0__TLP_PREFIX_MASK                                                0xFFFFFFFFL
//BIF_CFG_DEV1_RC0_PCIE_TLP_PREFIX_LOG1
#define BIF_CFG_DEV1_RC0_PCIE_TLP_PREFIX_LOG1__TLP_PREFIX__SHIFT                                              0x0
#define BIF_CFG_DEV1_RC0_PCIE_TLP_PREFIX_LOG1__TLP_PREFIX_MASK                                                0xFFFFFFFFL
//BIF_CFG_DEV1_RC0_PCIE_TLP_PREFIX_LOG2
#define BIF_CFG_DEV1_RC0_PCIE_TLP_PREFIX_LOG2__TLP_PREFIX__SHIFT                                              0x0
#define BIF_CFG_DEV1_RC0_PCIE_TLP_PREFIX_LOG2__TLP_PREFIX_MASK                                                0xFFFFFFFFL
//BIF_CFG_DEV1_RC0_PCIE_TLP_PREFIX_LOG3
#define BIF_CFG_DEV1_RC0_PCIE_TLP_PREFIX_LOG3__TLP_PREFIX__SHIFT                                              0x0
#define BIF_CFG_DEV1_RC0_PCIE_TLP_PREFIX_LOG3__TLP_PREFIX_MASK                                                0xFFFFFFFFL
//BIF_CFG_DEV1_RC0_PCIE_SECONDARY_ENH_CAP_LIST
#define BIF_CFG_DEV1_RC0_PCIE_SECONDARY_ENH_CAP_LIST__CAP_ID__SHIFT                                           0x0
#define BIF_CFG_DEV1_RC0_PCIE_SECONDARY_ENH_CAP_LIST__CAP_VER__SHIFT                                          0x10
#define BIF_CFG_DEV1_RC0_PCIE_SECONDARY_ENH_CAP_LIST__NEXT_PTR__SHIFT                                         0x14
#define BIF_CFG_DEV1_RC0_PCIE_SECONDARY_ENH_CAP_LIST__CAP_ID_MASK                                             0x0000FFFFL
#define BIF_CFG_DEV1_RC0_PCIE_SECONDARY_ENH_CAP_LIST__CAP_VER_MASK                                            0x000F0000L
#define BIF_CFG_DEV1_RC0_PCIE_SECONDARY_ENH_CAP_LIST__NEXT_PTR_MASK                                           0xFFF00000L
//BIF_CFG_DEV1_RC0_PCIE_LINK_CNTL3
#define BIF_CFG_DEV1_RC0_PCIE_LINK_CNTL3__PERFORM_EQUALIZATION__SHIFT                                         0x0
#define BIF_CFG_DEV1_RC0_PCIE_LINK_CNTL3__LINK_EQUALIZATION_REQ_INT_EN__SHIFT                                 0x1
#define BIF_CFG_DEV1_RC0_PCIE_LINK_CNTL3__RESERVED__SHIFT                                                     0x2
#define BIF_CFG_DEV1_RC0_PCIE_LINK_CNTL3__PERFORM_EQUALIZATION_MASK                                           0x00000001L
#define BIF_CFG_DEV1_RC0_PCIE_LINK_CNTL3__LINK_EQUALIZATION_REQ_INT_EN_MASK                                   0x00000002L
#define BIF_CFG_DEV1_RC0_PCIE_LINK_CNTL3__RESERVED_MASK                                                       0xFFFFFFFCL
//BIF_CFG_DEV1_RC0_PCIE_LANE_ERROR_STATUS
#define BIF_CFG_DEV1_RC0_PCIE_LANE_ERROR_STATUS__LANE_ERROR_STATUS_BITS__SHIFT                                0x0
#define BIF_CFG_DEV1_RC0_PCIE_LANE_ERROR_STATUS__RESERVED__SHIFT                                              0x10
#define BIF_CFG_DEV1_RC0_PCIE_LANE_ERROR_STATUS__LANE_ERROR_STATUS_BITS_MASK                                  0x0000FFFFL
#define BIF_CFG_DEV1_RC0_PCIE_LANE_ERROR_STATUS__RESERVED_MASK                                                0xFFFF0000L
//BIF_CFG_DEV1_RC0_PCIE_LANE_0_EQUALIZATION_CNTL
#define BIF_CFG_DEV1_RC0_PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                      0x0
#define BIF_CFG_DEV1_RC0_PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                 0x4
#define BIF_CFG_DEV1_RC0_PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                        0x8
#define BIF_CFG_DEV1_RC0_PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                   0xc
#define BIF_CFG_DEV1_RC0_PCIE_LANE_0_EQUALIZATION_CNTL__RESERVED__SHIFT                                       0xf
#define BIF_CFG_DEV1_RC0_PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                        0x000FL
#define BIF_CFG_DEV1_RC0_PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                   0x0070L
#define BIF_CFG_DEV1_RC0_PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                          0x0F00L
#define BIF_CFG_DEV1_RC0_PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                     0x7000L
#define BIF_CFG_DEV1_RC0_PCIE_LANE_0_EQUALIZATION_CNTL__RESERVED_MASK                                         0x8000L
//BIF_CFG_DEV1_RC0_PCIE_LANE_1_EQUALIZATION_CNTL
#define BIF_CFG_DEV1_RC0_PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                      0x0
#define BIF_CFG_DEV1_RC0_PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                 0x4
#define BIF_CFG_DEV1_RC0_PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                        0x8
#define BIF_CFG_DEV1_RC0_PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                   0xc
#define BIF_CFG_DEV1_RC0_PCIE_LANE_1_EQUALIZATION_CNTL__RESERVED__SHIFT                                       0xf
#define BIF_CFG_DEV1_RC0_PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                        0x000FL
#define BIF_CFG_DEV1_RC0_PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                   0x0070L
#define BIF_CFG_DEV1_RC0_PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                          0x0F00L
#define BIF_CFG_DEV1_RC0_PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                     0x7000L
#define BIF_CFG_DEV1_RC0_PCIE_LANE_1_EQUALIZATION_CNTL__RESERVED_MASK                                         0x8000L
//BIF_CFG_DEV1_RC0_PCIE_LANE_2_EQUALIZATION_CNTL
#define BIF_CFG_DEV1_RC0_PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                      0x0
#define BIF_CFG_DEV1_RC0_PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                 0x4
#define BIF_CFG_DEV1_RC0_PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                        0x8
#define BIF_CFG_DEV1_RC0_PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                   0xc
#define BIF_CFG_DEV1_RC0_PCIE_LANE_2_EQUALIZATION_CNTL__RESERVED__SHIFT                                       0xf
#define BIF_CFG_DEV1_RC0_PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                        0x000FL
#define BIF_CFG_DEV1_RC0_PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                   0x0070L
#define BIF_CFG_DEV1_RC0_PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                          0x0F00L
#define BIF_CFG_DEV1_RC0_PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                     0x7000L
#define BIF_CFG_DEV1_RC0_PCIE_LANE_2_EQUALIZATION_CNTL__RESERVED_MASK                                         0x8000L
//BIF_CFG_DEV1_RC0_PCIE_LANE_3_EQUALIZATION_CNTL
#define BIF_CFG_DEV1_RC0_PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                      0x0
#define BIF_CFG_DEV1_RC0_PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                 0x4
#define BIF_CFG_DEV1_RC0_PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                        0x8
#define BIF_CFG_DEV1_RC0_PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                   0xc
#define BIF_CFG_DEV1_RC0_PCIE_LANE_3_EQUALIZATION_CNTL__RESERVED__SHIFT                                       0xf
#define BIF_CFG_DEV1_RC0_PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                        0x000FL
#define BIF_CFG_DEV1_RC0_PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                   0x0070L
#define BIF_CFG_DEV1_RC0_PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                          0x0F00L
#define BIF_CFG_DEV1_RC0_PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                     0x7000L
#define BIF_CFG_DEV1_RC0_PCIE_LANE_3_EQUALIZATION_CNTL__RESERVED_MASK                                         0x8000L
//BIF_CFG_DEV1_RC0_PCIE_LANE_4_EQUALIZATION_CNTL
#define BIF_CFG_DEV1_RC0_PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                      0x0
#define BIF_CFG_DEV1_RC0_PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                 0x4
#define BIF_CFG_DEV1_RC0_PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                        0x8
#define BIF_CFG_DEV1_RC0_PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                   0xc
#define BIF_CFG_DEV1_RC0_PCIE_LANE_4_EQUALIZATION_CNTL__RESERVED__SHIFT                                       0xf
#define BIF_CFG_DEV1_RC0_PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                        0x000FL
#define BIF_CFG_DEV1_RC0_PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                   0x0070L
#define BIF_CFG_DEV1_RC0_PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                          0x0F00L
#define BIF_CFG_DEV1_RC0_PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                     0x7000L
#define BIF_CFG_DEV1_RC0_PCIE_LANE_4_EQUALIZATION_CNTL__RESERVED_MASK                                         0x8000L
//BIF_CFG_DEV1_RC0_PCIE_LANE_5_EQUALIZATION_CNTL
#define BIF_CFG_DEV1_RC0_PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                      0x0
#define BIF_CFG_DEV1_RC0_PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                 0x4
#define BIF_CFG_DEV1_RC0_PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                        0x8
#define BIF_CFG_DEV1_RC0_PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                   0xc
#define BIF_CFG_DEV1_RC0_PCIE_LANE_5_EQUALIZATION_CNTL__RESERVED__SHIFT                                       0xf
#define BIF_CFG_DEV1_RC0_PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                        0x000FL
#define BIF_CFG_DEV1_RC0_PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                   0x0070L
#define BIF_CFG_DEV1_RC0_PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                          0x0F00L
#define BIF_CFG_DEV1_RC0_PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                     0x7000L
#define BIF_CFG_DEV1_RC0_PCIE_LANE_5_EQUALIZATION_CNTL__RESERVED_MASK                                         0x8000L
//BIF_CFG_DEV1_RC0_PCIE_LANE_6_EQUALIZATION_CNTL
#define BIF_CFG_DEV1_RC0_PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                      0x0
#define BIF_CFG_DEV1_RC0_PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                 0x4
#define BIF_CFG_DEV1_RC0_PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                        0x8
#define BIF_CFG_DEV1_RC0_PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                   0xc
#define BIF_CFG_DEV1_RC0_PCIE_LANE_6_EQUALIZATION_CNTL__RESERVED__SHIFT                                       0xf
#define BIF_CFG_DEV1_RC0_PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                        0x000FL
#define BIF_CFG_DEV1_RC0_PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                   0x0070L
#define BIF_CFG_DEV1_RC0_PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                          0x0F00L
#define BIF_CFG_DEV1_RC0_PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                     0x7000L
#define BIF_CFG_DEV1_RC0_PCIE_LANE_6_EQUALIZATION_CNTL__RESERVED_MASK                                         0x8000L
//BIF_CFG_DEV1_RC0_PCIE_LANE_7_EQUALIZATION_CNTL
#define BIF_CFG_DEV1_RC0_PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                      0x0
#define BIF_CFG_DEV1_RC0_PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                 0x4
#define BIF_CFG_DEV1_RC0_PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                        0x8
#define BIF_CFG_DEV1_RC0_PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                   0xc
#define BIF_CFG_DEV1_RC0_PCIE_LANE_7_EQUALIZATION_CNTL__RESERVED__SHIFT                                       0xf
#define BIF_CFG_DEV1_RC0_PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                        0x000FL
#define BIF_CFG_DEV1_RC0_PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                   0x0070L
#define BIF_CFG_DEV1_RC0_PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                          0x0F00L
#define BIF_CFG_DEV1_RC0_PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                     0x7000L
#define BIF_CFG_DEV1_RC0_PCIE_LANE_7_EQUALIZATION_CNTL__RESERVED_MASK                                         0x8000L
//BIF_CFG_DEV1_RC0_PCIE_LANE_8_EQUALIZATION_CNTL
#define BIF_CFG_DEV1_RC0_PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                      0x0
#define BIF_CFG_DEV1_RC0_PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                 0x4
#define BIF_CFG_DEV1_RC0_PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                        0x8
#define BIF_CFG_DEV1_RC0_PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                   0xc
#define BIF_CFG_DEV1_RC0_PCIE_LANE_8_EQUALIZATION_CNTL__RESERVED__SHIFT                                       0xf
#define BIF_CFG_DEV1_RC0_PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                        0x000FL
#define BIF_CFG_DEV1_RC0_PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                   0x0070L
#define BIF_CFG_DEV1_RC0_PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                          0x0F00L
#define BIF_CFG_DEV1_RC0_PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                     0x7000L
#define BIF_CFG_DEV1_RC0_PCIE_LANE_8_EQUALIZATION_CNTL__RESERVED_MASK                                         0x8000L
//BIF_CFG_DEV1_RC0_PCIE_LANE_9_EQUALIZATION_CNTL
#define BIF_CFG_DEV1_RC0_PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                      0x0
#define BIF_CFG_DEV1_RC0_PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                 0x4
#define BIF_CFG_DEV1_RC0_PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                        0x8
#define BIF_CFG_DEV1_RC0_PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                   0xc
#define BIF_CFG_DEV1_RC0_PCIE_LANE_9_EQUALIZATION_CNTL__RESERVED__SHIFT                                       0xf
#define BIF_CFG_DEV1_RC0_PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                        0x000FL
#define BIF_CFG_DEV1_RC0_PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                   0x0070L
#define BIF_CFG_DEV1_RC0_PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                          0x0F00L
#define BIF_CFG_DEV1_RC0_PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                     0x7000L
#define BIF_CFG_DEV1_RC0_PCIE_LANE_9_EQUALIZATION_CNTL__RESERVED_MASK                                         0x8000L
//BIF_CFG_DEV1_RC0_PCIE_LANE_10_EQUALIZATION_CNTL
#define BIF_CFG_DEV1_RC0_PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                     0x0
#define BIF_CFG_DEV1_RC0_PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                0x4
#define BIF_CFG_DEV1_RC0_PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                       0x8
#define BIF_CFG_DEV1_RC0_PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                  0xc
#define BIF_CFG_DEV1_RC0_PCIE_LANE_10_EQUALIZATION_CNTL__RESERVED__SHIFT                                      0xf
#define BIF_CFG_DEV1_RC0_PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                       0x000FL
#define BIF_CFG_DEV1_RC0_PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                  0x0070L
#define BIF_CFG_DEV1_RC0_PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                         0x0F00L
#define BIF_CFG_DEV1_RC0_PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                    0x7000L
#define BIF_CFG_DEV1_RC0_PCIE_LANE_10_EQUALIZATION_CNTL__RESERVED_MASK                                        0x8000L
//BIF_CFG_DEV1_RC0_PCIE_LANE_11_EQUALIZATION_CNTL
#define BIF_CFG_DEV1_RC0_PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                     0x0
#define BIF_CFG_DEV1_RC0_PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                0x4
#define BIF_CFG_DEV1_RC0_PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                       0x8
#define BIF_CFG_DEV1_RC0_PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                  0xc
#define BIF_CFG_DEV1_RC0_PCIE_LANE_11_EQUALIZATION_CNTL__RESERVED__SHIFT                                      0xf
#define BIF_CFG_DEV1_RC0_PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                       0x000FL
#define BIF_CFG_DEV1_RC0_PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                  0x0070L
#define BIF_CFG_DEV1_RC0_PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                         0x0F00L
#define BIF_CFG_DEV1_RC0_PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                    0x7000L
#define BIF_CFG_DEV1_RC0_PCIE_LANE_11_EQUALIZATION_CNTL__RESERVED_MASK                                        0x8000L
//BIF_CFG_DEV1_RC0_PCIE_LANE_12_EQUALIZATION_CNTL
#define BIF_CFG_DEV1_RC0_PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                     0x0
#define BIF_CFG_DEV1_RC0_PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                0x4
#define BIF_CFG_DEV1_RC0_PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                       0x8
#define BIF_CFG_DEV1_RC0_PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                  0xc
#define BIF_CFG_DEV1_RC0_PCIE_LANE_12_EQUALIZATION_CNTL__RESERVED__SHIFT                                      0xf
#define BIF_CFG_DEV1_RC0_PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                       0x000FL
#define BIF_CFG_DEV1_RC0_PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                  0x0070L
#define BIF_CFG_DEV1_RC0_PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                         0x0F00L
#define BIF_CFG_DEV1_RC0_PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                    0x7000L
#define BIF_CFG_DEV1_RC0_PCIE_LANE_12_EQUALIZATION_CNTL__RESERVED_MASK                                        0x8000L
//BIF_CFG_DEV1_RC0_PCIE_LANE_13_EQUALIZATION_CNTL
#define BIF_CFG_DEV1_RC0_PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                     0x0
#define BIF_CFG_DEV1_RC0_PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                0x4
#define BIF_CFG_DEV1_RC0_PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                       0x8
#define BIF_CFG_DEV1_RC0_PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                  0xc
#define BIF_CFG_DEV1_RC0_PCIE_LANE_13_EQUALIZATION_CNTL__RESERVED__SHIFT                                      0xf
#define BIF_CFG_DEV1_RC0_PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                       0x000FL
#define BIF_CFG_DEV1_RC0_PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                  0x0070L
#define BIF_CFG_DEV1_RC0_PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                         0x0F00L
#define BIF_CFG_DEV1_RC0_PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                    0x7000L
#define BIF_CFG_DEV1_RC0_PCIE_LANE_13_EQUALIZATION_CNTL__RESERVED_MASK                                        0x8000L
//BIF_CFG_DEV1_RC0_PCIE_LANE_14_EQUALIZATION_CNTL
#define BIF_CFG_DEV1_RC0_PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                     0x0
#define BIF_CFG_DEV1_RC0_PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                0x4
#define BIF_CFG_DEV1_RC0_PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                       0x8
#define BIF_CFG_DEV1_RC0_PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                  0xc
#define BIF_CFG_DEV1_RC0_PCIE_LANE_14_EQUALIZATION_CNTL__RESERVED__SHIFT                                      0xf
#define BIF_CFG_DEV1_RC0_PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                       0x000FL
#define BIF_CFG_DEV1_RC0_PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                  0x0070L
#define BIF_CFG_DEV1_RC0_PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                         0x0F00L
#define BIF_CFG_DEV1_RC0_PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                    0x7000L
#define BIF_CFG_DEV1_RC0_PCIE_LANE_14_EQUALIZATION_CNTL__RESERVED_MASK                                        0x8000L
//BIF_CFG_DEV1_RC0_PCIE_LANE_15_EQUALIZATION_CNTL
#define BIF_CFG_DEV1_RC0_PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                     0x0
#define BIF_CFG_DEV1_RC0_PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                0x4
#define BIF_CFG_DEV1_RC0_PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                       0x8
#define BIF_CFG_DEV1_RC0_PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                  0xc
#define BIF_CFG_DEV1_RC0_PCIE_LANE_15_EQUALIZATION_CNTL__RESERVED__SHIFT                                      0xf
#define BIF_CFG_DEV1_RC0_PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                       0x000FL
#define BIF_CFG_DEV1_RC0_PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                  0x0070L
#define BIF_CFG_DEV1_RC0_PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                         0x0F00L
#define BIF_CFG_DEV1_RC0_PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                    0x7000L
#define BIF_CFG_DEV1_RC0_PCIE_LANE_15_EQUALIZATION_CNTL__RESERVED_MASK                                        0x8000L
//BIF_CFG_DEV1_RC0_PCIE_ACS_ENH_CAP_LIST
#define BIF_CFG_DEV1_RC0_PCIE_ACS_ENH_CAP_LIST__CAP_ID__SHIFT                                                 0x0
#define BIF_CFG_DEV1_RC0_PCIE_ACS_ENH_CAP_LIST__CAP_VER__SHIFT                                                0x10
#define BIF_CFG_DEV1_RC0_PCIE_ACS_ENH_CAP_LIST__NEXT_PTR__SHIFT                                               0x14
#define BIF_CFG_DEV1_RC0_PCIE_ACS_ENH_CAP_LIST__CAP_ID_MASK                                                   0x0000FFFFL
#define BIF_CFG_DEV1_RC0_PCIE_ACS_ENH_CAP_LIST__CAP_VER_MASK                                                  0x000F0000L
#define BIF_CFG_DEV1_RC0_PCIE_ACS_ENH_CAP_LIST__NEXT_PTR_MASK                                                 0xFFF00000L
//BIF_CFG_DEV1_RC0_PCIE_ACS_CAP
#define BIF_CFG_DEV1_RC0_PCIE_ACS_CAP__SOURCE_VALIDATION__SHIFT                                               0x0
#define BIF_CFG_DEV1_RC0_PCIE_ACS_CAP__TRANSLATION_BLOCKING__SHIFT                                            0x1
#define BIF_CFG_DEV1_RC0_PCIE_ACS_CAP__P2P_REQUEST_REDIRECT__SHIFT                                            0x2
#define BIF_CFG_DEV1_RC0_PCIE_ACS_CAP__P2P_COMPLETION_REDIRECT__SHIFT                                         0x3
#define BIF_CFG_DEV1_RC0_PCIE_ACS_CAP__UPSTREAM_FORWARDING__SHIFT                                             0x4
#define BIF_CFG_DEV1_RC0_PCIE_ACS_CAP__P2P_EGRESS_CONTROL__SHIFT                                              0x5
#define BIF_CFG_DEV1_RC0_PCIE_ACS_CAP__DIRECT_TRANSLATED_P2P__SHIFT                                           0x6
#define BIF_CFG_DEV1_RC0_PCIE_ACS_CAP__EGRESS_CONTROL_VECTOR_SIZE__SHIFT                                      0x8
#define BIF_CFG_DEV1_RC0_PCIE_ACS_CAP__SOURCE_VALIDATION_MASK                                                 0x0001L
#define BIF_CFG_DEV1_RC0_PCIE_ACS_CAP__TRANSLATION_BLOCKING_MASK                                              0x0002L
#define BIF_CFG_DEV1_RC0_PCIE_ACS_CAP__P2P_REQUEST_REDIRECT_MASK                                              0x0004L
#define BIF_CFG_DEV1_RC0_PCIE_ACS_CAP__P2P_COMPLETION_REDIRECT_MASK                                           0x0008L
#define BIF_CFG_DEV1_RC0_PCIE_ACS_CAP__UPSTREAM_FORWARDING_MASK                                               0x0010L
#define BIF_CFG_DEV1_RC0_PCIE_ACS_CAP__P2P_EGRESS_CONTROL_MASK                                                0x0020L
#define BIF_CFG_DEV1_RC0_PCIE_ACS_CAP__DIRECT_TRANSLATED_P2P_MASK                                             0x0040L
#define BIF_CFG_DEV1_RC0_PCIE_ACS_CAP__EGRESS_CONTROL_VECTOR_SIZE_MASK                                        0xFF00L
//BIF_CFG_DEV1_RC0_PCIE_ACS_CNTL
#define BIF_CFG_DEV1_RC0_PCIE_ACS_CNTL__SOURCE_VALIDATION_EN__SHIFT                                           0x0
#define BIF_CFG_DEV1_RC0_PCIE_ACS_CNTL__TRANSLATION_BLOCKING_EN__SHIFT                                        0x1
#define BIF_CFG_DEV1_RC0_PCIE_ACS_CNTL__P2P_REQUEST_REDIRECT_EN__SHIFT                                        0x2
#define BIF_CFG_DEV1_RC0_PCIE_ACS_CNTL__P2P_COMPLETION_REDIRECT_EN__SHIFT                                     0x3
#define BIF_CFG_DEV1_RC0_PCIE_ACS_CNTL__UPSTREAM_FORWARDING_EN__SHIFT                                         0x4
#define BIF_CFG_DEV1_RC0_PCIE_ACS_CNTL__P2P_EGRESS_CONTROL_EN__SHIFT                                          0x5
#define BIF_CFG_DEV1_RC0_PCIE_ACS_CNTL__DIRECT_TRANSLATED_P2P_EN__SHIFT                                       0x6
#define BIF_CFG_DEV1_RC0_PCIE_ACS_CNTL__SOURCE_VALIDATION_EN_MASK                                             0x0001L
#define BIF_CFG_DEV1_RC0_PCIE_ACS_CNTL__TRANSLATION_BLOCKING_EN_MASK                                          0x0002L
#define BIF_CFG_DEV1_RC0_PCIE_ACS_CNTL__P2P_REQUEST_REDIRECT_EN_MASK                                          0x0004L
#define BIF_CFG_DEV1_RC0_PCIE_ACS_CNTL__P2P_COMPLETION_REDIRECT_EN_MASK                                       0x0008L
#define BIF_CFG_DEV1_RC0_PCIE_ACS_CNTL__UPSTREAM_FORWARDING_EN_MASK                                           0x0010L
#define BIF_CFG_DEV1_RC0_PCIE_ACS_CNTL__P2P_EGRESS_CONTROL_EN_MASK                                            0x0020L
#define BIF_CFG_DEV1_RC0_PCIE_ACS_CNTL__DIRECT_TRANSLATED_P2P_EN_MASK                                         0x0040L


// addressBlock: nbio_iohub_nb_pciedummy0_pciedummy_cfgdec
//NB_PCIEDUMMY0_0_DEVICE_VENDOR_ID
#define NB_PCIEDUMMY0_0_DEVICE_VENDOR_ID__VENDOR_ID__SHIFT                                                    0x0
#define NB_PCIEDUMMY0_0_DEVICE_VENDOR_ID__DEVICE_ID__SHIFT                                                    0x10
#define NB_PCIEDUMMY0_0_DEVICE_VENDOR_ID__VENDOR_ID_MASK                                                      0x0000FFFFL
#define NB_PCIEDUMMY0_0_DEVICE_VENDOR_ID__DEVICE_ID_MASK                                                      0xFFFF0000L
//NB_PCIEDUMMY0_0_STATUS_COMMAND
#define NB_PCIEDUMMY0_0_STATUS_COMMAND__COMMAND__SHIFT                                                        0x0
#define NB_PCIEDUMMY0_0_STATUS_COMMAND__STATUS__SHIFT                                                         0x10
#define NB_PCIEDUMMY0_0_STATUS_COMMAND__COMMAND_MASK                                                          0x0000FFFFL
#define NB_PCIEDUMMY0_0_STATUS_COMMAND__STATUS_MASK                                                           0xFFFF0000L
//NB_PCIEDUMMY0_0_CLASS_CODE_REVID
#define NB_PCIEDUMMY0_0_CLASS_CODE_REVID__REVID__SHIFT                                                        0x0
#define NB_PCIEDUMMY0_0_CLASS_CODE_REVID__CLASS_CODE__SHIFT                                                   0x8
#define NB_PCIEDUMMY0_0_CLASS_CODE_REVID__REVID_MASK                                                          0x000000FFL
#define NB_PCIEDUMMY0_0_CLASS_CODE_REVID__CLASS_CODE_MASK                                                     0xFFFFFF00L
//NB_PCIEDUMMY0_0_HEADER_TYPE
#define NB_PCIEDUMMY0_0_HEADER_TYPE__HEADER_TYPE__SHIFT                                                       0x10
#define NB_PCIEDUMMY0_0_HEADER_TYPE__DEVICE_TYPE__SHIFT                                                       0x17
#define NB_PCIEDUMMY0_0_HEADER_TYPE__HEADER_TYPE_MASK                                                         0x007F0000L
#define NB_PCIEDUMMY0_0_HEADER_TYPE__DEVICE_TYPE_MASK                                                         0x00800000L
//NB_PCIEDUMMY0_0_HEADER_TYPE_W
#define NB_PCIEDUMMY0_0_HEADER_TYPE_W__DEVICE_TYPE__SHIFT                                                     0x7
#define NB_PCIEDUMMY0_0_HEADER_TYPE_W__DEVICE_TYPE_MASK                                                       0x00000080L


// addressBlock: nbio_iohub_nb_pciedummy1_pciedummy_cfgdec
//NB_PCIEDUMMY1_0_DEVICE_VENDOR_ID
#define NB_PCIEDUMMY1_0_DEVICE_VENDOR_ID__VENDOR_ID__SHIFT                                                    0x0
#define NB_PCIEDUMMY1_0_DEVICE_VENDOR_ID__DEVICE_ID__SHIFT                                                    0x10
#define NB_PCIEDUMMY1_0_DEVICE_VENDOR_ID__VENDOR_ID_MASK                                                      0x0000FFFFL
#define NB_PCIEDUMMY1_0_DEVICE_VENDOR_ID__DEVICE_ID_MASK                                                      0xFFFF0000L
//NB_PCIEDUMMY1_0_STATUS_COMMAND
#define NB_PCIEDUMMY1_0_STATUS_COMMAND__COMMAND__SHIFT                                                        0x0
#define NB_PCIEDUMMY1_0_STATUS_COMMAND__STATUS__SHIFT                                                         0x10
#define NB_PCIEDUMMY1_0_STATUS_COMMAND__COMMAND_MASK                                                          0x0000FFFFL
#define NB_PCIEDUMMY1_0_STATUS_COMMAND__STATUS_MASK                                                           0xFFFF0000L
//NB_PCIEDUMMY1_0_CLASS_CODE_REVID
#define NB_PCIEDUMMY1_0_CLASS_CODE_REVID__REVID__SHIFT                                                        0x0
#define NB_PCIEDUMMY1_0_CLASS_CODE_REVID__CLASS_CODE__SHIFT                                                   0x8
#define NB_PCIEDUMMY1_0_CLASS_CODE_REVID__REVID_MASK                                                          0x000000FFL
#define NB_PCIEDUMMY1_0_CLASS_CODE_REVID__CLASS_CODE_MASK                                                     0xFFFFFF00L
//NB_PCIEDUMMY1_0_HEADER_TYPE
#define NB_PCIEDUMMY1_0_HEADER_TYPE__HEADER_TYPE__SHIFT                                                       0x10
#define NB_PCIEDUMMY1_0_HEADER_TYPE__DEVICE_TYPE__SHIFT                                                       0x17
#define NB_PCIEDUMMY1_0_HEADER_TYPE__HEADER_TYPE_MASK                                                         0x007F0000L
#define NB_PCIEDUMMY1_0_HEADER_TYPE__DEVICE_TYPE_MASK                                                         0x00800000L
//NB_PCIEDUMMY1_0_HEADER_TYPE_W
#define NB_PCIEDUMMY1_0_HEADER_TYPE_W__DEVICE_TYPE__SHIFT                                                     0x7
#define NB_PCIEDUMMY1_0_HEADER_TYPE_W__DEVICE_TYPE_MASK                                                       0x00000080L


// addressBlock: nbio_nbif0_bif_cfg_dev0_epf0_bifcfgdecp
//VENDOR_ID
#define VENDOR_ID__VENDOR_ID__SHIFT                                                                           0x0
#define VENDOR_ID__VENDOR_ID_MASK                                                                             0xFFFFL
//DEVICE_ID
#define DEVICE_ID__DEVICE_ID__SHIFT                                                                           0x0
#define DEVICE_ID__DEVICE_ID_MASK                                                                             0xFFFFL
//COMMAND
#define COMMAND__IO_ACCESS_EN__SHIFT                                                                          0x0
#define COMMAND__MEM_ACCESS_EN__SHIFT                                                                         0x1
#define COMMAND__BUS_MASTER_EN__SHIFT                                                                         0x2
#define COMMAND__SPECIAL_CYCLE_EN__SHIFT                                                                      0x3
#define COMMAND__MEM_WRITE_INVALIDATE_EN__SHIFT                                                               0x4
#define COMMAND__PAL_SNOOP_EN__SHIFT                                                                          0x5
#define COMMAND__PARITY_ERROR_RESPONSE__SHIFT                                                                 0x6
#define COMMAND__AD_STEPPING__SHIFT                                                                           0x7
#define COMMAND__SERR_EN__SHIFT                                                                               0x8
#define COMMAND__FAST_B2B_EN__SHIFT                                                                           0x9
#define COMMAND__INT_DIS__SHIFT                                                                               0xa
#define COMMAND__IO_ACCESS_EN_MASK                                                                            0x0001L
#define COMMAND__MEM_ACCESS_EN_MASK                                                                           0x0002L
#define COMMAND__BUS_MASTER_EN_MASK                                                                           0x0004L
#define COMMAND__SPECIAL_CYCLE_EN_MASK                                                                        0x0008L
#define COMMAND__MEM_WRITE_INVALIDATE_EN_MASK                                                                 0x0010L
#define COMMAND__PAL_SNOOP_EN_MASK                                                                            0x0020L
#define COMMAND__PARITY_ERROR_RESPONSE_MASK                                                                   0x0040L
#define COMMAND__AD_STEPPING_MASK                                                                             0x0080L
#define COMMAND__SERR_EN_MASK                                                                                 0x0100L
#define COMMAND__FAST_B2B_EN_MASK                                                                             0x0200L
#define COMMAND__INT_DIS_MASK                                                                                 0x0400L
//STATUS
#define STATUS__INT_STATUS__SHIFT                                                                             0x3
#define STATUS__CAP_LIST__SHIFT                                                                               0x4
#define STATUS__PCI_66_EN__SHIFT                                                                              0x5
#define STATUS__FAST_BACK_CAPABLE__SHIFT                                                                      0x7
#define STATUS__MASTER_DATA_PARITY_ERROR__SHIFT                                                               0x8
#define STATUS__DEVSEL_TIMING__SHIFT                                                                          0x9
#define STATUS__SIGNAL_TARGET_ABORT__SHIFT                                                                    0xb
#define STATUS__RECEIVED_TARGET_ABORT__SHIFT                                                                  0xc
#define STATUS__RECEIVED_MASTER_ABORT__SHIFT                                                                  0xd
#define STATUS__SIGNALED_SYSTEM_ERROR__SHIFT                                                                  0xe
#define STATUS__PARITY_ERROR_DETECTED__SHIFT                                                                  0xf
#define STATUS__INT_STATUS_MASK                                                                               0x0008L
#define STATUS__CAP_LIST_MASK                                                                                 0x0010L
#define STATUS__PCI_66_EN_MASK                                                                                0x0020L
#define STATUS__FAST_BACK_CAPABLE_MASK                                                                        0x0080L
#define STATUS__MASTER_DATA_PARITY_ERROR_MASK                                                                 0x0100L
#define STATUS__DEVSEL_TIMING_MASK                                                                            0x0600L
#define STATUS__SIGNAL_TARGET_ABORT_MASK                                                                      0x0800L
#define STATUS__RECEIVED_TARGET_ABORT_MASK                                                                    0x1000L
#define STATUS__RECEIVED_MASTER_ABORT_MASK                                                                    0x2000L
#define STATUS__SIGNALED_SYSTEM_ERROR_MASK                                                                    0x4000L
#define STATUS__PARITY_ERROR_DETECTED_MASK                                                                    0x8000L
//REVISION_ID
#define REVISION_ID__MINOR_REV_ID__SHIFT                                                                      0x0
#define REVISION_ID__MAJOR_REV_ID__SHIFT                                                                      0x4
#define REVISION_ID__MINOR_REV_ID_MASK                                                                        0x0FL
#define REVISION_ID__MAJOR_REV_ID_MASK                                                                        0xF0L
//PROG_INTERFACE
#define PROG_INTERFACE__PROG_INTERFACE__SHIFT                                                                 0x0
#define PROG_INTERFACE__PROG_INTERFACE_MASK                                                                   0xFFL
//SUB_CLASS
#define SUB_CLASS__SUB_CLASS__SHIFT                                                                           0x0
#define SUB_CLASS__SUB_CLASS_MASK                                                                             0xFFL
//BASE_CLASS
#define BASE_CLASS__BASE_CLASS__SHIFT                                                                         0x0
#define BASE_CLASS__BASE_CLASS_MASK                                                                           0xFFL
//CACHE_LINE
#define CACHE_LINE__CACHE_LINE_SIZE__SHIFT                                                                    0x0
#define CACHE_LINE__CACHE_LINE_SIZE_MASK                                                                      0xFFL
//LATENCY
#define LATENCY__LATENCY_TIMER__SHIFT                                                                         0x0
#define LATENCY__LATENCY_TIMER_MASK                                                                           0xFFL
//HEADER
#define HEADER__HEADER_TYPE__SHIFT                                                                            0x0
#define HEADER__DEVICE_TYPE__SHIFT                                                                            0x7
#define HEADER__HEADER_TYPE_MASK                                                                              0x7FL
#define HEADER__DEVICE_TYPE_MASK                                                                              0x80L
//BIST
#define BIST__BIST_COMP__SHIFT                                                                                0x0
#define BIST__BIST_STRT__SHIFT                                                                                0x6
#define BIST__BIST_CAP__SHIFT                                                                                 0x7
#define BIST__BIST_COMP_MASK                                                                                  0x0FL
#define BIST__BIST_STRT_MASK                                                                                  0x40L
#define BIST__BIST_CAP_MASK                                                                                   0x80L
//BASE_ADDR_1
#define BASE_ADDR_1__BASE_ADDR__SHIFT                                                                         0x0
#define BASE_ADDR_1__BASE_ADDR_MASK                                                                           0xFFFFFFFFL
//BASE_ADDR_2
#define BASE_ADDR_2__BASE_ADDR__SHIFT                                                                         0x0
#define BASE_ADDR_2__BASE_ADDR_MASK                                                                           0xFFFFFFFFL
//BASE_ADDR_3
#define BASE_ADDR_3__BASE_ADDR__SHIFT                                                                         0x0
#define BASE_ADDR_3__BASE_ADDR_MASK                                                                           0xFFFFFFFFL
//BASE_ADDR_4
#define BASE_ADDR_4__BASE_ADDR__SHIFT                                                                         0x0
#define BASE_ADDR_4__BASE_ADDR_MASK                                                                           0xFFFFFFFFL
//BASE_ADDR_5
#define BASE_ADDR_5__BASE_ADDR__SHIFT                                                                         0x0
#define BASE_ADDR_5__BASE_ADDR_MASK                                                                           0xFFFFFFFFL
//BASE_ADDR_6
#define BASE_ADDR_6__BASE_ADDR__SHIFT                                                                         0x0
#define BASE_ADDR_6__BASE_ADDR_MASK                                                                           0xFFFFFFFFL
//ADAPTER_ID
#define ADAPTER_ID__SUBSYSTEM_VENDOR_ID__SHIFT                                                                0x0
#define ADAPTER_ID__SUBSYSTEM_ID__SHIFT                                                                       0x10
#define ADAPTER_ID__SUBSYSTEM_VENDOR_ID_MASK                                                                  0x0000FFFFL
#define ADAPTER_ID__SUBSYSTEM_ID_MASK                                                                         0xFFFF0000L
//ROM_BASE_ADDR
#define ROM_BASE_ADDR__BASE_ADDR__SHIFT                                                                       0x0
#define ROM_BASE_ADDR__BASE_ADDR_MASK                                                                         0xFFFFFFFFL
//CAP_PTR
#define CAP_PTR__CAP_PTR__SHIFT                                                                               0x0
#define CAP_PTR__CAP_PTR_MASK                                                                                 0x000000FFL
//INTERRUPT_LINE
#define INTERRUPT_LINE__INTERRUPT_LINE__SHIFT                                                                 0x0
#define INTERRUPT_LINE__INTERRUPT_LINE_MASK                                                                   0xFFL
//INTERRUPT_PIN
#define INTERRUPT_PIN__INTERRUPT_PIN__SHIFT                                                                   0x0
#define INTERRUPT_PIN__INTERRUPT_PIN_MASK                                                                     0xFFL
//MIN_GRANT
#define MIN_GRANT__MIN_GNT__SHIFT                                                                             0x0
#define MIN_GRANT__MIN_GNT_MASK                                                                               0xFFL
//MAX_LATENCY
#define MAX_LATENCY__MAX_LAT__SHIFT                                                                           0x0
#define MAX_LATENCY__MAX_LAT_MASK                                                                             0xFFL
//VENDOR_CAP_LIST
#define VENDOR_CAP_LIST__CAP_ID__SHIFT                                                                        0x0
#define VENDOR_CAP_LIST__NEXT_PTR__SHIFT                                                                      0x8
#define VENDOR_CAP_LIST__LENGTH__SHIFT                                                                        0x10
#define VENDOR_CAP_LIST__CAP_ID_MASK                                                                          0x000000FFL
#define VENDOR_CAP_LIST__NEXT_PTR_MASK                                                                        0x0000FF00L
#define VENDOR_CAP_LIST__LENGTH_MASK                                                                          0x00FF0000L
//ADAPTER_ID_W
#define ADAPTER_ID_W__SUBSYSTEM_VENDOR_ID__SHIFT                                                              0x0
#define ADAPTER_ID_W__SUBSYSTEM_ID__SHIFT                                                                     0x10
#define ADAPTER_ID_W__SUBSYSTEM_VENDOR_ID_MASK                                                                0x0000FFFFL
#define ADAPTER_ID_W__SUBSYSTEM_ID_MASK                                                                       0xFFFF0000L
//PMI_CAP_LIST
#define PMI_CAP_LIST__CAP_ID__SHIFT                                                                           0x0
#define PMI_CAP_LIST__NEXT_PTR__SHIFT                                                                         0x8
#define PMI_CAP_LIST__CAP_ID_MASK                                                                             0x00FFL
#define PMI_CAP_LIST__NEXT_PTR_MASK                                                                           0xFF00L
//PMI_CAP
#define PMI_CAP__VERSION__SHIFT                                                                               0x0
#define PMI_CAP__PME_CLOCK__SHIFT                                                                             0x3
#define PMI_CAP__DEV_SPECIFIC_INIT__SHIFT                                                                     0x5
#define PMI_CAP__AUX_CURRENT__SHIFT                                                                           0x6
#define PMI_CAP__D1_SUPPORT__SHIFT                                                                            0x9
#define PMI_CAP__D2_SUPPORT__SHIFT                                                                            0xa
#define PMI_CAP__PME_SUPPORT__SHIFT                                                                           0xb
#define PMI_CAP__VERSION_MASK                                                                                 0x0007L
#define PMI_CAP__PME_CLOCK_MASK                                                                               0x0008L
#define PMI_CAP__DEV_SPECIFIC_INIT_MASK                                                                       0x0020L
#define PMI_CAP__AUX_CURRENT_MASK                                                                             0x01C0L
#define PMI_CAP__D1_SUPPORT_MASK                                                                              0x0200L
#define PMI_CAP__D2_SUPPORT_MASK                                                                              0x0400L
#define PMI_CAP__PME_SUPPORT_MASK                                                                             0xF800L
//PMI_STATUS_CNTL
#define PMI_STATUS_CNTL__POWER_STATE__SHIFT                                                                   0x0
#define PMI_STATUS_CNTL__NO_SOFT_RESET__SHIFT                                                                 0x3
#define PMI_STATUS_CNTL__PME_EN__SHIFT                                                                        0x8
#define PMI_STATUS_CNTL__DATA_SELECT__SHIFT                                                                   0x9
#define PMI_STATUS_CNTL__DATA_SCALE__SHIFT                                                                    0xd
#define PMI_STATUS_CNTL__PME_STATUS__SHIFT                                                                    0xf
#define PMI_STATUS_CNTL__B2_B3_SUPPORT__SHIFT                                                                 0x16
#define PMI_STATUS_CNTL__BUS_PWR_EN__SHIFT                                                                    0x17
#define PMI_STATUS_CNTL__PMI_DATA__SHIFT                                                                      0x18
#define PMI_STATUS_CNTL__POWER_STATE_MASK                                                                     0x00000003L
#define PMI_STATUS_CNTL__NO_SOFT_RESET_MASK                                                                   0x00000008L
#define PMI_STATUS_CNTL__PME_EN_MASK                                                                          0x00000100L
#define PMI_STATUS_CNTL__DATA_SELECT_MASK                                                                     0x00001E00L
#define PMI_STATUS_CNTL__DATA_SCALE_MASK                                                                      0x00006000L
#define PMI_STATUS_CNTL__PME_STATUS_MASK                                                                      0x00008000L
#define PMI_STATUS_CNTL__B2_B3_SUPPORT_MASK                                                                   0x00400000L
#define PMI_STATUS_CNTL__BUS_PWR_EN_MASK                                                                      0x00800000L
#define PMI_STATUS_CNTL__PMI_DATA_MASK                                                                        0xFF000000L
//PCIE_CAP_LIST
#define PCIE_CAP_LIST__CAP_ID__SHIFT                                                                          0x0
#define PCIE_CAP_LIST__NEXT_PTR__SHIFT                                                                        0x8
#define PCIE_CAP_LIST__CAP_ID_MASK                                                                            0x00FFL
#define PCIE_CAP_LIST__NEXT_PTR_MASK                                                                          0xFF00L
//PCIE_CAP
#define PCIE_CAP__VERSION__SHIFT                                                                              0x0
#define PCIE_CAP__DEVICE_TYPE__SHIFT                                                                          0x4
#define PCIE_CAP__SLOT_IMPLEMENTED__SHIFT                                                                     0x8
#define PCIE_CAP__INT_MESSAGE_NUM__SHIFT                                                                      0x9
#define PCIE_CAP__VERSION_MASK                                                                                0x000FL
#define PCIE_CAP__DEVICE_TYPE_MASK                                                                            0x00F0L
#define PCIE_CAP__SLOT_IMPLEMENTED_MASK                                                                       0x0100L
#define PCIE_CAP__INT_MESSAGE_NUM_MASK                                                                        0x3E00L
//DEVICE_CAP
#define DEVICE_CAP__MAX_PAYLOAD_SUPPORT__SHIFT                                                                0x0
#define DEVICE_CAP__PHANTOM_FUNC__SHIFT                                                                       0x3
#define DEVICE_CAP__EXTENDED_TAG__SHIFT                                                                       0x5
#define DEVICE_CAP__L0S_ACCEPTABLE_LATENCY__SHIFT                                                             0x6
#define DEVICE_CAP__L1_ACCEPTABLE_LATENCY__SHIFT                                                              0x9
#define DEVICE_CAP__ROLE_BASED_ERR_REPORTING__SHIFT                                                           0xf
#define DEVICE_CAP__CAPTURED_SLOT_POWER_LIMIT__SHIFT                                                          0x12
#define DEVICE_CAP__CAPTURED_SLOT_POWER_SCALE__SHIFT                                                          0x1a
#define DEVICE_CAP__FLR_CAPABLE__SHIFT                                                                        0x1c
#define DEVICE_CAP__MAX_PAYLOAD_SUPPORT_MASK                                                                  0x00000007L
#define DEVICE_CAP__PHANTOM_FUNC_MASK                                                                         0x00000018L
#define DEVICE_CAP__EXTENDED_TAG_MASK                                                                         0x00000020L
#define DEVICE_CAP__L0S_ACCEPTABLE_LATENCY_MASK                                                               0x000001C0L
#define DEVICE_CAP__L1_ACCEPTABLE_LATENCY_MASK                                                                0x00000E00L
#define DEVICE_CAP__ROLE_BASED_ERR_REPORTING_MASK                                                             0x00008000L
#define DEVICE_CAP__CAPTURED_SLOT_POWER_LIMIT_MASK                                                            0x03FC0000L
#define DEVICE_CAP__CAPTURED_SLOT_POWER_SCALE_MASK                                                            0x0C000000L
#define DEVICE_CAP__FLR_CAPABLE_MASK                                                                          0x10000000L
//DEVICE_CNTL
#define DEVICE_CNTL__CORR_ERR_EN__SHIFT                                                                       0x0
#define DEVICE_CNTL__NON_FATAL_ERR_EN__SHIFT                                                                  0x1
#define DEVICE_CNTL__FATAL_ERR_EN__SHIFT                                                                      0x2
#define DEVICE_CNTL__USR_REPORT_EN__SHIFT                                                                     0x3
#define DEVICE_CNTL__RELAXED_ORD_EN__SHIFT                                                                    0x4
#define DEVICE_CNTL__MAX_PAYLOAD_SIZE__SHIFT                                                                  0x5
#define DEVICE_CNTL__EXTENDED_TAG_EN__SHIFT                                                                   0x8
#define DEVICE_CNTL__PHANTOM_FUNC_EN__SHIFT                                                                   0x9
#define DEVICE_CNTL__AUX_POWER_PM_EN__SHIFT                                                                   0xa
#define DEVICE_CNTL__NO_SNOOP_EN__SHIFT                                                                       0xb
#define DEVICE_CNTL__MAX_READ_REQUEST_SIZE__SHIFT                                                             0xc
#define DEVICE_CNTL__INITIATE_FLR__SHIFT                                                                      0xf
#define DEVICE_CNTL__CORR_ERR_EN_MASK                                                                         0x0001L
#define DEVICE_CNTL__NON_FATAL_ERR_EN_MASK                                                                    0x0002L
#define DEVICE_CNTL__FATAL_ERR_EN_MASK                                                                        0x0004L
#define DEVICE_CNTL__USR_REPORT_EN_MASK                                                                       0x0008L
#define DEVICE_CNTL__RELAXED_ORD_EN_MASK                                                                      0x0010L
#define DEVICE_CNTL__MAX_PAYLOAD_SIZE_MASK                                                                    0x00E0L
#define DEVICE_CNTL__EXTENDED_TAG_EN_MASK                                                                     0x0100L
#define DEVICE_CNTL__PHANTOM_FUNC_EN_MASK                                                                     0x0200L
#define DEVICE_CNTL__AUX_POWER_PM_EN_MASK                                                                     0x0400L
#define DEVICE_CNTL__NO_SNOOP_EN_MASK                                                                         0x0800L
#define DEVICE_CNTL__MAX_READ_REQUEST_SIZE_MASK                                                               0x7000L
#define DEVICE_CNTL__INITIATE_FLR_MASK                                                                        0x8000L
//DEVICE_STATUS
#define DEVICE_STATUS__CORR_ERR__SHIFT                                                                        0x0
#define DEVICE_STATUS__NON_FATAL_ERR__SHIFT                                                                   0x1
#define DEVICE_STATUS__FATAL_ERR__SHIFT                                                                       0x2
#define DEVICE_STATUS__USR_DETECTED__SHIFT                                                                    0x3
#define DEVICE_STATUS__AUX_PWR__SHIFT                                                                         0x4
#define DEVICE_STATUS__TRANSACTIONS_PEND__SHIFT                                                               0x5
#define DEVICE_STATUS__CORR_ERR_MASK                                                                          0x0001L
#define DEVICE_STATUS__NON_FATAL_ERR_MASK                                                                     0x0002L
#define DEVICE_STATUS__FATAL_ERR_MASK                                                                         0x0004L
#define DEVICE_STATUS__USR_DETECTED_MASK                                                                      0x0008L
#define DEVICE_STATUS__AUX_PWR_MASK                                                                           0x0010L
#define DEVICE_STATUS__TRANSACTIONS_PEND_MASK                                                                 0x0020L
//LINK_CAP
#define LINK_CAP__LINK_SPEED__SHIFT                                                                           0x0
#define LINK_CAP__LINK_WIDTH__SHIFT                                                                           0x4
#define LINK_CAP__PM_SUPPORT__SHIFT                                                                           0xa
#define LINK_CAP__L0S_EXIT_LATENCY__SHIFT                                                                     0xc
#define LINK_CAP__L1_EXIT_LATENCY__SHIFT                                                                      0xf
#define LINK_CAP__CLOCK_POWER_MANAGEMENT__SHIFT                                                               0x12
#define LINK_CAP__SURPRISE_DOWN_ERR_REPORTING__SHIFT                                                          0x13
#define LINK_CAP__DL_ACTIVE_REPORTING_CAPABLE__SHIFT                                                          0x14
#define LINK_CAP__LINK_BW_NOTIFICATION_CAP__SHIFT                                                             0x15
#define LINK_CAP__ASPM_OPTIONALITY_COMPLIANCE__SHIFT                                                          0x16
#define LINK_CAP__PORT_NUMBER__SHIFT                                                                          0x18
#define LINK_CAP__LINK_SPEED_MASK                                                                             0x0000000FL
#define LINK_CAP__LINK_WIDTH_MASK                                                                             0x000003F0L
#define LINK_CAP__PM_SUPPORT_MASK                                                                             0x00000C00L
#define LINK_CAP__L0S_EXIT_LATENCY_MASK                                                                       0x00007000L
#define LINK_CAP__L1_EXIT_LATENCY_MASK                                                                        0x00038000L
#define LINK_CAP__CLOCK_POWER_MANAGEMENT_MASK                                                                 0x00040000L
#define LINK_CAP__SURPRISE_DOWN_ERR_REPORTING_MASK                                                            0x00080000L
#define LINK_CAP__DL_ACTIVE_REPORTING_CAPABLE_MASK                                                            0x00100000L
#define LINK_CAP__LINK_BW_NOTIFICATION_CAP_MASK                                                               0x00200000L
#define LINK_CAP__ASPM_OPTIONALITY_COMPLIANCE_MASK                                                            0x00400000L
#define LINK_CAP__PORT_NUMBER_MASK                                                                            0xFF000000L
//LINK_CNTL
#define LINK_CNTL__PM_CONTROL__SHIFT                                                                          0x0
#define LINK_CNTL__READ_CPL_BOUNDARY__SHIFT                                                                   0x3
#define LINK_CNTL__LINK_DIS__SHIFT                                                                            0x4
#define LINK_CNTL__RETRAIN_LINK__SHIFT                                                                        0x5
#define LINK_CNTL__COMMON_CLOCK_CFG__SHIFT                                                                    0x6
#define LINK_CNTL__EXTENDED_SYNC__SHIFT                                                                       0x7
#define LINK_CNTL__CLOCK_POWER_MANAGEMENT_EN__SHIFT                                                           0x8
#define LINK_CNTL__HW_AUTONOMOUS_WIDTH_DISABLE__SHIFT                                                         0x9
#define LINK_CNTL__LINK_BW_MANAGEMENT_INT_EN__SHIFT                                                           0xa
#define LINK_CNTL__LINK_AUTONOMOUS_BW_INT_EN__SHIFT                                                           0xb
#define LINK_CNTL__PM_CONTROL_MASK                                                                            0x0003L
#define LINK_CNTL__READ_CPL_BOUNDARY_MASK                                                                     0x0008L
#define LINK_CNTL__LINK_DIS_MASK                                                                              0x0010L
#define LINK_CNTL__RETRAIN_LINK_MASK                                                                          0x0020L
#define LINK_CNTL__COMMON_CLOCK_CFG_MASK                                                                      0x0040L
#define LINK_CNTL__EXTENDED_SYNC_MASK                                                                         0x0080L
#define LINK_CNTL__CLOCK_POWER_MANAGEMENT_EN_MASK                                                             0x0100L
#define LINK_CNTL__HW_AUTONOMOUS_WIDTH_DISABLE_MASK                                                           0x0200L
#define LINK_CNTL__LINK_BW_MANAGEMENT_INT_EN_MASK                                                             0x0400L
#define LINK_CNTL__LINK_AUTONOMOUS_BW_INT_EN_MASK                                                             0x0800L
//LINK_STATUS
#define LINK_STATUS__CURRENT_LINK_SPEED__SHIFT                                                                0x0
#define LINK_STATUS__NEGOTIATED_LINK_WIDTH__SHIFT                                                             0x4
#define LINK_STATUS__LINK_TRAINING__SHIFT                                                                     0xb
#define LINK_STATUS__SLOT_CLOCK_CFG__SHIFT                                                                    0xc
#define LINK_STATUS__DL_ACTIVE__SHIFT                                                                         0xd
#define LINK_STATUS__LINK_BW_MANAGEMENT_STATUS__SHIFT                                                         0xe
#define LINK_STATUS__LINK_AUTONOMOUS_BW_STATUS__SHIFT                                                         0xf
#define LINK_STATUS__CURRENT_LINK_SPEED_MASK                                                                  0x000FL
#define LINK_STATUS__NEGOTIATED_LINK_WIDTH_MASK                                                               0x03F0L
#define LINK_STATUS__LINK_TRAINING_MASK                                                                       0x0800L
#define LINK_STATUS__SLOT_CLOCK_CFG_MASK                                                                      0x1000L
#define LINK_STATUS__DL_ACTIVE_MASK                                                                           0x2000L
#define LINK_STATUS__LINK_BW_MANAGEMENT_STATUS_MASK                                                           0x4000L
#define LINK_STATUS__LINK_AUTONOMOUS_BW_STATUS_MASK                                                           0x8000L
//DEVICE_CAP2
#define DEVICE_CAP2__CPL_TIMEOUT_RANGE_SUPPORTED__SHIFT                                                       0x0
#define DEVICE_CAP2__CPL_TIMEOUT_DIS_SUPPORTED__SHIFT                                                         0x4
#define DEVICE_CAP2__ARI_FORWARDING_SUPPORTED__SHIFT                                                          0x5
#define DEVICE_CAP2__ATOMICOP_ROUTING_SUPPORTED__SHIFT                                                        0x6
#define DEVICE_CAP2__ATOMICOP_32CMPLT_SUPPORTED__SHIFT                                                        0x7
#define DEVICE_CAP2__ATOMICOP_64CMPLT_SUPPORTED__SHIFT                                                        0x8
#define DEVICE_CAP2__CAS128_CMPLT_SUPPORTED__SHIFT                                                            0x9
#define DEVICE_CAP2__NO_RO_ENABLED_P2P_PASSING__SHIFT                                                         0xa
#define DEVICE_CAP2__LTR_SUPPORTED__SHIFT                                                                     0xb
#define DEVICE_CAP2__TPH_CPLR_SUPPORTED__SHIFT                                                                0xc
#define DEVICE_CAP2__OBFF_SUPPORTED__SHIFT                                                                    0x12
#define DEVICE_CAP2__EXTENDED_FMT_FIELD_SUPPORTED__SHIFT                                                      0x14
#define DEVICE_CAP2__END_END_TLP_PREFIX_SUPPORTED__SHIFT                                                      0x15
#define DEVICE_CAP2__MAX_END_END_TLP_PREFIXES__SHIFT                                                          0x16
#define DEVICE_CAP2__CPL_TIMEOUT_RANGE_SUPPORTED_MASK                                                         0x0000000FL
#define DEVICE_CAP2__CPL_TIMEOUT_DIS_SUPPORTED_MASK                                                           0x00000010L
#define DEVICE_CAP2__ARI_FORWARDING_SUPPORTED_MASK                                                            0x00000020L
#define DEVICE_CAP2__ATOMICOP_ROUTING_SUPPORTED_MASK                                                          0x00000040L
#define DEVICE_CAP2__ATOMICOP_32CMPLT_SUPPORTED_MASK                                                          0x00000080L
#define DEVICE_CAP2__ATOMICOP_64CMPLT_SUPPORTED_MASK                                                          0x00000100L
#define DEVICE_CAP2__CAS128_CMPLT_SUPPORTED_MASK                                                              0x00000200L
#define DEVICE_CAP2__NO_RO_ENABLED_P2P_PASSING_MASK                                                           0x00000400L
#define DEVICE_CAP2__LTR_SUPPORTED_MASK                                                                       0x00000800L
#define DEVICE_CAP2__TPH_CPLR_SUPPORTED_MASK                                                                  0x00003000L
#define DEVICE_CAP2__OBFF_SUPPORTED_MASK                                                                      0x000C0000L
#define DEVICE_CAP2__EXTENDED_FMT_FIELD_SUPPORTED_MASK                                                        0x00100000L
#define DEVICE_CAP2__END_END_TLP_PREFIX_SUPPORTED_MASK                                                        0x00200000L
#define DEVICE_CAP2__MAX_END_END_TLP_PREFIXES_MASK                                                            0x00C00000L
//DEVICE_CNTL2
#define DEVICE_CNTL2__CPL_TIMEOUT_VALUE__SHIFT                                                                0x0
#define DEVICE_CNTL2__CPL_TIMEOUT_DIS__SHIFT                                                                  0x4
#define DEVICE_CNTL2__ARI_FORWARDING_EN__SHIFT                                                                0x5
#define DEVICE_CNTL2__ATOMICOP_REQUEST_EN__SHIFT                                                              0x6
#define DEVICE_CNTL2__ATOMICOP_EGRESS_BLOCKING__SHIFT                                                         0x7
#define DEVICE_CNTL2__IDO_REQUEST_ENABLE__SHIFT                                                               0x8
#define DEVICE_CNTL2__IDO_COMPLETION_ENABLE__SHIFT                                                            0x9
#define DEVICE_CNTL2__LTR_EN__SHIFT                                                                           0xa
#define DEVICE_CNTL2__OBFF_EN__SHIFT                                                                          0xd
#define DEVICE_CNTL2__END_END_TLP_PREFIX_BLOCKING__SHIFT                                                      0xf
#define DEVICE_CNTL2__CPL_TIMEOUT_VALUE_MASK                                                                  0x000FL
#define DEVICE_CNTL2__CPL_TIMEOUT_DIS_MASK                                                                    0x0010L
#define DEVICE_CNTL2__ARI_FORWARDING_EN_MASK                                                                  0x0020L
#define DEVICE_CNTL2__ATOMICOP_REQUEST_EN_MASK                                                                0x0040L
#define DEVICE_CNTL2__ATOMICOP_EGRESS_BLOCKING_MASK                                                           0x0080L
#define DEVICE_CNTL2__IDO_REQUEST_ENABLE_MASK                                                                 0x0100L
#define DEVICE_CNTL2__IDO_COMPLETION_ENABLE_MASK                                                              0x0200L
#define DEVICE_CNTL2__LTR_EN_MASK                                                                             0x0400L
#define DEVICE_CNTL2__OBFF_EN_MASK                                                                            0x6000L
#define DEVICE_CNTL2__END_END_TLP_PREFIX_BLOCKING_MASK                                                        0x8000L
//DEVICE_STATUS2
#define DEVICE_STATUS2__RESERVED__SHIFT                                                                       0x0
#define DEVICE_STATUS2__RESERVED_MASK                                                                         0xFFFFL
//LINK_CAP2
#define LINK_CAP2__SUPPORTED_LINK_SPEED__SHIFT                                                                0x1
#define LINK_CAP2__CROSSLINK_SUPPORTED__SHIFT                                                                 0x8
#define LINK_CAP2__RESERVED__SHIFT                                                                            0x9
#define LINK_CAP2__SUPPORTED_LINK_SPEED_MASK                                                                  0x000000FEL
#define LINK_CAP2__CROSSLINK_SUPPORTED_MASK                                                                   0x00000100L
#define LINK_CAP2__RESERVED_MASK                                                                              0xFFFFFE00L
//LINK_CNTL2
#define LINK_CNTL2__TARGET_LINK_SPEED__SHIFT                                                                  0x0
#define LINK_CNTL2__ENTER_COMPLIANCE__SHIFT                                                                   0x4
#define LINK_CNTL2__HW_AUTONOMOUS_SPEED_DISABLE__SHIFT                                                        0x5
#define LINK_CNTL2__SELECTABLE_DEEMPHASIS__SHIFT                                                              0x6
#define LINK_CNTL2__XMIT_MARGIN__SHIFT                                                                        0x7
#define LINK_CNTL2__ENTER_MOD_COMPLIANCE__SHIFT                                                               0xa
#define LINK_CNTL2__COMPLIANCE_SOS__SHIFT                                                                     0xb
#define LINK_CNTL2__COMPLIANCE_DEEMPHASIS__SHIFT                                                              0xc
#define LINK_CNTL2__TARGET_LINK_SPEED_MASK                                                                    0x000FL
#define LINK_CNTL2__ENTER_COMPLIANCE_MASK                                                                     0x0010L
#define LINK_CNTL2__HW_AUTONOMOUS_SPEED_DISABLE_MASK                                                          0x0020L
#define LINK_CNTL2__SELECTABLE_DEEMPHASIS_MASK                                                                0x0040L
#define LINK_CNTL2__XMIT_MARGIN_MASK                                                                          0x0380L
#define LINK_CNTL2__ENTER_MOD_COMPLIANCE_MASK                                                                 0x0400L
#define LINK_CNTL2__COMPLIANCE_SOS_MASK                                                                       0x0800L
#define LINK_CNTL2__COMPLIANCE_DEEMPHASIS_MASK                                                                0xF000L
//LINK_STATUS2
#define LINK_STATUS2__CUR_DEEMPHASIS_LEVEL__SHIFT                                                             0x0
#define LINK_STATUS2__EQUALIZATION_COMPLETE__SHIFT                                                            0x1
#define LINK_STATUS2__EQUALIZATION_PHASE1_SUCCESS__SHIFT                                                      0x2
#define LINK_STATUS2__EQUALIZATION_PHASE2_SUCCESS__SHIFT                                                      0x3
#define LINK_STATUS2__EQUALIZATION_PHASE3_SUCCESS__SHIFT                                                      0x4
#define LINK_STATUS2__LINK_EQUALIZATION_REQUEST__SHIFT                                                        0x5
#define LINK_STATUS2__CUR_DEEMPHASIS_LEVEL_MASK                                                               0x0001L
#define LINK_STATUS2__EQUALIZATION_COMPLETE_MASK                                                              0x0002L
#define LINK_STATUS2__EQUALIZATION_PHASE1_SUCCESS_MASK                                                        0x0004L
#define LINK_STATUS2__EQUALIZATION_PHASE2_SUCCESS_MASK                                                        0x0008L
#define LINK_STATUS2__EQUALIZATION_PHASE3_SUCCESS_MASK                                                        0x0010L
#define LINK_STATUS2__LINK_EQUALIZATION_REQUEST_MASK                                                          0x0020L
//SLOT_CAP2
#define SLOT_CAP2__RESERVED__SHIFT                                                                            0x0
#define SLOT_CAP2__RESERVED_MASK                                                                              0xFFFFFFFFL
//SLOT_CNTL2
#define SLOT_CNTL2__RESERVED__SHIFT                                                                           0x0
#define SLOT_CNTL2__RESERVED_MASK                                                                             0xFFFFL
//SLOT_STATUS2
#define SLOT_STATUS2__RESERVED__SHIFT                                                                         0x0
#define SLOT_STATUS2__RESERVED_MASK                                                                           0xFFFFL
//MSI_CAP_LIST
#define MSI_CAP_LIST__CAP_ID__SHIFT                                                                           0x0
#define MSI_CAP_LIST__NEXT_PTR__SHIFT                                                                         0x8
#define MSI_CAP_LIST__CAP_ID_MASK                                                                             0x00FFL
#define MSI_CAP_LIST__NEXT_PTR_MASK                                                                           0xFF00L
//MSI_MSG_CNTL
#define MSI_MSG_CNTL__MSI_EN__SHIFT                                                                           0x0
#define MSI_MSG_CNTL__MSI_MULTI_CAP__SHIFT                                                                    0x1
#define MSI_MSG_CNTL__MSI_MULTI_EN__SHIFT                                                                     0x4
#define MSI_MSG_CNTL__MSI_64BIT__SHIFT                                                                        0x7
#define MSI_MSG_CNTL__MSI_PERVECTOR_MASKING_CAP__SHIFT                                                        0x8
#define MSI_MSG_CNTL__MSI_EN_MASK                                                                             0x0001L
#define MSI_MSG_CNTL__MSI_MULTI_CAP_MASK                                                                      0x000EL
#define MSI_MSG_CNTL__MSI_MULTI_EN_MASK                                                                       0x0070L
#define MSI_MSG_CNTL__MSI_64BIT_MASK                                                                          0x0080L
#define MSI_MSG_CNTL__MSI_PERVECTOR_MASKING_CAP_MASK                                                          0x0100L
//MSI_MSG_ADDR_LO
#define MSI_MSG_ADDR_LO__MSI_MSG_ADDR_LO__SHIFT                                                               0x2
#define MSI_MSG_ADDR_LO__MSI_MSG_ADDR_LO_MASK                                                                 0xFFFFFFFCL
//MSI_MSG_ADDR_HI
#define MSI_MSG_ADDR_HI__MSI_MSG_ADDR_HI__SHIFT                                                               0x0
#define MSI_MSG_ADDR_HI__MSI_MSG_ADDR_HI_MASK                                                                 0xFFFFFFFFL
//MSI_MSG_DATA
#define MSI_MSG_DATA__MSI_DATA__SHIFT                                                                         0x0
#define MSI_MSG_DATA__MSI_DATA_MASK                                                                           0x0000FFFFL
//MSI_MASK
#define MSI_MASK__MSI_MASK__SHIFT                                                                             0x0
#define MSI_MASK__MSI_MASK_MASK                                                                               0xFFFFFFFFL
//MSI_MSG_DATA_64
#define MSI_MSG_DATA_64__MSI_DATA_64__SHIFT                                                                   0x0
#define MSI_MSG_DATA_64__MSI_DATA_64_MASK                                                                     0x0000FFFFL
//MSI_MASK_64
#define MSI_MASK_64__MSI_MASK_64__SHIFT                                                                       0x0
#define MSI_MASK_64__MSI_MASK_64_MASK                                                                         0xFFFFFFFFL
//MSI_PENDING
#define MSI_PENDING__MSI_PENDING__SHIFT                                                                       0x0
#define MSI_PENDING__MSI_PENDING_MASK                                                                         0xFFFFFFFFL
//MSI_PENDING_64
#define MSI_PENDING_64__MSI_PENDING_64__SHIFT                                                                 0x0
#define MSI_PENDING_64__MSI_PENDING_64_MASK                                                                   0xFFFFFFFFL
//MSIX_CAP_LIST
#define MSIX_CAP_LIST__CAP_ID__SHIFT                                                                          0x0
#define MSIX_CAP_LIST__NEXT_PTR__SHIFT                                                                        0x8
#define MSIX_CAP_LIST__CAP_ID_MASK                                                                            0x00FFL
#define MSIX_CAP_LIST__NEXT_PTR_MASK                                                                          0xFF00L
//MSIX_MSG_CNTL
#define MSIX_MSG_CNTL__MSIX_TABLE_SIZE__SHIFT                                                                 0x0
#define MSIX_MSG_CNTL__MSIX_FUNC_MASK__SHIFT                                                                  0xe
#define MSIX_MSG_CNTL__MSIX_EN__SHIFT                                                                         0xf
#define MSIX_MSG_CNTL__MSIX_TABLE_SIZE_MASK                                                                   0x07FFL
#define MSIX_MSG_CNTL__MSIX_FUNC_MASK_MASK                                                                    0x4000L
#define MSIX_MSG_CNTL__MSIX_EN_MASK                                                                           0x8000L
//MSIX_TABLE
#define MSIX_TABLE__MSIX_TABLE_BIR__SHIFT                                                                     0x0
#define MSIX_TABLE__MSIX_TABLE_OFFSET__SHIFT                                                                  0x3
#define MSIX_TABLE__MSIX_TABLE_BIR_MASK                                                                       0x00000007L
#define MSIX_TABLE__MSIX_TABLE_OFFSET_MASK                                                                    0xFFFFFFF8L
//MSIX_PBA
#define MSIX_PBA__MSIX_PBA_BIR__SHIFT                                                                         0x0
#define MSIX_PBA__MSIX_PBA_OFFSET__SHIFT                                                                      0x3
#define MSIX_PBA__MSIX_PBA_BIR_MASK                                                                           0x00000007L
#define MSIX_PBA__MSIX_PBA_OFFSET_MASK                                                                        0xFFFFFFF8L
//PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST
#define PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_ID__SHIFT                                                      0x0
#define PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_VER__SHIFT                                                     0x10
#define PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__NEXT_PTR__SHIFT                                                    0x14
#define PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_ID_MASK                                                        0x0000FFFFL
#define PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_VER_MASK                                                       0x000F0000L
#define PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__NEXT_PTR_MASK                                                      0xFFF00000L
//PCIE_VENDOR_SPECIFIC_HDR
#define PCIE_VENDOR_SPECIFIC_HDR__VSEC_ID__SHIFT                                                              0x0
#define PCIE_VENDOR_SPECIFIC_HDR__VSEC_REV__SHIFT                                                             0x10
#define PCIE_VENDOR_SPECIFIC_HDR__VSEC_LENGTH__SHIFT                                                          0x14
#define PCIE_VENDOR_SPECIFIC_HDR__VSEC_ID_MASK                                                                0x0000FFFFL
#define PCIE_VENDOR_SPECIFIC_HDR__VSEC_REV_MASK                                                               0x000F0000L
#define PCIE_VENDOR_SPECIFIC_HDR__VSEC_LENGTH_MASK                                                            0xFFF00000L
//PCIE_VENDOR_SPECIFIC1
#define PCIE_VENDOR_SPECIFIC1__SCRATCH__SHIFT                                                                 0x0
#define PCIE_VENDOR_SPECIFIC1__SCRATCH_MASK                                                                   0xFFFFFFFFL
//PCIE_VENDOR_SPECIFIC2
#define PCIE_VENDOR_SPECIFIC2__SCRATCH__SHIFT                                                                 0x0
#define PCIE_VENDOR_SPECIFIC2__SCRATCH_MASK                                                                   0xFFFFFFFFL
//PCIE_VC_ENH_CAP_LIST
#define PCIE_VC_ENH_CAP_LIST__CAP_ID__SHIFT                                                                   0x0
#define PCIE_VC_ENH_CAP_LIST__CAP_VER__SHIFT                                                                  0x10
#define PCIE_VC_ENH_CAP_LIST__NEXT_PTR__SHIFT                                                                 0x14
#define PCIE_VC_ENH_CAP_LIST__CAP_ID_MASK                                                                     0x0000FFFFL
#define PCIE_VC_ENH_CAP_LIST__CAP_VER_MASK                                                                    0x000F0000L
#define PCIE_VC_ENH_CAP_LIST__NEXT_PTR_MASK                                                                   0xFFF00000L
//PCIE_PORT_VC_CAP_REG1
#define PCIE_PORT_VC_CAP_REG1__EXT_VC_COUNT__SHIFT                                                            0x0
#define PCIE_PORT_VC_CAP_REG1__LOW_PRIORITY_EXT_VC_COUNT__SHIFT                                               0x4
#define PCIE_PORT_VC_CAP_REG1__REF_CLK__SHIFT                                                                 0x8
#define PCIE_PORT_VC_CAP_REG1__PORT_ARB_TABLE_ENTRY_SIZE__SHIFT                                               0xa
#define PCIE_PORT_VC_CAP_REG1__EXT_VC_COUNT_MASK                                                              0x00000007L
#define PCIE_PORT_VC_CAP_REG1__LOW_PRIORITY_EXT_VC_COUNT_MASK                                                 0x00000070L
#define PCIE_PORT_VC_CAP_REG1__REF_CLK_MASK                                                                   0x00000300L
#define PCIE_PORT_VC_CAP_REG1__PORT_ARB_TABLE_ENTRY_SIZE_MASK                                                 0x00000C00L
//PCIE_PORT_VC_CAP_REG2
#define PCIE_PORT_VC_CAP_REG2__VC_ARB_CAP__SHIFT                                                              0x0
#define PCIE_PORT_VC_CAP_REG2__VC_ARB_TABLE_OFFSET__SHIFT                                                     0x18
#define PCIE_PORT_VC_CAP_REG2__VC_ARB_CAP_MASK                                                                0x000000FFL
#define PCIE_PORT_VC_CAP_REG2__VC_ARB_TABLE_OFFSET_MASK                                                       0xFF000000L
//PCIE_PORT_VC_CNTL
#define PCIE_PORT_VC_CNTL__LOAD_VC_ARB_TABLE__SHIFT                                                           0x0
#define PCIE_PORT_VC_CNTL__VC_ARB_SELECT__SHIFT                                                               0x1
#define PCIE_PORT_VC_CNTL__LOAD_VC_ARB_TABLE_MASK                                                             0x0001L
#define PCIE_PORT_VC_CNTL__VC_ARB_SELECT_MASK                                                                 0x000EL
//PCIE_PORT_VC_STATUS
#define PCIE_PORT_VC_STATUS__VC_ARB_TABLE_STATUS__SHIFT                                                       0x0
#define PCIE_PORT_VC_STATUS__VC_ARB_TABLE_STATUS_MASK                                                         0x0001L
//PCIE_VC0_RESOURCE_CAP
#define PCIE_VC0_RESOURCE_CAP__PORT_ARB_CAP__SHIFT                                                            0x0
#define PCIE_VC0_RESOURCE_CAP__REJECT_SNOOP_TRANS__SHIFT                                                      0xf
#define PCIE_VC0_RESOURCE_CAP__MAX_TIME_SLOTS__SHIFT                                                          0x10
#define PCIE_VC0_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET__SHIFT                                                   0x18
#define PCIE_VC0_RESOURCE_CAP__PORT_ARB_CAP_MASK                                                              0x000000FFL
#define PCIE_VC0_RESOURCE_CAP__REJECT_SNOOP_TRANS_MASK                                                        0x00008000L
#define PCIE_VC0_RESOURCE_CAP__MAX_TIME_SLOTS_MASK                                                            0x003F0000L
#define PCIE_VC0_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET_MASK                                                     0xFF000000L
//PCIE_VC0_RESOURCE_CNTL
#define PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC0__SHIFT                                                          0x0
#define PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC1_7__SHIFT                                                        0x1
#define PCIE_VC0_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE__SHIFT                                                    0x10
#define PCIE_VC0_RESOURCE_CNTL__PORT_ARB_SELECT__SHIFT                                                        0x11
#define PCIE_VC0_RESOURCE_CNTL__VC_ID__SHIFT                                                                  0x18
#define PCIE_VC0_RESOURCE_CNTL__VC_ENABLE__SHIFT                                                              0x1f
#define PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC0_MASK                                                            0x00000001L
#define PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC1_7_MASK                                                          0x000000FEL
#define PCIE_VC0_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE_MASK                                                      0x00010000L
#define PCIE_VC0_RESOURCE_CNTL__PORT_ARB_SELECT_MASK                                                          0x000E0000L
#define PCIE_VC0_RESOURCE_CNTL__VC_ID_MASK                                                                    0x07000000L
#define PCIE_VC0_RESOURCE_CNTL__VC_ENABLE_MASK                                                                0x80000000L
//PCIE_VC0_RESOURCE_STATUS
#define PCIE_VC0_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS__SHIFT                                                0x0
#define PCIE_VC0_RESOURCE_STATUS__VC_NEGOTIATION_PENDING__SHIFT                                               0x1
#define PCIE_VC0_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS_MASK                                                  0x0001L
#define PCIE_VC0_RESOURCE_STATUS__VC_NEGOTIATION_PENDING_MASK                                                 0x0002L
//PCIE_VC1_RESOURCE_CAP
#define PCIE_VC1_RESOURCE_CAP__PORT_ARB_CAP__SHIFT                                                            0x0
#define PCIE_VC1_RESOURCE_CAP__REJECT_SNOOP_TRANS__SHIFT                                                      0xf
#define PCIE_VC1_RESOURCE_CAP__MAX_TIME_SLOTS__SHIFT                                                          0x10
#define PCIE_VC1_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET__SHIFT                                                   0x18
#define PCIE_VC1_RESOURCE_CAP__PORT_ARB_CAP_MASK                                                              0x000000FFL
#define PCIE_VC1_RESOURCE_CAP__REJECT_SNOOP_TRANS_MASK                                                        0x00008000L
#define PCIE_VC1_RESOURCE_CAP__MAX_TIME_SLOTS_MASK                                                            0x003F0000L
#define PCIE_VC1_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET_MASK                                                     0xFF000000L
//PCIE_VC1_RESOURCE_CNTL
#define PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC0__SHIFT                                                          0x0
#define PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC1_7__SHIFT                                                        0x1
#define PCIE_VC1_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE__SHIFT                                                    0x10
#define PCIE_VC1_RESOURCE_CNTL__PORT_ARB_SELECT__SHIFT                                                        0x11
#define PCIE_VC1_RESOURCE_CNTL__VC_ID__SHIFT                                                                  0x18
#define PCIE_VC1_RESOURCE_CNTL__VC_ENABLE__SHIFT                                                              0x1f
#define PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC0_MASK                                                            0x00000001L
#define PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC1_7_MASK                                                          0x000000FEL
#define PCIE_VC1_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE_MASK                                                      0x00010000L
#define PCIE_VC1_RESOURCE_CNTL__PORT_ARB_SELECT_MASK                                                          0x000E0000L
#define PCIE_VC1_RESOURCE_CNTL__VC_ID_MASK                                                                    0x07000000L
#define PCIE_VC1_RESOURCE_CNTL__VC_ENABLE_MASK                                                                0x80000000L
//PCIE_VC1_RESOURCE_STATUS
#define PCIE_VC1_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS__SHIFT                                                0x0
#define PCIE_VC1_RESOURCE_STATUS__VC_NEGOTIATION_PENDING__SHIFT                                               0x1
#define PCIE_VC1_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS_MASK                                                  0x0001L
#define PCIE_VC1_RESOURCE_STATUS__VC_NEGOTIATION_PENDING_MASK                                                 0x0002L
//PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST
#define PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_ID__SHIFT                                                       0x0
#define PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_VER__SHIFT                                                      0x10
#define PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__NEXT_PTR__SHIFT                                                     0x14
#define PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_ID_MASK                                                         0x0000FFFFL
#define PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_VER_MASK                                                        0x000F0000L
#define PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__NEXT_PTR_MASK                                                       0xFFF00000L
//PCIE_DEV_SERIAL_NUM_DW1
#define PCIE_DEV_SERIAL_NUM_DW1__SERIAL_NUMBER_LO__SHIFT                                                      0x0
#define PCIE_DEV_SERIAL_NUM_DW1__SERIAL_NUMBER_LO_MASK                                                        0xFFFFFFFFL
//PCIE_DEV_SERIAL_NUM_DW2
#define PCIE_DEV_SERIAL_NUM_DW2__SERIAL_NUMBER_HI__SHIFT                                                      0x0
#define PCIE_DEV_SERIAL_NUM_DW2__SERIAL_NUMBER_HI_MASK                                                        0xFFFFFFFFL
//PCIE_ADV_ERR_RPT_ENH_CAP_LIST
#define PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_ID__SHIFT                                                          0x0
#define PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_VER__SHIFT                                                         0x10
#define PCIE_ADV_ERR_RPT_ENH_CAP_LIST__NEXT_PTR__SHIFT                                                        0x14
#define PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_ID_MASK                                                            0x0000FFFFL
#define PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_VER_MASK                                                           0x000F0000L
#define PCIE_ADV_ERR_RPT_ENH_CAP_LIST__NEXT_PTR_MASK                                                          0xFFF00000L
//PCIE_UNCORR_ERR_STATUS
#define PCIE_UNCORR_ERR_STATUS__DLP_ERR_STATUS__SHIFT                                                         0x4
#define PCIE_UNCORR_ERR_STATUS__SURPDN_ERR_STATUS__SHIFT                                                      0x5
#define PCIE_UNCORR_ERR_STATUS__PSN_ERR_STATUS__SHIFT                                                         0xc
#define PCIE_UNCORR_ERR_STATUS__FC_ERR_STATUS__SHIFT                                                          0xd
#define PCIE_UNCORR_ERR_STATUS__CPL_TIMEOUT_STATUS__SHIFT                                                     0xe
#define PCIE_UNCORR_ERR_STATUS__CPL_ABORT_ERR_STATUS__SHIFT                                                   0xf
#define PCIE_UNCORR_ERR_STATUS__UNEXP_CPL_STATUS__SHIFT                                                       0x10
#define PCIE_UNCORR_ERR_STATUS__RCV_OVFL_STATUS__SHIFT                                                        0x11
#define PCIE_UNCORR_ERR_STATUS__MAL_TLP_STATUS__SHIFT                                                         0x12
#define PCIE_UNCORR_ERR_STATUS__ECRC_ERR_STATUS__SHIFT                                                        0x13
#define PCIE_UNCORR_ERR_STATUS__UNSUPP_REQ_ERR_STATUS__SHIFT                                                  0x14
#define PCIE_UNCORR_ERR_STATUS__ACS_VIOLATION_STATUS__SHIFT                                                   0x15
#define PCIE_UNCORR_ERR_STATUS__UNCORR_INT_ERR_STATUS__SHIFT                                                  0x16
#define PCIE_UNCORR_ERR_STATUS__MC_BLOCKED_TLP_STATUS__SHIFT                                                  0x17
#define PCIE_UNCORR_ERR_STATUS__ATOMICOP_EGRESS_BLOCKED_STATUS__SHIFT                                         0x18
#define PCIE_UNCORR_ERR_STATUS__TLP_PREFIX_BLOCKED_ERR_STATUS__SHIFT                                          0x19
#define PCIE_UNCORR_ERR_STATUS__DLP_ERR_STATUS_MASK                                                           0x00000010L
#define PCIE_UNCORR_ERR_STATUS__SURPDN_ERR_STATUS_MASK                                                        0x00000020L
#define PCIE_UNCORR_ERR_STATUS__PSN_ERR_STATUS_MASK                                                           0x00001000L
#define PCIE_UNCORR_ERR_STATUS__FC_ERR_STATUS_MASK                                                            0x00002000L
#define PCIE_UNCORR_ERR_STATUS__CPL_TIMEOUT_STATUS_MASK                                                       0x00004000L
#define PCIE_UNCORR_ERR_STATUS__CPL_ABORT_ERR_STATUS_MASK                                                     0x00008000L
#define PCIE_UNCORR_ERR_STATUS__UNEXP_CPL_STATUS_MASK                                                         0x00010000L
#define PCIE_UNCORR_ERR_STATUS__RCV_OVFL_STATUS_MASK                                                          0x00020000L
#define PCIE_UNCORR_ERR_STATUS__MAL_TLP_STATUS_MASK                                                           0x00040000L
#define PCIE_UNCORR_ERR_STATUS__ECRC_ERR_STATUS_MASK                                                          0x00080000L
#define PCIE_UNCORR_ERR_STATUS__UNSUPP_REQ_ERR_STATUS_MASK                                                    0x00100000L
#define PCIE_UNCORR_ERR_STATUS__ACS_VIOLATION_STATUS_MASK                                                     0x00200000L
#define PCIE_UNCORR_ERR_STATUS__UNCORR_INT_ERR_STATUS_MASK                                                    0x00400000L
#define PCIE_UNCORR_ERR_STATUS__MC_BLOCKED_TLP_STATUS_MASK                                                    0x00800000L
#define PCIE_UNCORR_ERR_STATUS__ATOMICOP_EGRESS_BLOCKED_STATUS_MASK                                           0x01000000L
#define PCIE_UNCORR_ERR_STATUS__TLP_PREFIX_BLOCKED_ERR_STATUS_MASK                                            0x02000000L
//PCIE_UNCORR_ERR_MASK
#define PCIE_UNCORR_ERR_MASK__DLP_ERR_MASK__SHIFT                                                             0x4
#define PCIE_UNCORR_ERR_MASK__SURPDN_ERR_MASK__SHIFT                                                          0x5
#define PCIE_UNCORR_ERR_MASK__PSN_ERR_MASK__SHIFT                                                             0xc
#define PCIE_UNCORR_ERR_MASK__FC_ERR_MASK__SHIFT                                                              0xd
#define PCIE_UNCORR_ERR_MASK__CPL_TIMEOUT_MASK__SHIFT                                                         0xe
#define PCIE_UNCORR_ERR_MASK__CPL_ABORT_ERR_MASK__SHIFT                                                       0xf
#define PCIE_UNCORR_ERR_MASK__UNEXP_CPL_MASK__SHIFT                                                           0x10
#define PCIE_UNCORR_ERR_MASK__RCV_OVFL_MASK__SHIFT                                                            0x11
#define PCIE_UNCORR_ERR_MASK__MAL_TLP_MASK__SHIFT                                                             0x12
#define PCIE_UNCORR_ERR_MASK__ECRC_ERR_MASK__SHIFT                                                            0x13
#define PCIE_UNCORR_ERR_MASK__UNSUPP_REQ_ERR_MASK__SHIFT                                                      0x14
#define PCIE_UNCORR_ERR_MASK__ACS_VIOLATION_MASK__SHIFT                                                       0x15
#define PCIE_UNCORR_ERR_MASK__UNCORR_INT_ERR_MASK__SHIFT                                                      0x16
#define PCIE_UNCORR_ERR_MASK__MC_BLOCKED_TLP_MASK__SHIFT                                                      0x17
#define PCIE_UNCORR_ERR_MASK__ATOMICOP_EGRESS_BLOCKED_MASK__SHIFT                                             0x18
#define PCIE_UNCORR_ERR_MASK__TLP_PREFIX_BLOCKED_ERR_MASK__SHIFT                                              0x19
#define PCIE_UNCORR_ERR_MASK__DLP_ERR_MASK_MASK                                                               0x00000010L
#define PCIE_UNCORR_ERR_MASK__SURPDN_ERR_MASK_MASK                                                            0x00000020L
#define PCIE_UNCORR_ERR_MASK__PSN_ERR_MASK_MASK                                                               0x00001000L
#define PCIE_UNCORR_ERR_MASK__FC_ERR_MASK_MASK                                                                0x00002000L
#define PCIE_UNCORR_ERR_MASK__CPL_TIMEOUT_MASK_MASK                                                           0x00004000L
#define PCIE_UNCORR_ERR_MASK__CPL_ABORT_ERR_MASK_MASK                                                         0x00008000L
#define PCIE_UNCORR_ERR_MASK__UNEXP_CPL_MASK_MASK                                                             0x00010000L
#define PCIE_UNCORR_ERR_MASK__RCV_OVFL_MASK_MASK                                                              0x00020000L
#define PCIE_UNCORR_ERR_MASK__MAL_TLP_MASK_MASK                                                               0x00040000L
#define PCIE_UNCORR_ERR_MASK__ECRC_ERR_MASK_MASK                                                              0x00080000L
#define PCIE_UNCORR_ERR_MASK__UNSUPP_REQ_ERR_MASK_MASK                                                        0x00100000L
#define PCIE_UNCORR_ERR_MASK__ACS_VIOLATION_MASK_MASK                                                         0x00200000L
#define PCIE_UNCORR_ERR_MASK__UNCORR_INT_ERR_MASK_MASK                                                        0x00400000L
#define PCIE_UNCORR_ERR_MASK__MC_BLOCKED_TLP_MASK_MASK                                                        0x00800000L
#define PCIE_UNCORR_ERR_MASK__ATOMICOP_EGRESS_BLOCKED_MASK_MASK                                               0x01000000L
#define PCIE_UNCORR_ERR_MASK__TLP_PREFIX_BLOCKED_ERR_MASK_MASK                                                0x02000000L
//PCIE_UNCORR_ERR_SEVERITY
#define PCIE_UNCORR_ERR_SEVERITY__DLP_ERR_SEVERITY__SHIFT                                                     0x4
#define PCIE_UNCORR_ERR_SEVERITY__SURPDN_ERR_SEVERITY__SHIFT                                                  0x5
#define PCIE_UNCORR_ERR_SEVERITY__PSN_ERR_SEVERITY__SHIFT                                                     0xc
#define PCIE_UNCORR_ERR_SEVERITY__FC_ERR_SEVERITY__SHIFT                                                      0xd
#define PCIE_UNCORR_ERR_SEVERITY__CPL_TIMEOUT_SEVERITY__SHIFT                                                 0xe
#define PCIE_UNCORR_ERR_SEVERITY__CPL_ABORT_ERR_SEVERITY__SHIFT                                               0xf
#define PCIE_UNCORR_ERR_SEVERITY__UNEXP_CPL_SEVERITY__SHIFT                                                   0x10
#define PCIE_UNCORR_ERR_SEVERITY__RCV_OVFL_SEVERITY__SHIFT                                                    0x11
#define PCIE_UNCORR_ERR_SEVERITY__MAL_TLP_SEVERITY__SHIFT                                                     0x12
#define PCIE_UNCORR_ERR_SEVERITY__ECRC_ERR_SEVERITY__SHIFT                                                    0x13
#define PCIE_UNCORR_ERR_SEVERITY__UNSUPP_REQ_ERR_SEVERITY__SHIFT                                              0x14
#define PCIE_UNCORR_ERR_SEVERITY__ACS_VIOLATION_SEVERITY__SHIFT                                               0x15
#define PCIE_UNCORR_ERR_SEVERITY__UNCORR_INT_ERR_SEVERITY__SHIFT                                              0x16
#define PCIE_UNCORR_ERR_SEVERITY__MC_BLOCKED_TLP_SEVERITY__SHIFT                                              0x17
#define PCIE_UNCORR_ERR_SEVERITY__ATOMICOP_EGRESS_BLOCKED_SEVERITY__SHIFT                                     0x18
#define PCIE_UNCORR_ERR_SEVERITY__TLP_PREFIX_BLOCKED_ERR_SEVERITY__SHIFT                                      0x19
#define PCIE_UNCORR_ERR_SEVERITY__DLP_ERR_SEVERITY_MASK                                                       0x00000010L
#define PCIE_UNCORR_ERR_SEVERITY__SURPDN_ERR_SEVERITY_MASK                                                    0x00000020L
#define PCIE_UNCORR_ERR_SEVERITY__PSN_ERR_SEVERITY_MASK                                                       0x00001000L
#define PCIE_UNCORR_ERR_SEVERITY__FC_ERR_SEVERITY_MASK                                                        0x00002000L
#define PCIE_UNCORR_ERR_SEVERITY__CPL_TIMEOUT_SEVERITY_MASK                                                   0x00004000L
#define PCIE_UNCORR_ERR_SEVERITY__CPL_ABORT_ERR_SEVERITY_MASK                                                 0x00008000L
#define PCIE_UNCORR_ERR_SEVERITY__UNEXP_CPL_SEVERITY_MASK                                                     0x00010000L
#define PCIE_UNCORR_ERR_SEVERITY__RCV_OVFL_SEVERITY_MASK                                                      0x00020000L
#define PCIE_UNCORR_ERR_SEVERITY__MAL_TLP_SEVERITY_MASK                                                       0x00040000L
#define PCIE_UNCORR_ERR_SEVERITY__ECRC_ERR_SEVERITY_MASK                                                      0x00080000L
#define PCIE_UNCORR_ERR_SEVERITY__UNSUPP_REQ_ERR_SEVERITY_MASK                                                0x00100000L
#define PCIE_UNCORR_ERR_SEVERITY__ACS_VIOLATION_SEVERITY_MASK                                                 0x00200000L
#define PCIE_UNCORR_ERR_SEVERITY__UNCORR_INT_ERR_SEVERITY_MASK                                                0x00400000L
#define PCIE_UNCORR_ERR_SEVERITY__MC_BLOCKED_TLP_SEVERITY_MASK                                                0x00800000L
#define PCIE_UNCORR_ERR_SEVERITY__ATOMICOP_EGRESS_BLOCKED_SEVERITY_MASK                                       0x01000000L
#define PCIE_UNCORR_ERR_SEVERITY__TLP_PREFIX_BLOCKED_ERR_SEVERITY_MASK                                        0x02000000L
//PCIE_CORR_ERR_STATUS
#define PCIE_CORR_ERR_STATUS__RCV_ERR_STATUS__SHIFT                                                           0x0
#define PCIE_CORR_ERR_STATUS__BAD_TLP_STATUS__SHIFT                                                           0x6
#define PCIE_CORR_ERR_STATUS__BAD_DLLP_STATUS__SHIFT                                                          0x7
#define PCIE_CORR_ERR_STATUS__REPLAY_NUM_ROLLOVER_STATUS__SHIFT                                               0x8
#define PCIE_CORR_ERR_STATUS__REPLAY_TIMER_TIMEOUT_STATUS__SHIFT                                              0xc
#define PCIE_CORR_ERR_STATUS__ADVISORY_NONFATAL_ERR_STATUS__SHIFT                                             0xd
#define PCIE_CORR_ERR_STATUS__CORR_INT_ERR_STATUS__SHIFT                                                      0xe
#define PCIE_CORR_ERR_STATUS__HDR_LOG_OVFL_STATUS__SHIFT                                                      0xf
#define PCIE_CORR_ERR_STATUS__RCV_ERR_STATUS_MASK                                                             0x00000001L
#define PCIE_CORR_ERR_STATUS__BAD_TLP_STATUS_MASK                                                             0x00000040L
#define PCIE_CORR_ERR_STATUS__BAD_DLLP_STATUS_MASK                                                            0x00000080L
#define PCIE_CORR_ERR_STATUS__REPLAY_NUM_ROLLOVER_STATUS_MASK                                                 0x00000100L
#define PCIE_CORR_ERR_STATUS__REPLAY_TIMER_TIMEOUT_STATUS_MASK                                                0x00001000L
#define PCIE_CORR_ERR_STATUS__ADVISORY_NONFATAL_ERR_STATUS_MASK                                               0x00002000L
#define PCIE_CORR_ERR_STATUS__CORR_INT_ERR_STATUS_MASK                                                        0x00004000L
#define PCIE_CORR_ERR_STATUS__HDR_LOG_OVFL_STATUS_MASK                                                        0x00008000L
//PCIE_CORR_ERR_MASK
#define PCIE_CORR_ERR_MASK__RCV_ERR_MASK__SHIFT                                                               0x0
#define PCIE_CORR_ERR_MASK__BAD_TLP_MASK__SHIFT                                                               0x6
#define PCIE_CORR_ERR_MASK__BAD_DLLP_MASK__SHIFT                                                              0x7
#define PCIE_CORR_ERR_MASK__REPLAY_NUM_ROLLOVER_MASK__SHIFT                                                   0x8
#define PCIE_CORR_ERR_MASK__REPLAY_TIMER_TIMEOUT_MASK__SHIFT                                                  0xc
#define PCIE_CORR_ERR_MASK__ADVISORY_NONFATAL_ERR_MASK__SHIFT                                                 0xd
#define PCIE_CORR_ERR_MASK__CORR_INT_ERR_MASK__SHIFT                                                          0xe
#define PCIE_CORR_ERR_MASK__HDR_LOG_OVFL_MASK__SHIFT                                                          0xf
#define PCIE_CORR_ERR_MASK__RCV_ERR_MASK_MASK                                                                 0x00000001L
#define PCIE_CORR_ERR_MASK__BAD_TLP_MASK_MASK                                                                 0x00000040L
#define PCIE_CORR_ERR_MASK__BAD_DLLP_MASK_MASK                                                                0x00000080L
#define PCIE_CORR_ERR_MASK__REPLAY_NUM_ROLLOVER_MASK_MASK                                                     0x00000100L
#define PCIE_CORR_ERR_MASK__REPLAY_TIMER_TIMEOUT_MASK_MASK                                                    0x00001000L
#define PCIE_CORR_ERR_MASK__ADVISORY_NONFATAL_ERR_MASK_MASK                                                   0x00002000L
#define PCIE_CORR_ERR_MASK__CORR_INT_ERR_MASK_MASK                                                            0x00004000L
#define PCIE_CORR_ERR_MASK__HDR_LOG_OVFL_MASK_MASK                                                            0x00008000L
//PCIE_ADV_ERR_CAP_CNTL
#define PCIE_ADV_ERR_CAP_CNTL__FIRST_ERR_PTR__SHIFT                                                           0x0
#define PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_CAP__SHIFT                                                            0x5
#define PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_EN__SHIFT                                                             0x6
#define PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_CAP__SHIFT                                                          0x7
#define PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_EN__SHIFT                                                           0x8
#define PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_CAP__SHIFT                                                      0x9
#define PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_EN__SHIFT                                                       0xa
#define PCIE_ADV_ERR_CAP_CNTL__TLP_PREFIX_LOG_PRESENT__SHIFT                                                  0xb
#define PCIE_ADV_ERR_CAP_CNTL__FIRST_ERR_PTR_MASK                                                             0x0000001FL
#define PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_CAP_MASK                                                              0x00000020L
#define PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_EN_MASK                                                               0x00000040L
#define PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_CAP_MASK                                                            0x00000080L
#define PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_EN_MASK                                                             0x00000100L
#define PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_CAP_MASK                                                        0x00000200L
#define PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_EN_MASK                                                         0x00000400L
#define PCIE_ADV_ERR_CAP_CNTL__TLP_PREFIX_LOG_PRESENT_MASK                                                    0x00000800L
//PCIE_HDR_LOG0
#define PCIE_HDR_LOG0__TLP_HDR__SHIFT                                                                         0x0
#define PCIE_HDR_LOG0__TLP_HDR_MASK                                                                           0xFFFFFFFFL
//PCIE_HDR_LOG1
#define PCIE_HDR_LOG1__TLP_HDR__SHIFT                                                                         0x0
#define PCIE_HDR_LOG1__TLP_HDR_MASK                                                                           0xFFFFFFFFL
//PCIE_HDR_LOG2
#define PCIE_HDR_LOG2__TLP_HDR__SHIFT                                                                         0x0
#define PCIE_HDR_LOG2__TLP_HDR_MASK                                                                           0xFFFFFFFFL
//PCIE_HDR_LOG3
#define PCIE_HDR_LOG3__TLP_HDR__SHIFT                                                                         0x0
#define PCIE_HDR_LOG3__TLP_HDR_MASK                                                                           0xFFFFFFFFL
//PCIE_TLP_PREFIX_LOG0
#define PCIE_TLP_PREFIX_LOG0__TLP_PREFIX__SHIFT                                                               0x0
#define PCIE_TLP_PREFIX_LOG0__TLP_PREFIX_MASK                                                                 0xFFFFFFFFL
//PCIE_TLP_PREFIX_LOG1
#define PCIE_TLP_PREFIX_LOG1__TLP_PREFIX__SHIFT                                                               0x0
#define PCIE_TLP_PREFIX_LOG1__TLP_PREFIX_MASK                                                                 0xFFFFFFFFL
//PCIE_TLP_PREFIX_LOG2
#define PCIE_TLP_PREFIX_LOG2__TLP_PREFIX__SHIFT                                                               0x0
#define PCIE_TLP_PREFIX_LOG2__TLP_PREFIX_MASK                                                                 0xFFFFFFFFL
//PCIE_TLP_PREFIX_LOG3
#define PCIE_TLP_PREFIX_LOG3__TLP_PREFIX__SHIFT                                                               0x0
#define PCIE_TLP_PREFIX_LOG3__TLP_PREFIX_MASK                                                                 0xFFFFFFFFL
//PCIE_BAR_ENH_CAP_LIST
#define PCIE_BAR_ENH_CAP_LIST__CAP_ID__SHIFT                                                                  0x0
#define PCIE_BAR_ENH_CAP_LIST__CAP_VER__SHIFT                                                                 0x10
#define PCIE_BAR_ENH_CAP_LIST__NEXT_PTR__SHIFT                                                                0x14
#define PCIE_BAR_ENH_CAP_LIST__CAP_ID_MASK                                                                    0x0000FFFFL
#define PCIE_BAR_ENH_CAP_LIST__CAP_VER_MASK                                                                   0x000F0000L
#define PCIE_BAR_ENH_CAP_LIST__NEXT_PTR_MASK                                                                  0xFFF00000L
//PCIE_BAR1_CAP
#define PCIE_BAR1_CAP__BAR_SIZE_SUPPORTED__SHIFT                                                              0x4
#define PCIE_BAR1_CAP__BAR_SIZE_SUPPORTED_MASK                                                                0x00FFFFF0L
//PCIE_BAR1_CNTL
#define PCIE_BAR1_CNTL__BAR_INDEX__SHIFT                                                                      0x0
#define PCIE_BAR1_CNTL__BAR_TOTAL_NUM__SHIFT                                                                  0x5
#define PCIE_BAR1_CNTL__BAR_SIZE__SHIFT                                                                       0x8
#define PCIE_BAR1_CNTL__BAR_INDEX_MASK                                                                        0x0007L
#define PCIE_BAR1_CNTL__BAR_TOTAL_NUM_MASK                                                                    0x00E0L
#define PCIE_BAR1_CNTL__BAR_SIZE_MASK                                                                         0x1F00L
//PCIE_BAR2_CAP
#define PCIE_BAR2_CAP__BAR_SIZE_SUPPORTED__SHIFT                                                              0x4
#define PCIE_BAR2_CAP__BAR_SIZE_SUPPORTED_MASK                                                                0x00FFFFF0L
//PCIE_BAR2_CNTL
#define PCIE_BAR2_CNTL__BAR_INDEX__SHIFT                                                                      0x0
#define PCIE_BAR2_CNTL__BAR_TOTAL_NUM__SHIFT                                                                  0x5
#define PCIE_BAR2_CNTL__BAR_SIZE__SHIFT                                                                       0x8
#define PCIE_BAR2_CNTL__BAR_INDEX_MASK                                                                        0x0007L
#define PCIE_BAR2_CNTL__BAR_TOTAL_NUM_MASK                                                                    0x00E0L
#define PCIE_BAR2_CNTL__BAR_SIZE_MASK                                                                         0x1F00L
//PCIE_BAR3_CAP
#define PCIE_BAR3_CAP__BAR_SIZE_SUPPORTED__SHIFT                                                              0x4
#define PCIE_BAR3_CAP__BAR_SIZE_SUPPORTED_MASK                                                                0x00FFFFF0L
//PCIE_BAR3_CNTL
#define PCIE_BAR3_CNTL__BAR_INDEX__SHIFT                                                                      0x0
#define PCIE_BAR3_CNTL__BAR_TOTAL_NUM__SHIFT                                                                  0x5
#define PCIE_BAR3_CNTL__BAR_SIZE__SHIFT                                                                       0x8
#define PCIE_BAR3_CNTL__BAR_INDEX_MASK                                                                        0x0007L
#define PCIE_BAR3_CNTL__BAR_TOTAL_NUM_MASK                                                                    0x00E0L
#define PCIE_BAR3_CNTL__BAR_SIZE_MASK                                                                         0x1F00L
//PCIE_BAR4_CAP
#define PCIE_BAR4_CAP__BAR_SIZE_SUPPORTED__SHIFT                                                              0x4
#define PCIE_BAR4_CAP__BAR_SIZE_SUPPORTED_MASK                                                                0x00FFFFF0L
//PCIE_BAR4_CNTL
#define PCIE_BAR4_CNTL__BAR_INDEX__SHIFT                                                                      0x0
#define PCIE_BAR4_CNTL__BAR_TOTAL_NUM__SHIFT                                                                  0x5
#define PCIE_BAR4_CNTL__BAR_SIZE__SHIFT                                                                       0x8
#define PCIE_BAR4_CNTL__BAR_INDEX_MASK                                                                        0x0007L
#define PCIE_BAR4_CNTL__BAR_TOTAL_NUM_MASK                                                                    0x00E0L
#define PCIE_BAR4_CNTL__BAR_SIZE_MASK                                                                         0x1F00L
//PCIE_BAR5_CAP
#define PCIE_BAR5_CAP__BAR_SIZE_SUPPORTED__SHIFT                                                              0x4
#define PCIE_BAR5_CAP__BAR_SIZE_SUPPORTED_MASK                                                                0x00FFFFF0L
//PCIE_BAR5_CNTL
#define PCIE_BAR5_CNTL__BAR_INDEX__SHIFT                                                                      0x0
#define PCIE_BAR5_CNTL__BAR_TOTAL_NUM__SHIFT                                                                  0x5
#define PCIE_BAR5_CNTL__BAR_SIZE__SHIFT                                                                       0x8
#define PCIE_BAR5_CNTL__BAR_INDEX_MASK                                                                        0x0007L
#define PCIE_BAR5_CNTL__BAR_TOTAL_NUM_MASK                                                                    0x00E0L
#define PCIE_BAR5_CNTL__BAR_SIZE_MASK                                                                         0x1F00L
//PCIE_BAR6_CAP
#define PCIE_BAR6_CAP__BAR_SIZE_SUPPORTED__SHIFT                                                              0x4
#define PCIE_BAR6_CAP__BAR_SIZE_SUPPORTED_MASK                                                                0x00FFFFF0L
//PCIE_BAR6_CNTL
#define PCIE_BAR6_CNTL__BAR_INDEX__SHIFT                                                                      0x0
#define PCIE_BAR6_CNTL__BAR_TOTAL_NUM__SHIFT                                                                  0x5
#define PCIE_BAR6_CNTL__BAR_SIZE__SHIFT                                                                       0x8
#define PCIE_BAR6_CNTL__BAR_INDEX_MASK                                                                        0x0007L
#define PCIE_BAR6_CNTL__BAR_TOTAL_NUM_MASK                                                                    0x00E0L
#define PCIE_BAR6_CNTL__BAR_SIZE_MASK                                                                         0x1F00L
//PCIE_PWR_BUDGET_ENH_CAP_LIST
#define PCIE_PWR_BUDGET_ENH_CAP_LIST__CAP_ID__SHIFT                                                           0x0
#define PCIE_PWR_BUDGET_ENH_CAP_LIST__CAP_VER__SHIFT                                                          0x10
#define PCIE_PWR_BUDGET_ENH_CAP_LIST__NEXT_PTR__SHIFT                                                         0x14
#define PCIE_PWR_BUDGET_ENH_CAP_LIST__CAP_ID_MASK                                                             0x0000FFFFL
#define PCIE_PWR_BUDGET_ENH_CAP_LIST__CAP_VER_MASK                                                            0x000F0000L
#define PCIE_PWR_BUDGET_ENH_CAP_LIST__NEXT_PTR_MASK                                                           0xFFF00000L
//PCIE_PWR_BUDGET_DATA_SELECT
#define PCIE_PWR_BUDGET_DATA_SELECT__DATA_SELECT__SHIFT                                                       0x0
#define PCIE_PWR_BUDGET_DATA_SELECT__DATA_SELECT_MASK                                                         0xFFL
//PCIE_PWR_BUDGET_DATA
#define PCIE_PWR_BUDGET_DATA__BASE_POWER__SHIFT                                                               0x0
#define PCIE_PWR_BUDGET_DATA__DATA_SCALE__SHIFT                                                               0x8
#define PCIE_PWR_BUDGET_DATA__PM_SUB_STATE__SHIFT                                                             0xa
#define PCIE_PWR_BUDGET_DATA__PM_STATE__SHIFT                                                                 0xd
#define PCIE_PWR_BUDGET_DATA__TYPE__SHIFT                                                                     0xf
#define PCIE_PWR_BUDGET_DATA__POWER_RAIL__SHIFT                                                               0x12
#define PCIE_PWR_BUDGET_DATA__BASE_POWER_MASK                                                                 0x000000FFL
#define PCIE_PWR_BUDGET_DATA__DATA_SCALE_MASK                                                                 0x00000300L
#define PCIE_PWR_BUDGET_DATA__PM_SUB_STATE_MASK                                                               0x00001C00L
#define PCIE_PWR_BUDGET_DATA__PM_STATE_MASK                                                                   0x00006000L
#define PCIE_PWR_BUDGET_DATA__TYPE_MASK                                                                       0x00038000L
#define PCIE_PWR_BUDGET_DATA__POWER_RAIL_MASK                                                                 0x001C0000L
//PCIE_PWR_BUDGET_CAP
#define PCIE_PWR_BUDGET_CAP__SYSTEM_ALLOCATED__SHIFT                                                          0x0
#define PCIE_PWR_BUDGET_CAP__SYSTEM_ALLOCATED_MASK                                                            0x01L
//PCIE_DPA_ENH_CAP_LIST
#define PCIE_DPA_ENH_CAP_LIST__CAP_ID__SHIFT                                                                  0x0
#define PCIE_DPA_ENH_CAP_LIST__CAP_VER__SHIFT                                                                 0x10
#define PCIE_DPA_ENH_CAP_LIST__NEXT_PTR__SHIFT                                                                0x14
#define PCIE_DPA_ENH_CAP_LIST__CAP_ID_MASK                                                                    0x0000FFFFL
#define PCIE_DPA_ENH_CAP_LIST__CAP_VER_MASK                                                                   0x000F0000L
#define PCIE_DPA_ENH_CAP_LIST__NEXT_PTR_MASK                                                                  0xFFF00000L
//PCIE_DPA_CAP
#define PCIE_DPA_CAP__SUBSTATE_MAX__SHIFT                                                                     0x0
#define PCIE_DPA_CAP__TRANS_LAT_UNIT__SHIFT                                                                   0x8
#define PCIE_DPA_CAP__PWR_ALLOC_SCALE__SHIFT                                                                  0xc
#define PCIE_DPA_CAP__TRANS_LAT_VAL_0__SHIFT                                                                  0x10
#define PCIE_DPA_CAP__TRANS_LAT_VAL_1__SHIFT                                                                  0x18
#define PCIE_DPA_CAP__SUBSTATE_MAX_MASK                                                                       0x0000001FL
#define PCIE_DPA_CAP__TRANS_LAT_UNIT_MASK                                                                     0x00000300L
#define PCIE_DPA_CAP__PWR_ALLOC_SCALE_MASK                                                                    0x00003000L
#define PCIE_DPA_CAP__TRANS_LAT_VAL_0_MASK                                                                    0x00FF0000L
#define PCIE_DPA_CAP__TRANS_LAT_VAL_1_MASK                                                                    0xFF000000L
//PCIE_DPA_LATENCY_INDICATOR
#define PCIE_DPA_LATENCY_INDICATOR__TRANS_LAT_INDICATOR_BITS__SHIFT                                           0x0
#define PCIE_DPA_LATENCY_INDICATOR__TRANS_LAT_INDICATOR_BITS_MASK                                             0xFFL
//PCIE_DPA_STATUS
#define PCIE_DPA_STATUS__SUBSTATE_STATUS__SHIFT                                                               0x0
#define PCIE_DPA_STATUS__SUBSTATE_CNTL_ENABLED__SHIFT                                                         0x8
#define PCIE_DPA_STATUS__SUBSTATE_STATUS_MASK                                                                 0x001FL
#define PCIE_DPA_STATUS__SUBSTATE_CNTL_ENABLED_MASK                                                           0x0100L
//PCIE_DPA_CNTL
#define PCIE_DPA_CNTL__SUBSTATE_CNTL__SHIFT                                                                   0x0
#define PCIE_DPA_CNTL__SUBSTATE_CNTL_MASK                                                                     0x1FL
//PCIE_DPA_SUBSTATE_PWR_ALLOC_0
#define PCIE_DPA_SUBSTATE_PWR_ALLOC_0__SUBSTATE_PWR_ALLOC__SHIFT                                              0x0
#define PCIE_DPA_SUBSTATE_PWR_ALLOC_0__SUBSTATE_PWR_ALLOC_MASK                                                0xFFL
//PCIE_DPA_SUBSTATE_PWR_ALLOC_1
#define PCIE_DPA_SUBSTATE_PWR_ALLOC_1__SUBSTATE_PWR_ALLOC__SHIFT                                              0x0
#define PCIE_DPA_SUBSTATE_PWR_ALLOC_1__SUBSTATE_PWR_ALLOC_MASK                                                0xFFL
//PCIE_DPA_SUBSTATE_PWR_ALLOC_2
#define PCIE_DPA_SUBSTATE_PWR_ALLOC_2__SUBSTATE_PWR_ALLOC__SHIFT                                              0x0
#define PCIE_DPA_SUBSTATE_PWR_ALLOC_2__SUBSTATE_PWR_ALLOC_MASK                                                0xFFL
//PCIE_DPA_SUBSTATE_PWR_ALLOC_3
#define PCIE_DPA_SUBSTATE_PWR_ALLOC_3__SUBSTATE_PWR_ALLOC__SHIFT                                              0x0
#define PCIE_DPA_SUBSTATE_PWR_ALLOC_3__SUBSTATE_PWR_ALLOC_MASK                                                0xFFL
//PCIE_DPA_SUBSTATE_PWR_ALLOC_4
#define PCIE_DPA_SUBSTATE_PWR_ALLOC_4__SUBSTATE_PWR_ALLOC__SHIFT                                              0x0
#define PCIE_DPA_SUBSTATE_PWR_ALLOC_4__SUBSTATE_PWR_ALLOC_MASK                                                0xFFL
//PCIE_DPA_SUBSTATE_PWR_ALLOC_5
#define PCIE_DPA_SUBSTATE_PWR_ALLOC_5__SUBSTATE_PWR_ALLOC__SHIFT                                              0x0
#define PCIE_DPA_SUBSTATE_PWR_ALLOC_5__SUBSTATE_PWR_ALLOC_MASK                                                0xFFL
//PCIE_DPA_SUBSTATE_PWR_ALLOC_6
#define PCIE_DPA_SUBSTATE_PWR_ALLOC_6__SUBSTATE_PWR_ALLOC__SHIFT                                              0x0
#define PCIE_DPA_SUBSTATE_PWR_ALLOC_6__SUBSTATE_PWR_ALLOC_MASK                                                0xFFL
//PCIE_DPA_SUBSTATE_PWR_ALLOC_7
#define PCIE_DPA_SUBSTATE_PWR_ALLOC_7__SUBSTATE_PWR_ALLOC__SHIFT                                              0x0
#define PCIE_DPA_SUBSTATE_PWR_ALLOC_7__SUBSTATE_PWR_ALLOC_MASK                                                0xFFL
//PCIE_SECONDARY_ENH_CAP_LIST
#define PCIE_SECONDARY_ENH_CAP_LIST__CAP_ID__SHIFT                                                            0x0
#define PCIE_SECONDARY_ENH_CAP_LIST__CAP_VER__SHIFT                                                           0x10
#define PCIE_SECONDARY_ENH_CAP_LIST__NEXT_PTR__SHIFT                                                          0x14
#define PCIE_SECONDARY_ENH_CAP_LIST__CAP_ID_MASK                                                              0x0000FFFFL
#define PCIE_SECONDARY_ENH_CAP_LIST__CAP_VER_MASK                                                             0x000F0000L
#define PCIE_SECONDARY_ENH_CAP_LIST__NEXT_PTR_MASK                                                            0xFFF00000L
//PCIE_LINK_CNTL3
#define PCIE_LINK_CNTL3__PERFORM_EQUALIZATION__SHIFT                                                          0x0
#define PCIE_LINK_CNTL3__LINK_EQUALIZATION_REQ_INT_EN__SHIFT                                                  0x1
#define PCIE_LINK_CNTL3__RESERVED__SHIFT                                                                      0x2
#define PCIE_LINK_CNTL3__PERFORM_EQUALIZATION_MASK                                                            0x00000001L
#define PCIE_LINK_CNTL3__LINK_EQUALIZATION_REQ_INT_EN_MASK                                                    0x00000002L
#define PCIE_LINK_CNTL3__RESERVED_MASK                                                                        0xFFFFFFFCL
//PCIE_LANE_ERROR_STATUS
#define PCIE_LANE_ERROR_STATUS__LANE_ERROR_STATUS_BITS__SHIFT                                                 0x0
#define PCIE_LANE_ERROR_STATUS__RESERVED__SHIFT                                                               0x10
#define PCIE_LANE_ERROR_STATUS__LANE_ERROR_STATUS_BITS_MASK                                                   0x0000FFFFL
#define PCIE_LANE_ERROR_STATUS__RESERVED_MASK                                                                 0xFFFF0000L
//PCIE_LANE_0_EQUALIZATION_CNTL
#define PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                                       0x0
#define PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                                  0x4
#define PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                                         0x8
#define PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                                    0xc
#define PCIE_LANE_0_EQUALIZATION_CNTL__RESERVED__SHIFT                                                        0xf
#define PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                                         0x000FL
#define PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                                    0x0070L
#define PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                                           0x0F00L
#define PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                                      0x7000L
#define PCIE_LANE_0_EQUALIZATION_CNTL__RESERVED_MASK                                                          0x8000L
//PCIE_LANE_1_EQUALIZATION_CNTL
#define PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                                       0x0
#define PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                                  0x4
#define PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                                         0x8
#define PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                                    0xc
#define PCIE_LANE_1_EQUALIZATION_CNTL__RESERVED__SHIFT                                                        0xf
#define PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                                         0x000FL
#define PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                                    0x0070L
#define PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                                           0x0F00L
#define PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                                      0x7000L
#define PCIE_LANE_1_EQUALIZATION_CNTL__RESERVED_MASK                                                          0x8000L
//PCIE_LANE_2_EQUALIZATION_CNTL
#define PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                                       0x0
#define PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                                  0x4
#define PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                                         0x8
#define PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                                    0xc
#define PCIE_LANE_2_EQUALIZATION_CNTL__RESERVED__SHIFT                                                        0xf
#define PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                                         0x000FL
#define PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                                    0x0070L
#define PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                                           0x0F00L
#define PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                                      0x7000L
#define PCIE_LANE_2_EQUALIZATION_CNTL__RESERVED_MASK                                                          0x8000L
//PCIE_LANE_3_EQUALIZATION_CNTL
#define PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                                       0x0
#define PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                                  0x4
#define PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                                         0x8
#define PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                                    0xc
#define PCIE_LANE_3_EQUALIZATION_CNTL__RESERVED__SHIFT                                                        0xf
#define PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                                         0x000FL
#define PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                                    0x0070L
#define PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                                           0x0F00L
#define PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                                      0x7000L
#define PCIE_LANE_3_EQUALIZATION_CNTL__RESERVED_MASK                                                          0x8000L
//PCIE_LANE_4_EQUALIZATION_CNTL
#define PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                                       0x0
#define PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                                  0x4
#define PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                                         0x8
#define PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                                    0xc
#define PCIE_LANE_4_EQUALIZATION_CNTL__RESERVED__SHIFT                                                        0xf
#define PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                                         0x000FL
#define PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                                    0x0070L
#define PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                                           0x0F00L
#define PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                                      0x7000L
#define PCIE_LANE_4_EQUALIZATION_CNTL__RESERVED_MASK                                                          0x8000L
//PCIE_LANE_5_EQUALIZATION_CNTL
#define PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                                       0x0
#define PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                                  0x4
#define PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                                         0x8
#define PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                                    0xc
#define PCIE_LANE_5_EQUALIZATION_CNTL__RESERVED__SHIFT                                                        0xf
#define PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                                         0x000FL
#define PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                                    0x0070L
#define PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                                           0x0F00L
#define PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                                      0x7000L
#define PCIE_LANE_5_EQUALIZATION_CNTL__RESERVED_MASK                                                          0x8000L
//PCIE_LANE_6_EQUALIZATION_CNTL
#define PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                                       0x0
#define PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                                  0x4
#define PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                                         0x8
#define PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                                    0xc
#define PCIE_LANE_6_EQUALIZATION_CNTL__RESERVED__SHIFT                                                        0xf
#define PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                                         0x000FL
#define PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                                    0x0070L
#define PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                                           0x0F00L
#define PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                                      0x7000L
#define PCIE_LANE_6_EQUALIZATION_CNTL__RESERVED_MASK                                                          0x8000L
//PCIE_LANE_7_EQUALIZATION_CNTL
#define PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                                       0x0
#define PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                                  0x4
#define PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                                         0x8
#define PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                                    0xc
#define PCIE_LANE_7_EQUALIZATION_CNTL__RESERVED__SHIFT                                                        0xf
#define PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                                         0x000FL
#define PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                                    0x0070L
#define PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                                           0x0F00L
#define PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                                      0x7000L
#define PCIE_LANE_7_EQUALIZATION_CNTL__RESERVED_MASK                                                          0x8000L
//PCIE_LANE_8_EQUALIZATION_CNTL
#define PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                                       0x0
#define PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                                  0x4
#define PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                                         0x8
#define PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                                    0xc
#define PCIE_LANE_8_EQUALIZATION_CNTL__RESERVED__SHIFT                                                        0xf
#define PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                                         0x000FL
#define PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                                    0x0070L
#define PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                                           0x0F00L
#define PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                                      0x7000L
#define PCIE_LANE_8_EQUALIZATION_CNTL__RESERVED_MASK                                                          0x8000L
//PCIE_LANE_9_EQUALIZATION_CNTL
#define PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                                       0x0
#define PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                                  0x4
#define PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                                         0x8
#define PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                                    0xc
#define PCIE_LANE_9_EQUALIZATION_CNTL__RESERVED__SHIFT                                                        0xf
#define PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                                         0x000FL
#define PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                                    0x0070L
#define PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                                           0x0F00L
#define PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                                      0x7000L
#define PCIE_LANE_9_EQUALIZATION_CNTL__RESERVED_MASK                                                          0x8000L
//PCIE_LANE_10_EQUALIZATION_CNTL
#define PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                                      0x0
#define PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                                 0x4
#define PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                                        0x8
#define PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                                   0xc
#define PCIE_LANE_10_EQUALIZATION_CNTL__RESERVED__SHIFT                                                       0xf
#define PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                                        0x000FL
#define PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                                   0x0070L
#define PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                                          0x0F00L
#define PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                                     0x7000L
#define PCIE_LANE_10_EQUALIZATION_CNTL__RESERVED_MASK                                                         0x8000L
//PCIE_LANE_11_EQUALIZATION_CNTL
#define PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                                      0x0
#define PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                                 0x4
#define PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                                        0x8
#define PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                                   0xc
#define PCIE_LANE_11_EQUALIZATION_CNTL__RESERVED__SHIFT                                                       0xf
#define PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                                        0x000FL
#define PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                                   0x0070L
#define PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                                          0x0F00L
#define PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                                     0x7000L
#define PCIE_LANE_11_EQUALIZATION_CNTL__RESERVED_MASK                                                         0x8000L
//PCIE_LANE_12_EQUALIZATION_CNTL
#define PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                                      0x0
#define PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                                 0x4
#define PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                                        0x8
#define PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                                   0xc
#define PCIE_LANE_12_EQUALIZATION_CNTL__RESERVED__SHIFT                                                       0xf
#define PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                                        0x000FL
#define PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                                   0x0070L
#define PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                                          0x0F00L
#define PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                                     0x7000L
#define PCIE_LANE_12_EQUALIZATION_CNTL__RESERVED_MASK                                                         0x8000L
//PCIE_LANE_13_EQUALIZATION_CNTL
#define PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                                      0x0
#define PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                                 0x4
#define PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                                        0x8
#define PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                                   0xc
#define PCIE_LANE_13_EQUALIZATION_CNTL__RESERVED__SHIFT                                                       0xf
#define PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                                        0x000FL
#define PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                                   0x0070L
#define PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                                          0x0F00L
#define PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                                     0x7000L
#define PCIE_LANE_13_EQUALIZATION_CNTL__RESERVED_MASK                                                         0x8000L
//PCIE_LANE_14_EQUALIZATION_CNTL
#define PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                                      0x0
#define PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                                 0x4
#define PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                                        0x8
#define PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                                   0xc
#define PCIE_LANE_14_EQUALIZATION_CNTL__RESERVED__SHIFT                                                       0xf
#define PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                                        0x000FL
#define PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                                   0x0070L
#define PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                                          0x0F00L
#define PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                                     0x7000L
#define PCIE_LANE_14_EQUALIZATION_CNTL__RESERVED_MASK                                                         0x8000L
//PCIE_LANE_15_EQUALIZATION_CNTL
#define PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                                      0x0
#define PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT                                 0x4
#define PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                                        0x8
#define PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                                   0xc
#define PCIE_LANE_15_EQUALIZATION_CNTL__RESERVED__SHIFT                                                       0xf
#define PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                                        0x000FL
#define PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                                   0x0070L
#define PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                                          0x0F00L
#define PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                                     0x7000L
#define PCIE_LANE_15_EQUALIZATION_CNTL__RESERVED_MASK                                                         0x8000L
//PCIE_ACS_ENH_CAP_LIST
#define PCIE_ACS_ENH_CAP_LIST__CAP_ID__SHIFT                                                                  0x0
#define PCIE_ACS_ENH_CAP_LIST__CAP_VER__SHIFT                                                                 0x10
#define PCIE_ACS_ENH_CAP_LIST__NEXT_PTR__SHIFT                                                                0x14
#define PCIE_ACS_ENH_CAP_LIST__CAP_ID_MASK                                                                    0x0000FFFFL
#define PCIE_ACS_ENH_CAP_LIST__CAP_VER_MASK                                                                   0x000F0000L
#define PCIE_ACS_ENH_CAP_LIST__NEXT_PTR_MASK                                                                  0xFFF00000L
//PCIE_ACS_CAP
#define PCIE_ACS_CAP__SOURCE_VALIDATION__SHIFT                                                                0x0
#define PCIE_ACS_CAP__TRANSLATION_BLOCKING__SHIFT                                                             0x1
#define PCIE_ACS_CAP__P2P_REQUEST_REDIRECT__SHIFT                                                             0x2
#define PCIE_ACS_CAP__P2P_COMPLETION_REDIRECT__SHIFT                                                          0x3
#define PCIE_ACS_CAP__UPSTREAM_FORWARDING__SHIFT                                                              0x4
#define PCIE_ACS_CAP__P2P_EGRESS_CONTROL__SHIFT                                                               0x5
#define PCIE_ACS_CAP__DIRECT_TRANSLATED_P2P__SHIFT                                                            0x6
#define PCIE_ACS_CAP__EGRESS_CONTROL_VECTOR_SIZE__SHIFT                                                       0x8
#define PCIE_ACS_CAP__SOURCE_VALIDATION_MASK                                                                  0x0001L
#define PCIE_ACS_CAP__TRANSLATION_BLOCKING_MASK                                                               0x0002L
#define PCIE_ACS_CAP__P2P_REQUEST_REDIRECT_MASK                                                               0x0004L
#define PCIE_ACS_CAP__P2P_COMPLETION_REDIRECT_MASK                                                            0x0008L
#define PCIE_ACS_CAP__UPSTREAM_FORWARDING_MASK                                                                0x0010L
#define PCIE_ACS_CAP__P2P_EGRESS_CONTROL_MASK                                                                 0x0020L
#define PCIE_ACS_CAP__DIRECT_TRANSLATED_P2P_MASK                                                              0x0040L
#define PCIE_ACS_CAP__EGRESS_CONTROL_VECTOR_SIZE_MASK                                                         0xFF00L
//PCIE_ACS_CNTL
#define PCIE_ACS_CNTL__SOURCE_VALIDATION_EN__SHIFT                                                            0x0
#define PCIE_ACS_CNTL__TRANSLATION_BLOCKING_EN__SHIFT                                                         0x1
#define PCIE_ACS_CNTL__P2P_REQUEST_REDIRECT_EN__SHIFT                                                         0x2
#define PCIE_ACS_CNTL__P2P_COMPLETION_REDIRECT_EN__SHIFT                                                      0x3
#define PCIE_ACS_CNTL__UPSTREAM_FORWARDING_EN__SHIFT                                                          0x4
#define PCIE_ACS_CNTL__P2P_EGRESS_CONTROL_EN__SHIFT                                                           0x5
#define PCIE_ACS_CNTL__DIRECT_TRANSLATED_P2P_EN__SHIFT                                                        0x6
#define PCIE_ACS_CNTL__SOURCE_VALIDATION_EN_MASK                                                              0x0001L
#define PCIE_ACS_CNTL__TRANSLATION_BLOCKING_EN_MASK                                                           0x0002L
#define PCIE_ACS_CNTL__P2P_REQUEST_REDIRECT_EN_MASK                                                           0x0004L
#define PCIE_ACS_CNTL__P2P_COMPLETION_REDIRECT_EN_MASK                                                        0x0008L
#define PCIE_ACS_CNTL__UPSTREAM_FORWARDING_EN_MASK                                                            0x0010L
#define PCIE_ACS_CNTL__P2P_EGRESS_CONTROL_EN_MASK                                                             0x0020L
#define PCIE_ACS_CNTL__DIRECT_TRANSLATED_P2P_EN_MASK                                                          0x0040L
//PCIE_ATS_ENH_CAP_LIST
#define PCIE_ATS_ENH_CAP_LIST__CAP_ID__SHIFT                                                                  0x0
#define PCIE_ATS_ENH_CAP_LIST__CAP_VER__SHIFT                                                                 0x10
#define PCIE_ATS_ENH_CAP_LIST__NEXT_PTR__SHIFT                                                                0x14
#define PCIE_ATS_ENH_CAP_LIST__CAP_ID_MASK                                                                    0x0000FFFFL
#define PCIE_ATS_ENH_CAP_LIST__CAP_VER_MASK                                                                   0x000F0000L
#define PCIE_ATS_ENH_CAP_LIST__NEXT_PTR_MASK                                                                  0xFFF00000L
//PCIE_ATS_CAP
#define PCIE_ATS_CAP__INVALIDATE_Q_DEPTH__SHIFT                                                               0x0
#define PCIE_ATS_CAP__PAGE_ALIGNED_REQUEST__SHIFT                                                             0x5
#define PCIE_ATS_CAP__GLOBAL_INVALIDATE_SUPPORTED__SHIFT                                                      0x6
#define PCIE_ATS_CAP__INVALIDATE_Q_DEPTH_MASK                                                                 0x001FL
#define PCIE_ATS_CAP__PAGE_ALIGNED_REQUEST_MASK                                                               0x0020L
#define PCIE_ATS_CAP__GLOBAL_INVALIDATE_SUPPORTED_MASK                                                        0x0040L
//PCIE_ATS_CNTL
#define PCIE_ATS_CNTL__STU__SHIFT                                                                             0x0
#define PCIE_ATS_CNTL__ATC_ENABLE__SHIFT                                                                      0xf
#define PCIE_ATS_CNTL__STU_MASK                                                                               0x001FL
#define PCIE_ATS_CNTL__ATC_ENABLE_MASK                                                                        0x8000L
//PCIE_PAGE_REQ_ENH_CAP_LIST
#define PCIE_PAGE_REQ_ENH_CAP_LIST__CAP_ID__SHIFT                                                             0x0
#define PCIE_PAGE_REQ_ENH_CAP_LIST__CAP_VER__SHIFT                                                            0x10
#define PCIE_PAGE_REQ_ENH_CAP_LIST__NEXT_PTR__SHIFT                                                           0x14
#define PCIE_PAGE_REQ_ENH_CAP_LIST__CAP_ID_MASK                                                               0x0000FFFFL
#define PCIE_PAGE_REQ_ENH_CAP_LIST__CAP_VER_MASK                                                              0x000F0000L
#define PCIE_PAGE_REQ_ENH_CAP_LIST__NEXT_PTR_MASK                                                             0xFFF00000L
//PCIE_PAGE_REQ_CNTL
#define PCIE_PAGE_REQ_CNTL__PRI_ENABLE__SHIFT                                                                 0x0
#define PCIE_PAGE_REQ_CNTL__PRI_RESET__SHIFT                                                                  0x1
#define PCIE_PAGE_REQ_CNTL__PRI_ENABLE_MASK                                                                   0x0001L
#define PCIE_PAGE_REQ_CNTL__PRI_RESET_MASK                                                                    0x0002L
//PCIE_PAGE_REQ_STATUS
#define PCIE_PAGE_REQ_STATUS__RESPONSE_FAILURE__SHIFT                                                         0x0
#define PCIE_PAGE_REQ_STATUS__UNEXPECTED_PAGE_REQ_GRP_INDEX__SHIFT                                            0x1
#define PCIE_PAGE_REQ_STATUS__STOPPED__SHIFT                                                                  0x8
#define PCIE_PAGE_REQ_STATUS__PRG_RESPONSE_PASID_REQUIRED__SHIFT                                              0xf
#define PCIE_PAGE_REQ_STATUS__RESPONSE_FAILURE_MASK                                                           0x0001L
#define PCIE_PAGE_REQ_STATUS__UNEXPECTED_PAGE_REQ_GRP_INDEX_MASK                                              0x0002L
#define PCIE_PAGE_REQ_STATUS__STOPPED_MASK                                                                    0x0100L
#define PCIE_PAGE_REQ_STATUS__PRG_RESPONSE_PASID_REQUIRED_MASK                                                0x8000L
//PCIE_OUTSTAND_PAGE_REQ_CAPACITY
#define PCIE_OUTSTAND_PAGE_REQ_CAPACITY__OUTSTAND_PAGE_REQ_CAPACITY__SHIFT                                    0x0
#define PCIE_OUTSTAND_PAGE_REQ_CAPACITY__OUTSTAND_PAGE_REQ_CAPACITY_MASK                                      0xFFFFFFFFL
//PCIE_OUTSTAND_PAGE_REQ_ALLOC
#define PCIE_OUTSTAND_PAGE_REQ_ALLOC__OUTSTAND_PAGE_REQ_ALLOC__SHIFT                                          0x0
#define PCIE_OUTSTAND_PAGE_REQ_ALLOC__OUTSTAND_PAGE_REQ_ALLOC_MASK                                            0xFFFFFFFFL
//PCIE_PASID_ENH_CAP_LIST
#define PCIE_PASID_ENH_CAP_LIST__CAP_ID__SHIFT                                                                0x0
#define PCIE_PASID_ENH_CAP_LIST__CAP_VER__SHIFT                                                               0x10
#define PCIE_PASID_ENH_CAP_LIST__NEXT_PTR__SHIFT                                                              0x14
#define PCIE_PASID_ENH_CAP_LIST__CAP_ID_MASK                                                                  0x0000FFFFL
#define PCIE_PASID_ENH_CAP_LIST__CAP_VER_MASK                                                                 0x000F0000L
#define PCIE_PASID_ENH_CAP_LIST__NEXT_PTR_MASK                                                                0xFFF00000L
//PCIE_PASID_CAP
#define PCIE_PASID_CAP__PASID_EXE_PERMISSION_SUPPORTED__SHIFT                                                 0x1
#define PCIE_PASID_CAP__PASID_PRIV_MODE_SUPPORTED__SHIFT                                                      0x2
#define PCIE_PASID_CAP__MAX_PASID_WIDTH__SHIFT                                                                0x8
#define PCIE_PASID_CAP__PASID_EXE_PERMISSION_SUPPORTED_MASK                                                   0x0002L
#define PCIE_PASID_CAP__PASID_PRIV_MODE_SUPPORTED_MASK                                                        0x0004L
#define PCIE_PASID_CAP__MAX_PASID_WIDTH_MASK                                                                  0x1F00L
//PCIE_PASID_CNTL
#define PCIE_PASID_CNTL__PASID_ENABLE__SHIFT                                                                  0x0
#define PCIE_PASID_CNTL__PASID_EXE_PERMISSION_ENABLE__SHIFT                                                   0x1
#define PCIE_PASID_CNTL__PASID_PRIV_MODE_SUPPORTED_ENABLE__SHIFT                                              0x2
#define PCIE_PASID_CNTL__PASID_ENABLE_MASK                                                                    0x0001L
#define PCIE_PASID_CNTL__PASID_EXE_PERMISSION_ENABLE_MASK                                                     0x0002L
#define PCIE_PASID_CNTL__PASID_PRIV_MODE_SUPPORTED_ENABLE_MASK                                                0x0004L
//PCIE_TPH_REQR_ENH_CAP_LIST
#define PCIE_TPH_REQR_ENH_CAP_LIST__CAP_ID__SHIFT                                                             0x0
#define PCIE_TPH_REQR_ENH_CAP_LIST__CAP_VER__SHIFT                                                            0x10
#define PCIE_TPH_REQR_ENH_CAP_LIST__NEXT_PTR__SHIFT                                                           0x14
#define PCIE_TPH_REQR_ENH_CAP_LIST__CAP_ID_MASK                                                               0x0000FFFFL
#define PCIE_TPH_REQR_ENH_CAP_LIST__CAP_VER_MASK                                                              0x000F0000L
#define PCIE_TPH_REQR_ENH_CAP_LIST__NEXT_PTR_MASK                                                             0xFFF00000L
//PCIE_TPH_REQR_CAP
#define PCIE_TPH_REQR_CAP__TPH_REQR_NO_ST_MODE_SUPPORTED__SHIFT                                               0x0
#define PCIE_TPH_REQR_CAP__TPH_REQR_INT_VEC_MODE_SUPPORTED__SHIFT                                             0x1
#define PCIE_TPH_REQR_CAP__TPH_REQR_DEV_SPC_MODE_SUPPORTED__SHIFT                                             0x2
#define PCIE_TPH_REQR_CAP__TPH_REQR_EXTND_TPH_REQR_SUPPORED__SHIFT                                            0x8
#define PCIE_TPH_REQR_CAP__TPH_REQR_ST_TABLE_LOCATION__SHIFT                                                  0x9
#define PCIE_TPH_REQR_CAP__TPH_REQR_ST_TABLE_SIZE__SHIFT                                                      0x10
#define PCIE_TPH_REQR_CAP__TPH_REQR_NO_ST_MODE_SUPPORTED_MASK                                                 0x00000001L
#define PCIE_TPH_REQR_CAP__TPH_REQR_INT_VEC_MODE_SUPPORTED_MASK                                               0x00000002L
#define PCIE_TPH_REQR_CAP__TPH_REQR_DEV_SPC_MODE_SUPPORTED_MASK                                               0x00000004L
#define PCIE_TPH_REQR_CAP__TPH_REQR_EXTND_TPH_REQR_SUPPORED_MASK                                              0x00000100L
#define PCIE_TPH_REQR_CAP__TPH_REQR_ST_TABLE_LOCATION_MASK                                                    0x00000600L
#define PCIE_TPH_REQR_CAP__TPH_REQR_ST_TABLE_SIZE_MASK                                                        0x07FF0000L
//PCIE_TPH_REQR_CNTL
#define PCIE_TPH_REQR_CNTL__TPH_REQR_ST_MODE_SEL__SHIFT                                                       0x0
#define PCIE_TPH_REQR_CNTL__TPH_REQR_EN__SHIFT                                                                0x8
#define PCIE_TPH_REQR_CNTL__TPH_REQR_ST_MODE_SEL_MASK                                                         0x00000007L
#define PCIE_TPH_REQR_CNTL__TPH_REQR_EN_MASK                                                                  0x00000300L
//PCIE_MC_ENH_CAP_LIST
#define PCIE_MC_ENH_CAP_LIST__CAP_ID__SHIFT                                                                   0x0
#define PCIE_MC_ENH_CAP_LIST__CAP_VER__SHIFT                                                                  0x10
#define PCIE_MC_ENH_CAP_LIST__NEXT_PTR__SHIFT                                                                 0x14
#define PCIE_MC_ENH_CAP_LIST__CAP_ID_MASK                                                                     0x0000FFFFL
#define PCIE_MC_ENH_CAP_LIST__CAP_VER_MASK                                                                    0x000F0000L
#define PCIE_MC_ENH_CAP_LIST__NEXT_PTR_MASK                                                                   0xFFF00000L
//PCIE_MC_CAP
#define PCIE_MC_CAP__MC_MAX_GROUP__SHIFT                                                                      0x0
#define PCIE_MC_CAP__MC_WIN_SIZE_REQ__SHIFT                                                                   0x8
#define PCIE_MC_CAP__MC_ECRC_REGEN_SUPP__SHIFT                                                                0xf
#define PCIE_MC_CAP__MC_MAX_GROUP_MASK                                                                        0x003FL
#define PCIE_MC_CAP__MC_WIN_SIZE_REQ_MASK                                                                     0x3F00L
#define PCIE_MC_CAP__MC_ECRC_REGEN_SUPP_MASK                                                                  0x8000L
//PCIE_MC_CNTL
#define PCIE_MC_CNTL__MC_NUM_GROUP__SHIFT                                                                     0x0
#define PCIE_MC_CNTL__MC_ENABLE__SHIFT                                                                        0xf
#define PCIE_MC_CNTL__MC_NUM_GROUP_MASK                                                                       0x003FL
#define PCIE_MC_CNTL__MC_ENABLE_MASK                                                                          0x8000L
//PCIE_MC_ADDR0
#define PCIE_MC_ADDR0__MC_INDEX_POS__SHIFT                                                                    0x0
#define PCIE_MC_ADDR0__MC_BASE_ADDR_0__SHIFT                                                                  0xc
#define PCIE_MC_ADDR0__MC_INDEX_POS_MASK                                                                      0x0000003FL
#define PCIE_MC_ADDR0__MC_BASE_ADDR_0_MASK                                                                    0xFFFFF000L
//PCIE_MC_ADDR1
#define PCIE_MC_ADDR1__MC_BASE_ADDR_1__SHIFT                                                                  0x0
#define PCIE_MC_ADDR1__MC_BASE_ADDR_1_MASK                                                                    0xFFFFFFFFL
//PCIE_MC_RCV0
#define PCIE_MC_RCV0__MC_RECEIVE_0__SHIFT                                                                     0x0
#define PCIE_MC_RCV0__MC_RECEIVE_0_MASK                                                                       0xFFFFFFFFL
//PCIE_MC_RCV1
#define PCIE_MC_RCV1__MC_RECEIVE_1__SHIFT                                                                     0x0
#define PCIE_MC_RCV1__MC_RECEIVE_1_MASK                                                                       0xFFFFFFFFL
//PCIE_MC_BLOCK_ALL0
#define PCIE_MC_BLOCK_ALL0__MC_BLOCK_ALL_0__SHIFT                                                             0x0
#define PCIE_MC_BLOCK_ALL0__MC_BLOCK_ALL_0_MASK                                                               0xFFFFFFFFL
//PCIE_MC_BLOCK_ALL1
#define PCIE_MC_BLOCK_ALL1__MC_BLOCK_ALL_1__SHIFT                                                             0x0
#define PCIE_MC_BLOCK_ALL1__MC_BLOCK_ALL_1_MASK                                                               0xFFFFFFFFL
//PCIE_MC_BLOCK_UNTRANSLATED_0
#define PCIE_MC_BLOCK_UNTRANSLATED_0__MC_BLOCK_UNTRANSLATED_0__SHIFT                                          0x0
#define PCIE_MC_BLOCK_UNTRANSLATED_0__MC_BLOCK_UNTRANSLATED_0_MASK                                            0xFFFFFFFFL
//PCIE_MC_BLOCK_UNTRANSLATED_1
#define PCIE_MC_BLOCK_UNTRANSLATED_1__MC_BLOCK_UNTRANSLATED_1__SHIFT                                          0x0
#define PCIE_MC_BLOCK_UNTRANSLATED_1__MC_BLOCK_UNTRANSLATED_1_MASK                                            0xFFFFFFFFL
//PCIE_LTR_ENH_CAP_LIST
#define PCIE_LTR_ENH_CAP_LIST__CAP_ID__SHIFT                                                                  0x0
#define PCIE_LTR_ENH_CAP_LIST__CAP_VER__SHIFT                                                                 0x10
#define PCIE_LTR_ENH_CAP_LIST__NEXT_PTR__SHIFT                                                                0x14
#define PCIE_LTR_ENH_CAP_LIST__CAP_ID_MASK                                                                    0x0000FFFFL
#define PCIE_LTR_ENH_CAP_LIST__CAP_VER_MASK                                                                   0x000F0000L
#define PCIE_LTR_ENH_CAP_LIST__NEXT_PTR_MASK                                                                  0xFFF00000L
//PCIE_LTR_CAP
#define PCIE_LTR_CAP__LTR_MAX_S_LATENCY_VALUE__SHIFT                                                          0x0
#define PCIE_LTR_CAP__LTR_MAX_S_LATENCY_SCALE__SHIFT                                                          0xa
#define PCIE_LTR_CAP__LTR_MAX_NS_LATENCY_VALUE__SHIFT                                                         0x10
#define PCIE_LTR_CAP__LTR_MAX_NS_LATENCY_SCALE__SHIFT                                                         0x1a
#define PCIE_LTR_CAP__LTR_MAX_S_LATENCY_VALUE_MASK                                                            0x000003FFL
#define PCIE_LTR_CAP__LTR_MAX_S_LATENCY_SCALE_MASK                                                            0x00001C00L
#define PCIE_LTR_CAP__LTR_MAX_NS_LATENCY_VALUE_MASK                                                           0x03FF0000L
#define PCIE_LTR_CAP__LTR_MAX_NS_LATENCY_SCALE_MASK                                                           0x1C000000L
//PCIE_ARI_ENH_CAP_LIST
#define PCIE_ARI_ENH_CAP_LIST__CAP_ID__SHIFT                                                                  0x0
#define PCIE_ARI_ENH_CAP_LIST__CAP_VER__SHIFT                                                                 0x10
#define PCIE_ARI_ENH_CAP_LIST__NEXT_PTR__SHIFT                                                                0x14
#define PCIE_ARI_ENH_CAP_LIST__CAP_ID_MASK                                                                    0x0000FFFFL
#define PCIE_ARI_ENH_CAP_LIST__CAP_VER_MASK                                                                   0x000F0000L
#define PCIE_ARI_ENH_CAP_LIST__NEXT_PTR_MASK                                                                  0xFFF00000L
//PCIE_ARI_CAP
#define PCIE_ARI_CAP__ARI_MFVC_FUNC_GROUPS_CAP__SHIFT                                                         0x0
#define PCIE_ARI_CAP__ARI_ACS_FUNC_GROUPS_CAP__SHIFT                                                          0x1
#define PCIE_ARI_CAP__ARI_NEXT_FUNC_NUM__SHIFT                                                                0x8
#define PCIE_ARI_CAP__ARI_MFVC_FUNC_GROUPS_CAP_MASK                                                           0x0001L
#define PCIE_ARI_CAP__ARI_ACS_FUNC_GROUPS_CAP_MASK                                                            0x0002L
#define PCIE_ARI_CAP__ARI_NEXT_FUNC_NUM_MASK                                                                  0xFF00L
//PCIE_ARI_CNTL
#define PCIE_ARI_CNTL__ARI_MFVC_FUNC_GROUPS_EN__SHIFT                                                         0x0
#define PCIE_ARI_CNTL__ARI_ACS_FUNC_GROUPS_EN__SHIFT                                                          0x1
#define PCIE_ARI_CNTL__ARI_FUNCTION_GROUP__SHIFT                                                              0x4
#define PCIE_ARI_CNTL__ARI_MFVC_FUNC_GROUPS_EN_MASK                                                           0x0001L
#define PCIE_ARI_CNTL__ARI_ACS_FUNC_GROUPS_EN_MASK                                                            0x0002L
#define PCIE_ARI_CNTL__ARI_FUNCTION_GROUP_MASK                                                                0x0070L
//PCIE_SRIOV_ENH_CAP_LIST
#define PCIE_SRIOV_ENH_CAP_LIST__CAP_ID__SHIFT                                                                0x0
#define PCIE_SRIOV_ENH_CAP_LIST__CAP_VER__SHIFT                                                               0x10
#define PCIE_SRIOV_ENH_CAP_LIST__NEXT_PTR__SHIFT                                                              0x14
#define PCIE_SRIOV_ENH_CAP_LIST__CAP_ID_MASK                                                                  0x0000FFFFL
#define PCIE_SRIOV_ENH_CAP_LIST__CAP_VER_MASK                                                                 0x000F0000L
#define PCIE_SRIOV_ENH_CAP_LIST__NEXT_PTR_MASK                                                                0xFFF00000L
//PCIE_SRIOV_CAP
#define PCIE_SRIOV_CAP__SRIOV_VF_MIGRATION_CAP__SHIFT                                                         0x0
#define PCIE_SRIOV_CAP__SRIOV_ARI_CAP_HIERARCHY_PRESERVED__SHIFT                                              0x1
#define PCIE_SRIOV_CAP__SRIOV_VF_MIGRATION_INTR_MSG_NUM__SHIFT                                                0x15
#define PCIE_SRIOV_CAP__SRIOV_VF_MIGRATION_CAP_MASK                                                           0x00000001L
#define PCIE_SRIOV_CAP__SRIOV_ARI_CAP_HIERARCHY_PRESERVED_MASK                                                0x00000002L
#define PCIE_SRIOV_CAP__SRIOV_VF_MIGRATION_INTR_MSG_NUM_MASK                                                  0xFFE00000L
//PCIE_SRIOV_CONTROL
#define PCIE_SRIOV_CONTROL__SRIOV_VF_ENABLE__SHIFT                                                            0x0
#define PCIE_SRIOV_CONTROL__SRIOV_VF_MIGRATION_ENABLE__SHIFT                                                  0x1
#define PCIE_SRIOV_CONTROL__SRIOV_VF_MIGRATION_INTR_ENABLE__SHIFT                                             0x2
#define PCIE_SRIOV_CONTROL__SRIOV_VF_MSE__SHIFT                                                               0x3
#define PCIE_SRIOV_CONTROL__SRIOV_ARI_CAP_HIERARCHY__SHIFT                                                    0x4
#define PCIE_SRIOV_CONTROL__SRIOV_VF_ENABLE_MASK                                                              0x0001L
#define PCIE_SRIOV_CONTROL__SRIOV_VF_MIGRATION_ENABLE_MASK                                                    0x0002L
#define PCIE_SRIOV_CONTROL__SRIOV_VF_MIGRATION_INTR_ENABLE_MASK                                               0x0004L
#define PCIE_SRIOV_CONTROL__SRIOV_VF_MSE_MASK                                                                 0x0008L
#define PCIE_SRIOV_CONTROL__SRIOV_ARI_CAP_HIERARCHY_MASK                                                      0x0010L
//PCIE_SRIOV_STATUS
#define PCIE_SRIOV_STATUS__SRIOV_VF_MIGRATION_STATUS__SHIFT                                                   0x0
#define PCIE_SRIOV_STATUS__SRIOV_VF_MIGRATION_STATUS_MASK                                                     0x0001L
//PCIE_SRIOV_INITIAL_VFS
#define PCIE_SRIOV_INITIAL_VFS__SRIOV_INITIAL_VFS__SHIFT                                                      0x0
#define PCIE_SRIOV_INITIAL_VFS__SRIOV_INITIAL_VFS_MASK                                                        0xFFFFL
//PCIE_SRIOV_TOTAL_VFS
#define PCIE_SRIOV_TOTAL_VFS__SRIOV_TOTAL_VFS__SHIFT                                                          0x0
#define PCIE_SRIOV_TOTAL_VFS__SRIOV_TOTAL_VFS_MASK                                                            0xFFFFL
//PCIE_SRIOV_NUM_VFS
#define PCIE_SRIOV_NUM_VFS__SRIOV_NUM_VFS__SHIFT                                                              0x0
#define PCIE_SRIOV_NUM_VFS__SRIOV_NUM_VFS_MASK                                                                0xFFFFL
//PCIE_SRIOV_FUNC_DEP_LINK
#define PCIE_SRIOV_FUNC_DEP_LINK__SRIOV_FUNC_DEP_LINK__SHIFT                                                  0x0
#define PCIE_SRIOV_FUNC_DEP_LINK__SRIOV_FUNC_DEP_LINK_MASK                                                    0x00FFL
//PCIE_SRIOV_FIRST_VF_OFFSET
#define PCIE_SRIOV_FIRST_VF_OFFSET__SRIOV_FIRST_VF_OFFSET__SHIFT                                              0x0
#define PCIE_SRIOV_FIRST_VF_OFFSET__SRIOV_FIRST_VF_OFFSET_MASK                                                0xFFFFL
//PCIE_SRIOV_VF_STRIDE
#define PCIE_SRIOV_VF_STRIDE__SRIOV_VF_STRIDE__SHIFT                                                          0x0
#define PCIE_SRIOV_VF_STRIDE__SRIOV_VF_STRIDE_MASK                                                            0xFFFFL
//PCIE_SRIOV_VF_DEVICE_ID
#define PCIE_SRIOV_VF_DEVICE_ID__SRIOV_VF_DEVICE_ID__SHIFT                                                    0x0
#define PCIE_SRIOV_VF_DEVICE_ID__SRIOV_VF_DEVICE_ID_MASK                                                      0xFFFFL
//PCIE_SRIOV_SUPPORTED_PAGE_SIZE
#define PCIE_SRIOV_SUPPORTED_PAGE_SIZE__SRIOV_SUPPORTED_PAGE_SIZE__SHIFT                                      0x0
#define PCIE_SRIOV_SUPPORTED_PAGE_SIZE__SRIOV_SUPPORTED_PAGE_SIZE_MASK                                        0xFFFFFFFFL
//PCIE_SRIOV_SYSTEM_PAGE_SIZE
#define PCIE_SRIOV_SYSTEM_PAGE_SIZE__SRIOV_SYSTEM_PAGE_SIZE__SHIFT                                            0x0
#define PCIE_SRIOV_SYSTEM_PAGE_SIZE__SRIOV_SYSTEM_PAGE_SIZE_MASK                                              0xFFFFFFFFL
//PCIE_SRIOV_VF_BASE_ADDR_0
#define PCIE_SRIOV_VF_BASE_ADDR_0__VF_BASE_ADDR__SHIFT                                                        0x0
#define PCIE_SRIOV_VF_BASE_ADDR_0__VF_BASE_ADDR_MASK                                                          0xFFFFFFFFL
//PCIE_SRIOV_VF_BASE_ADDR_1
#define PCIE_SRIOV_VF_BASE_ADDR_1__VF_BASE_ADDR__SHIFT                                                        0x0
#define PCIE_SRIOV_VF_BASE_ADDR_1__VF_BASE_ADDR_MASK                                                          0xFFFFFFFFL
//PCIE_SRIOV_VF_BASE_ADDR_2
#define PCIE_SRIOV_VF_BASE_ADDR_2__VF_BASE_ADDR__SHIFT                                                        0x0
#define PCIE_SRIOV_VF_BASE_ADDR_2__VF_BASE_ADDR_MASK                                                          0xFFFFFFFFL
//PCIE_SRIOV_VF_BASE_ADDR_3
#define PCIE_SRIOV_VF_BASE_ADDR_3__VF_BASE_ADDR__SHIFT                                                        0x0
#define PCIE_SRIOV_VF_BASE_ADDR_3__VF_BASE_ADDR_MASK                                                          0xFFFFFFFFL
//PCIE_SRIOV_VF_BASE_ADDR_4
#define PCIE_SRIOV_VF_BASE_ADDR_4__VF_BASE_ADDR__SHIFT                                                        0x0
#define PCIE_SRIOV_VF_BASE_ADDR_4__VF_BASE_ADDR_MASK                                                          0xFFFFFFFFL
//PCIE_SRIOV_VF_BASE_ADDR_5
#define PCIE_SRIOV_VF_BASE_ADDR_5__VF_BASE_ADDR__SHIFT                                                        0x0
#define PCIE_SRIOV_VF_BASE_ADDR_5__VF_BASE_ADDR_MASK                                                          0xFFFFFFFFL
//PCIE_SRIOV_VF_MIGRATION_STATE_ARRAY_OFFSET
#define PCIE_SRIOV_VF_MIGRATION_STATE_ARRAY_OFFSET__SRIOV_VF_MIGRATION_STATE_BIF__SHIFT                       0x0
#define PCIE_SRIOV_VF_MIGRATION_STATE_ARRAY_OFFSET__SRIOV_VF_MIGRATION_STATE_ARRAY_OFFSET__SHIFT              0x3
#define PCIE_SRIOV_VF_MIGRATION_STATE_ARRAY_OFFSET__SRIOV_VF_MIGRATION_STATE_BIF_MASK                         0x00000007L
#define PCIE_SRIOV_VF_MIGRATION_STATE_ARRAY_OFFSET__SRIOV_VF_MIGRATION_STATE_ARRAY_OFFSET_MASK                0xFFFFFFF8L
//PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_GPUIOV
#define PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_GPUIOV__CAP_ID__SHIFT                                               0x0
#define PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_GPUIOV__CAP_VER__SHIFT                                              0x10
#define PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_GPUIOV__NEXT_PTR__SHIFT                                             0x14
#define PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_GPUIOV__CAP_ID_MASK                                                 0x0000FFFFL
#define PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_GPUIOV__CAP_VER_MASK                                                0x000F0000L
#define PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_GPUIOV__NEXT_PTR_MASK                                               0xFFF00000L
//PCIE_VENDOR_SPECIFIC_HDR_GPUIOV
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV__VSEC_ID__SHIFT                                                       0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV__VSEC_REV__SHIFT                                                      0x10
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV__VSEC_LENGTH__SHIFT                                                   0x14
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV__VSEC_ID_MASK                                                         0x0000FFFFL
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV__VSEC_REV_MASK                                                        0x000F0000L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV__VSEC_LENGTH_MASK                                                     0xFFF00000L
//PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_SRIOV_SHADOW
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_SRIOV_SHADOW__VF_EN__SHIFT                                            0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_SRIOV_SHADOW__VF_NUM__SHIFT                                           0x10
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_SRIOV_SHADOW__VF_EN_MASK                                              0x00000001L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_SRIOV_SHADOW__VF_NUM_MASK                                             0xFFFF0000L
//PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_ENABLE
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_ENABLE__GFX_CMD_COMPLETE_INTR_EN__SHIFT                          0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_ENABLE__GFX_HANG_SELF_RECOVERED_INTR_EN__SHIFT                   0x1
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_ENABLE__GFX_HANG_NEED_FLR_INTR_EN__SHIFT                         0x2
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_ENABLE__GFX_VM_BUSY_TRANSITION_INTR_EN__SHIFT                    0x3
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_ENABLE__UVD_CMD_COMPLETE_INTR_EN__SHIFT                          0x8
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_ENABLE__UVD_HANG_SELF_RECOVERED_INTR_EN__SHIFT                   0x9
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_ENABLE__UVD_HANG_NEED_FLR_INTR_EN__SHIFT                         0xa
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_ENABLE__UVD_VM_BUSY_TRANSITION_INTR_EN__SHIFT                    0xb
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_ENABLE__VCE_CMD_COMPLETE_INTR_EN__SHIFT                          0x10
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_ENABLE__VCE_HANG_SELF_RECOVERED_INTR_EN__SHIFT                   0x11
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_ENABLE__VCE_HANG_NEED_FLR_INTR_EN__SHIFT                         0x12
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_ENABLE__VCE_VM_BUSY_TRANSITION_INTR_EN__SHIFT                    0x13
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_ENABLE__HVVM_MAILBOX_TRN_ACK_INTR_EN__SHIFT                      0x18
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_ENABLE__HVVM_MAILBOX_RCV_VALID_INTR_EN__SHIFT                    0x19
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_ENABLE__GFX_CMD_COMPLETE_INTR_EN_MASK                            0x00000001L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_ENABLE__GFX_HANG_SELF_RECOVERED_INTR_EN_MASK                     0x00000002L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_ENABLE__GFX_HANG_NEED_FLR_INTR_EN_MASK                           0x00000004L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_ENABLE__GFX_VM_BUSY_TRANSITION_INTR_EN_MASK                      0x00000008L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_ENABLE__UVD_CMD_COMPLETE_INTR_EN_MASK                            0x00000100L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_ENABLE__UVD_HANG_SELF_RECOVERED_INTR_EN_MASK                     0x00000200L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_ENABLE__UVD_HANG_NEED_FLR_INTR_EN_MASK                           0x00000400L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_ENABLE__UVD_VM_BUSY_TRANSITION_INTR_EN_MASK                      0x00000800L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_ENABLE__VCE_CMD_COMPLETE_INTR_EN_MASK                            0x00010000L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_ENABLE__VCE_HANG_SELF_RECOVERED_INTR_EN_MASK                     0x00020000L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_ENABLE__VCE_HANG_NEED_FLR_INTR_EN_MASK                           0x00040000L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_ENABLE__VCE_VM_BUSY_TRANSITION_INTR_EN_MASK                      0x00080000L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_ENABLE__HVVM_MAILBOX_TRN_ACK_INTR_EN_MASK                        0x01000000L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_ENABLE__HVVM_MAILBOX_RCV_VALID_INTR_EN_MASK                      0x02000000L
//PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_STATUS
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_STATUS__GFX_CMD_COMPLETE_INTR_STATUS__SHIFT                      0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_STATUS__GFX_HANG_SELF_RECOVERED_INTR_STATUS__SHIFT               0x1
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_STATUS__GFX_HANG_NEED_FLR_INTR_STATUS__SHIFT                     0x2
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_STATUS__GFX_VM_BUSY_TRANSITION_INTR_STATUS__SHIFT                0x3
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_STATUS__UVD_CMD_COMPLETE_INTR_STATUS__SHIFT                      0x8
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_STATUS__UVD_HANG_SELF_RECOVERED_INTR_STATUS__SHIFT               0x9
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_STATUS__UVD_HANG_NEED_FLR_INTR_STATUS__SHIFT                     0xa
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_STATUS__UVD_VM_BUSY_TRANSITION_INTR_STATUS__SHIFT                0xb
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_STATUS__VCE_CMD_COMPLETE_INTR_STATUS__SHIFT                      0x10
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_STATUS__VCE_HANG_SELF_RECOVERED_INTR_STATUS__SHIFT               0x11
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_STATUS__VCE_HANG_NEED_FLR_INTR_STATUS__SHIFT                     0x12
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_STATUS__VCE_VM_BUSY_TRANSITION_INTR_STATUS__SHIFT                0x13
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_STATUS__HVVM_MAILBOX_TRN_ACK_INTR_STATUS__SHIFT                  0x18
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_STATUS__HVVM_MAILBOX_RCV_VALID_INTR_STATUS__SHIFT                0x19
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_STATUS__GFX_CMD_COMPLETE_INTR_STATUS_MASK                        0x00000001L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_STATUS__GFX_HANG_SELF_RECOVERED_INTR_STATUS_MASK                 0x00000002L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_STATUS__GFX_HANG_NEED_FLR_INTR_STATUS_MASK                       0x00000004L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_STATUS__GFX_VM_BUSY_TRANSITION_INTR_STATUS_MASK                  0x00000008L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_STATUS__UVD_CMD_COMPLETE_INTR_STATUS_MASK                        0x00000100L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_STATUS__UVD_HANG_SELF_RECOVERED_INTR_STATUS_MASK                 0x00000200L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_STATUS__UVD_HANG_NEED_FLR_INTR_STATUS_MASK                       0x00000400L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_STATUS__UVD_VM_BUSY_TRANSITION_INTR_STATUS_MASK                  0x00000800L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_STATUS__VCE_CMD_COMPLETE_INTR_STATUS_MASK                        0x00010000L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_STATUS__VCE_HANG_SELF_RECOVERED_INTR_STATUS_MASK                 0x00020000L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_STATUS__VCE_HANG_NEED_FLR_INTR_STATUS_MASK                       0x00040000L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_STATUS__VCE_VM_BUSY_TRANSITION_INTR_STATUS_MASK                  0x00080000L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_STATUS__HVVM_MAILBOX_TRN_ACK_INTR_STATUS_MASK                    0x01000000L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_STATUS__HVVM_MAILBOX_RCV_VALID_INTR_STATUS_MASK                  0x02000000L
//PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_RESET_CONTROL
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_RESET_CONTROL__SOFT_PF_FLR__SHIFT                                     0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_RESET_CONTROL__SOFT_PF_FLR_MASK                                       0x0001L
//PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW0__VF_INDEX__SHIFT                                        0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW0__TRN_MSG_DATA__SHIFT                                    0x8
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW0__TRN_MSG_VALID__SHIFT                                   0xf
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW0__RCV_MSG_DATA__SHIFT                                    0x10
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW0__RCV_MSG_ACK__SHIFT                                     0x18
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW0__VF_INDEX_MASK                                          0x000000FFL
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW0__TRN_MSG_DATA_MASK                                      0x00000F00L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW0__TRN_MSG_VALID_MASK                                     0x00008000L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW0__RCV_MSG_DATA_MASK                                      0x000F0000L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW0__RCV_MSG_ACK_MASK                                       0x01000000L
//PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF0_TRN_ACK__SHIFT                                     0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF0_RCV_VALID__SHIFT                                   0x1
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF1_TRN_ACK__SHIFT                                     0x2
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF1_RCV_VALID__SHIFT                                   0x3
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF2_TRN_ACK__SHIFT                                     0x4
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF2_RCV_VALID__SHIFT                                   0x5
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF3_TRN_ACK__SHIFT                                     0x6
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF3_RCV_VALID__SHIFT                                   0x7
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF4_TRN_ACK__SHIFT                                     0x8
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF4_RCV_VALID__SHIFT                                   0x9
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF5_TRN_ACK__SHIFT                                     0xa
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF5_RCV_VALID__SHIFT                                   0xb
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF6_TRN_ACK__SHIFT                                     0xc
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF6_RCV_VALID__SHIFT                                   0xd
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF7_TRN_ACK__SHIFT                                     0xe
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF7_RCV_VALID__SHIFT                                   0xf
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF8_TRN_ACK__SHIFT                                     0x10
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF8_RCV_VALID__SHIFT                                   0x11
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF9_TRN_ACK__SHIFT                                     0x12
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF9_RCV_VALID__SHIFT                                   0x13
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF10_TRN_ACK__SHIFT                                    0x14
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF10_RCV_VALID__SHIFT                                  0x15
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF11_TRN_ACK__SHIFT                                    0x16
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF11_RCV_VALID__SHIFT                                  0x17
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF12_TRN_ACK__SHIFT                                    0x18
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF12_RCV_VALID__SHIFT                                  0x19
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF13_TRN_ACK__SHIFT                                    0x1a
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF13_RCV_VALID__SHIFT                                  0x1b
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF14_TRN_ACK__SHIFT                                    0x1c
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF14_RCV_VALID__SHIFT                                  0x1d
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF15_TRN_ACK__SHIFT                                    0x1e
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF15_RCV_VALID__SHIFT                                  0x1f
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF0_TRN_ACK_MASK                                       0x00000001L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF0_RCV_VALID_MASK                                     0x00000002L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF1_TRN_ACK_MASK                                       0x00000004L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF1_RCV_VALID_MASK                                     0x00000008L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF2_TRN_ACK_MASK                                       0x00000010L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF2_RCV_VALID_MASK                                     0x00000020L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF3_TRN_ACK_MASK                                       0x00000040L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF3_RCV_VALID_MASK                                     0x00000080L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF4_TRN_ACK_MASK                                       0x00000100L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF4_RCV_VALID_MASK                                     0x00000200L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF5_TRN_ACK_MASK                                       0x00000400L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF5_RCV_VALID_MASK                                     0x00000800L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF6_TRN_ACK_MASK                                       0x00001000L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF6_RCV_VALID_MASK                                     0x00002000L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF7_TRN_ACK_MASK                                       0x00004000L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF7_RCV_VALID_MASK                                     0x00008000L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF8_TRN_ACK_MASK                                       0x00010000L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF8_RCV_VALID_MASK                                     0x00020000L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF9_TRN_ACK_MASK                                       0x00040000L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF9_RCV_VALID_MASK                                     0x00080000L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF10_TRN_ACK_MASK                                      0x00100000L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF10_RCV_VALID_MASK                                    0x00200000L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF11_TRN_ACK_MASK                                      0x00400000L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF11_RCV_VALID_MASK                                    0x00800000L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF12_TRN_ACK_MASK                                      0x01000000L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF12_RCV_VALID_MASK                                    0x02000000L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF13_TRN_ACK_MASK                                      0x04000000L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF13_RCV_VALID_MASK                                    0x08000000L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF14_TRN_ACK_MASK                                      0x10000000L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF14_RCV_VALID_MASK                                    0x20000000L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF15_TRN_ACK_MASK                                      0x40000000L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF15_RCV_VALID_MASK                                    0x80000000L
//PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW2
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW2__PF_TRN_ACK__SHIFT                                      0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW2__PF_RCV_VALID__SHIFT                                    0x1
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW2__PF_TRN_ACK_MASK                                        0x00000001L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW2__PF_RCV_VALID_MASK                                      0x00000002L
//PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_CONTEXT
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_CONTEXT__CONTEXT_SIZE__SHIFT                                          0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_CONTEXT__LOC__SHIFT                                                   0x7
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_CONTEXT__CONTEXT_OFFSET__SHIFT                                        0xa
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_CONTEXT__CONTEXT_SIZE_MASK                                            0x0000007FL
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_CONTEXT__LOC_MASK                                                     0x00000080L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_CONTEXT__CONTEXT_OFFSET_MASK                                          0xFFFFFC00L
//PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_TOTAL_FB
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_TOTAL_FB__TOTAL_FB_AVAILABLE__SHIFT                                   0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_TOTAL_FB__TOTAL_FB_CONSUMED__SHIFT                                    0x10
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_TOTAL_FB__TOTAL_FB_AVAILABLE_MASK                                     0x0000FFFFL
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_TOTAL_FB__TOTAL_FB_CONSUMED_MASK                                      0xFFFF0000L
//PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_OFFSETS
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_OFFSETS__UVDSCH_OFFSET__SHIFT                                         0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_OFFSETS__VCESCH_OFFSET__SHIFT                                         0x8
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_OFFSETS__GFXSCH_OFFSET__SHIFT                                         0x10
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_OFFSETS__UVDSCH_OFFSET_MASK                                           0x000000FFL
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_OFFSETS__VCESCH_OFFSET_MASK                                           0x0000FF00L
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_OFFSETS__GFXSCH_OFFSET_MASK                                           0x00FF0000L
//PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF0_FB
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF0_FB__VF0_FB_SIZE__SHIFT                                            0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF0_FB__VF0_FB_OFFSET__SHIFT                                          0x10
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF0_FB__VF0_FB_SIZE_MASK                                              0x0000FFFFL
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF0_FB__VF0_FB_OFFSET_MASK                                            0xFFFF0000L
//PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF1_FB
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF1_FB__VF1_FB_SIZE__SHIFT                                            0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF1_FB__VF1_FB_OFFSET__SHIFT                                          0x10
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF1_FB__VF1_FB_SIZE_MASK                                              0x0000FFFFL
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF1_FB__VF1_FB_OFFSET_MASK                                            0xFFFF0000L
//PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF2_FB
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF2_FB__VF2_FB_SIZE__SHIFT                                            0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF2_FB__VF2_FB_OFFSET__SHIFT                                          0x10
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF2_FB__VF2_FB_SIZE_MASK                                              0x0000FFFFL
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF2_FB__VF2_FB_OFFSET_MASK                                            0xFFFF0000L
//PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF3_FB
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF3_FB__VF3_FB_SIZE__SHIFT                                            0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF3_FB__VF3_FB_OFFSET__SHIFT                                          0x10
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF3_FB__VF3_FB_SIZE_MASK                                              0x0000FFFFL
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF3_FB__VF3_FB_OFFSET_MASK                                            0xFFFF0000L
//PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF4_FB
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF4_FB__VF4_FB_SIZE__SHIFT                                            0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF4_FB__VF4_FB_OFFSET__SHIFT                                          0x10
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF4_FB__VF4_FB_SIZE_MASK                                              0x0000FFFFL
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF4_FB__VF4_FB_OFFSET_MASK                                            0xFFFF0000L
//PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF5_FB
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF5_FB__VF5_FB_SIZE__SHIFT                                            0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF5_FB__VF5_FB_OFFSET__SHIFT                                          0x10
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF5_FB__VF5_FB_SIZE_MASK                                              0x0000FFFFL
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF5_FB__VF5_FB_OFFSET_MASK                                            0xFFFF0000L
//PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF6_FB
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF6_FB__VF6_FB_SIZE__SHIFT                                            0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF6_FB__VF6_FB_OFFSET__SHIFT                                          0x10
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF6_FB__VF6_FB_SIZE_MASK                                              0x0000FFFFL
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF6_FB__VF6_FB_OFFSET_MASK                                            0xFFFF0000L
//PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF7_FB
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF7_FB__VF7_FB_SIZE__SHIFT                                            0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF7_FB__VF7_FB_OFFSET__SHIFT                                          0x10
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF7_FB__VF7_FB_SIZE_MASK                                              0x0000FFFFL
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF7_FB__VF7_FB_OFFSET_MASK                                            0xFFFF0000L
//PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF8_FB
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF8_FB__VF8_FB_SIZE__SHIFT                                            0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF8_FB__VF8_FB_OFFSET__SHIFT                                          0x10
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF8_FB__VF8_FB_SIZE_MASK                                              0x0000FFFFL
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF8_FB__VF8_FB_OFFSET_MASK                                            0xFFFF0000L
//PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF9_FB
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF9_FB__VF9_FB_SIZE__SHIFT                                            0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF9_FB__VF9_FB_OFFSET__SHIFT                                          0x10
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF9_FB__VF9_FB_SIZE_MASK                                              0x0000FFFFL
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF9_FB__VF9_FB_OFFSET_MASK                                            0xFFFF0000L
//PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF10_FB
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF10_FB__VF10_FB_SIZE__SHIFT                                          0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF10_FB__VF10_FB_OFFSET__SHIFT                                        0x10
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF10_FB__VF10_FB_SIZE_MASK                                            0x0000FFFFL
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF10_FB__VF10_FB_OFFSET_MASK                                          0xFFFF0000L
//PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF11_FB
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF11_FB__VF11_FB_SIZE__SHIFT                                          0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF11_FB__VF11_FB_OFFSET__SHIFT                                        0x10
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF11_FB__VF11_FB_SIZE_MASK                                            0x0000FFFFL
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF11_FB__VF11_FB_OFFSET_MASK                                          0xFFFF0000L
//PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF12_FB
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF12_FB__VF12_FB_SIZE__SHIFT                                          0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF12_FB__VF12_FB_OFFSET__SHIFT                                        0x10
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF12_FB__VF12_FB_SIZE_MASK                                            0x0000FFFFL
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF12_FB__VF12_FB_OFFSET_MASK                                          0xFFFF0000L
//PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF13_FB
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF13_FB__VF13_FB_SIZE__SHIFT                                          0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF13_FB__VF13_FB_OFFSET__SHIFT                                        0x10
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF13_FB__VF13_FB_SIZE_MASK                                            0x0000FFFFL
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF13_FB__VF13_FB_OFFSET_MASK                                          0xFFFF0000L
//PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF14_FB
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF14_FB__VF14_FB_SIZE__SHIFT                                          0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF14_FB__VF14_FB_OFFSET__SHIFT                                        0x10
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF14_FB__VF14_FB_SIZE_MASK                                            0x0000FFFFL
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF14_FB__VF14_FB_OFFSET_MASK                                          0xFFFF0000L
//PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF15_FB
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF15_FB__VF15_FB_SIZE__SHIFT                                          0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF15_FB__VF15_FB_OFFSET__SHIFT                                        0x10
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF15_FB__VF15_FB_SIZE_MASK                                            0x0000FFFFL
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF15_FB__VF15_FB_OFFSET_MASK                                          0xFFFF0000L
//PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW0__DW0__SHIFT                                                0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW0__DW0_MASK                                                  0xFFFFFFFFL
//PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW1
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW1__DW1__SHIFT                                                0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW1__DW1_MASK                                                  0xFFFFFFFFL
//PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW2
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW2__DW2__SHIFT                                                0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW2__DW2_MASK                                                  0xFFFFFFFFL
//PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW3
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW3__DW3__SHIFT                                                0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW3__DW3_MASK                                                  0xFFFFFFFFL
//PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW4
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW4__DW4__SHIFT                                                0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW4__DW4_MASK                                                  0xFFFFFFFFL
//PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW5
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW5__DW5__SHIFT                                                0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW5__DW5_MASK                                                  0xFFFFFFFFL
//PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW6
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW6__DW6__SHIFT                                                0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW6__DW6_MASK                                                  0xFFFFFFFFL
//PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW7
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW7__DW7__SHIFT                                                0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW7__DW7_MASK                                                  0xFFFFFFFFL
//PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW8
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW8__DW8__SHIFT                                                0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW8__DW8_MASK                                                  0xFFFFFFFFL
//PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW0__DW0__SHIFT                                                0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW0__DW0_MASK                                                  0xFFFFFFFFL
//PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW1
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW1__DW1__SHIFT                                                0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW1__DW1_MASK                                                  0xFFFFFFFFL
//PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW2
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW2__DW2__SHIFT                                                0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW2__DW2_MASK                                                  0xFFFFFFFFL
//PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW3
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW3__DW3__SHIFT                                                0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW3__DW3_MASK                                                  0xFFFFFFFFL
//PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW4
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW4__DW4__SHIFT                                                0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW4__DW4_MASK                                                  0xFFFFFFFFL
//PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW5
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW5__DW5__SHIFT                                                0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW5__DW5_MASK                                                  0xFFFFFFFFL
//PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW6
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW6__DW6__SHIFT                                                0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW6__DW6_MASK                                                  0xFFFFFFFFL
//PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW7
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW7__DW7__SHIFT                                                0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW7__DW7_MASK                                                  0xFFFFFFFFL
//PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW8
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW8__DW8__SHIFT                                                0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW8__DW8_MASK                                                  0xFFFFFFFFL
//PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW0__DW0__SHIFT                                                0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW0__DW0_MASK                                                  0xFFFFFFFFL
//PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW1
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW1__DW1__SHIFT                                                0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW1__DW1_MASK                                                  0xFFFFFFFFL
//PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW2
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW2__DW2__SHIFT                                                0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW2__DW2_MASK                                                  0xFFFFFFFFL
//PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW3
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW3__DW3__SHIFT                                                0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW3__DW3_MASK                                                  0xFFFFFFFFL
//PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW4
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW4__DW4__SHIFT                                                0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW4__DW4_MASK                                                  0xFFFFFFFFL
//PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW5
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW5__DW5__SHIFT                                                0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW5__DW5_MASK                                                  0xFFFFFFFFL
//PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW6
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW6__DW6__SHIFT                                                0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW6__DW6_MASK                                                  0xFFFFFFFFL
//PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW7
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW7__DW7__SHIFT                                                0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW7__DW7_MASK                                                  0xFFFFFFFFL
//PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW8
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW8__DW8__SHIFT                                                0x0
#define PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW8__DW8_MASK                                                  0xFFFFFFFFL


// addressBlock: nbio_nbif0_bif_cfg_dev0_epf1_bifcfgdecp
//BIF_CFG_DEV0_EPF1_0_VENDOR_ID
#define BIF_CFG_DEV0_EPF1_0_VENDOR_ID__VENDOR_ID__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF1_0_VENDOR_ID__VENDOR_ID_MASK                                                         0xFFFFL
//BIF_CFG_DEV0_EPF1_0_DEVICE_ID
#define BIF_CFG_DEV0_EPF1_0_DEVICE_ID__DEVICE_ID__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF1_0_DEVICE_ID__DEVICE_ID_MASK                                                         0xFFFFL
//BIF_CFG_DEV0_EPF1_0_COMMAND
#define BIF_CFG_DEV0_EPF1_0_COMMAND__IO_ACCESS_EN__SHIFT                                                      0x0
#define BIF_CFG_DEV0_EPF1_0_COMMAND__MEM_ACCESS_EN__SHIFT                                                     0x1
#define BIF_CFG_DEV0_EPF1_0_COMMAND__BUS_MASTER_EN__SHIFT                                                     0x2
#define BIF_CFG_DEV0_EPF1_0_COMMAND__SPECIAL_CYCLE_EN__SHIFT                                                  0x3
#define BIF_CFG_DEV0_EPF1_0_COMMAND__MEM_WRITE_INVALIDATE_EN__SHIFT                                           0x4
#define BIF_CFG_DEV0_EPF1_0_COMMAND__PAL_SNOOP_EN__SHIFT                                                      0x5
#define BIF_CFG_DEV0_EPF1_0_COMMAND__PARITY_ERROR_RESPONSE__SHIFT                                             0x6
#define BIF_CFG_DEV0_EPF1_0_COMMAND__AD_STEPPING__SHIFT                                                       0x7
#define BIF_CFG_DEV0_EPF1_0_COMMAND__SERR_EN__SHIFT                                                           0x8
#define BIF_CFG_DEV0_EPF1_0_COMMAND__FAST_B2B_EN__SHIFT                                                       0x9
#define BIF_CFG_DEV0_EPF1_0_COMMAND__INT_DIS__SHIFT                                                           0xa
#define BIF_CFG_DEV0_EPF1_0_COMMAND__IO_ACCESS_EN_MASK                                                        0x0001L
#define BIF_CFG_DEV0_EPF1_0_COMMAND__MEM_ACCESS_EN_MASK                                                       0x0002L
#define BIF_CFG_DEV0_EPF1_0_COMMAND__BUS_MASTER_EN_MASK                                                       0x0004L
#define BIF_CFG_DEV0_EPF1_0_COMMAND__SPECIAL_CYCLE_EN_MASK                                                    0x0008L
#define BIF_CFG_DEV0_EPF1_0_COMMAND__MEM_WRITE_INVALIDATE_EN_MASK                                             0x0010L
#define BIF_CFG_DEV0_EPF1_0_COMMAND__PAL_SNOOP_EN_MASK                                                        0x0020L
#define BIF_CFG_DEV0_EPF1_0_COMMAND__PARITY_ERROR_RESPONSE_MASK                                               0x0040L
#define BIF_CFG_DEV0_EPF1_0_COMMAND__AD_STEPPING_MASK                                                         0x0080L
#define BIF_CFG_DEV0_EPF1_0_COMMAND__SERR_EN_MASK                                                             0x0100L
#define BIF_CFG_DEV0_EPF1_0_COMMAND__FAST_B2B_EN_MASK                                                         0x0200L
#define BIF_CFG_DEV0_EPF1_0_COMMAND__INT_DIS_MASK                                                             0x0400L
//BIF_CFG_DEV0_EPF1_0_STATUS
#define BIF_CFG_DEV0_EPF1_0_STATUS__INT_STATUS__SHIFT                                                         0x3
#define BIF_CFG_DEV0_EPF1_0_STATUS__CAP_LIST__SHIFT                                                           0x4
#define BIF_CFG_DEV0_EPF1_0_STATUS__PCI_66_EN__SHIFT                                                          0x5
#define BIF_CFG_DEV0_EPF1_0_STATUS__FAST_BACK_CAPABLE__SHIFT                                                  0x7
#define BIF_CFG_DEV0_EPF1_0_STATUS__MASTER_DATA_PARITY_ERROR__SHIFT                                           0x8
#define BIF_CFG_DEV0_EPF1_0_STATUS__DEVSEL_TIMING__SHIFT                                                      0x9
#define BIF_CFG_DEV0_EPF1_0_STATUS__SIGNAL_TARGET_ABORT__SHIFT                                                0xb
#define BIF_CFG_DEV0_EPF1_0_STATUS__RECEIVED_TARGET_ABORT__SHIFT                                              0xc
#define BIF_CFG_DEV0_EPF1_0_STATUS__RECEIVED_MASTER_ABORT__SHIFT                                              0xd
#define BIF_CFG_DEV0_EPF1_0_STATUS__SIGNALED_SYSTEM_ERROR__SHIFT                                              0xe
#define BIF_CFG_DEV0_EPF1_0_STATUS__PARITY_ERROR_DETECTED__SHIFT                                              0xf
#define BIF_CFG_DEV0_EPF1_0_STATUS__INT_STATUS_MASK                                                           0x0008L
#define BIF_CFG_DEV0_EPF1_0_STATUS__CAP_LIST_MASK                                                             0x0010L
#define BIF_CFG_DEV0_EPF1_0_STATUS__PCI_66_EN_MASK                                                            0x0020L
#define BIF_CFG_DEV0_EPF1_0_STATUS__FAST_BACK_CAPABLE_MASK                                                    0x0080L
#define BIF_CFG_DEV0_EPF1_0_STATUS__MASTER_DATA_PARITY_ERROR_MASK                                             0x0100L
#define BIF_CFG_DEV0_EPF1_0_STATUS__DEVSEL_TIMING_MASK                                                        0x0600L
#define BIF_CFG_DEV0_EPF1_0_STATUS__SIGNAL_TARGET_ABORT_MASK                                                  0x0800L
#define BIF_CFG_DEV0_EPF1_0_STATUS__RECEIVED_TARGET_ABORT_MASK                                                0x1000L
#define BIF_CFG_DEV0_EPF1_0_STATUS__RECEIVED_MASTER_ABORT_MASK                                                0x2000L
#define BIF_CFG_DEV0_EPF1_0_STATUS__SIGNALED_SYSTEM_ERROR_MASK                                                0x4000L
#define BIF_CFG_DEV0_EPF1_0_STATUS__PARITY_ERROR_DETECTED_MASK                                                0x8000L
//BIF_CFG_DEV0_EPF1_0_REVISION_ID
#define BIF_CFG_DEV0_EPF1_0_REVISION_ID__MINOR_REV_ID__SHIFT                                                  0x0
#define BIF_CFG_DEV0_EPF1_0_REVISION_ID__MAJOR_REV_ID__SHIFT                                                  0x4
#define BIF_CFG_DEV0_EPF1_0_REVISION_ID__MINOR_REV_ID_MASK                                                    0x0FL
#define BIF_CFG_DEV0_EPF1_0_REVISION_ID__MAJOR_REV_ID_MASK                                                    0xF0L
//BIF_CFG_DEV0_EPF1_0_PROG_INTERFACE
#define BIF_CFG_DEV0_EPF1_0_PROG_INTERFACE__PROG_INTERFACE__SHIFT                                             0x0
#define BIF_CFG_DEV0_EPF1_0_PROG_INTERFACE__PROG_INTERFACE_MASK                                               0xFFL
//BIF_CFG_DEV0_EPF1_0_SUB_CLASS
#define BIF_CFG_DEV0_EPF1_0_SUB_CLASS__SUB_CLASS__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF1_0_SUB_CLASS__SUB_CLASS_MASK                                                         0xFFL
//BIF_CFG_DEV0_EPF1_0_BASE_CLASS
#define BIF_CFG_DEV0_EPF1_0_BASE_CLASS__BASE_CLASS__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF1_0_BASE_CLASS__BASE_CLASS_MASK                                                       0xFFL
//BIF_CFG_DEV0_EPF1_0_CACHE_LINE
#define BIF_CFG_DEV0_EPF1_0_CACHE_LINE__CACHE_LINE_SIZE__SHIFT                                                0x0
#define BIF_CFG_DEV0_EPF1_0_CACHE_LINE__CACHE_LINE_SIZE_MASK                                                  0xFFL
//BIF_CFG_DEV0_EPF1_0_LATENCY
#define BIF_CFG_DEV0_EPF1_0_LATENCY__LATENCY_TIMER__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF1_0_LATENCY__LATENCY_TIMER_MASK                                                       0xFFL
//BIF_CFG_DEV0_EPF1_0_HEADER
#define BIF_CFG_DEV0_EPF1_0_HEADER__HEADER_TYPE__SHIFT                                                        0x0
#define BIF_CFG_DEV0_EPF1_0_HEADER__DEVICE_TYPE__SHIFT                                                        0x7
#define BIF_CFG_DEV0_EPF1_0_HEADER__HEADER_TYPE_MASK                                                          0x7FL
#define BIF_CFG_DEV0_EPF1_0_HEADER__DEVICE_TYPE_MASK                                                          0x80L
//BIF_CFG_DEV0_EPF1_0_BIST
#define BIF_CFG_DEV0_EPF1_0_BIST__BIST_COMP__SHIFT                                                            0x0
#define BIF_CFG_DEV0_EPF1_0_BIST__BIST_STRT__SHIFT                                                            0x6
#define BIF_CFG_DEV0_EPF1_0_BIST__BIST_CAP__SHIFT                                                             0x7
#define BIF_CFG_DEV0_EPF1_0_BIST__BIST_COMP_MASK                                                              0x0FL
#define BIF_CFG_DEV0_EPF1_0_BIST__BIST_STRT_MASK                                                              0x40L
#define BIF_CFG_DEV0_EPF1_0_BIST__BIST_CAP_MASK                                                               0x80L
//BIF_CFG_DEV0_EPF1_0_BASE_ADDR_1
#define BIF_CFG_DEV0_EPF1_0_BASE_ADDR_1__BASE_ADDR__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF1_0_BASE_ADDR_1__BASE_ADDR_MASK                                                       0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_BASE_ADDR_2
#define BIF_CFG_DEV0_EPF1_0_BASE_ADDR_2__BASE_ADDR__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF1_0_BASE_ADDR_2__BASE_ADDR_MASK                                                       0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_BASE_ADDR_3
#define BIF_CFG_DEV0_EPF1_0_BASE_ADDR_3__BASE_ADDR__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF1_0_BASE_ADDR_3__BASE_ADDR_MASK                                                       0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_BASE_ADDR_4
#define BIF_CFG_DEV0_EPF1_0_BASE_ADDR_4__BASE_ADDR__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF1_0_BASE_ADDR_4__BASE_ADDR_MASK                                                       0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_BASE_ADDR_5
#define BIF_CFG_DEV0_EPF1_0_BASE_ADDR_5__BASE_ADDR__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF1_0_BASE_ADDR_5__BASE_ADDR_MASK                                                       0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_BASE_ADDR_6
#define BIF_CFG_DEV0_EPF1_0_BASE_ADDR_6__BASE_ADDR__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF1_0_BASE_ADDR_6__BASE_ADDR_MASK                                                       0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_ADAPTER_ID
#define BIF_CFG_DEV0_EPF1_0_ADAPTER_ID__SUBSYSTEM_VENDOR_ID__SHIFT                                            0x0
#define BIF_CFG_DEV0_EPF1_0_ADAPTER_ID__SUBSYSTEM_ID__SHIFT                                                   0x10
#define BIF_CFG_DEV0_EPF1_0_ADAPTER_ID__SUBSYSTEM_VENDOR_ID_MASK                                              0x0000FFFFL
#define BIF_CFG_DEV0_EPF1_0_ADAPTER_ID__SUBSYSTEM_ID_MASK                                                     0xFFFF0000L
//BIF_CFG_DEV0_EPF1_0_ROM_BASE_ADDR
#define BIF_CFG_DEV0_EPF1_0_ROM_BASE_ADDR__BASE_ADDR__SHIFT                                                   0x0
#define BIF_CFG_DEV0_EPF1_0_ROM_BASE_ADDR__BASE_ADDR_MASK                                                     0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_CAP_PTR
#define BIF_CFG_DEV0_EPF1_0_CAP_PTR__CAP_PTR__SHIFT                                                           0x0
#define BIF_CFG_DEV0_EPF1_0_CAP_PTR__CAP_PTR_MASK                                                             0x000000FFL
//BIF_CFG_DEV0_EPF1_0_INTERRUPT_LINE
#define BIF_CFG_DEV0_EPF1_0_INTERRUPT_LINE__INTERRUPT_LINE__SHIFT                                             0x0
#define BIF_CFG_DEV0_EPF1_0_INTERRUPT_LINE__INTERRUPT_LINE_MASK                                               0xFFL
//BIF_CFG_DEV0_EPF1_0_INTERRUPT_PIN
#define BIF_CFG_DEV0_EPF1_0_INTERRUPT_PIN__INTERRUPT_PIN__SHIFT                                               0x0
#define BIF_CFG_DEV0_EPF1_0_INTERRUPT_PIN__INTERRUPT_PIN_MASK                                                 0xFFL
//BIF_CFG_DEV0_EPF1_0_MIN_GRANT
#define BIF_CFG_DEV0_EPF1_0_MIN_GRANT__MIN_GNT__SHIFT                                                         0x0
#define BIF_CFG_DEV0_EPF1_0_MIN_GRANT__MIN_GNT_MASK                                                           0xFFL
//BIF_CFG_DEV0_EPF1_0_MAX_LATENCY
#define BIF_CFG_DEV0_EPF1_0_MAX_LATENCY__MAX_LAT__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF1_0_MAX_LATENCY__MAX_LAT_MASK                                                         0xFFL
//BIF_CFG_DEV0_EPF1_0_VENDOR_CAP_LIST
#define BIF_CFG_DEV0_EPF1_0_VENDOR_CAP_LIST__CAP_ID__SHIFT                                                    0x0
#define BIF_CFG_DEV0_EPF1_0_VENDOR_CAP_LIST__NEXT_PTR__SHIFT                                                  0x8
#define BIF_CFG_DEV0_EPF1_0_VENDOR_CAP_LIST__LENGTH__SHIFT                                                    0x10
#define BIF_CFG_DEV0_EPF1_0_VENDOR_CAP_LIST__CAP_ID_MASK                                                      0x000000FFL
#define BIF_CFG_DEV0_EPF1_0_VENDOR_CAP_LIST__NEXT_PTR_MASK                                                    0x0000FF00L
#define BIF_CFG_DEV0_EPF1_0_VENDOR_CAP_LIST__LENGTH_MASK                                                      0x00FF0000L
//BIF_CFG_DEV0_EPF1_0_ADAPTER_ID_W
#define BIF_CFG_DEV0_EPF1_0_ADAPTER_ID_W__SUBSYSTEM_VENDOR_ID__SHIFT                                          0x0
#define BIF_CFG_DEV0_EPF1_0_ADAPTER_ID_W__SUBSYSTEM_ID__SHIFT                                                 0x10
#define BIF_CFG_DEV0_EPF1_0_ADAPTER_ID_W__SUBSYSTEM_VENDOR_ID_MASK                                            0x0000FFFFL
#define BIF_CFG_DEV0_EPF1_0_ADAPTER_ID_W__SUBSYSTEM_ID_MASK                                                   0xFFFF0000L
//BIF_CFG_DEV0_EPF1_0_PMI_CAP_LIST
#define BIF_CFG_DEV0_EPF1_0_PMI_CAP_LIST__CAP_ID__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF1_0_PMI_CAP_LIST__NEXT_PTR__SHIFT                                                     0x8
#define BIF_CFG_DEV0_EPF1_0_PMI_CAP_LIST__CAP_ID_MASK                                                         0x00FFL
#define BIF_CFG_DEV0_EPF1_0_PMI_CAP_LIST__NEXT_PTR_MASK                                                       0xFF00L
//BIF_CFG_DEV0_EPF1_0_PMI_CAP
#define BIF_CFG_DEV0_EPF1_0_PMI_CAP__VERSION__SHIFT                                                           0x0
#define BIF_CFG_DEV0_EPF1_0_PMI_CAP__PME_CLOCK__SHIFT                                                         0x3
#define BIF_CFG_DEV0_EPF1_0_PMI_CAP__DEV_SPECIFIC_INIT__SHIFT                                                 0x5
#define BIF_CFG_DEV0_EPF1_0_PMI_CAP__AUX_CURRENT__SHIFT                                                       0x6
#define BIF_CFG_DEV0_EPF1_0_PMI_CAP__D1_SUPPORT__SHIFT                                                        0x9
#define BIF_CFG_DEV0_EPF1_0_PMI_CAP__D2_SUPPORT__SHIFT                                                        0xa
#define BIF_CFG_DEV0_EPF1_0_PMI_CAP__PME_SUPPORT__SHIFT                                                       0xb
#define BIF_CFG_DEV0_EPF1_0_PMI_CAP__VERSION_MASK                                                             0x0007L
#define BIF_CFG_DEV0_EPF1_0_PMI_CAP__PME_CLOCK_MASK                                                           0x0008L
#define BIF_CFG_DEV0_EPF1_0_PMI_CAP__DEV_SPECIFIC_INIT_MASK                                                   0x0020L
#define BIF_CFG_DEV0_EPF1_0_PMI_CAP__AUX_CURRENT_MASK                                                         0x01C0L
#define BIF_CFG_DEV0_EPF1_0_PMI_CAP__D1_SUPPORT_MASK                                                          0x0200L
#define BIF_CFG_DEV0_EPF1_0_PMI_CAP__D2_SUPPORT_MASK                                                          0x0400L
#define BIF_CFG_DEV0_EPF1_0_PMI_CAP__PME_SUPPORT_MASK                                                         0xF800L
//BIF_CFG_DEV0_EPF1_0_PMI_STATUS_CNTL
#define BIF_CFG_DEV0_EPF1_0_PMI_STATUS_CNTL__POWER_STATE__SHIFT                                               0x0
#define BIF_CFG_DEV0_EPF1_0_PMI_STATUS_CNTL__NO_SOFT_RESET__SHIFT                                             0x3
#define BIF_CFG_DEV0_EPF1_0_PMI_STATUS_CNTL__PME_EN__SHIFT                                                    0x8
#define BIF_CFG_DEV0_EPF1_0_PMI_STATUS_CNTL__DATA_SELECT__SHIFT                                               0x9
#define BIF_CFG_DEV0_EPF1_0_PMI_STATUS_CNTL__DATA_SCALE__SHIFT                                                0xd
#define BIF_CFG_DEV0_EPF1_0_PMI_STATUS_CNTL__PME_STATUS__SHIFT                                                0xf
#define BIF_CFG_DEV0_EPF1_0_PMI_STATUS_CNTL__B2_B3_SUPPORT__SHIFT                                             0x16
#define BIF_CFG_DEV0_EPF1_0_PMI_STATUS_CNTL__BUS_PWR_EN__SHIFT                                                0x17
#define BIF_CFG_DEV0_EPF1_0_PMI_STATUS_CNTL__PMI_DATA__SHIFT                                                  0x18
#define BIF_CFG_DEV0_EPF1_0_PMI_STATUS_CNTL__POWER_STATE_MASK                                                 0x00000003L
#define BIF_CFG_DEV0_EPF1_0_PMI_STATUS_CNTL__NO_SOFT_RESET_MASK                                               0x00000008L
#define BIF_CFG_DEV0_EPF1_0_PMI_STATUS_CNTL__PME_EN_MASK                                                      0x00000100L
#define BIF_CFG_DEV0_EPF1_0_PMI_STATUS_CNTL__DATA_SELECT_MASK                                                 0x00001E00L
#define BIF_CFG_DEV0_EPF1_0_PMI_STATUS_CNTL__DATA_SCALE_MASK                                                  0x00006000L
#define BIF_CFG_DEV0_EPF1_0_PMI_STATUS_CNTL__PME_STATUS_MASK                                                  0x00008000L
#define BIF_CFG_DEV0_EPF1_0_PMI_STATUS_CNTL__B2_B3_SUPPORT_MASK                                               0x00400000L
#define BIF_CFG_DEV0_EPF1_0_PMI_STATUS_CNTL__BUS_PWR_EN_MASK                                                  0x00800000L
#define BIF_CFG_DEV0_EPF1_0_PMI_STATUS_CNTL__PMI_DATA_MASK                                                    0xFF000000L
//BIF_CFG_DEV0_EPF1_0_PCIE_CAP_LIST
#define BIF_CFG_DEV0_EPF1_0_PCIE_CAP_LIST__CAP_ID__SHIFT                                                      0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_CAP_LIST__NEXT_PTR__SHIFT                                                    0x8
#define BIF_CFG_DEV0_EPF1_0_PCIE_CAP_LIST__CAP_ID_MASK                                                        0x00FFL
#define BIF_CFG_DEV0_EPF1_0_PCIE_CAP_LIST__NEXT_PTR_MASK                                                      0xFF00L
//BIF_CFG_DEV0_EPF1_0_PCIE_CAP
#define BIF_CFG_DEV0_EPF1_0_PCIE_CAP__VERSION__SHIFT                                                          0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_CAP__DEVICE_TYPE__SHIFT                                                      0x4
#define BIF_CFG_DEV0_EPF1_0_PCIE_CAP__SLOT_IMPLEMENTED__SHIFT                                                 0x8
#define BIF_CFG_DEV0_EPF1_0_PCIE_CAP__INT_MESSAGE_NUM__SHIFT                                                  0x9
#define BIF_CFG_DEV0_EPF1_0_PCIE_CAP__VERSION_MASK                                                            0x000FL
#define BIF_CFG_DEV0_EPF1_0_PCIE_CAP__DEVICE_TYPE_MASK                                                        0x00F0L
#define BIF_CFG_DEV0_EPF1_0_PCIE_CAP__SLOT_IMPLEMENTED_MASK                                                   0x0100L
#define BIF_CFG_DEV0_EPF1_0_PCIE_CAP__INT_MESSAGE_NUM_MASK                                                    0x3E00L
//BIF_CFG_DEV0_EPF1_0_DEVICE_CAP
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CAP__MAX_PAYLOAD_SUPPORT__SHIFT                                            0x0
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CAP__PHANTOM_FUNC__SHIFT                                                   0x3
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CAP__EXTENDED_TAG__SHIFT                                                   0x5
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CAP__L0S_ACCEPTABLE_LATENCY__SHIFT                                         0x6
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CAP__L1_ACCEPTABLE_LATENCY__SHIFT                                          0x9
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CAP__ROLE_BASED_ERR_REPORTING__SHIFT                                       0xf
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CAP__CAPTURED_SLOT_POWER_LIMIT__SHIFT                                      0x12
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CAP__CAPTURED_SLOT_POWER_SCALE__SHIFT                                      0x1a
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CAP__FLR_CAPABLE__SHIFT                                                    0x1c
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CAP__MAX_PAYLOAD_SUPPORT_MASK                                              0x00000007L
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CAP__PHANTOM_FUNC_MASK                                                     0x00000018L
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CAP__EXTENDED_TAG_MASK                                                     0x00000020L
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CAP__L0S_ACCEPTABLE_LATENCY_MASK                                           0x000001C0L
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CAP__L1_ACCEPTABLE_LATENCY_MASK                                            0x00000E00L
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CAP__ROLE_BASED_ERR_REPORTING_MASK                                         0x00008000L
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CAP__CAPTURED_SLOT_POWER_LIMIT_MASK                                        0x03FC0000L
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CAP__CAPTURED_SLOT_POWER_SCALE_MASK                                        0x0C000000L
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CAP__FLR_CAPABLE_MASK                                                      0x10000000L
//BIF_CFG_DEV0_EPF1_0_DEVICE_CNTL
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CNTL__CORR_ERR_EN__SHIFT                                                   0x0
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CNTL__NON_FATAL_ERR_EN__SHIFT                                              0x1
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CNTL__FATAL_ERR_EN__SHIFT                                                  0x2
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CNTL__USR_REPORT_EN__SHIFT                                                 0x3
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CNTL__RELAXED_ORD_EN__SHIFT                                                0x4
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CNTL__MAX_PAYLOAD_SIZE__SHIFT                                              0x5
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CNTL__EXTENDED_TAG_EN__SHIFT                                               0x8
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CNTL__PHANTOM_FUNC_EN__SHIFT                                               0x9
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CNTL__AUX_POWER_PM_EN__SHIFT                                               0xa
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CNTL__NO_SNOOP_EN__SHIFT                                                   0xb
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CNTL__MAX_READ_REQUEST_SIZE__SHIFT                                         0xc
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CNTL__INITIATE_FLR__SHIFT                                                  0xf
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CNTL__CORR_ERR_EN_MASK                                                     0x0001L
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CNTL__NON_FATAL_ERR_EN_MASK                                                0x0002L
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CNTL__FATAL_ERR_EN_MASK                                                    0x0004L
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CNTL__USR_REPORT_EN_MASK                                                   0x0008L
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CNTL__RELAXED_ORD_EN_MASK                                                  0x0010L
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CNTL__MAX_PAYLOAD_SIZE_MASK                                                0x00E0L
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CNTL__EXTENDED_TAG_EN_MASK                                                 0x0100L
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CNTL__PHANTOM_FUNC_EN_MASK                                                 0x0200L
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CNTL__AUX_POWER_PM_EN_MASK                                                 0x0400L
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CNTL__NO_SNOOP_EN_MASK                                                     0x0800L
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CNTL__MAX_READ_REQUEST_SIZE_MASK                                           0x7000L
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CNTL__INITIATE_FLR_MASK                                                    0x8000L
//BIF_CFG_DEV0_EPF1_0_DEVICE_STATUS
#define BIF_CFG_DEV0_EPF1_0_DEVICE_STATUS__CORR_ERR__SHIFT                                                    0x0
#define BIF_CFG_DEV0_EPF1_0_DEVICE_STATUS__NON_FATAL_ERR__SHIFT                                               0x1
#define BIF_CFG_DEV0_EPF1_0_DEVICE_STATUS__FATAL_ERR__SHIFT                                                   0x2
#define BIF_CFG_DEV0_EPF1_0_DEVICE_STATUS__USR_DETECTED__SHIFT                                                0x3
#define BIF_CFG_DEV0_EPF1_0_DEVICE_STATUS__AUX_PWR__SHIFT                                                     0x4
#define BIF_CFG_DEV0_EPF1_0_DEVICE_STATUS__TRANSACTIONS_PEND__SHIFT                                           0x5
#define BIF_CFG_DEV0_EPF1_0_DEVICE_STATUS__CORR_ERR_MASK                                                      0x0001L
#define BIF_CFG_DEV0_EPF1_0_DEVICE_STATUS__NON_FATAL_ERR_MASK                                                 0x0002L
#define BIF_CFG_DEV0_EPF1_0_DEVICE_STATUS__FATAL_ERR_MASK                                                     0x0004L
#define BIF_CFG_DEV0_EPF1_0_DEVICE_STATUS__USR_DETECTED_MASK                                                  0x0008L
#define BIF_CFG_DEV0_EPF1_0_DEVICE_STATUS__AUX_PWR_MASK                                                       0x0010L
#define BIF_CFG_DEV0_EPF1_0_DEVICE_STATUS__TRANSACTIONS_PEND_MASK                                             0x0020L
//BIF_CFG_DEV0_EPF1_0_LINK_CAP
#define BIF_CFG_DEV0_EPF1_0_LINK_CAP__LINK_SPEED__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF1_0_LINK_CAP__LINK_WIDTH__SHIFT                                                       0x4
#define BIF_CFG_DEV0_EPF1_0_LINK_CAP__PM_SUPPORT__SHIFT                                                       0xa
#define BIF_CFG_DEV0_EPF1_0_LINK_CAP__L0S_EXIT_LATENCY__SHIFT                                                 0xc
#define BIF_CFG_DEV0_EPF1_0_LINK_CAP__L1_EXIT_LATENCY__SHIFT                                                  0xf
#define BIF_CFG_DEV0_EPF1_0_LINK_CAP__CLOCK_POWER_MANAGEMENT__SHIFT                                           0x12
#define BIF_CFG_DEV0_EPF1_0_LINK_CAP__SURPRISE_DOWN_ERR_REPORTING__SHIFT                                      0x13
#define BIF_CFG_DEV0_EPF1_0_LINK_CAP__DL_ACTIVE_REPORTING_CAPABLE__SHIFT                                      0x14
#define BIF_CFG_DEV0_EPF1_0_LINK_CAP__LINK_BW_NOTIFICATION_CAP__SHIFT                                         0x15
#define BIF_CFG_DEV0_EPF1_0_LINK_CAP__ASPM_OPTIONALITY_COMPLIANCE__SHIFT                                      0x16
#define BIF_CFG_DEV0_EPF1_0_LINK_CAP__PORT_NUMBER__SHIFT                                                      0x18
#define BIF_CFG_DEV0_EPF1_0_LINK_CAP__LINK_SPEED_MASK                                                         0x0000000FL
#define BIF_CFG_DEV0_EPF1_0_LINK_CAP__LINK_WIDTH_MASK                                                         0x000003F0L
#define BIF_CFG_DEV0_EPF1_0_LINK_CAP__PM_SUPPORT_MASK                                                         0x00000C00L
#define BIF_CFG_DEV0_EPF1_0_LINK_CAP__L0S_EXIT_LATENCY_MASK                                                   0x00007000L
#define BIF_CFG_DEV0_EPF1_0_LINK_CAP__L1_EXIT_LATENCY_MASK                                                    0x00038000L
#define BIF_CFG_DEV0_EPF1_0_LINK_CAP__CLOCK_POWER_MANAGEMENT_MASK                                             0x00040000L
#define BIF_CFG_DEV0_EPF1_0_LINK_CAP__SURPRISE_DOWN_ERR_REPORTING_MASK                                        0x00080000L
#define BIF_CFG_DEV0_EPF1_0_LINK_CAP__DL_ACTIVE_REPORTING_CAPABLE_MASK                                        0x00100000L
#define BIF_CFG_DEV0_EPF1_0_LINK_CAP__LINK_BW_NOTIFICATION_CAP_MASK                                           0x00200000L
#define BIF_CFG_DEV0_EPF1_0_LINK_CAP__ASPM_OPTIONALITY_COMPLIANCE_MASK                                        0x00400000L
#define BIF_CFG_DEV0_EPF1_0_LINK_CAP__PORT_NUMBER_MASK                                                        0xFF000000L
//BIF_CFG_DEV0_EPF1_0_LINK_CNTL
#define BIF_CFG_DEV0_EPF1_0_LINK_CNTL__PM_CONTROL__SHIFT                                                      0x0
#define BIF_CFG_DEV0_EPF1_0_LINK_CNTL__READ_CPL_BOUNDARY__SHIFT                                               0x3
#define BIF_CFG_DEV0_EPF1_0_LINK_CNTL__LINK_DIS__SHIFT                                                        0x4
#define BIF_CFG_DEV0_EPF1_0_LINK_CNTL__RETRAIN_LINK__SHIFT                                                    0x5
#define BIF_CFG_DEV0_EPF1_0_LINK_CNTL__COMMON_CLOCK_CFG__SHIFT                                                0x6
#define BIF_CFG_DEV0_EPF1_0_LINK_CNTL__EXTENDED_SYNC__SHIFT                                                   0x7
#define BIF_CFG_DEV0_EPF1_0_LINK_CNTL__CLOCK_POWER_MANAGEMENT_EN__SHIFT                                       0x8
#define BIF_CFG_DEV0_EPF1_0_LINK_CNTL__HW_AUTONOMOUS_WIDTH_DISABLE__SHIFT                                     0x9
#define BIF_CFG_DEV0_EPF1_0_LINK_CNTL__LINK_BW_MANAGEMENT_INT_EN__SHIFT                                       0xa
#define BIF_CFG_DEV0_EPF1_0_LINK_CNTL__LINK_AUTONOMOUS_BW_INT_EN__SHIFT                                       0xb
#define BIF_CFG_DEV0_EPF1_0_LINK_CNTL__PM_CONTROL_MASK                                                        0x0003L
#define BIF_CFG_DEV0_EPF1_0_LINK_CNTL__READ_CPL_BOUNDARY_MASK                                                 0x0008L
#define BIF_CFG_DEV0_EPF1_0_LINK_CNTL__LINK_DIS_MASK                                                          0x0010L
#define BIF_CFG_DEV0_EPF1_0_LINK_CNTL__RETRAIN_LINK_MASK                                                      0x0020L
#define BIF_CFG_DEV0_EPF1_0_LINK_CNTL__COMMON_CLOCK_CFG_MASK                                                  0x0040L
#define BIF_CFG_DEV0_EPF1_0_LINK_CNTL__EXTENDED_SYNC_MASK                                                     0x0080L
#define BIF_CFG_DEV0_EPF1_0_LINK_CNTL__CLOCK_POWER_MANAGEMENT_EN_MASK                                         0x0100L
#define BIF_CFG_DEV0_EPF1_0_LINK_CNTL__HW_AUTONOMOUS_WIDTH_DISABLE_MASK                                       0x0200L
#define BIF_CFG_DEV0_EPF1_0_LINK_CNTL__LINK_BW_MANAGEMENT_INT_EN_MASK                                         0x0400L
#define BIF_CFG_DEV0_EPF1_0_LINK_CNTL__LINK_AUTONOMOUS_BW_INT_EN_MASK                                         0x0800L
//BIF_CFG_DEV0_EPF1_0_LINK_STATUS
#define BIF_CFG_DEV0_EPF1_0_LINK_STATUS__CURRENT_LINK_SPEED__SHIFT                                            0x0
#define BIF_CFG_DEV0_EPF1_0_LINK_STATUS__NEGOTIATED_LINK_WIDTH__SHIFT                                         0x4
#define BIF_CFG_DEV0_EPF1_0_LINK_STATUS__LINK_TRAINING__SHIFT                                                 0xb
#define BIF_CFG_DEV0_EPF1_0_LINK_STATUS__SLOT_CLOCK_CFG__SHIFT                                                0xc
#define BIF_CFG_DEV0_EPF1_0_LINK_STATUS__DL_ACTIVE__SHIFT                                                     0xd
#define BIF_CFG_DEV0_EPF1_0_LINK_STATUS__LINK_BW_MANAGEMENT_STATUS__SHIFT                                     0xe
#define BIF_CFG_DEV0_EPF1_0_LINK_STATUS__LINK_AUTONOMOUS_BW_STATUS__SHIFT                                     0xf
#define BIF_CFG_DEV0_EPF1_0_LINK_STATUS__CURRENT_LINK_SPEED_MASK                                              0x000FL
#define BIF_CFG_DEV0_EPF1_0_LINK_STATUS__NEGOTIATED_LINK_WIDTH_MASK                                           0x03F0L
#define BIF_CFG_DEV0_EPF1_0_LINK_STATUS__LINK_TRAINING_MASK                                                   0x0800L
#define BIF_CFG_DEV0_EPF1_0_LINK_STATUS__SLOT_CLOCK_CFG_MASK                                                  0x1000L
#define BIF_CFG_DEV0_EPF1_0_LINK_STATUS__DL_ACTIVE_MASK                                                       0x2000L
#define BIF_CFG_DEV0_EPF1_0_LINK_STATUS__LINK_BW_MANAGEMENT_STATUS_MASK                                       0x4000L
#define BIF_CFG_DEV0_EPF1_0_LINK_STATUS__LINK_AUTONOMOUS_BW_STATUS_MASK                                       0x8000L
//BIF_CFG_DEV0_EPF1_0_DEVICE_CAP2
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CAP2__CPL_TIMEOUT_RANGE_SUPPORTED__SHIFT                                   0x0
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CAP2__CPL_TIMEOUT_DIS_SUPPORTED__SHIFT                                     0x4
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CAP2__ARI_FORWARDING_SUPPORTED__SHIFT                                      0x5
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CAP2__ATOMICOP_ROUTING_SUPPORTED__SHIFT                                    0x6
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CAP2__ATOMICOP_32CMPLT_SUPPORTED__SHIFT                                    0x7
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CAP2__ATOMICOP_64CMPLT_SUPPORTED__SHIFT                                    0x8
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CAP2__CAS128_CMPLT_SUPPORTED__SHIFT                                        0x9
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CAP2__NO_RO_ENABLED_P2P_PASSING__SHIFT                                     0xa
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CAP2__LTR_SUPPORTED__SHIFT                                                 0xb
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CAP2__TPH_CPLR_SUPPORTED__SHIFT                                            0xc
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CAP2__OBFF_SUPPORTED__SHIFT                                                0x12
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CAP2__EXTENDED_FMT_FIELD_SUPPORTED__SHIFT                                  0x14
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CAP2__END_END_TLP_PREFIX_SUPPORTED__SHIFT                                  0x15
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CAP2__MAX_END_END_TLP_PREFIXES__SHIFT                                      0x16
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CAP2__CPL_TIMEOUT_RANGE_SUPPORTED_MASK                                     0x0000000FL
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CAP2__CPL_TIMEOUT_DIS_SUPPORTED_MASK                                       0x00000010L
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CAP2__ARI_FORWARDING_SUPPORTED_MASK                                        0x00000020L
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CAP2__ATOMICOP_ROUTING_SUPPORTED_MASK                                      0x00000040L
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CAP2__ATOMICOP_32CMPLT_SUPPORTED_MASK                                      0x00000080L
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CAP2__ATOMICOP_64CMPLT_SUPPORTED_MASK                                      0x00000100L
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CAP2__CAS128_CMPLT_SUPPORTED_MASK                                          0x00000200L
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CAP2__NO_RO_ENABLED_P2P_PASSING_MASK                                       0x00000400L
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CAP2__LTR_SUPPORTED_MASK                                                   0x00000800L
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CAP2__TPH_CPLR_SUPPORTED_MASK                                              0x00003000L
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CAP2__OBFF_SUPPORTED_MASK                                                  0x000C0000L
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CAP2__EXTENDED_FMT_FIELD_SUPPORTED_MASK                                    0x00100000L
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CAP2__END_END_TLP_PREFIX_SUPPORTED_MASK                                    0x00200000L
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CAP2__MAX_END_END_TLP_PREFIXES_MASK                                        0x00C00000L
//BIF_CFG_DEV0_EPF1_0_DEVICE_CNTL2
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CNTL2__CPL_TIMEOUT_VALUE__SHIFT                                            0x0
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CNTL2__CPL_TIMEOUT_DIS__SHIFT                                              0x4
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CNTL2__ARI_FORWARDING_EN__SHIFT                                            0x5
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CNTL2__ATOMICOP_REQUEST_EN__SHIFT                                          0x6
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CNTL2__ATOMICOP_EGRESS_BLOCKING__SHIFT                                     0x7
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CNTL2__IDO_REQUEST_ENABLE__SHIFT                                           0x8
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CNTL2__IDO_COMPLETION_ENABLE__SHIFT                                        0x9
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CNTL2__LTR_EN__SHIFT                                                       0xa
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CNTL2__OBFF_EN__SHIFT                                                      0xd
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CNTL2__END_END_TLP_PREFIX_BLOCKING__SHIFT                                  0xf
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CNTL2__CPL_TIMEOUT_VALUE_MASK                                              0x000FL
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CNTL2__CPL_TIMEOUT_DIS_MASK                                                0x0010L
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CNTL2__ARI_FORWARDING_EN_MASK                                              0x0020L
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CNTL2__ATOMICOP_REQUEST_EN_MASK                                            0x0040L
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CNTL2__ATOMICOP_EGRESS_BLOCKING_MASK                                       0x0080L
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CNTL2__IDO_REQUEST_ENABLE_MASK                                             0x0100L
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CNTL2__IDO_COMPLETION_ENABLE_MASK                                          0x0200L
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CNTL2__LTR_EN_MASK                                                         0x0400L
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CNTL2__OBFF_EN_MASK                                                        0x6000L
#define BIF_CFG_DEV0_EPF1_0_DEVICE_CNTL2__END_END_TLP_PREFIX_BLOCKING_MASK                                    0x8000L
//BIF_CFG_DEV0_EPF1_0_DEVICE_STATUS2
#define BIF_CFG_DEV0_EPF1_0_DEVICE_STATUS2__RESERVED__SHIFT                                                   0x0
#define BIF_CFG_DEV0_EPF1_0_DEVICE_STATUS2__RESERVED_MASK                                                     0xFFFFL
//BIF_CFG_DEV0_EPF1_0_LINK_CAP2
#define BIF_CFG_DEV0_EPF1_0_LINK_CAP2__SUPPORTED_LINK_SPEED__SHIFT                                            0x1
#define BIF_CFG_DEV0_EPF1_0_LINK_CAP2__CROSSLINK_SUPPORTED__SHIFT                                             0x8
#define BIF_CFG_DEV0_EPF1_0_LINK_CAP2__RESERVED__SHIFT                                                        0x9
#define BIF_CFG_DEV0_EPF1_0_LINK_CAP2__SUPPORTED_LINK_SPEED_MASK                                              0x000000FEL
#define BIF_CFG_DEV0_EPF1_0_LINK_CAP2__CROSSLINK_SUPPORTED_MASK                                               0x00000100L
#define BIF_CFG_DEV0_EPF1_0_LINK_CAP2__RESERVED_MASK                                                          0xFFFFFE00L
//BIF_CFG_DEV0_EPF1_0_LINK_CNTL2
#define BIF_CFG_DEV0_EPF1_0_LINK_CNTL2__TARGET_LINK_SPEED__SHIFT                                              0x0
#define BIF_CFG_DEV0_EPF1_0_LINK_CNTL2__ENTER_COMPLIANCE__SHIFT                                               0x4
#define BIF_CFG_DEV0_EPF1_0_LINK_CNTL2__HW_AUTONOMOUS_SPEED_DISABLE__SHIFT                                    0x5
#define BIF_CFG_DEV0_EPF1_0_LINK_CNTL2__SELECTABLE_DEEMPHASIS__SHIFT                                          0x6
#define BIF_CFG_DEV0_EPF1_0_LINK_CNTL2__XMIT_MARGIN__SHIFT                                                    0x7
#define BIF_CFG_DEV0_EPF1_0_LINK_CNTL2__ENTER_MOD_COMPLIANCE__SHIFT                                           0xa
#define BIF_CFG_DEV0_EPF1_0_LINK_CNTL2__COMPLIANCE_SOS__SHIFT                                                 0xb
#define BIF_CFG_DEV0_EPF1_0_LINK_CNTL2__COMPLIANCE_DEEMPHASIS__SHIFT                                          0xc
#define BIF_CFG_DEV0_EPF1_0_LINK_CNTL2__TARGET_LINK_SPEED_MASK                                                0x000FL
#define BIF_CFG_DEV0_EPF1_0_LINK_CNTL2__ENTER_COMPLIANCE_MASK                                                 0x0010L
#define BIF_CFG_DEV0_EPF1_0_LINK_CNTL2__HW_AUTONOMOUS_SPEED_DISABLE_MASK                                      0x0020L
#define BIF_CFG_DEV0_EPF1_0_LINK_CNTL2__SELECTABLE_DEEMPHASIS_MASK                                            0x0040L
#define BIF_CFG_DEV0_EPF1_0_LINK_CNTL2__XMIT_MARGIN_MASK                                                      0x0380L
#define BIF_CFG_DEV0_EPF1_0_LINK_CNTL2__ENTER_MOD_COMPLIANCE_MASK                                             0x0400L
#define BIF_CFG_DEV0_EPF1_0_LINK_CNTL2__COMPLIANCE_SOS_MASK                                                   0x0800L
#define BIF_CFG_DEV0_EPF1_0_LINK_CNTL2__COMPLIANCE_DEEMPHASIS_MASK                                            0xF000L
//BIF_CFG_DEV0_EPF1_0_LINK_STATUS2
#define BIF_CFG_DEV0_EPF1_0_LINK_STATUS2__CUR_DEEMPHASIS_LEVEL__SHIFT                                         0x0
#define BIF_CFG_DEV0_EPF1_0_LINK_STATUS2__EQUALIZATION_COMPLETE__SHIFT                                        0x1
#define BIF_CFG_DEV0_EPF1_0_LINK_STATUS2__EQUALIZATION_PHASE1_SUCCESS__SHIFT                                  0x2
#define BIF_CFG_DEV0_EPF1_0_LINK_STATUS2__EQUALIZATION_PHASE2_SUCCESS__SHIFT                                  0x3
#define BIF_CFG_DEV0_EPF1_0_LINK_STATUS2__EQUALIZATION_PHASE3_SUCCESS__SHIFT                                  0x4
#define BIF_CFG_DEV0_EPF1_0_LINK_STATUS2__LINK_EQUALIZATION_REQUEST__SHIFT                                    0x5
#define BIF_CFG_DEV0_EPF1_0_LINK_STATUS2__CUR_DEEMPHASIS_LEVEL_MASK                                           0x0001L
#define BIF_CFG_DEV0_EPF1_0_LINK_STATUS2__EQUALIZATION_COMPLETE_MASK                                          0x0002L
#define BIF_CFG_DEV0_EPF1_0_LINK_STATUS2__EQUALIZATION_PHASE1_SUCCESS_MASK                                    0x0004L
#define BIF_CFG_DEV0_EPF1_0_LINK_STATUS2__EQUALIZATION_PHASE2_SUCCESS_MASK                                    0x0008L
#define BIF_CFG_DEV0_EPF1_0_LINK_STATUS2__EQUALIZATION_PHASE3_SUCCESS_MASK                                    0x0010L
#define BIF_CFG_DEV0_EPF1_0_LINK_STATUS2__LINK_EQUALIZATION_REQUEST_MASK                                      0x0020L
//BIF_CFG_DEV0_EPF1_0_SLOT_CAP2
#define BIF_CFG_DEV0_EPF1_0_SLOT_CAP2__RESERVED__SHIFT                                                        0x0
#define BIF_CFG_DEV0_EPF1_0_SLOT_CAP2__RESERVED_MASK                                                          0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_SLOT_CNTL2
#define BIF_CFG_DEV0_EPF1_0_SLOT_CNTL2__RESERVED__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF1_0_SLOT_CNTL2__RESERVED_MASK                                                         0xFFFFL
//BIF_CFG_DEV0_EPF1_0_SLOT_STATUS2
#define BIF_CFG_DEV0_EPF1_0_SLOT_STATUS2__RESERVED__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF1_0_SLOT_STATUS2__RESERVED_MASK                                                       0xFFFFL
//BIF_CFG_DEV0_EPF1_0_MSI_CAP_LIST
#define BIF_CFG_DEV0_EPF1_0_MSI_CAP_LIST__CAP_ID__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF1_0_MSI_CAP_LIST__NEXT_PTR__SHIFT                                                     0x8
#define BIF_CFG_DEV0_EPF1_0_MSI_CAP_LIST__CAP_ID_MASK                                                         0x00FFL
#define BIF_CFG_DEV0_EPF1_0_MSI_CAP_LIST__NEXT_PTR_MASK                                                       0xFF00L
//BIF_CFG_DEV0_EPF1_0_MSI_MSG_CNTL
#define BIF_CFG_DEV0_EPF1_0_MSI_MSG_CNTL__MSI_EN__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF1_0_MSI_MSG_CNTL__MSI_MULTI_CAP__SHIFT                                                0x1
#define BIF_CFG_DEV0_EPF1_0_MSI_MSG_CNTL__MSI_MULTI_EN__SHIFT                                                 0x4
#define BIF_CFG_DEV0_EPF1_0_MSI_MSG_CNTL__MSI_64BIT__SHIFT                                                    0x7
#define BIF_CFG_DEV0_EPF1_0_MSI_MSG_CNTL__MSI_PERVECTOR_MASKING_CAP__SHIFT                                    0x8
#define BIF_CFG_DEV0_EPF1_0_MSI_MSG_CNTL__MSI_EN_MASK                                                         0x0001L
#define BIF_CFG_DEV0_EPF1_0_MSI_MSG_CNTL__MSI_MULTI_CAP_MASK                                                  0x000EL
#define BIF_CFG_DEV0_EPF1_0_MSI_MSG_CNTL__MSI_MULTI_EN_MASK                                                   0x0070L
#define BIF_CFG_DEV0_EPF1_0_MSI_MSG_CNTL__MSI_64BIT_MASK                                                      0x0080L
#define BIF_CFG_DEV0_EPF1_0_MSI_MSG_CNTL__MSI_PERVECTOR_MASKING_CAP_MASK                                      0x0100L
//BIF_CFG_DEV0_EPF1_0_MSI_MSG_ADDR_LO
#define BIF_CFG_DEV0_EPF1_0_MSI_MSG_ADDR_LO__MSI_MSG_ADDR_LO__SHIFT                                           0x2
#define BIF_CFG_DEV0_EPF1_0_MSI_MSG_ADDR_LO__MSI_MSG_ADDR_LO_MASK                                             0xFFFFFFFCL
//BIF_CFG_DEV0_EPF1_0_MSI_MSG_ADDR_HI
#define BIF_CFG_DEV0_EPF1_0_MSI_MSG_ADDR_HI__MSI_MSG_ADDR_HI__SHIFT                                           0x0
#define BIF_CFG_DEV0_EPF1_0_MSI_MSG_ADDR_HI__MSI_MSG_ADDR_HI_MASK                                             0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_MSI_MSG_DATA
#define BIF_CFG_DEV0_EPF1_0_MSI_MSG_DATA__MSI_DATA__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF1_0_MSI_MSG_DATA__MSI_DATA_MASK                                                       0x0000FFFFL
//BIF_CFG_DEV0_EPF1_0_MSI_MASK
#define BIF_CFG_DEV0_EPF1_0_MSI_MASK__MSI_MASK__SHIFT                                                         0x0
#define BIF_CFG_DEV0_EPF1_0_MSI_MASK__MSI_MASK_MASK                                                           0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_MSI_MSG_DATA_64
#define BIF_CFG_DEV0_EPF1_0_MSI_MSG_DATA_64__MSI_DATA_64__SHIFT                                               0x0
#define BIF_CFG_DEV0_EPF1_0_MSI_MSG_DATA_64__MSI_DATA_64_MASK                                                 0x0000FFFFL
//BIF_CFG_DEV0_EPF1_0_MSI_MASK_64
#define BIF_CFG_DEV0_EPF1_0_MSI_MASK_64__MSI_MASK_64__SHIFT                                                   0x0
#define BIF_CFG_DEV0_EPF1_0_MSI_MASK_64__MSI_MASK_64_MASK                                                     0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_MSI_PENDING
#define BIF_CFG_DEV0_EPF1_0_MSI_PENDING__MSI_PENDING__SHIFT                                                   0x0
#define BIF_CFG_DEV0_EPF1_0_MSI_PENDING__MSI_PENDING_MASK                                                     0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_MSI_PENDING_64
#define BIF_CFG_DEV0_EPF1_0_MSI_PENDING_64__MSI_PENDING_64__SHIFT                                             0x0
#define BIF_CFG_DEV0_EPF1_0_MSI_PENDING_64__MSI_PENDING_64_MASK                                               0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_MSIX_CAP_LIST
#define BIF_CFG_DEV0_EPF1_0_MSIX_CAP_LIST__CAP_ID__SHIFT                                                      0x0
#define BIF_CFG_DEV0_EPF1_0_MSIX_CAP_LIST__NEXT_PTR__SHIFT                                                    0x8
#define BIF_CFG_DEV0_EPF1_0_MSIX_CAP_LIST__CAP_ID_MASK                                                        0x00FFL
#define BIF_CFG_DEV0_EPF1_0_MSIX_CAP_LIST__NEXT_PTR_MASK                                                      0xFF00L
//BIF_CFG_DEV0_EPF1_0_MSIX_MSG_CNTL
#define BIF_CFG_DEV0_EPF1_0_MSIX_MSG_CNTL__MSIX_TABLE_SIZE__SHIFT                                             0x0
#define BIF_CFG_DEV0_EPF1_0_MSIX_MSG_CNTL__MSIX_FUNC_MASK__SHIFT                                              0xe
#define BIF_CFG_DEV0_EPF1_0_MSIX_MSG_CNTL__MSIX_EN__SHIFT                                                     0xf
#define BIF_CFG_DEV0_EPF1_0_MSIX_MSG_CNTL__MSIX_TABLE_SIZE_MASK                                               0x07FFL
#define BIF_CFG_DEV0_EPF1_0_MSIX_MSG_CNTL__MSIX_FUNC_MASK_MASK                                                0x4000L
#define BIF_CFG_DEV0_EPF1_0_MSIX_MSG_CNTL__MSIX_EN_MASK                                                       0x8000L
//BIF_CFG_DEV0_EPF1_0_MSIX_TABLE
#define BIF_CFG_DEV0_EPF1_0_MSIX_TABLE__MSIX_TABLE_BIR__SHIFT                                                 0x0
#define BIF_CFG_DEV0_EPF1_0_MSIX_TABLE__MSIX_TABLE_OFFSET__SHIFT                                              0x3
#define BIF_CFG_DEV0_EPF1_0_MSIX_TABLE__MSIX_TABLE_BIR_MASK                                                   0x00000007L
#define BIF_CFG_DEV0_EPF1_0_MSIX_TABLE__MSIX_TABLE_OFFSET_MASK                                                0xFFFFFFF8L
//BIF_CFG_DEV0_EPF1_0_MSIX_PBA
#define BIF_CFG_DEV0_EPF1_0_MSIX_PBA__MSIX_PBA_BIR__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF1_0_MSIX_PBA__MSIX_PBA_OFFSET__SHIFT                                                  0x3
#define BIF_CFG_DEV0_EPF1_0_MSIX_PBA__MSIX_PBA_BIR_MASK                                                       0x00000007L
#define BIF_CFG_DEV0_EPF1_0_MSIX_PBA__MSIX_PBA_OFFSET_MASK                                                    0xFFFFFFF8L
//BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_ID__SHIFT                                  0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_VER__SHIFT                                 0x10
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__NEXT_PTR__SHIFT                                0x14
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_ID_MASK                                    0x0000FFFFL
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_VER_MASK                                   0x000F0000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__NEXT_PTR_MASK                                  0xFFF00000L
//BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR__VSEC_ID__SHIFT                                          0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR__VSEC_REV__SHIFT                                         0x10
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR__VSEC_LENGTH__SHIFT                                      0x14
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR__VSEC_ID_MASK                                            0x0000FFFFL
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR__VSEC_REV_MASK                                           0x000F0000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR__VSEC_LENGTH_MASK                                        0xFFF00000L
//BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC1
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC1__SCRATCH__SHIFT                                             0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC1__SCRATCH_MASK                                               0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC2
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC2__SCRATCH__SHIFT                                             0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC2__SCRATCH_MASK                                               0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_VC_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF1_0_PCIE_VC_ENH_CAP_LIST__CAP_ID__SHIFT                                               0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VC_ENH_CAP_LIST__CAP_VER__SHIFT                                              0x10
#define BIF_CFG_DEV0_EPF1_0_PCIE_VC_ENH_CAP_LIST__NEXT_PTR__SHIFT                                             0x14
#define BIF_CFG_DEV0_EPF1_0_PCIE_VC_ENH_CAP_LIST__CAP_ID_MASK                                                 0x0000FFFFL
#define BIF_CFG_DEV0_EPF1_0_PCIE_VC_ENH_CAP_LIST__CAP_VER_MASK                                                0x000F0000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VC_ENH_CAP_LIST__NEXT_PTR_MASK                                               0xFFF00000L
//BIF_CFG_DEV0_EPF1_0_PCIE_PORT_VC_CAP_REG1
#define BIF_CFG_DEV0_EPF1_0_PCIE_PORT_VC_CAP_REG1__EXT_VC_COUNT__SHIFT                                        0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_PORT_VC_CAP_REG1__LOW_PRIORITY_EXT_VC_COUNT__SHIFT                           0x4
#define BIF_CFG_DEV0_EPF1_0_PCIE_PORT_VC_CAP_REG1__REF_CLK__SHIFT                                             0x8
#define BIF_CFG_DEV0_EPF1_0_PCIE_PORT_VC_CAP_REG1__PORT_ARB_TABLE_ENTRY_SIZE__SHIFT                           0xa
#define BIF_CFG_DEV0_EPF1_0_PCIE_PORT_VC_CAP_REG1__EXT_VC_COUNT_MASK                                          0x00000007L
#define BIF_CFG_DEV0_EPF1_0_PCIE_PORT_VC_CAP_REG1__LOW_PRIORITY_EXT_VC_COUNT_MASK                             0x00000070L
#define BIF_CFG_DEV0_EPF1_0_PCIE_PORT_VC_CAP_REG1__REF_CLK_MASK                                               0x00000300L
#define BIF_CFG_DEV0_EPF1_0_PCIE_PORT_VC_CAP_REG1__PORT_ARB_TABLE_ENTRY_SIZE_MASK                             0x00000C00L
//BIF_CFG_DEV0_EPF1_0_PCIE_PORT_VC_CAP_REG2
#define BIF_CFG_DEV0_EPF1_0_PCIE_PORT_VC_CAP_REG2__VC_ARB_CAP__SHIFT                                          0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_PORT_VC_CAP_REG2__VC_ARB_TABLE_OFFSET__SHIFT                                 0x18
#define BIF_CFG_DEV0_EPF1_0_PCIE_PORT_VC_CAP_REG2__VC_ARB_CAP_MASK                                            0x000000FFL
#define BIF_CFG_DEV0_EPF1_0_PCIE_PORT_VC_CAP_REG2__VC_ARB_TABLE_OFFSET_MASK                                   0xFF000000L
//BIF_CFG_DEV0_EPF1_0_PCIE_PORT_VC_CNTL
#define BIF_CFG_DEV0_EPF1_0_PCIE_PORT_VC_CNTL__LOAD_VC_ARB_TABLE__SHIFT                                       0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_PORT_VC_CNTL__VC_ARB_SELECT__SHIFT                                           0x1
#define BIF_CFG_DEV0_EPF1_0_PCIE_PORT_VC_CNTL__LOAD_VC_ARB_TABLE_MASK                                         0x0001L
#define BIF_CFG_DEV0_EPF1_0_PCIE_PORT_VC_CNTL__VC_ARB_SELECT_MASK                                             0x000EL
//BIF_CFG_DEV0_EPF1_0_PCIE_PORT_VC_STATUS
#define BIF_CFG_DEV0_EPF1_0_PCIE_PORT_VC_STATUS__VC_ARB_TABLE_STATUS__SHIFT                                   0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_PORT_VC_STATUS__VC_ARB_TABLE_STATUS_MASK                                     0x0001L
//BIF_CFG_DEV0_EPF1_0_PCIE_VC0_RESOURCE_CAP
#define BIF_CFG_DEV0_EPF1_0_PCIE_VC0_RESOURCE_CAP__PORT_ARB_CAP__SHIFT                                        0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VC0_RESOURCE_CAP__REJECT_SNOOP_TRANS__SHIFT                                  0xf
#define BIF_CFG_DEV0_EPF1_0_PCIE_VC0_RESOURCE_CAP__MAX_TIME_SLOTS__SHIFT                                      0x10
#define BIF_CFG_DEV0_EPF1_0_PCIE_VC0_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET__SHIFT                               0x18
#define BIF_CFG_DEV0_EPF1_0_PCIE_VC0_RESOURCE_CAP__PORT_ARB_CAP_MASK                                          0x000000FFL
#define BIF_CFG_DEV0_EPF1_0_PCIE_VC0_RESOURCE_CAP__REJECT_SNOOP_TRANS_MASK                                    0x00008000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VC0_RESOURCE_CAP__MAX_TIME_SLOTS_MASK                                        0x003F0000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VC0_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET_MASK                                 0xFF000000L
//BIF_CFG_DEV0_EPF1_0_PCIE_VC0_RESOURCE_CNTL
#define BIF_CFG_DEV0_EPF1_0_PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC0__SHIFT                                      0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC1_7__SHIFT                                    0x1
#define BIF_CFG_DEV0_EPF1_0_PCIE_VC0_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE__SHIFT                                0x10
#define BIF_CFG_DEV0_EPF1_0_PCIE_VC0_RESOURCE_CNTL__PORT_ARB_SELECT__SHIFT                                    0x11
#define BIF_CFG_DEV0_EPF1_0_PCIE_VC0_RESOURCE_CNTL__VC_ID__SHIFT                                              0x18
#define BIF_CFG_DEV0_EPF1_0_PCIE_VC0_RESOURCE_CNTL__VC_ENABLE__SHIFT                                          0x1f
#define BIF_CFG_DEV0_EPF1_0_PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC0_MASK                                        0x00000001L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VC0_RESOURCE_CNTL__TC_VC_MAP_TC1_7_MASK                                      0x000000FEL
#define BIF_CFG_DEV0_EPF1_0_PCIE_VC0_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE_MASK                                  0x00010000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VC0_RESOURCE_CNTL__PORT_ARB_SELECT_MASK                                      0x000E0000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VC0_RESOURCE_CNTL__VC_ID_MASK                                                0x07000000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VC0_RESOURCE_CNTL__VC_ENABLE_MASK                                            0x80000000L
//BIF_CFG_DEV0_EPF1_0_PCIE_VC0_RESOURCE_STATUS
#define BIF_CFG_DEV0_EPF1_0_PCIE_VC0_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS__SHIFT                            0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VC0_RESOURCE_STATUS__VC_NEGOTIATION_PENDING__SHIFT                           0x1
#define BIF_CFG_DEV0_EPF1_0_PCIE_VC0_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS_MASK                              0x0001L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VC0_RESOURCE_STATUS__VC_NEGOTIATION_PENDING_MASK                             0x0002L
//BIF_CFG_DEV0_EPF1_0_PCIE_VC1_RESOURCE_CAP
#define BIF_CFG_DEV0_EPF1_0_PCIE_VC1_RESOURCE_CAP__PORT_ARB_CAP__SHIFT                                        0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VC1_RESOURCE_CAP__REJECT_SNOOP_TRANS__SHIFT                                  0xf
#define BIF_CFG_DEV0_EPF1_0_PCIE_VC1_RESOURCE_CAP__MAX_TIME_SLOTS__SHIFT                                      0x10
#define BIF_CFG_DEV0_EPF1_0_PCIE_VC1_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET__SHIFT                               0x18
#define BIF_CFG_DEV0_EPF1_0_PCIE_VC1_RESOURCE_CAP__PORT_ARB_CAP_MASK                                          0x000000FFL
#define BIF_CFG_DEV0_EPF1_0_PCIE_VC1_RESOURCE_CAP__REJECT_SNOOP_TRANS_MASK                                    0x00008000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VC1_RESOURCE_CAP__MAX_TIME_SLOTS_MASK                                        0x003F0000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VC1_RESOURCE_CAP__PORT_ARB_TABLE_OFFSET_MASK                                 0xFF000000L
//BIF_CFG_DEV0_EPF1_0_PCIE_VC1_RESOURCE_CNTL
#define BIF_CFG_DEV0_EPF1_0_PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC0__SHIFT                                      0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC1_7__SHIFT                                    0x1
#define BIF_CFG_DEV0_EPF1_0_PCIE_VC1_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE__SHIFT                                0x10
#define BIF_CFG_DEV0_EPF1_0_PCIE_VC1_RESOURCE_CNTL__PORT_ARB_SELECT__SHIFT                                    0x11
#define BIF_CFG_DEV0_EPF1_0_PCIE_VC1_RESOURCE_CNTL__VC_ID__SHIFT                                              0x18
#define BIF_CFG_DEV0_EPF1_0_PCIE_VC1_RESOURCE_CNTL__VC_ENABLE__SHIFT                                          0x1f
#define BIF_CFG_DEV0_EPF1_0_PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC0_MASK                                        0x00000001L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VC1_RESOURCE_CNTL__TC_VC_MAP_TC1_7_MASK                                      0x000000FEL
#define BIF_CFG_DEV0_EPF1_0_PCIE_VC1_RESOURCE_CNTL__LOAD_PORT_ARB_TABLE_MASK                                  0x00010000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VC1_RESOURCE_CNTL__PORT_ARB_SELECT_MASK                                      0x000E0000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VC1_RESOURCE_CNTL__VC_ID_MASK                                                0x07000000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VC1_RESOURCE_CNTL__VC_ENABLE_MASK                                            0x80000000L
//BIF_CFG_DEV0_EPF1_0_PCIE_VC1_RESOURCE_STATUS
#define BIF_CFG_DEV0_EPF1_0_PCIE_VC1_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS__SHIFT                            0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VC1_RESOURCE_STATUS__VC_NEGOTIATION_PENDING__SHIFT                           0x1
#define BIF_CFG_DEV0_EPF1_0_PCIE_VC1_RESOURCE_STATUS__PORT_ARB_TABLE_STATUS_MASK                              0x0001L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VC1_RESOURCE_STATUS__VC_NEGOTIATION_PENDING_MASK                             0x0002L
//BIF_CFG_DEV0_EPF1_0_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF1_0_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_ID__SHIFT                                   0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_VER__SHIFT                                  0x10
#define BIF_CFG_DEV0_EPF1_0_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__NEXT_PTR__SHIFT                                 0x14
#define BIF_CFG_DEV0_EPF1_0_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_ID_MASK                                     0x0000FFFFL
#define BIF_CFG_DEV0_EPF1_0_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__CAP_VER_MASK                                    0x000F0000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_DEV_SERIAL_NUM_ENH_CAP_LIST__NEXT_PTR_MASK                                   0xFFF00000L
//BIF_CFG_DEV0_EPF1_0_PCIE_DEV_SERIAL_NUM_DW1
#define BIF_CFG_DEV0_EPF1_0_PCIE_DEV_SERIAL_NUM_DW1__SERIAL_NUMBER_LO__SHIFT                                  0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_DEV_SERIAL_NUM_DW1__SERIAL_NUMBER_LO_MASK                                    0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_DEV_SERIAL_NUM_DW2
#define BIF_CFG_DEV0_EPF1_0_PCIE_DEV_SERIAL_NUM_DW2__SERIAL_NUMBER_HI__SHIFT                                  0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_DEV_SERIAL_NUM_DW2__SERIAL_NUMBER_HI_MASK                                    0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF1_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_ID__SHIFT                                      0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_VER__SHIFT                                     0x10
#define BIF_CFG_DEV0_EPF1_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__NEXT_PTR__SHIFT                                    0x14
#define BIF_CFG_DEV0_EPF1_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_ID_MASK                                        0x0000FFFFL
#define BIF_CFG_DEV0_EPF1_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_VER_MASK                                       0x000F0000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__NEXT_PTR_MASK                                      0xFFF00000L
//BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_STATUS
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_STATUS__DLP_ERR_STATUS__SHIFT                                     0x4
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_STATUS__SURPDN_ERR_STATUS__SHIFT                                  0x5
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_STATUS__PSN_ERR_STATUS__SHIFT                                     0xc
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_STATUS__FC_ERR_STATUS__SHIFT                                      0xd
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_STATUS__CPL_TIMEOUT_STATUS__SHIFT                                 0xe
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_STATUS__CPL_ABORT_ERR_STATUS__SHIFT                               0xf
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_STATUS__UNEXP_CPL_STATUS__SHIFT                                   0x10
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_STATUS__RCV_OVFL_STATUS__SHIFT                                    0x11
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_STATUS__MAL_TLP_STATUS__SHIFT                                     0x12
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_STATUS__ECRC_ERR_STATUS__SHIFT                                    0x13
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_STATUS__UNSUPP_REQ_ERR_STATUS__SHIFT                              0x14
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_STATUS__ACS_VIOLATION_STATUS__SHIFT                               0x15
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_STATUS__UNCORR_INT_ERR_STATUS__SHIFT                              0x16
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_STATUS__MC_BLOCKED_TLP_STATUS__SHIFT                              0x17
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_STATUS__ATOMICOP_EGRESS_BLOCKED_STATUS__SHIFT                     0x18
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_STATUS__TLP_PREFIX_BLOCKED_ERR_STATUS__SHIFT                      0x19
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_STATUS__DLP_ERR_STATUS_MASK                                       0x00000010L
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_STATUS__SURPDN_ERR_STATUS_MASK                                    0x00000020L
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_STATUS__PSN_ERR_STATUS_MASK                                       0x00001000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_STATUS__FC_ERR_STATUS_MASK                                        0x00002000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_STATUS__CPL_TIMEOUT_STATUS_MASK                                   0x00004000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_STATUS__CPL_ABORT_ERR_STATUS_MASK                                 0x00008000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_STATUS__UNEXP_CPL_STATUS_MASK                                     0x00010000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_STATUS__RCV_OVFL_STATUS_MASK                                      0x00020000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_STATUS__MAL_TLP_STATUS_MASK                                       0x00040000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_STATUS__ECRC_ERR_STATUS_MASK                                      0x00080000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_STATUS__UNSUPP_REQ_ERR_STATUS_MASK                                0x00100000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_STATUS__ACS_VIOLATION_STATUS_MASK                                 0x00200000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_STATUS__UNCORR_INT_ERR_STATUS_MASK                                0x00400000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_STATUS__MC_BLOCKED_TLP_STATUS_MASK                                0x00800000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_STATUS__ATOMICOP_EGRESS_BLOCKED_STATUS_MASK                       0x01000000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_STATUS__TLP_PREFIX_BLOCKED_ERR_STATUS_MASK                        0x02000000L
//BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_MASK
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_MASK__DLP_ERR_MASK__SHIFT                                         0x4
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_MASK__SURPDN_ERR_MASK__SHIFT                                      0x5
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_MASK__PSN_ERR_MASK__SHIFT                                         0xc
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_MASK__FC_ERR_MASK__SHIFT                                          0xd
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_MASK__CPL_TIMEOUT_MASK__SHIFT                                     0xe
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_MASK__CPL_ABORT_ERR_MASK__SHIFT                                   0xf
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_MASK__UNEXP_CPL_MASK__SHIFT                                       0x10
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_MASK__RCV_OVFL_MASK__SHIFT                                        0x11
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_MASK__MAL_TLP_MASK__SHIFT                                         0x12
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_MASK__ECRC_ERR_MASK__SHIFT                                        0x13
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_MASK__UNSUPP_REQ_ERR_MASK__SHIFT                                  0x14
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_MASK__ACS_VIOLATION_MASK__SHIFT                                   0x15
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_MASK__UNCORR_INT_ERR_MASK__SHIFT                                  0x16
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_MASK__MC_BLOCKED_TLP_MASK__SHIFT                                  0x17
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_MASK__ATOMICOP_EGRESS_BLOCKED_MASK__SHIFT                         0x18
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_MASK__TLP_PREFIX_BLOCKED_ERR_MASK__SHIFT                          0x19
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_MASK__DLP_ERR_MASK_MASK                                           0x00000010L
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_MASK__SURPDN_ERR_MASK_MASK                                        0x00000020L
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_MASK__PSN_ERR_MASK_MASK                                           0x00001000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_MASK__FC_ERR_MASK_MASK                                            0x00002000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_MASK__CPL_TIMEOUT_MASK_MASK                                       0x00004000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_MASK__CPL_ABORT_ERR_MASK_MASK                                     0x00008000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_MASK__UNEXP_CPL_MASK_MASK                                         0x00010000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_MASK__RCV_OVFL_MASK_MASK                                          0x00020000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_MASK__MAL_TLP_MASK_MASK                                           0x00040000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_MASK__ECRC_ERR_MASK_MASK                                          0x00080000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_MASK__UNSUPP_REQ_ERR_MASK_MASK                                    0x00100000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_MASK__ACS_VIOLATION_MASK_MASK                                     0x00200000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_MASK__UNCORR_INT_ERR_MASK_MASK                                    0x00400000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_MASK__MC_BLOCKED_TLP_MASK_MASK                                    0x00800000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_MASK__ATOMICOP_EGRESS_BLOCKED_MASK_MASK                           0x01000000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_MASK__TLP_PREFIX_BLOCKED_ERR_MASK_MASK                            0x02000000L
//BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_SEVERITY
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_SEVERITY__DLP_ERR_SEVERITY__SHIFT                                 0x4
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_SEVERITY__SURPDN_ERR_SEVERITY__SHIFT                              0x5
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_SEVERITY__PSN_ERR_SEVERITY__SHIFT                                 0xc
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_SEVERITY__FC_ERR_SEVERITY__SHIFT                                  0xd
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_SEVERITY__CPL_TIMEOUT_SEVERITY__SHIFT                             0xe
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_SEVERITY__CPL_ABORT_ERR_SEVERITY__SHIFT                           0xf
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_SEVERITY__UNEXP_CPL_SEVERITY__SHIFT                               0x10
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_SEVERITY__RCV_OVFL_SEVERITY__SHIFT                                0x11
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_SEVERITY__MAL_TLP_SEVERITY__SHIFT                                 0x12
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_SEVERITY__ECRC_ERR_SEVERITY__SHIFT                                0x13
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_SEVERITY__UNSUPP_REQ_ERR_SEVERITY__SHIFT                          0x14
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_SEVERITY__ACS_VIOLATION_SEVERITY__SHIFT                           0x15
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_SEVERITY__UNCORR_INT_ERR_SEVERITY__SHIFT                          0x16
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_SEVERITY__MC_BLOCKED_TLP_SEVERITY__SHIFT                          0x17
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_SEVERITY__ATOMICOP_EGRESS_BLOCKED_SEVERITY__SHIFT                 0x18
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_SEVERITY__TLP_PREFIX_BLOCKED_ERR_SEVERITY__SHIFT                  0x19
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_SEVERITY__DLP_ERR_SEVERITY_MASK                                   0x00000010L
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_SEVERITY__SURPDN_ERR_SEVERITY_MASK                                0x00000020L
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_SEVERITY__PSN_ERR_SEVERITY_MASK                                   0x00001000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_SEVERITY__FC_ERR_SEVERITY_MASK                                    0x00002000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_SEVERITY__CPL_TIMEOUT_SEVERITY_MASK                               0x00004000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_SEVERITY__CPL_ABORT_ERR_SEVERITY_MASK                             0x00008000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_SEVERITY__UNEXP_CPL_SEVERITY_MASK                                 0x00010000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_SEVERITY__RCV_OVFL_SEVERITY_MASK                                  0x00020000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_SEVERITY__MAL_TLP_SEVERITY_MASK                                   0x00040000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_SEVERITY__ECRC_ERR_SEVERITY_MASK                                  0x00080000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_SEVERITY__UNSUPP_REQ_ERR_SEVERITY_MASK                            0x00100000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_SEVERITY__ACS_VIOLATION_SEVERITY_MASK                             0x00200000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_SEVERITY__UNCORR_INT_ERR_SEVERITY_MASK                            0x00400000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_SEVERITY__MC_BLOCKED_TLP_SEVERITY_MASK                            0x00800000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_SEVERITY__ATOMICOP_EGRESS_BLOCKED_SEVERITY_MASK                   0x01000000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_UNCORR_ERR_SEVERITY__TLP_PREFIX_BLOCKED_ERR_SEVERITY_MASK                    0x02000000L
//BIF_CFG_DEV0_EPF1_0_PCIE_CORR_ERR_STATUS
#define BIF_CFG_DEV0_EPF1_0_PCIE_CORR_ERR_STATUS__RCV_ERR_STATUS__SHIFT                                       0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_CORR_ERR_STATUS__BAD_TLP_STATUS__SHIFT                                       0x6
#define BIF_CFG_DEV0_EPF1_0_PCIE_CORR_ERR_STATUS__BAD_DLLP_STATUS__SHIFT                                      0x7
#define BIF_CFG_DEV0_EPF1_0_PCIE_CORR_ERR_STATUS__REPLAY_NUM_ROLLOVER_STATUS__SHIFT                           0x8
#define BIF_CFG_DEV0_EPF1_0_PCIE_CORR_ERR_STATUS__REPLAY_TIMER_TIMEOUT_STATUS__SHIFT                          0xc
#define BIF_CFG_DEV0_EPF1_0_PCIE_CORR_ERR_STATUS__ADVISORY_NONFATAL_ERR_STATUS__SHIFT                         0xd
#define BIF_CFG_DEV0_EPF1_0_PCIE_CORR_ERR_STATUS__CORR_INT_ERR_STATUS__SHIFT                                  0xe
#define BIF_CFG_DEV0_EPF1_0_PCIE_CORR_ERR_STATUS__HDR_LOG_OVFL_STATUS__SHIFT                                  0xf
#define BIF_CFG_DEV0_EPF1_0_PCIE_CORR_ERR_STATUS__RCV_ERR_STATUS_MASK                                         0x00000001L
#define BIF_CFG_DEV0_EPF1_0_PCIE_CORR_ERR_STATUS__BAD_TLP_STATUS_MASK                                         0x00000040L
#define BIF_CFG_DEV0_EPF1_0_PCIE_CORR_ERR_STATUS__BAD_DLLP_STATUS_MASK                                        0x00000080L
#define BIF_CFG_DEV0_EPF1_0_PCIE_CORR_ERR_STATUS__REPLAY_NUM_ROLLOVER_STATUS_MASK                             0x00000100L
#define BIF_CFG_DEV0_EPF1_0_PCIE_CORR_ERR_STATUS__REPLAY_TIMER_TIMEOUT_STATUS_MASK                            0x00001000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_CORR_ERR_STATUS__ADVISORY_NONFATAL_ERR_STATUS_MASK                           0x00002000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_CORR_ERR_STATUS__CORR_INT_ERR_STATUS_MASK                                    0x00004000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_CORR_ERR_STATUS__HDR_LOG_OVFL_STATUS_MASK                                    0x00008000L
//BIF_CFG_DEV0_EPF1_0_PCIE_CORR_ERR_MASK
#define BIF_CFG_DEV0_EPF1_0_PCIE_CORR_ERR_MASK__RCV_ERR_MASK__SHIFT                                           0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_CORR_ERR_MASK__BAD_TLP_MASK__SHIFT                                           0x6
#define BIF_CFG_DEV0_EPF1_0_PCIE_CORR_ERR_MASK__BAD_DLLP_MASK__SHIFT                                          0x7
#define BIF_CFG_DEV0_EPF1_0_PCIE_CORR_ERR_MASK__REPLAY_NUM_ROLLOVER_MASK__SHIFT                               0x8
#define BIF_CFG_DEV0_EPF1_0_PCIE_CORR_ERR_MASK__REPLAY_TIMER_TIMEOUT_MASK__SHIFT                              0xc
#define BIF_CFG_DEV0_EPF1_0_PCIE_CORR_ERR_MASK__ADVISORY_NONFATAL_ERR_MASK__SHIFT                             0xd
#define BIF_CFG_DEV0_EPF1_0_PCIE_CORR_ERR_MASK__CORR_INT_ERR_MASK__SHIFT                                      0xe
#define BIF_CFG_DEV0_EPF1_0_PCIE_CORR_ERR_MASK__HDR_LOG_OVFL_MASK__SHIFT                                      0xf
#define BIF_CFG_DEV0_EPF1_0_PCIE_CORR_ERR_MASK__RCV_ERR_MASK_MASK                                             0x00000001L
#define BIF_CFG_DEV0_EPF1_0_PCIE_CORR_ERR_MASK__BAD_TLP_MASK_MASK                                             0x00000040L
#define BIF_CFG_DEV0_EPF1_0_PCIE_CORR_ERR_MASK__BAD_DLLP_MASK_MASK                                            0x00000080L
#define BIF_CFG_DEV0_EPF1_0_PCIE_CORR_ERR_MASK__REPLAY_NUM_ROLLOVER_MASK_MASK                                 0x00000100L
#define BIF_CFG_DEV0_EPF1_0_PCIE_CORR_ERR_MASK__REPLAY_TIMER_TIMEOUT_MASK_MASK                                0x00001000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_CORR_ERR_MASK__ADVISORY_NONFATAL_ERR_MASK_MASK                               0x00002000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_CORR_ERR_MASK__CORR_INT_ERR_MASK_MASK                                        0x00004000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_CORR_ERR_MASK__HDR_LOG_OVFL_MASK_MASK                                        0x00008000L
//BIF_CFG_DEV0_EPF1_0_PCIE_ADV_ERR_CAP_CNTL
#define BIF_CFG_DEV0_EPF1_0_PCIE_ADV_ERR_CAP_CNTL__FIRST_ERR_PTR__SHIFT                                       0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_CAP__SHIFT                                        0x5
#define BIF_CFG_DEV0_EPF1_0_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_EN__SHIFT                                         0x6
#define BIF_CFG_DEV0_EPF1_0_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_CAP__SHIFT                                      0x7
#define BIF_CFG_DEV0_EPF1_0_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_EN__SHIFT                                       0x8
#define BIF_CFG_DEV0_EPF1_0_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_CAP__SHIFT                                  0x9
#define BIF_CFG_DEV0_EPF1_0_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_EN__SHIFT                                   0xa
#define BIF_CFG_DEV0_EPF1_0_PCIE_ADV_ERR_CAP_CNTL__TLP_PREFIX_LOG_PRESENT__SHIFT                              0xb
#define BIF_CFG_DEV0_EPF1_0_PCIE_ADV_ERR_CAP_CNTL__FIRST_ERR_PTR_MASK                                         0x0000001FL
#define BIF_CFG_DEV0_EPF1_0_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_CAP_MASK                                          0x00000020L
#define BIF_CFG_DEV0_EPF1_0_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_EN_MASK                                           0x00000040L
#define BIF_CFG_DEV0_EPF1_0_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_CAP_MASK                                        0x00000080L
#define BIF_CFG_DEV0_EPF1_0_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_EN_MASK                                         0x00000100L
#define BIF_CFG_DEV0_EPF1_0_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_CAP_MASK                                    0x00000200L
#define BIF_CFG_DEV0_EPF1_0_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_EN_MASK                                     0x00000400L
#define BIF_CFG_DEV0_EPF1_0_PCIE_ADV_ERR_CAP_CNTL__TLP_PREFIX_LOG_PRESENT_MASK                                0x00000800L
//BIF_CFG_DEV0_EPF1_0_PCIE_HDR_LOG0
#define BIF_CFG_DEV0_EPF1_0_PCIE_HDR_LOG0__TLP_HDR__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_HDR_LOG0__TLP_HDR_MASK                                                       0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_HDR_LOG1
#define BIF_CFG_DEV0_EPF1_0_PCIE_HDR_LOG1__TLP_HDR__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_HDR_LOG1__TLP_HDR_MASK                                                       0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_HDR_LOG2
#define BIF_CFG_DEV0_EPF1_0_PCIE_HDR_LOG2__TLP_HDR__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_HDR_LOG2__TLP_HDR_MASK                                                       0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_HDR_LOG3
#define BIF_CFG_DEV0_EPF1_0_PCIE_HDR_LOG3__TLP_HDR__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_HDR_LOG3__TLP_HDR_MASK                                                       0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_TLP_PREFIX_LOG0
#define BIF_CFG_DEV0_EPF1_0_PCIE_TLP_PREFIX_LOG0__TLP_PREFIX__SHIFT                                           0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_TLP_PREFIX_LOG0__TLP_PREFIX_MASK                                             0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_TLP_PREFIX_LOG1
#define BIF_CFG_DEV0_EPF1_0_PCIE_TLP_PREFIX_LOG1__TLP_PREFIX__SHIFT                                           0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_TLP_PREFIX_LOG1__TLP_PREFIX_MASK                                             0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_TLP_PREFIX_LOG2
#define BIF_CFG_DEV0_EPF1_0_PCIE_TLP_PREFIX_LOG2__TLP_PREFIX__SHIFT                                           0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_TLP_PREFIX_LOG2__TLP_PREFIX_MASK                                             0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_TLP_PREFIX_LOG3
#define BIF_CFG_DEV0_EPF1_0_PCIE_TLP_PREFIX_LOG3__TLP_PREFIX__SHIFT                                           0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_TLP_PREFIX_LOG3__TLP_PREFIX_MASK                                             0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_BAR_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF1_0_PCIE_BAR_ENH_CAP_LIST__CAP_ID__SHIFT                                              0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_BAR_ENH_CAP_LIST__CAP_VER__SHIFT                                             0x10
#define BIF_CFG_DEV0_EPF1_0_PCIE_BAR_ENH_CAP_LIST__NEXT_PTR__SHIFT                                            0x14
#define BIF_CFG_DEV0_EPF1_0_PCIE_BAR_ENH_CAP_LIST__CAP_ID_MASK                                                0x0000FFFFL
#define BIF_CFG_DEV0_EPF1_0_PCIE_BAR_ENH_CAP_LIST__CAP_VER_MASK                                               0x000F0000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_BAR_ENH_CAP_LIST__NEXT_PTR_MASK                                              0xFFF00000L
//BIF_CFG_DEV0_EPF1_0_PCIE_BAR1_CAP
#define BIF_CFG_DEV0_EPF1_0_PCIE_BAR1_CAP__BAR_SIZE_SUPPORTED__SHIFT                                          0x4
#define BIF_CFG_DEV0_EPF1_0_PCIE_BAR1_CAP__BAR_SIZE_SUPPORTED_MASK                                            0x00FFFFF0L
//BIF_CFG_DEV0_EPF1_0_PCIE_BAR1_CNTL
#define BIF_CFG_DEV0_EPF1_0_PCIE_BAR1_CNTL__BAR_INDEX__SHIFT                                                  0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_BAR1_CNTL__BAR_TOTAL_NUM__SHIFT                                              0x5
#define BIF_CFG_DEV0_EPF1_0_PCIE_BAR1_CNTL__BAR_SIZE__SHIFT                                                   0x8
#define BIF_CFG_DEV0_EPF1_0_PCIE_BAR1_CNTL__BAR_INDEX_MASK                                                    0x0007L
#define BIF_CFG_DEV0_EPF1_0_PCIE_BAR1_CNTL__BAR_TOTAL_NUM_MASK                                                0x00E0L
#define BIF_CFG_DEV0_EPF1_0_PCIE_BAR1_CNTL__BAR_SIZE_MASK                                                     0x1F00L
//BIF_CFG_DEV0_EPF1_0_PCIE_BAR2_CAP
#define BIF_CFG_DEV0_EPF1_0_PCIE_BAR2_CAP__BAR_SIZE_SUPPORTED__SHIFT                                          0x4
#define BIF_CFG_DEV0_EPF1_0_PCIE_BAR2_CAP__BAR_SIZE_SUPPORTED_MASK                                            0x00FFFFF0L
//BIF_CFG_DEV0_EPF1_0_PCIE_BAR2_CNTL
#define BIF_CFG_DEV0_EPF1_0_PCIE_BAR2_CNTL__BAR_INDEX__SHIFT                                                  0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_BAR2_CNTL__BAR_TOTAL_NUM__SHIFT                                              0x5
#define BIF_CFG_DEV0_EPF1_0_PCIE_BAR2_CNTL__BAR_SIZE__SHIFT                                                   0x8
#define BIF_CFG_DEV0_EPF1_0_PCIE_BAR2_CNTL__BAR_INDEX_MASK                                                    0x0007L
#define BIF_CFG_DEV0_EPF1_0_PCIE_BAR2_CNTL__BAR_TOTAL_NUM_MASK                                                0x00E0L
#define BIF_CFG_DEV0_EPF1_0_PCIE_BAR2_CNTL__BAR_SIZE_MASK                                                     0x1F00L
//BIF_CFG_DEV0_EPF1_0_PCIE_BAR3_CAP
#define BIF_CFG_DEV0_EPF1_0_PCIE_BAR3_CAP__BAR_SIZE_SUPPORTED__SHIFT                                          0x4
#define BIF_CFG_DEV0_EPF1_0_PCIE_BAR3_CAP__BAR_SIZE_SUPPORTED_MASK                                            0x00FFFFF0L
//BIF_CFG_DEV0_EPF1_0_PCIE_BAR3_CNTL
#define BIF_CFG_DEV0_EPF1_0_PCIE_BAR3_CNTL__BAR_INDEX__SHIFT                                                  0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_BAR3_CNTL__BAR_TOTAL_NUM__SHIFT                                              0x5
#define BIF_CFG_DEV0_EPF1_0_PCIE_BAR3_CNTL__BAR_SIZE__SHIFT                                                   0x8
#define BIF_CFG_DEV0_EPF1_0_PCIE_BAR3_CNTL__BAR_INDEX_MASK                                                    0x0007L
#define BIF_CFG_DEV0_EPF1_0_PCIE_BAR3_CNTL__BAR_TOTAL_NUM_MASK                                                0x00E0L
#define BIF_CFG_DEV0_EPF1_0_PCIE_BAR3_CNTL__BAR_SIZE_MASK                                                     0x1F00L
//BIF_CFG_DEV0_EPF1_0_PCIE_BAR4_CAP
#define BIF_CFG_DEV0_EPF1_0_PCIE_BAR4_CAP__BAR_SIZE_SUPPORTED__SHIFT                                          0x4
#define BIF_CFG_DEV0_EPF1_0_PCIE_BAR4_CAP__BAR_SIZE_SUPPORTED_MASK                                            0x00FFFFF0L
//BIF_CFG_DEV0_EPF1_0_PCIE_BAR4_CNTL
#define BIF_CFG_DEV0_EPF1_0_PCIE_BAR4_CNTL__BAR_INDEX__SHIFT                                                  0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_BAR4_CNTL__BAR_TOTAL_NUM__SHIFT                                              0x5
#define BIF_CFG_DEV0_EPF1_0_PCIE_BAR4_CNTL__BAR_SIZE__SHIFT                                                   0x8
#define BIF_CFG_DEV0_EPF1_0_PCIE_BAR4_CNTL__BAR_INDEX_MASK                                                    0x0007L
#define BIF_CFG_DEV0_EPF1_0_PCIE_BAR4_CNTL__BAR_TOTAL_NUM_MASK                                                0x00E0L
#define BIF_CFG_DEV0_EPF1_0_PCIE_BAR4_CNTL__BAR_SIZE_MASK                                                     0x1F00L
//BIF_CFG_DEV0_EPF1_0_PCIE_BAR5_CAP
#define BIF_CFG_DEV0_EPF1_0_PCIE_BAR5_CAP__BAR_SIZE_SUPPORTED__SHIFT                                          0x4
#define BIF_CFG_DEV0_EPF1_0_PCIE_BAR5_CAP__BAR_SIZE_SUPPORTED_MASK                                            0x00FFFFF0L
//BIF_CFG_DEV0_EPF1_0_PCIE_BAR5_CNTL
#define BIF_CFG_DEV0_EPF1_0_PCIE_BAR5_CNTL__BAR_INDEX__SHIFT                                                  0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_BAR5_CNTL__BAR_TOTAL_NUM__SHIFT                                              0x5
#define BIF_CFG_DEV0_EPF1_0_PCIE_BAR5_CNTL__BAR_SIZE__SHIFT                                                   0x8
#define BIF_CFG_DEV0_EPF1_0_PCIE_BAR5_CNTL__BAR_INDEX_MASK                                                    0x0007L
#define BIF_CFG_DEV0_EPF1_0_PCIE_BAR5_CNTL__BAR_TOTAL_NUM_MASK                                                0x00E0L
#define BIF_CFG_DEV0_EPF1_0_PCIE_BAR5_CNTL__BAR_SIZE_MASK                                                     0x1F00L
//BIF_CFG_DEV0_EPF1_0_PCIE_BAR6_CAP
#define BIF_CFG_DEV0_EPF1_0_PCIE_BAR6_CAP__BAR_SIZE_SUPPORTED__SHIFT                                          0x4
#define BIF_CFG_DEV0_EPF1_0_PCIE_BAR6_CAP__BAR_SIZE_SUPPORTED_MASK                                            0x00FFFFF0L
//BIF_CFG_DEV0_EPF1_0_PCIE_BAR6_CNTL
#define BIF_CFG_DEV0_EPF1_0_PCIE_BAR6_CNTL__BAR_INDEX__SHIFT                                                  0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_BAR6_CNTL__BAR_TOTAL_NUM__SHIFT                                              0x5
#define BIF_CFG_DEV0_EPF1_0_PCIE_BAR6_CNTL__BAR_SIZE__SHIFT                                                   0x8
#define BIF_CFG_DEV0_EPF1_0_PCIE_BAR6_CNTL__BAR_INDEX_MASK                                                    0x0007L
#define BIF_CFG_DEV0_EPF1_0_PCIE_BAR6_CNTL__BAR_TOTAL_NUM_MASK                                                0x00E0L
#define BIF_CFG_DEV0_EPF1_0_PCIE_BAR6_CNTL__BAR_SIZE_MASK                                                     0x1F00L
//BIF_CFG_DEV0_EPF1_0_PCIE_PWR_BUDGET_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF1_0_PCIE_PWR_BUDGET_ENH_CAP_LIST__CAP_ID__SHIFT                                       0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_PWR_BUDGET_ENH_CAP_LIST__CAP_VER__SHIFT                                      0x10
#define BIF_CFG_DEV0_EPF1_0_PCIE_PWR_BUDGET_ENH_CAP_LIST__NEXT_PTR__SHIFT                                     0x14
#define BIF_CFG_DEV0_EPF1_0_PCIE_PWR_BUDGET_ENH_CAP_LIST__CAP_ID_MASK                                         0x0000FFFFL
#define BIF_CFG_DEV0_EPF1_0_PCIE_PWR_BUDGET_ENH_CAP_LIST__CAP_VER_MASK                                        0x000F0000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_PWR_BUDGET_ENH_CAP_LIST__NEXT_PTR_MASK                                       0xFFF00000L
//BIF_CFG_DEV0_EPF1_0_PCIE_PWR_BUDGET_DATA_SELECT
#define BIF_CFG_DEV0_EPF1_0_PCIE_PWR_BUDGET_DATA_SELECT__DATA_SELECT__SHIFT                                   0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_PWR_BUDGET_DATA_SELECT__DATA_SELECT_MASK                                     0xFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_PWR_BUDGET_DATA
#define BIF_CFG_DEV0_EPF1_0_PCIE_PWR_BUDGET_DATA__BASE_POWER__SHIFT                                           0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_PWR_BUDGET_DATA__DATA_SCALE__SHIFT                                           0x8
#define BIF_CFG_DEV0_EPF1_0_PCIE_PWR_BUDGET_DATA__PM_SUB_STATE__SHIFT                                         0xa
#define BIF_CFG_DEV0_EPF1_0_PCIE_PWR_BUDGET_DATA__PM_STATE__SHIFT                                             0xd
#define BIF_CFG_DEV0_EPF1_0_PCIE_PWR_BUDGET_DATA__TYPE__SHIFT                                                 0xf
#define BIF_CFG_DEV0_EPF1_0_PCIE_PWR_BUDGET_DATA__POWER_RAIL__SHIFT                                           0x12
#define BIF_CFG_DEV0_EPF1_0_PCIE_PWR_BUDGET_DATA__BASE_POWER_MASK                                             0x000000FFL
#define BIF_CFG_DEV0_EPF1_0_PCIE_PWR_BUDGET_DATA__DATA_SCALE_MASK                                             0x00000300L
#define BIF_CFG_DEV0_EPF1_0_PCIE_PWR_BUDGET_DATA__PM_SUB_STATE_MASK                                           0x00001C00L
#define BIF_CFG_DEV0_EPF1_0_PCIE_PWR_BUDGET_DATA__PM_STATE_MASK                                               0x00006000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_PWR_BUDGET_DATA__TYPE_MASK                                                   0x00038000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_PWR_BUDGET_DATA__POWER_RAIL_MASK                                             0x001C0000L
//BIF_CFG_DEV0_EPF1_0_PCIE_PWR_BUDGET_CAP
#define BIF_CFG_DEV0_EPF1_0_PCIE_PWR_BUDGET_CAP__SYSTEM_ALLOCATED__SHIFT                                      0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_PWR_BUDGET_CAP__SYSTEM_ALLOCATED_MASK                                        0x01L
//BIF_CFG_DEV0_EPF1_0_PCIE_DPA_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF1_0_PCIE_DPA_ENH_CAP_LIST__CAP_ID__SHIFT                                              0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_DPA_ENH_CAP_LIST__CAP_VER__SHIFT                                             0x10
#define BIF_CFG_DEV0_EPF1_0_PCIE_DPA_ENH_CAP_LIST__NEXT_PTR__SHIFT                                            0x14
#define BIF_CFG_DEV0_EPF1_0_PCIE_DPA_ENH_CAP_LIST__CAP_ID_MASK                                                0x0000FFFFL
#define BIF_CFG_DEV0_EPF1_0_PCIE_DPA_ENH_CAP_LIST__CAP_VER_MASK                                               0x000F0000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_DPA_ENH_CAP_LIST__NEXT_PTR_MASK                                              0xFFF00000L
//BIF_CFG_DEV0_EPF1_0_PCIE_DPA_CAP
#define BIF_CFG_DEV0_EPF1_0_PCIE_DPA_CAP__SUBSTATE_MAX__SHIFT                                                 0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_DPA_CAP__TRANS_LAT_UNIT__SHIFT                                               0x8
#define BIF_CFG_DEV0_EPF1_0_PCIE_DPA_CAP__PWR_ALLOC_SCALE__SHIFT                                              0xc
#define BIF_CFG_DEV0_EPF1_0_PCIE_DPA_CAP__TRANS_LAT_VAL_0__SHIFT                                              0x10
#define BIF_CFG_DEV0_EPF1_0_PCIE_DPA_CAP__TRANS_LAT_VAL_1__SHIFT                                              0x18
#define BIF_CFG_DEV0_EPF1_0_PCIE_DPA_CAP__SUBSTATE_MAX_MASK                                                   0x0000001FL
#define BIF_CFG_DEV0_EPF1_0_PCIE_DPA_CAP__TRANS_LAT_UNIT_MASK                                                 0x00000300L
#define BIF_CFG_DEV0_EPF1_0_PCIE_DPA_CAP__PWR_ALLOC_SCALE_MASK                                                0x00003000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_DPA_CAP__TRANS_LAT_VAL_0_MASK                                                0x00FF0000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_DPA_CAP__TRANS_LAT_VAL_1_MASK                                                0xFF000000L
//BIF_CFG_DEV0_EPF1_0_PCIE_DPA_LATENCY_INDICATOR
#define BIF_CFG_DEV0_EPF1_0_PCIE_DPA_LATENCY_INDICATOR__TRANS_LAT_INDICATOR_BITS__SHIFT                       0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_DPA_LATENCY_INDICATOR__TRANS_LAT_INDICATOR_BITS_MASK                         0xFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_DPA_STATUS
#define BIF_CFG_DEV0_EPF1_0_PCIE_DPA_STATUS__SUBSTATE_STATUS__SHIFT                                           0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_DPA_STATUS__SUBSTATE_CNTL_ENABLED__SHIFT                                     0x8
#define BIF_CFG_DEV0_EPF1_0_PCIE_DPA_STATUS__SUBSTATE_STATUS_MASK                                             0x001FL
#define BIF_CFG_DEV0_EPF1_0_PCIE_DPA_STATUS__SUBSTATE_CNTL_ENABLED_MASK                                       0x0100L
//BIF_CFG_DEV0_EPF1_0_PCIE_DPA_CNTL
#define BIF_CFG_DEV0_EPF1_0_PCIE_DPA_CNTL__SUBSTATE_CNTL__SHIFT                                               0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_DPA_CNTL__SUBSTATE_CNTL_MASK                                                 0x1FL
//BIF_CFG_DEV0_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_0
#define BIF_CFG_DEV0_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_0__SUBSTATE_PWR_ALLOC__SHIFT                          0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_0__SUBSTATE_PWR_ALLOC_MASK                            0xFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_1
#define BIF_CFG_DEV0_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_1__SUBSTATE_PWR_ALLOC__SHIFT                          0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_1__SUBSTATE_PWR_ALLOC_MASK                            0xFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_2
#define BIF_CFG_DEV0_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_2__SUBSTATE_PWR_ALLOC__SHIFT                          0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_2__SUBSTATE_PWR_ALLOC_MASK                            0xFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_3
#define BIF_CFG_DEV0_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_3__SUBSTATE_PWR_ALLOC__SHIFT                          0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_3__SUBSTATE_PWR_ALLOC_MASK                            0xFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_4
#define BIF_CFG_DEV0_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_4__SUBSTATE_PWR_ALLOC__SHIFT                          0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_4__SUBSTATE_PWR_ALLOC_MASK                            0xFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_5
#define BIF_CFG_DEV0_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_5__SUBSTATE_PWR_ALLOC__SHIFT                          0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_5__SUBSTATE_PWR_ALLOC_MASK                            0xFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_6
#define BIF_CFG_DEV0_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_6__SUBSTATE_PWR_ALLOC__SHIFT                          0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_6__SUBSTATE_PWR_ALLOC_MASK                            0xFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_7
#define BIF_CFG_DEV0_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_7__SUBSTATE_PWR_ALLOC__SHIFT                          0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_7__SUBSTATE_PWR_ALLOC_MASK                            0xFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_SECONDARY_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF1_0_PCIE_SECONDARY_ENH_CAP_LIST__CAP_ID__SHIFT                                        0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_SECONDARY_ENH_CAP_LIST__CAP_VER__SHIFT                                       0x10
#define BIF_CFG_DEV0_EPF1_0_PCIE_SECONDARY_ENH_CAP_LIST__NEXT_PTR__SHIFT                                      0x14
#define BIF_CFG_DEV0_EPF1_0_PCIE_SECONDARY_ENH_CAP_LIST__CAP_ID_MASK                                          0x0000FFFFL
#define BIF_CFG_DEV0_EPF1_0_PCIE_SECONDARY_ENH_CAP_LIST__CAP_VER_MASK                                         0x000F0000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_SECONDARY_ENH_CAP_LIST__NEXT_PTR_MASK                                        0xFFF00000L
//BIF_CFG_DEV0_EPF1_0_PCIE_LINK_CNTL3
#define BIF_CFG_DEV0_EPF1_0_PCIE_LINK_CNTL3__PERFORM_EQUALIZATION__SHIFT                                      0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_LINK_CNTL3__LINK_EQUALIZATION_REQ_INT_EN__SHIFT                              0x1
#define BIF_CFG_DEV0_EPF1_0_PCIE_LINK_CNTL3__RESERVED__SHIFT                                                  0x2
#define BIF_CFG_DEV0_EPF1_0_PCIE_LINK_CNTL3__PERFORM_EQUALIZATION_MASK                                        0x00000001L
#define BIF_CFG_DEV0_EPF1_0_PCIE_LINK_CNTL3__LINK_EQUALIZATION_REQ_INT_EN_MASK                                0x00000002L
#define BIF_CFG_DEV0_EPF1_0_PCIE_LINK_CNTL3__RESERVED_MASK                                                    0xFFFFFFFCL
//BIF_CFG_DEV0_EPF1_0_PCIE_LANE_ERROR_STATUS
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_ERROR_STATUS__LANE_ERROR_STATUS_BITS__SHIFT                             0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_ERROR_STATUS__RESERVED__SHIFT                                           0x10
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_ERROR_STATUS__LANE_ERROR_STATUS_BITS_MASK                               0x0000FFFFL
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_ERROR_STATUS__RESERVED_MASK                                             0xFFFF0000L
//BIF_CFG_DEV0_EPF1_0_PCIE_LANE_0_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                   0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT              0x4
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                     0x8
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                0xc
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_0_EQUALIZATION_CNTL__RESERVED__SHIFT                                    0xf
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                     0x000FL
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_0_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                0x0070L
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                       0x0F00L
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_0_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                  0x7000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_0_EQUALIZATION_CNTL__RESERVED_MASK                                      0x8000L
//BIF_CFG_DEV0_EPF1_0_PCIE_LANE_1_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                   0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT              0x4
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                     0x8
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                0xc
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_1_EQUALIZATION_CNTL__RESERVED__SHIFT                                    0xf
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                     0x000FL
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_1_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                0x0070L
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                       0x0F00L
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_1_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                  0x7000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_1_EQUALIZATION_CNTL__RESERVED_MASK                                      0x8000L
//BIF_CFG_DEV0_EPF1_0_PCIE_LANE_2_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                   0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT              0x4
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                     0x8
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                0xc
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_2_EQUALIZATION_CNTL__RESERVED__SHIFT                                    0xf
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                     0x000FL
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_2_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                0x0070L
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                       0x0F00L
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_2_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                  0x7000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_2_EQUALIZATION_CNTL__RESERVED_MASK                                      0x8000L
//BIF_CFG_DEV0_EPF1_0_PCIE_LANE_3_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                   0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT              0x4
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                     0x8
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                0xc
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_3_EQUALIZATION_CNTL__RESERVED__SHIFT                                    0xf
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                     0x000FL
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_3_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                0x0070L
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                       0x0F00L
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_3_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                  0x7000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_3_EQUALIZATION_CNTL__RESERVED_MASK                                      0x8000L
//BIF_CFG_DEV0_EPF1_0_PCIE_LANE_4_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                   0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT              0x4
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                     0x8
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                0xc
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_4_EQUALIZATION_CNTL__RESERVED__SHIFT                                    0xf
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                     0x000FL
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_4_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                0x0070L
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                       0x0F00L
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_4_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                  0x7000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_4_EQUALIZATION_CNTL__RESERVED_MASK                                      0x8000L
//BIF_CFG_DEV0_EPF1_0_PCIE_LANE_5_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                   0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT              0x4
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                     0x8
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                0xc
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_5_EQUALIZATION_CNTL__RESERVED__SHIFT                                    0xf
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                     0x000FL
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_5_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                0x0070L
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                       0x0F00L
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_5_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                  0x7000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_5_EQUALIZATION_CNTL__RESERVED_MASK                                      0x8000L
//BIF_CFG_DEV0_EPF1_0_PCIE_LANE_6_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                   0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT              0x4
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                     0x8
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                0xc
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_6_EQUALIZATION_CNTL__RESERVED__SHIFT                                    0xf
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                     0x000FL
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_6_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                0x0070L
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                       0x0F00L
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_6_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                  0x7000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_6_EQUALIZATION_CNTL__RESERVED_MASK                                      0x8000L
//BIF_CFG_DEV0_EPF1_0_PCIE_LANE_7_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                   0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT              0x4
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                     0x8
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                0xc
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_7_EQUALIZATION_CNTL__RESERVED__SHIFT                                    0xf
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                     0x000FL
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_7_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                0x0070L
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                       0x0F00L
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_7_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                  0x7000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_7_EQUALIZATION_CNTL__RESERVED_MASK                                      0x8000L
//BIF_CFG_DEV0_EPF1_0_PCIE_LANE_8_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                   0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT              0x4
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                     0x8
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                0xc
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_8_EQUALIZATION_CNTL__RESERVED__SHIFT                                    0xf
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                     0x000FL
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_8_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                0x0070L
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                       0x0F00L
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_8_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                  0x7000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_8_EQUALIZATION_CNTL__RESERVED_MASK                                      0x8000L
//BIF_CFG_DEV0_EPF1_0_PCIE_LANE_9_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                   0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT              0x4
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                     0x8
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT                0xc
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_9_EQUALIZATION_CNTL__RESERVED__SHIFT                                    0xf
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                     0x000FL
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_9_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK                0x0070L
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                       0x0F00L
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_9_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                  0x7000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_9_EQUALIZATION_CNTL__RESERVED_MASK                                      0x8000L
//BIF_CFG_DEV0_EPF1_0_PCIE_LANE_10_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                  0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT             0x4
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                    0x8
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT               0xc
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_10_EQUALIZATION_CNTL__RESERVED__SHIFT                                   0xf
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                    0x000FL
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_10_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK               0x0070L
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                      0x0F00L
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_10_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                 0x7000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_10_EQUALIZATION_CNTL__RESERVED_MASK                                     0x8000L
//BIF_CFG_DEV0_EPF1_0_PCIE_LANE_11_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                  0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT             0x4
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                    0x8
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT               0xc
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_11_EQUALIZATION_CNTL__RESERVED__SHIFT                                   0xf
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                    0x000FL
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_11_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK               0x0070L
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                      0x0F00L
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_11_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                 0x7000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_11_EQUALIZATION_CNTL__RESERVED_MASK                                     0x8000L
//BIF_CFG_DEV0_EPF1_0_PCIE_LANE_12_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                  0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT             0x4
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                    0x8
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT               0xc
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_12_EQUALIZATION_CNTL__RESERVED__SHIFT                                   0xf
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                    0x000FL
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_12_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK               0x0070L
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                      0x0F00L
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_12_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                 0x7000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_12_EQUALIZATION_CNTL__RESERVED_MASK                                     0x8000L
//BIF_CFG_DEV0_EPF1_0_PCIE_LANE_13_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                  0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT             0x4
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                    0x8
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT               0xc
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_13_EQUALIZATION_CNTL__RESERVED__SHIFT                                   0xf
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                    0x000FL
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_13_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK               0x0070L
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                      0x0F00L
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_13_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                 0x7000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_13_EQUALIZATION_CNTL__RESERVED_MASK                                     0x8000L
//BIF_CFG_DEV0_EPF1_0_PCIE_LANE_14_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                  0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT             0x4
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                    0x8
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT               0xc
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_14_EQUALIZATION_CNTL__RESERVED__SHIFT                                   0xf
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                    0x000FL
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_14_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK               0x0070L
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                      0x0F00L
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_14_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                 0x7000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_14_EQUALIZATION_CNTL__RESERVED_MASK                                     0x8000L
//BIF_CFG_DEV0_EPF1_0_PCIE_LANE_15_EQUALIZATION_CNTL
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET__SHIFT                  0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT__SHIFT             0x4
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET__SHIFT                    0x8
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT__SHIFT               0xc
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_15_EQUALIZATION_CNTL__RESERVED__SHIFT                                   0xf
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_TX_PRESET_MASK                    0x000FL
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_15_EQUALIZATION_CNTL__DOWNSTREAM_PORT_RX_PRESET_HINT_MASK               0x0070L
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_TX_PRESET_MASK                      0x0F00L
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_15_EQUALIZATION_CNTL__UPSTREAM_PORT_RX_PRESET_HINT_MASK                 0x7000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_LANE_15_EQUALIZATION_CNTL__RESERVED_MASK                                     0x8000L
//BIF_CFG_DEV0_EPF1_0_PCIE_ACS_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF1_0_PCIE_ACS_ENH_CAP_LIST__CAP_ID__SHIFT                                              0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_ACS_ENH_CAP_LIST__CAP_VER__SHIFT                                             0x10
#define BIF_CFG_DEV0_EPF1_0_PCIE_ACS_ENH_CAP_LIST__NEXT_PTR__SHIFT                                            0x14
#define BIF_CFG_DEV0_EPF1_0_PCIE_ACS_ENH_CAP_LIST__CAP_ID_MASK                                                0x0000FFFFL
#define BIF_CFG_DEV0_EPF1_0_PCIE_ACS_ENH_CAP_LIST__CAP_VER_MASK                                               0x000F0000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_ACS_ENH_CAP_LIST__NEXT_PTR_MASK                                              0xFFF00000L
//BIF_CFG_DEV0_EPF1_0_PCIE_ACS_CAP
#define BIF_CFG_DEV0_EPF1_0_PCIE_ACS_CAP__SOURCE_VALIDATION__SHIFT                                            0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_ACS_CAP__TRANSLATION_BLOCKING__SHIFT                                         0x1
#define BIF_CFG_DEV0_EPF1_0_PCIE_ACS_CAP__P2P_REQUEST_REDIRECT__SHIFT                                         0x2
#define BIF_CFG_DEV0_EPF1_0_PCIE_ACS_CAP__P2P_COMPLETION_REDIRECT__SHIFT                                      0x3
#define BIF_CFG_DEV0_EPF1_0_PCIE_ACS_CAP__UPSTREAM_FORWARDING__SHIFT                                          0x4
#define BIF_CFG_DEV0_EPF1_0_PCIE_ACS_CAP__P2P_EGRESS_CONTROL__SHIFT                                           0x5
#define BIF_CFG_DEV0_EPF1_0_PCIE_ACS_CAP__DIRECT_TRANSLATED_P2P__SHIFT                                        0x6
#define BIF_CFG_DEV0_EPF1_0_PCIE_ACS_CAP__EGRESS_CONTROL_VECTOR_SIZE__SHIFT                                   0x8
#define BIF_CFG_DEV0_EPF1_0_PCIE_ACS_CAP__SOURCE_VALIDATION_MASK                                              0x0001L
#define BIF_CFG_DEV0_EPF1_0_PCIE_ACS_CAP__TRANSLATION_BLOCKING_MASK                                           0x0002L
#define BIF_CFG_DEV0_EPF1_0_PCIE_ACS_CAP__P2P_REQUEST_REDIRECT_MASK                                           0x0004L
#define BIF_CFG_DEV0_EPF1_0_PCIE_ACS_CAP__P2P_COMPLETION_REDIRECT_MASK                                        0x0008L
#define BIF_CFG_DEV0_EPF1_0_PCIE_ACS_CAP__UPSTREAM_FORWARDING_MASK                                            0x0010L
#define BIF_CFG_DEV0_EPF1_0_PCIE_ACS_CAP__P2P_EGRESS_CONTROL_MASK                                             0x0020L
#define BIF_CFG_DEV0_EPF1_0_PCIE_ACS_CAP__DIRECT_TRANSLATED_P2P_MASK                                          0x0040L
#define BIF_CFG_DEV0_EPF1_0_PCIE_ACS_CAP__EGRESS_CONTROL_VECTOR_SIZE_MASK                                     0xFF00L
//BIF_CFG_DEV0_EPF1_0_PCIE_ACS_CNTL
#define BIF_CFG_DEV0_EPF1_0_PCIE_ACS_CNTL__SOURCE_VALIDATION_EN__SHIFT                                        0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_ACS_CNTL__TRANSLATION_BLOCKING_EN__SHIFT                                     0x1
#define BIF_CFG_DEV0_EPF1_0_PCIE_ACS_CNTL__P2P_REQUEST_REDIRECT_EN__SHIFT                                     0x2
#define BIF_CFG_DEV0_EPF1_0_PCIE_ACS_CNTL__P2P_COMPLETION_REDIRECT_EN__SHIFT                                  0x3
#define BIF_CFG_DEV0_EPF1_0_PCIE_ACS_CNTL__UPSTREAM_FORWARDING_EN__SHIFT                                      0x4
#define BIF_CFG_DEV0_EPF1_0_PCIE_ACS_CNTL__P2P_EGRESS_CONTROL_EN__SHIFT                                       0x5
#define BIF_CFG_DEV0_EPF1_0_PCIE_ACS_CNTL__DIRECT_TRANSLATED_P2P_EN__SHIFT                                    0x6
#define BIF_CFG_DEV0_EPF1_0_PCIE_ACS_CNTL__SOURCE_VALIDATION_EN_MASK                                          0x0001L
#define BIF_CFG_DEV0_EPF1_0_PCIE_ACS_CNTL__TRANSLATION_BLOCKING_EN_MASK                                       0x0002L
#define BIF_CFG_DEV0_EPF1_0_PCIE_ACS_CNTL__P2P_REQUEST_REDIRECT_EN_MASK                                       0x0004L
#define BIF_CFG_DEV0_EPF1_0_PCIE_ACS_CNTL__P2P_COMPLETION_REDIRECT_EN_MASK                                    0x0008L
#define BIF_CFG_DEV0_EPF1_0_PCIE_ACS_CNTL__UPSTREAM_FORWARDING_EN_MASK                                        0x0010L
#define BIF_CFG_DEV0_EPF1_0_PCIE_ACS_CNTL__P2P_EGRESS_CONTROL_EN_MASK                                         0x0020L
#define BIF_CFG_DEV0_EPF1_0_PCIE_ACS_CNTL__DIRECT_TRANSLATED_P2P_EN_MASK                                      0x0040L
//BIF_CFG_DEV0_EPF1_0_PCIE_ATS_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF1_0_PCIE_ATS_ENH_CAP_LIST__CAP_ID__SHIFT                                              0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_ATS_ENH_CAP_LIST__CAP_VER__SHIFT                                             0x10
#define BIF_CFG_DEV0_EPF1_0_PCIE_ATS_ENH_CAP_LIST__NEXT_PTR__SHIFT                                            0x14
#define BIF_CFG_DEV0_EPF1_0_PCIE_ATS_ENH_CAP_LIST__CAP_ID_MASK                                                0x0000FFFFL
#define BIF_CFG_DEV0_EPF1_0_PCIE_ATS_ENH_CAP_LIST__CAP_VER_MASK                                               0x000F0000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_ATS_ENH_CAP_LIST__NEXT_PTR_MASK                                              0xFFF00000L
//BIF_CFG_DEV0_EPF1_0_PCIE_ATS_CAP
#define BIF_CFG_DEV0_EPF1_0_PCIE_ATS_CAP__INVALIDATE_Q_DEPTH__SHIFT                                           0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_ATS_CAP__PAGE_ALIGNED_REQUEST__SHIFT                                         0x5
#define BIF_CFG_DEV0_EPF1_0_PCIE_ATS_CAP__GLOBAL_INVALIDATE_SUPPORTED__SHIFT                                  0x6
#define BIF_CFG_DEV0_EPF1_0_PCIE_ATS_CAP__INVALIDATE_Q_DEPTH_MASK                                             0x001FL
#define BIF_CFG_DEV0_EPF1_0_PCIE_ATS_CAP__PAGE_ALIGNED_REQUEST_MASK                                           0x0020L
#define BIF_CFG_DEV0_EPF1_0_PCIE_ATS_CAP__GLOBAL_INVALIDATE_SUPPORTED_MASK                                    0x0040L
//BIF_CFG_DEV0_EPF1_0_PCIE_ATS_CNTL
#define BIF_CFG_DEV0_EPF1_0_PCIE_ATS_CNTL__STU__SHIFT                                                         0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_ATS_CNTL__ATC_ENABLE__SHIFT                                                  0xf
#define BIF_CFG_DEV0_EPF1_0_PCIE_ATS_CNTL__STU_MASK                                                           0x001FL
#define BIF_CFG_DEV0_EPF1_0_PCIE_ATS_CNTL__ATC_ENABLE_MASK                                                    0x8000L
//BIF_CFG_DEV0_EPF1_0_PCIE_PAGE_REQ_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF1_0_PCIE_PAGE_REQ_ENH_CAP_LIST__CAP_ID__SHIFT                                         0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_PAGE_REQ_ENH_CAP_LIST__CAP_VER__SHIFT                                        0x10
#define BIF_CFG_DEV0_EPF1_0_PCIE_PAGE_REQ_ENH_CAP_LIST__NEXT_PTR__SHIFT                                       0x14
#define BIF_CFG_DEV0_EPF1_0_PCIE_PAGE_REQ_ENH_CAP_LIST__CAP_ID_MASK                                           0x0000FFFFL
#define BIF_CFG_DEV0_EPF1_0_PCIE_PAGE_REQ_ENH_CAP_LIST__CAP_VER_MASK                                          0x000F0000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_PAGE_REQ_ENH_CAP_LIST__NEXT_PTR_MASK                                         0xFFF00000L
//BIF_CFG_DEV0_EPF1_0_PCIE_PAGE_REQ_CNTL
#define BIF_CFG_DEV0_EPF1_0_PCIE_PAGE_REQ_CNTL__PRI_ENABLE__SHIFT                                             0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_PAGE_REQ_CNTL__PRI_RESET__SHIFT                                              0x1
#define BIF_CFG_DEV0_EPF1_0_PCIE_PAGE_REQ_CNTL__PRI_ENABLE_MASK                                               0x0001L
#define BIF_CFG_DEV0_EPF1_0_PCIE_PAGE_REQ_CNTL__PRI_RESET_MASK                                                0x0002L
//BIF_CFG_DEV0_EPF1_0_PCIE_PAGE_REQ_STATUS
#define BIF_CFG_DEV0_EPF1_0_PCIE_PAGE_REQ_STATUS__RESPONSE_FAILURE__SHIFT                                     0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_PAGE_REQ_STATUS__UNEXPECTED_PAGE_REQ_GRP_INDEX__SHIFT                        0x1
#define BIF_CFG_DEV0_EPF1_0_PCIE_PAGE_REQ_STATUS__STOPPED__SHIFT                                              0x8
#define BIF_CFG_DEV0_EPF1_0_PCIE_PAGE_REQ_STATUS__PRG_RESPONSE_PASID_REQUIRED__SHIFT                          0xf
#define BIF_CFG_DEV0_EPF1_0_PCIE_PAGE_REQ_STATUS__RESPONSE_FAILURE_MASK                                       0x0001L
#define BIF_CFG_DEV0_EPF1_0_PCIE_PAGE_REQ_STATUS__UNEXPECTED_PAGE_REQ_GRP_INDEX_MASK                          0x0002L
#define BIF_CFG_DEV0_EPF1_0_PCIE_PAGE_REQ_STATUS__STOPPED_MASK                                                0x0100L
#define BIF_CFG_DEV0_EPF1_0_PCIE_PAGE_REQ_STATUS__PRG_RESPONSE_PASID_REQUIRED_MASK                            0x8000L
//BIF_CFG_DEV0_EPF1_0_PCIE_OUTSTAND_PAGE_REQ_CAPACITY
#define BIF_CFG_DEV0_EPF1_0_PCIE_OUTSTAND_PAGE_REQ_CAPACITY__OUTSTAND_PAGE_REQ_CAPACITY__SHIFT                0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_OUTSTAND_PAGE_REQ_CAPACITY__OUTSTAND_PAGE_REQ_CAPACITY_MASK                  0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_OUTSTAND_PAGE_REQ_ALLOC
#define BIF_CFG_DEV0_EPF1_0_PCIE_OUTSTAND_PAGE_REQ_ALLOC__OUTSTAND_PAGE_REQ_ALLOC__SHIFT                      0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_OUTSTAND_PAGE_REQ_ALLOC__OUTSTAND_PAGE_REQ_ALLOC_MASK                        0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_PASID_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF1_0_PCIE_PASID_ENH_CAP_LIST__CAP_ID__SHIFT                                            0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_PASID_ENH_CAP_LIST__CAP_VER__SHIFT                                           0x10
#define BIF_CFG_DEV0_EPF1_0_PCIE_PASID_ENH_CAP_LIST__NEXT_PTR__SHIFT                                          0x14
#define BIF_CFG_DEV0_EPF1_0_PCIE_PASID_ENH_CAP_LIST__CAP_ID_MASK                                              0x0000FFFFL
#define BIF_CFG_DEV0_EPF1_0_PCIE_PASID_ENH_CAP_LIST__CAP_VER_MASK                                             0x000F0000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_PASID_ENH_CAP_LIST__NEXT_PTR_MASK                                            0xFFF00000L
//BIF_CFG_DEV0_EPF1_0_PCIE_PASID_CAP
#define BIF_CFG_DEV0_EPF1_0_PCIE_PASID_CAP__PASID_EXE_PERMISSION_SUPPORTED__SHIFT                             0x1
#define BIF_CFG_DEV0_EPF1_0_PCIE_PASID_CAP__PASID_PRIV_MODE_SUPPORTED__SHIFT                                  0x2
#define BIF_CFG_DEV0_EPF1_0_PCIE_PASID_CAP__MAX_PASID_WIDTH__SHIFT                                            0x8
#define BIF_CFG_DEV0_EPF1_0_PCIE_PASID_CAP__PASID_EXE_PERMISSION_SUPPORTED_MASK                               0x0002L
#define BIF_CFG_DEV0_EPF1_0_PCIE_PASID_CAP__PASID_PRIV_MODE_SUPPORTED_MASK                                    0x0004L
#define BIF_CFG_DEV0_EPF1_0_PCIE_PASID_CAP__MAX_PASID_WIDTH_MASK                                              0x1F00L
//BIF_CFG_DEV0_EPF1_0_PCIE_PASID_CNTL
#define BIF_CFG_DEV0_EPF1_0_PCIE_PASID_CNTL__PASID_ENABLE__SHIFT                                              0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_PASID_CNTL__PASID_EXE_PERMISSION_ENABLE__SHIFT                               0x1
#define BIF_CFG_DEV0_EPF1_0_PCIE_PASID_CNTL__PASID_PRIV_MODE_SUPPORTED_ENABLE__SHIFT                          0x2
#define BIF_CFG_DEV0_EPF1_0_PCIE_PASID_CNTL__PASID_ENABLE_MASK                                                0x0001L
#define BIF_CFG_DEV0_EPF1_0_PCIE_PASID_CNTL__PASID_EXE_PERMISSION_ENABLE_MASK                                 0x0002L
#define BIF_CFG_DEV0_EPF1_0_PCIE_PASID_CNTL__PASID_PRIV_MODE_SUPPORTED_ENABLE_MASK                            0x0004L
//BIF_CFG_DEV0_EPF1_0_PCIE_TPH_REQR_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF1_0_PCIE_TPH_REQR_ENH_CAP_LIST__CAP_ID__SHIFT                                         0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_TPH_REQR_ENH_CAP_LIST__CAP_VER__SHIFT                                        0x10
#define BIF_CFG_DEV0_EPF1_0_PCIE_TPH_REQR_ENH_CAP_LIST__NEXT_PTR__SHIFT                                       0x14
#define BIF_CFG_DEV0_EPF1_0_PCIE_TPH_REQR_ENH_CAP_LIST__CAP_ID_MASK                                           0x0000FFFFL
#define BIF_CFG_DEV0_EPF1_0_PCIE_TPH_REQR_ENH_CAP_LIST__CAP_VER_MASK                                          0x000F0000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_TPH_REQR_ENH_CAP_LIST__NEXT_PTR_MASK                                         0xFFF00000L
//BIF_CFG_DEV0_EPF1_0_PCIE_TPH_REQR_CAP
#define BIF_CFG_DEV0_EPF1_0_PCIE_TPH_REQR_CAP__TPH_REQR_NO_ST_MODE_SUPPORTED__SHIFT                           0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_TPH_REQR_CAP__TPH_REQR_INT_VEC_MODE_SUPPORTED__SHIFT                         0x1
#define BIF_CFG_DEV0_EPF1_0_PCIE_TPH_REQR_CAP__TPH_REQR_DEV_SPC_MODE_SUPPORTED__SHIFT                         0x2
#define BIF_CFG_DEV0_EPF1_0_PCIE_TPH_REQR_CAP__TPH_REQR_EXTND_TPH_REQR_SUPPORED__SHIFT                        0x8
#define BIF_CFG_DEV0_EPF1_0_PCIE_TPH_REQR_CAP__TPH_REQR_ST_TABLE_LOCATION__SHIFT                              0x9
#define BIF_CFG_DEV0_EPF1_0_PCIE_TPH_REQR_CAP__TPH_REQR_ST_TABLE_SIZE__SHIFT                                  0x10
#define BIF_CFG_DEV0_EPF1_0_PCIE_TPH_REQR_CAP__TPH_REQR_NO_ST_MODE_SUPPORTED_MASK                             0x00000001L
#define BIF_CFG_DEV0_EPF1_0_PCIE_TPH_REQR_CAP__TPH_REQR_INT_VEC_MODE_SUPPORTED_MASK                           0x00000002L
#define BIF_CFG_DEV0_EPF1_0_PCIE_TPH_REQR_CAP__TPH_REQR_DEV_SPC_MODE_SUPPORTED_MASK                           0x00000004L
#define BIF_CFG_DEV0_EPF1_0_PCIE_TPH_REQR_CAP__TPH_REQR_EXTND_TPH_REQR_SUPPORED_MASK                          0x00000100L
#define BIF_CFG_DEV0_EPF1_0_PCIE_TPH_REQR_CAP__TPH_REQR_ST_TABLE_LOCATION_MASK                                0x00000600L
#define BIF_CFG_DEV0_EPF1_0_PCIE_TPH_REQR_CAP__TPH_REQR_ST_TABLE_SIZE_MASK                                    0x07FF0000L
//BIF_CFG_DEV0_EPF1_0_PCIE_TPH_REQR_CNTL
#define BIF_CFG_DEV0_EPF1_0_PCIE_TPH_REQR_CNTL__TPH_REQR_ST_MODE_SEL__SHIFT                                   0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_TPH_REQR_CNTL__TPH_REQR_EN__SHIFT                                            0x8
#define BIF_CFG_DEV0_EPF1_0_PCIE_TPH_REQR_CNTL__TPH_REQR_ST_MODE_SEL_MASK                                     0x00000007L
#define BIF_CFG_DEV0_EPF1_0_PCIE_TPH_REQR_CNTL__TPH_REQR_EN_MASK                                              0x00000300L
//BIF_CFG_DEV0_EPF1_0_PCIE_MC_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF1_0_PCIE_MC_ENH_CAP_LIST__CAP_ID__SHIFT                                               0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_MC_ENH_CAP_LIST__CAP_VER__SHIFT                                              0x10
#define BIF_CFG_DEV0_EPF1_0_PCIE_MC_ENH_CAP_LIST__NEXT_PTR__SHIFT                                             0x14
#define BIF_CFG_DEV0_EPF1_0_PCIE_MC_ENH_CAP_LIST__CAP_ID_MASK                                                 0x0000FFFFL
#define BIF_CFG_DEV0_EPF1_0_PCIE_MC_ENH_CAP_LIST__CAP_VER_MASK                                                0x000F0000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_MC_ENH_CAP_LIST__NEXT_PTR_MASK                                               0xFFF00000L
//BIF_CFG_DEV0_EPF1_0_PCIE_MC_CAP
#define BIF_CFG_DEV0_EPF1_0_PCIE_MC_CAP__MC_MAX_GROUP__SHIFT                                                  0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_MC_CAP__MC_WIN_SIZE_REQ__SHIFT                                               0x8
#define BIF_CFG_DEV0_EPF1_0_PCIE_MC_CAP__MC_ECRC_REGEN_SUPP__SHIFT                                            0xf
#define BIF_CFG_DEV0_EPF1_0_PCIE_MC_CAP__MC_MAX_GROUP_MASK                                                    0x003FL
#define BIF_CFG_DEV0_EPF1_0_PCIE_MC_CAP__MC_WIN_SIZE_REQ_MASK                                                 0x3F00L
#define BIF_CFG_DEV0_EPF1_0_PCIE_MC_CAP__MC_ECRC_REGEN_SUPP_MASK                                              0x8000L
//BIF_CFG_DEV0_EPF1_0_PCIE_MC_CNTL
#define BIF_CFG_DEV0_EPF1_0_PCIE_MC_CNTL__MC_NUM_GROUP__SHIFT                                                 0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_MC_CNTL__MC_ENABLE__SHIFT                                                    0xf
#define BIF_CFG_DEV0_EPF1_0_PCIE_MC_CNTL__MC_NUM_GROUP_MASK                                                   0x003FL
#define BIF_CFG_DEV0_EPF1_0_PCIE_MC_CNTL__MC_ENABLE_MASK                                                      0x8000L
//BIF_CFG_DEV0_EPF1_0_PCIE_MC_ADDR0
#define BIF_CFG_DEV0_EPF1_0_PCIE_MC_ADDR0__MC_INDEX_POS__SHIFT                                                0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_MC_ADDR0__MC_BASE_ADDR_0__SHIFT                                              0xc
#define BIF_CFG_DEV0_EPF1_0_PCIE_MC_ADDR0__MC_INDEX_POS_MASK                                                  0x0000003FL
#define BIF_CFG_DEV0_EPF1_0_PCIE_MC_ADDR0__MC_BASE_ADDR_0_MASK                                                0xFFFFF000L
//BIF_CFG_DEV0_EPF1_0_PCIE_MC_ADDR1
#define BIF_CFG_DEV0_EPF1_0_PCIE_MC_ADDR1__MC_BASE_ADDR_1__SHIFT                                              0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_MC_ADDR1__MC_BASE_ADDR_1_MASK                                                0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_MC_RCV0
#define BIF_CFG_DEV0_EPF1_0_PCIE_MC_RCV0__MC_RECEIVE_0__SHIFT                                                 0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_MC_RCV0__MC_RECEIVE_0_MASK                                                   0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_MC_RCV1
#define BIF_CFG_DEV0_EPF1_0_PCIE_MC_RCV1__MC_RECEIVE_1__SHIFT                                                 0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_MC_RCV1__MC_RECEIVE_1_MASK                                                   0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_MC_BLOCK_ALL0
#define BIF_CFG_DEV0_EPF1_0_PCIE_MC_BLOCK_ALL0__MC_BLOCK_ALL_0__SHIFT                                         0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_MC_BLOCK_ALL0__MC_BLOCK_ALL_0_MASK                                           0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_MC_BLOCK_ALL1
#define BIF_CFG_DEV0_EPF1_0_PCIE_MC_BLOCK_ALL1__MC_BLOCK_ALL_1__SHIFT                                         0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_MC_BLOCK_ALL1__MC_BLOCK_ALL_1_MASK                                           0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_MC_BLOCK_UNTRANSLATED_0
#define BIF_CFG_DEV0_EPF1_0_PCIE_MC_BLOCK_UNTRANSLATED_0__MC_BLOCK_UNTRANSLATED_0__SHIFT                      0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_MC_BLOCK_UNTRANSLATED_0__MC_BLOCK_UNTRANSLATED_0_MASK                        0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_MC_BLOCK_UNTRANSLATED_1
#define BIF_CFG_DEV0_EPF1_0_PCIE_MC_BLOCK_UNTRANSLATED_1__MC_BLOCK_UNTRANSLATED_1__SHIFT                      0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_MC_BLOCK_UNTRANSLATED_1__MC_BLOCK_UNTRANSLATED_1_MASK                        0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_LTR_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF1_0_PCIE_LTR_ENH_CAP_LIST__CAP_ID__SHIFT                                              0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_LTR_ENH_CAP_LIST__CAP_VER__SHIFT                                             0x10
#define BIF_CFG_DEV0_EPF1_0_PCIE_LTR_ENH_CAP_LIST__NEXT_PTR__SHIFT                                            0x14
#define BIF_CFG_DEV0_EPF1_0_PCIE_LTR_ENH_CAP_LIST__CAP_ID_MASK                                                0x0000FFFFL
#define BIF_CFG_DEV0_EPF1_0_PCIE_LTR_ENH_CAP_LIST__CAP_VER_MASK                                               0x000F0000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_LTR_ENH_CAP_LIST__NEXT_PTR_MASK                                              0xFFF00000L
//BIF_CFG_DEV0_EPF1_0_PCIE_LTR_CAP
#define BIF_CFG_DEV0_EPF1_0_PCIE_LTR_CAP__LTR_MAX_S_LATENCY_VALUE__SHIFT                                      0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_LTR_CAP__LTR_MAX_S_LATENCY_SCALE__SHIFT                                      0xa
#define BIF_CFG_DEV0_EPF1_0_PCIE_LTR_CAP__LTR_MAX_NS_LATENCY_VALUE__SHIFT                                     0x10
#define BIF_CFG_DEV0_EPF1_0_PCIE_LTR_CAP__LTR_MAX_NS_LATENCY_SCALE__SHIFT                                     0x1a
#define BIF_CFG_DEV0_EPF1_0_PCIE_LTR_CAP__LTR_MAX_S_LATENCY_VALUE_MASK                                        0x000003FFL
#define BIF_CFG_DEV0_EPF1_0_PCIE_LTR_CAP__LTR_MAX_S_LATENCY_SCALE_MASK                                        0x00001C00L
#define BIF_CFG_DEV0_EPF1_0_PCIE_LTR_CAP__LTR_MAX_NS_LATENCY_VALUE_MASK                                       0x03FF0000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_LTR_CAP__LTR_MAX_NS_LATENCY_SCALE_MASK                                       0x1C000000L
//BIF_CFG_DEV0_EPF1_0_PCIE_ARI_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF1_0_PCIE_ARI_ENH_CAP_LIST__CAP_ID__SHIFT                                              0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_ARI_ENH_CAP_LIST__CAP_VER__SHIFT                                             0x10
#define BIF_CFG_DEV0_EPF1_0_PCIE_ARI_ENH_CAP_LIST__NEXT_PTR__SHIFT                                            0x14
#define BIF_CFG_DEV0_EPF1_0_PCIE_ARI_ENH_CAP_LIST__CAP_ID_MASK                                                0x0000FFFFL
#define BIF_CFG_DEV0_EPF1_0_PCIE_ARI_ENH_CAP_LIST__CAP_VER_MASK                                               0x000F0000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_ARI_ENH_CAP_LIST__NEXT_PTR_MASK                                              0xFFF00000L
//BIF_CFG_DEV0_EPF1_0_PCIE_ARI_CAP
#define BIF_CFG_DEV0_EPF1_0_PCIE_ARI_CAP__ARI_MFVC_FUNC_GROUPS_CAP__SHIFT                                     0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_ARI_CAP__ARI_ACS_FUNC_GROUPS_CAP__SHIFT                                      0x1
#define BIF_CFG_DEV0_EPF1_0_PCIE_ARI_CAP__ARI_NEXT_FUNC_NUM__SHIFT                                            0x8
#define BIF_CFG_DEV0_EPF1_0_PCIE_ARI_CAP__ARI_MFVC_FUNC_GROUPS_CAP_MASK                                       0x0001L
#define BIF_CFG_DEV0_EPF1_0_PCIE_ARI_CAP__ARI_ACS_FUNC_GROUPS_CAP_MASK                                        0x0002L
#define BIF_CFG_DEV0_EPF1_0_PCIE_ARI_CAP__ARI_NEXT_FUNC_NUM_MASK                                              0xFF00L
//BIF_CFG_DEV0_EPF1_0_PCIE_ARI_CNTL
#define BIF_CFG_DEV0_EPF1_0_PCIE_ARI_CNTL__ARI_MFVC_FUNC_GROUPS_EN__SHIFT                                     0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_ARI_CNTL__ARI_ACS_FUNC_GROUPS_EN__SHIFT                                      0x1
#define BIF_CFG_DEV0_EPF1_0_PCIE_ARI_CNTL__ARI_FUNCTION_GROUP__SHIFT                                          0x4
#define BIF_CFG_DEV0_EPF1_0_PCIE_ARI_CNTL__ARI_MFVC_FUNC_GROUPS_EN_MASK                                       0x0001L
#define BIF_CFG_DEV0_EPF1_0_PCIE_ARI_CNTL__ARI_ACS_FUNC_GROUPS_EN_MASK                                        0x0002L
#define BIF_CFG_DEV0_EPF1_0_PCIE_ARI_CNTL__ARI_FUNCTION_GROUP_MASK                                            0x0070L
//BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_ENH_CAP_LIST__CAP_ID__SHIFT                                            0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_ENH_CAP_LIST__CAP_VER__SHIFT                                           0x10
#define BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_ENH_CAP_LIST__NEXT_PTR__SHIFT                                          0x14
#define BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_ENH_CAP_LIST__CAP_ID_MASK                                              0x0000FFFFL
#define BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_ENH_CAP_LIST__CAP_VER_MASK                                             0x000F0000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_ENH_CAP_LIST__NEXT_PTR_MASK                                            0xFFF00000L
//BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_CAP
#define BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_CAP__SRIOV_VF_MIGRATION_CAP__SHIFT                                     0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_CAP__SRIOV_ARI_CAP_HIERARCHY_PRESERVED__SHIFT                          0x1
#define BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_CAP__SRIOV_VF_MIGRATION_INTR_MSG_NUM__SHIFT                            0x15
#define BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_CAP__SRIOV_VF_MIGRATION_CAP_MASK                                       0x00000001L
#define BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_CAP__SRIOV_ARI_CAP_HIERARCHY_PRESERVED_MASK                            0x00000002L
#define BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_CAP__SRIOV_VF_MIGRATION_INTR_MSG_NUM_MASK                              0xFFE00000L
//BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_CONTROL
#define BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_CONTROL__SRIOV_VF_ENABLE__SHIFT                                        0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_CONTROL__SRIOV_VF_MIGRATION_ENABLE__SHIFT                              0x1
#define BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_CONTROL__SRIOV_VF_MIGRATION_INTR_ENABLE__SHIFT                         0x2
#define BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_CONTROL__SRIOV_VF_MSE__SHIFT                                           0x3
#define BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_CONTROL__SRIOV_ARI_CAP_HIERARCHY__SHIFT                                0x4
#define BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_CONTROL__SRIOV_VF_ENABLE_MASK                                          0x0001L
#define BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_CONTROL__SRIOV_VF_MIGRATION_ENABLE_MASK                                0x0002L
#define BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_CONTROL__SRIOV_VF_MIGRATION_INTR_ENABLE_MASK                           0x0004L
#define BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_CONTROL__SRIOV_VF_MSE_MASK                                             0x0008L
#define BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_CONTROL__SRIOV_ARI_CAP_HIERARCHY_MASK                                  0x0010L
//BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_STATUS
#define BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_STATUS__SRIOV_VF_MIGRATION_STATUS__SHIFT                               0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_STATUS__SRIOV_VF_MIGRATION_STATUS_MASK                                 0x0001L
//BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_INITIAL_VFS
#define BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_INITIAL_VFS__SRIOV_INITIAL_VFS__SHIFT                                  0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_INITIAL_VFS__SRIOV_INITIAL_VFS_MASK                                    0xFFFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_TOTAL_VFS
#define BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_TOTAL_VFS__SRIOV_TOTAL_VFS__SHIFT                                      0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_TOTAL_VFS__SRIOV_TOTAL_VFS_MASK                                        0xFFFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_NUM_VFS
#define BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_NUM_VFS__SRIOV_NUM_VFS__SHIFT                                          0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_NUM_VFS__SRIOV_NUM_VFS_MASK                                            0xFFFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_FUNC_DEP_LINK
#define BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_FUNC_DEP_LINK__SRIOV_FUNC_DEP_LINK__SHIFT                              0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_FUNC_DEP_LINK__SRIOV_FUNC_DEP_LINK_MASK                                0x00FFL
//BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_FIRST_VF_OFFSET
#define BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_FIRST_VF_OFFSET__SRIOV_FIRST_VF_OFFSET__SHIFT                          0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_FIRST_VF_OFFSET__SRIOV_FIRST_VF_OFFSET_MASK                            0xFFFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_VF_STRIDE
#define BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_VF_STRIDE__SRIOV_VF_STRIDE__SHIFT                                      0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_VF_STRIDE__SRIOV_VF_STRIDE_MASK                                        0xFFFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_VF_DEVICE_ID
#define BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_VF_DEVICE_ID__SRIOV_VF_DEVICE_ID__SHIFT                                0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_VF_DEVICE_ID__SRIOV_VF_DEVICE_ID_MASK                                  0xFFFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_SUPPORTED_PAGE_SIZE
#define BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_SUPPORTED_PAGE_SIZE__SRIOV_SUPPORTED_PAGE_SIZE__SHIFT                  0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_SUPPORTED_PAGE_SIZE__SRIOV_SUPPORTED_PAGE_SIZE_MASK                    0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_SYSTEM_PAGE_SIZE
#define BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_SYSTEM_PAGE_SIZE__SRIOV_SYSTEM_PAGE_SIZE__SHIFT                        0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_SYSTEM_PAGE_SIZE__SRIOV_SYSTEM_PAGE_SIZE_MASK                          0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_VF_BASE_ADDR_0
#define BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_VF_BASE_ADDR_0__VF_BASE_ADDR__SHIFT                                    0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_VF_BASE_ADDR_0__VF_BASE_ADDR_MASK                                      0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_VF_BASE_ADDR_1
#define BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_VF_BASE_ADDR_1__VF_BASE_ADDR__SHIFT                                    0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_VF_BASE_ADDR_1__VF_BASE_ADDR_MASK                                      0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_VF_BASE_ADDR_2
#define BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_VF_BASE_ADDR_2__VF_BASE_ADDR__SHIFT                                    0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_VF_BASE_ADDR_2__VF_BASE_ADDR_MASK                                      0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_VF_BASE_ADDR_3
#define BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_VF_BASE_ADDR_3__VF_BASE_ADDR__SHIFT                                    0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_VF_BASE_ADDR_3__VF_BASE_ADDR_MASK                                      0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_VF_BASE_ADDR_4
#define BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_VF_BASE_ADDR_4__VF_BASE_ADDR__SHIFT                                    0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_VF_BASE_ADDR_4__VF_BASE_ADDR_MASK                                      0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_VF_BASE_ADDR_5
#define BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_VF_BASE_ADDR_5__VF_BASE_ADDR__SHIFT                                    0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_VF_BASE_ADDR_5__VF_BASE_ADDR_MASK                                      0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_VF_MIGRATION_STATE_ARRAY_OFFSET
#define BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_VF_MIGRATION_STATE_ARRAY_OFFSET__SRIOV_VF_MIGRATION_STATE_BIF__SHIFT   0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_VF_MIGRATION_STATE_ARRAY_OFFSET__SRIOV_VF_MIGRATION_STATE_ARRAY_OFFSET__SHIFT  0x3
#define BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_VF_MIGRATION_STATE_ARRAY_OFFSET__SRIOV_VF_MIGRATION_STATE_BIF_MASK     0x00000007L
#define BIF_CFG_DEV0_EPF1_0_PCIE_SRIOV_VF_MIGRATION_STATE_ARRAY_OFFSET__SRIOV_VF_MIGRATION_STATE_ARRAY_OFFSET_MASK  0xFFFFFFF8L
//BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_GPUIOV
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_GPUIOV__CAP_ID__SHIFT                           0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_GPUIOV__CAP_VER__SHIFT                          0x10
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_GPUIOV__NEXT_PTR__SHIFT                         0x14
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_GPUIOV__CAP_ID_MASK                             0x0000FFFFL
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_GPUIOV__CAP_VER_MASK                            0x000F0000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST_GPUIOV__NEXT_PTR_MASK                           0xFFF00000L
//BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV__VSEC_ID__SHIFT                                   0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV__VSEC_REV__SHIFT                                  0x10
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV__VSEC_LENGTH__SHIFT                               0x14
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV__VSEC_ID_MASK                                     0x0000FFFFL
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV__VSEC_REV_MASK                                    0x000F0000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV__VSEC_LENGTH_MASK                                 0xFFF00000L
//BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_SRIOV_SHADOW
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_SRIOV_SHADOW__VF_EN__SHIFT                        0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_SRIOV_SHADOW__VF_NUM__SHIFT                       0x10
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_SRIOV_SHADOW__VF_EN_MASK                          0x00000001L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_SRIOV_SHADOW__VF_NUM_MASK                         0xFFFF0000L
//BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_ENABLE
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_ENABLE__GFX_CMD_COMPLETE_INTR_EN__SHIFT      0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_ENABLE__GFX_HANG_SELF_RECOVERED_INTR_EN__SHIFT  0x1
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_ENABLE__GFX_HANG_NEED_FLR_INTR_EN__SHIFT     0x2
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_ENABLE__GFX_VM_BUSY_TRANSITION_INTR_EN__SHIFT  0x3
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_ENABLE__UVD_CMD_COMPLETE_INTR_EN__SHIFT      0x8
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_ENABLE__UVD_HANG_SELF_RECOVERED_INTR_EN__SHIFT  0x9
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_ENABLE__UVD_HANG_NEED_FLR_INTR_EN__SHIFT     0xa
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_ENABLE__UVD_VM_BUSY_TRANSITION_INTR_EN__SHIFT  0xb
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_ENABLE__VCE_CMD_COMPLETE_INTR_EN__SHIFT      0x10
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_ENABLE__VCE_HANG_SELF_RECOVERED_INTR_EN__SHIFT  0x11
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_ENABLE__VCE_HANG_NEED_FLR_INTR_EN__SHIFT     0x12
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_ENABLE__VCE_VM_BUSY_TRANSITION_INTR_EN__SHIFT  0x13
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_ENABLE__HVVM_MAILBOX_TRN_ACK_INTR_EN__SHIFT  0x18
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_ENABLE__HVVM_MAILBOX_RCV_VALID_INTR_EN__SHIFT  0x19
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_ENABLE__GFX_CMD_COMPLETE_INTR_EN_MASK        0x00000001L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_ENABLE__GFX_HANG_SELF_RECOVERED_INTR_EN_MASK  0x00000002L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_ENABLE__GFX_HANG_NEED_FLR_INTR_EN_MASK       0x00000004L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_ENABLE__GFX_VM_BUSY_TRANSITION_INTR_EN_MASK  0x00000008L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_ENABLE__UVD_CMD_COMPLETE_INTR_EN_MASK        0x00000100L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_ENABLE__UVD_HANG_SELF_RECOVERED_INTR_EN_MASK  0x00000200L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_ENABLE__UVD_HANG_NEED_FLR_INTR_EN_MASK       0x00000400L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_ENABLE__UVD_VM_BUSY_TRANSITION_INTR_EN_MASK  0x00000800L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_ENABLE__VCE_CMD_COMPLETE_INTR_EN_MASK        0x00010000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_ENABLE__VCE_HANG_SELF_RECOVERED_INTR_EN_MASK  0x00020000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_ENABLE__VCE_HANG_NEED_FLR_INTR_EN_MASK       0x00040000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_ENABLE__VCE_VM_BUSY_TRANSITION_INTR_EN_MASK  0x00080000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_ENABLE__HVVM_MAILBOX_TRN_ACK_INTR_EN_MASK    0x01000000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_ENABLE__HVVM_MAILBOX_RCV_VALID_INTR_EN_MASK  0x02000000L
//BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_STATUS
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_STATUS__GFX_CMD_COMPLETE_INTR_STATUS__SHIFT  0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_STATUS__GFX_HANG_SELF_RECOVERED_INTR_STATUS__SHIFT  0x1
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_STATUS__GFX_HANG_NEED_FLR_INTR_STATUS__SHIFT  0x2
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_STATUS__GFX_VM_BUSY_TRANSITION_INTR_STATUS__SHIFT  0x3
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_STATUS__UVD_CMD_COMPLETE_INTR_STATUS__SHIFT  0x8
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_STATUS__UVD_HANG_SELF_RECOVERED_INTR_STATUS__SHIFT  0x9
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_STATUS__UVD_HANG_NEED_FLR_INTR_STATUS__SHIFT  0xa
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_STATUS__UVD_VM_BUSY_TRANSITION_INTR_STATUS__SHIFT  0xb
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_STATUS__VCE_CMD_COMPLETE_INTR_STATUS__SHIFT  0x10
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_STATUS__VCE_HANG_SELF_RECOVERED_INTR_STATUS__SHIFT  0x11
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_STATUS__VCE_HANG_NEED_FLR_INTR_STATUS__SHIFT  0x12
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_STATUS__VCE_VM_BUSY_TRANSITION_INTR_STATUS__SHIFT  0x13
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_STATUS__HVVM_MAILBOX_TRN_ACK_INTR_STATUS__SHIFT  0x18
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_STATUS__HVVM_MAILBOX_RCV_VALID_INTR_STATUS__SHIFT  0x19
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_STATUS__GFX_CMD_COMPLETE_INTR_STATUS_MASK    0x00000001L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_STATUS__GFX_HANG_SELF_RECOVERED_INTR_STATUS_MASK  0x00000002L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_STATUS__GFX_HANG_NEED_FLR_INTR_STATUS_MASK   0x00000004L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_STATUS__GFX_VM_BUSY_TRANSITION_INTR_STATUS_MASK  0x00000008L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_STATUS__UVD_CMD_COMPLETE_INTR_STATUS_MASK    0x00000100L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_STATUS__UVD_HANG_SELF_RECOVERED_INTR_STATUS_MASK  0x00000200L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_STATUS__UVD_HANG_NEED_FLR_INTR_STATUS_MASK   0x00000400L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_STATUS__UVD_VM_BUSY_TRANSITION_INTR_STATUS_MASK  0x00000800L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_STATUS__VCE_CMD_COMPLETE_INTR_STATUS_MASK    0x00010000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_STATUS__VCE_HANG_SELF_RECOVERED_INTR_STATUS_MASK  0x00020000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_STATUS__VCE_HANG_NEED_FLR_INTR_STATUS_MASK   0x00040000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_STATUS__VCE_VM_BUSY_TRANSITION_INTR_STATUS_MASK  0x00080000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_STATUS__HVVM_MAILBOX_TRN_ACK_INTR_STATUS_MASK  0x01000000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_INTR_STATUS__HVVM_MAILBOX_RCV_VALID_INTR_STATUS_MASK  0x02000000L
//BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_RESET_CONTROL
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_RESET_CONTROL__SOFT_PF_FLR__SHIFT                 0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_RESET_CONTROL__SOFT_PF_FLR_MASK                   0x0001L
//BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW0__VF_INDEX__SHIFT                    0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW0__TRN_MSG_DATA__SHIFT                0x8
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW0__TRN_MSG_VALID__SHIFT               0xf
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW0__RCV_MSG_DATA__SHIFT                0x10
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW0__RCV_MSG_ACK__SHIFT                 0x18
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW0__VF_INDEX_MASK                      0x000000FFL
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW0__TRN_MSG_DATA_MASK                  0x00000F00L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW0__TRN_MSG_VALID_MASK                 0x00008000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW0__RCV_MSG_DATA_MASK                  0x000F0000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW0__RCV_MSG_ACK_MASK                   0x01000000L
//BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF0_TRN_ACK__SHIFT                 0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF0_RCV_VALID__SHIFT               0x1
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF1_TRN_ACK__SHIFT                 0x2
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF1_RCV_VALID__SHIFT               0x3
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF2_TRN_ACK__SHIFT                 0x4
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF2_RCV_VALID__SHIFT               0x5
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF3_TRN_ACK__SHIFT                 0x6
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF3_RCV_VALID__SHIFT               0x7
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF4_TRN_ACK__SHIFT                 0x8
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF4_RCV_VALID__SHIFT               0x9
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF5_TRN_ACK__SHIFT                 0xa
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF5_RCV_VALID__SHIFT               0xb
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF6_TRN_ACK__SHIFT                 0xc
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF6_RCV_VALID__SHIFT               0xd
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF7_TRN_ACK__SHIFT                 0xe
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF7_RCV_VALID__SHIFT               0xf
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF8_TRN_ACK__SHIFT                 0x10
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF8_RCV_VALID__SHIFT               0x11
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF9_TRN_ACK__SHIFT                 0x12
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF9_RCV_VALID__SHIFT               0x13
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF10_TRN_ACK__SHIFT                0x14
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF10_RCV_VALID__SHIFT              0x15
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF11_TRN_ACK__SHIFT                0x16
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF11_RCV_VALID__SHIFT              0x17
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF12_TRN_ACK__SHIFT                0x18
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF12_RCV_VALID__SHIFT              0x19
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF13_TRN_ACK__SHIFT                0x1a
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF13_RCV_VALID__SHIFT              0x1b
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF14_TRN_ACK__SHIFT                0x1c
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF14_RCV_VALID__SHIFT              0x1d
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF15_TRN_ACK__SHIFT                0x1e
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF15_RCV_VALID__SHIFT              0x1f
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF0_TRN_ACK_MASK                   0x00000001L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF0_RCV_VALID_MASK                 0x00000002L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF1_TRN_ACK_MASK                   0x00000004L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF1_RCV_VALID_MASK                 0x00000008L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF2_TRN_ACK_MASK                   0x00000010L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF2_RCV_VALID_MASK                 0x00000020L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF3_TRN_ACK_MASK                   0x00000040L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF3_RCV_VALID_MASK                 0x00000080L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF4_TRN_ACK_MASK                   0x00000100L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF4_RCV_VALID_MASK                 0x00000200L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF5_TRN_ACK_MASK                   0x00000400L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF5_RCV_VALID_MASK                 0x00000800L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF6_TRN_ACK_MASK                   0x00001000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF6_RCV_VALID_MASK                 0x00002000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF7_TRN_ACK_MASK                   0x00004000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF7_RCV_VALID_MASK                 0x00008000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF8_TRN_ACK_MASK                   0x00010000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF8_RCV_VALID_MASK                 0x00020000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF9_TRN_ACK_MASK                   0x00040000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF9_RCV_VALID_MASK                 0x00080000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF10_TRN_ACK_MASK                  0x00100000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF10_RCV_VALID_MASK                0x00200000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF11_TRN_ACK_MASK                  0x00400000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF11_RCV_VALID_MASK                0x00800000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF12_TRN_ACK_MASK                  0x01000000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF12_RCV_VALID_MASK                0x02000000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF13_TRN_ACK_MASK                  0x04000000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF13_RCV_VALID_MASK                0x08000000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF14_TRN_ACK_MASK                  0x10000000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF14_RCV_VALID_MASK                0x20000000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF15_TRN_ACK_MASK                  0x40000000L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW1__VF15_RCV_VALID_MASK                0x80000000L
//BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW2
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW2__PF_TRN_ACK__SHIFT                  0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW2__PF_RCV_VALID__SHIFT                0x1
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW2__PF_TRN_ACK_MASK                    0x00000001L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_HVVM_MBOX_DW2__PF_RCV_VALID_MASK                  0x00000002L
//BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_CONTEXT
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_CONTEXT__CONTEXT_SIZE__SHIFT                      0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_CONTEXT__LOC__SHIFT                               0x7
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_CONTEXT__CONTEXT_OFFSET__SHIFT                    0xa
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_CONTEXT__CONTEXT_SIZE_MASK                        0x0000007FL
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_CONTEXT__LOC_MASK                                 0x00000080L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_CONTEXT__CONTEXT_OFFSET_MASK                      0xFFFFFC00L
//BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_TOTAL_FB
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_TOTAL_FB__TOTAL_FB_AVAILABLE__SHIFT               0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_TOTAL_FB__TOTAL_FB_CONSUMED__SHIFT                0x10
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_TOTAL_FB__TOTAL_FB_AVAILABLE_MASK                 0x0000FFFFL
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_TOTAL_FB__TOTAL_FB_CONSUMED_MASK                  0xFFFF0000L
//BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_OFFSETS
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_OFFSETS__UVDSCH_OFFSET__SHIFT                     0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_OFFSETS__VCESCH_OFFSET__SHIFT                     0x8
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_OFFSETS__GFXSCH_OFFSET__SHIFT                     0x10
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_OFFSETS__UVDSCH_OFFSET_MASK                       0x000000FFL
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_OFFSETS__VCESCH_OFFSET_MASK                       0x0000FF00L
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_OFFSETS__GFXSCH_OFFSET_MASK                       0x00FF0000L
//BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF0_FB
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF0_FB__VF0_FB_SIZE__SHIFT                        0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF0_FB__VF0_FB_OFFSET__SHIFT                      0x10
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF0_FB__VF0_FB_SIZE_MASK                          0x0000FFFFL
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF0_FB__VF0_FB_OFFSET_MASK                        0xFFFF0000L
//BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF1_FB
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF1_FB__VF1_FB_SIZE__SHIFT                        0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF1_FB__VF1_FB_OFFSET__SHIFT                      0x10
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF1_FB__VF1_FB_SIZE_MASK                          0x0000FFFFL
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF1_FB__VF1_FB_OFFSET_MASK                        0xFFFF0000L
//BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF2_FB
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF2_FB__VF2_FB_SIZE__SHIFT                        0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF2_FB__VF2_FB_OFFSET__SHIFT                      0x10
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF2_FB__VF2_FB_SIZE_MASK                          0x0000FFFFL
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF2_FB__VF2_FB_OFFSET_MASK                        0xFFFF0000L
//BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF3_FB
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF3_FB__VF3_FB_SIZE__SHIFT                        0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF3_FB__VF3_FB_OFFSET__SHIFT                      0x10
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF3_FB__VF3_FB_SIZE_MASK                          0x0000FFFFL
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF3_FB__VF3_FB_OFFSET_MASK                        0xFFFF0000L
//BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF4_FB
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF4_FB__VF4_FB_SIZE__SHIFT                        0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF4_FB__VF4_FB_OFFSET__SHIFT                      0x10
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF4_FB__VF4_FB_SIZE_MASK                          0x0000FFFFL
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF4_FB__VF4_FB_OFFSET_MASK                        0xFFFF0000L
//BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF5_FB
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF5_FB__VF5_FB_SIZE__SHIFT                        0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF5_FB__VF5_FB_OFFSET__SHIFT                      0x10
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF5_FB__VF5_FB_SIZE_MASK                          0x0000FFFFL
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF5_FB__VF5_FB_OFFSET_MASK                        0xFFFF0000L
//BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF6_FB
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF6_FB__VF6_FB_SIZE__SHIFT                        0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF6_FB__VF6_FB_OFFSET__SHIFT                      0x10
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF6_FB__VF6_FB_SIZE_MASK                          0x0000FFFFL
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF6_FB__VF6_FB_OFFSET_MASK                        0xFFFF0000L
//BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF7_FB
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF7_FB__VF7_FB_SIZE__SHIFT                        0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF7_FB__VF7_FB_OFFSET__SHIFT                      0x10
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF7_FB__VF7_FB_SIZE_MASK                          0x0000FFFFL
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF7_FB__VF7_FB_OFFSET_MASK                        0xFFFF0000L
//BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF8_FB
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF8_FB__VF8_FB_SIZE__SHIFT                        0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF8_FB__VF8_FB_OFFSET__SHIFT                      0x10
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF8_FB__VF8_FB_SIZE_MASK                          0x0000FFFFL
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF8_FB__VF8_FB_OFFSET_MASK                        0xFFFF0000L
//BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF9_FB
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF9_FB__VF9_FB_SIZE__SHIFT                        0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF9_FB__VF9_FB_OFFSET__SHIFT                      0x10
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF9_FB__VF9_FB_SIZE_MASK                          0x0000FFFFL
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF9_FB__VF9_FB_OFFSET_MASK                        0xFFFF0000L
//BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF10_FB
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF10_FB__VF10_FB_SIZE__SHIFT                      0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF10_FB__VF10_FB_OFFSET__SHIFT                    0x10
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF10_FB__VF10_FB_SIZE_MASK                        0x0000FFFFL
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF10_FB__VF10_FB_OFFSET_MASK                      0xFFFF0000L
//BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF11_FB
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF11_FB__VF11_FB_SIZE__SHIFT                      0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF11_FB__VF11_FB_OFFSET__SHIFT                    0x10
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF11_FB__VF11_FB_SIZE_MASK                        0x0000FFFFL
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF11_FB__VF11_FB_OFFSET_MASK                      0xFFFF0000L
//BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF12_FB
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF12_FB__VF12_FB_SIZE__SHIFT                      0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF12_FB__VF12_FB_OFFSET__SHIFT                    0x10
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF12_FB__VF12_FB_SIZE_MASK                        0x0000FFFFL
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF12_FB__VF12_FB_OFFSET_MASK                      0xFFFF0000L
//BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF13_FB
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF13_FB__VF13_FB_SIZE__SHIFT                      0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF13_FB__VF13_FB_OFFSET__SHIFT                    0x10
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF13_FB__VF13_FB_SIZE_MASK                        0x0000FFFFL
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF13_FB__VF13_FB_OFFSET_MASK                      0xFFFF0000L
//BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF14_FB
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF14_FB__VF14_FB_SIZE__SHIFT                      0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF14_FB__VF14_FB_OFFSET__SHIFT                    0x10
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF14_FB__VF14_FB_SIZE_MASK                        0x0000FFFFL
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF14_FB__VF14_FB_OFFSET_MASK                      0xFFFF0000L
//BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF15_FB
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF15_FB__VF15_FB_SIZE__SHIFT                      0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF15_FB__VF15_FB_OFFSET__SHIFT                    0x10
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF15_FB__VF15_FB_SIZE_MASK                        0x0000FFFFL
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VF15_FB__VF15_FB_OFFSET_MASK                      0xFFFF0000L
//BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW0__DW0__SHIFT                            0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW0__DW0_MASK                              0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW1
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW1__DW1__SHIFT                            0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW1__DW1_MASK                              0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW2
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW2__DW2__SHIFT                            0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW2__DW2_MASK                              0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW3
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW3__DW3__SHIFT                            0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW3__DW3_MASK                              0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW4
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW4__DW4__SHIFT                            0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW4__DW4_MASK                              0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW5
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW5__DW5__SHIFT                            0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW5__DW5_MASK                              0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW6
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW6__DW6__SHIFT                            0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW6__DW6_MASK                              0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW7
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW7__DW7__SHIFT                            0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW7__DW7_MASK                              0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW8
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW8__DW8__SHIFT                            0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_UVDSCH_DW8__DW8_MASK                              0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW0__DW0__SHIFT                            0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW0__DW0_MASK                              0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW1
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW1__DW1__SHIFT                            0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW1__DW1_MASK                              0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW2
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW2__DW2__SHIFT                            0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW2__DW2_MASK                              0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW3
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW3__DW3__SHIFT                            0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW3__DW3_MASK                              0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW4
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW4__DW4__SHIFT                            0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW4__DW4_MASK                              0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW5
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW5__DW5__SHIFT                            0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW5__DW5_MASK                              0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW6
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW6__DW6__SHIFT                            0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW6__DW6_MASK                              0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW7
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW7__DW7__SHIFT                            0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW7__DW7_MASK                              0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW8
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW8__DW8__SHIFT                            0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_VCESCH_DW8__DW8_MASK                              0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW0__DW0__SHIFT                            0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW0__DW0_MASK                              0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW1
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW1__DW1__SHIFT                            0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW1__DW1_MASK                              0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW2
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW2__DW2__SHIFT                            0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW2__DW2_MASK                              0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW3
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW3__DW3__SHIFT                            0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW3__DW3_MASK                              0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW4
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW4__DW4__SHIFT                            0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW4__DW4_MASK                              0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW5
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW5__DW5__SHIFT                            0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW5__DW5_MASK                              0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW6
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW6__DW6__SHIFT                            0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW6__DW6_MASK                              0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW7
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW7__DW7__SHIFT                            0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW7__DW7_MASK                              0xFFFFFFFFL
//BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW8
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW8__DW8__SHIFT                            0x0
#define BIF_CFG_DEV0_EPF1_0_PCIE_VENDOR_SPECIFIC_HDR_GPUIOV_GFXSCH_DW8__DW8_MASK                              0xFFFFFFFFL


// addressBlock: nbio_nbif0_bif_cfg_dev0_epf2_bifcfgdecp
//BIF_CFG_DEV0_EPF2_0_VENDOR_ID
#define BIF_CFG_DEV0_EPF2_0_VENDOR_ID__VENDOR_ID__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF2_0_VENDOR_ID__VENDOR_ID_MASK                                                         0xFFFFL
//BIF_CFG_DEV0_EPF2_0_DEVICE_ID
#define BIF_CFG_DEV0_EPF2_0_DEVICE_ID__DEVICE_ID__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF2_0_DEVICE_ID__DEVICE_ID_MASK                                                         0xFFFFL
//BIF_CFG_DEV0_EPF2_0_COMMAND
#define BIF_CFG_DEV0_EPF2_0_COMMAND__IO_ACCESS_EN__SHIFT                                                      0x0
#define BIF_CFG_DEV0_EPF2_0_COMMAND__MEM_ACCESS_EN__SHIFT                                                     0x1
#define BIF_CFG_DEV0_EPF2_0_COMMAND__BUS_MASTER_EN__SHIFT                                                     0x2
#define BIF_CFG_DEV0_EPF2_0_COMMAND__SPECIAL_CYCLE_EN__SHIFT                                                  0x3
#define BIF_CFG_DEV0_EPF2_0_COMMAND__MEM_WRITE_INVALIDATE_EN__SHIFT                                           0x4
#define BIF_CFG_DEV0_EPF2_0_COMMAND__PAL_SNOOP_EN__SHIFT                                                      0x5
#define BIF_CFG_DEV0_EPF2_0_COMMAND__PARITY_ERROR_RESPONSE__SHIFT                                             0x6
#define BIF_CFG_DEV0_EPF2_0_COMMAND__AD_STEPPING__SHIFT                                                       0x7
#define BIF_CFG_DEV0_EPF2_0_COMMAND__SERR_EN__SHIFT                                                           0x8
#define BIF_CFG_DEV0_EPF2_0_COMMAND__FAST_B2B_EN__SHIFT                                                       0x9
#define BIF_CFG_DEV0_EPF2_0_COMMAND__INT_DIS__SHIFT                                                           0xa
#define BIF_CFG_DEV0_EPF2_0_COMMAND__IO_ACCESS_EN_MASK                                                        0x0001L
#define BIF_CFG_DEV0_EPF2_0_COMMAND__MEM_ACCESS_EN_MASK                                                       0x0002L
#define BIF_CFG_DEV0_EPF2_0_COMMAND__BUS_MASTER_EN_MASK                                                       0x0004L
#define BIF_CFG_DEV0_EPF2_0_COMMAND__SPECIAL_CYCLE_EN_MASK                                                    0x0008L
#define BIF_CFG_DEV0_EPF2_0_COMMAND__MEM_WRITE_INVALIDATE_EN_MASK                                             0x0010L
#define BIF_CFG_DEV0_EPF2_0_COMMAND__PAL_SNOOP_EN_MASK                                                        0x0020L
#define BIF_CFG_DEV0_EPF2_0_COMMAND__PARITY_ERROR_RESPONSE_MASK                                               0x0040L
#define BIF_CFG_DEV0_EPF2_0_COMMAND__AD_STEPPING_MASK                                                         0x0080L
#define BIF_CFG_DEV0_EPF2_0_COMMAND__SERR_EN_MASK                                                             0x0100L
#define BIF_CFG_DEV0_EPF2_0_COMMAND__FAST_B2B_EN_MASK                                                         0x0200L
#define BIF_CFG_DEV0_EPF2_0_COMMAND__INT_DIS_MASK                                                             0x0400L
//BIF_CFG_DEV0_EPF2_0_STATUS
#define BIF_CFG_DEV0_EPF2_0_STATUS__INT_STATUS__SHIFT                                                         0x3
#define BIF_CFG_DEV0_EPF2_0_STATUS__CAP_LIST__SHIFT                                                           0x4
#define BIF_CFG_DEV0_EPF2_0_STATUS__PCI_66_EN__SHIFT                                                          0x5
#define BIF_CFG_DEV0_EPF2_0_STATUS__FAST_BACK_CAPABLE__SHIFT                                                  0x7
#define BIF_CFG_DEV0_EPF2_0_STATUS__MASTER_DATA_PARITY_ERROR__SHIFT                                           0x8
#define BIF_CFG_DEV0_EPF2_0_STATUS__DEVSEL_TIMING__SHIFT                                                      0x9
#define BIF_CFG_DEV0_EPF2_0_STATUS__SIGNAL_TARGET_ABORT__SHIFT                                                0xb
#define BIF_CFG_DEV0_EPF2_0_STATUS__RECEIVED_TARGET_ABORT__SHIFT                                              0xc
#define BIF_CFG_DEV0_EPF2_0_STATUS__RECEIVED_MASTER_ABORT__SHIFT                                              0xd
#define BIF_CFG_DEV0_EPF2_0_STATUS__SIGNALED_SYSTEM_ERROR__SHIFT                                              0xe
#define BIF_CFG_DEV0_EPF2_0_STATUS__PARITY_ERROR_DETECTED__SHIFT                                              0xf
#define BIF_CFG_DEV0_EPF2_0_STATUS__INT_STATUS_MASK                                                           0x0008L
#define BIF_CFG_DEV0_EPF2_0_STATUS__CAP_LIST_MASK                                                             0x0010L
#define BIF_CFG_DEV0_EPF2_0_STATUS__PCI_66_EN_MASK                                                            0x0020L
#define BIF_CFG_DEV0_EPF2_0_STATUS__FAST_BACK_CAPABLE_MASK                                                    0x0080L
#define BIF_CFG_DEV0_EPF2_0_STATUS__MASTER_DATA_PARITY_ERROR_MASK                                             0x0100L
#define BIF_CFG_DEV0_EPF2_0_STATUS__DEVSEL_TIMING_MASK                                                        0x0600L
#define BIF_CFG_DEV0_EPF2_0_STATUS__SIGNAL_TARGET_ABORT_MASK                                                  0x0800L
#define BIF_CFG_DEV0_EPF2_0_STATUS__RECEIVED_TARGET_ABORT_MASK                                                0x1000L
#define BIF_CFG_DEV0_EPF2_0_STATUS__RECEIVED_MASTER_ABORT_MASK                                                0x2000L
#define BIF_CFG_DEV0_EPF2_0_STATUS__SIGNALED_SYSTEM_ERROR_MASK                                                0x4000L
#define BIF_CFG_DEV0_EPF2_0_STATUS__PARITY_ERROR_DETECTED_MASK                                                0x8000L
//BIF_CFG_DEV0_EPF2_0_REVISION_ID
#define BIF_CFG_DEV0_EPF2_0_REVISION_ID__MINOR_REV_ID__SHIFT                                                  0x0
#define BIF_CFG_DEV0_EPF2_0_REVISION_ID__MAJOR_REV_ID__SHIFT                                                  0x4
#define BIF_CFG_DEV0_EPF2_0_REVISION_ID__MINOR_REV_ID_MASK                                                    0x0FL
#define BIF_CFG_DEV0_EPF2_0_REVISION_ID__MAJOR_REV_ID_MASK                                                    0xF0L
//BIF_CFG_DEV0_EPF2_0_PROG_INTERFACE
#define BIF_CFG_DEV0_EPF2_0_PROG_INTERFACE__PROG_INTERFACE__SHIFT                                             0x0
#define BIF_CFG_DEV0_EPF2_0_PROG_INTERFACE__PROG_INTERFACE_MASK                                               0xFFL
//BIF_CFG_DEV0_EPF2_0_SUB_CLASS
#define BIF_CFG_DEV0_EPF2_0_SUB_CLASS__SUB_CLASS__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF2_0_SUB_CLASS__SUB_CLASS_MASK                                                         0xFFL
//BIF_CFG_DEV0_EPF2_0_BASE_CLASS
#define BIF_CFG_DEV0_EPF2_0_BASE_CLASS__BASE_CLASS__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF2_0_BASE_CLASS__BASE_CLASS_MASK                                                       0xFFL
//BIF_CFG_DEV0_EPF2_0_CACHE_LINE
#define BIF_CFG_DEV0_EPF2_0_CACHE_LINE__CACHE_LINE_SIZE__SHIFT                                                0x0
#define BIF_CFG_DEV0_EPF2_0_CACHE_LINE__CACHE_LINE_SIZE_MASK                                                  0xFFL
//BIF_CFG_DEV0_EPF2_0_LATENCY
#define BIF_CFG_DEV0_EPF2_0_LATENCY__LATENCY_TIMER__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF2_0_LATENCY__LATENCY_TIMER_MASK                                                       0xFFL
//BIF_CFG_DEV0_EPF2_0_HEADER
#define BIF_CFG_DEV0_EPF2_0_HEADER__HEADER_TYPE__SHIFT                                                        0x0
#define BIF_CFG_DEV0_EPF2_0_HEADER__DEVICE_TYPE__SHIFT                                                        0x7
#define BIF_CFG_DEV0_EPF2_0_HEADER__HEADER_TYPE_MASK                                                          0x7FL
#define BIF_CFG_DEV0_EPF2_0_HEADER__DEVICE_TYPE_MASK                                                          0x80L
//BIF_CFG_DEV0_EPF2_0_BIST
#define BIF_CFG_DEV0_EPF2_0_BIST__BIST_COMP__SHIFT                                                            0x0
#define BIF_CFG_DEV0_EPF2_0_BIST__BIST_STRT__SHIFT                                                            0x6
#define BIF_CFG_DEV0_EPF2_0_BIST__BIST_CAP__SHIFT                                                             0x7
#define BIF_CFG_DEV0_EPF2_0_BIST__BIST_COMP_MASK                                                              0x0FL
#define BIF_CFG_DEV0_EPF2_0_BIST__BIST_STRT_MASK                                                              0x40L
#define BIF_CFG_DEV0_EPF2_0_BIST__BIST_CAP_MASK                                                               0x80L
//BIF_CFG_DEV0_EPF2_0_BASE_ADDR_1
#define BIF_CFG_DEV0_EPF2_0_BASE_ADDR_1__BASE_ADDR__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF2_0_BASE_ADDR_1__BASE_ADDR_MASK                                                       0xFFFFFFFFL
//BIF_CFG_DEV0_EPF2_0_BASE_ADDR_2
#define BIF_CFG_DEV0_EPF2_0_BASE_ADDR_2__BASE_ADDR__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF2_0_BASE_ADDR_2__BASE_ADDR_MASK                                                       0xFFFFFFFFL
//BIF_CFG_DEV0_EPF2_0_BASE_ADDR_3
#define BIF_CFG_DEV0_EPF2_0_BASE_ADDR_3__BASE_ADDR__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF2_0_BASE_ADDR_3__BASE_ADDR_MASK                                                       0xFFFFFFFFL
//BIF_CFG_DEV0_EPF2_0_BASE_ADDR_4
#define BIF_CFG_DEV0_EPF2_0_BASE_ADDR_4__BASE_ADDR__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF2_0_BASE_ADDR_4__BASE_ADDR_MASK                                                       0xFFFFFFFFL
//BIF_CFG_DEV0_EPF2_0_BASE_ADDR_5
#define BIF_CFG_DEV0_EPF2_0_BASE_ADDR_5__BASE_ADDR__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF2_0_BASE_ADDR_5__BASE_ADDR_MASK                                                       0xFFFFFFFFL
//BIF_CFG_DEV0_EPF2_0_BASE_ADDR_6
#define BIF_CFG_DEV0_EPF2_0_BASE_ADDR_6__BASE_ADDR__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF2_0_BASE_ADDR_6__BASE_ADDR_MASK                                                       0xFFFFFFFFL
//BIF_CFG_DEV0_EPF2_0_ADAPTER_ID
#define BIF_CFG_DEV0_EPF2_0_ADAPTER_ID__SUBSYSTEM_VENDOR_ID__SHIFT                                            0x0
#define BIF_CFG_DEV0_EPF2_0_ADAPTER_ID__SUBSYSTEM_ID__SHIFT                                                   0x10
#define BIF_CFG_DEV0_EPF2_0_ADAPTER_ID__SUBSYSTEM_VENDOR_ID_MASK                                              0x0000FFFFL
#define BIF_CFG_DEV0_EPF2_0_ADAPTER_ID__SUBSYSTEM_ID_MASK                                                     0xFFFF0000L
//BIF_CFG_DEV0_EPF2_0_ROM_BASE_ADDR
#define BIF_CFG_DEV0_EPF2_0_ROM_BASE_ADDR__BASE_ADDR__SHIFT                                                   0x0
#define BIF_CFG_DEV0_EPF2_0_ROM_BASE_ADDR__BASE_ADDR_MASK                                                     0xFFFFFFFFL
//BIF_CFG_DEV0_EPF2_0_CAP_PTR
#define BIF_CFG_DEV0_EPF2_0_CAP_PTR__CAP_PTR__SHIFT                                                           0x0
#define BIF_CFG_DEV0_EPF2_0_CAP_PTR__CAP_PTR_MASK                                                             0x000000FFL
//BIF_CFG_DEV0_EPF2_0_INTERRUPT_LINE
#define BIF_CFG_DEV0_EPF2_0_INTERRUPT_LINE__INTERRUPT_LINE__SHIFT                                             0x0
#define BIF_CFG_DEV0_EPF2_0_INTERRUPT_LINE__INTERRUPT_LINE_MASK                                               0xFFL
//BIF_CFG_DEV0_EPF2_0_INTERRUPT_PIN
#define BIF_CFG_DEV0_EPF2_0_INTERRUPT_PIN__INTERRUPT_PIN__SHIFT                                               0x0
#define BIF_CFG_DEV0_EPF2_0_INTERRUPT_PIN__INTERRUPT_PIN_MASK                                                 0xFFL
//BIF_CFG_DEV0_EPF2_0_MIN_GRANT
#define BIF_CFG_DEV0_EPF2_0_MIN_GRANT__MIN_GNT__SHIFT                                                         0x0
#define BIF_CFG_DEV0_EPF2_0_MIN_GRANT__MIN_GNT_MASK                                                           0xFFL
//BIF_CFG_DEV0_EPF2_0_MAX_LATENCY
#define BIF_CFG_DEV0_EPF2_0_MAX_LATENCY__MAX_LAT__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF2_0_MAX_LATENCY__MAX_LAT_MASK                                                         0xFFL
//BIF_CFG_DEV0_EPF2_0_VENDOR_CAP_LIST
#define BIF_CFG_DEV0_EPF2_0_VENDOR_CAP_LIST__CAP_ID__SHIFT                                                    0x0
#define BIF_CFG_DEV0_EPF2_0_VENDOR_CAP_LIST__NEXT_PTR__SHIFT                                                  0x8
#define BIF_CFG_DEV0_EPF2_0_VENDOR_CAP_LIST__LENGTH__SHIFT                                                    0x10
#define BIF_CFG_DEV0_EPF2_0_VENDOR_CAP_LIST__CAP_ID_MASK                                                      0x000000FFL
#define BIF_CFG_DEV0_EPF2_0_VENDOR_CAP_LIST__NEXT_PTR_MASK                                                    0x0000FF00L
#define BIF_CFG_DEV0_EPF2_0_VENDOR_CAP_LIST__LENGTH_MASK                                                      0x00FF0000L
//BIF_CFG_DEV0_EPF2_0_ADAPTER_ID_W
#define BIF_CFG_DEV0_EPF2_0_ADAPTER_ID_W__SUBSYSTEM_VENDOR_ID__SHIFT                                          0x0
#define BIF_CFG_DEV0_EPF2_0_ADAPTER_ID_W__SUBSYSTEM_ID__SHIFT                                                 0x10
#define BIF_CFG_DEV0_EPF2_0_ADAPTER_ID_W__SUBSYSTEM_VENDOR_ID_MASK                                            0x0000FFFFL
#define BIF_CFG_DEV0_EPF2_0_ADAPTER_ID_W__SUBSYSTEM_ID_MASK                                                   0xFFFF0000L
//BIF_CFG_DEV0_EPF2_0_PMI_CAP_LIST
#define BIF_CFG_DEV0_EPF2_0_PMI_CAP_LIST__CAP_ID__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF2_0_PMI_CAP_LIST__NEXT_PTR__SHIFT                                                     0x8
#define BIF_CFG_DEV0_EPF2_0_PMI_CAP_LIST__CAP_ID_MASK                                                         0x00FFL
#define BIF_CFG_DEV0_EPF2_0_PMI_CAP_LIST__NEXT_PTR_MASK                                                       0xFF00L
//BIF_CFG_DEV0_EPF2_0_PMI_CAP
#define BIF_CFG_DEV0_EPF2_0_PMI_CAP__VERSION__SHIFT                                                           0x0
#define BIF_CFG_DEV0_EPF2_0_PMI_CAP__PME_CLOCK__SHIFT                                                         0x3
#define BIF_CFG_DEV0_EPF2_0_PMI_CAP__DEV_SPECIFIC_INIT__SHIFT                                                 0x5
#define BIF_CFG_DEV0_EPF2_0_PMI_CAP__AUX_CURRENT__SHIFT                                                       0x6
#define BIF_CFG_DEV0_EPF2_0_PMI_CAP__D1_SUPPORT__SHIFT                                                        0x9
#define BIF_CFG_DEV0_EPF2_0_PMI_CAP__D2_SUPPORT__SHIFT                                                        0xa
#define BIF_CFG_DEV0_EPF2_0_PMI_CAP__PME_SUPPORT__SHIFT                                                       0xb
#define BIF_CFG_DEV0_EPF2_0_PMI_CAP__VERSION_MASK                                                             0x0007L
#define BIF_CFG_DEV0_EPF2_0_PMI_CAP__PME_CLOCK_MASK                                                           0x0008L
#define BIF_CFG_DEV0_EPF2_0_PMI_CAP__DEV_SPECIFIC_INIT_MASK                                                   0x0020L
#define BIF_CFG_DEV0_EPF2_0_PMI_CAP__AUX_CURRENT_MASK                                                         0x01C0L
#define BIF_CFG_DEV0_EPF2_0_PMI_CAP__D1_SUPPORT_MASK                                                          0x0200L
#define BIF_CFG_DEV0_EPF2_0_PMI_CAP__D2_SUPPORT_MASK                                                          0x0400L
#define BIF_CFG_DEV0_EPF2_0_PMI_CAP__PME_SUPPORT_MASK                                                         0xF800L
//BIF_CFG_DEV0_EPF2_0_PMI_STATUS_CNTL
#define BIF_CFG_DEV0_EPF2_0_PMI_STATUS_CNTL__POWER_STATE__SHIFT                                               0x0
#define BIF_CFG_DEV0_EPF2_0_PMI_STATUS_CNTL__NO_SOFT_RESET__SHIFT                                             0x3
#define BIF_CFG_DEV0_EPF2_0_PMI_STATUS_CNTL__PME_EN__SHIFT                                                    0x8
#define BIF_CFG_DEV0_EPF2_0_PMI_STATUS_CNTL__DATA_SELECT__SHIFT                                               0x9
#define BIF_CFG_DEV0_EPF2_0_PMI_STATUS_CNTL__DATA_SCALE__SHIFT                                                0xd
#define BIF_CFG_DEV0_EPF2_0_PMI_STATUS_CNTL__PME_STATUS__SHIFT                                                0xf
#define BIF_CFG_DEV0_EPF2_0_PMI_STATUS_CNTL__B2_B3_SUPPORT__SHIFT                                             0x16
#define BIF_CFG_DEV0_EPF2_0_PMI_STATUS_CNTL__BUS_PWR_EN__SHIFT                                                0x17
#define BIF_CFG_DEV0_EPF2_0_PMI_STATUS_CNTL__PMI_DATA__SHIFT                                                  0x18
#define BIF_CFG_DEV0_EPF2_0_PMI_STATUS_CNTL__POWER_STATE_MASK                                                 0x00000003L
#define BIF_CFG_DEV0_EPF2_0_PMI_STATUS_CNTL__NO_SOFT_RESET_MASK                                               0x00000008L
#define BIF_CFG_DEV0_EPF2_0_PMI_STATUS_CNTL__PME_EN_MASK                                                      0x00000100L
#define BIF_CFG_DEV0_EPF2_0_PMI_STATUS_CNTL__DATA_SELECT_MASK                                                 0x00001E00L
#define BIF_CFG_DEV0_EPF2_0_PMI_STATUS_CNTL__DATA_SCALE_MASK                                                  0x00006000L
#define BIF_CFG_DEV0_EPF2_0_PMI_STATUS_CNTL__PME_STATUS_MASK                                                  0x00008000L
#define BIF_CFG_DEV0_EPF2_0_PMI_STATUS_CNTL__B2_B3_SUPPORT_MASK                                               0x00400000L
#define BIF_CFG_DEV0_EPF2_0_PMI_STATUS_CNTL__BUS_PWR_EN_MASK                                                  0x00800000L
#define BIF_CFG_DEV0_EPF2_0_PMI_STATUS_CNTL__PMI_DATA_MASK                                                    0xFF000000L
//BIF_CFG_DEV0_EPF2_0_SBRN
#define BIF_CFG_DEV0_EPF2_0_SBRN__SBRN__SHIFT                                                                 0x0
#define BIF_CFG_DEV0_EPF2_0_SBRN__SBRN_MASK                                                                   0xFFL
//BIF_CFG_DEV0_EPF2_0_FLADJ
#define BIF_CFG_DEV0_EPF2_0_FLADJ__FLADJ__SHIFT                                                               0x0
#define BIF_CFG_DEV0_EPF2_0_FLADJ__FLADJ_MASK                                                                 0x3FL
//BIF_CFG_DEV0_EPF2_0_DBESL_DBESLD
#define BIF_CFG_DEV0_EPF2_0_DBESL_DBESLD__DBESL__SHIFT                                                        0x0
#define BIF_CFG_DEV0_EPF2_0_DBESL_DBESLD__DBESLD__SHIFT                                                       0x4
#define BIF_CFG_DEV0_EPF2_0_DBESL_DBESLD__DBESL_MASK                                                          0x0FL
#define BIF_CFG_DEV0_EPF2_0_DBESL_DBESLD__DBESLD_MASK                                                         0xF0L
//BIF_CFG_DEV0_EPF2_0_PCIE_CAP_LIST
#define BIF_CFG_DEV0_EPF2_0_PCIE_CAP_LIST__CAP_ID__SHIFT                                                      0x0
#define BIF_CFG_DEV0_EPF2_0_PCIE_CAP_LIST__NEXT_PTR__SHIFT                                                    0x8
#define BIF_CFG_DEV0_EPF2_0_PCIE_CAP_LIST__CAP_ID_MASK                                                        0x00FFL
#define BIF_CFG_DEV0_EPF2_0_PCIE_CAP_LIST__NEXT_PTR_MASK                                                      0xFF00L
//BIF_CFG_DEV0_EPF2_0_PCIE_CAP
#define BIF_CFG_DEV0_EPF2_0_PCIE_CAP__VERSION__SHIFT                                                          0x0
#define BIF_CFG_DEV0_EPF2_0_PCIE_CAP__DEVICE_TYPE__SHIFT                                                      0x4
#define BIF_CFG_DEV0_EPF2_0_PCIE_CAP__SLOT_IMPLEMENTED__SHIFT                                                 0x8
#define BIF_CFG_DEV0_EPF2_0_PCIE_CAP__INT_MESSAGE_NUM__SHIFT                                                  0x9
#define BIF_CFG_DEV0_EPF2_0_PCIE_CAP__VERSION_MASK                                                            0x000FL
#define BIF_CFG_DEV0_EPF2_0_PCIE_CAP__DEVICE_TYPE_MASK                                                        0x00F0L
#define BIF_CFG_DEV0_EPF2_0_PCIE_CAP__SLOT_IMPLEMENTED_MASK                                                   0x0100L
#define BIF_CFG_DEV0_EPF2_0_PCIE_CAP__INT_MESSAGE_NUM_MASK                                                    0x3E00L
//BIF_CFG_DEV0_EPF2_0_DEVICE_CAP
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CAP__MAX_PAYLOAD_SUPPORT__SHIFT                                            0x0
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CAP__PHANTOM_FUNC__SHIFT                                                   0x3
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CAP__EXTENDED_TAG__SHIFT                                                   0x5
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CAP__L0S_ACCEPTABLE_LATENCY__SHIFT                                         0x6
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CAP__L1_ACCEPTABLE_LATENCY__SHIFT                                          0x9
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CAP__ROLE_BASED_ERR_REPORTING__SHIFT                                       0xf
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CAP__CAPTURED_SLOT_POWER_LIMIT__SHIFT                                      0x12
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CAP__CAPTURED_SLOT_POWER_SCALE__SHIFT                                      0x1a
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CAP__FLR_CAPABLE__SHIFT                                                    0x1c
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CAP__MAX_PAYLOAD_SUPPORT_MASK                                              0x00000007L
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CAP__PHANTOM_FUNC_MASK                                                     0x00000018L
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CAP__EXTENDED_TAG_MASK                                                     0x00000020L
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CAP__L0S_ACCEPTABLE_LATENCY_MASK                                           0x000001C0L
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CAP__L1_ACCEPTABLE_LATENCY_MASK                                            0x00000E00L
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CAP__ROLE_BASED_ERR_REPORTING_MASK                                         0x00008000L
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CAP__CAPTURED_SLOT_POWER_LIMIT_MASK                                        0x03FC0000L
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CAP__CAPTURED_SLOT_POWER_SCALE_MASK                                        0x0C000000L
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CAP__FLR_CAPABLE_MASK                                                      0x10000000L
//BIF_CFG_DEV0_EPF2_0_DEVICE_CNTL
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CNTL__CORR_ERR_EN__SHIFT                                                   0x0
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CNTL__NON_FATAL_ERR_EN__SHIFT                                              0x1
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CNTL__FATAL_ERR_EN__SHIFT                                                  0x2
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CNTL__USR_REPORT_EN__SHIFT                                                 0x3
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CNTL__RELAXED_ORD_EN__SHIFT                                                0x4
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CNTL__MAX_PAYLOAD_SIZE__SHIFT                                              0x5
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CNTL__EXTENDED_TAG_EN__SHIFT                                               0x8
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CNTL__PHANTOM_FUNC_EN__SHIFT                                               0x9
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CNTL__AUX_POWER_PM_EN__SHIFT                                               0xa
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CNTL__NO_SNOOP_EN__SHIFT                                                   0xb
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CNTL__MAX_READ_REQUEST_SIZE__SHIFT                                         0xc
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CNTL__INITIATE_FLR__SHIFT                                                  0xf
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CNTL__CORR_ERR_EN_MASK                                                     0x0001L
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CNTL__NON_FATAL_ERR_EN_MASK                                                0x0002L
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CNTL__FATAL_ERR_EN_MASK                                                    0x0004L
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CNTL__USR_REPORT_EN_MASK                                                   0x0008L
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CNTL__RELAXED_ORD_EN_MASK                                                  0x0010L
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CNTL__MAX_PAYLOAD_SIZE_MASK                                                0x00E0L
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CNTL__EXTENDED_TAG_EN_MASK                                                 0x0100L
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CNTL__PHANTOM_FUNC_EN_MASK                                                 0x0200L
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CNTL__AUX_POWER_PM_EN_MASK                                                 0x0400L
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CNTL__NO_SNOOP_EN_MASK                                                     0x0800L
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CNTL__MAX_READ_REQUEST_SIZE_MASK                                           0x7000L
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CNTL__INITIATE_FLR_MASK                                                    0x8000L
//BIF_CFG_DEV0_EPF2_0_DEVICE_STATUS
#define BIF_CFG_DEV0_EPF2_0_DEVICE_STATUS__CORR_ERR__SHIFT                                                    0x0
#define BIF_CFG_DEV0_EPF2_0_DEVICE_STATUS__NON_FATAL_ERR__SHIFT                                               0x1
#define BIF_CFG_DEV0_EPF2_0_DEVICE_STATUS__FATAL_ERR__SHIFT                                                   0x2
#define BIF_CFG_DEV0_EPF2_0_DEVICE_STATUS__USR_DETECTED__SHIFT                                                0x3
#define BIF_CFG_DEV0_EPF2_0_DEVICE_STATUS__AUX_PWR__SHIFT                                                     0x4
#define BIF_CFG_DEV0_EPF2_0_DEVICE_STATUS__TRANSACTIONS_PEND__SHIFT                                           0x5
#define BIF_CFG_DEV0_EPF2_0_DEVICE_STATUS__CORR_ERR_MASK                                                      0x0001L
#define BIF_CFG_DEV0_EPF2_0_DEVICE_STATUS__NON_FATAL_ERR_MASK                                                 0x0002L
#define BIF_CFG_DEV0_EPF2_0_DEVICE_STATUS__FATAL_ERR_MASK                                                     0x0004L
#define BIF_CFG_DEV0_EPF2_0_DEVICE_STATUS__USR_DETECTED_MASK                                                  0x0008L
#define BIF_CFG_DEV0_EPF2_0_DEVICE_STATUS__AUX_PWR_MASK                                                       0x0010L
#define BIF_CFG_DEV0_EPF2_0_DEVICE_STATUS__TRANSACTIONS_PEND_MASK                                             0x0020L
//BIF_CFG_DEV0_EPF2_0_LINK_CAP
#define BIF_CFG_DEV0_EPF2_0_LINK_CAP__LINK_SPEED__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF2_0_LINK_CAP__LINK_WIDTH__SHIFT                                                       0x4
#define BIF_CFG_DEV0_EPF2_0_LINK_CAP__PM_SUPPORT__SHIFT                                                       0xa
#define BIF_CFG_DEV0_EPF2_0_LINK_CAP__L0S_EXIT_LATENCY__SHIFT                                                 0xc
#define BIF_CFG_DEV0_EPF2_0_LINK_CAP__L1_EXIT_LATENCY__SHIFT                                                  0xf
#define BIF_CFG_DEV0_EPF2_0_LINK_CAP__CLOCK_POWER_MANAGEMENT__SHIFT                                           0x12
#define BIF_CFG_DEV0_EPF2_0_LINK_CAP__SURPRISE_DOWN_ERR_REPORTING__SHIFT                                      0x13
#define BIF_CFG_DEV0_EPF2_0_LINK_CAP__DL_ACTIVE_REPORTING_CAPABLE__SHIFT                                      0x14
#define BIF_CFG_DEV0_EPF2_0_LINK_CAP__LINK_BW_NOTIFICATION_CAP__SHIFT                                         0x15
#define BIF_CFG_DEV0_EPF2_0_LINK_CAP__ASPM_OPTIONALITY_COMPLIANCE__SHIFT                                      0x16
#define BIF_CFG_DEV0_EPF2_0_LINK_CAP__PORT_NUMBER__SHIFT                                                      0x18
#define BIF_CFG_DEV0_EPF2_0_LINK_CAP__LINK_SPEED_MASK                                                         0x0000000FL
#define BIF_CFG_DEV0_EPF2_0_LINK_CAP__LINK_WIDTH_MASK                                                         0x000003F0L
#define BIF_CFG_DEV0_EPF2_0_LINK_CAP__PM_SUPPORT_MASK                                                         0x00000C00L
#define BIF_CFG_DEV0_EPF2_0_LINK_CAP__L0S_EXIT_LATENCY_MASK                                                   0x00007000L
#define BIF_CFG_DEV0_EPF2_0_LINK_CAP__L1_EXIT_LATENCY_MASK                                                    0x00038000L
#define BIF_CFG_DEV0_EPF2_0_LINK_CAP__CLOCK_POWER_MANAGEMENT_MASK                                             0x00040000L
#define BIF_CFG_DEV0_EPF2_0_LINK_CAP__SURPRISE_DOWN_ERR_REPORTING_MASK                                        0x00080000L
#define BIF_CFG_DEV0_EPF2_0_LINK_CAP__DL_ACTIVE_REPORTING_CAPABLE_MASK                                        0x00100000L
#define BIF_CFG_DEV0_EPF2_0_LINK_CAP__LINK_BW_NOTIFICATION_CAP_MASK                                           0x00200000L
#define BIF_CFG_DEV0_EPF2_0_LINK_CAP__ASPM_OPTIONALITY_COMPLIANCE_MASK                                        0x00400000L
#define BIF_CFG_DEV0_EPF2_0_LINK_CAP__PORT_NUMBER_MASK                                                        0xFF000000L
//BIF_CFG_DEV0_EPF2_0_LINK_CNTL
#define BIF_CFG_DEV0_EPF2_0_LINK_CNTL__PM_CONTROL__SHIFT                                                      0x0
#define BIF_CFG_DEV0_EPF2_0_LINK_CNTL__READ_CPL_BOUNDARY__SHIFT                                               0x3
#define BIF_CFG_DEV0_EPF2_0_LINK_CNTL__LINK_DIS__SHIFT                                                        0x4
#define BIF_CFG_DEV0_EPF2_0_LINK_CNTL__RETRAIN_LINK__SHIFT                                                    0x5
#define BIF_CFG_DEV0_EPF2_0_LINK_CNTL__COMMON_CLOCK_CFG__SHIFT                                                0x6
#define BIF_CFG_DEV0_EPF2_0_LINK_CNTL__EXTENDED_SYNC__SHIFT                                                   0x7
#define BIF_CFG_DEV0_EPF2_0_LINK_CNTL__CLOCK_POWER_MANAGEMENT_EN__SHIFT                                       0x8
#define BIF_CFG_DEV0_EPF2_0_LINK_CNTL__HW_AUTONOMOUS_WIDTH_DISABLE__SHIFT                                     0x9
#define BIF_CFG_DEV0_EPF2_0_LINK_CNTL__LINK_BW_MANAGEMENT_INT_EN__SHIFT                                       0xa
#define BIF_CFG_DEV0_EPF2_0_LINK_CNTL__LINK_AUTONOMOUS_BW_INT_EN__SHIFT                                       0xb
#define BIF_CFG_DEV0_EPF2_0_LINK_CNTL__PM_CONTROL_MASK                                                        0x0003L
#define BIF_CFG_DEV0_EPF2_0_LINK_CNTL__READ_CPL_BOUNDARY_MASK                                                 0x0008L
#define BIF_CFG_DEV0_EPF2_0_LINK_CNTL__LINK_DIS_MASK                                                          0x0010L
#define BIF_CFG_DEV0_EPF2_0_LINK_CNTL__RETRAIN_LINK_MASK                                                      0x0020L
#define BIF_CFG_DEV0_EPF2_0_LINK_CNTL__COMMON_CLOCK_CFG_MASK                                                  0x0040L
#define BIF_CFG_DEV0_EPF2_0_LINK_CNTL__EXTENDED_SYNC_MASK                                                     0x0080L
#define BIF_CFG_DEV0_EPF2_0_LINK_CNTL__CLOCK_POWER_MANAGEMENT_EN_MASK                                         0x0100L
#define BIF_CFG_DEV0_EPF2_0_LINK_CNTL__HW_AUTONOMOUS_WIDTH_DISABLE_MASK                                       0x0200L
#define BIF_CFG_DEV0_EPF2_0_LINK_CNTL__LINK_BW_MANAGEMENT_INT_EN_MASK                                         0x0400L
#define BIF_CFG_DEV0_EPF2_0_LINK_CNTL__LINK_AUTONOMOUS_BW_INT_EN_MASK                                         0x0800L
//BIF_CFG_DEV0_EPF2_0_LINK_STATUS
#define BIF_CFG_DEV0_EPF2_0_LINK_STATUS__CURRENT_LINK_SPEED__SHIFT                                            0x0
#define BIF_CFG_DEV0_EPF2_0_LINK_STATUS__NEGOTIATED_LINK_WIDTH__SHIFT                                         0x4
#define BIF_CFG_DEV0_EPF2_0_LINK_STATUS__LINK_TRAINING__SHIFT                                                 0xb
#define BIF_CFG_DEV0_EPF2_0_LINK_STATUS__SLOT_CLOCK_CFG__SHIFT                                                0xc
#define BIF_CFG_DEV0_EPF2_0_LINK_STATUS__DL_ACTIVE__SHIFT                                                     0xd
#define BIF_CFG_DEV0_EPF2_0_LINK_STATUS__LINK_BW_MANAGEMENT_STATUS__SHIFT                                     0xe
#define BIF_CFG_DEV0_EPF2_0_LINK_STATUS__LINK_AUTONOMOUS_BW_STATUS__SHIFT                                     0xf
#define BIF_CFG_DEV0_EPF2_0_LINK_STATUS__CURRENT_LINK_SPEED_MASK                                              0x000FL
#define BIF_CFG_DEV0_EPF2_0_LINK_STATUS__NEGOTIATED_LINK_WIDTH_MASK                                           0x03F0L
#define BIF_CFG_DEV0_EPF2_0_LINK_STATUS__LINK_TRAINING_MASK                                                   0x0800L
#define BIF_CFG_DEV0_EPF2_0_LINK_STATUS__SLOT_CLOCK_CFG_MASK                                                  0x1000L
#define BIF_CFG_DEV0_EPF2_0_LINK_STATUS__DL_ACTIVE_MASK                                                       0x2000L
#define BIF_CFG_DEV0_EPF2_0_LINK_STATUS__LINK_BW_MANAGEMENT_STATUS_MASK                                       0x4000L
#define BIF_CFG_DEV0_EPF2_0_LINK_STATUS__LINK_AUTONOMOUS_BW_STATUS_MASK                                       0x8000L
//BIF_CFG_DEV0_EPF2_0_DEVICE_CAP2
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CAP2__CPL_TIMEOUT_RANGE_SUPPORTED__SHIFT                                   0x0
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CAP2__CPL_TIMEOUT_DIS_SUPPORTED__SHIFT                                     0x4
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CAP2__ARI_FORWARDING_SUPPORTED__SHIFT                                      0x5
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CAP2__ATOMICOP_ROUTING_SUPPORTED__SHIFT                                    0x6
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CAP2__ATOMICOP_32CMPLT_SUPPORTED__SHIFT                                    0x7
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CAP2__ATOMICOP_64CMPLT_SUPPORTED__SHIFT                                    0x8
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CAP2__CAS128_CMPLT_SUPPORTED__SHIFT                                        0x9
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CAP2__NO_RO_ENABLED_P2P_PASSING__SHIFT                                     0xa
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CAP2__LTR_SUPPORTED__SHIFT                                                 0xb
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CAP2__TPH_CPLR_SUPPORTED__SHIFT                                            0xc
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CAP2__OBFF_SUPPORTED__SHIFT                                                0x12
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CAP2__EXTENDED_FMT_FIELD_SUPPORTED__SHIFT                                  0x14
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CAP2__END_END_TLP_PREFIX_SUPPORTED__SHIFT                                  0x15
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CAP2__MAX_END_END_TLP_PREFIXES__SHIFT                                      0x16
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CAP2__CPL_TIMEOUT_RANGE_SUPPORTED_MASK                                     0x0000000FL
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CAP2__CPL_TIMEOUT_DIS_SUPPORTED_MASK                                       0x00000010L
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CAP2__ARI_FORWARDING_SUPPORTED_MASK                                        0x00000020L
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CAP2__ATOMICOP_ROUTING_SUPPORTED_MASK                                      0x00000040L
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CAP2__ATOMICOP_32CMPLT_SUPPORTED_MASK                                      0x00000080L
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CAP2__ATOMICOP_64CMPLT_SUPPORTED_MASK                                      0x00000100L
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CAP2__CAS128_CMPLT_SUPPORTED_MASK                                          0x00000200L
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CAP2__NO_RO_ENABLED_P2P_PASSING_MASK                                       0x00000400L
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CAP2__LTR_SUPPORTED_MASK                                                   0x00000800L
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CAP2__TPH_CPLR_SUPPORTED_MASK                                              0x00003000L
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CAP2__OBFF_SUPPORTED_MASK                                                  0x000C0000L
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CAP2__EXTENDED_FMT_FIELD_SUPPORTED_MASK                                    0x00100000L
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CAP2__END_END_TLP_PREFIX_SUPPORTED_MASK                                    0x00200000L
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CAP2__MAX_END_END_TLP_PREFIXES_MASK                                        0x00C00000L
//BIF_CFG_DEV0_EPF2_0_DEVICE_CNTL2
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CNTL2__CPL_TIMEOUT_VALUE__SHIFT                                            0x0
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CNTL2__CPL_TIMEOUT_DIS__SHIFT                                              0x4
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CNTL2__ARI_FORWARDING_EN__SHIFT                                            0x5
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CNTL2__ATOMICOP_REQUEST_EN__SHIFT                                          0x6
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CNTL2__ATOMICOP_EGRESS_BLOCKING__SHIFT                                     0x7
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CNTL2__IDO_REQUEST_ENABLE__SHIFT                                           0x8
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CNTL2__IDO_COMPLETION_ENABLE__SHIFT                                        0x9
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CNTL2__LTR_EN__SHIFT                                                       0xa
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CNTL2__OBFF_EN__SHIFT                                                      0xd
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CNTL2__END_END_TLP_PREFIX_BLOCKING__SHIFT                                  0xf
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CNTL2__CPL_TIMEOUT_VALUE_MASK                                              0x000FL
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CNTL2__CPL_TIMEOUT_DIS_MASK                                                0x0010L
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CNTL2__ARI_FORWARDING_EN_MASK                                              0x0020L
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CNTL2__ATOMICOP_REQUEST_EN_MASK                                            0x0040L
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CNTL2__ATOMICOP_EGRESS_BLOCKING_MASK                                       0x0080L
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CNTL2__IDO_REQUEST_ENABLE_MASK                                             0x0100L
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CNTL2__IDO_COMPLETION_ENABLE_MASK                                          0x0200L
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CNTL2__LTR_EN_MASK                                                         0x0400L
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CNTL2__OBFF_EN_MASK                                                        0x6000L
#define BIF_CFG_DEV0_EPF2_0_DEVICE_CNTL2__END_END_TLP_PREFIX_BLOCKING_MASK                                    0x8000L
//BIF_CFG_DEV0_EPF2_0_DEVICE_STATUS2
#define BIF_CFG_DEV0_EPF2_0_DEVICE_STATUS2__RESERVED__SHIFT                                                   0x0
#define BIF_CFG_DEV0_EPF2_0_DEVICE_STATUS2__RESERVED_MASK                                                     0xFFFFL
//BIF_CFG_DEV0_EPF2_0_LINK_CAP2
#define BIF_CFG_DEV0_EPF2_0_LINK_CAP2__SUPPORTED_LINK_SPEED__SHIFT                                            0x1
#define BIF_CFG_DEV0_EPF2_0_LINK_CAP2__CROSSLINK_SUPPORTED__SHIFT                                             0x8
#define BIF_CFG_DEV0_EPF2_0_LINK_CAP2__RESERVED__SHIFT                                                        0x9
#define BIF_CFG_DEV0_EPF2_0_LINK_CAP2__SUPPORTED_LINK_SPEED_MASK                                              0x000000FEL
#define BIF_CFG_DEV0_EPF2_0_LINK_CAP2__CROSSLINK_SUPPORTED_MASK                                               0x00000100L
#define BIF_CFG_DEV0_EPF2_0_LINK_CAP2__RESERVED_MASK                                                          0xFFFFFE00L
//BIF_CFG_DEV0_EPF2_0_LINK_CNTL2
#define BIF_CFG_DEV0_EPF2_0_LINK_CNTL2__TARGET_LINK_SPEED__SHIFT                                              0x0
#define BIF_CFG_DEV0_EPF2_0_LINK_CNTL2__ENTER_COMPLIANCE__SHIFT                                               0x4
#define BIF_CFG_DEV0_EPF2_0_LINK_CNTL2__HW_AUTONOMOUS_SPEED_DISABLE__SHIFT                                    0x5
#define BIF_CFG_DEV0_EPF2_0_LINK_CNTL2__SELECTABLE_DEEMPHASIS__SHIFT                                          0x6
#define BIF_CFG_DEV0_EPF2_0_LINK_CNTL2__XMIT_MARGIN__SHIFT                                                    0x7
#define BIF_CFG_DEV0_EPF2_0_LINK_CNTL2__ENTER_MOD_COMPLIANCE__SHIFT                                           0xa
#define BIF_CFG_DEV0_EPF2_0_LINK_CNTL2__COMPLIANCE_SOS__SHIFT                                                 0xb
#define BIF_CFG_DEV0_EPF2_0_LINK_CNTL2__COMPLIANCE_DEEMPHASIS__SHIFT                                          0xc
#define BIF_CFG_DEV0_EPF2_0_LINK_CNTL2__TARGET_LINK_SPEED_MASK                                                0x000FL
#define BIF_CFG_DEV0_EPF2_0_LINK_CNTL2__ENTER_COMPLIANCE_MASK                                                 0x0010L
#define BIF_CFG_DEV0_EPF2_0_LINK_CNTL2__HW_AUTONOMOUS_SPEED_DISABLE_MASK                                      0x0020L
#define BIF_CFG_DEV0_EPF2_0_LINK_CNTL2__SELECTABLE_DEEMPHASIS_MASK                                            0x0040L
#define BIF_CFG_DEV0_EPF2_0_LINK_CNTL2__XMIT_MARGIN_MASK                                                      0x0380L
#define BIF_CFG_DEV0_EPF2_0_LINK_CNTL2__ENTER_MOD_COMPLIANCE_MASK                                             0x0400L
#define BIF_CFG_DEV0_EPF2_0_LINK_CNTL2__COMPLIANCE_SOS_MASK                                                   0x0800L
#define BIF_CFG_DEV0_EPF2_0_LINK_CNTL2__COMPLIANCE_DEEMPHASIS_MASK                                            0xF000L
//BIF_CFG_DEV0_EPF2_0_LINK_STATUS2
#define BIF_CFG_DEV0_EPF2_0_LINK_STATUS2__CUR_DEEMPHASIS_LEVEL__SHIFT                                         0x0
#define BIF_CFG_DEV0_EPF2_0_LINK_STATUS2__EQUALIZATION_COMPLETE__SHIFT                                        0x1
#define BIF_CFG_DEV0_EPF2_0_LINK_STATUS2__EQUALIZATION_PHASE1_SUCCESS__SHIFT                                  0x2
#define BIF_CFG_DEV0_EPF2_0_LINK_STATUS2__EQUALIZATION_PHASE2_SUCCESS__SHIFT                                  0x3
#define BIF_CFG_DEV0_EPF2_0_LINK_STATUS2__EQUALIZATION_PHASE3_SUCCESS__SHIFT                                  0x4
#define BIF_CFG_DEV0_EPF2_0_LINK_STATUS2__LINK_EQUALIZATION_REQUEST__SHIFT                                    0x5
#define BIF_CFG_DEV0_EPF2_0_LINK_STATUS2__CUR_DEEMPHASIS_LEVEL_MASK                                           0x0001L
#define BIF_CFG_DEV0_EPF2_0_LINK_STATUS2__EQUALIZATION_COMPLETE_MASK                                          0x0002L
#define BIF_CFG_DEV0_EPF2_0_LINK_STATUS2__EQUALIZATION_PHASE1_SUCCESS_MASK                                    0x0004L
#define BIF_CFG_DEV0_EPF2_0_LINK_STATUS2__EQUALIZATION_PHASE2_SUCCESS_MASK                                    0x0008L
#define BIF_CFG_DEV0_EPF2_0_LINK_STATUS2__EQUALIZATION_PHASE3_SUCCESS_MASK                                    0x0010L
#define BIF_CFG_DEV0_EPF2_0_LINK_STATUS2__LINK_EQUALIZATION_REQUEST_MASK                                      0x0020L
//BIF_CFG_DEV0_EPF2_0_SLOT_CAP2
#define BIF_CFG_DEV0_EPF2_0_SLOT_CAP2__RESERVED__SHIFT                                                        0x0
#define BIF_CFG_DEV0_EPF2_0_SLOT_CAP2__RESERVED_MASK                                                          0xFFFFFFFFL
//BIF_CFG_DEV0_EPF2_0_SLOT_CNTL2
#define BIF_CFG_DEV0_EPF2_0_SLOT_CNTL2__RESERVED__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF2_0_SLOT_CNTL2__RESERVED_MASK                                                         0xFFFFL
//BIF_CFG_DEV0_EPF2_0_SLOT_STATUS2
#define BIF_CFG_DEV0_EPF2_0_SLOT_STATUS2__RESERVED__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF2_0_SLOT_STATUS2__RESERVED_MASK                                                       0xFFFFL
//BIF_CFG_DEV0_EPF2_0_MSI_CAP_LIST
#define BIF_CFG_DEV0_EPF2_0_MSI_CAP_LIST__CAP_ID__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF2_0_MSI_CAP_LIST__NEXT_PTR__SHIFT                                                     0x8
#define BIF_CFG_DEV0_EPF2_0_MSI_CAP_LIST__CAP_ID_MASK                                                         0x00FFL
#define BIF_CFG_DEV0_EPF2_0_MSI_CAP_LIST__NEXT_PTR_MASK                                                       0xFF00L
//BIF_CFG_DEV0_EPF2_0_MSI_MSG_CNTL
#define BIF_CFG_DEV0_EPF2_0_MSI_MSG_CNTL__MSI_EN__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF2_0_MSI_MSG_CNTL__MSI_MULTI_CAP__SHIFT                                                0x1
#define BIF_CFG_DEV0_EPF2_0_MSI_MSG_CNTL__MSI_MULTI_EN__SHIFT                                                 0x4
#define BIF_CFG_DEV0_EPF2_0_MSI_MSG_CNTL__MSI_64BIT__SHIFT                                                    0x7
#define BIF_CFG_DEV0_EPF2_0_MSI_MSG_CNTL__MSI_PERVECTOR_MASKING_CAP__SHIFT                                    0x8
#define BIF_CFG_DEV0_EPF2_0_MSI_MSG_CNTL__MSI_EN_MASK                                                         0x0001L
#define BIF_CFG_DEV0_EPF2_0_MSI_MSG_CNTL__MSI_MULTI_CAP_MASK                                                  0x000EL
#define BIF_CFG_DEV0_EPF2_0_MSI_MSG_CNTL__MSI_MULTI_EN_MASK                                                   0x0070L
#define BIF_CFG_DEV0_EPF2_0_MSI_MSG_CNTL__MSI_64BIT_MASK                                                      0x0080L
#define BIF_CFG_DEV0_EPF2_0_MSI_MSG_CNTL__MSI_PERVECTOR_MASKING_CAP_MASK                                      0x0100L
//BIF_CFG_DEV0_EPF2_0_MSI_MSG_ADDR_LO
#define BIF_CFG_DEV0_EPF2_0_MSI_MSG_ADDR_LO__MSI_MSG_ADDR_LO__SHIFT                                           0x2
#define BIF_CFG_DEV0_EPF2_0_MSI_MSG_ADDR_LO__MSI_MSG_ADDR_LO_MASK                                             0xFFFFFFFCL
//BIF_CFG_DEV0_EPF2_0_MSI_MSG_ADDR_HI
#define BIF_CFG_DEV0_EPF2_0_MSI_MSG_ADDR_HI__MSI_MSG_ADDR_HI__SHIFT                                           0x0
#define BIF_CFG_DEV0_EPF2_0_MSI_MSG_ADDR_HI__MSI_MSG_ADDR_HI_MASK                                             0xFFFFFFFFL
//BIF_CFG_DEV0_EPF2_0_MSI_MSG_DATA
#define BIF_CFG_DEV0_EPF2_0_MSI_MSG_DATA__MSI_DATA__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF2_0_MSI_MSG_DATA__MSI_DATA_MASK                                                       0x0000FFFFL
//BIF_CFG_DEV0_EPF2_0_MSI_MASK
#define BIF_CFG_DEV0_EPF2_0_MSI_MASK__MSI_MASK__SHIFT                                                         0x0
#define BIF_CFG_DEV0_EPF2_0_MSI_MASK__MSI_MASK_MASK                                                           0xFFFFFFFFL
//BIF_CFG_DEV0_EPF2_0_MSI_MSG_DATA_64
#define BIF_CFG_DEV0_EPF2_0_MSI_MSG_DATA_64__MSI_DATA_64__SHIFT                                               0x0
#define BIF_CFG_DEV0_EPF2_0_MSI_MSG_DATA_64__MSI_DATA_64_MASK                                                 0x0000FFFFL
//BIF_CFG_DEV0_EPF2_0_MSI_MASK_64
#define BIF_CFG_DEV0_EPF2_0_MSI_MASK_64__MSI_MASK_64__SHIFT                                                   0x0
#define BIF_CFG_DEV0_EPF2_0_MSI_MASK_64__MSI_MASK_64_MASK                                                     0xFFFFFFFFL
//BIF_CFG_DEV0_EPF2_0_MSI_PENDING
#define BIF_CFG_DEV0_EPF2_0_MSI_PENDING__MSI_PENDING__SHIFT                                                   0x0
#define BIF_CFG_DEV0_EPF2_0_MSI_PENDING__MSI_PENDING_MASK                                                     0xFFFFFFFFL
//BIF_CFG_DEV0_EPF2_0_MSI_PENDING_64
#define BIF_CFG_DEV0_EPF2_0_MSI_PENDING_64__MSI_PENDING_64__SHIFT                                             0x0
#define BIF_CFG_DEV0_EPF2_0_MSI_PENDING_64__MSI_PENDING_64_MASK                                               0xFFFFFFFFL
//BIF_CFG_DEV0_EPF2_0_MSIX_CAP_LIST
#define BIF_CFG_DEV0_EPF2_0_MSIX_CAP_LIST__CAP_ID__SHIFT                                                      0x0
#define BIF_CFG_DEV0_EPF2_0_MSIX_CAP_LIST__NEXT_PTR__SHIFT                                                    0x8
#define BIF_CFG_DEV0_EPF2_0_MSIX_CAP_LIST__CAP_ID_MASK                                                        0x00FFL
#define BIF_CFG_DEV0_EPF2_0_MSIX_CAP_LIST__NEXT_PTR_MASK                                                      0xFF00L
//BIF_CFG_DEV0_EPF2_0_MSIX_MSG_CNTL
#define BIF_CFG_DEV0_EPF2_0_MSIX_MSG_CNTL__MSIX_TABLE_SIZE__SHIFT                                             0x0
#define BIF_CFG_DEV0_EPF2_0_MSIX_MSG_CNTL__MSIX_FUNC_MASK__SHIFT                                              0xe
#define BIF_CFG_DEV0_EPF2_0_MSIX_MSG_CNTL__MSIX_EN__SHIFT                                                     0xf
#define BIF_CFG_DEV0_EPF2_0_MSIX_MSG_CNTL__MSIX_TABLE_SIZE_MASK                                               0x07FFL
#define BIF_CFG_DEV0_EPF2_0_MSIX_MSG_CNTL__MSIX_FUNC_MASK_MASK                                                0x4000L
#define BIF_CFG_DEV0_EPF2_0_MSIX_MSG_CNTL__MSIX_EN_MASK                                                       0x8000L
//BIF_CFG_DEV0_EPF2_0_MSIX_TABLE
#define BIF_CFG_DEV0_EPF2_0_MSIX_TABLE__MSIX_TABLE_BIR__SHIFT                                                 0x0
#define BIF_CFG_DEV0_EPF2_0_MSIX_TABLE__MSIX_TABLE_OFFSET__SHIFT                                              0x3
#define BIF_CFG_DEV0_EPF2_0_MSIX_TABLE__MSIX_TABLE_BIR_MASK                                                   0x00000007L
#define BIF_CFG_DEV0_EPF2_0_MSIX_TABLE__MSIX_TABLE_OFFSET_MASK                                                0xFFFFFFF8L
//BIF_CFG_DEV0_EPF2_0_MSIX_PBA
#define BIF_CFG_DEV0_EPF2_0_MSIX_PBA__MSIX_PBA_BIR__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF2_0_MSIX_PBA__MSIX_PBA_OFFSET__SHIFT                                                  0x3
#define BIF_CFG_DEV0_EPF2_0_MSIX_PBA__MSIX_PBA_BIR_MASK                                                       0x00000007L
#define BIF_CFG_DEV0_EPF2_0_MSIX_PBA__MSIX_PBA_OFFSET_MASK                                                    0xFFFFFFF8L
//BIF_CFG_DEV0_EPF2_0_SATA_CAP_0
#define BIF_CFG_DEV0_EPF2_0_SATA_CAP_0__CAP_ID__SHIFT                                                         0x0
#define BIF_CFG_DEV0_EPF2_0_SATA_CAP_0__NEXT_PTR__SHIFT                                                       0x8
#define BIF_CFG_DEV0_EPF2_0_SATA_CAP_0__SATA_CAP_MINOR_REV__SHIFT                                             0x10
#define BIF_CFG_DEV0_EPF2_0_SATA_CAP_0__SATA_CAP_MAJOR_REV__SHIFT                                             0x14
#define BIF_CFG_DEV0_EPF2_0_SATA_CAP_0__SATA_CAP_RESERVED1__SHIFT                                             0x18
#define BIF_CFG_DEV0_EPF2_0_SATA_CAP_0__CAP_ID_MASK                                                           0x000000FFL
#define BIF_CFG_DEV0_EPF2_0_SATA_CAP_0__NEXT_PTR_MASK                                                         0x0000FF00L
#define BIF_CFG_DEV0_EPF2_0_SATA_CAP_0__SATA_CAP_MINOR_REV_MASK                                               0x000F0000L
#define BIF_CFG_DEV0_EPF2_0_SATA_CAP_0__SATA_CAP_MAJOR_REV_MASK                                               0x00F00000L
#define BIF_CFG_DEV0_EPF2_0_SATA_CAP_0__SATA_CAP_RESERVED1_MASK                                               0xFF000000L
//BIF_CFG_DEV0_EPF2_0_SATA_CAP_1
#define BIF_CFG_DEV0_EPF2_0_SATA_CAP_1__SATA_CAP_BAR_LOC__SHIFT                                               0x0
#define BIF_CFG_DEV0_EPF2_0_SATA_CAP_1__SATA_CAP_BAR_OFFSET__SHIFT                                            0x4
#define BIF_CFG_DEV0_EPF2_0_SATA_CAP_1__SATA_CAP_RESERVED2__SHIFT                                             0x18
#define BIF_CFG_DEV0_EPF2_0_SATA_CAP_1__SATA_CAP_BAR_LOC_MASK                                                 0x0000000FL
#define BIF_CFG_DEV0_EPF2_0_SATA_CAP_1__SATA_CAP_BAR_OFFSET_MASK                                              0x00FFFFF0L
#define BIF_CFG_DEV0_EPF2_0_SATA_CAP_1__SATA_CAP_RESERVED2_MASK                                               0xFF000000L
//BIF_CFG_DEV0_EPF2_0_SATA_IDP_INDEX
#define BIF_CFG_DEV0_EPF2_0_SATA_IDP_INDEX__IDP_RESERVED1__SHIFT                                              0x0
#define BIF_CFG_DEV0_EPF2_0_SATA_IDP_INDEX__IDP_INDEX__SHIFT                                                  0x2
#define BIF_CFG_DEV0_EPF2_0_SATA_IDP_INDEX__IDP_RESERVED2__SHIFT                                              0xc
#define BIF_CFG_DEV0_EPF2_0_SATA_IDP_INDEX__IDP_RESERVED1_MASK                                                0x00000003L
#define BIF_CFG_DEV0_EPF2_0_SATA_IDP_INDEX__IDP_INDEX_MASK                                                    0x00000FFCL
#define BIF_CFG_DEV0_EPF2_0_SATA_IDP_INDEX__IDP_RESERVED2_MASK                                                0xFFFFF000L
//BIF_CFG_DEV0_EPF2_0_SATA_IDP_DATA
#define BIF_CFG_DEV0_EPF2_0_SATA_IDP_DATA__IDP_DATA__SHIFT                                                    0x0
#define BIF_CFG_DEV0_EPF2_0_SATA_IDP_DATA__IDP_DATA_MASK                                                      0xFFFFFFFFL
//BIF_CFG_DEV0_EPF2_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF2_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_ID__SHIFT                                  0x0
#define BIF_CFG_DEV0_EPF2_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_VER__SHIFT                                 0x10
#define BIF_CFG_DEV0_EPF2_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__NEXT_PTR__SHIFT                                0x14
#define BIF_CFG_DEV0_EPF2_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_ID_MASK                                    0x0000FFFFL
#define BIF_CFG_DEV0_EPF2_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_VER_MASK                                   0x000F0000L
#define BIF_CFG_DEV0_EPF2_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__NEXT_PTR_MASK                                  0xFFF00000L
//BIF_CFG_DEV0_EPF2_0_PCIE_VENDOR_SPECIFIC_HDR
#define BIF_CFG_DEV0_EPF2_0_PCIE_VENDOR_SPECIFIC_HDR__VSEC_ID__SHIFT                                          0x0
#define BIF_CFG_DEV0_EPF2_0_PCIE_VENDOR_SPECIFIC_HDR__VSEC_REV__SHIFT                                         0x10
#define BIF_CFG_DEV0_EPF2_0_PCIE_VENDOR_SPECIFIC_HDR__VSEC_LENGTH__SHIFT                                      0x14
#define BIF_CFG_DEV0_EPF2_0_PCIE_VENDOR_SPECIFIC_HDR__VSEC_ID_MASK                                            0x0000FFFFL
#define BIF_CFG_DEV0_EPF2_0_PCIE_VENDOR_SPECIFIC_HDR__VSEC_REV_MASK                                           0x000F0000L
#define BIF_CFG_DEV0_EPF2_0_PCIE_VENDOR_SPECIFIC_HDR__VSEC_LENGTH_MASK                                        0xFFF00000L
//BIF_CFG_DEV0_EPF2_0_PCIE_VENDOR_SPECIFIC1
#define BIF_CFG_DEV0_EPF2_0_PCIE_VENDOR_SPECIFIC1__SCRATCH__SHIFT                                             0x0
#define BIF_CFG_DEV0_EPF2_0_PCIE_VENDOR_SPECIFIC1__SCRATCH_MASK                                               0xFFFFFFFFL
//BIF_CFG_DEV0_EPF2_0_PCIE_VENDOR_SPECIFIC2
#define BIF_CFG_DEV0_EPF2_0_PCIE_VENDOR_SPECIFIC2__SCRATCH__SHIFT                                             0x0
#define BIF_CFG_DEV0_EPF2_0_PCIE_VENDOR_SPECIFIC2__SCRATCH_MASK                                               0xFFFFFFFFL
//BIF_CFG_DEV0_EPF2_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF2_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_ID__SHIFT                                      0x0
#define BIF_CFG_DEV0_EPF2_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_VER__SHIFT                                     0x10
#define BIF_CFG_DEV0_EPF2_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__NEXT_PTR__SHIFT                                    0x14
#define BIF_CFG_DEV0_EPF2_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_ID_MASK                                        0x0000FFFFL
#define BIF_CFG_DEV0_EPF2_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_VER_MASK                                       0x000F0000L
#define BIF_CFG_DEV0_EPF2_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__NEXT_PTR_MASK                                      0xFFF00000L
//BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_STATUS
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_STATUS__DLP_ERR_STATUS__SHIFT                                     0x4
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_STATUS__SURPDN_ERR_STATUS__SHIFT                                  0x5
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_STATUS__PSN_ERR_STATUS__SHIFT                                     0xc
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_STATUS__FC_ERR_STATUS__SHIFT                                      0xd
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_STATUS__CPL_TIMEOUT_STATUS__SHIFT                                 0xe
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_STATUS__CPL_ABORT_ERR_STATUS__SHIFT                               0xf
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_STATUS__UNEXP_CPL_STATUS__SHIFT                                   0x10
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_STATUS__RCV_OVFL_STATUS__SHIFT                                    0x11
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_STATUS__MAL_TLP_STATUS__SHIFT                                     0x12
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_STATUS__ECRC_ERR_STATUS__SHIFT                                    0x13
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_STATUS__UNSUPP_REQ_ERR_STATUS__SHIFT                              0x14
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_STATUS__ACS_VIOLATION_STATUS__SHIFT                               0x15
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_STATUS__UNCORR_INT_ERR_STATUS__SHIFT                              0x16
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_STATUS__MC_BLOCKED_TLP_STATUS__SHIFT                              0x17
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_STATUS__ATOMICOP_EGRESS_BLOCKED_STATUS__SHIFT                     0x18
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_STATUS__TLP_PREFIX_BLOCKED_ERR_STATUS__SHIFT                      0x19
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_STATUS__DLP_ERR_STATUS_MASK                                       0x00000010L
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_STATUS__SURPDN_ERR_STATUS_MASK                                    0x00000020L
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_STATUS__PSN_ERR_STATUS_MASK                                       0x00001000L
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_STATUS__FC_ERR_STATUS_MASK                                        0x00002000L
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_STATUS__CPL_TIMEOUT_STATUS_MASK                                   0x00004000L
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_STATUS__CPL_ABORT_ERR_STATUS_MASK                                 0x00008000L
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_STATUS__UNEXP_CPL_STATUS_MASK                                     0x00010000L
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_STATUS__RCV_OVFL_STATUS_MASK                                      0x00020000L
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_STATUS__MAL_TLP_STATUS_MASK                                       0x00040000L
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_STATUS__ECRC_ERR_STATUS_MASK                                      0x00080000L
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_STATUS__UNSUPP_REQ_ERR_STATUS_MASK                                0x00100000L
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_STATUS__ACS_VIOLATION_STATUS_MASK                                 0x00200000L
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_STATUS__UNCORR_INT_ERR_STATUS_MASK                                0x00400000L
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_STATUS__MC_BLOCKED_TLP_STATUS_MASK                                0x00800000L
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_STATUS__ATOMICOP_EGRESS_BLOCKED_STATUS_MASK                       0x01000000L
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_STATUS__TLP_PREFIX_BLOCKED_ERR_STATUS_MASK                        0x02000000L
//BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_MASK
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_MASK__DLP_ERR_MASK__SHIFT                                         0x4
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_MASK__SURPDN_ERR_MASK__SHIFT                                      0x5
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_MASK__PSN_ERR_MASK__SHIFT                                         0xc
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_MASK__FC_ERR_MASK__SHIFT                                          0xd
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_MASK__CPL_TIMEOUT_MASK__SHIFT                                     0xe
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_MASK__CPL_ABORT_ERR_MASK__SHIFT                                   0xf
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_MASK__UNEXP_CPL_MASK__SHIFT                                       0x10
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_MASK__RCV_OVFL_MASK__SHIFT                                        0x11
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_MASK__MAL_TLP_MASK__SHIFT                                         0x12
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_MASK__ECRC_ERR_MASK__SHIFT                                        0x13
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_MASK__UNSUPP_REQ_ERR_MASK__SHIFT                                  0x14
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_MASK__ACS_VIOLATION_MASK__SHIFT                                   0x15
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_MASK__UNCORR_INT_ERR_MASK__SHIFT                                  0x16
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_MASK__MC_BLOCKED_TLP_MASK__SHIFT                                  0x17
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_MASK__ATOMICOP_EGRESS_BLOCKED_MASK__SHIFT                         0x18
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_MASK__TLP_PREFIX_BLOCKED_ERR_MASK__SHIFT                          0x19
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_MASK__DLP_ERR_MASK_MASK                                           0x00000010L
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_MASK__SURPDN_ERR_MASK_MASK                                        0x00000020L
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_MASK__PSN_ERR_MASK_MASK                                           0x00001000L
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_MASK__FC_ERR_MASK_MASK                                            0x00002000L
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_MASK__CPL_TIMEOUT_MASK_MASK                                       0x00004000L
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_MASK__CPL_ABORT_ERR_MASK_MASK                                     0x00008000L
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_MASK__UNEXP_CPL_MASK_MASK                                         0x00010000L
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_MASK__RCV_OVFL_MASK_MASK                                          0x00020000L
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_MASK__MAL_TLP_MASK_MASK                                           0x00040000L
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_MASK__ECRC_ERR_MASK_MASK                                          0x00080000L
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_MASK__UNSUPP_REQ_ERR_MASK_MASK                                    0x00100000L
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_MASK__ACS_VIOLATION_MASK_MASK                                     0x00200000L
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_MASK__UNCORR_INT_ERR_MASK_MASK                                    0x00400000L
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_MASK__MC_BLOCKED_TLP_MASK_MASK                                    0x00800000L
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_MASK__ATOMICOP_EGRESS_BLOCKED_MASK_MASK                           0x01000000L
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_MASK__TLP_PREFIX_BLOCKED_ERR_MASK_MASK                            0x02000000L
//BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_SEVERITY
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_SEVERITY__DLP_ERR_SEVERITY__SHIFT                                 0x4
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_SEVERITY__SURPDN_ERR_SEVERITY__SHIFT                              0x5
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_SEVERITY__PSN_ERR_SEVERITY__SHIFT                                 0xc
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_SEVERITY__FC_ERR_SEVERITY__SHIFT                                  0xd
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_SEVERITY__CPL_TIMEOUT_SEVERITY__SHIFT                             0xe
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_SEVERITY__CPL_ABORT_ERR_SEVERITY__SHIFT                           0xf
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_SEVERITY__UNEXP_CPL_SEVERITY__SHIFT                               0x10
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_SEVERITY__RCV_OVFL_SEVERITY__SHIFT                                0x11
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_SEVERITY__MAL_TLP_SEVERITY__SHIFT                                 0x12
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_SEVERITY__ECRC_ERR_SEVERITY__SHIFT                                0x13
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_SEVERITY__UNSUPP_REQ_ERR_SEVERITY__SHIFT                          0x14
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_SEVERITY__ACS_VIOLATION_SEVERITY__SHIFT                           0x15
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_SEVERITY__UNCORR_INT_ERR_SEVERITY__SHIFT                          0x16
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_SEVERITY__MC_BLOCKED_TLP_SEVERITY__SHIFT                          0x17
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_SEVERITY__ATOMICOP_EGRESS_BLOCKED_SEVERITY__SHIFT                 0x18
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_SEVERITY__TLP_PREFIX_BLOCKED_ERR_SEVERITY__SHIFT                  0x19
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_SEVERITY__DLP_ERR_SEVERITY_MASK                                   0x00000010L
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_SEVERITY__SURPDN_ERR_SEVERITY_MASK                                0x00000020L
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_SEVERITY__PSN_ERR_SEVERITY_MASK                                   0x00001000L
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_SEVERITY__FC_ERR_SEVERITY_MASK                                    0x00002000L
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_SEVERITY__CPL_TIMEOUT_SEVERITY_MASK                               0x00004000L
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_SEVERITY__CPL_ABORT_ERR_SEVERITY_MASK                             0x00008000L
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_SEVERITY__UNEXP_CPL_SEVERITY_MASK                                 0x00010000L
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_SEVERITY__RCV_OVFL_SEVERITY_MASK                                  0x00020000L
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_SEVERITY__MAL_TLP_SEVERITY_MASK                                   0x00040000L
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_SEVERITY__ECRC_ERR_SEVERITY_MASK                                  0x00080000L
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_SEVERITY__UNSUPP_REQ_ERR_SEVERITY_MASK                            0x00100000L
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_SEVERITY__ACS_VIOLATION_SEVERITY_MASK                             0x00200000L
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_SEVERITY__UNCORR_INT_ERR_SEVERITY_MASK                            0x00400000L
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_SEVERITY__MC_BLOCKED_TLP_SEVERITY_MASK                            0x00800000L
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_SEVERITY__ATOMICOP_EGRESS_BLOCKED_SEVERITY_MASK                   0x01000000L
#define BIF_CFG_DEV0_EPF2_0_PCIE_UNCORR_ERR_SEVERITY__TLP_PREFIX_BLOCKED_ERR_SEVERITY_MASK                    0x02000000L
//BIF_CFG_DEV0_EPF2_0_PCIE_CORR_ERR_STATUS
#define BIF_CFG_DEV0_EPF2_0_PCIE_CORR_ERR_STATUS__RCV_ERR_STATUS__SHIFT                                       0x0
#define BIF_CFG_DEV0_EPF2_0_PCIE_CORR_ERR_STATUS__BAD_TLP_STATUS__SHIFT                                       0x6
#define BIF_CFG_DEV0_EPF2_0_PCIE_CORR_ERR_STATUS__BAD_DLLP_STATUS__SHIFT                                      0x7
#define BIF_CFG_DEV0_EPF2_0_PCIE_CORR_ERR_STATUS__REPLAY_NUM_ROLLOVER_STATUS__SHIFT                           0x8
#define BIF_CFG_DEV0_EPF2_0_PCIE_CORR_ERR_STATUS__REPLAY_TIMER_TIMEOUT_STATUS__SHIFT                          0xc
#define BIF_CFG_DEV0_EPF2_0_PCIE_CORR_ERR_STATUS__ADVISORY_NONFATAL_ERR_STATUS__SHIFT                         0xd
#define BIF_CFG_DEV0_EPF2_0_PCIE_CORR_ERR_STATUS__CORR_INT_ERR_STATUS__SHIFT                                  0xe
#define BIF_CFG_DEV0_EPF2_0_PCIE_CORR_ERR_STATUS__HDR_LOG_OVFL_STATUS__SHIFT                                  0xf
#define BIF_CFG_DEV0_EPF2_0_PCIE_CORR_ERR_STATUS__RCV_ERR_STATUS_MASK                                         0x00000001L
#define BIF_CFG_DEV0_EPF2_0_PCIE_CORR_ERR_STATUS__BAD_TLP_STATUS_MASK                                         0x00000040L
#define BIF_CFG_DEV0_EPF2_0_PCIE_CORR_ERR_STATUS__BAD_DLLP_STATUS_MASK                                        0x00000080L
#define BIF_CFG_DEV0_EPF2_0_PCIE_CORR_ERR_STATUS__REPLAY_NUM_ROLLOVER_STATUS_MASK                             0x00000100L
#define BIF_CFG_DEV0_EPF2_0_PCIE_CORR_ERR_STATUS__REPLAY_TIMER_TIMEOUT_STATUS_MASK                            0x00001000L
#define BIF_CFG_DEV0_EPF2_0_PCIE_CORR_ERR_STATUS__ADVISORY_NONFATAL_ERR_STATUS_MASK                           0x00002000L
#define BIF_CFG_DEV0_EPF2_0_PCIE_CORR_ERR_STATUS__CORR_INT_ERR_STATUS_MASK                                    0x00004000L
#define BIF_CFG_DEV0_EPF2_0_PCIE_CORR_ERR_STATUS__HDR_LOG_OVFL_STATUS_MASK                                    0x00008000L
//BIF_CFG_DEV0_EPF2_0_PCIE_CORR_ERR_MASK
#define BIF_CFG_DEV0_EPF2_0_PCIE_CORR_ERR_MASK__RCV_ERR_MASK__SHIFT                                           0x0
#define BIF_CFG_DEV0_EPF2_0_PCIE_CORR_ERR_MASK__BAD_TLP_MASK__SHIFT                                           0x6
#define BIF_CFG_DEV0_EPF2_0_PCIE_CORR_ERR_MASK__BAD_DLLP_MASK__SHIFT                                          0x7
#define BIF_CFG_DEV0_EPF2_0_PCIE_CORR_ERR_MASK__REPLAY_NUM_ROLLOVER_MASK__SHIFT                               0x8
#define BIF_CFG_DEV0_EPF2_0_PCIE_CORR_ERR_MASK__REPLAY_TIMER_TIMEOUT_MASK__SHIFT                              0xc
#define BIF_CFG_DEV0_EPF2_0_PCIE_CORR_ERR_MASK__ADVISORY_NONFATAL_ERR_MASK__SHIFT                             0xd
#define BIF_CFG_DEV0_EPF2_0_PCIE_CORR_ERR_MASK__CORR_INT_ERR_MASK__SHIFT                                      0xe
#define BIF_CFG_DEV0_EPF2_0_PCIE_CORR_ERR_MASK__HDR_LOG_OVFL_MASK__SHIFT                                      0xf
#define BIF_CFG_DEV0_EPF2_0_PCIE_CORR_ERR_MASK__RCV_ERR_MASK_MASK                                             0x00000001L
#define BIF_CFG_DEV0_EPF2_0_PCIE_CORR_ERR_MASK__BAD_TLP_MASK_MASK                                             0x00000040L
#define BIF_CFG_DEV0_EPF2_0_PCIE_CORR_ERR_MASK__BAD_DLLP_MASK_MASK                                            0x00000080L
#define BIF_CFG_DEV0_EPF2_0_PCIE_CORR_ERR_MASK__REPLAY_NUM_ROLLOVER_MASK_MASK                                 0x00000100L
#define BIF_CFG_DEV0_EPF2_0_PCIE_CORR_ERR_MASK__REPLAY_TIMER_TIMEOUT_MASK_MASK                                0x00001000L
#define BIF_CFG_DEV0_EPF2_0_PCIE_CORR_ERR_MASK__ADVISORY_NONFATAL_ERR_MASK_MASK                               0x00002000L
#define BIF_CFG_DEV0_EPF2_0_PCIE_CORR_ERR_MASK__CORR_INT_ERR_MASK_MASK                                        0x00004000L
#define BIF_CFG_DEV0_EPF2_0_PCIE_CORR_ERR_MASK__HDR_LOG_OVFL_MASK_MASK                                        0x00008000L
//BIF_CFG_DEV0_EPF2_0_PCIE_ADV_ERR_CAP_CNTL
#define BIF_CFG_DEV0_EPF2_0_PCIE_ADV_ERR_CAP_CNTL__FIRST_ERR_PTR__SHIFT                                       0x0
#define BIF_CFG_DEV0_EPF2_0_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_CAP__SHIFT                                        0x5
#define BIF_CFG_DEV0_EPF2_0_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_EN__SHIFT                                         0x6
#define BIF_CFG_DEV0_EPF2_0_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_CAP__SHIFT                                      0x7
#define BIF_CFG_DEV0_EPF2_0_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_EN__SHIFT                                       0x8
#define BIF_CFG_DEV0_EPF2_0_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_CAP__SHIFT                                  0x9
#define BIF_CFG_DEV0_EPF2_0_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_EN__SHIFT                                   0xa
#define BIF_CFG_DEV0_EPF2_0_PCIE_ADV_ERR_CAP_CNTL__TLP_PREFIX_LOG_PRESENT__SHIFT                              0xb
#define BIF_CFG_DEV0_EPF2_0_PCIE_ADV_ERR_CAP_CNTL__FIRST_ERR_PTR_MASK                                         0x0000001FL
#define BIF_CFG_DEV0_EPF2_0_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_CAP_MASK                                          0x00000020L
#define BIF_CFG_DEV0_EPF2_0_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_EN_MASK                                           0x00000040L
#define BIF_CFG_DEV0_EPF2_0_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_CAP_MASK                                        0x00000080L
#define BIF_CFG_DEV0_EPF2_0_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_EN_MASK                                         0x00000100L
#define BIF_CFG_DEV0_EPF2_0_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_CAP_MASK                                    0x00000200L
#define BIF_CFG_DEV0_EPF2_0_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_EN_MASK                                     0x00000400L
#define BIF_CFG_DEV0_EPF2_0_PCIE_ADV_ERR_CAP_CNTL__TLP_PREFIX_LOG_PRESENT_MASK                                0x00000800L
//BIF_CFG_DEV0_EPF2_0_PCIE_HDR_LOG0
#define BIF_CFG_DEV0_EPF2_0_PCIE_HDR_LOG0__TLP_HDR__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF2_0_PCIE_HDR_LOG0__TLP_HDR_MASK                                                       0xFFFFFFFFL
//BIF_CFG_DEV0_EPF2_0_PCIE_HDR_LOG1
#define BIF_CFG_DEV0_EPF2_0_PCIE_HDR_LOG1__TLP_HDR__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF2_0_PCIE_HDR_LOG1__TLP_HDR_MASK                                                       0xFFFFFFFFL
//BIF_CFG_DEV0_EPF2_0_PCIE_HDR_LOG2
#define BIF_CFG_DEV0_EPF2_0_PCIE_HDR_LOG2__TLP_HDR__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF2_0_PCIE_HDR_LOG2__TLP_HDR_MASK                                                       0xFFFFFFFFL
//BIF_CFG_DEV0_EPF2_0_PCIE_HDR_LOG3
#define BIF_CFG_DEV0_EPF2_0_PCIE_HDR_LOG3__TLP_HDR__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF2_0_PCIE_HDR_LOG3__TLP_HDR_MASK                                                       0xFFFFFFFFL
//BIF_CFG_DEV0_EPF2_0_PCIE_TLP_PREFIX_LOG0
#define BIF_CFG_DEV0_EPF2_0_PCIE_TLP_PREFIX_LOG0__TLP_PREFIX__SHIFT                                           0x0
#define BIF_CFG_DEV0_EPF2_0_PCIE_TLP_PREFIX_LOG0__TLP_PREFIX_MASK                                             0xFFFFFFFFL
//BIF_CFG_DEV0_EPF2_0_PCIE_TLP_PREFIX_LOG1
#define BIF_CFG_DEV0_EPF2_0_PCIE_TLP_PREFIX_LOG1__TLP_PREFIX__SHIFT                                           0x0
#define BIF_CFG_DEV0_EPF2_0_PCIE_TLP_PREFIX_LOG1__TLP_PREFIX_MASK                                             0xFFFFFFFFL
//BIF_CFG_DEV0_EPF2_0_PCIE_TLP_PREFIX_LOG2
#define BIF_CFG_DEV0_EPF2_0_PCIE_TLP_PREFIX_LOG2__TLP_PREFIX__SHIFT                                           0x0
#define BIF_CFG_DEV0_EPF2_0_PCIE_TLP_PREFIX_LOG2__TLP_PREFIX_MASK                                             0xFFFFFFFFL
//BIF_CFG_DEV0_EPF2_0_PCIE_TLP_PREFIX_LOG3
#define BIF_CFG_DEV0_EPF2_0_PCIE_TLP_PREFIX_LOG3__TLP_PREFIX__SHIFT                                           0x0
#define BIF_CFG_DEV0_EPF2_0_PCIE_TLP_PREFIX_LOG3__TLP_PREFIX_MASK                                             0xFFFFFFFFL
//BIF_CFG_DEV0_EPF2_0_PCIE_BAR_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF2_0_PCIE_BAR_ENH_CAP_LIST__CAP_ID__SHIFT                                              0x0
#define BIF_CFG_DEV0_EPF2_0_PCIE_BAR_ENH_CAP_LIST__CAP_VER__SHIFT                                             0x10
#define BIF_CFG_DEV0_EPF2_0_PCIE_BAR_ENH_CAP_LIST__NEXT_PTR__SHIFT                                            0x14
#define BIF_CFG_DEV0_EPF2_0_PCIE_BAR_ENH_CAP_LIST__CAP_ID_MASK                                                0x0000FFFFL
#define BIF_CFG_DEV0_EPF2_0_PCIE_BAR_ENH_CAP_LIST__CAP_VER_MASK                                               0x000F0000L
#define BIF_CFG_DEV0_EPF2_0_PCIE_BAR_ENH_CAP_LIST__NEXT_PTR_MASK                                              0xFFF00000L
//BIF_CFG_DEV0_EPF2_0_PCIE_BAR1_CAP
#define BIF_CFG_DEV0_EPF2_0_PCIE_BAR1_CAP__BAR_SIZE_SUPPORTED__SHIFT                                          0x4
#define BIF_CFG_DEV0_EPF2_0_PCIE_BAR1_CAP__BAR_SIZE_SUPPORTED_MASK                                            0x00FFFFF0L
//BIF_CFG_DEV0_EPF2_0_PCIE_BAR1_CNTL
#define BIF_CFG_DEV0_EPF2_0_PCIE_BAR1_CNTL__BAR_INDEX__SHIFT                                                  0x0
#define BIF_CFG_DEV0_EPF2_0_PCIE_BAR1_CNTL__BAR_TOTAL_NUM__SHIFT                                              0x5
#define BIF_CFG_DEV0_EPF2_0_PCIE_BAR1_CNTL__BAR_SIZE__SHIFT                                                   0x8
#define BIF_CFG_DEV0_EPF2_0_PCIE_BAR1_CNTL__BAR_INDEX_MASK                                                    0x0007L
#define BIF_CFG_DEV0_EPF2_0_PCIE_BAR1_CNTL__BAR_TOTAL_NUM_MASK                                                0x00E0L
#define BIF_CFG_DEV0_EPF2_0_PCIE_BAR1_CNTL__BAR_SIZE_MASK                                                     0x1F00L
//BIF_CFG_DEV0_EPF2_0_PCIE_BAR2_CAP
#define BIF_CFG_DEV0_EPF2_0_PCIE_BAR2_CAP__BAR_SIZE_SUPPORTED__SHIFT                                          0x4
#define BIF_CFG_DEV0_EPF2_0_PCIE_BAR2_CAP__BAR_SIZE_SUPPORTED_MASK                                            0x00FFFFF0L
//BIF_CFG_DEV0_EPF2_0_PCIE_BAR2_CNTL
#define BIF_CFG_DEV0_EPF2_0_PCIE_BAR2_CNTL__BAR_INDEX__SHIFT                                                  0x0
#define BIF_CFG_DEV0_EPF2_0_PCIE_BAR2_CNTL__BAR_TOTAL_NUM__SHIFT                                              0x5
#define BIF_CFG_DEV0_EPF2_0_PCIE_BAR2_CNTL__BAR_SIZE__SHIFT                                                   0x8
#define BIF_CFG_DEV0_EPF2_0_PCIE_BAR2_CNTL__BAR_INDEX_MASK                                                    0x0007L
#define BIF_CFG_DEV0_EPF2_0_PCIE_BAR2_CNTL__BAR_TOTAL_NUM_MASK                                                0x00E0L
#define BIF_CFG_DEV0_EPF2_0_PCIE_BAR2_CNTL__BAR_SIZE_MASK                                                     0x1F00L
//BIF_CFG_DEV0_EPF2_0_PCIE_BAR3_CAP
#define BIF_CFG_DEV0_EPF2_0_PCIE_BAR3_CAP__BAR_SIZE_SUPPORTED__SHIFT                                          0x4
#define BIF_CFG_DEV0_EPF2_0_PCIE_BAR3_CAP__BAR_SIZE_SUPPORTED_MASK                                            0x00FFFFF0L
//BIF_CFG_DEV0_EPF2_0_PCIE_BAR3_CNTL
#define BIF_CFG_DEV0_EPF2_0_PCIE_BAR3_CNTL__BAR_INDEX__SHIFT                                                  0x0
#define BIF_CFG_DEV0_EPF2_0_PCIE_BAR3_CNTL__BAR_TOTAL_NUM__SHIFT                                              0x5
#define BIF_CFG_DEV0_EPF2_0_PCIE_BAR3_CNTL__BAR_SIZE__SHIFT                                                   0x8
#define BIF_CFG_DEV0_EPF2_0_PCIE_BAR3_CNTL__BAR_INDEX_MASK                                                    0x0007L
#define BIF_CFG_DEV0_EPF2_0_PCIE_BAR3_CNTL__BAR_TOTAL_NUM_MASK                                                0x00E0L
#define BIF_CFG_DEV0_EPF2_0_PCIE_BAR3_CNTL__BAR_SIZE_MASK                                                     0x1F00L
//BIF_CFG_DEV0_EPF2_0_PCIE_BAR4_CAP
#define BIF_CFG_DEV0_EPF2_0_PCIE_BAR4_CAP__BAR_SIZE_SUPPORTED__SHIFT                                          0x4
#define BIF_CFG_DEV0_EPF2_0_PCIE_BAR4_CAP__BAR_SIZE_SUPPORTED_MASK                                            0x00FFFFF0L
//BIF_CFG_DEV0_EPF2_0_PCIE_BAR4_CNTL
#define BIF_CFG_DEV0_EPF2_0_PCIE_BAR4_CNTL__BAR_INDEX__SHIFT                                                  0x0
#define BIF_CFG_DEV0_EPF2_0_PCIE_BAR4_CNTL__BAR_TOTAL_NUM__SHIFT                                              0x5
#define BIF_CFG_DEV0_EPF2_0_PCIE_BAR4_CNTL__BAR_SIZE__SHIFT                                                   0x8
#define BIF_CFG_DEV0_EPF2_0_PCIE_BAR4_CNTL__BAR_INDEX_MASK                                                    0x0007L
#define BIF_CFG_DEV0_EPF2_0_PCIE_BAR4_CNTL__BAR_TOTAL_NUM_MASK                                                0x00E0L
#define BIF_CFG_DEV0_EPF2_0_PCIE_BAR4_CNTL__BAR_SIZE_MASK                                                     0x1F00L
//BIF_CFG_DEV0_EPF2_0_PCIE_BAR5_CAP
#define BIF_CFG_DEV0_EPF2_0_PCIE_BAR5_CAP__BAR_SIZE_SUPPORTED__SHIFT                                          0x4
#define BIF_CFG_DEV0_EPF2_0_PCIE_BAR5_CAP__BAR_SIZE_SUPPORTED_MASK                                            0x00FFFFF0L
//BIF_CFG_DEV0_EPF2_0_PCIE_BAR5_CNTL
#define BIF_CFG_DEV0_EPF2_0_PCIE_BAR5_CNTL__BAR_INDEX__SHIFT                                                  0x0
#define BIF_CFG_DEV0_EPF2_0_PCIE_BAR5_CNTL__BAR_TOTAL_NUM__SHIFT                                              0x5
#define BIF_CFG_DEV0_EPF2_0_PCIE_BAR5_CNTL__BAR_SIZE__SHIFT                                                   0x8
#define BIF_CFG_DEV0_EPF2_0_PCIE_BAR5_CNTL__BAR_INDEX_MASK                                                    0x0007L
#define BIF_CFG_DEV0_EPF2_0_PCIE_BAR5_CNTL__BAR_TOTAL_NUM_MASK                                                0x00E0L
#define BIF_CFG_DEV0_EPF2_0_PCIE_BAR5_CNTL__BAR_SIZE_MASK                                                     0x1F00L
//BIF_CFG_DEV0_EPF2_0_PCIE_BAR6_CAP
#define BIF_CFG_DEV0_EPF2_0_PCIE_BAR6_CAP__BAR_SIZE_SUPPORTED__SHIFT                                          0x4
#define BIF_CFG_DEV0_EPF2_0_PCIE_BAR6_CAP__BAR_SIZE_SUPPORTED_MASK                                            0x00FFFFF0L
//BIF_CFG_DEV0_EPF2_0_PCIE_BAR6_CNTL
#define BIF_CFG_DEV0_EPF2_0_PCIE_BAR6_CNTL__BAR_INDEX__SHIFT                                                  0x0
#define BIF_CFG_DEV0_EPF2_0_PCIE_BAR6_CNTL__BAR_TOTAL_NUM__SHIFT                                              0x5
#define BIF_CFG_DEV0_EPF2_0_PCIE_BAR6_CNTL__BAR_SIZE__SHIFT                                                   0x8
#define BIF_CFG_DEV0_EPF2_0_PCIE_BAR6_CNTL__BAR_INDEX_MASK                                                    0x0007L
#define BIF_CFG_DEV0_EPF2_0_PCIE_BAR6_CNTL__BAR_TOTAL_NUM_MASK                                                0x00E0L
#define BIF_CFG_DEV0_EPF2_0_PCIE_BAR6_CNTL__BAR_SIZE_MASK                                                     0x1F00L
//BIF_CFG_DEV0_EPF2_0_PCIE_PWR_BUDGET_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF2_0_PCIE_PWR_BUDGET_ENH_CAP_LIST__CAP_ID__SHIFT                                       0x0
#define BIF_CFG_DEV0_EPF2_0_PCIE_PWR_BUDGET_ENH_CAP_LIST__CAP_VER__SHIFT                                      0x10
#define BIF_CFG_DEV0_EPF2_0_PCIE_PWR_BUDGET_ENH_CAP_LIST__NEXT_PTR__SHIFT                                     0x14
#define BIF_CFG_DEV0_EPF2_0_PCIE_PWR_BUDGET_ENH_CAP_LIST__CAP_ID_MASK                                         0x0000FFFFL
#define BIF_CFG_DEV0_EPF2_0_PCIE_PWR_BUDGET_ENH_CAP_LIST__CAP_VER_MASK                                        0x000F0000L
#define BIF_CFG_DEV0_EPF2_0_PCIE_PWR_BUDGET_ENH_CAP_LIST__NEXT_PTR_MASK                                       0xFFF00000L
//BIF_CFG_DEV0_EPF2_0_PCIE_PWR_BUDGET_DATA_SELECT
#define BIF_CFG_DEV0_EPF2_0_PCIE_PWR_BUDGET_DATA_SELECT__DATA_SELECT__SHIFT                                   0x0
#define BIF_CFG_DEV0_EPF2_0_PCIE_PWR_BUDGET_DATA_SELECT__DATA_SELECT_MASK                                     0xFFL
//BIF_CFG_DEV0_EPF2_0_PCIE_PWR_BUDGET_DATA
#define BIF_CFG_DEV0_EPF2_0_PCIE_PWR_BUDGET_DATA__BASE_POWER__SHIFT                                           0x0
#define BIF_CFG_DEV0_EPF2_0_PCIE_PWR_BUDGET_DATA__DATA_SCALE__SHIFT                                           0x8
#define BIF_CFG_DEV0_EPF2_0_PCIE_PWR_BUDGET_DATA__PM_SUB_STATE__SHIFT                                         0xa
#define BIF_CFG_DEV0_EPF2_0_PCIE_PWR_BUDGET_DATA__PM_STATE__SHIFT                                             0xd
#define BIF_CFG_DEV0_EPF2_0_PCIE_PWR_BUDGET_DATA__TYPE__SHIFT                                                 0xf
#define BIF_CFG_DEV0_EPF2_0_PCIE_PWR_BUDGET_DATA__POWER_RAIL__SHIFT                                           0x12
#define BIF_CFG_DEV0_EPF2_0_PCIE_PWR_BUDGET_DATA__BASE_POWER_MASK                                             0x000000FFL
#define BIF_CFG_DEV0_EPF2_0_PCIE_PWR_BUDGET_DATA__DATA_SCALE_MASK                                             0x00000300L
#define BIF_CFG_DEV0_EPF2_0_PCIE_PWR_BUDGET_DATA__PM_SUB_STATE_MASK                                           0x00001C00L
#define BIF_CFG_DEV0_EPF2_0_PCIE_PWR_BUDGET_DATA__PM_STATE_MASK                                               0x00006000L
#define BIF_CFG_DEV0_EPF2_0_PCIE_PWR_BUDGET_DATA__TYPE_MASK                                                   0x00038000L
#define BIF_CFG_DEV0_EPF2_0_PCIE_PWR_BUDGET_DATA__POWER_RAIL_MASK                                             0x001C0000L
//BIF_CFG_DEV0_EPF2_0_PCIE_PWR_BUDGET_CAP
#define BIF_CFG_DEV0_EPF2_0_PCIE_PWR_BUDGET_CAP__SYSTEM_ALLOCATED__SHIFT                                      0x0
#define BIF_CFG_DEV0_EPF2_0_PCIE_PWR_BUDGET_CAP__SYSTEM_ALLOCATED_MASK                                        0x01L
//BIF_CFG_DEV0_EPF2_0_PCIE_DPA_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF2_0_PCIE_DPA_ENH_CAP_LIST__CAP_ID__SHIFT                                              0x0
#define BIF_CFG_DEV0_EPF2_0_PCIE_DPA_ENH_CAP_LIST__CAP_VER__SHIFT                                             0x10
#define BIF_CFG_DEV0_EPF2_0_PCIE_DPA_ENH_CAP_LIST__NEXT_PTR__SHIFT                                            0x14
#define BIF_CFG_DEV0_EPF2_0_PCIE_DPA_ENH_CAP_LIST__CAP_ID_MASK                                                0x0000FFFFL
#define BIF_CFG_DEV0_EPF2_0_PCIE_DPA_ENH_CAP_LIST__CAP_VER_MASK                                               0x000F0000L
#define BIF_CFG_DEV0_EPF2_0_PCIE_DPA_ENH_CAP_LIST__NEXT_PTR_MASK                                              0xFFF00000L
//BIF_CFG_DEV0_EPF2_0_PCIE_DPA_CAP
#define BIF_CFG_DEV0_EPF2_0_PCIE_DPA_CAP__SUBSTATE_MAX__SHIFT                                                 0x0
#define BIF_CFG_DEV0_EPF2_0_PCIE_DPA_CAP__TRANS_LAT_UNIT__SHIFT                                               0x8
#define BIF_CFG_DEV0_EPF2_0_PCIE_DPA_CAP__PWR_ALLOC_SCALE__SHIFT                                              0xc
#define BIF_CFG_DEV0_EPF2_0_PCIE_DPA_CAP__TRANS_LAT_VAL_0__SHIFT                                              0x10
#define BIF_CFG_DEV0_EPF2_0_PCIE_DPA_CAP__TRANS_LAT_VAL_1__SHIFT                                              0x18
#define BIF_CFG_DEV0_EPF2_0_PCIE_DPA_CAP__SUBSTATE_MAX_MASK                                                   0x0000001FL
#define BIF_CFG_DEV0_EPF2_0_PCIE_DPA_CAP__TRANS_LAT_UNIT_MASK                                                 0x00000300L
#define BIF_CFG_DEV0_EPF2_0_PCIE_DPA_CAP__PWR_ALLOC_SCALE_MASK                                                0x00003000L
#define BIF_CFG_DEV0_EPF2_0_PCIE_DPA_CAP__TRANS_LAT_VAL_0_MASK                                                0x00FF0000L
#define BIF_CFG_DEV0_EPF2_0_PCIE_DPA_CAP__TRANS_LAT_VAL_1_MASK                                                0xFF000000L
//BIF_CFG_DEV0_EPF2_0_PCIE_DPA_LATENCY_INDICATOR
#define BIF_CFG_DEV0_EPF2_0_PCIE_DPA_LATENCY_INDICATOR__TRANS_LAT_INDICATOR_BITS__SHIFT                       0x0
#define BIF_CFG_DEV0_EPF2_0_PCIE_DPA_LATENCY_INDICATOR__TRANS_LAT_INDICATOR_BITS_MASK                         0xFFL
//BIF_CFG_DEV0_EPF2_0_PCIE_DPA_STATUS
#define BIF_CFG_DEV0_EPF2_0_PCIE_DPA_STATUS__SUBSTATE_STATUS__SHIFT                                           0x0
#define BIF_CFG_DEV0_EPF2_0_PCIE_DPA_STATUS__SUBSTATE_CNTL_ENABLED__SHIFT                                     0x8
#define BIF_CFG_DEV0_EPF2_0_PCIE_DPA_STATUS__SUBSTATE_STATUS_MASK                                             0x001FL
#define BIF_CFG_DEV0_EPF2_0_PCIE_DPA_STATUS__SUBSTATE_CNTL_ENABLED_MASK                                       0x0100L
//BIF_CFG_DEV0_EPF2_0_PCIE_DPA_CNTL
#define BIF_CFG_DEV0_EPF2_0_PCIE_DPA_CNTL__SUBSTATE_CNTL__SHIFT                                               0x0
#define BIF_CFG_DEV0_EPF2_0_PCIE_DPA_CNTL__SUBSTATE_CNTL_MASK                                                 0x1FL
//BIF_CFG_DEV0_EPF2_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_0
#define BIF_CFG_DEV0_EPF2_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_0__SUBSTATE_PWR_ALLOC__SHIFT                          0x0
#define BIF_CFG_DEV0_EPF2_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_0__SUBSTATE_PWR_ALLOC_MASK                            0xFFL
//BIF_CFG_DEV0_EPF2_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_1
#define BIF_CFG_DEV0_EPF2_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_1__SUBSTATE_PWR_ALLOC__SHIFT                          0x0
#define BIF_CFG_DEV0_EPF2_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_1__SUBSTATE_PWR_ALLOC_MASK                            0xFFL
//BIF_CFG_DEV0_EPF2_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_2
#define BIF_CFG_DEV0_EPF2_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_2__SUBSTATE_PWR_ALLOC__SHIFT                          0x0
#define BIF_CFG_DEV0_EPF2_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_2__SUBSTATE_PWR_ALLOC_MASK                            0xFFL
//BIF_CFG_DEV0_EPF2_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_3
#define BIF_CFG_DEV0_EPF2_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_3__SUBSTATE_PWR_ALLOC__SHIFT                          0x0
#define BIF_CFG_DEV0_EPF2_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_3__SUBSTATE_PWR_ALLOC_MASK                            0xFFL
//BIF_CFG_DEV0_EPF2_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_4
#define BIF_CFG_DEV0_EPF2_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_4__SUBSTATE_PWR_ALLOC__SHIFT                          0x0
#define BIF_CFG_DEV0_EPF2_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_4__SUBSTATE_PWR_ALLOC_MASK                            0xFFL
//BIF_CFG_DEV0_EPF2_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_5
#define BIF_CFG_DEV0_EPF2_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_5__SUBSTATE_PWR_ALLOC__SHIFT                          0x0
#define BIF_CFG_DEV0_EPF2_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_5__SUBSTATE_PWR_ALLOC_MASK                            0xFFL
//BIF_CFG_DEV0_EPF2_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_6
#define BIF_CFG_DEV0_EPF2_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_6__SUBSTATE_PWR_ALLOC__SHIFT                          0x0
#define BIF_CFG_DEV0_EPF2_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_6__SUBSTATE_PWR_ALLOC_MASK                            0xFFL
//BIF_CFG_DEV0_EPF2_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_7
#define BIF_CFG_DEV0_EPF2_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_7__SUBSTATE_PWR_ALLOC__SHIFT                          0x0
#define BIF_CFG_DEV0_EPF2_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_7__SUBSTATE_PWR_ALLOC_MASK                            0xFFL
//BIF_CFG_DEV0_EPF2_0_PCIE_ACS_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF2_0_PCIE_ACS_ENH_CAP_LIST__CAP_ID__SHIFT                                              0x0
#define BIF_CFG_DEV0_EPF2_0_PCIE_ACS_ENH_CAP_LIST__CAP_VER__SHIFT                                             0x10
#define BIF_CFG_DEV0_EPF2_0_PCIE_ACS_ENH_CAP_LIST__NEXT_PTR__SHIFT                                            0x14
#define BIF_CFG_DEV0_EPF2_0_PCIE_ACS_ENH_CAP_LIST__CAP_ID_MASK                                                0x0000FFFFL
#define BIF_CFG_DEV0_EPF2_0_PCIE_ACS_ENH_CAP_LIST__CAP_VER_MASK                                               0x000F0000L
#define BIF_CFG_DEV0_EPF2_0_PCIE_ACS_ENH_CAP_LIST__NEXT_PTR_MASK                                              0xFFF00000L
//BIF_CFG_DEV0_EPF2_0_PCIE_ACS_CAP
#define BIF_CFG_DEV0_EPF2_0_PCIE_ACS_CAP__SOURCE_VALIDATION__SHIFT                                            0x0
#define BIF_CFG_DEV0_EPF2_0_PCIE_ACS_CAP__TRANSLATION_BLOCKING__SHIFT                                         0x1
#define BIF_CFG_DEV0_EPF2_0_PCIE_ACS_CAP__P2P_REQUEST_REDIRECT__SHIFT                                         0x2
#define BIF_CFG_DEV0_EPF2_0_PCIE_ACS_CAP__P2P_COMPLETION_REDIRECT__SHIFT                                      0x3
#define BIF_CFG_DEV0_EPF2_0_PCIE_ACS_CAP__UPSTREAM_FORWARDING__SHIFT                                          0x4
#define BIF_CFG_DEV0_EPF2_0_PCIE_ACS_CAP__P2P_EGRESS_CONTROL__SHIFT                                           0x5
#define BIF_CFG_DEV0_EPF2_0_PCIE_ACS_CAP__DIRECT_TRANSLATED_P2P__SHIFT                                        0x6
#define BIF_CFG_DEV0_EPF2_0_PCIE_ACS_CAP__EGRESS_CONTROL_VECTOR_SIZE__SHIFT                                   0x8
#define BIF_CFG_DEV0_EPF2_0_PCIE_ACS_CAP__SOURCE_VALIDATION_MASK                                              0x0001L
#define BIF_CFG_DEV0_EPF2_0_PCIE_ACS_CAP__TRANSLATION_BLOCKING_MASK                                           0x0002L
#define BIF_CFG_DEV0_EPF2_0_PCIE_ACS_CAP__P2P_REQUEST_REDIRECT_MASK                                           0x0004L
#define BIF_CFG_DEV0_EPF2_0_PCIE_ACS_CAP__P2P_COMPLETION_REDIRECT_MASK                                        0x0008L
#define BIF_CFG_DEV0_EPF2_0_PCIE_ACS_CAP__UPSTREAM_FORWARDING_MASK                                            0x0010L
#define BIF_CFG_DEV0_EPF2_0_PCIE_ACS_CAP__P2P_EGRESS_CONTROL_MASK                                             0x0020L
#define BIF_CFG_DEV0_EPF2_0_PCIE_ACS_CAP__DIRECT_TRANSLATED_P2P_MASK                                          0x0040L
#define BIF_CFG_DEV0_EPF2_0_PCIE_ACS_CAP__EGRESS_CONTROL_VECTOR_SIZE_MASK                                     0xFF00L
//BIF_CFG_DEV0_EPF2_0_PCIE_ACS_CNTL
#define BIF_CFG_DEV0_EPF2_0_PCIE_ACS_CNTL__SOURCE_VALIDATION_EN__SHIFT                                        0x0
#define BIF_CFG_DEV0_EPF2_0_PCIE_ACS_CNTL__TRANSLATION_BLOCKING_EN__SHIFT                                     0x1
#define BIF_CFG_DEV0_EPF2_0_PCIE_ACS_CNTL__P2P_REQUEST_REDIRECT_EN__SHIFT                                     0x2
#define BIF_CFG_DEV0_EPF2_0_PCIE_ACS_CNTL__P2P_COMPLETION_REDIRECT_EN__SHIFT                                  0x3
#define BIF_CFG_DEV0_EPF2_0_PCIE_ACS_CNTL__UPSTREAM_FORWARDING_EN__SHIFT                                      0x4
#define BIF_CFG_DEV0_EPF2_0_PCIE_ACS_CNTL__P2P_EGRESS_CONTROL_EN__SHIFT                                       0x5
#define BIF_CFG_DEV0_EPF2_0_PCIE_ACS_CNTL__DIRECT_TRANSLATED_P2P_EN__SHIFT                                    0x6
#define BIF_CFG_DEV0_EPF2_0_PCIE_ACS_CNTL__SOURCE_VALIDATION_EN_MASK                                          0x0001L
#define BIF_CFG_DEV0_EPF2_0_PCIE_ACS_CNTL__TRANSLATION_BLOCKING_EN_MASK                                       0x0002L
#define BIF_CFG_DEV0_EPF2_0_PCIE_ACS_CNTL__P2P_REQUEST_REDIRECT_EN_MASK                                       0x0004L
#define BIF_CFG_DEV0_EPF2_0_PCIE_ACS_CNTL__P2P_COMPLETION_REDIRECT_EN_MASK                                    0x0008L
#define BIF_CFG_DEV0_EPF2_0_PCIE_ACS_CNTL__UPSTREAM_FORWARDING_EN_MASK                                        0x0010L
#define BIF_CFG_DEV0_EPF2_0_PCIE_ACS_CNTL__P2P_EGRESS_CONTROL_EN_MASK                                         0x0020L
#define BIF_CFG_DEV0_EPF2_0_PCIE_ACS_CNTL__DIRECT_TRANSLATED_P2P_EN_MASK                                      0x0040L
//BIF_CFG_DEV0_EPF2_0_PCIE_ARI_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF2_0_PCIE_ARI_ENH_CAP_LIST__CAP_ID__SHIFT                                              0x0
#define BIF_CFG_DEV0_EPF2_0_PCIE_ARI_ENH_CAP_LIST__CAP_VER__SHIFT                                             0x10
#define BIF_CFG_DEV0_EPF2_0_PCIE_ARI_ENH_CAP_LIST__NEXT_PTR__SHIFT                                            0x14
#define BIF_CFG_DEV0_EPF2_0_PCIE_ARI_ENH_CAP_LIST__CAP_ID_MASK                                                0x0000FFFFL
#define BIF_CFG_DEV0_EPF2_0_PCIE_ARI_ENH_CAP_LIST__CAP_VER_MASK                                               0x000F0000L
#define BIF_CFG_DEV0_EPF2_0_PCIE_ARI_ENH_CAP_LIST__NEXT_PTR_MASK                                              0xFFF00000L
//BIF_CFG_DEV0_EPF2_0_PCIE_ARI_CAP
#define BIF_CFG_DEV0_EPF2_0_PCIE_ARI_CAP__ARI_MFVC_FUNC_GROUPS_CAP__SHIFT                                     0x0
#define BIF_CFG_DEV0_EPF2_0_PCIE_ARI_CAP__ARI_ACS_FUNC_GROUPS_CAP__SHIFT                                      0x1
#define BIF_CFG_DEV0_EPF2_0_PCIE_ARI_CAP__ARI_NEXT_FUNC_NUM__SHIFT                                            0x8
#define BIF_CFG_DEV0_EPF2_0_PCIE_ARI_CAP__ARI_MFVC_FUNC_GROUPS_CAP_MASK                                       0x0001L
#define BIF_CFG_DEV0_EPF2_0_PCIE_ARI_CAP__ARI_ACS_FUNC_GROUPS_CAP_MASK                                        0x0002L
#define BIF_CFG_DEV0_EPF2_0_PCIE_ARI_CAP__ARI_NEXT_FUNC_NUM_MASK                                              0xFF00L
//BIF_CFG_DEV0_EPF2_0_PCIE_ARI_CNTL
#define BIF_CFG_DEV0_EPF2_0_PCIE_ARI_CNTL__ARI_MFVC_FUNC_GROUPS_EN__SHIFT                                     0x0
#define BIF_CFG_DEV0_EPF2_0_PCIE_ARI_CNTL__ARI_ACS_FUNC_GROUPS_EN__SHIFT                                      0x1
#define BIF_CFG_DEV0_EPF2_0_PCIE_ARI_CNTL__ARI_FUNCTION_GROUP__SHIFT                                          0x4
#define BIF_CFG_DEV0_EPF2_0_PCIE_ARI_CNTL__ARI_MFVC_FUNC_GROUPS_EN_MASK                                       0x0001L
#define BIF_CFG_DEV0_EPF2_0_PCIE_ARI_CNTL__ARI_ACS_FUNC_GROUPS_EN_MASK                                        0x0002L
#define BIF_CFG_DEV0_EPF2_0_PCIE_ARI_CNTL__ARI_FUNCTION_GROUP_MASK                                            0x0070L


// addressBlock: nbio_nbif0_bif_cfg_dev0_epf3_bifcfgdecp
//BIF_CFG_DEV0_EPF3_0_VENDOR_ID
#define BIF_CFG_DEV0_EPF3_0_VENDOR_ID__VENDOR_ID__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF3_0_VENDOR_ID__VENDOR_ID_MASK                                                         0xFFFFL
//BIF_CFG_DEV0_EPF3_0_DEVICE_ID
#define BIF_CFG_DEV0_EPF3_0_DEVICE_ID__DEVICE_ID__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF3_0_DEVICE_ID__DEVICE_ID_MASK                                                         0xFFFFL
//BIF_CFG_DEV0_EPF3_0_COMMAND
#define BIF_CFG_DEV0_EPF3_0_COMMAND__IO_ACCESS_EN__SHIFT                                                      0x0
#define BIF_CFG_DEV0_EPF3_0_COMMAND__MEM_ACCESS_EN__SHIFT                                                     0x1
#define BIF_CFG_DEV0_EPF3_0_COMMAND__BUS_MASTER_EN__SHIFT                                                     0x2
#define BIF_CFG_DEV0_EPF3_0_COMMAND__SPECIAL_CYCLE_EN__SHIFT                                                  0x3
#define BIF_CFG_DEV0_EPF3_0_COMMAND__MEM_WRITE_INVALIDATE_EN__SHIFT                                           0x4
#define BIF_CFG_DEV0_EPF3_0_COMMAND__PAL_SNOOP_EN__SHIFT                                                      0x5
#define BIF_CFG_DEV0_EPF3_0_COMMAND__PARITY_ERROR_RESPONSE__SHIFT                                             0x6
#define BIF_CFG_DEV0_EPF3_0_COMMAND__AD_STEPPING__SHIFT                                                       0x7
#define BIF_CFG_DEV0_EPF3_0_COMMAND__SERR_EN__SHIFT                                                           0x8
#define BIF_CFG_DEV0_EPF3_0_COMMAND__FAST_B2B_EN__SHIFT                                                       0x9
#define BIF_CFG_DEV0_EPF3_0_COMMAND__INT_DIS__SHIFT                                                           0xa
#define BIF_CFG_DEV0_EPF3_0_COMMAND__IO_ACCESS_EN_MASK                                                        0x0001L
#define BIF_CFG_DEV0_EPF3_0_COMMAND__MEM_ACCESS_EN_MASK                                                       0x0002L
#define BIF_CFG_DEV0_EPF3_0_COMMAND__BUS_MASTER_EN_MASK                                                       0x0004L
#define BIF_CFG_DEV0_EPF3_0_COMMAND__SPECIAL_CYCLE_EN_MASK                                                    0x0008L
#define BIF_CFG_DEV0_EPF3_0_COMMAND__MEM_WRITE_INVALIDATE_EN_MASK                                             0x0010L
#define BIF_CFG_DEV0_EPF3_0_COMMAND__PAL_SNOOP_EN_MASK                                                        0x0020L
#define BIF_CFG_DEV0_EPF3_0_COMMAND__PARITY_ERROR_RESPONSE_MASK                                               0x0040L
#define BIF_CFG_DEV0_EPF3_0_COMMAND__AD_STEPPING_MASK                                                         0x0080L
#define BIF_CFG_DEV0_EPF3_0_COMMAND__SERR_EN_MASK                                                             0x0100L
#define BIF_CFG_DEV0_EPF3_0_COMMAND__FAST_B2B_EN_MASK                                                         0x0200L
#define BIF_CFG_DEV0_EPF3_0_COMMAND__INT_DIS_MASK                                                             0x0400L
//BIF_CFG_DEV0_EPF3_0_STATUS
#define BIF_CFG_DEV0_EPF3_0_STATUS__INT_STATUS__SHIFT                                                         0x3
#define BIF_CFG_DEV0_EPF3_0_STATUS__CAP_LIST__SHIFT                                                           0x4
#define BIF_CFG_DEV0_EPF3_0_STATUS__PCI_66_EN__SHIFT                                                          0x5
#define BIF_CFG_DEV0_EPF3_0_STATUS__FAST_BACK_CAPABLE__SHIFT                                                  0x7
#define BIF_CFG_DEV0_EPF3_0_STATUS__MASTER_DATA_PARITY_ERROR__SHIFT                                           0x8
#define BIF_CFG_DEV0_EPF3_0_STATUS__DEVSEL_TIMING__SHIFT                                                      0x9
#define BIF_CFG_DEV0_EPF3_0_STATUS__SIGNAL_TARGET_ABORT__SHIFT                                                0xb
#define BIF_CFG_DEV0_EPF3_0_STATUS__RECEIVED_TARGET_ABORT__SHIFT                                              0xc
#define BIF_CFG_DEV0_EPF3_0_STATUS__RECEIVED_MASTER_ABORT__SHIFT                                              0xd
#define BIF_CFG_DEV0_EPF3_0_STATUS__SIGNALED_SYSTEM_ERROR__SHIFT                                              0xe
#define BIF_CFG_DEV0_EPF3_0_STATUS__PARITY_ERROR_DETECTED__SHIFT                                              0xf
#define BIF_CFG_DEV0_EPF3_0_STATUS__INT_STATUS_MASK                                                           0x0008L
#define BIF_CFG_DEV0_EPF3_0_STATUS__CAP_LIST_MASK                                                             0x0010L
#define BIF_CFG_DEV0_EPF3_0_STATUS__PCI_66_EN_MASK                                                            0x0020L
#define BIF_CFG_DEV0_EPF3_0_STATUS__FAST_BACK_CAPABLE_MASK                                                    0x0080L
#define BIF_CFG_DEV0_EPF3_0_STATUS__MASTER_DATA_PARITY_ERROR_MASK                                             0x0100L
#define BIF_CFG_DEV0_EPF3_0_STATUS__DEVSEL_TIMING_MASK                                                        0x0600L
#define BIF_CFG_DEV0_EPF3_0_STATUS__SIGNAL_TARGET_ABORT_MASK                                                  0x0800L
#define BIF_CFG_DEV0_EPF3_0_STATUS__RECEIVED_TARGET_ABORT_MASK                                                0x1000L
#define BIF_CFG_DEV0_EPF3_0_STATUS__RECEIVED_MASTER_ABORT_MASK                                                0x2000L
#define BIF_CFG_DEV0_EPF3_0_STATUS__SIGNALED_SYSTEM_ERROR_MASK                                                0x4000L
#define BIF_CFG_DEV0_EPF3_0_STATUS__PARITY_ERROR_DETECTED_MASK                                                0x8000L
//BIF_CFG_DEV0_EPF3_0_REVISION_ID
#define BIF_CFG_DEV0_EPF3_0_REVISION_ID__MINOR_REV_ID__SHIFT                                                  0x0
#define BIF_CFG_DEV0_EPF3_0_REVISION_ID__MAJOR_REV_ID__SHIFT                                                  0x4
#define BIF_CFG_DEV0_EPF3_0_REVISION_ID__MINOR_REV_ID_MASK                                                    0x0FL
#define BIF_CFG_DEV0_EPF3_0_REVISION_ID__MAJOR_REV_ID_MASK                                                    0xF0L
//BIF_CFG_DEV0_EPF3_0_PROG_INTERFACE
#define BIF_CFG_DEV0_EPF3_0_PROG_INTERFACE__PROG_INTERFACE__SHIFT                                             0x0
#define BIF_CFG_DEV0_EPF3_0_PROG_INTERFACE__PROG_INTERFACE_MASK                                               0xFFL
//BIF_CFG_DEV0_EPF3_0_SUB_CLASS
#define BIF_CFG_DEV0_EPF3_0_SUB_CLASS__SUB_CLASS__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF3_0_SUB_CLASS__SUB_CLASS_MASK                                                         0xFFL
//BIF_CFG_DEV0_EPF3_0_BASE_CLASS
#define BIF_CFG_DEV0_EPF3_0_BASE_CLASS__BASE_CLASS__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF3_0_BASE_CLASS__BASE_CLASS_MASK                                                       0xFFL
//BIF_CFG_DEV0_EPF3_0_CACHE_LINE
#define BIF_CFG_DEV0_EPF3_0_CACHE_LINE__CACHE_LINE_SIZE__SHIFT                                                0x0
#define BIF_CFG_DEV0_EPF3_0_CACHE_LINE__CACHE_LINE_SIZE_MASK                                                  0xFFL
//BIF_CFG_DEV0_EPF3_0_LATENCY
#define BIF_CFG_DEV0_EPF3_0_LATENCY__LATENCY_TIMER__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF3_0_LATENCY__LATENCY_TIMER_MASK                                                       0xFFL
//BIF_CFG_DEV0_EPF3_0_HEADER
#define BIF_CFG_DEV0_EPF3_0_HEADER__HEADER_TYPE__SHIFT                                                        0x0
#define BIF_CFG_DEV0_EPF3_0_HEADER__DEVICE_TYPE__SHIFT                                                        0x7
#define BIF_CFG_DEV0_EPF3_0_HEADER__HEADER_TYPE_MASK                                                          0x7FL
#define BIF_CFG_DEV0_EPF3_0_HEADER__DEVICE_TYPE_MASK                                                          0x80L
//BIF_CFG_DEV0_EPF3_0_BIST
#define BIF_CFG_DEV0_EPF3_0_BIST__BIST_COMP__SHIFT                                                            0x0
#define BIF_CFG_DEV0_EPF3_0_BIST__BIST_STRT__SHIFT                                                            0x6
#define BIF_CFG_DEV0_EPF3_0_BIST__BIST_CAP__SHIFT                                                             0x7
#define BIF_CFG_DEV0_EPF3_0_BIST__BIST_COMP_MASK                                                              0x0FL
#define BIF_CFG_DEV0_EPF3_0_BIST__BIST_STRT_MASK                                                              0x40L
#define BIF_CFG_DEV0_EPF3_0_BIST__BIST_CAP_MASK                                                               0x80L
//BIF_CFG_DEV0_EPF3_0_BASE_ADDR_1
#define BIF_CFG_DEV0_EPF3_0_BASE_ADDR_1__BASE_ADDR__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF3_0_BASE_ADDR_1__BASE_ADDR_MASK                                                       0xFFFFFFFFL
//BIF_CFG_DEV0_EPF3_0_BASE_ADDR_2
#define BIF_CFG_DEV0_EPF3_0_BASE_ADDR_2__BASE_ADDR__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF3_0_BASE_ADDR_2__BASE_ADDR_MASK                                                       0xFFFFFFFFL
//BIF_CFG_DEV0_EPF3_0_BASE_ADDR_3
#define BIF_CFG_DEV0_EPF3_0_BASE_ADDR_3__BASE_ADDR__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF3_0_BASE_ADDR_3__BASE_ADDR_MASK                                                       0xFFFFFFFFL
//BIF_CFG_DEV0_EPF3_0_BASE_ADDR_4
#define BIF_CFG_DEV0_EPF3_0_BASE_ADDR_4__BASE_ADDR__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF3_0_BASE_ADDR_4__BASE_ADDR_MASK                                                       0xFFFFFFFFL
//BIF_CFG_DEV0_EPF3_0_BASE_ADDR_5
#define BIF_CFG_DEV0_EPF3_0_BASE_ADDR_5__BASE_ADDR__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF3_0_BASE_ADDR_5__BASE_ADDR_MASK                                                       0xFFFFFFFFL
//BIF_CFG_DEV0_EPF3_0_BASE_ADDR_6
#define BIF_CFG_DEV0_EPF3_0_BASE_ADDR_6__BASE_ADDR__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF3_0_BASE_ADDR_6__BASE_ADDR_MASK                                                       0xFFFFFFFFL
//BIF_CFG_DEV0_EPF3_0_ADAPTER_ID
#define BIF_CFG_DEV0_EPF3_0_ADAPTER_ID__SUBSYSTEM_VENDOR_ID__SHIFT                                            0x0
#define BIF_CFG_DEV0_EPF3_0_ADAPTER_ID__SUBSYSTEM_ID__SHIFT                                                   0x10
#define BIF_CFG_DEV0_EPF3_0_ADAPTER_ID__SUBSYSTEM_VENDOR_ID_MASK                                              0x0000FFFFL
#define BIF_CFG_DEV0_EPF3_0_ADAPTER_ID__SUBSYSTEM_ID_MASK                                                     0xFFFF0000L
//BIF_CFG_DEV0_EPF3_0_ROM_BASE_ADDR
#define BIF_CFG_DEV0_EPF3_0_ROM_BASE_ADDR__BASE_ADDR__SHIFT                                                   0x0
#define BIF_CFG_DEV0_EPF3_0_ROM_BASE_ADDR__BASE_ADDR_MASK                                                     0xFFFFFFFFL
//BIF_CFG_DEV0_EPF3_0_CAP_PTR
#define BIF_CFG_DEV0_EPF3_0_CAP_PTR__CAP_PTR__SHIFT                                                           0x0
#define BIF_CFG_DEV0_EPF3_0_CAP_PTR__CAP_PTR_MASK                                                             0x000000FFL
//BIF_CFG_DEV0_EPF3_0_INTERRUPT_LINE
#define BIF_CFG_DEV0_EPF3_0_INTERRUPT_LINE__INTERRUPT_LINE__SHIFT                                             0x0
#define BIF_CFG_DEV0_EPF3_0_INTERRUPT_LINE__INTERRUPT_LINE_MASK                                               0xFFL
//BIF_CFG_DEV0_EPF3_0_INTERRUPT_PIN
#define BIF_CFG_DEV0_EPF3_0_INTERRUPT_PIN__INTERRUPT_PIN__SHIFT                                               0x0
#define BIF_CFG_DEV0_EPF3_0_INTERRUPT_PIN__INTERRUPT_PIN_MASK                                                 0xFFL
//BIF_CFG_DEV0_EPF3_0_MIN_GRANT
#define BIF_CFG_DEV0_EPF3_0_MIN_GRANT__MIN_GNT__SHIFT                                                         0x0
#define BIF_CFG_DEV0_EPF3_0_MIN_GRANT__MIN_GNT_MASK                                                           0xFFL
//BIF_CFG_DEV0_EPF3_0_MAX_LATENCY
#define BIF_CFG_DEV0_EPF3_0_MAX_LATENCY__MAX_LAT__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF3_0_MAX_LATENCY__MAX_LAT_MASK                                                         0xFFL
//BIF_CFG_DEV0_EPF3_0_VENDOR_CAP_LIST
#define BIF_CFG_DEV0_EPF3_0_VENDOR_CAP_LIST__CAP_ID__SHIFT                                                    0x0
#define BIF_CFG_DEV0_EPF3_0_VENDOR_CAP_LIST__NEXT_PTR__SHIFT                                                  0x8
#define BIF_CFG_DEV0_EPF3_0_VENDOR_CAP_LIST__LENGTH__SHIFT                                                    0x10
#define BIF_CFG_DEV0_EPF3_0_VENDOR_CAP_LIST__CAP_ID_MASK                                                      0x000000FFL
#define BIF_CFG_DEV0_EPF3_0_VENDOR_CAP_LIST__NEXT_PTR_MASK                                                    0x0000FF00L
#define BIF_CFG_DEV0_EPF3_0_VENDOR_CAP_LIST__LENGTH_MASK                                                      0x00FF0000L
//BIF_CFG_DEV0_EPF3_0_ADAPTER_ID_W
#define BIF_CFG_DEV0_EPF3_0_ADAPTER_ID_W__SUBSYSTEM_VENDOR_ID__SHIFT                                          0x0
#define BIF_CFG_DEV0_EPF3_0_ADAPTER_ID_W__SUBSYSTEM_ID__SHIFT                                                 0x10
#define BIF_CFG_DEV0_EPF3_0_ADAPTER_ID_W__SUBSYSTEM_VENDOR_ID_MASK                                            0x0000FFFFL
#define BIF_CFG_DEV0_EPF3_0_ADAPTER_ID_W__SUBSYSTEM_ID_MASK                                                   0xFFFF0000L
//BIF_CFG_DEV0_EPF3_0_PMI_CAP_LIST
#define BIF_CFG_DEV0_EPF3_0_PMI_CAP_LIST__CAP_ID__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF3_0_PMI_CAP_LIST__NEXT_PTR__SHIFT                                                     0x8
#define BIF_CFG_DEV0_EPF3_0_PMI_CAP_LIST__CAP_ID_MASK                                                         0x00FFL
#define BIF_CFG_DEV0_EPF3_0_PMI_CAP_LIST__NEXT_PTR_MASK                                                       0xFF00L
//BIF_CFG_DEV0_EPF3_0_PMI_CAP
#define BIF_CFG_DEV0_EPF3_0_PMI_CAP__VERSION__SHIFT                                                           0x0
#define BIF_CFG_DEV0_EPF3_0_PMI_CAP__PME_CLOCK__SHIFT                                                         0x3
#define BIF_CFG_DEV0_EPF3_0_PMI_CAP__DEV_SPECIFIC_INIT__SHIFT                                                 0x5
#define BIF_CFG_DEV0_EPF3_0_PMI_CAP__AUX_CURRENT__SHIFT                                                       0x6
#define BIF_CFG_DEV0_EPF3_0_PMI_CAP__D1_SUPPORT__SHIFT                                                        0x9
#define BIF_CFG_DEV0_EPF3_0_PMI_CAP__D2_SUPPORT__SHIFT                                                        0xa
#define BIF_CFG_DEV0_EPF3_0_PMI_CAP__PME_SUPPORT__SHIFT                                                       0xb
#define BIF_CFG_DEV0_EPF3_0_PMI_CAP__VERSION_MASK                                                             0x0007L
#define BIF_CFG_DEV0_EPF3_0_PMI_CAP__PME_CLOCK_MASK                                                           0x0008L
#define BIF_CFG_DEV0_EPF3_0_PMI_CAP__DEV_SPECIFIC_INIT_MASK                                                   0x0020L
#define BIF_CFG_DEV0_EPF3_0_PMI_CAP__AUX_CURRENT_MASK                                                         0x01C0L
#define BIF_CFG_DEV0_EPF3_0_PMI_CAP__D1_SUPPORT_MASK                                                          0x0200L
#define BIF_CFG_DEV0_EPF3_0_PMI_CAP__D2_SUPPORT_MASK                                                          0x0400L
#define BIF_CFG_DEV0_EPF3_0_PMI_CAP__PME_SUPPORT_MASK                                                         0xF800L
//BIF_CFG_DEV0_EPF3_0_PMI_STATUS_CNTL
#define BIF_CFG_DEV0_EPF3_0_PMI_STATUS_CNTL__POWER_STATE__SHIFT                                               0x0
#define BIF_CFG_DEV0_EPF3_0_PMI_STATUS_CNTL__NO_SOFT_RESET__SHIFT                                             0x3
#define BIF_CFG_DEV0_EPF3_0_PMI_STATUS_CNTL__PME_EN__SHIFT                                                    0x8
#define BIF_CFG_DEV0_EPF3_0_PMI_STATUS_CNTL__DATA_SELECT__SHIFT                                               0x9
#define BIF_CFG_DEV0_EPF3_0_PMI_STATUS_CNTL__DATA_SCALE__SHIFT                                                0xd
#define BIF_CFG_DEV0_EPF3_0_PMI_STATUS_CNTL__PME_STATUS__SHIFT                                                0xf
#define BIF_CFG_DEV0_EPF3_0_PMI_STATUS_CNTL__B2_B3_SUPPORT__SHIFT                                             0x16
#define BIF_CFG_DEV0_EPF3_0_PMI_STATUS_CNTL__BUS_PWR_EN__SHIFT                                                0x17
#define BIF_CFG_DEV0_EPF3_0_PMI_STATUS_CNTL__PMI_DATA__SHIFT                                                  0x18
#define BIF_CFG_DEV0_EPF3_0_PMI_STATUS_CNTL__POWER_STATE_MASK                                                 0x00000003L
#define BIF_CFG_DEV0_EPF3_0_PMI_STATUS_CNTL__NO_SOFT_RESET_MASK                                               0x00000008L
#define BIF_CFG_DEV0_EPF3_0_PMI_STATUS_CNTL__PME_EN_MASK                                                      0x00000100L
#define BIF_CFG_DEV0_EPF3_0_PMI_STATUS_CNTL__DATA_SELECT_MASK                                                 0x00001E00L
#define BIF_CFG_DEV0_EPF3_0_PMI_STATUS_CNTL__DATA_SCALE_MASK                                                  0x00006000L
#define BIF_CFG_DEV0_EPF3_0_PMI_STATUS_CNTL__PME_STATUS_MASK                                                  0x00008000L
#define BIF_CFG_DEV0_EPF3_0_PMI_STATUS_CNTL__B2_B3_SUPPORT_MASK                                               0x00400000L
#define BIF_CFG_DEV0_EPF3_0_PMI_STATUS_CNTL__BUS_PWR_EN_MASK                                                  0x00800000L
#define BIF_CFG_DEV0_EPF3_0_PMI_STATUS_CNTL__PMI_DATA_MASK                                                    0xFF000000L
//BIF_CFG_DEV0_EPF3_0_SBRN
#define BIF_CFG_DEV0_EPF3_0_SBRN__SBRN__SHIFT                                                                 0x0
#define BIF_CFG_DEV0_EPF3_0_SBRN__SBRN_MASK                                                                   0xFFL
//BIF_CFG_DEV0_EPF3_0_FLADJ
#define BIF_CFG_DEV0_EPF3_0_FLADJ__FLADJ__SHIFT                                                               0x0
#define BIF_CFG_DEV0_EPF3_0_FLADJ__FLADJ_MASK                                                                 0x3FL
//BIF_CFG_DEV0_EPF3_0_DBESL_DBESLD
#define BIF_CFG_DEV0_EPF3_0_DBESL_DBESLD__DBESL__SHIFT                                                        0x0
#define BIF_CFG_DEV0_EPF3_0_DBESL_DBESLD__DBESLD__SHIFT                                                       0x4
#define BIF_CFG_DEV0_EPF3_0_DBESL_DBESLD__DBESL_MASK                                                          0x0FL
#define BIF_CFG_DEV0_EPF3_0_DBESL_DBESLD__DBESLD_MASK                                                         0xF0L
//BIF_CFG_DEV0_EPF3_0_PCIE_CAP_LIST
#define BIF_CFG_DEV0_EPF3_0_PCIE_CAP_LIST__CAP_ID__SHIFT                                                      0x0
#define BIF_CFG_DEV0_EPF3_0_PCIE_CAP_LIST__NEXT_PTR__SHIFT                                                    0x8
#define BIF_CFG_DEV0_EPF3_0_PCIE_CAP_LIST__CAP_ID_MASK                                                        0x00FFL
#define BIF_CFG_DEV0_EPF3_0_PCIE_CAP_LIST__NEXT_PTR_MASK                                                      0xFF00L
//BIF_CFG_DEV0_EPF3_0_PCIE_CAP
#define BIF_CFG_DEV0_EPF3_0_PCIE_CAP__VERSION__SHIFT                                                          0x0
#define BIF_CFG_DEV0_EPF3_0_PCIE_CAP__DEVICE_TYPE__SHIFT                                                      0x4
#define BIF_CFG_DEV0_EPF3_0_PCIE_CAP__SLOT_IMPLEMENTED__SHIFT                                                 0x8
#define BIF_CFG_DEV0_EPF3_0_PCIE_CAP__INT_MESSAGE_NUM__SHIFT                                                  0x9
#define BIF_CFG_DEV0_EPF3_0_PCIE_CAP__VERSION_MASK                                                            0x000FL
#define BIF_CFG_DEV0_EPF3_0_PCIE_CAP__DEVICE_TYPE_MASK                                                        0x00F0L
#define BIF_CFG_DEV0_EPF3_0_PCIE_CAP__SLOT_IMPLEMENTED_MASK                                                   0x0100L
#define BIF_CFG_DEV0_EPF3_0_PCIE_CAP__INT_MESSAGE_NUM_MASK                                                    0x3E00L
//BIF_CFG_DEV0_EPF3_0_DEVICE_CAP
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CAP__MAX_PAYLOAD_SUPPORT__SHIFT                                            0x0
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CAP__PHANTOM_FUNC__SHIFT                                                   0x3
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CAP__EXTENDED_TAG__SHIFT                                                   0x5
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CAP__L0S_ACCEPTABLE_LATENCY__SHIFT                                         0x6
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CAP__L1_ACCEPTABLE_LATENCY__SHIFT                                          0x9
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CAP__ROLE_BASED_ERR_REPORTING__SHIFT                                       0xf
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CAP__CAPTURED_SLOT_POWER_LIMIT__SHIFT                                      0x12
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CAP__CAPTURED_SLOT_POWER_SCALE__SHIFT                                      0x1a
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CAP__FLR_CAPABLE__SHIFT                                                    0x1c
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CAP__MAX_PAYLOAD_SUPPORT_MASK                                              0x00000007L
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CAP__PHANTOM_FUNC_MASK                                                     0x00000018L
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CAP__EXTENDED_TAG_MASK                                                     0x00000020L
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CAP__L0S_ACCEPTABLE_LATENCY_MASK                                           0x000001C0L
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CAP__L1_ACCEPTABLE_LATENCY_MASK                                            0x00000E00L
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CAP__ROLE_BASED_ERR_REPORTING_MASK                                         0x00008000L
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CAP__CAPTURED_SLOT_POWER_LIMIT_MASK                                        0x03FC0000L
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CAP__CAPTURED_SLOT_POWER_SCALE_MASK                                        0x0C000000L
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CAP__FLR_CAPABLE_MASK                                                      0x10000000L
//BIF_CFG_DEV0_EPF3_0_DEVICE_CNTL
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CNTL__CORR_ERR_EN__SHIFT                                                   0x0
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CNTL__NON_FATAL_ERR_EN__SHIFT                                              0x1
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CNTL__FATAL_ERR_EN__SHIFT                                                  0x2
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CNTL__USR_REPORT_EN__SHIFT                                                 0x3
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CNTL__RELAXED_ORD_EN__SHIFT                                                0x4
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CNTL__MAX_PAYLOAD_SIZE__SHIFT                                              0x5
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CNTL__EXTENDED_TAG_EN__SHIFT                                               0x8
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CNTL__PHANTOM_FUNC_EN__SHIFT                                               0x9
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CNTL__AUX_POWER_PM_EN__SHIFT                                               0xa
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CNTL__NO_SNOOP_EN__SHIFT                                                   0xb
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CNTL__MAX_READ_REQUEST_SIZE__SHIFT                                         0xc
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CNTL__INITIATE_FLR__SHIFT                                                  0xf
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CNTL__CORR_ERR_EN_MASK                                                     0x0001L
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CNTL__NON_FATAL_ERR_EN_MASK                                                0x0002L
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CNTL__FATAL_ERR_EN_MASK                                                    0x0004L
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CNTL__USR_REPORT_EN_MASK                                                   0x0008L
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CNTL__RELAXED_ORD_EN_MASK                                                  0x0010L
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CNTL__MAX_PAYLOAD_SIZE_MASK                                                0x00E0L
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CNTL__EXTENDED_TAG_EN_MASK                                                 0x0100L
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CNTL__PHANTOM_FUNC_EN_MASK                                                 0x0200L
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CNTL__AUX_POWER_PM_EN_MASK                                                 0x0400L
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CNTL__NO_SNOOP_EN_MASK                                                     0x0800L
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CNTL__MAX_READ_REQUEST_SIZE_MASK                                           0x7000L
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CNTL__INITIATE_FLR_MASK                                                    0x8000L
//BIF_CFG_DEV0_EPF3_0_DEVICE_STATUS
#define BIF_CFG_DEV0_EPF3_0_DEVICE_STATUS__CORR_ERR__SHIFT                                                    0x0
#define BIF_CFG_DEV0_EPF3_0_DEVICE_STATUS__NON_FATAL_ERR__SHIFT                                               0x1
#define BIF_CFG_DEV0_EPF3_0_DEVICE_STATUS__FATAL_ERR__SHIFT                                                   0x2
#define BIF_CFG_DEV0_EPF3_0_DEVICE_STATUS__USR_DETECTED__SHIFT                                                0x3
#define BIF_CFG_DEV0_EPF3_0_DEVICE_STATUS__AUX_PWR__SHIFT                                                     0x4
#define BIF_CFG_DEV0_EPF3_0_DEVICE_STATUS__TRANSACTIONS_PEND__SHIFT                                           0x5
#define BIF_CFG_DEV0_EPF3_0_DEVICE_STATUS__CORR_ERR_MASK                                                      0x0001L
#define BIF_CFG_DEV0_EPF3_0_DEVICE_STATUS__NON_FATAL_ERR_MASK                                                 0x0002L
#define BIF_CFG_DEV0_EPF3_0_DEVICE_STATUS__FATAL_ERR_MASK                                                     0x0004L
#define BIF_CFG_DEV0_EPF3_0_DEVICE_STATUS__USR_DETECTED_MASK                                                  0x0008L
#define BIF_CFG_DEV0_EPF3_0_DEVICE_STATUS__AUX_PWR_MASK                                                       0x0010L
#define BIF_CFG_DEV0_EPF3_0_DEVICE_STATUS__TRANSACTIONS_PEND_MASK                                             0x0020L
//BIF_CFG_DEV0_EPF3_0_LINK_CAP
#define BIF_CFG_DEV0_EPF3_0_LINK_CAP__LINK_SPEED__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF3_0_LINK_CAP__LINK_WIDTH__SHIFT                                                       0x4
#define BIF_CFG_DEV0_EPF3_0_LINK_CAP__PM_SUPPORT__SHIFT                                                       0xa
#define BIF_CFG_DEV0_EPF3_0_LINK_CAP__L0S_EXIT_LATENCY__SHIFT                                                 0xc
#define BIF_CFG_DEV0_EPF3_0_LINK_CAP__L1_EXIT_LATENCY__SHIFT                                                  0xf
#define BIF_CFG_DEV0_EPF3_0_LINK_CAP__CLOCK_POWER_MANAGEMENT__SHIFT                                           0x12
#define BIF_CFG_DEV0_EPF3_0_LINK_CAP__SURPRISE_DOWN_ERR_REPORTING__SHIFT                                      0x13
#define BIF_CFG_DEV0_EPF3_0_LINK_CAP__DL_ACTIVE_REPORTING_CAPABLE__SHIFT                                      0x14
#define BIF_CFG_DEV0_EPF3_0_LINK_CAP__LINK_BW_NOTIFICATION_CAP__SHIFT                                         0x15
#define BIF_CFG_DEV0_EPF3_0_LINK_CAP__ASPM_OPTIONALITY_COMPLIANCE__SHIFT                                      0x16
#define BIF_CFG_DEV0_EPF3_0_LINK_CAP__PORT_NUMBER__SHIFT                                                      0x18
#define BIF_CFG_DEV0_EPF3_0_LINK_CAP__LINK_SPEED_MASK                                                         0x0000000FL
#define BIF_CFG_DEV0_EPF3_0_LINK_CAP__LINK_WIDTH_MASK                                                         0x000003F0L
#define BIF_CFG_DEV0_EPF3_0_LINK_CAP__PM_SUPPORT_MASK                                                         0x00000C00L
#define BIF_CFG_DEV0_EPF3_0_LINK_CAP__L0S_EXIT_LATENCY_MASK                                                   0x00007000L
#define BIF_CFG_DEV0_EPF3_0_LINK_CAP__L1_EXIT_LATENCY_MASK                                                    0x00038000L
#define BIF_CFG_DEV0_EPF3_0_LINK_CAP__CLOCK_POWER_MANAGEMENT_MASK                                             0x00040000L
#define BIF_CFG_DEV0_EPF3_0_LINK_CAP__SURPRISE_DOWN_ERR_REPORTING_MASK                                        0x00080000L
#define BIF_CFG_DEV0_EPF3_0_LINK_CAP__DL_ACTIVE_REPORTING_CAPABLE_MASK                                        0x00100000L
#define BIF_CFG_DEV0_EPF3_0_LINK_CAP__LINK_BW_NOTIFICATION_CAP_MASK                                           0x00200000L
#define BIF_CFG_DEV0_EPF3_0_LINK_CAP__ASPM_OPTIONALITY_COMPLIANCE_MASK                                        0x00400000L
#define BIF_CFG_DEV0_EPF3_0_LINK_CAP__PORT_NUMBER_MASK                                                        0xFF000000L
//BIF_CFG_DEV0_EPF3_0_LINK_CNTL
#define BIF_CFG_DEV0_EPF3_0_LINK_CNTL__PM_CONTROL__SHIFT                                                      0x0
#define BIF_CFG_DEV0_EPF3_0_LINK_CNTL__READ_CPL_BOUNDARY__SHIFT                                               0x3
#define BIF_CFG_DEV0_EPF3_0_LINK_CNTL__LINK_DIS__SHIFT                                                        0x4
#define BIF_CFG_DEV0_EPF3_0_LINK_CNTL__RETRAIN_LINK__SHIFT                                                    0x5
#define BIF_CFG_DEV0_EPF3_0_LINK_CNTL__COMMON_CLOCK_CFG__SHIFT                                                0x6
#define BIF_CFG_DEV0_EPF3_0_LINK_CNTL__EXTENDED_SYNC__SHIFT                                                   0x7
#define BIF_CFG_DEV0_EPF3_0_LINK_CNTL__CLOCK_POWER_MANAGEMENT_EN__SHIFT                                       0x8
#define BIF_CFG_DEV0_EPF3_0_LINK_CNTL__HW_AUTONOMOUS_WIDTH_DISABLE__SHIFT                                     0x9
#define BIF_CFG_DEV0_EPF3_0_LINK_CNTL__LINK_BW_MANAGEMENT_INT_EN__SHIFT                                       0xa
#define BIF_CFG_DEV0_EPF3_0_LINK_CNTL__LINK_AUTONOMOUS_BW_INT_EN__SHIFT                                       0xb
#define BIF_CFG_DEV0_EPF3_0_LINK_CNTL__PM_CONTROL_MASK                                                        0x0003L
#define BIF_CFG_DEV0_EPF3_0_LINK_CNTL__READ_CPL_BOUNDARY_MASK                                                 0x0008L
#define BIF_CFG_DEV0_EPF3_0_LINK_CNTL__LINK_DIS_MASK                                                          0x0010L
#define BIF_CFG_DEV0_EPF3_0_LINK_CNTL__RETRAIN_LINK_MASK                                                      0x0020L
#define BIF_CFG_DEV0_EPF3_0_LINK_CNTL__COMMON_CLOCK_CFG_MASK                                                  0x0040L
#define BIF_CFG_DEV0_EPF3_0_LINK_CNTL__EXTENDED_SYNC_MASK                                                     0x0080L
#define BIF_CFG_DEV0_EPF3_0_LINK_CNTL__CLOCK_POWER_MANAGEMENT_EN_MASK                                         0x0100L
#define BIF_CFG_DEV0_EPF3_0_LINK_CNTL__HW_AUTONOMOUS_WIDTH_DISABLE_MASK                                       0x0200L
#define BIF_CFG_DEV0_EPF3_0_LINK_CNTL__LINK_BW_MANAGEMENT_INT_EN_MASK                                         0x0400L
#define BIF_CFG_DEV0_EPF3_0_LINK_CNTL__LINK_AUTONOMOUS_BW_INT_EN_MASK                                         0x0800L
//BIF_CFG_DEV0_EPF3_0_LINK_STATUS
#define BIF_CFG_DEV0_EPF3_0_LINK_STATUS__CURRENT_LINK_SPEED__SHIFT                                            0x0
#define BIF_CFG_DEV0_EPF3_0_LINK_STATUS__NEGOTIATED_LINK_WIDTH__SHIFT                                         0x4
#define BIF_CFG_DEV0_EPF3_0_LINK_STATUS__LINK_TRAINING__SHIFT                                                 0xb
#define BIF_CFG_DEV0_EPF3_0_LINK_STATUS__SLOT_CLOCK_CFG__SHIFT                                                0xc
#define BIF_CFG_DEV0_EPF3_0_LINK_STATUS__DL_ACTIVE__SHIFT                                                     0xd
#define BIF_CFG_DEV0_EPF3_0_LINK_STATUS__LINK_BW_MANAGEMENT_STATUS__SHIFT                                     0xe
#define BIF_CFG_DEV0_EPF3_0_LINK_STATUS__LINK_AUTONOMOUS_BW_STATUS__SHIFT                                     0xf
#define BIF_CFG_DEV0_EPF3_0_LINK_STATUS__CURRENT_LINK_SPEED_MASK                                              0x000FL
#define BIF_CFG_DEV0_EPF3_0_LINK_STATUS__NEGOTIATED_LINK_WIDTH_MASK                                           0x03F0L
#define BIF_CFG_DEV0_EPF3_0_LINK_STATUS__LINK_TRAINING_MASK                                                   0x0800L
#define BIF_CFG_DEV0_EPF3_0_LINK_STATUS__SLOT_CLOCK_CFG_MASK                                                  0x1000L
#define BIF_CFG_DEV0_EPF3_0_LINK_STATUS__DL_ACTIVE_MASK                                                       0x2000L
#define BIF_CFG_DEV0_EPF3_0_LINK_STATUS__LINK_BW_MANAGEMENT_STATUS_MASK                                       0x4000L
#define BIF_CFG_DEV0_EPF3_0_LINK_STATUS__LINK_AUTONOMOUS_BW_STATUS_MASK                                       0x8000L
//BIF_CFG_DEV0_EPF3_0_DEVICE_CAP2
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CAP2__CPL_TIMEOUT_RANGE_SUPPORTED__SHIFT                                   0x0
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CAP2__CPL_TIMEOUT_DIS_SUPPORTED__SHIFT                                     0x4
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CAP2__ARI_FORWARDING_SUPPORTED__SHIFT                                      0x5
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CAP2__ATOMICOP_ROUTING_SUPPORTED__SHIFT                                    0x6
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CAP2__ATOMICOP_32CMPLT_SUPPORTED__SHIFT                                    0x7
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CAP2__ATOMICOP_64CMPLT_SUPPORTED__SHIFT                                    0x8
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CAP2__CAS128_CMPLT_SUPPORTED__SHIFT                                        0x9
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CAP2__NO_RO_ENABLED_P2P_PASSING__SHIFT                                     0xa
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CAP2__LTR_SUPPORTED__SHIFT                                                 0xb
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CAP2__TPH_CPLR_SUPPORTED__SHIFT                                            0xc
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CAP2__OBFF_SUPPORTED__SHIFT                                                0x12
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CAP2__EXTENDED_FMT_FIELD_SUPPORTED__SHIFT                                  0x14
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CAP2__END_END_TLP_PREFIX_SUPPORTED__SHIFT                                  0x15
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CAP2__MAX_END_END_TLP_PREFIXES__SHIFT                                      0x16
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CAP2__CPL_TIMEOUT_RANGE_SUPPORTED_MASK                                     0x0000000FL
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CAP2__CPL_TIMEOUT_DIS_SUPPORTED_MASK                                       0x00000010L
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CAP2__ARI_FORWARDING_SUPPORTED_MASK                                        0x00000020L
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CAP2__ATOMICOP_ROUTING_SUPPORTED_MASK                                      0x00000040L
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CAP2__ATOMICOP_32CMPLT_SUPPORTED_MASK                                      0x00000080L
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CAP2__ATOMICOP_64CMPLT_SUPPORTED_MASK                                      0x00000100L
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CAP2__CAS128_CMPLT_SUPPORTED_MASK                                          0x00000200L
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CAP2__NO_RO_ENABLED_P2P_PASSING_MASK                                       0x00000400L
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CAP2__LTR_SUPPORTED_MASK                                                   0x00000800L
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CAP2__TPH_CPLR_SUPPORTED_MASK                                              0x00003000L
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CAP2__OBFF_SUPPORTED_MASK                                                  0x000C0000L
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CAP2__EXTENDED_FMT_FIELD_SUPPORTED_MASK                                    0x00100000L
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CAP2__END_END_TLP_PREFIX_SUPPORTED_MASK                                    0x00200000L
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CAP2__MAX_END_END_TLP_PREFIXES_MASK                                        0x00C00000L
//BIF_CFG_DEV0_EPF3_0_DEVICE_CNTL2
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CNTL2__CPL_TIMEOUT_VALUE__SHIFT                                            0x0
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CNTL2__CPL_TIMEOUT_DIS__SHIFT                                              0x4
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CNTL2__ARI_FORWARDING_EN__SHIFT                                            0x5
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CNTL2__ATOMICOP_REQUEST_EN__SHIFT                                          0x6
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CNTL2__ATOMICOP_EGRESS_BLOCKING__SHIFT                                     0x7
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CNTL2__IDO_REQUEST_ENABLE__SHIFT                                           0x8
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CNTL2__IDO_COMPLETION_ENABLE__SHIFT                                        0x9
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CNTL2__LTR_EN__SHIFT                                                       0xa
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CNTL2__OBFF_EN__SHIFT                                                      0xd
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CNTL2__END_END_TLP_PREFIX_BLOCKING__SHIFT                                  0xf
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CNTL2__CPL_TIMEOUT_VALUE_MASK                                              0x000FL
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CNTL2__CPL_TIMEOUT_DIS_MASK                                                0x0010L
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CNTL2__ARI_FORWARDING_EN_MASK                                              0x0020L
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CNTL2__ATOMICOP_REQUEST_EN_MASK                                            0x0040L
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CNTL2__ATOMICOP_EGRESS_BLOCKING_MASK                                       0x0080L
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CNTL2__IDO_REQUEST_ENABLE_MASK                                             0x0100L
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CNTL2__IDO_COMPLETION_ENABLE_MASK                                          0x0200L
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CNTL2__LTR_EN_MASK                                                         0x0400L
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CNTL2__OBFF_EN_MASK                                                        0x6000L
#define BIF_CFG_DEV0_EPF3_0_DEVICE_CNTL2__END_END_TLP_PREFIX_BLOCKING_MASK                                    0x8000L
//BIF_CFG_DEV0_EPF3_0_DEVICE_STATUS2
#define BIF_CFG_DEV0_EPF3_0_DEVICE_STATUS2__RESERVED__SHIFT                                                   0x0
#define BIF_CFG_DEV0_EPF3_0_DEVICE_STATUS2__RESERVED_MASK                                                     0xFFFFL
//BIF_CFG_DEV0_EPF3_0_LINK_CAP2
#define BIF_CFG_DEV0_EPF3_0_LINK_CAP2__SUPPORTED_LINK_SPEED__SHIFT                                            0x1
#define BIF_CFG_DEV0_EPF3_0_LINK_CAP2__CROSSLINK_SUPPORTED__SHIFT                                             0x8
#define BIF_CFG_DEV0_EPF3_0_LINK_CAP2__RESERVED__SHIFT                                                        0x9
#define BIF_CFG_DEV0_EPF3_0_LINK_CAP2__SUPPORTED_LINK_SPEED_MASK                                              0x000000FEL
#define BIF_CFG_DEV0_EPF3_0_LINK_CAP2__CROSSLINK_SUPPORTED_MASK                                               0x00000100L
#define BIF_CFG_DEV0_EPF3_0_LINK_CAP2__RESERVED_MASK                                                          0xFFFFFE00L
//BIF_CFG_DEV0_EPF3_0_LINK_CNTL2
#define BIF_CFG_DEV0_EPF3_0_LINK_CNTL2__TARGET_LINK_SPEED__SHIFT                                              0x0
#define BIF_CFG_DEV0_EPF3_0_LINK_CNTL2__ENTER_COMPLIANCE__SHIFT                                               0x4
#define BIF_CFG_DEV0_EPF3_0_LINK_CNTL2__HW_AUTONOMOUS_SPEED_DISABLE__SHIFT                                    0x5
#define BIF_CFG_DEV0_EPF3_0_LINK_CNTL2__SELECTABLE_DEEMPHASIS__SHIFT                                          0x6
#define BIF_CFG_DEV0_EPF3_0_LINK_CNTL2__XMIT_MARGIN__SHIFT                                                    0x7
#define BIF_CFG_DEV0_EPF3_0_LINK_CNTL2__ENTER_MOD_COMPLIANCE__SHIFT                                           0xa
#define BIF_CFG_DEV0_EPF3_0_LINK_CNTL2__COMPLIANCE_SOS__SHIFT                                                 0xb
#define BIF_CFG_DEV0_EPF3_0_LINK_CNTL2__COMPLIANCE_DEEMPHASIS__SHIFT                                          0xc
#define BIF_CFG_DEV0_EPF3_0_LINK_CNTL2__TARGET_LINK_SPEED_MASK                                                0x000FL
#define BIF_CFG_DEV0_EPF3_0_LINK_CNTL2__ENTER_COMPLIANCE_MASK                                                 0x0010L
#define BIF_CFG_DEV0_EPF3_0_LINK_CNTL2__HW_AUTONOMOUS_SPEED_DISABLE_MASK                                      0x0020L
#define BIF_CFG_DEV0_EPF3_0_LINK_CNTL2__SELECTABLE_DEEMPHASIS_MASK                                            0x0040L
#define BIF_CFG_DEV0_EPF3_0_LINK_CNTL2__XMIT_MARGIN_MASK                                                      0x0380L
#define BIF_CFG_DEV0_EPF3_0_LINK_CNTL2__ENTER_MOD_COMPLIANCE_MASK                                             0x0400L
#define BIF_CFG_DEV0_EPF3_0_LINK_CNTL2__COMPLIANCE_SOS_MASK                                                   0x0800L
#define BIF_CFG_DEV0_EPF3_0_LINK_CNTL2__COMPLIANCE_DEEMPHASIS_MASK                                            0xF000L
//BIF_CFG_DEV0_EPF3_0_LINK_STATUS2
#define BIF_CFG_DEV0_EPF3_0_LINK_STATUS2__CUR_DEEMPHASIS_LEVEL__SHIFT                                         0x0
#define BIF_CFG_DEV0_EPF3_0_LINK_STATUS2__EQUALIZATION_COMPLETE__SHIFT                                        0x1
#define BIF_CFG_DEV0_EPF3_0_LINK_STATUS2__EQUALIZATION_PHASE1_SUCCESS__SHIFT                                  0x2
#define BIF_CFG_DEV0_EPF3_0_LINK_STATUS2__EQUALIZATION_PHASE2_SUCCESS__SHIFT                                  0x3
#define BIF_CFG_DEV0_EPF3_0_LINK_STATUS2__EQUALIZATION_PHASE3_SUCCESS__SHIFT                                  0x4
#define BIF_CFG_DEV0_EPF3_0_LINK_STATUS2__LINK_EQUALIZATION_REQUEST__SHIFT                                    0x5
#define BIF_CFG_DEV0_EPF3_0_LINK_STATUS2__CUR_DEEMPHASIS_LEVEL_MASK                                           0x0001L
#define BIF_CFG_DEV0_EPF3_0_LINK_STATUS2__EQUALIZATION_COMPLETE_MASK                                          0x0002L
#define BIF_CFG_DEV0_EPF3_0_LINK_STATUS2__EQUALIZATION_PHASE1_SUCCESS_MASK                                    0x0004L
#define BIF_CFG_DEV0_EPF3_0_LINK_STATUS2__EQUALIZATION_PHASE2_SUCCESS_MASK                                    0x0008L
#define BIF_CFG_DEV0_EPF3_0_LINK_STATUS2__EQUALIZATION_PHASE3_SUCCESS_MASK                                    0x0010L
#define BIF_CFG_DEV0_EPF3_0_LINK_STATUS2__LINK_EQUALIZATION_REQUEST_MASK                                      0x0020L
//BIF_CFG_DEV0_EPF3_0_SLOT_CAP2
#define BIF_CFG_DEV0_EPF3_0_SLOT_CAP2__RESERVED__SHIFT                                                        0x0
#define BIF_CFG_DEV0_EPF3_0_SLOT_CAP2__RESERVED_MASK                                                          0xFFFFFFFFL
//BIF_CFG_DEV0_EPF3_0_SLOT_CNTL2
#define BIF_CFG_DEV0_EPF3_0_SLOT_CNTL2__RESERVED__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF3_0_SLOT_CNTL2__RESERVED_MASK                                                         0xFFFFL
//BIF_CFG_DEV0_EPF3_0_SLOT_STATUS2
#define BIF_CFG_DEV0_EPF3_0_SLOT_STATUS2__RESERVED__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF3_0_SLOT_STATUS2__RESERVED_MASK                                                       0xFFFFL
//BIF_CFG_DEV0_EPF3_0_MSI_CAP_LIST
#define BIF_CFG_DEV0_EPF3_0_MSI_CAP_LIST__CAP_ID__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF3_0_MSI_CAP_LIST__NEXT_PTR__SHIFT                                                     0x8
#define BIF_CFG_DEV0_EPF3_0_MSI_CAP_LIST__CAP_ID_MASK                                                         0x00FFL
#define BIF_CFG_DEV0_EPF3_0_MSI_CAP_LIST__NEXT_PTR_MASK                                                       0xFF00L
//BIF_CFG_DEV0_EPF3_0_MSI_MSG_CNTL
#define BIF_CFG_DEV0_EPF3_0_MSI_MSG_CNTL__MSI_EN__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF3_0_MSI_MSG_CNTL__MSI_MULTI_CAP__SHIFT                                                0x1
#define BIF_CFG_DEV0_EPF3_0_MSI_MSG_CNTL__MSI_MULTI_EN__SHIFT                                                 0x4
#define BIF_CFG_DEV0_EPF3_0_MSI_MSG_CNTL__MSI_64BIT__SHIFT                                                    0x7
#define BIF_CFG_DEV0_EPF3_0_MSI_MSG_CNTL__MSI_PERVECTOR_MASKING_CAP__SHIFT                                    0x8
#define BIF_CFG_DEV0_EPF3_0_MSI_MSG_CNTL__MSI_EN_MASK                                                         0x0001L
#define BIF_CFG_DEV0_EPF3_0_MSI_MSG_CNTL__MSI_MULTI_CAP_MASK                                                  0x000EL
#define BIF_CFG_DEV0_EPF3_0_MSI_MSG_CNTL__MSI_MULTI_EN_MASK                                                   0x0070L
#define BIF_CFG_DEV0_EPF3_0_MSI_MSG_CNTL__MSI_64BIT_MASK                                                      0x0080L
#define BIF_CFG_DEV0_EPF3_0_MSI_MSG_CNTL__MSI_PERVECTOR_MASKING_CAP_MASK                                      0x0100L
//BIF_CFG_DEV0_EPF3_0_MSI_MSG_ADDR_LO
#define BIF_CFG_DEV0_EPF3_0_MSI_MSG_ADDR_LO__MSI_MSG_ADDR_LO__SHIFT                                           0x2
#define BIF_CFG_DEV0_EPF3_0_MSI_MSG_ADDR_LO__MSI_MSG_ADDR_LO_MASK                                             0xFFFFFFFCL
//BIF_CFG_DEV0_EPF3_0_MSI_MSG_ADDR_HI
#define BIF_CFG_DEV0_EPF3_0_MSI_MSG_ADDR_HI__MSI_MSG_ADDR_HI__SHIFT                                           0x0
#define BIF_CFG_DEV0_EPF3_0_MSI_MSG_ADDR_HI__MSI_MSG_ADDR_HI_MASK                                             0xFFFFFFFFL
//BIF_CFG_DEV0_EPF3_0_MSI_MSG_DATA
#define BIF_CFG_DEV0_EPF3_0_MSI_MSG_DATA__MSI_DATA__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF3_0_MSI_MSG_DATA__MSI_DATA_MASK                                                       0x0000FFFFL
//BIF_CFG_DEV0_EPF3_0_MSI_MASK
#define BIF_CFG_DEV0_EPF3_0_MSI_MASK__MSI_MASK__SHIFT                                                         0x0
#define BIF_CFG_DEV0_EPF3_0_MSI_MASK__MSI_MASK_MASK                                                           0xFFFFFFFFL
//BIF_CFG_DEV0_EPF3_0_MSI_MSG_DATA_64
#define BIF_CFG_DEV0_EPF3_0_MSI_MSG_DATA_64__MSI_DATA_64__SHIFT                                               0x0
#define BIF_CFG_DEV0_EPF3_0_MSI_MSG_DATA_64__MSI_DATA_64_MASK                                                 0x0000FFFFL
//BIF_CFG_DEV0_EPF3_0_MSI_MASK_64
#define BIF_CFG_DEV0_EPF3_0_MSI_MASK_64__MSI_MASK_64__SHIFT                                                   0x0
#define BIF_CFG_DEV0_EPF3_0_MSI_MASK_64__MSI_MASK_64_MASK                                                     0xFFFFFFFFL
//BIF_CFG_DEV0_EPF3_0_MSI_PENDING
#define BIF_CFG_DEV0_EPF3_0_MSI_PENDING__MSI_PENDING__SHIFT                                                   0x0
#define BIF_CFG_DEV0_EPF3_0_MSI_PENDING__MSI_PENDING_MASK                                                     0xFFFFFFFFL
//BIF_CFG_DEV0_EPF3_0_MSI_PENDING_64
#define BIF_CFG_DEV0_EPF3_0_MSI_PENDING_64__MSI_PENDING_64__SHIFT                                             0x0
#define BIF_CFG_DEV0_EPF3_0_MSI_PENDING_64__MSI_PENDING_64_MASK                                               0xFFFFFFFFL
//BIF_CFG_DEV0_EPF3_0_MSIX_CAP_LIST
#define BIF_CFG_DEV0_EPF3_0_MSIX_CAP_LIST__CAP_ID__SHIFT                                                      0x0
#define BIF_CFG_DEV0_EPF3_0_MSIX_CAP_LIST__NEXT_PTR__SHIFT                                                    0x8
#define BIF_CFG_DEV0_EPF3_0_MSIX_CAP_LIST__CAP_ID_MASK                                                        0x00FFL
#define BIF_CFG_DEV0_EPF3_0_MSIX_CAP_LIST__NEXT_PTR_MASK                                                      0xFF00L
//BIF_CFG_DEV0_EPF3_0_MSIX_MSG_CNTL
#define BIF_CFG_DEV0_EPF3_0_MSIX_MSG_CNTL__MSIX_TABLE_SIZE__SHIFT                                             0x0
#define BIF_CFG_DEV0_EPF3_0_MSIX_MSG_CNTL__MSIX_FUNC_MASK__SHIFT                                              0xe
#define BIF_CFG_DEV0_EPF3_0_MSIX_MSG_CNTL__MSIX_EN__SHIFT                                                     0xf
#define BIF_CFG_DEV0_EPF3_0_MSIX_MSG_CNTL__MSIX_TABLE_SIZE_MASK                                               0x07FFL
#define BIF_CFG_DEV0_EPF3_0_MSIX_MSG_CNTL__MSIX_FUNC_MASK_MASK                                                0x4000L
#define BIF_CFG_DEV0_EPF3_0_MSIX_MSG_CNTL__MSIX_EN_MASK                                                       0x8000L
//BIF_CFG_DEV0_EPF3_0_MSIX_TABLE
#define BIF_CFG_DEV0_EPF3_0_MSIX_TABLE__MSIX_TABLE_BIR__SHIFT                                                 0x0
#define BIF_CFG_DEV0_EPF3_0_MSIX_TABLE__MSIX_TABLE_OFFSET__SHIFT                                              0x3
#define BIF_CFG_DEV0_EPF3_0_MSIX_TABLE__MSIX_TABLE_BIR_MASK                                                   0x00000007L
#define BIF_CFG_DEV0_EPF3_0_MSIX_TABLE__MSIX_TABLE_OFFSET_MASK                                                0xFFFFFFF8L
//BIF_CFG_DEV0_EPF3_0_MSIX_PBA
#define BIF_CFG_DEV0_EPF3_0_MSIX_PBA__MSIX_PBA_BIR__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF3_0_MSIX_PBA__MSIX_PBA_OFFSET__SHIFT                                                  0x3
#define BIF_CFG_DEV0_EPF3_0_MSIX_PBA__MSIX_PBA_BIR_MASK                                                       0x00000007L
#define BIF_CFG_DEV0_EPF3_0_MSIX_PBA__MSIX_PBA_OFFSET_MASK                                                    0xFFFFFFF8L
//BIF_CFG_DEV0_EPF3_0_SATA_CAP_0
#define BIF_CFG_DEV0_EPF3_0_SATA_CAP_0__CAP_ID__SHIFT                                                         0x0
#define BIF_CFG_DEV0_EPF3_0_SATA_CAP_0__NEXT_PTR__SHIFT                                                       0x8
#define BIF_CFG_DEV0_EPF3_0_SATA_CAP_0__SATA_CAP_MINOR_REV__SHIFT                                             0x10
#define BIF_CFG_DEV0_EPF3_0_SATA_CAP_0__SATA_CAP_MAJOR_REV__SHIFT                                             0x14
#define BIF_CFG_DEV0_EPF3_0_SATA_CAP_0__SATA_CAP_RESERVED1__SHIFT                                             0x18
#define BIF_CFG_DEV0_EPF3_0_SATA_CAP_0__CAP_ID_MASK                                                           0x000000FFL
#define BIF_CFG_DEV0_EPF3_0_SATA_CAP_0__NEXT_PTR_MASK                                                         0x0000FF00L
#define BIF_CFG_DEV0_EPF3_0_SATA_CAP_0__SATA_CAP_MINOR_REV_MASK                                               0x000F0000L
#define BIF_CFG_DEV0_EPF3_0_SATA_CAP_0__SATA_CAP_MAJOR_REV_MASK                                               0x00F00000L
#define BIF_CFG_DEV0_EPF3_0_SATA_CAP_0__SATA_CAP_RESERVED1_MASK                                               0xFF000000L
//BIF_CFG_DEV0_EPF3_0_SATA_CAP_1
#define BIF_CFG_DEV0_EPF3_0_SATA_CAP_1__SATA_CAP_BAR_LOC__SHIFT                                               0x0
#define BIF_CFG_DEV0_EPF3_0_SATA_CAP_1__SATA_CAP_BAR_OFFSET__SHIFT                                            0x4
#define BIF_CFG_DEV0_EPF3_0_SATA_CAP_1__SATA_CAP_RESERVED2__SHIFT                                             0x18
#define BIF_CFG_DEV0_EPF3_0_SATA_CAP_1__SATA_CAP_BAR_LOC_MASK                                                 0x0000000FL
#define BIF_CFG_DEV0_EPF3_0_SATA_CAP_1__SATA_CAP_BAR_OFFSET_MASK                                              0x00FFFFF0L
#define BIF_CFG_DEV0_EPF3_0_SATA_CAP_1__SATA_CAP_RESERVED2_MASK                                               0xFF000000L
//BIF_CFG_DEV0_EPF3_0_SATA_IDP_INDEX
#define BIF_CFG_DEV0_EPF3_0_SATA_IDP_INDEX__IDP_RESERVED1__SHIFT                                              0x0
#define BIF_CFG_DEV0_EPF3_0_SATA_IDP_INDEX__IDP_INDEX__SHIFT                                                  0x2
#define BIF_CFG_DEV0_EPF3_0_SATA_IDP_INDEX__IDP_RESERVED2__SHIFT                                              0xc
#define BIF_CFG_DEV0_EPF3_0_SATA_IDP_INDEX__IDP_RESERVED1_MASK                                                0x00000003L
#define BIF_CFG_DEV0_EPF3_0_SATA_IDP_INDEX__IDP_INDEX_MASK                                                    0x00000FFCL
#define BIF_CFG_DEV0_EPF3_0_SATA_IDP_INDEX__IDP_RESERVED2_MASK                                                0xFFFFF000L
//BIF_CFG_DEV0_EPF3_0_SATA_IDP_DATA
#define BIF_CFG_DEV0_EPF3_0_SATA_IDP_DATA__IDP_DATA__SHIFT                                                    0x0
#define BIF_CFG_DEV0_EPF3_0_SATA_IDP_DATA__IDP_DATA_MASK                                                      0xFFFFFFFFL
//BIF_CFG_DEV0_EPF3_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF3_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_ID__SHIFT                                  0x0
#define BIF_CFG_DEV0_EPF3_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_VER__SHIFT                                 0x10
#define BIF_CFG_DEV0_EPF3_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__NEXT_PTR__SHIFT                                0x14
#define BIF_CFG_DEV0_EPF3_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_ID_MASK                                    0x0000FFFFL
#define BIF_CFG_DEV0_EPF3_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_VER_MASK                                   0x000F0000L
#define BIF_CFG_DEV0_EPF3_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__NEXT_PTR_MASK                                  0xFFF00000L
//BIF_CFG_DEV0_EPF3_0_PCIE_VENDOR_SPECIFIC_HDR
#define BIF_CFG_DEV0_EPF3_0_PCIE_VENDOR_SPECIFIC_HDR__VSEC_ID__SHIFT                                          0x0
#define BIF_CFG_DEV0_EPF3_0_PCIE_VENDOR_SPECIFIC_HDR__VSEC_REV__SHIFT                                         0x10
#define BIF_CFG_DEV0_EPF3_0_PCIE_VENDOR_SPECIFIC_HDR__VSEC_LENGTH__SHIFT                                      0x14
#define BIF_CFG_DEV0_EPF3_0_PCIE_VENDOR_SPECIFIC_HDR__VSEC_ID_MASK                                            0x0000FFFFL
#define BIF_CFG_DEV0_EPF3_0_PCIE_VENDOR_SPECIFIC_HDR__VSEC_REV_MASK                                           0x000F0000L
#define BIF_CFG_DEV0_EPF3_0_PCIE_VENDOR_SPECIFIC_HDR__VSEC_LENGTH_MASK                                        0xFFF00000L
//BIF_CFG_DEV0_EPF3_0_PCIE_VENDOR_SPECIFIC1
#define BIF_CFG_DEV0_EPF3_0_PCIE_VENDOR_SPECIFIC1__SCRATCH__SHIFT                                             0x0
#define BIF_CFG_DEV0_EPF3_0_PCIE_VENDOR_SPECIFIC1__SCRATCH_MASK                                               0xFFFFFFFFL
//BIF_CFG_DEV0_EPF3_0_PCIE_VENDOR_SPECIFIC2
#define BIF_CFG_DEV0_EPF3_0_PCIE_VENDOR_SPECIFIC2__SCRATCH__SHIFT                                             0x0
#define BIF_CFG_DEV0_EPF3_0_PCIE_VENDOR_SPECIFIC2__SCRATCH_MASK                                               0xFFFFFFFFL
//BIF_CFG_DEV0_EPF3_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF3_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_ID__SHIFT                                      0x0
#define BIF_CFG_DEV0_EPF3_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_VER__SHIFT                                     0x10
#define BIF_CFG_DEV0_EPF3_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__NEXT_PTR__SHIFT                                    0x14
#define BIF_CFG_DEV0_EPF3_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_ID_MASK                                        0x0000FFFFL
#define BIF_CFG_DEV0_EPF3_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_VER_MASK                                       0x000F0000L
#define BIF_CFG_DEV0_EPF3_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__NEXT_PTR_MASK                                      0xFFF00000L
//BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_STATUS
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_STATUS__DLP_ERR_STATUS__SHIFT                                     0x4
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_STATUS__SURPDN_ERR_STATUS__SHIFT                                  0x5
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_STATUS__PSN_ERR_STATUS__SHIFT                                     0xc
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_STATUS__FC_ERR_STATUS__SHIFT                                      0xd
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_STATUS__CPL_TIMEOUT_STATUS__SHIFT                                 0xe
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_STATUS__CPL_ABORT_ERR_STATUS__SHIFT                               0xf
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_STATUS__UNEXP_CPL_STATUS__SHIFT                                   0x10
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_STATUS__RCV_OVFL_STATUS__SHIFT                                    0x11
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_STATUS__MAL_TLP_STATUS__SHIFT                                     0x12
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_STATUS__ECRC_ERR_STATUS__SHIFT                                    0x13
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_STATUS__UNSUPP_REQ_ERR_STATUS__SHIFT                              0x14
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_STATUS__ACS_VIOLATION_STATUS__SHIFT                               0x15
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_STATUS__UNCORR_INT_ERR_STATUS__SHIFT                              0x16
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_STATUS__MC_BLOCKED_TLP_STATUS__SHIFT                              0x17
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_STATUS__ATOMICOP_EGRESS_BLOCKED_STATUS__SHIFT                     0x18
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_STATUS__TLP_PREFIX_BLOCKED_ERR_STATUS__SHIFT                      0x19
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_STATUS__DLP_ERR_STATUS_MASK                                       0x00000010L
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_STATUS__SURPDN_ERR_STATUS_MASK                                    0x00000020L
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_STATUS__PSN_ERR_STATUS_MASK                                       0x00001000L
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_STATUS__FC_ERR_STATUS_MASK                                        0x00002000L
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_STATUS__CPL_TIMEOUT_STATUS_MASK                                   0x00004000L
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_STATUS__CPL_ABORT_ERR_STATUS_MASK                                 0x00008000L
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_STATUS__UNEXP_CPL_STATUS_MASK                                     0x00010000L
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_STATUS__RCV_OVFL_STATUS_MASK                                      0x00020000L
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_STATUS__MAL_TLP_STATUS_MASK                                       0x00040000L
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_STATUS__ECRC_ERR_STATUS_MASK                                      0x00080000L
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_STATUS__UNSUPP_REQ_ERR_STATUS_MASK                                0x00100000L
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_STATUS__ACS_VIOLATION_STATUS_MASK                                 0x00200000L
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_STATUS__UNCORR_INT_ERR_STATUS_MASK                                0x00400000L
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_STATUS__MC_BLOCKED_TLP_STATUS_MASK                                0x00800000L
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_STATUS__ATOMICOP_EGRESS_BLOCKED_STATUS_MASK                       0x01000000L
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_STATUS__TLP_PREFIX_BLOCKED_ERR_STATUS_MASK                        0x02000000L
//BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_MASK
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_MASK__DLP_ERR_MASK__SHIFT                                         0x4
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_MASK__SURPDN_ERR_MASK__SHIFT                                      0x5
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_MASK__PSN_ERR_MASK__SHIFT                                         0xc
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_MASK__FC_ERR_MASK__SHIFT                                          0xd
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_MASK__CPL_TIMEOUT_MASK__SHIFT                                     0xe
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_MASK__CPL_ABORT_ERR_MASK__SHIFT                                   0xf
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_MASK__UNEXP_CPL_MASK__SHIFT                                       0x10
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_MASK__RCV_OVFL_MASK__SHIFT                                        0x11
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_MASK__MAL_TLP_MASK__SHIFT                                         0x12
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_MASK__ECRC_ERR_MASK__SHIFT                                        0x13
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_MASK__UNSUPP_REQ_ERR_MASK__SHIFT                                  0x14
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_MASK__ACS_VIOLATION_MASK__SHIFT                                   0x15
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_MASK__UNCORR_INT_ERR_MASK__SHIFT                                  0x16
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_MASK__MC_BLOCKED_TLP_MASK__SHIFT                                  0x17
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_MASK__ATOMICOP_EGRESS_BLOCKED_MASK__SHIFT                         0x18
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_MASK__TLP_PREFIX_BLOCKED_ERR_MASK__SHIFT                          0x19
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_MASK__DLP_ERR_MASK_MASK                                           0x00000010L
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_MASK__SURPDN_ERR_MASK_MASK                                        0x00000020L
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_MASK__PSN_ERR_MASK_MASK                                           0x00001000L
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_MASK__FC_ERR_MASK_MASK                                            0x00002000L
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_MASK__CPL_TIMEOUT_MASK_MASK                                       0x00004000L
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_MASK__CPL_ABORT_ERR_MASK_MASK                                     0x00008000L
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_MASK__UNEXP_CPL_MASK_MASK                                         0x00010000L
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_MASK__RCV_OVFL_MASK_MASK                                          0x00020000L
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_MASK__MAL_TLP_MASK_MASK                                           0x00040000L
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_MASK__ECRC_ERR_MASK_MASK                                          0x00080000L
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_MASK__UNSUPP_REQ_ERR_MASK_MASK                                    0x00100000L
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_MASK__ACS_VIOLATION_MASK_MASK                                     0x00200000L
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_MASK__UNCORR_INT_ERR_MASK_MASK                                    0x00400000L
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_MASK__MC_BLOCKED_TLP_MASK_MASK                                    0x00800000L
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_MASK__ATOMICOP_EGRESS_BLOCKED_MASK_MASK                           0x01000000L
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_MASK__TLP_PREFIX_BLOCKED_ERR_MASK_MASK                            0x02000000L
//BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_SEVERITY
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_SEVERITY__DLP_ERR_SEVERITY__SHIFT                                 0x4
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_SEVERITY__SURPDN_ERR_SEVERITY__SHIFT                              0x5
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_SEVERITY__PSN_ERR_SEVERITY__SHIFT                                 0xc
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_SEVERITY__FC_ERR_SEVERITY__SHIFT                                  0xd
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_SEVERITY__CPL_TIMEOUT_SEVERITY__SHIFT                             0xe
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_SEVERITY__CPL_ABORT_ERR_SEVERITY__SHIFT                           0xf
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_SEVERITY__UNEXP_CPL_SEVERITY__SHIFT                               0x10
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_SEVERITY__RCV_OVFL_SEVERITY__SHIFT                                0x11
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_SEVERITY__MAL_TLP_SEVERITY__SHIFT                                 0x12
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_SEVERITY__ECRC_ERR_SEVERITY__SHIFT                                0x13
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_SEVERITY__UNSUPP_REQ_ERR_SEVERITY__SHIFT                          0x14
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_SEVERITY__ACS_VIOLATION_SEVERITY__SHIFT                           0x15
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_SEVERITY__UNCORR_INT_ERR_SEVERITY__SHIFT                          0x16
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_SEVERITY__MC_BLOCKED_TLP_SEVERITY__SHIFT                          0x17
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_SEVERITY__ATOMICOP_EGRESS_BLOCKED_SEVERITY__SHIFT                 0x18
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_SEVERITY__TLP_PREFIX_BLOCKED_ERR_SEVERITY__SHIFT                  0x19
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_SEVERITY__DLP_ERR_SEVERITY_MASK                                   0x00000010L
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_SEVERITY__SURPDN_ERR_SEVERITY_MASK                                0x00000020L
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_SEVERITY__PSN_ERR_SEVERITY_MASK                                   0x00001000L
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_SEVERITY__FC_ERR_SEVERITY_MASK                                    0x00002000L
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_SEVERITY__CPL_TIMEOUT_SEVERITY_MASK                               0x00004000L
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_SEVERITY__CPL_ABORT_ERR_SEVERITY_MASK                             0x00008000L
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_SEVERITY__UNEXP_CPL_SEVERITY_MASK                                 0x00010000L
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_SEVERITY__RCV_OVFL_SEVERITY_MASK                                  0x00020000L
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_SEVERITY__MAL_TLP_SEVERITY_MASK                                   0x00040000L
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_SEVERITY__ECRC_ERR_SEVERITY_MASK                                  0x00080000L
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_SEVERITY__UNSUPP_REQ_ERR_SEVERITY_MASK                            0x00100000L
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_SEVERITY__ACS_VIOLATION_SEVERITY_MASK                             0x00200000L
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_SEVERITY__UNCORR_INT_ERR_SEVERITY_MASK                            0x00400000L
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_SEVERITY__MC_BLOCKED_TLP_SEVERITY_MASK                            0x00800000L
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_SEVERITY__ATOMICOP_EGRESS_BLOCKED_SEVERITY_MASK                   0x01000000L
#define BIF_CFG_DEV0_EPF3_0_PCIE_UNCORR_ERR_SEVERITY__TLP_PREFIX_BLOCKED_ERR_SEVERITY_MASK                    0x02000000L
//BIF_CFG_DEV0_EPF3_0_PCIE_CORR_ERR_STATUS
#define BIF_CFG_DEV0_EPF3_0_PCIE_CORR_ERR_STATUS__RCV_ERR_STATUS__SHIFT                                       0x0
#define BIF_CFG_DEV0_EPF3_0_PCIE_CORR_ERR_STATUS__BAD_TLP_STATUS__SHIFT                                       0x6
#define BIF_CFG_DEV0_EPF3_0_PCIE_CORR_ERR_STATUS__BAD_DLLP_STATUS__SHIFT                                      0x7
#define BIF_CFG_DEV0_EPF3_0_PCIE_CORR_ERR_STATUS__REPLAY_NUM_ROLLOVER_STATUS__SHIFT                           0x8
#define BIF_CFG_DEV0_EPF3_0_PCIE_CORR_ERR_STATUS__REPLAY_TIMER_TIMEOUT_STATUS__SHIFT                          0xc
#define BIF_CFG_DEV0_EPF3_0_PCIE_CORR_ERR_STATUS__ADVISORY_NONFATAL_ERR_STATUS__SHIFT                         0xd
#define BIF_CFG_DEV0_EPF3_0_PCIE_CORR_ERR_STATUS__CORR_INT_ERR_STATUS__SHIFT                                  0xe
#define BIF_CFG_DEV0_EPF3_0_PCIE_CORR_ERR_STATUS__HDR_LOG_OVFL_STATUS__SHIFT                                  0xf
#define BIF_CFG_DEV0_EPF3_0_PCIE_CORR_ERR_STATUS__RCV_ERR_STATUS_MASK                                         0x00000001L
#define BIF_CFG_DEV0_EPF3_0_PCIE_CORR_ERR_STATUS__BAD_TLP_STATUS_MASK                                         0x00000040L
#define BIF_CFG_DEV0_EPF3_0_PCIE_CORR_ERR_STATUS__BAD_DLLP_STATUS_MASK                                        0x00000080L
#define BIF_CFG_DEV0_EPF3_0_PCIE_CORR_ERR_STATUS__REPLAY_NUM_ROLLOVER_STATUS_MASK                             0x00000100L
#define BIF_CFG_DEV0_EPF3_0_PCIE_CORR_ERR_STATUS__REPLAY_TIMER_TIMEOUT_STATUS_MASK                            0x00001000L
#define BIF_CFG_DEV0_EPF3_0_PCIE_CORR_ERR_STATUS__ADVISORY_NONFATAL_ERR_STATUS_MASK                           0x00002000L
#define BIF_CFG_DEV0_EPF3_0_PCIE_CORR_ERR_STATUS__CORR_INT_ERR_STATUS_MASK                                    0x00004000L
#define BIF_CFG_DEV0_EPF3_0_PCIE_CORR_ERR_STATUS__HDR_LOG_OVFL_STATUS_MASK                                    0x00008000L
//BIF_CFG_DEV0_EPF3_0_PCIE_CORR_ERR_MASK
#define BIF_CFG_DEV0_EPF3_0_PCIE_CORR_ERR_MASK__RCV_ERR_MASK__SHIFT                                           0x0
#define BIF_CFG_DEV0_EPF3_0_PCIE_CORR_ERR_MASK__BAD_TLP_MASK__SHIFT                                           0x6
#define BIF_CFG_DEV0_EPF3_0_PCIE_CORR_ERR_MASK__BAD_DLLP_MASK__SHIFT                                          0x7
#define BIF_CFG_DEV0_EPF3_0_PCIE_CORR_ERR_MASK__REPLAY_NUM_ROLLOVER_MASK__SHIFT                               0x8
#define BIF_CFG_DEV0_EPF3_0_PCIE_CORR_ERR_MASK__REPLAY_TIMER_TIMEOUT_MASK__SHIFT                              0xc
#define BIF_CFG_DEV0_EPF3_0_PCIE_CORR_ERR_MASK__ADVISORY_NONFATAL_ERR_MASK__SHIFT                             0xd
#define BIF_CFG_DEV0_EPF3_0_PCIE_CORR_ERR_MASK__CORR_INT_ERR_MASK__SHIFT                                      0xe
#define BIF_CFG_DEV0_EPF3_0_PCIE_CORR_ERR_MASK__HDR_LOG_OVFL_MASK__SHIFT                                      0xf
#define BIF_CFG_DEV0_EPF3_0_PCIE_CORR_ERR_MASK__RCV_ERR_MASK_MASK                                             0x00000001L
#define BIF_CFG_DEV0_EPF3_0_PCIE_CORR_ERR_MASK__BAD_TLP_MASK_MASK                                             0x00000040L
#define BIF_CFG_DEV0_EPF3_0_PCIE_CORR_ERR_MASK__BAD_DLLP_MASK_MASK                                            0x00000080L
#define BIF_CFG_DEV0_EPF3_0_PCIE_CORR_ERR_MASK__REPLAY_NUM_ROLLOVER_MASK_MASK                                 0x00000100L
#define BIF_CFG_DEV0_EPF3_0_PCIE_CORR_ERR_MASK__REPLAY_TIMER_TIMEOUT_MASK_MASK                                0x00001000L
#define BIF_CFG_DEV0_EPF3_0_PCIE_CORR_ERR_MASK__ADVISORY_NONFATAL_ERR_MASK_MASK                               0x00002000L
#define BIF_CFG_DEV0_EPF3_0_PCIE_CORR_ERR_MASK__CORR_INT_ERR_MASK_MASK                                        0x00004000L
#define BIF_CFG_DEV0_EPF3_0_PCIE_CORR_ERR_MASK__HDR_LOG_OVFL_MASK_MASK                                        0x00008000L
//BIF_CFG_DEV0_EPF3_0_PCIE_ADV_ERR_CAP_CNTL
#define BIF_CFG_DEV0_EPF3_0_PCIE_ADV_ERR_CAP_CNTL__FIRST_ERR_PTR__SHIFT                                       0x0
#define BIF_CFG_DEV0_EPF3_0_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_CAP__SHIFT                                        0x5
#define BIF_CFG_DEV0_EPF3_0_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_EN__SHIFT                                         0x6
#define BIF_CFG_DEV0_EPF3_0_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_CAP__SHIFT                                      0x7
#define BIF_CFG_DEV0_EPF3_0_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_EN__SHIFT                                       0x8
#define BIF_CFG_DEV0_EPF3_0_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_CAP__SHIFT                                  0x9
#define BIF_CFG_DEV0_EPF3_0_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_EN__SHIFT                                   0xa
#define BIF_CFG_DEV0_EPF3_0_PCIE_ADV_ERR_CAP_CNTL__TLP_PREFIX_LOG_PRESENT__SHIFT                              0xb
#define BIF_CFG_DEV0_EPF3_0_PCIE_ADV_ERR_CAP_CNTL__FIRST_ERR_PTR_MASK                                         0x0000001FL
#define BIF_CFG_DEV0_EPF3_0_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_CAP_MASK                                          0x00000020L
#define BIF_CFG_DEV0_EPF3_0_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_EN_MASK                                           0x00000040L
#define BIF_CFG_DEV0_EPF3_0_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_CAP_MASK                                        0x00000080L
#define BIF_CFG_DEV0_EPF3_0_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_EN_MASK                                         0x00000100L
#define BIF_CFG_DEV0_EPF3_0_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_CAP_MASK                                    0x00000200L
#define BIF_CFG_DEV0_EPF3_0_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_EN_MASK                                     0x00000400L
#define BIF_CFG_DEV0_EPF3_0_PCIE_ADV_ERR_CAP_CNTL__TLP_PREFIX_LOG_PRESENT_MASK                                0x00000800L
//BIF_CFG_DEV0_EPF3_0_PCIE_HDR_LOG0
#define BIF_CFG_DEV0_EPF3_0_PCIE_HDR_LOG0__TLP_HDR__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF3_0_PCIE_HDR_LOG0__TLP_HDR_MASK                                                       0xFFFFFFFFL
//BIF_CFG_DEV0_EPF3_0_PCIE_HDR_LOG1
#define BIF_CFG_DEV0_EPF3_0_PCIE_HDR_LOG1__TLP_HDR__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF3_0_PCIE_HDR_LOG1__TLP_HDR_MASK                                                       0xFFFFFFFFL
//BIF_CFG_DEV0_EPF3_0_PCIE_HDR_LOG2
#define BIF_CFG_DEV0_EPF3_0_PCIE_HDR_LOG2__TLP_HDR__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF3_0_PCIE_HDR_LOG2__TLP_HDR_MASK                                                       0xFFFFFFFFL
//BIF_CFG_DEV0_EPF3_0_PCIE_HDR_LOG3
#define BIF_CFG_DEV0_EPF3_0_PCIE_HDR_LOG3__TLP_HDR__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF3_0_PCIE_HDR_LOG3__TLP_HDR_MASK                                                       0xFFFFFFFFL
//BIF_CFG_DEV0_EPF3_0_PCIE_TLP_PREFIX_LOG0
#define BIF_CFG_DEV0_EPF3_0_PCIE_TLP_PREFIX_LOG0__TLP_PREFIX__SHIFT                                           0x0
#define BIF_CFG_DEV0_EPF3_0_PCIE_TLP_PREFIX_LOG0__TLP_PREFIX_MASK                                             0xFFFFFFFFL
//BIF_CFG_DEV0_EPF3_0_PCIE_TLP_PREFIX_LOG1
#define BIF_CFG_DEV0_EPF3_0_PCIE_TLP_PREFIX_LOG1__TLP_PREFIX__SHIFT                                           0x0
#define BIF_CFG_DEV0_EPF3_0_PCIE_TLP_PREFIX_LOG1__TLP_PREFIX_MASK                                             0xFFFFFFFFL
//BIF_CFG_DEV0_EPF3_0_PCIE_TLP_PREFIX_LOG2
#define BIF_CFG_DEV0_EPF3_0_PCIE_TLP_PREFIX_LOG2__TLP_PREFIX__SHIFT                                           0x0
#define BIF_CFG_DEV0_EPF3_0_PCIE_TLP_PREFIX_LOG2__TLP_PREFIX_MASK                                             0xFFFFFFFFL
//BIF_CFG_DEV0_EPF3_0_PCIE_TLP_PREFIX_LOG3
#define BIF_CFG_DEV0_EPF3_0_PCIE_TLP_PREFIX_LOG3__TLP_PREFIX__SHIFT                                           0x0
#define BIF_CFG_DEV0_EPF3_0_PCIE_TLP_PREFIX_LOG3__TLP_PREFIX_MASK                                             0xFFFFFFFFL
//BIF_CFG_DEV0_EPF3_0_PCIE_BAR_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF3_0_PCIE_BAR_ENH_CAP_LIST__CAP_ID__SHIFT                                              0x0
#define BIF_CFG_DEV0_EPF3_0_PCIE_BAR_ENH_CAP_LIST__CAP_VER__SHIFT                                             0x10
#define BIF_CFG_DEV0_EPF3_0_PCIE_BAR_ENH_CAP_LIST__NEXT_PTR__SHIFT                                            0x14
#define BIF_CFG_DEV0_EPF3_0_PCIE_BAR_ENH_CAP_LIST__CAP_ID_MASK                                                0x0000FFFFL
#define BIF_CFG_DEV0_EPF3_0_PCIE_BAR_ENH_CAP_LIST__CAP_VER_MASK                                               0x000F0000L
#define BIF_CFG_DEV0_EPF3_0_PCIE_BAR_ENH_CAP_LIST__NEXT_PTR_MASK                                              0xFFF00000L
//BIF_CFG_DEV0_EPF3_0_PCIE_BAR1_CAP
#define BIF_CFG_DEV0_EPF3_0_PCIE_BAR1_CAP__BAR_SIZE_SUPPORTED__SHIFT                                          0x4
#define BIF_CFG_DEV0_EPF3_0_PCIE_BAR1_CAP__BAR_SIZE_SUPPORTED_MASK                                            0x00FFFFF0L
//BIF_CFG_DEV0_EPF3_0_PCIE_BAR1_CNTL
#define BIF_CFG_DEV0_EPF3_0_PCIE_BAR1_CNTL__BAR_INDEX__SHIFT                                                  0x0
#define BIF_CFG_DEV0_EPF3_0_PCIE_BAR1_CNTL__BAR_TOTAL_NUM__SHIFT                                              0x5
#define BIF_CFG_DEV0_EPF3_0_PCIE_BAR1_CNTL__BAR_SIZE__SHIFT                                                   0x8
#define BIF_CFG_DEV0_EPF3_0_PCIE_BAR1_CNTL__BAR_INDEX_MASK                                                    0x0007L
#define BIF_CFG_DEV0_EPF3_0_PCIE_BAR1_CNTL__BAR_TOTAL_NUM_MASK                                                0x00E0L
#define BIF_CFG_DEV0_EPF3_0_PCIE_BAR1_CNTL__BAR_SIZE_MASK                                                     0x1F00L
//BIF_CFG_DEV0_EPF3_0_PCIE_BAR2_CAP
#define BIF_CFG_DEV0_EPF3_0_PCIE_BAR2_CAP__BAR_SIZE_SUPPORTED__SHIFT                                          0x4
#define BIF_CFG_DEV0_EPF3_0_PCIE_BAR2_CAP__BAR_SIZE_SUPPORTED_MASK                                            0x00FFFFF0L
//BIF_CFG_DEV0_EPF3_0_PCIE_BAR2_CNTL
#define BIF_CFG_DEV0_EPF3_0_PCIE_BAR2_CNTL__BAR_INDEX__SHIFT                                                  0x0
#define BIF_CFG_DEV0_EPF3_0_PCIE_BAR2_CNTL__BAR_TOTAL_NUM__SHIFT                                              0x5
#define BIF_CFG_DEV0_EPF3_0_PCIE_BAR2_CNTL__BAR_SIZE__SHIFT                                                   0x8
#define BIF_CFG_DEV0_EPF3_0_PCIE_BAR2_CNTL__BAR_INDEX_MASK                                                    0x0007L
#define BIF_CFG_DEV0_EPF3_0_PCIE_BAR2_CNTL__BAR_TOTAL_NUM_MASK                                                0x00E0L
#define BIF_CFG_DEV0_EPF3_0_PCIE_BAR2_CNTL__BAR_SIZE_MASK                                                     0x1F00L
//BIF_CFG_DEV0_EPF3_0_PCIE_BAR3_CAP
#define BIF_CFG_DEV0_EPF3_0_PCIE_BAR3_CAP__BAR_SIZE_SUPPORTED__SHIFT                                          0x4
#define BIF_CFG_DEV0_EPF3_0_PCIE_BAR3_CAP__BAR_SIZE_SUPPORTED_MASK                                            0x00FFFFF0L
//BIF_CFG_DEV0_EPF3_0_PCIE_BAR3_CNTL
#define BIF_CFG_DEV0_EPF3_0_PCIE_BAR3_CNTL__BAR_INDEX__SHIFT                                                  0x0
#define BIF_CFG_DEV0_EPF3_0_PCIE_BAR3_CNTL__BAR_TOTAL_NUM__SHIFT                                              0x5
#define BIF_CFG_DEV0_EPF3_0_PCIE_BAR3_CNTL__BAR_SIZE__SHIFT                                                   0x8
#define BIF_CFG_DEV0_EPF3_0_PCIE_BAR3_CNTL__BAR_INDEX_MASK                                                    0x0007L
#define BIF_CFG_DEV0_EPF3_0_PCIE_BAR3_CNTL__BAR_TOTAL_NUM_MASK                                                0x00E0L
#define BIF_CFG_DEV0_EPF3_0_PCIE_BAR3_CNTL__BAR_SIZE_MASK                                                     0x1F00L
//BIF_CFG_DEV0_EPF3_0_PCIE_BAR4_CAP
#define BIF_CFG_DEV0_EPF3_0_PCIE_BAR4_CAP__BAR_SIZE_SUPPORTED__SHIFT                                          0x4
#define BIF_CFG_DEV0_EPF3_0_PCIE_BAR4_CAP__BAR_SIZE_SUPPORTED_MASK                                            0x00FFFFF0L
//BIF_CFG_DEV0_EPF3_0_PCIE_BAR4_CNTL
#define BIF_CFG_DEV0_EPF3_0_PCIE_BAR4_CNTL__BAR_INDEX__SHIFT                                                  0x0
#define BIF_CFG_DEV0_EPF3_0_PCIE_BAR4_CNTL__BAR_TOTAL_NUM__SHIFT                                              0x5
#define BIF_CFG_DEV0_EPF3_0_PCIE_BAR4_CNTL__BAR_SIZE__SHIFT                                                   0x8
#define BIF_CFG_DEV0_EPF3_0_PCIE_BAR4_CNTL__BAR_INDEX_MASK                                                    0x0007L
#define BIF_CFG_DEV0_EPF3_0_PCIE_BAR4_CNTL__BAR_TOTAL_NUM_MASK                                                0x00E0L
#define BIF_CFG_DEV0_EPF3_0_PCIE_BAR4_CNTL__BAR_SIZE_MASK                                                     0x1F00L
//BIF_CFG_DEV0_EPF3_0_PCIE_BAR5_CAP
#define BIF_CFG_DEV0_EPF3_0_PCIE_BAR5_CAP__BAR_SIZE_SUPPORTED__SHIFT                                          0x4
#define BIF_CFG_DEV0_EPF3_0_PCIE_BAR5_CAP__BAR_SIZE_SUPPORTED_MASK                                            0x00FFFFF0L
//BIF_CFG_DEV0_EPF3_0_PCIE_BAR5_CNTL
#define BIF_CFG_DEV0_EPF3_0_PCIE_BAR5_CNTL__BAR_INDEX__SHIFT                                                  0x0
#define BIF_CFG_DEV0_EPF3_0_PCIE_BAR5_CNTL__BAR_TOTAL_NUM__SHIFT                                              0x5
#define BIF_CFG_DEV0_EPF3_0_PCIE_BAR5_CNTL__BAR_SIZE__SHIFT                                                   0x8
#define BIF_CFG_DEV0_EPF3_0_PCIE_BAR5_CNTL__BAR_INDEX_MASK                                                    0x0007L
#define BIF_CFG_DEV0_EPF3_0_PCIE_BAR5_CNTL__BAR_TOTAL_NUM_MASK                                                0x00E0L
#define BIF_CFG_DEV0_EPF3_0_PCIE_BAR5_CNTL__BAR_SIZE_MASK                                                     0x1F00L
//BIF_CFG_DEV0_EPF3_0_PCIE_BAR6_CAP
#define BIF_CFG_DEV0_EPF3_0_PCIE_BAR6_CAP__BAR_SIZE_SUPPORTED__SHIFT                                          0x4
#define BIF_CFG_DEV0_EPF3_0_PCIE_BAR6_CAP__BAR_SIZE_SUPPORTED_MASK                                            0x00FFFFF0L
//BIF_CFG_DEV0_EPF3_0_PCIE_BAR6_CNTL
#define BIF_CFG_DEV0_EPF3_0_PCIE_BAR6_CNTL__BAR_INDEX__SHIFT                                                  0x0
#define BIF_CFG_DEV0_EPF3_0_PCIE_BAR6_CNTL__BAR_TOTAL_NUM__SHIFT                                              0x5
#define BIF_CFG_DEV0_EPF3_0_PCIE_BAR6_CNTL__BAR_SIZE__SHIFT                                                   0x8
#define BIF_CFG_DEV0_EPF3_0_PCIE_BAR6_CNTL__BAR_INDEX_MASK                                                    0x0007L
#define BIF_CFG_DEV0_EPF3_0_PCIE_BAR6_CNTL__BAR_TOTAL_NUM_MASK                                                0x00E0L
#define BIF_CFG_DEV0_EPF3_0_PCIE_BAR6_CNTL__BAR_SIZE_MASK                                                     0x1F00L
//BIF_CFG_DEV0_EPF3_0_PCIE_PWR_BUDGET_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF3_0_PCIE_PWR_BUDGET_ENH_CAP_LIST__CAP_ID__SHIFT                                       0x0
#define BIF_CFG_DEV0_EPF3_0_PCIE_PWR_BUDGET_ENH_CAP_LIST__CAP_VER__SHIFT                                      0x10
#define BIF_CFG_DEV0_EPF3_0_PCIE_PWR_BUDGET_ENH_CAP_LIST__NEXT_PTR__SHIFT                                     0x14
#define BIF_CFG_DEV0_EPF3_0_PCIE_PWR_BUDGET_ENH_CAP_LIST__CAP_ID_MASK                                         0x0000FFFFL
#define BIF_CFG_DEV0_EPF3_0_PCIE_PWR_BUDGET_ENH_CAP_LIST__CAP_VER_MASK                                        0x000F0000L
#define BIF_CFG_DEV0_EPF3_0_PCIE_PWR_BUDGET_ENH_CAP_LIST__NEXT_PTR_MASK                                       0xFFF00000L
//BIF_CFG_DEV0_EPF3_0_PCIE_PWR_BUDGET_DATA_SELECT
#define BIF_CFG_DEV0_EPF3_0_PCIE_PWR_BUDGET_DATA_SELECT__DATA_SELECT__SHIFT                                   0x0
#define BIF_CFG_DEV0_EPF3_0_PCIE_PWR_BUDGET_DATA_SELECT__DATA_SELECT_MASK                                     0xFFL
//BIF_CFG_DEV0_EPF3_0_PCIE_PWR_BUDGET_DATA
#define BIF_CFG_DEV0_EPF3_0_PCIE_PWR_BUDGET_DATA__BASE_POWER__SHIFT                                           0x0
#define BIF_CFG_DEV0_EPF3_0_PCIE_PWR_BUDGET_DATA__DATA_SCALE__SHIFT                                           0x8
#define BIF_CFG_DEV0_EPF3_0_PCIE_PWR_BUDGET_DATA__PM_SUB_STATE__SHIFT                                         0xa
#define BIF_CFG_DEV0_EPF3_0_PCIE_PWR_BUDGET_DATA__PM_STATE__SHIFT                                             0xd
#define BIF_CFG_DEV0_EPF3_0_PCIE_PWR_BUDGET_DATA__TYPE__SHIFT                                                 0xf
#define BIF_CFG_DEV0_EPF3_0_PCIE_PWR_BUDGET_DATA__POWER_RAIL__SHIFT                                           0x12
#define BIF_CFG_DEV0_EPF3_0_PCIE_PWR_BUDGET_DATA__BASE_POWER_MASK                                             0x000000FFL
#define BIF_CFG_DEV0_EPF3_0_PCIE_PWR_BUDGET_DATA__DATA_SCALE_MASK                                             0x00000300L
#define BIF_CFG_DEV0_EPF3_0_PCIE_PWR_BUDGET_DATA__PM_SUB_STATE_MASK                                           0x00001C00L
#define BIF_CFG_DEV0_EPF3_0_PCIE_PWR_BUDGET_DATA__PM_STATE_MASK                                               0x00006000L
#define BIF_CFG_DEV0_EPF3_0_PCIE_PWR_BUDGET_DATA__TYPE_MASK                                                   0x00038000L
#define BIF_CFG_DEV0_EPF3_0_PCIE_PWR_BUDGET_DATA__POWER_RAIL_MASK                                             0x001C0000L
//BIF_CFG_DEV0_EPF3_0_PCIE_PWR_BUDGET_CAP
#define BIF_CFG_DEV0_EPF3_0_PCIE_PWR_BUDGET_CAP__SYSTEM_ALLOCATED__SHIFT                                      0x0
#define BIF_CFG_DEV0_EPF3_0_PCIE_PWR_BUDGET_CAP__SYSTEM_ALLOCATED_MASK                                        0x01L
//BIF_CFG_DEV0_EPF3_0_PCIE_DPA_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF3_0_PCIE_DPA_ENH_CAP_LIST__CAP_ID__SHIFT                                              0x0
#define BIF_CFG_DEV0_EPF3_0_PCIE_DPA_ENH_CAP_LIST__CAP_VER__SHIFT                                             0x10
#define BIF_CFG_DEV0_EPF3_0_PCIE_DPA_ENH_CAP_LIST__NEXT_PTR__SHIFT                                            0x14
#define BIF_CFG_DEV0_EPF3_0_PCIE_DPA_ENH_CAP_LIST__CAP_ID_MASK                                                0x0000FFFFL
#define BIF_CFG_DEV0_EPF3_0_PCIE_DPA_ENH_CAP_LIST__CAP_VER_MASK                                               0x000F0000L
#define BIF_CFG_DEV0_EPF3_0_PCIE_DPA_ENH_CAP_LIST__NEXT_PTR_MASK                                              0xFFF00000L
//BIF_CFG_DEV0_EPF3_0_PCIE_DPA_CAP
#define BIF_CFG_DEV0_EPF3_0_PCIE_DPA_CAP__SUBSTATE_MAX__SHIFT                                                 0x0
#define BIF_CFG_DEV0_EPF3_0_PCIE_DPA_CAP__TRANS_LAT_UNIT__SHIFT                                               0x8
#define BIF_CFG_DEV0_EPF3_0_PCIE_DPA_CAP__PWR_ALLOC_SCALE__SHIFT                                              0xc
#define BIF_CFG_DEV0_EPF3_0_PCIE_DPA_CAP__TRANS_LAT_VAL_0__SHIFT                                              0x10
#define BIF_CFG_DEV0_EPF3_0_PCIE_DPA_CAP__TRANS_LAT_VAL_1__SHIFT                                              0x18
#define BIF_CFG_DEV0_EPF3_0_PCIE_DPA_CAP__SUBSTATE_MAX_MASK                                                   0x0000001FL
#define BIF_CFG_DEV0_EPF3_0_PCIE_DPA_CAP__TRANS_LAT_UNIT_MASK                                                 0x00000300L
#define BIF_CFG_DEV0_EPF3_0_PCIE_DPA_CAP__PWR_ALLOC_SCALE_MASK                                                0x00003000L
#define BIF_CFG_DEV0_EPF3_0_PCIE_DPA_CAP__TRANS_LAT_VAL_0_MASK                                                0x00FF0000L
#define BIF_CFG_DEV0_EPF3_0_PCIE_DPA_CAP__TRANS_LAT_VAL_1_MASK                                                0xFF000000L
//BIF_CFG_DEV0_EPF3_0_PCIE_DPA_LATENCY_INDICATOR
#define BIF_CFG_DEV0_EPF3_0_PCIE_DPA_LATENCY_INDICATOR__TRANS_LAT_INDICATOR_BITS__SHIFT                       0x0
#define BIF_CFG_DEV0_EPF3_0_PCIE_DPA_LATENCY_INDICATOR__TRANS_LAT_INDICATOR_BITS_MASK                         0xFFL
//BIF_CFG_DEV0_EPF3_0_PCIE_DPA_STATUS
#define BIF_CFG_DEV0_EPF3_0_PCIE_DPA_STATUS__SUBSTATE_STATUS__SHIFT                                           0x0
#define BIF_CFG_DEV0_EPF3_0_PCIE_DPA_STATUS__SUBSTATE_CNTL_ENABLED__SHIFT                                     0x8
#define BIF_CFG_DEV0_EPF3_0_PCIE_DPA_STATUS__SUBSTATE_STATUS_MASK                                             0x001FL
#define BIF_CFG_DEV0_EPF3_0_PCIE_DPA_STATUS__SUBSTATE_CNTL_ENABLED_MASK                                       0x0100L
//BIF_CFG_DEV0_EPF3_0_PCIE_DPA_CNTL
#define BIF_CFG_DEV0_EPF3_0_PCIE_DPA_CNTL__SUBSTATE_CNTL__SHIFT                                               0x0
#define BIF_CFG_DEV0_EPF3_0_PCIE_DPA_CNTL__SUBSTATE_CNTL_MASK                                                 0x1FL
//BIF_CFG_DEV0_EPF3_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_0
#define BIF_CFG_DEV0_EPF3_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_0__SUBSTATE_PWR_ALLOC__SHIFT                          0x0
#define BIF_CFG_DEV0_EPF3_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_0__SUBSTATE_PWR_ALLOC_MASK                            0xFFL
//BIF_CFG_DEV0_EPF3_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_1
#define BIF_CFG_DEV0_EPF3_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_1__SUBSTATE_PWR_ALLOC__SHIFT                          0x0
#define BIF_CFG_DEV0_EPF3_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_1__SUBSTATE_PWR_ALLOC_MASK                            0xFFL
//BIF_CFG_DEV0_EPF3_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_2
#define BIF_CFG_DEV0_EPF3_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_2__SUBSTATE_PWR_ALLOC__SHIFT                          0x0
#define BIF_CFG_DEV0_EPF3_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_2__SUBSTATE_PWR_ALLOC_MASK                            0xFFL
//BIF_CFG_DEV0_EPF3_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_3
#define BIF_CFG_DEV0_EPF3_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_3__SUBSTATE_PWR_ALLOC__SHIFT                          0x0
#define BIF_CFG_DEV0_EPF3_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_3__SUBSTATE_PWR_ALLOC_MASK                            0xFFL
//BIF_CFG_DEV0_EPF3_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_4
#define BIF_CFG_DEV0_EPF3_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_4__SUBSTATE_PWR_ALLOC__SHIFT                          0x0
#define BIF_CFG_DEV0_EPF3_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_4__SUBSTATE_PWR_ALLOC_MASK                            0xFFL
//BIF_CFG_DEV0_EPF3_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_5
#define BIF_CFG_DEV0_EPF3_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_5__SUBSTATE_PWR_ALLOC__SHIFT                          0x0
#define BIF_CFG_DEV0_EPF3_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_5__SUBSTATE_PWR_ALLOC_MASK                            0xFFL
//BIF_CFG_DEV0_EPF3_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_6
#define BIF_CFG_DEV0_EPF3_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_6__SUBSTATE_PWR_ALLOC__SHIFT                          0x0
#define BIF_CFG_DEV0_EPF3_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_6__SUBSTATE_PWR_ALLOC_MASK                            0xFFL
//BIF_CFG_DEV0_EPF3_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_7
#define BIF_CFG_DEV0_EPF3_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_7__SUBSTATE_PWR_ALLOC__SHIFT                          0x0
#define BIF_CFG_DEV0_EPF3_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_7__SUBSTATE_PWR_ALLOC_MASK                            0xFFL
//BIF_CFG_DEV0_EPF3_0_PCIE_ACS_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF3_0_PCIE_ACS_ENH_CAP_LIST__CAP_ID__SHIFT                                              0x0
#define BIF_CFG_DEV0_EPF3_0_PCIE_ACS_ENH_CAP_LIST__CAP_VER__SHIFT                                             0x10
#define BIF_CFG_DEV0_EPF3_0_PCIE_ACS_ENH_CAP_LIST__NEXT_PTR__SHIFT                                            0x14
#define BIF_CFG_DEV0_EPF3_0_PCIE_ACS_ENH_CAP_LIST__CAP_ID_MASK                                                0x0000FFFFL
#define BIF_CFG_DEV0_EPF3_0_PCIE_ACS_ENH_CAP_LIST__CAP_VER_MASK                                               0x000F0000L
#define BIF_CFG_DEV0_EPF3_0_PCIE_ACS_ENH_CAP_LIST__NEXT_PTR_MASK                                              0xFFF00000L
//BIF_CFG_DEV0_EPF3_0_PCIE_ACS_CAP
#define BIF_CFG_DEV0_EPF3_0_PCIE_ACS_CAP__SOURCE_VALIDATION__SHIFT                                            0x0
#define BIF_CFG_DEV0_EPF3_0_PCIE_ACS_CAP__TRANSLATION_BLOCKING__SHIFT                                         0x1
#define BIF_CFG_DEV0_EPF3_0_PCIE_ACS_CAP__P2P_REQUEST_REDIRECT__SHIFT                                         0x2
#define BIF_CFG_DEV0_EPF3_0_PCIE_ACS_CAP__P2P_COMPLETION_REDIRECT__SHIFT                                      0x3
#define BIF_CFG_DEV0_EPF3_0_PCIE_ACS_CAP__UPSTREAM_FORWARDING__SHIFT                                          0x4
#define BIF_CFG_DEV0_EPF3_0_PCIE_ACS_CAP__P2P_EGRESS_CONTROL__SHIFT                                           0x5
#define BIF_CFG_DEV0_EPF3_0_PCIE_ACS_CAP__DIRECT_TRANSLATED_P2P__SHIFT                                        0x6
#define BIF_CFG_DEV0_EPF3_0_PCIE_ACS_CAP__EGRESS_CONTROL_VECTOR_SIZE__SHIFT                                   0x8
#define BIF_CFG_DEV0_EPF3_0_PCIE_ACS_CAP__SOURCE_VALIDATION_MASK                                              0x0001L
#define BIF_CFG_DEV0_EPF3_0_PCIE_ACS_CAP__TRANSLATION_BLOCKING_MASK                                           0x0002L
#define BIF_CFG_DEV0_EPF3_0_PCIE_ACS_CAP__P2P_REQUEST_REDIRECT_MASK                                           0x0004L
#define BIF_CFG_DEV0_EPF3_0_PCIE_ACS_CAP__P2P_COMPLETION_REDIRECT_MASK                                        0x0008L
#define BIF_CFG_DEV0_EPF3_0_PCIE_ACS_CAP__UPSTREAM_FORWARDING_MASK                                            0x0010L
#define BIF_CFG_DEV0_EPF3_0_PCIE_ACS_CAP__P2P_EGRESS_CONTROL_MASK                                             0x0020L
#define BIF_CFG_DEV0_EPF3_0_PCIE_ACS_CAP__DIRECT_TRANSLATED_P2P_MASK                                          0x0040L
#define BIF_CFG_DEV0_EPF3_0_PCIE_ACS_CAP__EGRESS_CONTROL_VECTOR_SIZE_MASK                                     0xFF00L
//BIF_CFG_DEV0_EPF3_0_PCIE_ACS_CNTL
#define BIF_CFG_DEV0_EPF3_0_PCIE_ACS_CNTL__SOURCE_VALIDATION_EN__SHIFT                                        0x0
#define BIF_CFG_DEV0_EPF3_0_PCIE_ACS_CNTL__TRANSLATION_BLOCKING_EN__SHIFT                                     0x1
#define BIF_CFG_DEV0_EPF3_0_PCIE_ACS_CNTL__P2P_REQUEST_REDIRECT_EN__SHIFT                                     0x2
#define BIF_CFG_DEV0_EPF3_0_PCIE_ACS_CNTL__P2P_COMPLETION_REDIRECT_EN__SHIFT                                  0x3
#define BIF_CFG_DEV0_EPF3_0_PCIE_ACS_CNTL__UPSTREAM_FORWARDING_EN__SHIFT                                      0x4
#define BIF_CFG_DEV0_EPF3_0_PCIE_ACS_CNTL__P2P_EGRESS_CONTROL_EN__SHIFT                                       0x5
#define BIF_CFG_DEV0_EPF3_0_PCIE_ACS_CNTL__DIRECT_TRANSLATED_P2P_EN__SHIFT                                    0x6
#define BIF_CFG_DEV0_EPF3_0_PCIE_ACS_CNTL__SOURCE_VALIDATION_EN_MASK                                          0x0001L
#define BIF_CFG_DEV0_EPF3_0_PCIE_ACS_CNTL__TRANSLATION_BLOCKING_EN_MASK                                       0x0002L
#define BIF_CFG_DEV0_EPF3_0_PCIE_ACS_CNTL__P2P_REQUEST_REDIRECT_EN_MASK                                       0x0004L
#define BIF_CFG_DEV0_EPF3_0_PCIE_ACS_CNTL__P2P_COMPLETION_REDIRECT_EN_MASK                                    0x0008L
#define BIF_CFG_DEV0_EPF3_0_PCIE_ACS_CNTL__UPSTREAM_FORWARDING_EN_MASK                                        0x0010L
#define BIF_CFG_DEV0_EPF3_0_PCIE_ACS_CNTL__P2P_EGRESS_CONTROL_EN_MASK                                         0x0020L
#define BIF_CFG_DEV0_EPF3_0_PCIE_ACS_CNTL__DIRECT_TRANSLATED_P2P_EN_MASK                                      0x0040L
//BIF_CFG_DEV0_EPF3_0_PCIE_ARI_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF3_0_PCIE_ARI_ENH_CAP_LIST__CAP_ID__SHIFT                                              0x0
#define BIF_CFG_DEV0_EPF3_0_PCIE_ARI_ENH_CAP_LIST__CAP_VER__SHIFT                                             0x10
#define BIF_CFG_DEV0_EPF3_0_PCIE_ARI_ENH_CAP_LIST__NEXT_PTR__SHIFT                                            0x14
#define BIF_CFG_DEV0_EPF3_0_PCIE_ARI_ENH_CAP_LIST__CAP_ID_MASK                                                0x0000FFFFL
#define BIF_CFG_DEV0_EPF3_0_PCIE_ARI_ENH_CAP_LIST__CAP_VER_MASK                                               0x000F0000L
#define BIF_CFG_DEV0_EPF3_0_PCIE_ARI_ENH_CAP_LIST__NEXT_PTR_MASK                                              0xFFF00000L
//BIF_CFG_DEV0_EPF3_0_PCIE_ARI_CAP
#define BIF_CFG_DEV0_EPF3_0_PCIE_ARI_CAP__ARI_MFVC_FUNC_GROUPS_CAP__SHIFT                                     0x0
#define BIF_CFG_DEV0_EPF3_0_PCIE_ARI_CAP__ARI_ACS_FUNC_GROUPS_CAP__SHIFT                                      0x1
#define BIF_CFG_DEV0_EPF3_0_PCIE_ARI_CAP__ARI_NEXT_FUNC_NUM__SHIFT                                            0x8
#define BIF_CFG_DEV0_EPF3_0_PCIE_ARI_CAP__ARI_MFVC_FUNC_GROUPS_CAP_MASK                                       0x0001L
#define BIF_CFG_DEV0_EPF3_0_PCIE_ARI_CAP__ARI_ACS_FUNC_GROUPS_CAP_MASK                                        0x0002L
#define BIF_CFG_DEV0_EPF3_0_PCIE_ARI_CAP__ARI_NEXT_FUNC_NUM_MASK                                              0xFF00L
//BIF_CFG_DEV0_EPF3_0_PCIE_ARI_CNTL
#define BIF_CFG_DEV0_EPF3_0_PCIE_ARI_CNTL__ARI_MFVC_FUNC_GROUPS_EN__SHIFT                                     0x0
#define BIF_CFG_DEV0_EPF3_0_PCIE_ARI_CNTL__ARI_ACS_FUNC_GROUPS_EN__SHIFT                                      0x1
#define BIF_CFG_DEV0_EPF3_0_PCIE_ARI_CNTL__ARI_FUNCTION_GROUP__SHIFT                                          0x4
#define BIF_CFG_DEV0_EPF3_0_PCIE_ARI_CNTL__ARI_MFVC_FUNC_GROUPS_EN_MASK                                       0x0001L
#define BIF_CFG_DEV0_EPF3_0_PCIE_ARI_CNTL__ARI_ACS_FUNC_GROUPS_EN_MASK                                        0x0002L
#define BIF_CFG_DEV0_EPF3_0_PCIE_ARI_CNTL__ARI_FUNCTION_GROUP_MASK                                            0x0070L


// addressBlock: nbio_nbif0_bif_cfg_dev0_epf4_bifcfgdecp
//BIF_CFG_DEV0_EPF4_0_VENDOR_ID
#define BIF_CFG_DEV0_EPF4_0_VENDOR_ID__VENDOR_ID__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF4_0_VENDOR_ID__VENDOR_ID_MASK                                                         0xFFFFL
//BIF_CFG_DEV0_EPF4_0_DEVICE_ID
#define BIF_CFG_DEV0_EPF4_0_DEVICE_ID__DEVICE_ID__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF4_0_DEVICE_ID__DEVICE_ID_MASK                                                         0xFFFFL
//BIF_CFG_DEV0_EPF4_0_COMMAND
#define BIF_CFG_DEV0_EPF4_0_COMMAND__IO_ACCESS_EN__SHIFT                                                      0x0
#define BIF_CFG_DEV0_EPF4_0_COMMAND__MEM_ACCESS_EN__SHIFT                                                     0x1
#define BIF_CFG_DEV0_EPF4_0_COMMAND__BUS_MASTER_EN__SHIFT                                                     0x2
#define BIF_CFG_DEV0_EPF4_0_COMMAND__SPECIAL_CYCLE_EN__SHIFT                                                  0x3
#define BIF_CFG_DEV0_EPF4_0_COMMAND__MEM_WRITE_INVALIDATE_EN__SHIFT                                           0x4
#define BIF_CFG_DEV0_EPF4_0_COMMAND__PAL_SNOOP_EN__SHIFT                                                      0x5
#define BIF_CFG_DEV0_EPF4_0_COMMAND__PARITY_ERROR_RESPONSE__SHIFT                                             0x6
#define BIF_CFG_DEV0_EPF4_0_COMMAND__AD_STEPPING__SHIFT                                                       0x7
#define BIF_CFG_DEV0_EPF4_0_COMMAND__SERR_EN__SHIFT                                                           0x8
#define BIF_CFG_DEV0_EPF4_0_COMMAND__FAST_B2B_EN__SHIFT                                                       0x9
#define BIF_CFG_DEV0_EPF4_0_COMMAND__INT_DIS__SHIFT                                                           0xa
#define BIF_CFG_DEV0_EPF4_0_COMMAND__IO_ACCESS_EN_MASK                                                        0x0001L
#define BIF_CFG_DEV0_EPF4_0_COMMAND__MEM_ACCESS_EN_MASK                                                       0x0002L
#define BIF_CFG_DEV0_EPF4_0_COMMAND__BUS_MASTER_EN_MASK                                                       0x0004L
#define BIF_CFG_DEV0_EPF4_0_COMMAND__SPECIAL_CYCLE_EN_MASK                                                    0x0008L
#define BIF_CFG_DEV0_EPF4_0_COMMAND__MEM_WRITE_INVALIDATE_EN_MASK                                             0x0010L
#define BIF_CFG_DEV0_EPF4_0_COMMAND__PAL_SNOOP_EN_MASK                                                        0x0020L
#define BIF_CFG_DEV0_EPF4_0_COMMAND__PARITY_ERROR_RESPONSE_MASK                                               0x0040L
#define BIF_CFG_DEV0_EPF4_0_COMMAND__AD_STEPPING_MASK                                                         0x0080L
#define BIF_CFG_DEV0_EPF4_0_COMMAND__SERR_EN_MASK                                                             0x0100L
#define BIF_CFG_DEV0_EPF4_0_COMMAND__FAST_B2B_EN_MASK                                                         0x0200L
#define BIF_CFG_DEV0_EPF4_0_COMMAND__INT_DIS_MASK                                                             0x0400L
//BIF_CFG_DEV0_EPF4_0_STATUS
#define BIF_CFG_DEV0_EPF4_0_STATUS__INT_STATUS__SHIFT                                                         0x3
#define BIF_CFG_DEV0_EPF4_0_STATUS__CAP_LIST__SHIFT                                                           0x4
#define BIF_CFG_DEV0_EPF4_0_STATUS__PCI_66_EN__SHIFT                                                          0x5
#define BIF_CFG_DEV0_EPF4_0_STATUS__FAST_BACK_CAPABLE__SHIFT                                                  0x7
#define BIF_CFG_DEV0_EPF4_0_STATUS__MASTER_DATA_PARITY_ERROR__SHIFT                                           0x8
#define BIF_CFG_DEV0_EPF4_0_STATUS__DEVSEL_TIMING__SHIFT                                                      0x9
#define BIF_CFG_DEV0_EPF4_0_STATUS__SIGNAL_TARGET_ABORT__SHIFT                                                0xb
#define BIF_CFG_DEV0_EPF4_0_STATUS__RECEIVED_TARGET_ABORT__SHIFT                                              0xc
#define BIF_CFG_DEV0_EPF4_0_STATUS__RECEIVED_MASTER_ABORT__SHIFT                                              0xd
#define BIF_CFG_DEV0_EPF4_0_STATUS__SIGNALED_SYSTEM_ERROR__SHIFT                                              0xe
#define BIF_CFG_DEV0_EPF4_0_STATUS__PARITY_ERROR_DETECTED__SHIFT                                              0xf
#define BIF_CFG_DEV0_EPF4_0_STATUS__INT_STATUS_MASK                                                           0x0008L
#define BIF_CFG_DEV0_EPF4_0_STATUS__CAP_LIST_MASK                                                             0x0010L
#define BIF_CFG_DEV0_EPF4_0_STATUS__PCI_66_EN_MASK                                                            0x0020L
#define BIF_CFG_DEV0_EPF4_0_STATUS__FAST_BACK_CAPABLE_MASK                                                    0x0080L
#define BIF_CFG_DEV0_EPF4_0_STATUS__MASTER_DATA_PARITY_ERROR_MASK                                             0x0100L
#define BIF_CFG_DEV0_EPF4_0_STATUS__DEVSEL_TIMING_MASK                                                        0x0600L
#define BIF_CFG_DEV0_EPF4_0_STATUS__SIGNAL_TARGET_ABORT_MASK                                                  0x0800L
#define BIF_CFG_DEV0_EPF4_0_STATUS__RECEIVED_TARGET_ABORT_MASK                                                0x1000L
#define BIF_CFG_DEV0_EPF4_0_STATUS__RECEIVED_MASTER_ABORT_MASK                                                0x2000L
#define BIF_CFG_DEV0_EPF4_0_STATUS__SIGNALED_SYSTEM_ERROR_MASK                                                0x4000L
#define BIF_CFG_DEV0_EPF4_0_STATUS__PARITY_ERROR_DETECTED_MASK                                                0x8000L
//BIF_CFG_DEV0_EPF4_0_REVISION_ID
#define BIF_CFG_DEV0_EPF4_0_REVISION_ID__MINOR_REV_ID__SHIFT                                                  0x0
#define BIF_CFG_DEV0_EPF4_0_REVISION_ID__MAJOR_REV_ID__SHIFT                                                  0x4
#define BIF_CFG_DEV0_EPF4_0_REVISION_ID__MINOR_REV_ID_MASK                                                    0x0FL
#define BIF_CFG_DEV0_EPF4_0_REVISION_ID__MAJOR_REV_ID_MASK                                                    0xF0L
//BIF_CFG_DEV0_EPF4_0_PROG_INTERFACE
#define BIF_CFG_DEV0_EPF4_0_PROG_INTERFACE__PROG_INTERFACE__SHIFT                                             0x0
#define BIF_CFG_DEV0_EPF4_0_PROG_INTERFACE__PROG_INTERFACE_MASK                                               0xFFL
//BIF_CFG_DEV0_EPF4_0_SUB_CLASS
#define BIF_CFG_DEV0_EPF4_0_SUB_CLASS__SUB_CLASS__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF4_0_SUB_CLASS__SUB_CLASS_MASK                                                         0xFFL
//BIF_CFG_DEV0_EPF4_0_BASE_CLASS
#define BIF_CFG_DEV0_EPF4_0_BASE_CLASS__BASE_CLASS__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF4_0_BASE_CLASS__BASE_CLASS_MASK                                                       0xFFL
//BIF_CFG_DEV0_EPF4_0_CACHE_LINE
#define BIF_CFG_DEV0_EPF4_0_CACHE_LINE__CACHE_LINE_SIZE__SHIFT                                                0x0
#define BIF_CFG_DEV0_EPF4_0_CACHE_LINE__CACHE_LINE_SIZE_MASK                                                  0xFFL
//BIF_CFG_DEV0_EPF4_0_LATENCY
#define BIF_CFG_DEV0_EPF4_0_LATENCY__LATENCY_TIMER__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF4_0_LATENCY__LATENCY_TIMER_MASK                                                       0xFFL
//BIF_CFG_DEV0_EPF4_0_HEADER
#define BIF_CFG_DEV0_EPF4_0_HEADER__HEADER_TYPE__SHIFT                                                        0x0
#define BIF_CFG_DEV0_EPF4_0_HEADER__DEVICE_TYPE__SHIFT                                                        0x7
#define BIF_CFG_DEV0_EPF4_0_HEADER__HEADER_TYPE_MASK                                                          0x7FL
#define BIF_CFG_DEV0_EPF4_0_HEADER__DEVICE_TYPE_MASK                                                          0x80L
//BIF_CFG_DEV0_EPF4_0_BIST
#define BIF_CFG_DEV0_EPF4_0_BIST__BIST_COMP__SHIFT                                                            0x0
#define BIF_CFG_DEV0_EPF4_0_BIST__BIST_STRT__SHIFT                                                            0x6
#define BIF_CFG_DEV0_EPF4_0_BIST__BIST_CAP__SHIFT                                                             0x7
#define BIF_CFG_DEV0_EPF4_0_BIST__BIST_COMP_MASK                                                              0x0FL
#define BIF_CFG_DEV0_EPF4_0_BIST__BIST_STRT_MASK                                                              0x40L
#define BIF_CFG_DEV0_EPF4_0_BIST__BIST_CAP_MASK                                                               0x80L
//BIF_CFG_DEV0_EPF4_0_BASE_ADDR_1
#define BIF_CFG_DEV0_EPF4_0_BASE_ADDR_1__BASE_ADDR__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF4_0_BASE_ADDR_1__BASE_ADDR_MASK                                                       0xFFFFFFFFL
//BIF_CFG_DEV0_EPF4_0_BASE_ADDR_2
#define BIF_CFG_DEV0_EPF4_0_BASE_ADDR_2__BASE_ADDR__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF4_0_BASE_ADDR_2__BASE_ADDR_MASK                                                       0xFFFFFFFFL
//BIF_CFG_DEV0_EPF4_0_BASE_ADDR_3
#define BIF_CFG_DEV0_EPF4_0_BASE_ADDR_3__BASE_ADDR__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF4_0_BASE_ADDR_3__BASE_ADDR_MASK                                                       0xFFFFFFFFL
//BIF_CFG_DEV0_EPF4_0_BASE_ADDR_4
#define BIF_CFG_DEV0_EPF4_0_BASE_ADDR_4__BASE_ADDR__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF4_0_BASE_ADDR_4__BASE_ADDR_MASK                                                       0xFFFFFFFFL
//BIF_CFG_DEV0_EPF4_0_BASE_ADDR_5
#define BIF_CFG_DEV0_EPF4_0_BASE_ADDR_5__BASE_ADDR__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF4_0_BASE_ADDR_5__BASE_ADDR_MASK                                                       0xFFFFFFFFL
//BIF_CFG_DEV0_EPF4_0_BASE_ADDR_6
#define BIF_CFG_DEV0_EPF4_0_BASE_ADDR_6__BASE_ADDR__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF4_0_BASE_ADDR_6__BASE_ADDR_MASK                                                       0xFFFFFFFFL
//BIF_CFG_DEV0_EPF4_0_ADAPTER_ID
#define BIF_CFG_DEV0_EPF4_0_ADAPTER_ID__SUBSYSTEM_VENDOR_ID__SHIFT                                            0x0
#define BIF_CFG_DEV0_EPF4_0_ADAPTER_ID__SUBSYSTEM_ID__SHIFT                                                   0x10
#define BIF_CFG_DEV0_EPF4_0_ADAPTER_ID__SUBSYSTEM_VENDOR_ID_MASK                                              0x0000FFFFL
#define BIF_CFG_DEV0_EPF4_0_ADAPTER_ID__SUBSYSTEM_ID_MASK                                                     0xFFFF0000L
//BIF_CFG_DEV0_EPF4_0_ROM_BASE_ADDR
#define BIF_CFG_DEV0_EPF4_0_ROM_BASE_ADDR__BASE_ADDR__SHIFT                                                   0x0
#define BIF_CFG_DEV0_EPF4_0_ROM_BASE_ADDR__BASE_ADDR_MASK                                                     0xFFFFFFFFL
//BIF_CFG_DEV0_EPF4_0_CAP_PTR
#define BIF_CFG_DEV0_EPF4_0_CAP_PTR__CAP_PTR__SHIFT                                                           0x0
#define BIF_CFG_DEV0_EPF4_0_CAP_PTR__CAP_PTR_MASK                                                             0x000000FFL
//BIF_CFG_DEV0_EPF4_0_INTERRUPT_LINE
#define BIF_CFG_DEV0_EPF4_0_INTERRUPT_LINE__INTERRUPT_LINE__SHIFT                                             0x0
#define BIF_CFG_DEV0_EPF4_0_INTERRUPT_LINE__INTERRUPT_LINE_MASK                                               0xFFL
//BIF_CFG_DEV0_EPF4_0_INTERRUPT_PIN
#define BIF_CFG_DEV0_EPF4_0_INTERRUPT_PIN__INTERRUPT_PIN__SHIFT                                               0x0
#define BIF_CFG_DEV0_EPF4_0_INTERRUPT_PIN__INTERRUPT_PIN_MASK                                                 0xFFL
//BIF_CFG_DEV0_EPF4_0_MIN_GRANT
#define BIF_CFG_DEV0_EPF4_0_MIN_GRANT__MIN_GNT__SHIFT                                                         0x0
#define BIF_CFG_DEV0_EPF4_0_MIN_GRANT__MIN_GNT_MASK                                                           0xFFL
//BIF_CFG_DEV0_EPF4_0_MAX_LATENCY
#define BIF_CFG_DEV0_EPF4_0_MAX_LATENCY__MAX_LAT__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF4_0_MAX_LATENCY__MAX_LAT_MASK                                                         0xFFL
//BIF_CFG_DEV0_EPF4_0_VENDOR_CAP_LIST
#define BIF_CFG_DEV0_EPF4_0_VENDOR_CAP_LIST__CAP_ID__SHIFT                                                    0x0
#define BIF_CFG_DEV0_EPF4_0_VENDOR_CAP_LIST__NEXT_PTR__SHIFT                                                  0x8
#define BIF_CFG_DEV0_EPF4_0_VENDOR_CAP_LIST__LENGTH__SHIFT                                                    0x10
#define BIF_CFG_DEV0_EPF4_0_VENDOR_CAP_LIST__CAP_ID_MASK                                                      0x000000FFL
#define BIF_CFG_DEV0_EPF4_0_VENDOR_CAP_LIST__NEXT_PTR_MASK                                                    0x0000FF00L
#define BIF_CFG_DEV0_EPF4_0_VENDOR_CAP_LIST__LENGTH_MASK                                                      0x00FF0000L
//BIF_CFG_DEV0_EPF4_0_ADAPTER_ID_W
#define BIF_CFG_DEV0_EPF4_0_ADAPTER_ID_W__SUBSYSTEM_VENDOR_ID__SHIFT                                          0x0
#define BIF_CFG_DEV0_EPF4_0_ADAPTER_ID_W__SUBSYSTEM_ID__SHIFT                                                 0x10
#define BIF_CFG_DEV0_EPF4_0_ADAPTER_ID_W__SUBSYSTEM_VENDOR_ID_MASK                                            0x0000FFFFL
#define BIF_CFG_DEV0_EPF4_0_ADAPTER_ID_W__SUBSYSTEM_ID_MASK                                                   0xFFFF0000L
//BIF_CFG_DEV0_EPF4_0_PMI_CAP_LIST
#define BIF_CFG_DEV0_EPF4_0_PMI_CAP_LIST__CAP_ID__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF4_0_PMI_CAP_LIST__NEXT_PTR__SHIFT                                                     0x8
#define BIF_CFG_DEV0_EPF4_0_PMI_CAP_LIST__CAP_ID_MASK                                                         0x00FFL
#define BIF_CFG_DEV0_EPF4_0_PMI_CAP_LIST__NEXT_PTR_MASK                                                       0xFF00L
//BIF_CFG_DEV0_EPF4_0_PMI_CAP
#define BIF_CFG_DEV0_EPF4_0_PMI_CAP__VERSION__SHIFT                                                           0x0
#define BIF_CFG_DEV0_EPF4_0_PMI_CAP__PME_CLOCK__SHIFT                                                         0x3
#define BIF_CFG_DEV0_EPF4_0_PMI_CAP__DEV_SPECIFIC_INIT__SHIFT                                                 0x5
#define BIF_CFG_DEV0_EPF4_0_PMI_CAP__AUX_CURRENT__SHIFT                                                       0x6
#define BIF_CFG_DEV0_EPF4_0_PMI_CAP__D1_SUPPORT__SHIFT                                                        0x9
#define BIF_CFG_DEV0_EPF4_0_PMI_CAP__D2_SUPPORT__SHIFT                                                        0xa
#define BIF_CFG_DEV0_EPF4_0_PMI_CAP__PME_SUPPORT__SHIFT                                                       0xb
#define BIF_CFG_DEV0_EPF4_0_PMI_CAP__VERSION_MASK                                                             0x0007L
#define BIF_CFG_DEV0_EPF4_0_PMI_CAP__PME_CLOCK_MASK                                                           0x0008L
#define BIF_CFG_DEV0_EPF4_0_PMI_CAP__DEV_SPECIFIC_INIT_MASK                                                   0x0020L
#define BIF_CFG_DEV0_EPF4_0_PMI_CAP__AUX_CURRENT_MASK                                                         0x01C0L
#define BIF_CFG_DEV0_EPF4_0_PMI_CAP__D1_SUPPORT_MASK                                                          0x0200L
#define BIF_CFG_DEV0_EPF4_0_PMI_CAP__D2_SUPPORT_MASK                                                          0x0400L
#define BIF_CFG_DEV0_EPF4_0_PMI_CAP__PME_SUPPORT_MASK                                                         0xF800L
//BIF_CFG_DEV0_EPF4_0_PMI_STATUS_CNTL
#define BIF_CFG_DEV0_EPF4_0_PMI_STATUS_CNTL__POWER_STATE__SHIFT                                               0x0
#define BIF_CFG_DEV0_EPF4_0_PMI_STATUS_CNTL__NO_SOFT_RESET__SHIFT                                             0x3
#define BIF_CFG_DEV0_EPF4_0_PMI_STATUS_CNTL__PME_EN__SHIFT                                                    0x8
#define BIF_CFG_DEV0_EPF4_0_PMI_STATUS_CNTL__DATA_SELECT__SHIFT                                               0x9
#define BIF_CFG_DEV0_EPF4_0_PMI_STATUS_CNTL__DATA_SCALE__SHIFT                                                0xd
#define BIF_CFG_DEV0_EPF4_0_PMI_STATUS_CNTL__PME_STATUS__SHIFT                                                0xf
#define BIF_CFG_DEV0_EPF4_0_PMI_STATUS_CNTL__B2_B3_SUPPORT__SHIFT                                             0x16
#define BIF_CFG_DEV0_EPF4_0_PMI_STATUS_CNTL__BUS_PWR_EN__SHIFT                                                0x17
#define BIF_CFG_DEV0_EPF4_0_PMI_STATUS_CNTL__PMI_DATA__SHIFT                                                  0x18
#define BIF_CFG_DEV0_EPF4_0_PMI_STATUS_CNTL__POWER_STATE_MASK                                                 0x00000003L
#define BIF_CFG_DEV0_EPF4_0_PMI_STATUS_CNTL__NO_SOFT_RESET_MASK                                               0x00000008L
#define BIF_CFG_DEV0_EPF4_0_PMI_STATUS_CNTL__PME_EN_MASK                                                      0x00000100L
#define BIF_CFG_DEV0_EPF4_0_PMI_STATUS_CNTL__DATA_SELECT_MASK                                                 0x00001E00L
#define BIF_CFG_DEV0_EPF4_0_PMI_STATUS_CNTL__DATA_SCALE_MASK                                                  0x00006000L
#define BIF_CFG_DEV0_EPF4_0_PMI_STATUS_CNTL__PME_STATUS_MASK                                                  0x00008000L
#define BIF_CFG_DEV0_EPF4_0_PMI_STATUS_CNTL__B2_B3_SUPPORT_MASK                                               0x00400000L
#define BIF_CFG_DEV0_EPF4_0_PMI_STATUS_CNTL__BUS_PWR_EN_MASK                                                  0x00800000L
#define BIF_CFG_DEV0_EPF4_0_PMI_STATUS_CNTL__PMI_DATA_MASK                                                    0xFF000000L
//BIF_CFG_DEV0_EPF4_0_SBRN
#define BIF_CFG_DEV0_EPF4_0_SBRN__SBRN__SHIFT                                                                 0x0
#define BIF_CFG_DEV0_EPF4_0_SBRN__SBRN_MASK                                                                   0xFFL
//BIF_CFG_DEV0_EPF4_0_FLADJ
#define BIF_CFG_DEV0_EPF4_0_FLADJ__FLADJ__SHIFT                                                               0x0
#define BIF_CFG_DEV0_EPF4_0_FLADJ__FLADJ_MASK                                                                 0x3FL
//BIF_CFG_DEV0_EPF4_0_DBESL_DBESLD
#define BIF_CFG_DEV0_EPF4_0_DBESL_DBESLD__DBESL__SHIFT                                                        0x0
#define BIF_CFG_DEV0_EPF4_0_DBESL_DBESLD__DBESLD__SHIFT                                                       0x4
#define BIF_CFG_DEV0_EPF4_0_DBESL_DBESLD__DBESL_MASK                                                          0x0FL
#define BIF_CFG_DEV0_EPF4_0_DBESL_DBESLD__DBESLD_MASK                                                         0xF0L
//BIF_CFG_DEV0_EPF4_0_PCIE_CAP_LIST
#define BIF_CFG_DEV0_EPF4_0_PCIE_CAP_LIST__CAP_ID__SHIFT                                                      0x0
#define BIF_CFG_DEV0_EPF4_0_PCIE_CAP_LIST__NEXT_PTR__SHIFT                                                    0x8
#define BIF_CFG_DEV0_EPF4_0_PCIE_CAP_LIST__CAP_ID_MASK                                                        0x00FFL
#define BIF_CFG_DEV0_EPF4_0_PCIE_CAP_LIST__NEXT_PTR_MASK                                                      0xFF00L
//BIF_CFG_DEV0_EPF4_0_PCIE_CAP
#define BIF_CFG_DEV0_EPF4_0_PCIE_CAP__VERSION__SHIFT                                                          0x0
#define BIF_CFG_DEV0_EPF4_0_PCIE_CAP__DEVICE_TYPE__SHIFT                                                      0x4
#define BIF_CFG_DEV0_EPF4_0_PCIE_CAP__SLOT_IMPLEMENTED__SHIFT                                                 0x8
#define BIF_CFG_DEV0_EPF4_0_PCIE_CAP__INT_MESSAGE_NUM__SHIFT                                                  0x9
#define BIF_CFG_DEV0_EPF4_0_PCIE_CAP__VERSION_MASK                                                            0x000FL
#define BIF_CFG_DEV0_EPF4_0_PCIE_CAP__DEVICE_TYPE_MASK                                                        0x00F0L
#define BIF_CFG_DEV0_EPF4_0_PCIE_CAP__SLOT_IMPLEMENTED_MASK                                                   0x0100L
#define BIF_CFG_DEV0_EPF4_0_PCIE_CAP__INT_MESSAGE_NUM_MASK                                                    0x3E00L
//BIF_CFG_DEV0_EPF4_0_DEVICE_CAP
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CAP__MAX_PAYLOAD_SUPPORT__SHIFT                                            0x0
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CAP__PHANTOM_FUNC__SHIFT                                                   0x3
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CAP__EXTENDED_TAG__SHIFT                                                   0x5
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CAP__L0S_ACCEPTABLE_LATENCY__SHIFT                                         0x6
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CAP__L1_ACCEPTABLE_LATENCY__SHIFT                                          0x9
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CAP__ROLE_BASED_ERR_REPORTING__SHIFT                                       0xf
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CAP__CAPTURED_SLOT_POWER_LIMIT__SHIFT                                      0x12
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CAP__CAPTURED_SLOT_POWER_SCALE__SHIFT                                      0x1a
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CAP__FLR_CAPABLE__SHIFT                                                    0x1c
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CAP__MAX_PAYLOAD_SUPPORT_MASK                                              0x00000007L
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CAP__PHANTOM_FUNC_MASK                                                     0x00000018L
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CAP__EXTENDED_TAG_MASK                                                     0x00000020L
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CAP__L0S_ACCEPTABLE_LATENCY_MASK                                           0x000001C0L
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CAP__L1_ACCEPTABLE_LATENCY_MASK                                            0x00000E00L
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CAP__ROLE_BASED_ERR_REPORTING_MASK                                         0x00008000L
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CAP__CAPTURED_SLOT_POWER_LIMIT_MASK                                        0x03FC0000L
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CAP__CAPTURED_SLOT_POWER_SCALE_MASK                                        0x0C000000L
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CAP__FLR_CAPABLE_MASK                                                      0x10000000L
//BIF_CFG_DEV0_EPF4_0_DEVICE_CNTL
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CNTL__CORR_ERR_EN__SHIFT                                                   0x0
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CNTL__NON_FATAL_ERR_EN__SHIFT                                              0x1
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CNTL__FATAL_ERR_EN__SHIFT                                                  0x2
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CNTL__USR_REPORT_EN__SHIFT                                                 0x3
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CNTL__RELAXED_ORD_EN__SHIFT                                                0x4
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CNTL__MAX_PAYLOAD_SIZE__SHIFT                                              0x5
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CNTL__EXTENDED_TAG_EN__SHIFT                                               0x8
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CNTL__PHANTOM_FUNC_EN__SHIFT                                               0x9
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CNTL__AUX_POWER_PM_EN__SHIFT                                               0xa
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CNTL__NO_SNOOP_EN__SHIFT                                                   0xb
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CNTL__MAX_READ_REQUEST_SIZE__SHIFT                                         0xc
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CNTL__INITIATE_FLR__SHIFT                                                  0xf
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CNTL__CORR_ERR_EN_MASK                                                     0x0001L
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CNTL__NON_FATAL_ERR_EN_MASK                                                0x0002L
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CNTL__FATAL_ERR_EN_MASK                                                    0x0004L
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CNTL__USR_REPORT_EN_MASK                                                   0x0008L
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CNTL__RELAXED_ORD_EN_MASK                                                  0x0010L
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CNTL__MAX_PAYLOAD_SIZE_MASK                                                0x00E0L
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CNTL__EXTENDED_TAG_EN_MASK                                                 0x0100L
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CNTL__PHANTOM_FUNC_EN_MASK                                                 0x0200L
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CNTL__AUX_POWER_PM_EN_MASK                                                 0x0400L
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CNTL__NO_SNOOP_EN_MASK                                                     0x0800L
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CNTL__MAX_READ_REQUEST_SIZE_MASK                                           0x7000L
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CNTL__INITIATE_FLR_MASK                                                    0x8000L
//BIF_CFG_DEV0_EPF4_0_DEVICE_STATUS
#define BIF_CFG_DEV0_EPF4_0_DEVICE_STATUS__CORR_ERR__SHIFT                                                    0x0
#define BIF_CFG_DEV0_EPF4_0_DEVICE_STATUS__NON_FATAL_ERR__SHIFT                                               0x1
#define BIF_CFG_DEV0_EPF4_0_DEVICE_STATUS__FATAL_ERR__SHIFT                                                   0x2
#define BIF_CFG_DEV0_EPF4_0_DEVICE_STATUS__USR_DETECTED__SHIFT                                                0x3
#define BIF_CFG_DEV0_EPF4_0_DEVICE_STATUS__AUX_PWR__SHIFT                                                     0x4
#define BIF_CFG_DEV0_EPF4_0_DEVICE_STATUS__TRANSACTIONS_PEND__SHIFT                                           0x5
#define BIF_CFG_DEV0_EPF4_0_DEVICE_STATUS__CORR_ERR_MASK                                                      0x0001L
#define BIF_CFG_DEV0_EPF4_0_DEVICE_STATUS__NON_FATAL_ERR_MASK                                                 0x0002L
#define BIF_CFG_DEV0_EPF4_0_DEVICE_STATUS__FATAL_ERR_MASK                                                     0x0004L
#define BIF_CFG_DEV0_EPF4_0_DEVICE_STATUS__USR_DETECTED_MASK                                                  0x0008L
#define BIF_CFG_DEV0_EPF4_0_DEVICE_STATUS__AUX_PWR_MASK                                                       0x0010L
#define BIF_CFG_DEV0_EPF4_0_DEVICE_STATUS__TRANSACTIONS_PEND_MASK                                             0x0020L
//BIF_CFG_DEV0_EPF4_0_LINK_CAP
#define BIF_CFG_DEV0_EPF4_0_LINK_CAP__LINK_SPEED__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF4_0_LINK_CAP__LINK_WIDTH__SHIFT                                                       0x4
#define BIF_CFG_DEV0_EPF4_0_LINK_CAP__PM_SUPPORT__SHIFT                                                       0xa
#define BIF_CFG_DEV0_EPF4_0_LINK_CAP__L0S_EXIT_LATENCY__SHIFT                                                 0xc
#define BIF_CFG_DEV0_EPF4_0_LINK_CAP__L1_EXIT_LATENCY__SHIFT                                                  0xf
#define BIF_CFG_DEV0_EPF4_0_LINK_CAP__CLOCK_POWER_MANAGEMENT__SHIFT                                           0x12
#define BIF_CFG_DEV0_EPF4_0_LINK_CAP__SURPRISE_DOWN_ERR_REPORTING__SHIFT                                      0x13
#define BIF_CFG_DEV0_EPF4_0_LINK_CAP__DL_ACTIVE_REPORTING_CAPABLE__SHIFT                                      0x14
#define BIF_CFG_DEV0_EPF4_0_LINK_CAP__LINK_BW_NOTIFICATION_CAP__SHIFT                                         0x15
#define BIF_CFG_DEV0_EPF4_0_LINK_CAP__ASPM_OPTIONALITY_COMPLIANCE__SHIFT                                      0x16
#define BIF_CFG_DEV0_EPF4_0_LINK_CAP__PORT_NUMBER__SHIFT                                                      0x18
#define BIF_CFG_DEV0_EPF4_0_LINK_CAP__LINK_SPEED_MASK                                                         0x0000000FL
#define BIF_CFG_DEV0_EPF4_0_LINK_CAP__LINK_WIDTH_MASK                                                         0x000003F0L
#define BIF_CFG_DEV0_EPF4_0_LINK_CAP__PM_SUPPORT_MASK                                                         0x00000C00L
#define BIF_CFG_DEV0_EPF4_0_LINK_CAP__L0S_EXIT_LATENCY_MASK                                                   0x00007000L
#define BIF_CFG_DEV0_EPF4_0_LINK_CAP__L1_EXIT_LATENCY_MASK                                                    0x00038000L
#define BIF_CFG_DEV0_EPF4_0_LINK_CAP__CLOCK_POWER_MANAGEMENT_MASK                                             0x00040000L
#define BIF_CFG_DEV0_EPF4_0_LINK_CAP__SURPRISE_DOWN_ERR_REPORTING_MASK                                        0x00080000L
#define BIF_CFG_DEV0_EPF4_0_LINK_CAP__DL_ACTIVE_REPORTING_CAPABLE_MASK                                        0x00100000L
#define BIF_CFG_DEV0_EPF4_0_LINK_CAP__LINK_BW_NOTIFICATION_CAP_MASK                                           0x00200000L
#define BIF_CFG_DEV0_EPF4_0_LINK_CAP__ASPM_OPTIONALITY_COMPLIANCE_MASK                                        0x00400000L
#define BIF_CFG_DEV0_EPF4_0_LINK_CAP__PORT_NUMBER_MASK                                                        0xFF000000L
//BIF_CFG_DEV0_EPF4_0_LINK_CNTL
#define BIF_CFG_DEV0_EPF4_0_LINK_CNTL__PM_CONTROL__SHIFT                                                      0x0
#define BIF_CFG_DEV0_EPF4_0_LINK_CNTL__READ_CPL_BOUNDARY__SHIFT                                               0x3
#define BIF_CFG_DEV0_EPF4_0_LINK_CNTL__LINK_DIS__SHIFT                                                        0x4
#define BIF_CFG_DEV0_EPF4_0_LINK_CNTL__RETRAIN_LINK__SHIFT                                                    0x5
#define BIF_CFG_DEV0_EPF4_0_LINK_CNTL__COMMON_CLOCK_CFG__SHIFT                                                0x6
#define BIF_CFG_DEV0_EPF4_0_LINK_CNTL__EXTENDED_SYNC__SHIFT                                                   0x7
#define BIF_CFG_DEV0_EPF4_0_LINK_CNTL__CLOCK_POWER_MANAGEMENT_EN__SHIFT                                       0x8
#define BIF_CFG_DEV0_EPF4_0_LINK_CNTL__HW_AUTONOMOUS_WIDTH_DISABLE__SHIFT                                     0x9
#define BIF_CFG_DEV0_EPF4_0_LINK_CNTL__LINK_BW_MANAGEMENT_INT_EN__SHIFT                                       0xa
#define BIF_CFG_DEV0_EPF4_0_LINK_CNTL__LINK_AUTONOMOUS_BW_INT_EN__SHIFT                                       0xb
#define BIF_CFG_DEV0_EPF4_0_LINK_CNTL__PM_CONTROL_MASK                                                        0x0003L
#define BIF_CFG_DEV0_EPF4_0_LINK_CNTL__READ_CPL_BOUNDARY_MASK                                                 0x0008L
#define BIF_CFG_DEV0_EPF4_0_LINK_CNTL__LINK_DIS_MASK                                                          0x0010L
#define BIF_CFG_DEV0_EPF4_0_LINK_CNTL__RETRAIN_LINK_MASK                                                      0x0020L
#define BIF_CFG_DEV0_EPF4_0_LINK_CNTL__COMMON_CLOCK_CFG_MASK                                                  0x0040L
#define BIF_CFG_DEV0_EPF4_0_LINK_CNTL__EXTENDED_SYNC_MASK                                                     0x0080L
#define BIF_CFG_DEV0_EPF4_0_LINK_CNTL__CLOCK_POWER_MANAGEMENT_EN_MASK                                         0x0100L
#define BIF_CFG_DEV0_EPF4_0_LINK_CNTL__HW_AUTONOMOUS_WIDTH_DISABLE_MASK                                       0x0200L
#define BIF_CFG_DEV0_EPF4_0_LINK_CNTL__LINK_BW_MANAGEMENT_INT_EN_MASK                                         0x0400L
#define BIF_CFG_DEV0_EPF4_0_LINK_CNTL__LINK_AUTONOMOUS_BW_INT_EN_MASK                                         0x0800L
//BIF_CFG_DEV0_EPF4_0_LINK_STATUS
#define BIF_CFG_DEV0_EPF4_0_LINK_STATUS__CURRENT_LINK_SPEED__SHIFT                                            0x0
#define BIF_CFG_DEV0_EPF4_0_LINK_STATUS__NEGOTIATED_LINK_WIDTH__SHIFT                                         0x4
#define BIF_CFG_DEV0_EPF4_0_LINK_STATUS__LINK_TRAINING__SHIFT                                                 0xb
#define BIF_CFG_DEV0_EPF4_0_LINK_STATUS__SLOT_CLOCK_CFG__SHIFT                                                0xc
#define BIF_CFG_DEV0_EPF4_0_LINK_STATUS__DL_ACTIVE__SHIFT                                                     0xd
#define BIF_CFG_DEV0_EPF4_0_LINK_STATUS__LINK_BW_MANAGEMENT_STATUS__SHIFT                                     0xe
#define BIF_CFG_DEV0_EPF4_0_LINK_STATUS__LINK_AUTONOMOUS_BW_STATUS__SHIFT                                     0xf
#define BIF_CFG_DEV0_EPF4_0_LINK_STATUS__CURRENT_LINK_SPEED_MASK                                              0x000FL
#define BIF_CFG_DEV0_EPF4_0_LINK_STATUS__NEGOTIATED_LINK_WIDTH_MASK                                           0x03F0L
#define BIF_CFG_DEV0_EPF4_0_LINK_STATUS__LINK_TRAINING_MASK                                                   0x0800L
#define BIF_CFG_DEV0_EPF4_0_LINK_STATUS__SLOT_CLOCK_CFG_MASK                                                  0x1000L
#define BIF_CFG_DEV0_EPF4_0_LINK_STATUS__DL_ACTIVE_MASK                                                       0x2000L
#define BIF_CFG_DEV0_EPF4_0_LINK_STATUS__LINK_BW_MANAGEMENT_STATUS_MASK                                       0x4000L
#define BIF_CFG_DEV0_EPF4_0_LINK_STATUS__LINK_AUTONOMOUS_BW_STATUS_MASK                                       0x8000L
//BIF_CFG_DEV0_EPF4_0_DEVICE_CAP2
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CAP2__CPL_TIMEOUT_RANGE_SUPPORTED__SHIFT                                   0x0
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CAP2__CPL_TIMEOUT_DIS_SUPPORTED__SHIFT                                     0x4
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CAP2__ARI_FORWARDING_SUPPORTED__SHIFT                                      0x5
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CAP2__ATOMICOP_ROUTING_SUPPORTED__SHIFT                                    0x6
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CAP2__ATOMICOP_32CMPLT_SUPPORTED__SHIFT                                    0x7
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CAP2__ATOMICOP_64CMPLT_SUPPORTED__SHIFT                                    0x8
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CAP2__CAS128_CMPLT_SUPPORTED__SHIFT                                        0x9
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CAP2__NO_RO_ENABLED_P2P_PASSING__SHIFT                                     0xa
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CAP2__LTR_SUPPORTED__SHIFT                                                 0xb
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CAP2__TPH_CPLR_SUPPORTED__SHIFT                                            0xc
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CAP2__OBFF_SUPPORTED__SHIFT                                                0x12
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CAP2__EXTENDED_FMT_FIELD_SUPPORTED__SHIFT                                  0x14
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CAP2__END_END_TLP_PREFIX_SUPPORTED__SHIFT                                  0x15
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CAP2__MAX_END_END_TLP_PREFIXES__SHIFT                                      0x16
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CAP2__CPL_TIMEOUT_RANGE_SUPPORTED_MASK                                     0x0000000FL
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CAP2__CPL_TIMEOUT_DIS_SUPPORTED_MASK                                       0x00000010L
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CAP2__ARI_FORWARDING_SUPPORTED_MASK                                        0x00000020L
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CAP2__ATOMICOP_ROUTING_SUPPORTED_MASK                                      0x00000040L
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CAP2__ATOMICOP_32CMPLT_SUPPORTED_MASK                                      0x00000080L
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CAP2__ATOMICOP_64CMPLT_SUPPORTED_MASK                                      0x00000100L
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CAP2__CAS128_CMPLT_SUPPORTED_MASK                                          0x00000200L
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CAP2__NO_RO_ENABLED_P2P_PASSING_MASK                                       0x00000400L
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CAP2__LTR_SUPPORTED_MASK                                                   0x00000800L
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CAP2__TPH_CPLR_SUPPORTED_MASK                                              0x00003000L
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CAP2__OBFF_SUPPORTED_MASK                                                  0x000C0000L
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CAP2__EXTENDED_FMT_FIELD_SUPPORTED_MASK                                    0x00100000L
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CAP2__END_END_TLP_PREFIX_SUPPORTED_MASK                                    0x00200000L
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CAP2__MAX_END_END_TLP_PREFIXES_MASK                                        0x00C00000L
//BIF_CFG_DEV0_EPF4_0_DEVICE_CNTL2
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CNTL2__CPL_TIMEOUT_VALUE__SHIFT                                            0x0
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CNTL2__CPL_TIMEOUT_DIS__SHIFT                                              0x4
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CNTL2__ARI_FORWARDING_EN__SHIFT                                            0x5
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CNTL2__ATOMICOP_REQUEST_EN__SHIFT                                          0x6
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CNTL2__ATOMICOP_EGRESS_BLOCKING__SHIFT                                     0x7
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CNTL2__IDO_REQUEST_ENABLE__SHIFT                                           0x8
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CNTL2__IDO_COMPLETION_ENABLE__SHIFT                                        0x9
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CNTL2__LTR_EN__SHIFT                                                       0xa
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CNTL2__OBFF_EN__SHIFT                                                      0xd
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CNTL2__END_END_TLP_PREFIX_BLOCKING__SHIFT                                  0xf
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CNTL2__CPL_TIMEOUT_VALUE_MASK                                              0x000FL
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CNTL2__CPL_TIMEOUT_DIS_MASK                                                0x0010L
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CNTL2__ARI_FORWARDING_EN_MASK                                              0x0020L
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CNTL2__ATOMICOP_REQUEST_EN_MASK                                            0x0040L
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CNTL2__ATOMICOP_EGRESS_BLOCKING_MASK                                       0x0080L
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CNTL2__IDO_REQUEST_ENABLE_MASK                                             0x0100L
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CNTL2__IDO_COMPLETION_ENABLE_MASK                                          0x0200L
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CNTL2__LTR_EN_MASK                                                         0x0400L
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CNTL2__OBFF_EN_MASK                                                        0x6000L
#define BIF_CFG_DEV0_EPF4_0_DEVICE_CNTL2__END_END_TLP_PREFIX_BLOCKING_MASK                                    0x8000L
//BIF_CFG_DEV0_EPF4_0_DEVICE_STATUS2
#define BIF_CFG_DEV0_EPF4_0_DEVICE_STATUS2__RESERVED__SHIFT                                                   0x0
#define BIF_CFG_DEV0_EPF4_0_DEVICE_STATUS2__RESERVED_MASK                                                     0xFFFFL
//BIF_CFG_DEV0_EPF4_0_LINK_CAP2
#define BIF_CFG_DEV0_EPF4_0_LINK_CAP2__SUPPORTED_LINK_SPEED__SHIFT                                            0x1
#define BIF_CFG_DEV0_EPF4_0_LINK_CAP2__CROSSLINK_SUPPORTED__SHIFT                                             0x8
#define BIF_CFG_DEV0_EPF4_0_LINK_CAP2__RESERVED__SHIFT                                                        0x9
#define BIF_CFG_DEV0_EPF4_0_LINK_CAP2__SUPPORTED_LINK_SPEED_MASK                                              0x000000FEL
#define BIF_CFG_DEV0_EPF4_0_LINK_CAP2__CROSSLINK_SUPPORTED_MASK                                               0x00000100L
#define BIF_CFG_DEV0_EPF4_0_LINK_CAP2__RESERVED_MASK                                                          0xFFFFFE00L
//BIF_CFG_DEV0_EPF4_0_LINK_CNTL2
#define BIF_CFG_DEV0_EPF4_0_LINK_CNTL2__TARGET_LINK_SPEED__SHIFT                                              0x0
#define BIF_CFG_DEV0_EPF4_0_LINK_CNTL2__ENTER_COMPLIANCE__SHIFT                                               0x4
#define BIF_CFG_DEV0_EPF4_0_LINK_CNTL2__HW_AUTONOMOUS_SPEED_DISABLE__SHIFT                                    0x5
#define BIF_CFG_DEV0_EPF4_0_LINK_CNTL2__SELECTABLE_DEEMPHASIS__SHIFT                                          0x6
#define BIF_CFG_DEV0_EPF4_0_LINK_CNTL2__XMIT_MARGIN__SHIFT                                                    0x7
#define BIF_CFG_DEV0_EPF4_0_LINK_CNTL2__ENTER_MOD_COMPLIANCE__SHIFT                                           0xa
#define BIF_CFG_DEV0_EPF4_0_LINK_CNTL2__COMPLIANCE_SOS__SHIFT                                                 0xb
#define BIF_CFG_DEV0_EPF4_0_LINK_CNTL2__COMPLIANCE_DEEMPHASIS__SHIFT                                          0xc
#define BIF_CFG_DEV0_EPF4_0_LINK_CNTL2__TARGET_LINK_SPEED_MASK                                                0x000FL
#define BIF_CFG_DEV0_EPF4_0_LINK_CNTL2__ENTER_COMPLIANCE_MASK                                                 0x0010L
#define BIF_CFG_DEV0_EPF4_0_LINK_CNTL2__HW_AUTONOMOUS_SPEED_DISABLE_MASK                                      0x0020L
#define BIF_CFG_DEV0_EPF4_0_LINK_CNTL2__SELECTABLE_DEEMPHASIS_MASK                                            0x0040L
#define BIF_CFG_DEV0_EPF4_0_LINK_CNTL2__XMIT_MARGIN_MASK                                                      0x0380L
#define BIF_CFG_DEV0_EPF4_0_LINK_CNTL2__ENTER_MOD_COMPLIANCE_MASK                                             0x0400L
#define BIF_CFG_DEV0_EPF4_0_LINK_CNTL2__COMPLIANCE_SOS_MASK                                                   0x0800L
#define BIF_CFG_DEV0_EPF4_0_LINK_CNTL2__COMPLIANCE_DEEMPHASIS_MASK                                            0xF000L
//BIF_CFG_DEV0_EPF4_0_LINK_STATUS2
#define BIF_CFG_DEV0_EPF4_0_LINK_STATUS2__CUR_DEEMPHASIS_LEVEL__SHIFT                                         0x0
#define BIF_CFG_DEV0_EPF4_0_LINK_STATUS2__EQUALIZATION_COMPLETE__SHIFT                                        0x1
#define BIF_CFG_DEV0_EPF4_0_LINK_STATUS2__EQUALIZATION_PHASE1_SUCCESS__SHIFT                                  0x2
#define BIF_CFG_DEV0_EPF4_0_LINK_STATUS2__EQUALIZATION_PHASE2_SUCCESS__SHIFT                                  0x3
#define BIF_CFG_DEV0_EPF4_0_LINK_STATUS2__EQUALIZATION_PHASE3_SUCCESS__SHIFT                                  0x4
#define BIF_CFG_DEV0_EPF4_0_LINK_STATUS2__LINK_EQUALIZATION_REQUEST__SHIFT                                    0x5
#define BIF_CFG_DEV0_EPF4_0_LINK_STATUS2__CUR_DEEMPHASIS_LEVEL_MASK                                           0x0001L
#define BIF_CFG_DEV0_EPF4_0_LINK_STATUS2__EQUALIZATION_COMPLETE_MASK                                          0x0002L
#define BIF_CFG_DEV0_EPF4_0_LINK_STATUS2__EQUALIZATION_PHASE1_SUCCESS_MASK                                    0x0004L
#define BIF_CFG_DEV0_EPF4_0_LINK_STATUS2__EQUALIZATION_PHASE2_SUCCESS_MASK                                    0x0008L
#define BIF_CFG_DEV0_EPF4_0_LINK_STATUS2__EQUALIZATION_PHASE3_SUCCESS_MASK                                    0x0010L
#define BIF_CFG_DEV0_EPF4_0_LINK_STATUS2__LINK_EQUALIZATION_REQUEST_MASK                                      0x0020L
//BIF_CFG_DEV0_EPF4_0_SLOT_CAP2
#define BIF_CFG_DEV0_EPF4_0_SLOT_CAP2__RESERVED__SHIFT                                                        0x0
#define BIF_CFG_DEV0_EPF4_0_SLOT_CAP2__RESERVED_MASK                                                          0xFFFFFFFFL
//BIF_CFG_DEV0_EPF4_0_SLOT_CNTL2
#define BIF_CFG_DEV0_EPF4_0_SLOT_CNTL2__RESERVED__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF4_0_SLOT_CNTL2__RESERVED_MASK                                                         0xFFFFL
//BIF_CFG_DEV0_EPF4_0_SLOT_STATUS2
#define BIF_CFG_DEV0_EPF4_0_SLOT_STATUS2__RESERVED__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF4_0_SLOT_STATUS2__RESERVED_MASK                                                       0xFFFFL
//BIF_CFG_DEV0_EPF4_0_MSI_CAP_LIST
#define BIF_CFG_DEV0_EPF4_0_MSI_CAP_LIST__CAP_ID__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF4_0_MSI_CAP_LIST__NEXT_PTR__SHIFT                                                     0x8
#define BIF_CFG_DEV0_EPF4_0_MSI_CAP_LIST__CAP_ID_MASK                                                         0x00FFL
#define BIF_CFG_DEV0_EPF4_0_MSI_CAP_LIST__NEXT_PTR_MASK                                                       0xFF00L
//BIF_CFG_DEV0_EPF4_0_MSI_MSG_CNTL
#define BIF_CFG_DEV0_EPF4_0_MSI_MSG_CNTL__MSI_EN__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF4_0_MSI_MSG_CNTL__MSI_MULTI_CAP__SHIFT                                                0x1
#define BIF_CFG_DEV0_EPF4_0_MSI_MSG_CNTL__MSI_MULTI_EN__SHIFT                                                 0x4
#define BIF_CFG_DEV0_EPF4_0_MSI_MSG_CNTL__MSI_64BIT__SHIFT                                                    0x7
#define BIF_CFG_DEV0_EPF4_0_MSI_MSG_CNTL__MSI_PERVECTOR_MASKING_CAP__SHIFT                                    0x8
#define BIF_CFG_DEV0_EPF4_0_MSI_MSG_CNTL__MSI_EN_MASK                                                         0x0001L
#define BIF_CFG_DEV0_EPF4_0_MSI_MSG_CNTL__MSI_MULTI_CAP_MASK                                                  0x000EL
#define BIF_CFG_DEV0_EPF4_0_MSI_MSG_CNTL__MSI_MULTI_EN_MASK                                                   0x0070L
#define BIF_CFG_DEV0_EPF4_0_MSI_MSG_CNTL__MSI_64BIT_MASK                                                      0x0080L
#define BIF_CFG_DEV0_EPF4_0_MSI_MSG_CNTL__MSI_PERVECTOR_MASKING_CAP_MASK                                      0x0100L
//BIF_CFG_DEV0_EPF4_0_MSI_MSG_ADDR_LO
#define BIF_CFG_DEV0_EPF4_0_MSI_MSG_ADDR_LO__MSI_MSG_ADDR_LO__SHIFT                                           0x2
#define BIF_CFG_DEV0_EPF4_0_MSI_MSG_ADDR_LO__MSI_MSG_ADDR_LO_MASK                                             0xFFFFFFFCL
//BIF_CFG_DEV0_EPF4_0_MSI_MSG_ADDR_HI
#define BIF_CFG_DEV0_EPF4_0_MSI_MSG_ADDR_HI__MSI_MSG_ADDR_HI__SHIFT                                           0x0
#define BIF_CFG_DEV0_EPF4_0_MSI_MSG_ADDR_HI__MSI_MSG_ADDR_HI_MASK                                             0xFFFFFFFFL
//BIF_CFG_DEV0_EPF4_0_MSI_MSG_DATA
#define BIF_CFG_DEV0_EPF4_0_MSI_MSG_DATA__MSI_DATA__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF4_0_MSI_MSG_DATA__MSI_DATA_MASK                                                       0x0000FFFFL
//BIF_CFG_DEV0_EPF4_0_MSI_MASK
#define BIF_CFG_DEV0_EPF4_0_MSI_MASK__MSI_MASK__SHIFT                                                         0x0
#define BIF_CFG_DEV0_EPF4_0_MSI_MASK__MSI_MASK_MASK                                                           0xFFFFFFFFL
//BIF_CFG_DEV0_EPF4_0_MSI_MSG_DATA_64
#define BIF_CFG_DEV0_EPF4_0_MSI_MSG_DATA_64__MSI_DATA_64__SHIFT                                               0x0
#define BIF_CFG_DEV0_EPF4_0_MSI_MSG_DATA_64__MSI_DATA_64_MASK                                                 0x0000FFFFL
//BIF_CFG_DEV0_EPF4_0_MSI_MASK_64
#define BIF_CFG_DEV0_EPF4_0_MSI_MASK_64__MSI_MASK_64__SHIFT                                                   0x0
#define BIF_CFG_DEV0_EPF4_0_MSI_MASK_64__MSI_MASK_64_MASK                                                     0xFFFFFFFFL
//BIF_CFG_DEV0_EPF4_0_MSI_PENDING
#define BIF_CFG_DEV0_EPF4_0_MSI_PENDING__MSI_PENDING__SHIFT                                                   0x0
#define BIF_CFG_DEV0_EPF4_0_MSI_PENDING__MSI_PENDING_MASK                                                     0xFFFFFFFFL
//BIF_CFG_DEV0_EPF4_0_MSI_PENDING_64
#define BIF_CFG_DEV0_EPF4_0_MSI_PENDING_64__MSI_PENDING_64__SHIFT                                             0x0
#define BIF_CFG_DEV0_EPF4_0_MSI_PENDING_64__MSI_PENDING_64_MASK                                               0xFFFFFFFFL
//BIF_CFG_DEV0_EPF4_0_MSIX_CAP_LIST
#define BIF_CFG_DEV0_EPF4_0_MSIX_CAP_LIST__CAP_ID__SHIFT                                                      0x0
#define BIF_CFG_DEV0_EPF4_0_MSIX_CAP_LIST__NEXT_PTR__SHIFT                                                    0x8
#define BIF_CFG_DEV0_EPF4_0_MSIX_CAP_LIST__CAP_ID_MASK                                                        0x00FFL
#define BIF_CFG_DEV0_EPF4_0_MSIX_CAP_LIST__NEXT_PTR_MASK                                                      0xFF00L
//BIF_CFG_DEV0_EPF4_0_MSIX_MSG_CNTL
#define BIF_CFG_DEV0_EPF4_0_MSIX_MSG_CNTL__MSIX_TABLE_SIZE__SHIFT                                             0x0
#define BIF_CFG_DEV0_EPF4_0_MSIX_MSG_CNTL__MSIX_FUNC_MASK__SHIFT                                              0xe
#define BIF_CFG_DEV0_EPF4_0_MSIX_MSG_CNTL__MSIX_EN__SHIFT                                                     0xf
#define BIF_CFG_DEV0_EPF4_0_MSIX_MSG_CNTL__MSIX_TABLE_SIZE_MASK                                               0x07FFL
#define BIF_CFG_DEV0_EPF4_0_MSIX_MSG_CNTL__MSIX_FUNC_MASK_MASK                                                0x4000L
#define BIF_CFG_DEV0_EPF4_0_MSIX_MSG_CNTL__MSIX_EN_MASK                                                       0x8000L
//BIF_CFG_DEV0_EPF4_0_MSIX_TABLE
#define BIF_CFG_DEV0_EPF4_0_MSIX_TABLE__MSIX_TABLE_BIR__SHIFT                                                 0x0
#define BIF_CFG_DEV0_EPF4_0_MSIX_TABLE__MSIX_TABLE_OFFSET__SHIFT                                              0x3
#define BIF_CFG_DEV0_EPF4_0_MSIX_TABLE__MSIX_TABLE_BIR_MASK                                                   0x00000007L
#define BIF_CFG_DEV0_EPF4_0_MSIX_TABLE__MSIX_TABLE_OFFSET_MASK                                                0xFFFFFFF8L
//BIF_CFG_DEV0_EPF4_0_MSIX_PBA
#define BIF_CFG_DEV0_EPF4_0_MSIX_PBA__MSIX_PBA_BIR__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF4_0_MSIX_PBA__MSIX_PBA_OFFSET__SHIFT                                                  0x3
#define BIF_CFG_DEV0_EPF4_0_MSIX_PBA__MSIX_PBA_BIR_MASK                                                       0x00000007L
#define BIF_CFG_DEV0_EPF4_0_MSIX_PBA__MSIX_PBA_OFFSET_MASK                                                    0xFFFFFFF8L
//BIF_CFG_DEV0_EPF4_0_SATA_CAP_0
#define BIF_CFG_DEV0_EPF4_0_SATA_CAP_0__CAP_ID__SHIFT                                                         0x0
#define BIF_CFG_DEV0_EPF4_0_SATA_CAP_0__NEXT_PTR__SHIFT                                                       0x8
#define BIF_CFG_DEV0_EPF4_0_SATA_CAP_0__SATA_CAP_MINOR_REV__SHIFT                                             0x10
#define BIF_CFG_DEV0_EPF4_0_SATA_CAP_0__SATA_CAP_MAJOR_REV__SHIFT                                             0x14
#define BIF_CFG_DEV0_EPF4_0_SATA_CAP_0__SATA_CAP_RESERVED1__SHIFT                                             0x18
#define BIF_CFG_DEV0_EPF4_0_SATA_CAP_0__CAP_ID_MASK                                                           0x000000FFL
#define BIF_CFG_DEV0_EPF4_0_SATA_CAP_0__NEXT_PTR_MASK                                                         0x0000FF00L
#define BIF_CFG_DEV0_EPF4_0_SATA_CAP_0__SATA_CAP_MINOR_REV_MASK                                               0x000F0000L
#define BIF_CFG_DEV0_EPF4_0_SATA_CAP_0__SATA_CAP_MAJOR_REV_MASK                                               0x00F00000L
#define BIF_CFG_DEV0_EPF4_0_SATA_CAP_0__SATA_CAP_RESERVED1_MASK                                               0xFF000000L
//BIF_CFG_DEV0_EPF4_0_SATA_CAP_1
#define BIF_CFG_DEV0_EPF4_0_SATA_CAP_1__SATA_CAP_BAR_LOC__SHIFT                                               0x0
#define BIF_CFG_DEV0_EPF4_0_SATA_CAP_1__SATA_CAP_BAR_OFFSET__SHIFT                                            0x4
#define BIF_CFG_DEV0_EPF4_0_SATA_CAP_1__SATA_CAP_RESERVED2__SHIFT                                             0x18
#define BIF_CFG_DEV0_EPF4_0_SATA_CAP_1__SATA_CAP_BAR_LOC_MASK                                                 0x0000000FL
#define BIF_CFG_DEV0_EPF4_0_SATA_CAP_1__SATA_CAP_BAR_OFFSET_MASK                                              0x00FFFFF0L
#define BIF_CFG_DEV0_EPF4_0_SATA_CAP_1__SATA_CAP_RESERVED2_MASK                                               0xFF000000L
//BIF_CFG_DEV0_EPF4_0_SATA_IDP_INDEX
#define BIF_CFG_DEV0_EPF4_0_SATA_IDP_INDEX__IDP_RESERVED1__SHIFT                                              0x0
#define BIF_CFG_DEV0_EPF4_0_SATA_IDP_INDEX__IDP_INDEX__SHIFT                                                  0x2
#define BIF_CFG_DEV0_EPF4_0_SATA_IDP_INDEX__IDP_RESERVED2__SHIFT                                              0xc
#define BIF_CFG_DEV0_EPF4_0_SATA_IDP_INDEX__IDP_RESERVED1_MASK                                                0x00000003L
#define BIF_CFG_DEV0_EPF4_0_SATA_IDP_INDEX__IDP_INDEX_MASK                                                    0x00000FFCL
#define BIF_CFG_DEV0_EPF4_0_SATA_IDP_INDEX__IDP_RESERVED2_MASK                                                0xFFFFF000L
//BIF_CFG_DEV0_EPF4_0_SATA_IDP_DATA
#define BIF_CFG_DEV0_EPF4_0_SATA_IDP_DATA__IDP_DATA__SHIFT                                                    0x0
#define BIF_CFG_DEV0_EPF4_0_SATA_IDP_DATA__IDP_DATA_MASK                                                      0xFFFFFFFFL
//BIF_CFG_DEV0_EPF4_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF4_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_ID__SHIFT                                  0x0
#define BIF_CFG_DEV0_EPF4_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_VER__SHIFT                                 0x10
#define BIF_CFG_DEV0_EPF4_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__NEXT_PTR__SHIFT                                0x14
#define BIF_CFG_DEV0_EPF4_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_ID_MASK                                    0x0000FFFFL
#define BIF_CFG_DEV0_EPF4_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__CAP_VER_MASK                                   0x000F0000L
#define BIF_CFG_DEV0_EPF4_0_PCIE_VENDOR_SPECIFIC_ENH_CAP_LIST__NEXT_PTR_MASK                                  0xFFF00000L
//BIF_CFG_DEV0_EPF4_0_PCIE_VENDOR_SPECIFIC_HDR
#define BIF_CFG_DEV0_EPF4_0_PCIE_VENDOR_SPECIFIC_HDR__VSEC_ID__SHIFT                                          0x0
#define BIF_CFG_DEV0_EPF4_0_PCIE_VENDOR_SPECIFIC_HDR__VSEC_REV__SHIFT                                         0x10
#define BIF_CFG_DEV0_EPF4_0_PCIE_VENDOR_SPECIFIC_HDR__VSEC_LENGTH__SHIFT                                      0x14
#define BIF_CFG_DEV0_EPF4_0_PCIE_VENDOR_SPECIFIC_HDR__VSEC_ID_MASK                                            0x0000FFFFL
#define BIF_CFG_DEV0_EPF4_0_PCIE_VENDOR_SPECIFIC_HDR__VSEC_REV_MASK                                           0x000F0000L
#define BIF_CFG_DEV0_EPF4_0_PCIE_VENDOR_SPECIFIC_HDR__VSEC_LENGTH_MASK                                        0xFFF00000L
//BIF_CFG_DEV0_EPF4_0_PCIE_VENDOR_SPECIFIC1
#define BIF_CFG_DEV0_EPF4_0_PCIE_VENDOR_SPECIFIC1__SCRATCH__SHIFT                                             0x0
#define BIF_CFG_DEV0_EPF4_0_PCIE_VENDOR_SPECIFIC1__SCRATCH_MASK                                               0xFFFFFFFFL
//BIF_CFG_DEV0_EPF4_0_PCIE_VENDOR_SPECIFIC2
#define BIF_CFG_DEV0_EPF4_0_PCIE_VENDOR_SPECIFIC2__SCRATCH__SHIFT                                             0x0
#define BIF_CFG_DEV0_EPF4_0_PCIE_VENDOR_SPECIFIC2__SCRATCH_MASK                                               0xFFFFFFFFL
//BIF_CFG_DEV0_EPF4_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF4_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_ID__SHIFT                                      0x0
#define BIF_CFG_DEV0_EPF4_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_VER__SHIFT                                     0x10
#define BIF_CFG_DEV0_EPF4_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__NEXT_PTR__SHIFT                                    0x14
#define BIF_CFG_DEV0_EPF4_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_ID_MASK                                        0x0000FFFFL
#define BIF_CFG_DEV0_EPF4_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__CAP_VER_MASK                                       0x000F0000L
#define BIF_CFG_DEV0_EPF4_0_PCIE_ADV_ERR_RPT_ENH_CAP_LIST__NEXT_PTR_MASK                                      0xFFF00000L
//BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_STATUS
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_STATUS__DLP_ERR_STATUS__SHIFT                                     0x4
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_STATUS__SURPDN_ERR_STATUS__SHIFT                                  0x5
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_STATUS__PSN_ERR_STATUS__SHIFT                                     0xc
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_STATUS__FC_ERR_STATUS__SHIFT                                      0xd
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_STATUS__CPL_TIMEOUT_STATUS__SHIFT                                 0xe
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_STATUS__CPL_ABORT_ERR_STATUS__SHIFT                               0xf
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_STATUS__UNEXP_CPL_STATUS__SHIFT                                   0x10
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_STATUS__RCV_OVFL_STATUS__SHIFT                                    0x11
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_STATUS__MAL_TLP_STATUS__SHIFT                                     0x12
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_STATUS__ECRC_ERR_STATUS__SHIFT                                    0x13
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_STATUS__UNSUPP_REQ_ERR_STATUS__SHIFT                              0x14
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_STATUS__ACS_VIOLATION_STATUS__SHIFT                               0x15
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_STATUS__UNCORR_INT_ERR_STATUS__SHIFT                              0x16
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_STATUS__MC_BLOCKED_TLP_STATUS__SHIFT                              0x17
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_STATUS__ATOMICOP_EGRESS_BLOCKED_STATUS__SHIFT                     0x18
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_STATUS__TLP_PREFIX_BLOCKED_ERR_STATUS__SHIFT                      0x19
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_STATUS__DLP_ERR_STATUS_MASK                                       0x00000010L
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_STATUS__SURPDN_ERR_STATUS_MASK                                    0x00000020L
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_STATUS__PSN_ERR_STATUS_MASK                                       0x00001000L
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_STATUS__FC_ERR_STATUS_MASK                                        0x00002000L
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_STATUS__CPL_TIMEOUT_STATUS_MASK                                   0x00004000L
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_STATUS__CPL_ABORT_ERR_STATUS_MASK                                 0x00008000L
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_STATUS__UNEXP_CPL_STATUS_MASK                                     0x00010000L
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_STATUS__RCV_OVFL_STATUS_MASK                                      0x00020000L
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_STATUS__MAL_TLP_STATUS_MASK                                       0x00040000L
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_STATUS__ECRC_ERR_STATUS_MASK                                      0x00080000L
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_STATUS__UNSUPP_REQ_ERR_STATUS_MASK                                0x00100000L
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_STATUS__ACS_VIOLATION_STATUS_MASK                                 0x00200000L
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_STATUS__UNCORR_INT_ERR_STATUS_MASK                                0x00400000L
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_STATUS__MC_BLOCKED_TLP_STATUS_MASK                                0x00800000L
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_STATUS__ATOMICOP_EGRESS_BLOCKED_STATUS_MASK                       0x01000000L
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_STATUS__TLP_PREFIX_BLOCKED_ERR_STATUS_MASK                        0x02000000L
//BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_MASK
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_MASK__DLP_ERR_MASK__SHIFT                                         0x4
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_MASK__SURPDN_ERR_MASK__SHIFT                                      0x5
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_MASK__PSN_ERR_MASK__SHIFT                                         0xc
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_MASK__FC_ERR_MASK__SHIFT                                          0xd
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_MASK__CPL_TIMEOUT_MASK__SHIFT                                     0xe
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_MASK__CPL_ABORT_ERR_MASK__SHIFT                                   0xf
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_MASK__UNEXP_CPL_MASK__SHIFT                                       0x10
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_MASK__RCV_OVFL_MASK__SHIFT                                        0x11
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_MASK__MAL_TLP_MASK__SHIFT                                         0x12
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_MASK__ECRC_ERR_MASK__SHIFT                                        0x13
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_MASK__UNSUPP_REQ_ERR_MASK__SHIFT                                  0x14
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_MASK__ACS_VIOLATION_MASK__SHIFT                                   0x15
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_MASK__UNCORR_INT_ERR_MASK__SHIFT                                  0x16
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_MASK__MC_BLOCKED_TLP_MASK__SHIFT                                  0x17
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_MASK__ATOMICOP_EGRESS_BLOCKED_MASK__SHIFT                         0x18
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_MASK__TLP_PREFIX_BLOCKED_ERR_MASK__SHIFT                          0x19
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_MASK__DLP_ERR_MASK_MASK                                           0x00000010L
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_MASK__SURPDN_ERR_MASK_MASK                                        0x00000020L
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_MASK__PSN_ERR_MASK_MASK                                           0x00001000L
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_MASK__FC_ERR_MASK_MASK                                            0x00002000L
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_MASK__CPL_TIMEOUT_MASK_MASK                                       0x00004000L
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_MASK__CPL_ABORT_ERR_MASK_MASK                                     0x00008000L
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_MASK__UNEXP_CPL_MASK_MASK                                         0x00010000L
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_MASK__RCV_OVFL_MASK_MASK                                          0x00020000L
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_MASK__MAL_TLP_MASK_MASK                                           0x00040000L
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_MASK__ECRC_ERR_MASK_MASK                                          0x00080000L
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_MASK__UNSUPP_REQ_ERR_MASK_MASK                                    0x00100000L
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_MASK__ACS_VIOLATION_MASK_MASK                                     0x00200000L
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_MASK__UNCORR_INT_ERR_MASK_MASK                                    0x00400000L
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_MASK__MC_BLOCKED_TLP_MASK_MASK                                    0x00800000L
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_MASK__ATOMICOP_EGRESS_BLOCKED_MASK_MASK                           0x01000000L
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_MASK__TLP_PREFIX_BLOCKED_ERR_MASK_MASK                            0x02000000L
//BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_SEVERITY
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_SEVERITY__DLP_ERR_SEVERITY__SHIFT                                 0x4
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_SEVERITY__SURPDN_ERR_SEVERITY__SHIFT                              0x5
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_SEVERITY__PSN_ERR_SEVERITY__SHIFT                                 0xc
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_SEVERITY__FC_ERR_SEVERITY__SHIFT                                  0xd
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_SEVERITY__CPL_TIMEOUT_SEVERITY__SHIFT                             0xe
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_SEVERITY__CPL_ABORT_ERR_SEVERITY__SHIFT                           0xf
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_SEVERITY__UNEXP_CPL_SEVERITY__SHIFT                               0x10
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_SEVERITY__RCV_OVFL_SEVERITY__SHIFT                                0x11
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_SEVERITY__MAL_TLP_SEVERITY__SHIFT                                 0x12
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_SEVERITY__ECRC_ERR_SEVERITY__SHIFT                                0x13
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_SEVERITY__UNSUPP_REQ_ERR_SEVERITY__SHIFT                          0x14
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_SEVERITY__ACS_VIOLATION_SEVERITY__SHIFT                           0x15
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_SEVERITY__UNCORR_INT_ERR_SEVERITY__SHIFT                          0x16
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_SEVERITY__MC_BLOCKED_TLP_SEVERITY__SHIFT                          0x17
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_SEVERITY__ATOMICOP_EGRESS_BLOCKED_SEVERITY__SHIFT                 0x18
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_SEVERITY__TLP_PREFIX_BLOCKED_ERR_SEVERITY__SHIFT                  0x19
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_SEVERITY__DLP_ERR_SEVERITY_MASK                                   0x00000010L
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_SEVERITY__SURPDN_ERR_SEVERITY_MASK                                0x00000020L
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_SEVERITY__PSN_ERR_SEVERITY_MASK                                   0x00001000L
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_SEVERITY__FC_ERR_SEVERITY_MASK                                    0x00002000L
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_SEVERITY__CPL_TIMEOUT_SEVERITY_MASK                               0x00004000L
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_SEVERITY__CPL_ABORT_ERR_SEVERITY_MASK                             0x00008000L
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_SEVERITY__UNEXP_CPL_SEVERITY_MASK                                 0x00010000L
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_SEVERITY__RCV_OVFL_SEVERITY_MASK                                  0x00020000L
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_SEVERITY__MAL_TLP_SEVERITY_MASK                                   0x00040000L
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_SEVERITY__ECRC_ERR_SEVERITY_MASK                                  0x00080000L
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_SEVERITY__UNSUPP_REQ_ERR_SEVERITY_MASK                            0x00100000L
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_SEVERITY__ACS_VIOLATION_SEVERITY_MASK                             0x00200000L
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_SEVERITY__UNCORR_INT_ERR_SEVERITY_MASK                            0x00400000L
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_SEVERITY__MC_BLOCKED_TLP_SEVERITY_MASK                            0x00800000L
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_SEVERITY__ATOMICOP_EGRESS_BLOCKED_SEVERITY_MASK                   0x01000000L
#define BIF_CFG_DEV0_EPF4_0_PCIE_UNCORR_ERR_SEVERITY__TLP_PREFIX_BLOCKED_ERR_SEVERITY_MASK                    0x02000000L
//BIF_CFG_DEV0_EPF4_0_PCIE_CORR_ERR_STATUS
#define BIF_CFG_DEV0_EPF4_0_PCIE_CORR_ERR_STATUS__RCV_ERR_STATUS__SHIFT                                       0x0
#define BIF_CFG_DEV0_EPF4_0_PCIE_CORR_ERR_STATUS__BAD_TLP_STATUS__SHIFT                                       0x6
#define BIF_CFG_DEV0_EPF4_0_PCIE_CORR_ERR_STATUS__BAD_DLLP_STATUS__SHIFT                                      0x7
#define BIF_CFG_DEV0_EPF4_0_PCIE_CORR_ERR_STATUS__REPLAY_NUM_ROLLOVER_STATUS__SHIFT                           0x8
#define BIF_CFG_DEV0_EPF4_0_PCIE_CORR_ERR_STATUS__REPLAY_TIMER_TIMEOUT_STATUS__SHIFT                          0xc
#define BIF_CFG_DEV0_EPF4_0_PCIE_CORR_ERR_STATUS__ADVISORY_NONFATAL_ERR_STATUS__SHIFT                         0xd
#define BIF_CFG_DEV0_EPF4_0_PCIE_CORR_ERR_STATUS__CORR_INT_ERR_STATUS__SHIFT                                  0xe
#define BIF_CFG_DEV0_EPF4_0_PCIE_CORR_ERR_STATUS__HDR_LOG_OVFL_STATUS__SHIFT                                  0xf
#define BIF_CFG_DEV0_EPF4_0_PCIE_CORR_ERR_STATUS__RCV_ERR_STATUS_MASK                                         0x00000001L
#define BIF_CFG_DEV0_EPF4_0_PCIE_CORR_ERR_STATUS__BAD_TLP_STATUS_MASK                                         0x00000040L
#define BIF_CFG_DEV0_EPF4_0_PCIE_CORR_ERR_STATUS__BAD_DLLP_STATUS_MASK                                        0x00000080L
#define BIF_CFG_DEV0_EPF4_0_PCIE_CORR_ERR_STATUS__REPLAY_NUM_ROLLOVER_STATUS_MASK                             0x00000100L
#define BIF_CFG_DEV0_EPF4_0_PCIE_CORR_ERR_STATUS__REPLAY_TIMER_TIMEOUT_STATUS_MASK                            0x00001000L
#define BIF_CFG_DEV0_EPF4_0_PCIE_CORR_ERR_STATUS__ADVISORY_NONFATAL_ERR_STATUS_MASK                           0x00002000L
#define BIF_CFG_DEV0_EPF4_0_PCIE_CORR_ERR_STATUS__CORR_INT_ERR_STATUS_MASK                                    0x00004000L
#define BIF_CFG_DEV0_EPF4_0_PCIE_CORR_ERR_STATUS__HDR_LOG_OVFL_STATUS_MASK                                    0x00008000L
//BIF_CFG_DEV0_EPF4_0_PCIE_CORR_ERR_MASK
#define BIF_CFG_DEV0_EPF4_0_PCIE_CORR_ERR_MASK__RCV_ERR_MASK__SHIFT                                           0x0
#define BIF_CFG_DEV0_EPF4_0_PCIE_CORR_ERR_MASK__BAD_TLP_MASK__SHIFT                                           0x6
#define BIF_CFG_DEV0_EPF4_0_PCIE_CORR_ERR_MASK__BAD_DLLP_MASK__SHIFT                                          0x7
#define BIF_CFG_DEV0_EPF4_0_PCIE_CORR_ERR_MASK__REPLAY_NUM_ROLLOVER_MASK__SHIFT                               0x8
#define BIF_CFG_DEV0_EPF4_0_PCIE_CORR_ERR_MASK__REPLAY_TIMER_TIMEOUT_MASK__SHIFT                              0xc
#define BIF_CFG_DEV0_EPF4_0_PCIE_CORR_ERR_MASK__ADVISORY_NONFATAL_ERR_MASK__SHIFT                             0xd
#define BIF_CFG_DEV0_EPF4_0_PCIE_CORR_ERR_MASK__CORR_INT_ERR_MASK__SHIFT                                      0xe
#define BIF_CFG_DEV0_EPF4_0_PCIE_CORR_ERR_MASK__HDR_LOG_OVFL_MASK__SHIFT                                      0xf
#define BIF_CFG_DEV0_EPF4_0_PCIE_CORR_ERR_MASK__RCV_ERR_MASK_MASK                                             0x00000001L
#define BIF_CFG_DEV0_EPF4_0_PCIE_CORR_ERR_MASK__BAD_TLP_MASK_MASK                                             0x00000040L
#define BIF_CFG_DEV0_EPF4_0_PCIE_CORR_ERR_MASK__BAD_DLLP_MASK_MASK                                            0x00000080L
#define BIF_CFG_DEV0_EPF4_0_PCIE_CORR_ERR_MASK__REPLAY_NUM_ROLLOVER_MASK_MASK                                 0x00000100L
#define BIF_CFG_DEV0_EPF4_0_PCIE_CORR_ERR_MASK__REPLAY_TIMER_TIMEOUT_MASK_MASK                                0x00001000L
#define BIF_CFG_DEV0_EPF4_0_PCIE_CORR_ERR_MASK__ADVISORY_NONFATAL_ERR_MASK_MASK                               0x00002000L
#define BIF_CFG_DEV0_EPF4_0_PCIE_CORR_ERR_MASK__CORR_INT_ERR_MASK_MASK                                        0x00004000L
#define BIF_CFG_DEV0_EPF4_0_PCIE_CORR_ERR_MASK__HDR_LOG_OVFL_MASK_MASK                                        0x00008000L
//BIF_CFG_DEV0_EPF4_0_PCIE_ADV_ERR_CAP_CNTL
#define BIF_CFG_DEV0_EPF4_0_PCIE_ADV_ERR_CAP_CNTL__FIRST_ERR_PTR__SHIFT                                       0x0
#define BIF_CFG_DEV0_EPF4_0_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_CAP__SHIFT                                        0x5
#define BIF_CFG_DEV0_EPF4_0_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_EN__SHIFT                                         0x6
#define BIF_CFG_DEV0_EPF4_0_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_CAP__SHIFT                                      0x7
#define BIF_CFG_DEV0_EPF4_0_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_EN__SHIFT                                       0x8
#define BIF_CFG_DEV0_EPF4_0_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_CAP__SHIFT                                  0x9
#define BIF_CFG_DEV0_EPF4_0_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_EN__SHIFT                                   0xa
#define BIF_CFG_DEV0_EPF4_0_PCIE_ADV_ERR_CAP_CNTL__TLP_PREFIX_LOG_PRESENT__SHIFT                              0xb
#define BIF_CFG_DEV0_EPF4_0_PCIE_ADV_ERR_CAP_CNTL__FIRST_ERR_PTR_MASK                                         0x0000001FL
#define BIF_CFG_DEV0_EPF4_0_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_CAP_MASK                                          0x00000020L
#define BIF_CFG_DEV0_EPF4_0_PCIE_ADV_ERR_CAP_CNTL__ECRC_GEN_EN_MASK                                           0x00000040L
#define BIF_CFG_DEV0_EPF4_0_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_CAP_MASK                                        0x00000080L
#define BIF_CFG_DEV0_EPF4_0_PCIE_ADV_ERR_CAP_CNTL__ECRC_CHECK_EN_MASK                                         0x00000100L
#define BIF_CFG_DEV0_EPF4_0_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_CAP_MASK                                    0x00000200L
#define BIF_CFG_DEV0_EPF4_0_PCIE_ADV_ERR_CAP_CNTL__MULTI_HDR_RECD_EN_MASK                                     0x00000400L
#define BIF_CFG_DEV0_EPF4_0_PCIE_ADV_ERR_CAP_CNTL__TLP_PREFIX_LOG_PRESENT_MASK                                0x00000800L
//BIF_CFG_DEV0_EPF4_0_PCIE_HDR_LOG0
#define BIF_CFG_DEV0_EPF4_0_PCIE_HDR_LOG0__TLP_HDR__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF4_0_PCIE_HDR_LOG0__TLP_HDR_MASK                                                       0xFFFFFFFFL
//BIF_CFG_DEV0_EPF4_0_PCIE_HDR_LOG1
#define BIF_CFG_DEV0_EPF4_0_PCIE_HDR_LOG1__TLP_HDR__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF4_0_PCIE_HDR_LOG1__TLP_HDR_MASK                                                       0xFFFFFFFFL
//BIF_CFG_DEV0_EPF4_0_PCIE_HDR_LOG2
#define BIF_CFG_DEV0_EPF4_0_PCIE_HDR_LOG2__TLP_HDR__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF4_0_PCIE_HDR_LOG2__TLP_HDR_MASK                                                       0xFFFFFFFFL
//BIF_CFG_DEV0_EPF4_0_PCIE_HDR_LOG3
#define BIF_CFG_DEV0_EPF4_0_PCIE_HDR_LOG3__TLP_HDR__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF4_0_PCIE_HDR_LOG3__TLP_HDR_MASK                                                       0xFFFFFFFFL
//BIF_CFG_DEV0_EPF4_0_PCIE_TLP_PREFIX_LOG0
#define BIF_CFG_DEV0_EPF4_0_PCIE_TLP_PREFIX_LOG0__TLP_PREFIX__SHIFT                                           0x0
#define BIF_CFG_DEV0_EPF4_0_PCIE_TLP_PREFIX_LOG0__TLP_PREFIX_MASK                                             0xFFFFFFFFL
//BIF_CFG_DEV0_EPF4_0_PCIE_TLP_PREFIX_LOG1
#define BIF_CFG_DEV0_EPF4_0_PCIE_TLP_PREFIX_LOG1__TLP_PREFIX__SHIFT                                           0x0
#define BIF_CFG_DEV0_EPF4_0_PCIE_TLP_PREFIX_LOG1__TLP_PREFIX_MASK                                             0xFFFFFFFFL
//BIF_CFG_DEV0_EPF4_0_PCIE_TLP_PREFIX_LOG2
#define BIF_CFG_DEV0_EPF4_0_PCIE_TLP_PREFIX_LOG2__TLP_PREFIX__SHIFT                                           0x0
#define BIF_CFG_DEV0_EPF4_0_PCIE_TLP_PREFIX_LOG2__TLP_PREFIX_MASK                                             0xFFFFFFFFL
//BIF_CFG_DEV0_EPF4_0_PCIE_TLP_PREFIX_LOG3
#define BIF_CFG_DEV0_EPF4_0_PCIE_TLP_PREFIX_LOG3__TLP_PREFIX__SHIFT                                           0x0
#define BIF_CFG_DEV0_EPF4_0_PCIE_TLP_PREFIX_LOG3__TLP_PREFIX_MASK                                             0xFFFFFFFFL
//BIF_CFG_DEV0_EPF4_0_PCIE_BAR_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF4_0_PCIE_BAR_ENH_CAP_LIST__CAP_ID__SHIFT                                              0x0
#define BIF_CFG_DEV0_EPF4_0_PCIE_BAR_ENH_CAP_LIST__CAP_VER__SHIFT                                             0x10
#define BIF_CFG_DEV0_EPF4_0_PCIE_BAR_ENH_CAP_LIST__NEXT_PTR__SHIFT                                            0x14
#define BIF_CFG_DEV0_EPF4_0_PCIE_BAR_ENH_CAP_LIST__CAP_ID_MASK                                                0x0000FFFFL
#define BIF_CFG_DEV0_EPF4_0_PCIE_BAR_ENH_CAP_LIST__CAP_VER_MASK                                               0x000F0000L
#define BIF_CFG_DEV0_EPF4_0_PCIE_BAR_ENH_CAP_LIST__NEXT_PTR_MASK                                              0xFFF00000L
//BIF_CFG_DEV0_EPF4_0_PCIE_BAR1_CAP
#define BIF_CFG_DEV0_EPF4_0_PCIE_BAR1_CAP__BAR_SIZE_SUPPORTED__SHIFT                                          0x4
#define BIF_CFG_DEV0_EPF4_0_PCIE_BAR1_CAP__BAR_SIZE_SUPPORTED_MASK                                            0x00FFFFF0L
//BIF_CFG_DEV0_EPF4_0_PCIE_BAR1_CNTL
#define BIF_CFG_DEV0_EPF4_0_PCIE_BAR1_CNTL__BAR_INDEX__SHIFT                                                  0x0
#define BIF_CFG_DEV0_EPF4_0_PCIE_BAR1_CNTL__BAR_TOTAL_NUM__SHIFT                                              0x5
#define BIF_CFG_DEV0_EPF4_0_PCIE_BAR1_CNTL__BAR_SIZE__SHIFT                                                   0x8
#define BIF_CFG_DEV0_EPF4_0_PCIE_BAR1_CNTL__BAR_INDEX_MASK                                                    0x0007L
#define BIF_CFG_DEV0_EPF4_0_PCIE_BAR1_CNTL__BAR_TOTAL_NUM_MASK                                                0x00E0L
#define BIF_CFG_DEV0_EPF4_0_PCIE_BAR1_CNTL__BAR_SIZE_MASK                                                     0x1F00L
//BIF_CFG_DEV0_EPF4_0_PCIE_BAR2_CAP
#define BIF_CFG_DEV0_EPF4_0_PCIE_BAR2_CAP__BAR_SIZE_SUPPORTED__SHIFT                                          0x4
#define BIF_CFG_DEV0_EPF4_0_PCIE_BAR2_CAP__BAR_SIZE_SUPPORTED_MASK                                            0x00FFFFF0L
//BIF_CFG_DEV0_EPF4_0_PCIE_BAR2_CNTL
#define BIF_CFG_DEV0_EPF4_0_PCIE_BAR2_CNTL__BAR_INDEX__SHIFT                                                  0x0
#define BIF_CFG_DEV0_EPF4_0_PCIE_BAR2_CNTL__BAR_TOTAL_NUM__SHIFT                                              0x5
#define BIF_CFG_DEV0_EPF4_0_PCIE_BAR2_CNTL__BAR_SIZE__SHIFT                                                   0x8
#define BIF_CFG_DEV0_EPF4_0_PCIE_BAR2_CNTL__BAR_INDEX_MASK                                                    0x0007L
#define BIF_CFG_DEV0_EPF4_0_PCIE_BAR2_CNTL__BAR_TOTAL_NUM_MASK                                                0x00E0L
#define BIF_CFG_DEV0_EPF4_0_PCIE_BAR2_CNTL__BAR_SIZE_MASK                                                     0x1F00L
//BIF_CFG_DEV0_EPF4_0_PCIE_BAR3_CAP
#define BIF_CFG_DEV0_EPF4_0_PCIE_BAR3_CAP__BAR_SIZE_SUPPORTED__SHIFT                                          0x4
#define BIF_CFG_DEV0_EPF4_0_PCIE_BAR3_CAP__BAR_SIZE_SUPPORTED_MASK                                            0x00FFFFF0L
//BIF_CFG_DEV0_EPF4_0_PCIE_BAR3_CNTL
#define BIF_CFG_DEV0_EPF4_0_PCIE_BAR3_CNTL__BAR_INDEX__SHIFT                                                  0x0
#define BIF_CFG_DEV0_EPF4_0_PCIE_BAR3_CNTL__BAR_TOTAL_NUM__SHIFT                                              0x5
#define BIF_CFG_DEV0_EPF4_0_PCIE_BAR3_CNTL__BAR_SIZE__SHIFT                                                   0x8
#define BIF_CFG_DEV0_EPF4_0_PCIE_BAR3_CNTL__BAR_INDEX_MASK                                                    0x0007L
#define BIF_CFG_DEV0_EPF4_0_PCIE_BAR3_CNTL__BAR_TOTAL_NUM_MASK                                                0x00E0L
#define BIF_CFG_DEV0_EPF4_0_PCIE_BAR3_CNTL__BAR_SIZE_MASK                                                     0x1F00L
//BIF_CFG_DEV0_EPF4_0_PCIE_BAR4_CAP
#define BIF_CFG_DEV0_EPF4_0_PCIE_BAR4_CAP__BAR_SIZE_SUPPORTED__SHIFT                                          0x4
#define BIF_CFG_DEV0_EPF4_0_PCIE_BAR4_CAP__BAR_SIZE_SUPPORTED_MASK                                            0x00FFFFF0L
//BIF_CFG_DEV0_EPF4_0_PCIE_BAR4_CNTL
#define BIF_CFG_DEV0_EPF4_0_PCIE_BAR4_CNTL__BAR_INDEX__SHIFT                                                  0x0
#define BIF_CFG_DEV0_EPF4_0_PCIE_BAR4_CNTL__BAR_TOTAL_NUM__SHIFT                                              0x5
#define BIF_CFG_DEV0_EPF4_0_PCIE_BAR4_CNTL__BAR_SIZE__SHIFT                                                   0x8
#define BIF_CFG_DEV0_EPF4_0_PCIE_BAR4_CNTL__BAR_INDEX_MASK                                                    0x0007L
#define BIF_CFG_DEV0_EPF4_0_PCIE_BAR4_CNTL__BAR_TOTAL_NUM_MASK                                                0x00E0L
#define BIF_CFG_DEV0_EPF4_0_PCIE_BAR4_CNTL__BAR_SIZE_MASK                                                     0x1F00L
//BIF_CFG_DEV0_EPF4_0_PCIE_BAR5_CAP
#define BIF_CFG_DEV0_EPF4_0_PCIE_BAR5_CAP__BAR_SIZE_SUPPORTED__SHIFT                                          0x4
#define BIF_CFG_DEV0_EPF4_0_PCIE_BAR5_CAP__BAR_SIZE_SUPPORTED_MASK                                            0x00FFFFF0L
//BIF_CFG_DEV0_EPF4_0_PCIE_BAR5_CNTL
#define BIF_CFG_DEV0_EPF4_0_PCIE_BAR5_CNTL__BAR_INDEX__SHIFT                                                  0x0
#define BIF_CFG_DEV0_EPF4_0_PCIE_BAR5_CNTL__BAR_TOTAL_NUM__SHIFT                                              0x5
#define BIF_CFG_DEV0_EPF4_0_PCIE_BAR5_CNTL__BAR_SIZE__SHIFT                                                   0x8
#define BIF_CFG_DEV0_EPF4_0_PCIE_BAR5_CNTL__BAR_INDEX_MASK                                                    0x0007L
#define BIF_CFG_DEV0_EPF4_0_PCIE_BAR5_CNTL__BAR_TOTAL_NUM_MASK                                                0x00E0L
#define BIF_CFG_DEV0_EPF4_0_PCIE_BAR5_CNTL__BAR_SIZE_MASK                                                     0x1F00L
//BIF_CFG_DEV0_EPF4_0_PCIE_BAR6_CAP
#define BIF_CFG_DEV0_EPF4_0_PCIE_BAR6_CAP__BAR_SIZE_SUPPORTED__SHIFT                                          0x4
#define BIF_CFG_DEV0_EPF4_0_PCIE_BAR6_CAP__BAR_SIZE_SUPPORTED_MASK                                            0x00FFFFF0L
//BIF_CFG_DEV0_EPF4_0_PCIE_BAR6_CNTL
#define BIF_CFG_DEV0_EPF4_0_PCIE_BAR6_CNTL__BAR_INDEX__SHIFT                                                  0x0
#define BIF_CFG_DEV0_EPF4_0_PCIE_BAR6_CNTL__BAR_TOTAL_NUM__SHIFT                                              0x5
#define BIF_CFG_DEV0_EPF4_0_PCIE_BAR6_CNTL__BAR_SIZE__SHIFT                                                   0x8
#define BIF_CFG_DEV0_EPF4_0_PCIE_BAR6_CNTL__BAR_INDEX_MASK                                                    0x0007L
#define BIF_CFG_DEV0_EPF4_0_PCIE_BAR6_CNTL__BAR_TOTAL_NUM_MASK                                                0x00E0L
#define BIF_CFG_DEV0_EPF4_0_PCIE_BAR6_CNTL__BAR_SIZE_MASK                                                     0x1F00L
//BIF_CFG_DEV0_EPF4_0_PCIE_PWR_BUDGET_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF4_0_PCIE_PWR_BUDGET_ENH_CAP_LIST__CAP_ID__SHIFT                                       0x0
#define BIF_CFG_DEV0_EPF4_0_PCIE_PWR_BUDGET_ENH_CAP_LIST__CAP_VER__SHIFT                                      0x10
#define BIF_CFG_DEV0_EPF4_0_PCIE_PWR_BUDGET_ENH_CAP_LIST__NEXT_PTR__SHIFT                                     0x14
#define BIF_CFG_DEV0_EPF4_0_PCIE_PWR_BUDGET_ENH_CAP_LIST__CAP_ID_MASK                                         0x0000FFFFL
#define BIF_CFG_DEV0_EPF4_0_PCIE_PWR_BUDGET_ENH_CAP_LIST__CAP_VER_MASK                                        0x000F0000L
#define BIF_CFG_DEV0_EPF4_0_PCIE_PWR_BUDGET_ENH_CAP_LIST__NEXT_PTR_MASK                                       0xFFF00000L
//BIF_CFG_DEV0_EPF4_0_PCIE_PWR_BUDGET_DATA_SELECT
#define BIF_CFG_DEV0_EPF4_0_PCIE_PWR_BUDGET_DATA_SELECT__DATA_SELECT__SHIFT                                   0x0
#define BIF_CFG_DEV0_EPF4_0_PCIE_PWR_BUDGET_DATA_SELECT__DATA_SELECT_MASK                                     0xFFL
//BIF_CFG_DEV0_EPF4_0_PCIE_PWR_BUDGET_DATA
#define BIF_CFG_DEV0_EPF4_0_PCIE_PWR_BUDGET_DATA__BASE_POWER__SHIFT                                           0x0
#define BIF_CFG_DEV0_EPF4_0_PCIE_PWR_BUDGET_DATA__DATA_SCALE__SHIFT                                           0x8
#define BIF_CFG_DEV0_EPF4_0_PCIE_PWR_BUDGET_DATA__PM_SUB_STATE__SHIFT                                         0xa
#define BIF_CFG_DEV0_EPF4_0_PCIE_PWR_BUDGET_DATA__PM_STATE__SHIFT                                             0xd
#define BIF_CFG_DEV0_EPF4_0_PCIE_PWR_BUDGET_DATA__TYPE__SHIFT                                                 0xf
#define BIF_CFG_DEV0_EPF4_0_PCIE_PWR_BUDGET_DATA__POWER_RAIL__SHIFT                                           0x12
#define BIF_CFG_DEV0_EPF4_0_PCIE_PWR_BUDGET_DATA__BASE_POWER_MASK                                             0x000000FFL
#define BIF_CFG_DEV0_EPF4_0_PCIE_PWR_BUDGET_DATA__DATA_SCALE_MASK                                             0x00000300L
#define BIF_CFG_DEV0_EPF4_0_PCIE_PWR_BUDGET_DATA__PM_SUB_STATE_MASK                                           0x00001C00L
#define BIF_CFG_DEV0_EPF4_0_PCIE_PWR_BUDGET_DATA__PM_STATE_MASK                                               0x00006000L
#define BIF_CFG_DEV0_EPF4_0_PCIE_PWR_BUDGET_DATA__TYPE_MASK                                                   0x00038000L
#define BIF_CFG_DEV0_EPF4_0_PCIE_PWR_BUDGET_DATA__POWER_RAIL_MASK                                             0x001C0000L
//BIF_CFG_DEV0_EPF4_0_PCIE_PWR_BUDGET_CAP
#define BIF_CFG_DEV0_EPF4_0_PCIE_PWR_BUDGET_CAP__SYSTEM_ALLOCATED__SHIFT                                      0x0
#define BIF_CFG_DEV0_EPF4_0_PCIE_PWR_BUDGET_CAP__SYSTEM_ALLOCATED_MASK                                        0x01L
//BIF_CFG_DEV0_EPF4_0_PCIE_DPA_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF4_0_PCIE_DPA_ENH_CAP_LIST__CAP_ID__SHIFT                                              0x0
#define BIF_CFG_DEV0_EPF4_0_PCIE_DPA_ENH_CAP_LIST__CAP_VER__SHIFT                                             0x10
#define BIF_CFG_DEV0_EPF4_0_PCIE_DPA_ENH_CAP_LIST__NEXT_PTR__SHIFT                                            0x14
#define BIF_CFG_DEV0_EPF4_0_PCIE_DPA_ENH_CAP_LIST__CAP_ID_MASK                                                0x0000FFFFL
#define BIF_CFG_DEV0_EPF4_0_PCIE_DPA_ENH_CAP_LIST__CAP_VER_MASK                                               0x000F0000L
#define BIF_CFG_DEV0_EPF4_0_PCIE_DPA_ENH_CAP_LIST__NEXT_PTR_MASK                                              0xFFF00000L
//BIF_CFG_DEV0_EPF4_0_PCIE_DPA_CAP
#define BIF_CFG_DEV0_EPF4_0_PCIE_DPA_CAP__SUBSTATE_MAX__SHIFT                                                 0x0
#define BIF_CFG_DEV0_EPF4_0_PCIE_DPA_CAP__TRANS_LAT_UNIT__SHIFT                                               0x8
#define BIF_CFG_DEV0_EPF4_0_PCIE_DPA_CAP__PWR_ALLOC_SCALE__SHIFT                                              0xc
#define BIF_CFG_DEV0_EPF4_0_PCIE_DPA_CAP__TRANS_LAT_VAL_0__SHIFT                                              0x10
#define BIF_CFG_DEV0_EPF4_0_PCIE_DPA_CAP__TRANS_LAT_VAL_1__SHIFT                                              0x18
#define BIF_CFG_DEV0_EPF4_0_PCIE_DPA_CAP__SUBSTATE_MAX_MASK                                                   0x0000001FL
#define BIF_CFG_DEV0_EPF4_0_PCIE_DPA_CAP__TRANS_LAT_UNIT_MASK                                                 0x00000300L
#define BIF_CFG_DEV0_EPF4_0_PCIE_DPA_CAP__PWR_ALLOC_SCALE_MASK                                                0x00003000L
#define BIF_CFG_DEV0_EPF4_0_PCIE_DPA_CAP__TRANS_LAT_VAL_0_MASK                                                0x00FF0000L
#define BIF_CFG_DEV0_EPF4_0_PCIE_DPA_CAP__TRANS_LAT_VAL_1_MASK                                                0xFF000000L
//BIF_CFG_DEV0_EPF4_0_PCIE_DPA_LATENCY_INDICATOR
#define BIF_CFG_DEV0_EPF4_0_PCIE_DPA_LATENCY_INDICATOR__TRANS_LAT_INDICATOR_BITS__SHIFT                       0x0
#define BIF_CFG_DEV0_EPF4_0_PCIE_DPA_LATENCY_INDICATOR__TRANS_LAT_INDICATOR_BITS_MASK                         0xFFL
//BIF_CFG_DEV0_EPF4_0_PCIE_DPA_STATUS
#define BIF_CFG_DEV0_EPF4_0_PCIE_DPA_STATUS__SUBSTATE_STATUS__SHIFT                                           0x0
#define BIF_CFG_DEV0_EPF4_0_PCIE_DPA_STATUS__SUBSTATE_CNTL_ENABLED__SHIFT                                     0x8
#define BIF_CFG_DEV0_EPF4_0_PCIE_DPA_STATUS__SUBSTATE_STATUS_MASK                                             0x001FL
#define BIF_CFG_DEV0_EPF4_0_PCIE_DPA_STATUS__SUBSTATE_CNTL_ENABLED_MASK                                       0x0100L
//BIF_CFG_DEV0_EPF4_0_PCIE_DPA_CNTL
#define BIF_CFG_DEV0_EPF4_0_PCIE_DPA_CNTL__SUBSTATE_CNTL__SHIFT                                               0x0
#define BIF_CFG_DEV0_EPF4_0_PCIE_DPA_CNTL__SUBSTATE_CNTL_MASK                                                 0x1FL
//BIF_CFG_DEV0_EPF4_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_0
#define BIF_CFG_DEV0_EPF4_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_0__SUBSTATE_PWR_ALLOC__SHIFT                          0x0
#define BIF_CFG_DEV0_EPF4_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_0__SUBSTATE_PWR_ALLOC_MASK                            0xFFL
//BIF_CFG_DEV0_EPF4_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_1
#define BIF_CFG_DEV0_EPF4_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_1__SUBSTATE_PWR_ALLOC__SHIFT                          0x0
#define BIF_CFG_DEV0_EPF4_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_1__SUBSTATE_PWR_ALLOC_MASK                            0xFFL
//BIF_CFG_DEV0_EPF4_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_2
#define BIF_CFG_DEV0_EPF4_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_2__SUBSTATE_PWR_ALLOC__SHIFT                          0x0
#define BIF_CFG_DEV0_EPF4_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_2__SUBSTATE_PWR_ALLOC_MASK                            0xFFL
//BIF_CFG_DEV0_EPF4_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_3
#define BIF_CFG_DEV0_EPF4_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_3__SUBSTATE_PWR_ALLOC__SHIFT                          0x0
#define BIF_CFG_DEV0_EPF4_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_3__SUBSTATE_PWR_ALLOC_MASK                            0xFFL
//BIF_CFG_DEV0_EPF4_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_4
#define BIF_CFG_DEV0_EPF4_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_4__SUBSTATE_PWR_ALLOC__SHIFT                          0x0
#define BIF_CFG_DEV0_EPF4_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_4__SUBSTATE_PWR_ALLOC_MASK                            0xFFL
//BIF_CFG_DEV0_EPF4_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_5
#define BIF_CFG_DEV0_EPF4_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_5__SUBSTATE_PWR_ALLOC__SHIFT                          0x0
#define BIF_CFG_DEV0_EPF4_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_5__SUBSTATE_PWR_ALLOC_MASK                            0xFFL
//BIF_CFG_DEV0_EPF4_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_6
#define BIF_CFG_DEV0_EPF4_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_6__SUBSTATE_PWR_ALLOC__SHIFT                          0x0
#define BIF_CFG_DEV0_EPF4_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_6__SUBSTATE_PWR_ALLOC_MASK                            0xFFL
//BIF_CFG_DEV0_EPF4_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_7
#define BIF_CFG_DEV0_EPF4_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_7__SUBSTATE_PWR_ALLOC__SHIFT                          0x0
#define BIF_CFG_DEV0_EPF4_0_PCIE_DPA_SUBSTATE_PWR_ALLOC_7__SUBSTATE_PWR_ALLOC_MASK                            0xFFL
//BIF_CFG_DEV0_EPF4_0_PCIE_ACS_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF4_0_PCIE_ACS_ENH_CAP_LIST__CAP_ID__SHIFT                                              0x0
#define BIF_CFG_DEV0_EPF4_0_PCIE_ACS_ENH_CAP_LIST__CAP_VER__SHIFT                                             0x10
#define BIF_CFG_DEV0_EPF4_0_PCIE_ACS_ENH_CAP_LIST__NEXT_PTR__SHIFT                                            0x14
#define BIF_CFG_DEV0_EPF4_0_PCIE_ACS_ENH_CAP_LIST__CAP_ID_MASK                                                0x0000FFFFL
#define BIF_CFG_DEV0_EPF4_0_PCIE_ACS_ENH_CAP_LIST__CAP_VER_MASK                                               0x000F0000L
#define BIF_CFG_DEV0_EPF4_0_PCIE_ACS_ENH_CAP_LIST__NEXT_PTR_MASK                                              0xFFF00000L
//BIF_CFG_DEV0_EPF4_0_PCIE_ACS_CAP
#define BIF_CFG_DEV0_EPF4_0_PCIE_ACS_CAP__SOURCE_VALIDATION__SHIFT                                            0x0
#define BIF_CFG_DEV0_EPF4_0_PCIE_ACS_CAP__TRANSLATION_BLOCKING__SHIFT                                         0x1
#define BIF_CFG_DEV0_EPF4_0_PCIE_ACS_CAP__P2P_REQUEST_REDIRECT__SHIFT                                         0x2
#define BIF_CFG_DEV0_EPF4_0_PCIE_ACS_CAP__P2P_COMPLETION_REDIRECT__SHIFT                                      0x3
#define BIF_CFG_DEV0_EPF4_0_PCIE_ACS_CAP__UPSTREAM_FORWARDING__SHIFT                                          0x4
#define BIF_CFG_DEV0_EPF4_0_PCIE_ACS_CAP__P2P_EGRESS_CONTROL__SHIFT                                           0x5
#define BIF_CFG_DEV0_EPF4_0_PCIE_ACS_CAP__DIRECT_TRANSLATED_P2P__SHIFT                                        0x6
#define BIF_CFG_DEV0_EPF4_0_PCIE_ACS_CAP__EGRESS_CONTROL_VECTOR_SIZE__SHIFT                                   0x8
#define BIF_CFG_DEV0_EPF4_0_PCIE_ACS_CAP__SOURCE_VALIDATION_MASK                                              0x0001L
#define BIF_CFG_DEV0_EPF4_0_PCIE_ACS_CAP__TRANSLATION_BLOCKING_MASK                                           0x0002L
#define BIF_CFG_DEV0_EPF4_0_PCIE_ACS_CAP__P2P_REQUEST_REDIRECT_MASK                                           0x0004L
#define BIF_CFG_DEV0_EPF4_0_PCIE_ACS_CAP__P2P_COMPLETION_REDIRECT_MASK                                        0x0008L
#define BIF_CFG_DEV0_EPF4_0_PCIE_ACS_CAP__UPSTREAM_FORWARDING_MASK                                            0x0010L
#define BIF_CFG_DEV0_EPF4_0_PCIE_ACS_CAP__P2P_EGRESS_CONTROL_MASK                                             0x0020L
#define BIF_CFG_DEV0_EPF4_0_PCIE_ACS_CAP__DIRECT_TRANSLATED_P2P_MASK                                          0x0040L
#define BIF_CFG_DEV0_EPF4_0_PCIE_ACS_CAP__EGRESS_CONTROL_VECTOR_SIZE_MASK                                     0xFF00L
//BIF_CFG_DEV0_EPF4_0_PCIE_ACS_CNTL
#define BIF_CFG_DEV0_EPF4_0_PCIE_ACS_CNTL__SOURCE_VALIDATION_EN__SHIFT                                        0x0
#define BIF_CFG_DEV0_EPF4_0_PCIE_ACS_CNTL__TRANSLATION_BLOCKING_EN__SHIFT                                     0x1
#define BIF_CFG_DEV0_EPF4_0_PCIE_ACS_CNTL__P2P_REQUEST_REDIRECT_EN__SHIFT                                     0x2
#define BIF_CFG_DEV0_EPF4_0_PCIE_ACS_CNTL__P2P_COMPLETION_REDIRECT_EN__SHIFT                                  0x3
#define BIF_CFG_DEV0_EPF4_0_PCIE_ACS_CNTL__UPSTREAM_FORWARDING_EN__SHIFT                                      0x4
#define BIF_CFG_DEV0_EPF4_0_PCIE_ACS_CNTL__P2P_EGRESS_CONTROL_EN__SHIFT                                       0x5
#define BIF_CFG_DEV0_EPF4_0_PCIE_ACS_CNTL__DIRECT_TRANSLATED_P2P_EN__SHIFT                                    0x6
#define BIF_CFG_DEV0_EPF4_0_PCIE_ACS_CNTL__SOURCE_VALIDATION_EN_MASK                                          0x0001L
#define BIF_CFG_DEV0_EPF4_0_PCIE_ACS_CNTL__TRANSLATION_BLOCKING_EN_MASK                                       0x0002L
#define BIF_CFG_DEV0_EPF4_0_PCIE_ACS_CNTL__P2P_REQUEST_REDIRECT_EN_MASK                                       0x0004L
#define BIF_CFG_DEV0_EPF4_0_PCIE_ACS_CNTL__P2P_COMPLETION_REDIRECT_EN_MASK                                    0x0008L
#define BIF_CFG_DEV0_EPF4_0_PCIE_ACS_CNTL__UPSTREAM_FORWARDING_EN_MASK                                        0x0010L
#define BIF_CFG_DEV0_EPF4_0_PCIE_ACS_CNTL__P2P_EGRESS_CONTROL_EN_MASK                                         0x0020L
#define BIF_CFG_DEV0_EPF4_0_PCIE_ACS_CNTL__DIRECT_TRANSLATED_P2P_EN_MASK                                      0x0040L
//BIF_CFG_DEV0_EPF4_0_PCIE_ARI_ENH_CAP_LIST
#define BIF_CFG_DEV0_EPF4_0_PCIE_ARI_ENH_CAP_LIST__CAP_ID__SHIFT                                              0x0
#define BIF_CFG_DEV0_EPF4_0_PCIE_ARI_ENH_CAP_LIST__CAP_VER__SHIFT                                             0x10
#define BIF_CFG_DEV0_EPF4_0_PCIE_ARI_ENH_CAP_LIST__NEXT_PTR__SHIFT                                            0x14
#define BIF_CFG_DEV0_EPF4_0_PCIE_ARI_ENH_CAP_LIST__CAP_ID_MASK                                                0x0000FFFFL
#define BIF_CFG_DEV0_EPF4_0_PCIE_ARI_ENH_CAP_LIST__CAP_VER_MASK                                               0x000F0000L
#define BIF_CFG_DEV0_EPF4_0_PCIE_ARI_ENH_CAP_LIST__NEXT_PTR_MASK                                              0xFFF00000L
//BIF_CFG_DEV0_EPF4_0_PCIE_ARI_CAP
#define BIF_CFG_DEV0_EPF4_0_PCIE_ARI_CAP__ARI_MFVC_FUNC_GROUPS_CAP__SHIFT                                     0x0
#define BIF_CFG_DEV0_EPF4_0_PCIE_ARI_CAP__ARI_ACS_FUNC_GROUPS_CAP__SHIFT                                      0x1
#define BIF_CFG_DEV0_EPF4_0_PCIE_ARI_CAP__ARI_NEXT_FUNC_NUM__SHIFT                                            0x8
#define BIF_CFG_DEV0_EPF4_0_PCIE_ARI_CAP__ARI_MFVC_FUNC_GROUPS_CAP_MASK                                       0x0001L
#define BIF_CFG_DEV0_EPF4_0_PCIE_ARI_CAP__ARI_ACS_FUNC_GROUPS_CAP_MASK                                        0x0002L
#define BIF_CFG_DEV0_EPF4_0_PCIE_ARI_CAP__ARI_NEXT_FUNC_NUM_MASK                                              0xFF00L
//BIF_CFG_DEV0_EPF4_0_PCIE_ARI_CNTL
#define BIF_CFG_DEV0_EPF4_0_PCIE_ARI_CNTL__ARI_MFVC_FUNC_GROUPS_EN__SHIFT                                     0x0
#define BIF_CFG_DEV0_EPF4_0_PCIE_ARI_CNTL__ARI_ACS_FUNC_GROUPS_EN__SHIFT                                      0x1
#define BIF_CFG_DEV0_EPF4_0_PCIE_ARI_CNTL__ARI_FUNCTION_GROUP__SHIFT                                          0x4
#define BIF_CFG_DEV0_EPF4_0_PCIE_ARI_CNTL__ARI_MFVC_FUNC_GROUPS_EN_MASK                                       0x0001L
#define BIF_CFG_DEV0_EPF4_0_PCIE_ARI_CNTL__ARI_ACS_FUNC_GROUPS_EN_MASK                                        0x0002L
#define BIF_CFG_DEV0_EPF4_0_PCIE_ARI_CNTL__ARI_FUNCTION_GROUP_MASK                                            0x0070L


// addressBlock: nbio_nbif0_bif_cfg_dev0_epf5_bifcfgdecp
//BIF_CFG_DEV0_EPF5_0_VENDOR_ID
#define BIF_CFG_DEV0_EPF5_0_VENDOR_ID__VENDOR_ID__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF5_0_VENDOR_ID__VENDOR_ID_MASK                                                         0xFFFFL
//BIF_CFG_DEV0_EPF5_0_DEVICE_ID
#define BIF_CFG_DEV0_EPF5_0_DEVICE_ID__DEVICE_ID__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF5_0_DEVICE_ID__DEVICE_ID_MASK                                                         0xFFFFL
//BIF_CFG_DEV0_EPF5_0_COMMAND
#define BIF_CFG_DEV0_EPF5_0_COMMAND__IO_ACCESS_EN__SHIFT                                                      0x0
#define BIF_CFG_DEV0_EPF5_0_COMMAND__MEM_ACCESS_EN__SHIFT                                                     0x1
#define BIF_CFG_DEV0_EPF5_0_COMMAND__BUS_MASTER_EN__SHIFT                                                     0x2
#define BIF_CFG_DEV0_EPF5_0_COMMAND__SPECIAL_CYCLE_EN__SHIFT                                                  0x3
#define BIF_CFG_DEV0_EPF5_0_COMMAND__MEM_WRITE_INVALIDATE_EN__SHIFT                                           0x4
#define BIF_CFG_DEV0_EPF5_0_COMMAND__PAL_SNOOP_EN__SHIFT                                                      0x5
#define BIF_CFG_DEV0_EPF5_0_COMMAND__PARITY_ERROR_RESPONSE__SHIFT                                             0x6
#define BIF_CFG_DEV0_EPF5_0_COMMAND__AD_STEPPING__SHIFT                                                       0x7
#define BIF_CFG_DEV0_EPF5_0_COMMAND__SERR_EN__SHIFT                                                           0x8
#define BIF_CFG_DEV0_EPF5_0_COMMAND__FAST_B2B_EN__SHIFT                                                       0x9
#define BIF_CFG_DEV0_EPF5_0_COMMAND__INT_DIS__SHIFT                                                           0xa
#define BIF_CFG_DEV0_EPF5_0_COMMAND__IO_ACCESS_EN_MASK                                                        0x0001L
#define BIF_CFG_DEV0_EPF5_0_COMMAND__MEM_ACCESS_EN_MASK                                                       0x0002L
#define BIF_CFG_DEV0_EPF5_0_COMMAND__BUS_MASTER_EN_MASK                                                       0x0004L
#define BIF_CFG_DEV0_EPF5_0_COMMAND__SPECIAL_CYCLE_EN_MASK                                                    0x0008L
#define BIF_CFG_DEV0_EPF5_0_COMMAND__MEM_WRITE_INVALIDATE_EN_MASK                                             0x0010L
#define BIF_CFG_DEV0_EPF5_0_COMMAND__PAL_SNOOP_EN_MASK                                                        0x0020L
#define BIF_CFG_DEV0_EPF5_0_COMMAND__PARITY_ERROR_RESPONSE_MASK                                               0x0040L
#define BIF_CFG_DEV0_EPF5_0_COMMAND__AD_STEPPING_MASK                                                         0x0080L
#define BIF_CFG_DEV0_EPF5_0_COMMAND__SERR_EN_MASK                                                             0x0100L
#define BIF_CFG_DEV0_EPF5_0_COMMAND__FAST_B2B_EN_MASK                                                         0x0200L
#define BIF_CFG_DEV0_EPF5_0_COMMAND__INT_DIS_MASK                                                             0x0400L
//BIF_CFG_DEV0_EPF5_0_STATUS
#define BIF_CFG_DEV0_EPF5_0_STATUS__INT_STATUS__SHIFT                                                         0x3
#define BIF_CFG_DEV0_EPF5_0_STATUS__CAP_LIST__SHIFT                                                           0x4
#define BIF_CFG_DEV0_EPF5_0_STATUS__PCI_66_EN__SHIFT                                                          0x5
#define BIF_CFG_DEV0_EPF5_0_STATUS__FAST_BACK_CAPABLE__SHIFT                                                  0x7
#define BIF_CFG_DEV0_EPF5_0_STATUS__MASTER_DATA_PARITY_ERROR__SHIFT                                           0x8
#define BIF_CFG_DEV0_EPF5_0_STATUS__DEVSEL_TIMING__SHIFT                                                      0x9
#define BIF_CFG_DEV0_EPF5_0_STATUS__SIGNAL_TARGET_ABORT__SHIFT                                                0xb
#define BIF_CFG_DEV0_EPF5_0_STATUS__RECEIVED_TARGET_ABORT__SHIFT                                              0xc
#define BIF_CFG_DEV0_EPF5_0_STATUS__RECEIVED_MASTER_ABORT__SHIFT                                              0xd
#define BIF_CFG_DEV0_EPF5_0_STATUS__SIGNALED_SYSTEM_ERROR__SHIFT                                              0xe
#define BIF_CFG_DEV0_EPF5_0_STATUS__PARITY_ERROR_DETECTED__SHIFT                                              0xf
#define BIF_CFG_DEV0_EPF5_0_STATUS__INT_STATUS_MASK                                                           0x0008L
#define BIF_CFG_DEV0_EPF5_0_STATUS__CAP_LIST_MASK                                                             0x0010L
#define BIF_CFG_DEV0_EPF5_0_STATUS__PCI_66_EN_MASK                                                            0x0020L
#define BIF_CFG_DEV0_EPF5_0_STATUS__FAST_BACK_CAPABLE_MASK                                                    0x0080L
#define BIF_CFG_DEV0_EPF5_0_STATUS__MASTER_DATA_PARITY_ERROR_MASK                                             0x0100L
#define BIF_CFG_DEV0_EPF5_0_STATUS__DEVSEL_TIMING_MASK                                                        0x0600L
#define BIF_CFG_DEV0_EPF5_0_STATUS__SIGNAL_TARGET_ABORT_MASK                                                  0x0800L
#define BIF_CFG_DEV0_EPF5_0_STATUS__RECEIVED_TARGET_ABORT_MASK                                                0x1000L
#define BIF_CFG_DEV0_EPF5_0_STATUS__RECEIVED_MASTER_ABORT_MASK                                                0x2000L
#define BIF_CFG_DEV0_EPF5_0_STATUS__SIGNALED_SYSTEM_ERROR_MASK                                                0x4000L
#define BIF_CFG_DEV0_EPF5_0_STATUS__PARITY_ERROR_DETECTED_MASK                                                0x8000L
//BIF_CFG_DEV0_EPF5_0_REVISION_ID
#define BIF_CFG_DEV0_EPF5_0_REVISION_ID__MINOR_REV_ID__SHIFT                                                  0x0
#define BIF_CFG_DEV0_EPF5_0_REVISION_ID__MAJOR_REV_ID__SHIFT                                                  0x4
#define BIF_CFG_DEV0_EPF5_0_REVISION_ID__MINOR_REV_ID_MASK                                                    0x0FL
#define BIF_CFG_DEV0_EPF5_0_REVISION_ID__MAJOR_REV_ID_MASK                                                    0xF0L
//BIF_CFG_DEV0_EPF5_0_PROG_INTERFACE
#define BIF_CFG_DEV0_EPF5_0_PROG_INTERFACE__PROG_INTERFACE__SHIFT                                             0x0
#define BIF_CFG_DEV0_EPF5_0_PROG_INTERFACE__PROG_INTERFACE_MASK                                               0xFFL
//BIF_CFG_DEV0_EPF5_0_SUB_CLASS
#define BIF_CFG_DEV0_EPF5_0_SUB_CLASS__SUB_CLASS__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF5_0_SUB_CLASS__SUB_CLASS_MASK                                                         0xFFL
//BIF_CFG_DEV0_EPF5_0_BASE_CLASS
#define BIF_CFG_DEV0_EPF5_0_BASE_CLASS__BASE_CLASS__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF5_0_BASE_CLASS__BASE_CLASS_MASK                                                       0xFFL
//BIF_CFG_DEV0_EPF5_0_CACHE_LINE
#define BIF_CFG_DEV0_EPF5_0_CACHE_LINE__CACHE_LINE_SIZE__SHIFT                                                0x0
#define BIF_CFG_DEV0_EPF5_0_CACHE_LINE__CACHE_LINE_SIZE_MASK                                                  0xFFL
//BIF_CFG_DEV0_EPF5_0_LATENCY
#define BIF_CFG_DEV0_EPF5_0_LATENCY__LATENCY_TIMER__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF5_0_LATENCY__LATENCY_TIMER_MASK                                                       0xFFL
//BIF_CFG_DEV0_EPF5_0_HEADER
#define BIF_CFG_DEV0_EPF5_0_HEADER__HEADER_TYPE__SHIFT                                                        0x0
#define BIF_CFG_DEV0_EPF5_0_HEADER__DEVICE_TYPE__SHIFT                                                        0x7
#define BIF_CFG_DEV0_EPF5_0_HEADER__HEADER_TYPE_MASK                                                          0x7FL
#define BIF_CFG_DEV0_EPF5_0_HEADER__DEVICE_TYPE_MASK                                                          0x80L
//BIF_CFG_DEV0_EPF5_0_BIST
#define BIF_CFG_DEV0_EPF5_0_BIST__BIST_COMP__SHIFT                                                            0x0
#define BIF_CFG_DEV0_EPF5_0_BIST__BIST_STRT__SHIFT                                                            0x6
#define BIF_CFG_DEV0_EPF5_0_BIST__BIST_CAP__SHIFT                                                             0x7
#define BIF_CFG_DEV0_EPF5_0_BIST__BIST_COMP_MASK                                                              0x0FL
#define BIF_CFG_DEV0_EPF5_0_BIST__BIST_STRT_MASK                                                              0x40L
#define BIF_CFG_DEV0_EPF5_0_BIST__BIST_CAP_MASK                                                               0x80L
//BIF_CFG_DEV0_EPF5_0_BASE_ADDR_1
#define BIF_CFG_DEV0_EPF5_0_BASE_ADDR_1__BASE_ADDR__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF5_0_BASE_ADDR_1__BASE_ADDR_MASK                                                       0xFFFFFFFFL
//BIF_CFG_DEV0_EPF5_0_BASE_ADDR_2
#define BIF_CFG_DEV0_EPF5_0_BASE_ADDR_2__BASE_ADDR__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF5_0_BASE_ADDR_2__BASE_ADDR_MASK                                                       0xFFFFFFFFL
//BIF_CFG_DEV0_EPF5_0_BASE_ADDR_3
#define BIF_CFG_DEV0_EPF5_0_BASE_ADDR_3__BASE_ADDR__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF5_0_BASE_ADDR_3__BASE_ADDR_MASK                                                       0xFFFFFFFFL
//BIF_CFG_DEV0_EPF5_0_BASE_ADDR_4
#define BIF_CFG_DEV0_EPF5_0_BASE_ADDR_4__BASE_ADDR__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF5_0_BASE_ADDR_4__BASE_ADDR_MASK                                                       0xFFFFFFFFL
//BIF_CFG_DEV0_EPF5_0_BASE_ADDR_5
#define BIF_CFG_DEV0_EPF5_0_BASE_ADDR_5__BASE_ADDR__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF5_0_BASE_ADDR_5__BASE_ADDR_MASK                                                       0xFFFFFFFFL
//BIF_CFG_DEV0_EPF5_0_BASE_ADDR_6
#define BIF_CFG_DEV0_EPF5_0_BASE_ADDR_6__BASE_ADDR__SHIFT                                                     0x0
#define BIF_CFG_DEV0_EPF5_0_BASE_ADDR_6__BASE_ADDR_MASK                                                       0xFFFFFFFFL
//BIF_CFG_DEV0_EPF5_0_ADAPTER_ID
#define BIF_CFG_DEV0_EPF5_0_ADAPTER_ID__SUBSYSTEM_VENDOR_ID__SHIFT                                            0x0
#define BIF_CFG_DEV0_EPF5_0_ADAPTER_ID__SUBSYSTEM_ID__SHIFT                                                   0x10
#define BIF_CFG_DEV0_EPF5_0_ADAPTER_ID__SUBSYSTEM_VENDOR_ID_MASK                                              0x0000FFFFL
#define BIF_CFG_DEV0_EPF5_0_ADAPTER_ID__SUBSYSTEM_ID_MASK                                                     0xFFFF0000L
//BIF_CFG_DEV0_EPF5_0_ROM_BASE_ADDR
#define BIF_CFG_DEV0_EPF5_0_ROM_BASE_ADDR__BASE_ADDR__SHIFT                                                   0x0
#define BIF_CFG_DEV0_EPF5_0_ROM_BASE_ADDR__BASE_ADDR_MASK                                                     0xFFFFFFFFL
//BIF_CFG_DEV0_EPF5_0_CAP_PTR
#define BIF_CFG_DEV0_EPF5_0_CAP_PTR__CAP_PTR__SHIFT                                                           0x0
#define BIF_CFG_DEV0_EPF5_0_CAP_PTR__CAP_PTR_MASK                                                             0x000000FFL
//BIF_CFG_DEV0_EPF5_0_INTERRUPT_LINE
#define BIF_CFG_DEV0_EPF5_0_INTERRUPT_LINE__INTERRUPT_LINE__SHIFT                                             0x0
#define BIF_CFG_DEV0_EPF5_0_INTERRUPT_LINE__INTERRUPT_LINE_MASK                                               0xFFL
//BIF_CFG_DEV0_EPF5_0_INTERRUPT_PIN
#define BIF_CFG_DEV0_EPF5_0_INTERRUPT_PIN__INTERRUPT_PIN__SHIFT                                               0x0
#define BIF_CFG_DEV0_EPF5_0_INTERRUPT_PIN__INTERRUPT_PIN_MASK                                                 0xFFL
//BIF_CFG_DEV0_EPF5_0_MIN_GRANT
#define BIF_CFG_DEV0_EPF5_0_MIN_GRANT__MIN_GNT__SHIFT                                                         0x0
#define BIF_CFG_DEV0_EPF5_0_MIN_GRANT__MIN_GNT_MASK                                                           0xFFL
//BIF_CFG_DEV0_EPF5_0_MAX_LATENCY
#define BIF_CFG_DEV0_EPF5_0_MAX_LATENCY__MAX_LAT__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF5_0_MAX_LATENCY__MAX_LAT_MASK                                                         0xFFL
//BIF_CFG_DEV0_EPF5_0_VENDOR_CAP_LIST
#define BIF_CFG_DEV0_EPF5_0_VENDOR_CAP_LIST__CAP_ID__SHIFT                                                    0x0
#define BIF_CFG_DEV0_EPF5_0_VENDOR_CAP_LIST__NEXT_PTR__SHIFT                                                  0x8
#define BIF_CFG_DEV0_EPF5_0_VENDOR_CAP_LIST__LENGTH__SHIFT                                                    0x10
#define BIF_CFG_DEV0_EPF5_0_VENDOR_CAP_LIST__CAP_ID_MASK                                                      0x000000FFL
#define BIF_CFG_DEV0_EPF5_0_VENDOR_CAP_LIST__NEXT_PTR_MASK                                                    0x0000FF00L
#define BIF_CFG_DEV0_EPF5_0_VENDOR_CAP_LIST__LENGTH_MASK                                                      0x00FF0000L
//BIF_CFG_DEV0_EPF5_0_ADAPTER_ID_W
#define BIF_CFG_DEV0_EPF5_0_ADAPTER_ID_W__SUBSYSTEM_VENDOR_ID__SHIFT                                          0x0
#define BIF_CFG_DEV0_EPF5_0_ADAPTER_ID_W__SUBSYSTEM_ID__SHIFT                                                 0x10
#define BIF_CFG_DEV0_EPF5_0_ADAPTER_ID_W__SUBSYSTEM_VENDOR_ID_MASK                                            0x0000FFFFL
#define BIF_CFG_DEV0_EPF5_0_ADAPTER_ID_W__SUBSYSTEM_ID_MASK                                                   0xFFFF0000L
//BIF_CFG_DEV0_EPF5_0_PMI_CAP_LIST
#define BIF_CFG_DEV0_EPF5_0_PMI_CAP_LIST__CAP_ID__SHIFT                                                       0x0
#define BIF_CFG_DEV0_EPF5_0_PMI_CAP_LIST__NEXT_PTR__SHIFT                                                     0x8
#define BIF_CFG_DEV0_EPF5_0_PMI_CAP_LIST__CAP_ID_MASK                                                         0x00FFL
#define BIF_CFG_DEV0_EPF5_0_PMI_CAP_LIST__NEXT_PTR_MASK                                                       0xFF00L
//BIF_CFG_DEV0_EPF5_0_PMI_CAP
#define BIF_CFG_DEV0_EPF5_0_PMI_CAP__VERSION__SHIFT                                                           0x0
#define BIF_CFG_DEV0_EPF5_0_PMI_CAP__PME_CLOCK__SHIFT                                                         0x3
#define BIF_CFG_DEV0_EPF5_0_PMI_CAP__DEV_SPECIFIC_INIT__SHIFT                                                 0x5
#define BIF_CFG_DEV0_EPF5_0_PMI_CAP__AUX_CURRENT__SHIFT                                                       0x6
#define BIF_CFG_DEV0_EPF5_0_PMI_CAP__D1_SUPPORT__SHIFT                                                        0x9
#define BIF_CFG_DEV0_EPF5_0_PMI_CAP__D2_SUPPORT__SHIFT                                                        0xa
#define BIF_CFG_DEV0_EPF5_0_PMI_CAP__PME_SUPPORT__SHIFT                                                       0xb
#define BIF_CFG_DEV0_EPF5_0_PMI_CAP__VERSION_MASK                                                             0x0007L
#define BIF_CFG_DEV0_EPF5_0_PMI_CAP__PME_CLOCK_MASK                                                           0x0008L
#define BIF_CFG_DEV0_EPF5_0_PMI_CAP__DEV_SPECIFIC_INIT_MASK                                                   0x0020L
#define BIF_CFG_DEV0_EPF5_0_PMI_CAP__AUX_CURRENT_MASK                                                         0x01C0L
#define BIF_CFG_DEV0_EPF5_0_PMI_CAP__D1_SUPPORT_MASK                                                          0x0200L
#define BIF_CFG_DEV0_EPF5_0_PMI_CAP__D2_SUPPORT_MASK                                                          0x0400L
#define BIF_CFG_DEV0_EPF5_0_PMI_CAP__PME_SUPPORT_MASK                                                         0xF800L
//BIF_CFG_DEV0_EPF5_0_PMI_STATUS_CNTL
#define BIF_CFG_DEV0_EPF5_0_PMI_STATUS_CNTL__POWER_STATE__SHIFT                                               0x0
#define BIF_CFG_DEV0_EPF5_0_PMI_STATUS_CNTL__NO_SOFT_RESET__SHIFT                                             0x3
#define BIF_CFG_DEV0_EPF5_0_PMI_STATUS_CNTL__PME_EN__SHIFT                                                    0x8
#define BIF_CFG_DEV0_EPF5_0_PMI_STATUS_CNTL__DATA_SELECT__SHIFT                                               0x9
#define BIF_CFG_DEV0_EPF5_0_PMI_STATUS_CNTL__DATA_SCALE__SHIFT                                                0xd
#define BIF_CFG_DEV0_EPF5_0_PMI_STATUS_CNTL__PME_STATUS__SHIFT                                                0xf
#define BIF_CFG_DEV0_EPF5_0_PMI_STATUS_CNTL__B2_B3_SUPPORT__SHIFT                                             0x16
#define BIF_CFG_DEV0_EPF5_0_PMI_STATUS_CNTL__BUS_PWR_EN__SHIFT                                                0x17
#define BIF_CFG_DEV0_EPF5_0_PMI_STATUS_CNTL__PMI_DATA__SHIFT                                                  0x18
#define BIF_CFG_DEV0_EPF5_0_PMI_STATUS_CNTL__POWER_STATE_MASK                                                 0x00000003L
#define BIF_CFG_DEV0_EPF5_0_PMI_STATUS_CNTL__NO_SOFT_RESET_MASK                                               0x00000008L
#define BIF_CFG_DEV0_EPF5_0_PMI_STATUS_CNTL__PME_EN_MASK                                                      0x00000100L
#define BIF_CFG_DEV0_EPF5_0_PMI_STATUS_CNTL__DATA_SELECT_MASK                                                 0x00001E00L
#define BIF_CFG_DEV0_EPF5_0_PMI_STATUS_CNTL__DATA_SCALE_MASK                                                  0x00006000L
#define BIF_CFG_DEV0_EPF5_0_PMI_STATUS_CNTL__PME_STATUS_MASK                                                  0x00008000L
#define BIF_CFG_DEV0_EPF5_0_PMI_STATUS_CNTL__B2_B3_SUPPORT_MASK                                               0x00400000L
#define BIF_CFG_DEV0_EPF5_0_PMI_STATUS_CNTL__BUS_PWR_EN_MASK                                                  0x00800000L
#define BIF_CFG_DEV0_EPF5_0_PMI_STATUS_CNTL__PMI_DATA_MASK                                                    0xFF000000L
//BIF_CFG_DEV0_EPF5_0_SBRN
#define BIF_CFG_DEV0_EPF5_0_SBRN__SBRN__SHIFT                                                                 0x0
#define BIF_CFG_DEV0_EPF5_0_SBRN__SBRN_MASK                                                                   0xFFL
//BIF_CFG_DEV0_EPF5_0_FLADJ
#define BIF_CFG_DEV0_EPF5_0_FLADJ__FLADJ__SHIFT                                                               0x0
#define BIF_CFG_DEV0_EPF5_0_FLADJ__FLADJ_MASK                                                                 0x3FL
//BIF_CFG_DEV0_EPF5_0_DBESL_DBESLD
#define BIF_CFG_DEV0_EPF5_0_DBESL_DBESLD__DBESL__SHIFT                                                        0x0
#define BIF_CFG_DEV0_EPF5_0_DBESL_DBESLD__DBESLD__SHIFT                                                       0x4
#define BIF_CFG_DEV0_EPF5_0_DBESL_DBESLD__DBESL_MASK