/*
 *                            COPYRIGHT
 *
 *  pcb-rnd, interactive printed circuit board design
 *  Copyright (C) 2025 Tibor 'Igor2' Palinkas
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 31 Milk Street, # 960789 Boston, MA 02196 USA.
 *
 *  Contact:
 *    Project page: http://www.repo.hu/projects/librnd
 *    lead developer: http://www.repo.hu/projects/librnd/contact.html
 *    mailing list: pcb-rnd (at) list.repo.hu (send "subscribe")
 */

typedef struct {
	void *hid_ctx;
	mbtk_box_t hvbox;
	rnd_hid_dock_t where;
} docked_t;


static htsp_t pck_dock_pos[RND_HID_DOCK_max];

static void rnd_mbtk_dock_init(void)
{
	int n;
	for(n = 0; n < RND_HID_DOCK_max; n++)
		htsp_init(&pck_dock_pos[n], strhash, strkeyeq);
}

static void rnd_mbtk_dock_uninit(void)
{
	int n;
	for(n = 0; n < RND_HID_DOCK_max; n++) {
		htsp_entry_t *e;
		for(e = htsp_first(&pck_dock_pos[n]); e != NULL; e = htsp_next(&pck_dock_pos[n], e))
			free(e->key);
		htsp_uninit(&pck_dock_pos[n]);
	}
}

static int mbtk_dock_poke(rnd_hid_dad_subdialog_t *sub, const char *cmd, rnd_event_arg_t *res, int argc, rnd_event_arg_t *argv)
{
	TODO("copy this from gtk (lesstif doesn't have it)");
	return -1;
}


static int rnd_mbtk_dock_enter(rnd_hid_t *hid, rnd_hid_dad_subdialog_t *sub, rnd_hid_dock_t where, const char *id)
{
	rnd_mbtk_t *mctx = hid->hid_data;
	docked_t *docked;
	mbtk_widget_t *frame;
	mbtk_kw_t kw_rim;
	int expfill = 0;


	if (mctx->topwin->dockbox[where].w.type == 0)
		return -1;

	docked = calloc(sizeof(docked_t), 1);
	docked->where = where;

	if (RND_HATT_IS_COMPOSITE(sub->dlg[0].type))
		expfill = (sub->dlg[0].rnd_hatt_flags & RND_HATF_EXPFILL);

	frame = htsp_get(&pck_dock_pos[where], id);
	if (frame == NULL) {
		if (rnd_dock_has_frame[where])
			frame = (mbtk_widget_t *)mbtk_rim_new_with_label(id);
		else
			frame = (mbtk_widget_t *)mbtk_hbox_new(NULL);
		htsp_set(&pck_dock_pos[where], rnd_strdup(id), frame);
		if (expfill)
			mbtk_widget_set_span(frame, HVBOX_FILL);
		mbtk_box_add_widget(&mctx->topwin->dockbox[where], frame, 0);
	}

	mbtk_box_new(&docked->hvbox, !rnd_dock_is_vert[where]);
	if (expfill)
		mbtk_widget_set_span(&docked->hvbox.w, HVBOX_FILL);

	mbtk_kw_cache(kw_rim, "rim");
	if (frame->type == kw_rim)
		mbtk_rim_set_child((mbtk_rim_t *)frame, &docked->hvbox.w);
	else
		mbtk_box_add_widget((mbtk_box_t *)frame, &docked->hvbox.w, 0);

	sub->parent_poke = mbtk_dock_poke;
	sub->dlg_hid_ctx = docked->hid_ctx = rnd_mbtk_attr_sub_new(mctx, &docked->hvbox, sub->dlg, sub->dlg_len, sub);
	sub->parent_ctx = docked;

	gdl_append(&mctx->topwin->dock[where], sub, link);

	/* may have been hidden earlier in a dock_leave() */
	mbtk_widget_show(frame, 0);

	return 0;
}

static void rnd_mbtk_dock_leave(rnd_hid_t *hid, rnd_hid_dad_subdialog_t *sub)
{
	rnd_mbtk_t *mctx = hid->hid_data;
	docked_t *docked = sub->parent_ctx;
	mbtk_widget_t *frame = (mbtk_widget_t *)docked->hvbox.w.hvbox.parent;

	mbtk_widget_destroy(&docked->hvbox.w);

	gdl_remove(&mctx->topwin->dock[docked->where], sub, link);
	free(docked);
	RND_DAD_FREE(sub->dlg);

	mbtk_widget_hide(frame, 0);
}
