#!/bin/sh

# After changing or adding .pup files:
# run make map_plugins in src/, which runs this script.
# WARNING: this script requires a fair amount of tools - it is intended to
#          run on developers' machines, not on users'

export LANG=C
if test -z "$PUPLUG"
then
	echo "map_plugins.sh: PUPLUG is not set (fatal error)" >&2
	exit 1
fi

dirs="$@"

# generate scconfig's 3 state plugin list
for dir in $dirs
do
	$PUPLUG findpups "$dir" '%$class$|%N|%3|%A|%$short$|0%$hidlib$\n'
done | sed '
s/^lib/1|lib/
s/^feature/2|feature/
s/^fp/3|fp/
s/^import/4|import/
s/^export/5|export/
s/^io/6|io/
s/^hid/7|hid/
' | sort | awk -F "[|]" '
BEGIN {
	HDR["lib"] = "Library plugins"
	HDR["feature"] = "Feature plugins"
	HDR["fp"] = "Footprint backends"
	HDR["import"] = "Import plugins"
	HDR["export"] = "Export plugins"
	HDR["io"] = "IO plugins (file formats)"
	HDR["hid"] = "HID plugins"
	print "/******************************************************************************"
	print " Auto-generated by trunk/src_plugins/map_plugins.sh - do NOT edit,"
	print " run make map_plugins in trunk/src/ - to change any of the data below,"
	print " edit trunk/src_plugins/PLUGIN/PLUGIN.pup"
	print "******************************************************************************/"
}

function q(s) { return "\"" s "\"," }

($2 != last) {
	print "\nplugin_header(\"\\n" HDR[$2] ":\\n\")"
	last = $2
}

{
	if ($4 == "")
		print "Error: invalid default in plugin: " $3 > "/dev/stderr"
	printf("plugin_def(%-20s%-35s%-10s%s)\n", q($3), q($6), $4 "," , $5)
}

END { print "\n" }

' > ../scconfig/plugins.h

for dir in $dirs
do
	$PUPLUG findpups "$dir" "" 'plugin_dep("%N", "%m")\n'
done | sort >> ../scconfig/plugins.h


# Generate the plugin list
echo "# List of all plugins - generated by make map_plugins - do NOT edit" > plugins_ALL.tmpasm
for dir in $dirs
do
	$PUPLUG findpups "$dir" "include {$INCLUDE_PREFIX$dir/%D/Plug.tmpasm}\n"
done | sed "s^/./^/^g" | sort >> plugins_ALL.tmpasm
