Ice Water (SPC/E)
==============
This is an example of SPC/E water arranged in a hexagonal ice (1h) crystal.  The oxygen atoms in 1h ice are arranged in a diamond lattice.  However the orientation of the hydrogen atoms is an additional degree of freedom.  There are numerous ways to arrange the hydrogen bond directions (which are similar in energy) while preserving the crystal morphology.

Here I approximated 1h ice as periodic, and provided several different possible choices for the unit cell each (with different sizes and hydrogen bond arrangements).

1) [spce_ice_rect8.lt](moltemplate_files/spce_ice_rect8.lt) (containing 8 water molecules)
2) [spce_ice_rect16.lt](moltemplate_files/spce_ice_rect16.lt) (containing 16 water molecules)
3) [spce_ice_rect32.lt](moltemplate_files/spce_ice_rect32.lt) (containing 32 water molecules)

The size of the final crystal is a multiple of its unit cell size.  *(A procedure to create more realistic ice crystals with random hydrogen bond directions is outlined [below](#-More-realistic-configurations).)*


#### Images

Unit Cell (8 water molecules):

<img src="images/ice_rect8_unitcell.png" width=60>

Assembled crystal (3x2x2 unit cells):

<img src="images/ice_rect8_crystal_3x2x2_LR.jpg" width=150>

The number of water molecules in the simulation and and the simulation box size can be controlled by editing the [system.lt file](moltemplate_files/system.lt).  The simulation contitions can be controlled by editing the [run.in.npt file](run.in.npt).


### Details 

Here I am using the SPC/E water model with long range electrostatics.


### Instructions

More detailed instructions on how to build LAMMPS input files and
run a short simulation are provided in other README files.

1) To build the files which LAMMPS needs, follow the instructions in:
[README_setup.sh](README_setup.sh)

2) To run LAMMPS with these files, follow these instructions:
[README_run.sh](README_run.sh)

*(If you notice a problem with this example, please [report it](../README.md).)*


### More realistic configurations

The configuration generated by either of these files is periodic.  This should suffice for most applications.  If you need to generate more realistic ice configurations (with truly random arrangements of hydrogen-bond directions), then you will need to run your own physics simulation to generate such a configuration.  An efficient way to do that is to create the initial ice crystal using the approach described above.  Then heat the system up at constant volume *while keeping the positions of the oxygen atoms immobilized*.  Then gradually cool the system again.  *This strategy was not used here.*

(You can immobilize the oxygen atoms by using the LAMMPS "group" command to define a group containing all atoms *except* the oxygen atom types.  Then use this group of atoms with the "fix nvt" command.)
