/* $Id: Suspect_rule_set.hpp 659771 2022-12-05 12:50:08Z gotvyans $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @file Suspect_rule_set.hpp
/// User-defined methods of the data storage class.
///
/// This file was originally generated by application DATATOOL
/// using the following specifications:
/// 'macro.asn'.
///
/// New methods or data members can be added to it if needed.
/// See also: Suspect_rule_set_.hpp


#ifndef OBJECTS_MACRO_SUSPECT_RULE_SET_HPP
#define OBJECTS_MACRO_SUSPECT_RULE_SET_HPP


// generated includes
#include <objects/macro/Suspect_rule_set_.hpp>

// generated classes

BEGIN_NCBI_SCOPE

class CMultipatternSearch;

namespace FSM
{
    class CCompiledFSM;
}

BEGIN_objects_SCOPE // namespace ncbi::objects::



/////////////////////////////////////////////////////////////////////////////
class CSuspect_rule_set : public CSuspect_rule_set_Base
{
    typedef CSuspect_rule_set_Base Tparent;
public:
    // constructor
    CSuspect_rule_set(void);
    // Prohibit copy constructor and assignment operator
    CSuspect_rule_set(const CSuspect_rule_set&) = delete;
    // destructor
    ~CSuspect_rule_set(void);

    void SetPrecompiledData(const FSM::CCompiledFSM* fsm)
    {
        m_Precompiled_FSM = fsm;
    }

    void Screen(const char* input, char* output) const;
    void Screen(const string& input, char* output) const { Screen(input.c_str(), output); }

private:
    mutable unique_ptr<CMultipatternSearch> m_FSM;
    const FSM::CCompiledFSM* m_Precompiled_FSM = nullptr;
};

END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_MACRO_SUSPECT_RULE_SET_HPP
/* Original file checksum: lines: 86, chars: 2519, CRC32: e82b213 */
