/* $Id: Cit_jour.cpp 272611 2011-04-08 18:57:08Z ucko $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using specifications from the ASN data definition file
 *   'biblio.asn'.
 */

// standard includes

// generated includes
#include <ncbi_pch.hpp>
#include <objects/biblio/Cit_jour.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

// destructor
CCit_jour::~CCit_jour(void)
{
}


bool CCit_jour::GetLabelV1(string* label, TLabelFlags) const
{
    return x_GetLabelV1(label, false, 0, &GetImp(), &GetTitle(), 0, this);
}


// Based on FormatCitJour from the C Toolkit's api/asn2gnb5.c.
bool CCit_jour::GetLabelV2(string* label, TLabelFlags flags) const
{
    const CImprint& imp = GetImp();

    int prepub = imp.CanGetPrepub()    ? imp.GetPrepub()    : 0;
    int status = imp.CanGetPubstatus() ? imp.GetPubstatus() : 0;

    bool is_electronic = (status == ePubStatus_epublish
                          ||  status == ePubStatus_aheadofprint);

    const string* jtitle;
    try {
        jtitle = &GetTitle().GetTitle(CTitle::C_E::e_Iso_jta);
    } catch (CException&) {
        try {
            jtitle = &GetTitle().GetTitle();
            if (NStr::StartsWith(*jtitle, "(er)")) {
                is_electronic = true;
            }
            if ((flags & fLabel_ISO_JTA) != 0  &&  !is_electronic) {
                return false;
            }
        } catch (CException&) {
            jtitle = NULL;
        }
    }

    string year = GetParenthesizedYear(imp.GetDate());

    MaybeAddSpace(label);

    if (prepub == CImprint::ePrepub_submitted
        ||  prepub == CImprint::ePrepub_other) {
        *label += "Unpublished " + year;
        return true;
    }

    if (jtitle == NULL  ||  jtitle->size() < 3) {
        *label += '.';
        return false;
    }

    *label += *jtitle;

    const string* volume = imp.CanGetVolume() ? &imp.GetVolume() : NULL;
    string        pages  = imp.CanGetPages()  ? imp.GetPages()   : kEmptyStr;
    if ( !pages.empty()  &&  !is_electronic ) {
        pages = FixPages(pages);
    }

    if (HasText(volume)) {
        MaybeAddSpace(label);
        *label += *volume;
    }

    if ((flags & fLabel_FlatNCBI) != 0
        &&  (HasText(volume)  ||  HasText(pages))) {
        NoteSup(label, imp);
    }

    if ((flags & fLabel_FlatNCBI) != 0) {
        if (HasText(pages)) {
            *label += ", " + pages;
        }
    } else if ((flags & fLabel_FlatEMBL) != 0) {
        if (HasText(pages)) {
            *label += ':' + pages;
        } else if (prepub == CImprint::ePrepub_in_press  ||  !HasText(volume)) {
            MaybeAddSpace(label);
            *label += "0:0-0";
        }
    }

    *label += ' ' + year;
    
    if ((flags & fLabel_FlatNCBI) != 0) {
        if (prepub == CImprint::ePrepub_in_press
            ||  (status == ePubStatus_aheadofprint  &&  !HasText(pages))) {
            MaybeAddSpace(label);
            *label += "In press";
        }
    }

    return true;
}


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

/* Original file checksum: lines: 61, chars: 1883, CRC32: 93da792e */
