/*---------------------------------------------------------*\
| QMKKeycodes.h                                             |
|                                                           |
|   List of QMK keycode values                              |
|                                                           |
|   Adam Honse <calcprogrammer1@gmail.com)      06 Oct 2025 |
|                                                           |
|   This file is part of the OpenRGB project                |
|   SPDX-License-Identifier: GPL-2.0-or-later               |
\*---------------------------------------------------------*/

#pragma once

#include <map>
#include <string>

typedef unsigned short qmk_keycode;
enum
{
    QMK_KC_NO                                           = 0x0000,
    QMK_KC_TRANSPARENT                                  = 0x0001,
    QMK_KC_A                                            = 0x0004,
    QMK_KC_B                                            = 0x0005,
    QMK_KC_C                                            = 0x0006,
    QMK_KC_D                                            = 0x0007,
    QMK_KC_E                                            = 0x0008,
    QMK_KC_F                                            = 0x0009,
    QMK_KC_G                                            = 0x000A,
    QMK_KC_H                                            = 0x000B,
    QMK_KC_I                                            = 0x000C,
    QMK_KC_J                                            = 0x000D,
    QMK_KC_K                                            = 0x000E,
    QMK_KC_L                                            = 0x000F,
    QMK_KC_M                                            = 0x0010,
    QMK_KC_N                                            = 0x0011,
    QMK_KC_O                                            = 0x0012,
    QMK_KC_P                                            = 0x0013,
    QMK_KC_Q                                            = 0x0014,
    QMK_KC_R                                            = 0x0015,
    QMK_KC_S                                            = 0x0016,
    QMK_KC_T                                            = 0x0017,
    QMK_KC_U                                            = 0x0018,
    QMK_KC_V                                            = 0x0019,
    QMK_KC_W                                            = 0x001A,
    QMK_KC_X                                            = 0x001B,
    QMK_KC_Y                                            = 0x001C,
    QMK_KC_Z                                            = 0x001D,
    QMK_KC_1                                            = 0x001E,
    QMK_KC_2                                            = 0x001F,
    QMK_KC_3                                            = 0x0020,
    QMK_KC_4                                            = 0x0021,
    QMK_KC_5                                            = 0x0022,
    QMK_KC_6                                            = 0x0023,
    QMK_KC_7                                            = 0x0024,
    QMK_KC_8                                            = 0x0025,
    QMK_KC_9                                            = 0x0026,
    QMK_KC_0                                            = 0x0027,
    QMK_KC_ENTER                                        = 0x0028,
    QMK_KC_ESCAPE                                       = 0x0029,
    QMK_KC_BACKSPACE                                    = 0x002A,
    QMK_KC_TAB                                          = 0x002B,
    QMK_KC_SPACE                                        = 0x002C,
    QMK_KC_MINUS                                        = 0x002D,
    QMK_KC_EQUAL                                        = 0x002E,
    QMK_KC_LEFT_BRACKET                                 = 0x002F,
    QMK_KC_RIGHT_BRACKET                                = 0x0030,
    QMK_KC_BACKSLASH                                    = 0x0031,
    QMK_KC_NONUS_HASH                                   = 0x0032,
    QMK_KC_SEMICOLON                                    = 0x0033,
    QMK_KC_QUOTE                                        = 0x0034,
    QMK_KC_GRAVE                                        = 0x0035,
    QMK_KC_COMMA                                        = 0x0036,
    QMK_KC_DOT                                          = 0x0037,
    QMK_KC_SLASH                                        = 0x0038,
    QMK_KC_CAPS_LOCK                                    = 0x0039,
    QMK_KC_F1                                           = 0x003A,
    QMK_KC_F2                                           = 0x003B,
    QMK_KC_F3                                           = 0x003C,
    QMK_KC_F4                                           = 0x003D,
    QMK_KC_F5                                           = 0x003E,
    QMK_KC_F6                                           = 0x003F,
    QMK_KC_F7                                           = 0x0040,
    QMK_KC_F8                                           = 0x0041,
    QMK_KC_F9                                           = 0x0042,
    QMK_KC_F10                                          = 0x0043,
    QMK_KC_F11                                          = 0x0044,
    QMK_KC_F12                                          = 0x0045,
    QMK_KC_PRINT_SCREEN                                 = 0x0046,
    QMK_KC_SCROLL_LOCK                                  = 0x0047,
    QMK_KC_PAUSE                                        = 0x0048,
    QMK_KC_INSERT                                       = 0x0049,
    QMK_KC_HOME                                         = 0x004A,
    QMK_KC_PAGE_UP                                      = 0x004B,
    QMK_KC_DELETE                                       = 0x004C,
    QMK_KC_END                                          = 0x004D,
    QMK_KC_PAGE_DOWN                                    = 0x004E,
    QMK_KC_RIGHT                                        = 0x004F,
    QMK_KC_LEFT                                         = 0x0050,
    QMK_KC_DOWN                                         = 0x0051,
    QMK_KC_UP                                           = 0x0052,
    QMK_KC_NUM_LOCK                                     = 0x0053,
    QMK_KC_KP_SLASH                                     = 0x0054,
    QMK_KC_KP_ASTERISK                                  = 0x0055,
    QMK_KC_KP_MINUS                                     = 0x0056,
    QMK_KC_KP_PLUS                                      = 0x0057,
    QMK_KC_KP_ENTER                                     = 0x0058,
    QMK_KC_KP_1                                         = 0x0059,
    QMK_KC_KP_2                                         = 0x005A,
    QMK_KC_KP_3                                         = 0x005B,
    QMK_KC_KP_4                                         = 0x005C,
    QMK_KC_KP_5                                         = 0x005D,
    QMK_KC_KP_6                                         = 0x005E,
    QMK_KC_KP_7                                         = 0x005F,
    QMK_KC_KP_8                                         = 0x0060,
    QMK_KC_KP_9                                         = 0x0061,
    QMK_KC_KP_0                                         = 0x0062,
    QMK_KC_KP_DOT                                       = 0x0063,
    QMK_KC_NONUS_BACKSLASH                              = 0x0064,
    QMK_KC_APPLICATION                                  = 0x0065,
    QMK_KC_KB_POWER                                     = 0x0066,
    QMK_KC_KP_EQUAL                                     = 0x0067,
    QMK_KC_F13                                          = 0x0068,
    QMK_KC_F14                                          = 0x0069,
    QMK_KC_F15                                          = 0x006A,
    QMK_KC_F16                                          = 0x006B,
    QMK_KC_F17                                          = 0x006C,
    QMK_KC_F18                                          = 0x006D,
    QMK_KC_F19                                          = 0x006E,
    QMK_KC_F20                                          = 0x006F,
    QMK_KC_F21                                          = 0x0070,
    QMK_KC_F22                                          = 0x0071,
    QMK_KC_F23                                          = 0x0072,
    QMK_KC_F24                                          = 0x0073,
    QMK_KC_EXECUTE                                      = 0x0074,
    QMK_KC_HELP                                         = 0x0075,
    QMK_KC_MENU                                         = 0x0076,
    QMK_KC_SELECT                                       = 0x0077,
    QMK_KC_STOP                                         = 0x0078,
    QMK_KC_AGAIN                                        = 0x0079,
    QMK_KC_UNDO                                         = 0x007A,
    QMK_KC_CUT                                          = 0x007B,
    QMK_KC_COPY                                         = 0x007C,
    QMK_KC_PASTE                                        = 0x007D,
    QMK_KC_FIND                                         = 0x007E,
    QMK_KC_KB_MUTE                                      = 0x007F,
    QMK_KC_KB_VOLUME_UP                                 = 0x0080,
    QMK_KC_KB_VOLUME_DOWN                               = 0x0081,
    QMK_KC_LOCKING_CAPS_LOCK                            = 0x0082,
    QMK_KC_LOCKING_NUM_LOCK                             = 0x0083,
    QMK_KC_LOCKING_SCROLL_LOCK                          = 0x0084,
    QMK_KC_KP_COMMA                                     = 0x0085,
    QMK_KC_KP_EQUAL_AS400                               = 0x0086,
    QMK_KC_INTERNATIONAL_1                              = 0x0087,
    QMK_KC_INTERNATIONAL_2                              = 0x0088,
    QMK_KC_INTERNATIONAL_3                              = 0x0089,
    QMK_KC_INTERNATIONAL_4                              = 0x008A,
    QMK_KC_INTERNATIONAL_5                              = 0x008B,
    QMK_KC_INTERNATIONAL_6                              = 0x008C,
    QMK_KC_INTERNATIONAL_7                              = 0x008D,
    QMK_KC_INTERNATIONAL_8                              = 0x008E,
    QMK_KC_INTERNATIONAL_9                              = 0x008F,
    QMK_KC_LANGUAGE_1                                   = 0x0090,
    QMK_KC_LANGUAGE_2                                   = 0x0091,
    QMK_KC_LANGUAGE_3                                   = 0x0092,
    QMK_KC_LANGUAGE_4                                   = 0x0093,
    QMK_KC_LANGUAGE_5                                   = 0x0094,
    QMK_KC_LANGUAGE_6                                   = 0x0095,
    QMK_KC_LANGUAGE_7                                   = 0x0096,
    QMK_KC_LANGUAGE_8                                   = 0x0097,
    QMK_KC_LANGUAGE_9                                   = 0x0098,
    QMK_KC_ALTERNATE_ERASE                              = 0x0099,
    QMK_KC_SYSTEM_REQUEST                               = 0x009A,
    QMK_KC_CANCEL                                       = 0x009B,
    QMK_KC_CLEAR                                        = 0x009C,
    QMK_KC_PRIOR                                        = 0x009D,
    QMK_KC_RETURN                                       = 0x009E,
    QMK_KC_SEPARATOR                                    = 0x009F,
    QMK_KC_OUT                                          = 0x00A0,
    QMK_KC_OPER                                         = 0x00A1,
    QMK_KC_CLEAR_AGAIN                                  = 0x00A2,
    QMK_KC_CRSEL                                        = 0x00A3,
    QMK_KC_EXSEL                                        = 0x00A4,
    QMK_KC_SYSTEM_POWER                                 = 0x00A5,
    QMK_KC_SYSTEM_SLEEP                                 = 0x00A6,
    QMK_KC_SYSTEM_WAKE                                  = 0x00A7,
    QMK_KC_AUDIO_MUTE                                   = 0x00A8,
    QMK_KC_AUDIO_VOL_UP                                 = 0x00A9,
    QMK_KC_AUDIO_VOL_DOWN                               = 0x00AA,
    QMK_KC_MEDIA_NEXT_TRACK                             = 0x00AB,
    QMK_KC_MEDIA_PREV_TRACK                             = 0x00AC,
    QMK_KC_MEDIA_STOP                                   = 0x00AD,
    QMK_KC_MEDIA_PLAY_PAUSE                             = 0x00AE,
    QMK_KC_MEDIA_SELECT                                 = 0x00AF,
    QMK_KC_MEDIA_EJECT                                  = 0x00B0,
    QMK_KC_MAIL                                         = 0x00B1,
    QMK_KC_CALCULATOR                                   = 0x00B2,
    QMK_KC_MY_COMPUTER                                  = 0x00B3,
    QMK_KC_WWW_SEARCH                                   = 0x00B4,
    QMK_KC_WWW_HOME                                     = 0x00B5,
    QMK_KC_WWW_BACK                                     = 0x00B6,
    QMK_KC_WWW_FORWARD                                  = 0x00B7,
    QMK_KC_WWW_STOP                                     = 0x00B8,
    QMK_KC_WWW_REFRESH                                  = 0x00B9,
    QMK_KC_WWW_FAVORITES                                = 0x00BA,
    QMK_KC_MEDIA_FAST_FORWARD                           = 0x00BB,
    QMK_KC_MEDIA_REWIND                                 = 0x00BC,
    QMK_KC_BRIGHTNESS_UP                                = 0x00BD,
    QMK_KC_BRIGHTNESS_DOWN                              = 0x00BE,
    QMK_KC_CONTROL_PANEL                                = 0x00BF,
    QMK_KC_ASSISTANT                                    = 0x00C0,
    QMK_KC_MISSION_CONTROL                              = 0x00C1,
    QMK_KC_LAUNCHPAD                                    = 0x00C2,
    QMK_QK_MOUSE_CURSOR_UP                              = 0x00CD,
    QMK_QK_MOUSE_CURSOR_DOWN                            = 0x00CE,
    QMK_QK_MOUSE_CURSOR_LEFT                            = 0x00CF,
    QMK_QK_MOUSE_CURSOR_RIGHT                           = 0x00D0,
    QMK_QK_MOUSE_BUTTON_1                               = 0x00D1,
    QMK_QK_MOUSE_BUTTON_2                               = 0x00D2,
    QMK_QK_MOUSE_BUTTON_3                               = 0x00D3,
    QMK_QK_MOUSE_BUTTON_4                               = 0x00D4,
    QMK_QK_MOUSE_BUTTON_5                               = 0x00D5,
    QMK_QK_MOUSE_BUTTON_6                               = 0x00D6,
    QMK_QK_MOUSE_BUTTON_7                               = 0x00D7,
    QMK_QK_MOUSE_BUTTON_8                               = 0x00D8,
    QMK_QK_MOUSE_WHEEL_UP                               = 0x00D9,
    QMK_QK_MOUSE_WHEEL_DOWN                             = 0x00DA,
    QMK_QK_MOUSE_WHEEL_LEFT                             = 0x00DB,
    QMK_QK_MOUSE_WHEEL_RIGHT                            = 0x00DC,
    QMK_QK_MOUSE_ACCELERATION_0                         = 0x00DD,
    QMK_QK_MOUSE_ACCELERATION_1                         = 0x00DE,
    QMK_QK_MOUSE_ACCELERATION_2                         = 0x00DF,
    QMK_KC_LEFT_CTRL                                    = 0x00E0,
    QMK_KC_LEFT_SHIFT                                   = 0x00E1,
    QMK_KC_LEFT_ALT                                     = 0x00E2,
    QMK_KC_LEFT_GUI                                     = 0x00E3,
    QMK_KC_RIGHT_CTRL                                   = 0x00E4,
    QMK_KC_RIGHT_SHIFT                                  = 0x00E5,
    QMK_KC_RIGHT_ALT                                    = 0x00E6,
    QMK_KC_RIGHT_GUI                                    = 0x00E7,
    QMK_QK_SWAP_HANDS_TOGGLE                            = 0x56F0,
    QMK_QK_SWAP_HANDS_TAP_TOGGLE                        = 0x56F1,
    QMK_QK_SWAP_HANDS_MOMENTARY_ON                      = 0x56F2,
    QMK_QK_SWAP_HANDS_MOMENTARY_OFF                     = 0x56F3,
    QMK_QK_SWAP_HANDS_OFF                               = 0x56F4,
    QMK_QK_SWAP_HANDS_ON                                = 0x56F5,
    QMK_QK_SWAP_HANDS_ONE_SHOT                          = 0x56F6,
    QMK_QK_MAGIC_SWAP_CONTROL_CAPS_LOCK                 = 0x7000,
    QMK_QK_MAGIC_UNSWAP_CONTROL_CAPS_LOCK               = 0x7001,
    QMK_QK_MAGIC_TOGGLE_CONTROL_CAPS_LOCK               = 0x7002,
    QMK_QK_MAGIC_CAPS_LOCK_AS_CONTROL_OFF               = 0x7003,
    QMK_QK_MAGIC_CAPS_LOCK_AS_CONTROL_ON                = 0x7004,
    QMK_QK_MAGIC_SWAP_LALT_LGUI                         = 0x7005,
    QMK_QK_MAGIC_UNSWAP_LALT_LGUI                       = 0x7006,
    QMK_QK_MAGIC_SWAP_RALT_RGUI                         = 0x7007,
    QMK_QK_MAGIC_UNSWAP_RALT_RGUI                       = 0x7008,
    QMK_QK_MAGIC_GUI_ON                                 = 0x7009,
    QMK_QK_MAGIC_GUI_OFF                                = 0x700A,
    QMK_QK_MAGIC_TOGGLE_GUI                             = 0x700B,
    QMK_QK_MAGIC_SWAP_GRAVE_ESC                         = 0x700C,
    QMK_QK_MAGIC_UNSWAP_GRAVE_ESC                       = 0x700D,
    QMK_QK_MAGIC_SWAP_BACKSLASH_BACKSPACE               = 0x700E,
    QMK_QK_MAGIC_UNSWAP_BACKSLASH_BACKSPACE             = 0x700F,
    QMK_QK_MAGIC_TOGGLE_BACKSLASH_BACKSPACE             = 0x7010,
    QMK_QK_MAGIC_NKRO_ON                                = 0x7011,
    QMK_QK_MAGIC_NKRO_OFF                               = 0x7012,
    QMK_QK_MAGIC_TOGGLE_NKRO                            = 0x7013,
    QMK_QK_MAGIC_SWAP_ALT_GUI                           = 0x7014,
    QMK_QK_MAGIC_UNSWAP_ALT_GUI                         = 0x7015,
    QMK_QK_MAGIC_TOGGLE_ALT_GUI                         = 0x7016,
    QMK_QK_MAGIC_SWAP_LCTL_LGUI                         = 0x7017,
    QMK_QK_MAGIC_UNSWAP_LCTL_LGUI                       = 0x7018,
    QMK_QK_MAGIC_SWAP_RCTL_RGUI                         = 0x7019,
    QMK_QK_MAGIC_UNSWAP_RCTL_RGUI                       = 0x701A,
    QMK_QK_MAGIC_SWAP_CTL_GUI                           = 0x701B,
    QMK_QK_MAGIC_UNSWAP_CTL_GUI                         = 0x701C,
    QMK_QK_MAGIC_TOGGLE_CTL_GUI                         = 0x701D,
    QMK_QK_MAGIC_EE_HANDS_LEFT                          = 0x701E,
    QMK_QK_MAGIC_EE_HANDS_RIGHT                         = 0x701F,
    QMK_QK_MAGIC_SWAP_ESCAPE_CAPS_LOCK                  = 0x7020,
    QMK_QK_MAGIC_UNSWAP_ESCAPE_CAPS_LOCK                = 0x7021,
    QMK_QK_MAGIC_TOGGLE_ESCAPE_CAPS_LOCK                = 0x7022,
    QMK_QK_MIDI_ON                                      = 0x7100,
    QMK_QK_MIDI_OFF                                     = 0x7101,
    QMK_QK_MIDI_TOGGLE                                  = 0x7102,
    QMK_QK_MIDI_NOTE_C_0                                = 0x7103,
    QMK_QK_MIDI_NOTE_C_SHARP_0                          = 0x7104,
    QMK_QK_MIDI_NOTE_D_0                                = 0x7105,
    QMK_QK_MIDI_NOTE_D_SHARP_0                          = 0x7106,
    QMK_QK_MIDI_NOTE_E_0                                = 0x7107,
    QMK_QK_MIDI_NOTE_F_0                                = 0x7108,
    QMK_QK_MIDI_NOTE_F_SHARP_0                          = 0x7109,
    QMK_QK_MIDI_NOTE_G_0                                = 0x710A,
    QMK_QK_MIDI_NOTE_G_SHARP_0                          = 0x710B,
    QMK_QK_MIDI_NOTE_A_0                                = 0x710C,
    QMK_QK_MIDI_NOTE_A_SHARP_0                          = 0x710D,
    QMK_QK_MIDI_NOTE_B_0                                = 0x710E,
    QMK_QK_MIDI_NOTE_C_1                                = 0x710F,
    QMK_QK_MIDI_NOTE_C_SHARP_1                          = 0x7110,
    QMK_QK_MIDI_NOTE_D_1                                = 0x7111,
    QMK_QK_MIDI_NOTE_D_SHARP_1                          = 0x7112,
    QMK_QK_MIDI_NOTE_E_1                                = 0x7113,
    QMK_QK_MIDI_NOTE_F_1                                = 0x7114,
    QMK_QK_MIDI_NOTE_F_SHARP_1                          = 0x7115,
    QMK_QK_MIDI_NOTE_G_1                                = 0x7116,
    QMK_QK_MIDI_NOTE_G_SHARP_1                          = 0x7117,
    QMK_QK_MIDI_NOTE_A_1                                = 0x7118,
    QMK_QK_MIDI_NOTE_A_SHARP_1                          = 0x7119,
    QMK_QK_MIDI_NOTE_B_1                                = 0x711A,
    QMK_QK_MIDI_NOTE_C_2                                = 0x711B,
    QMK_QK_MIDI_NOTE_C_SHARP_2                          = 0x711C,
    QMK_QK_MIDI_NOTE_D_2                                = 0x711D,
    QMK_QK_MIDI_NOTE_D_SHARP_2                          = 0x711E,
    QMK_QK_MIDI_NOTE_E_2                                = 0x711F,
    QMK_QK_MIDI_NOTE_F_2                                = 0x7120,
    QMK_QK_MIDI_NOTE_F_SHARP_2                          = 0x7121,
    QMK_QK_MIDI_NOTE_G_2                                = 0x7122,
    QMK_QK_MIDI_NOTE_G_SHARP_2                          = 0x7123,
    QMK_QK_MIDI_NOTE_A_2                                = 0x7124,
    QMK_QK_MIDI_NOTE_A_SHARP_2                          = 0x7125,
    QMK_QK_MIDI_NOTE_B_2                                = 0x7126,
    QMK_QK_MIDI_NOTE_C_3                                = 0x7127,
    QMK_QK_MIDI_NOTE_C_SHARP_3                          = 0x7128,
    QMK_QK_MIDI_NOTE_D_3                                = 0x7129,
    QMK_QK_MIDI_NOTE_D_SHARP_3                          = 0x712A,
    QMK_QK_MIDI_NOTE_E_3                                = 0x712B,
    QMK_QK_MIDI_NOTE_F_3                                = 0x712C,
    QMK_QK_MIDI_NOTE_F_SHARP_3                          = 0x712D,
    QMK_QK_MIDI_NOTE_G_3                                = 0x712E,
    QMK_QK_MIDI_NOTE_G_SHARP_3                          = 0x712F,
    QMK_QK_MIDI_NOTE_A_3                                = 0x7130,
    QMK_QK_MIDI_NOTE_A_SHARP_3                          = 0x7131,
    QMK_QK_MIDI_NOTE_B_3                                = 0x7132,
    QMK_QK_MIDI_NOTE_C_4                                = 0x7133,
    QMK_QK_MIDI_NOTE_C_SHARP_4                          = 0x7134,
    QMK_QK_MIDI_NOTE_D_4                                = 0x7135,
    QMK_QK_MIDI_NOTE_D_SHARP_4                          = 0x7136,
    QMK_QK_MIDI_NOTE_E_4                                = 0x7137,
    QMK_QK_MIDI_NOTE_F_4                                = 0x7138,
    QMK_QK_MIDI_NOTE_F_SHARP_4                          = 0x7139,
    QMK_QK_MIDI_NOTE_G_4                                = 0x713A,
    QMK_QK_MIDI_NOTE_G_SHARP_4                          = 0x713B,
    QMK_QK_MIDI_NOTE_A_4                                = 0x713C,
    QMK_QK_MIDI_NOTE_A_SHARP_4                          = 0x713D,
    QMK_QK_MIDI_NOTE_B_4                                = 0x713E,
    QMK_QK_MIDI_NOTE_C_5                                = 0x713F,
    QMK_QK_MIDI_NOTE_C_SHARP_5                          = 0x7140,
    QMK_QK_MIDI_NOTE_D_5                                = 0x7141,
    QMK_QK_MIDI_NOTE_D_SHARP_5                          = 0x7142,
    QMK_QK_MIDI_NOTE_E_5                                = 0x7143,
    QMK_QK_MIDI_NOTE_F_5                                = 0x7144,
    QMK_QK_MIDI_NOTE_F_SHARP_5                          = 0x7145,
    QMK_QK_MIDI_NOTE_G_5                                = 0x7146,
    QMK_QK_MIDI_NOTE_G_SHARP_5                          = 0x7147,
    QMK_QK_MIDI_NOTE_A_5                                = 0x7148,
    QMK_QK_MIDI_NOTE_A_SHARP_5                          = 0x7149,
    QMK_QK_MIDI_NOTE_B_5                                = 0x714A,
    QMK_QK_MIDI_OCTAVE_N2                               = 0x714B,
    QMK_QK_MIDI_OCTAVE_N1                               = 0x714C,
    QMK_QK_MIDI_OCTAVE_0                                = 0x714D,
    QMK_QK_MIDI_OCTAVE_1                                = 0x714E,
    QMK_QK_MIDI_OCTAVE_2                                = 0x714F,
    QMK_QK_MIDI_OCTAVE_3                                = 0x7150,
    QMK_QK_MIDI_OCTAVE_4                                = 0x7151,
    QMK_QK_MIDI_OCTAVE_5                                = 0x7152,
    QMK_QK_MIDI_OCTAVE_6                                = 0x7153,
    QMK_QK_MIDI_OCTAVE_7                                = 0x7154,
    QMK_QK_MIDI_OCTAVE_DOWN                             = 0x7155,
    QMK_QK_MIDI_OCTAVE_UP                               = 0x7156,
    QMK_QK_MIDI_TRANSPOSE_N6                            = 0x7157,
    QMK_QK_MIDI_TRANSPOSE_N5                            = 0x7158,
    QMK_QK_MIDI_TRANSPOSE_N4                            = 0x7159,
    QMK_QK_MIDI_TRANSPOSE_N3                            = 0x715A,
    QMK_QK_MIDI_TRANSPOSE_N2                            = 0x715B,
    QMK_QK_MIDI_TRANSPOSE_N1                            = 0x715C,
    QMK_QK_MIDI_TRANSPOSE_0                             = 0x715D,
    QMK_QK_MIDI_TRANSPOSE_1                             = 0x715E,
    QMK_QK_MIDI_TRANSPOSE_2                             = 0x715F,
    QMK_QK_MIDI_TRANSPOSE_3                             = 0x7160,
    QMK_QK_MIDI_TRANSPOSE_4                             = 0x7161,
    QMK_QK_MIDI_TRANSPOSE_5                             = 0x7162,
    QMK_QK_MIDI_TRANSPOSE_6                             = 0x7163,
    QMK_QK_MIDI_TRANSPOSE_DOWN                          = 0x7164,
    QMK_QK_MIDI_TRANSPOSE_UP                            = 0x7165,
    QMK_QK_MIDI_VELOCITY_0                              = 0x7166,
    QMK_QK_MIDI_VELOCITY_1                              = 0x7167,
    QMK_QK_MIDI_VELOCITY_2                              = 0x7168,
    QMK_QK_MIDI_VELOCITY_3                              = 0x7169,
    QMK_QK_MIDI_VELOCITY_4                              = 0x716A,
    QMK_QK_MIDI_VELOCITY_5                              = 0x716B,
    QMK_QK_MIDI_VELOCITY_6                              = 0x716C,
    QMK_QK_MIDI_VELOCITY_7                              = 0x716D,
    QMK_QK_MIDI_VELOCITY_8                              = 0x716E,
    QMK_QK_MIDI_VELOCITY_9                              = 0x716F,
    QMK_QK_MIDI_VELOCITY_10                             = 0x7170,
    QMK_QK_MIDI_VELOCITY_DOWN                           = 0x7171,
    QMK_QK_MIDI_VELOCITY_UP                             = 0x7172,
    QMK_QK_MIDI_CHANNEL_1                               = 0x7173,
    QMK_QK_MIDI_CHANNEL_2                               = 0x7174,
    QMK_QK_MIDI_CHANNEL_3                               = 0x7175,
    QMK_QK_MIDI_CHANNEL_4                               = 0x7176,
    QMK_QK_MIDI_CHANNEL_5                               = 0x7177,
    QMK_QK_MIDI_CHANNEL_6                               = 0x7178,
    QMK_QK_MIDI_CHANNEL_7                               = 0x7179,
    QMK_QK_MIDI_CHANNEL_8                               = 0x717A,
    QMK_QK_MIDI_CHANNEL_9                               = 0x717B,
    QMK_QK_MIDI_CHANNEL_10                              = 0x717C,
    QMK_QK_MIDI_CHANNEL_11                              = 0x717D,
    QMK_QK_MIDI_CHANNEL_12                              = 0x717E,
    QMK_QK_MIDI_CHANNEL_13                              = 0x717F,
    QMK_QK_MIDI_CHANNEL_14                              = 0x7180,
    QMK_QK_MIDI_CHANNEL_15                              = 0x7181,
    QMK_QK_MIDI_CHANNEL_16                              = 0x7182,
    QMK_QK_MIDI_CHANNEL_DOWN                            = 0x7183,
    QMK_QK_MIDI_CHANNEL_UP                              = 0x7184,
    QMK_QK_MIDI_ALL_NOTES_OFF                           = 0x7185,
    QMK_QK_MIDI_SUSTAIN                                 = 0x7186,
    QMK_QK_MIDI_PORTAMENTO                              = 0x7187,
    QMK_QK_MIDI_SOSTENUTO                               = 0x7188,
    QMK_QK_MIDI_SOFT                                    = 0x7189,
    QMK_QK_MIDI_LEGATO                                  = 0x718A,
    QMK_QK_MIDI_MODULATION                              = 0x718B,
    QMK_QK_MIDI_MODULATION_SPEED_DOWN                   = 0x718C,
    QMK_QK_MIDI_MODULATION_SPEED_UP                     = 0x718D,
    QMK_QK_MIDI_PITCH_BEND_DOWN                         = 0x718E,
    QMK_QK_MIDI_PITCH_BEND_UP                           = 0x718F,
    QMK_QK_SEQUENCER_ON                                 = 0x7200,
    QMK_QK_SEQUENCER_OFF                                = 0x7201,
    QMK_QK_SEQUENCER_TOGGLE                             = 0x7202,
    QMK_QK_SEQUENCER_TEMPO_DOWN                         = 0x7203,
    QMK_QK_SEQUENCER_TEMPO_UP                           = 0x7204,
    QMK_QK_SEQUENCER_RESOLUTION_DOWN                    = 0x7205,
    QMK_QK_SEQUENCER_RESOLUTION_UP                      = 0x7206,
    QMK_QK_SEQUENCER_STEPS_ALL                          = 0x7207,
    QMK_QK_SEQUENCER_STEPS_CLEAR                        = 0x7208,
    QMK_QK_JOYSTICK_BUTTON_0                            = 0x7400,
    QMK_QK_JOYSTICK_BUTTON_1                            = 0x7401,
    QMK_QK_JOYSTICK_BUTTON_2                            = 0x7402,
    QMK_QK_JOYSTICK_BUTTON_3                            = 0x7403,
    QMK_QK_JOYSTICK_BUTTON_4                            = 0x7404,
    QMK_QK_JOYSTICK_BUTTON_5                            = 0x7405,
    QMK_QK_JOYSTICK_BUTTON_6                            = 0x7406,
    QMK_QK_JOYSTICK_BUTTON_7                            = 0x7407,
    QMK_QK_JOYSTICK_BUTTON_8                            = 0x7408,
    QMK_QK_JOYSTICK_BUTTON_9                            = 0x7409,
    QMK_QK_JOYSTICK_BUTTON_10                           = 0x740A,
    QMK_QK_JOYSTICK_BUTTON_11                           = 0x740B,
    QMK_QK_JOYSTICK_BUTTON_12                           = 0x740C,
    QMK_QK_JOYSTICK_BUTTON_13                           = 0x740D,
    QMK_QK_JOYSTICK_BUTTON_14                           = 0x740E,
    QMK_QK_JOYSTICK_BUTTON_15                           = 0x740F,
    QMK_QK_JOYSTICK_BUTTON_16                           = 0x7410,
    QMK_QK_JOYSTICK_BUTTON_17                           = 0x7411,
    QMK_QK_JOYSTICK_BUTTON_18                           = 0x7412,
    QMK_QK_JOYSTICK_BUTTON_19                           = 0x7413,
    QMK_QK_JOYSTICK_BUTTON_20                           = 0x7414,
    QMK_QK_JOYSTICK_BUTTON_21                           = 0x7415,
    QMK_QK_JOYSTICK_BUTTON_22                           = 0x7416,
    QMK_QK_JOYSTICK_BUTTON_23                           = 0x7417,
    QMK_QK_JOYSTICK_BUTTON_24                           = 0x7418,
    QMK_QK_JOYSTICK_BUTTON_25                           = 0x7419,
    QMK_QK_JOYSTICK_BUTTON_26                           = 0x741A,
    QMK_QK_JOYSTICK_BUTTON_27                           = 0x741B,
    QMK_QK_JOYSTICK_BUTTON_28                           = 0x741C,
    QMK_QK_JOYSTICK_BUTTON_29                           = 0x741D,
    QMK_QK_JOYSTICK_BUTTON_30                           = 0x741E,
    QMK_QK_JOYSTICK_BUTTON_31                           = 0x741F,
    QMK_QK_PROGRAMMABLE_BUTTON_1                        = 0x7440,
    QMK_QK_PROGRAMMABLE_BUTTON_2                        = 0x7441,
    QMK_QK_PROGRAMMABLE_BUTTON_3                        = 0x7442,
    QMK_QK_PROGRAMMABLE_BUTTON_4                        = 0x7443,
    QMK_QK_PROGRAMMABLE_BUTTON_5                        = 0x7444,
    QMK_QK_PROGRAMMABLE_BUTTON_6                        = 0x7445,
    QMK_QK_PROGRAMMABLE_BUTTON_7                        = 0x7446,
    QMK_QK_PROGRAMMABLE_BUTTON_8                        = 0x7447,
    QMK_QK_PROGRAMMABLE_BUTTON_9                        = 0x7448,
    QMK_QK_PROGRAMMABLE_BUTTON_10                       = 0x7449,
    QMK_QK_PROGRAMMABLE_BUTTON_11                       = 0x744A,
    QMK_QK_PROGRAMMABLE_BUTTON_12                       = 0x744B,
    QMK_QK_PROGRAMMABLE_BUTTON_13                       = 0x744C,
    QMK_QK_PROGRAMMABLE_BUTTON_14                       = 0x744D,
    QMK_QK_PROGRAMMABLE_BUTTON_15                       = 0x744E,
    QMK_QK_PROGRAMMABLE_BUTTON_16                       = 0x744F,
    QMK_QK_PROGRAMMABLE_BUTTON_17                       = 0x7450,
    QMK_QK_PROGRAMMABLE_BUTTON_18                       = 0x7451,
    QMK_QK_PROGRAMMABLE_BUTTON_19                       = 0x7452,
    QMK_QK_PROGRAMMABLE_BUTTON_20                       = 0x7453,
    QMK_QK_PROGRAMMABLE_BUTTON_21                       = 0x7454,
    QMK_QK_PROGRAMMABLE_BUTTON_22                       = 0x7455,
    QMK_QK_PROGRAMMABLE_BUTTON_23                       = 0x7456,
    QMK_QK_PROGRAMMABLE_BUTTON_24                       = 0x7457,
    QMK_QK_PROGRAMMABLE_BUTTON_25                       = 0x7458,
    QMK_QK_PROGRAMMABLE_BUTTON_26                       = 0x7459,
    QMK_QK_PROGRAMMABLE_BUTTON_27                       = 0x745A,
    QMK_QK_PROGRAMMABLE_BUTTON_28                       = 0x745B,
    QMK_QK_PROGRAMMABLE_BUTTON_29                       = 0x745C,
    QMK_QK_PROGRAMMABLE_BUTTON_30                       = 0x745D,
    QMK_QK_PROGRAMMABLE_BUTTON_31                       = 0x745E,
    QMK_QK_PROGRAMMABLE_BUTTON_32                       = 0x745F,
    QMK_QK_AUDIO_ON                                     = 0x7480,
    QMK_QK_AUDIO_OFF                                    = 0x7481,
    QMK_QK_AUDIO_TOGGLE                                 = 0x7482,
    QMK_QK_AUDIO_CLICKY_TOGGLE                          = 0x748A,
    QMK_QK_AUDIO_CLICKY_ON                              = 0x748B,
    QMK_QK_AUDIO_CLICKY_OFF                             = 0x748C,
    QMK_QK_AUDIO_CLICKY_UP                              = 0x748D,
    QMK_QK_AUDIO_CLICKY_DOWN                            = 0x748E,
    QMK_QK_AUDIO_CLICKY_RESET                           = 0x748F,
    QMK_QK_MUSIC_ON                                     = 0x7490,
    QMK_QK_MUSIC_OFF                                    = 0x7491,
    QMK_QK_MUSIC_TOGGLE                                 = 0x7492,
    QMK_QK_MUSIC_MODE_NEXT                              = 0x7493,
    QMK_QK_AUDIO_VOICE_NEXT                             = 0x7494,
    QMK_QK_AUDIO_VOICE_PREVIOUS                         = 0x7495,
    QMK_QK_STENO_BOLT                                   = 0x74F0,
    QMK_QK_STENO_GEMINI                                 = 0x74F1,
    QMK_QK_STENO_COMB                                   = 0x74F2,
    QMK_QK_STENO_COMB_MAX                               = 0x74FC,
    QMK_QK_MACRO_0                                      = 0x7700,
    QMK_QK_MACRO_1                                      = 0x7701,
    QMK_QK_MACRO_2                                      = 0x7702,
    QMK_QK_MACRO_3                                      = 0x7703,
    QMK_QK_MACRO_4                                      = 0x7704,
    QMK_QK_MACRO_5                                      = 0x7705,
    QMK_QK_MACRO_6                                      = 0x7706,
    QMK_QK_MACRO_7                                      = 0x7707,
    QMK_QK_MACRO_8                                      = 0x7708,
    QMK_QK_MACRO_9                                      = 0x7709,
    QMK_QK_MACRO_10                                     = 0x770A,
    QMK_QK_MACRO_11                                     = 0x770B,
    QMK_QK_MACRO_12                                     = 0x770C,
    QMK_QK_MACRO_13                                     = 0x770D,
    QMK_QK_MACRO_14                                     = 0x770E,
    QMK_QK_MACRO_15                                     = 0x770F,
    QMK_QK_MACRO_16                                     = 0x7710,
    QMK_QK_MACRO_17                                     = 0x7711,
    QMK_QK_MACRO_18                                     = 0x7712,
    QMK_QK_MACRO_19                                     = 0x7713,
    QMK_QK_MACRO_20                                     = 0x7714,
    QMK_QK_MACRO_21                                     = 0x7715,
    QMK_QK_MACRO_22                                     = 0x7716,
    QMK_QK_MACRO_23                                     = 0x7717,
    QMK_QK_MACRO_24                                     = 0x7718,
    QMK_QK_MACRO_25                                     = 0x7719,
    QMK_QK_MACRO_26                                     = 0x771A,
    QMK_QK_MACRO_27                                     = 0x771B,
    QMK_QK_MACRO_28                                     = 0x771C,
    QMK_QK_MACRO_29                                     = 0x771D,
    QMK_QK_MACRO_30                                     = 0x771E,
    QMK_QK_MACRO_31                                     = 0x771F,
    QMK_QK_OUTPUT_AUTO                                  = 0x7780,
    QMK_QK_OUTPUT_NEXT                                  = 0x7781,
    QMK_QK_OUTPUT_PREV                                  = 0x7782,
    QMK_QK_OUTPUT_NONE                                  = 0x7783,
    QMK_QK_OUTPUT_USB                                   = 0x7784,
    QMK_QK_OUTPUT_2P4GHZ                                = 0x7785,
    QMK_QK_OUTPUT_BLUETOOTH                             = 0x7786,
    QMK_QK_BLUETOOTH_PROFILE_NEXT                       = 0x7790,
    QMK_QK_BLUETOOTH_PROFILE_PREV                       = 0x7791,
    QMK_QK_BLUETOOTH_UNPAIR                             = 0x7792,
    QMK_QK_BLUETOOTH_PROFILE1                           = 0x7793,
    QMK_QK_BLUETOOTH_PROFILE2                           = 0x7794,
    QMK_QK_BLUETOOTH_PROFILE3                           = 0x7795,
    QMK_QK_BLUETOOTH_PROFILE4                           = 0x7796,
    QMK_QK_BLUETOOTH_PROFILE5                           = 0x7797,
    QMK_QK_BACKLIGHT_ON                                 = 0x7800,
    QMK_QK_BACKLIGHT_OFF                                = 0x7801,
    QMK_QK_BACKLIGHT_TOGGLE                             = 0x7802,
    QMK_QK_BACKLIGHT_DOWN                               = 0x7803,
    QMK_QK_BACKLIGHT_UP                                 = 0x7804,
    QMK_QK_BACKLIGHT_STEP                               = 0x7805,
    QMK_QK_BACKLIGHT_TOGGLE_BREATHING                   = 0x7806,
    QMK_QK_LED_MATRIX_ON                                = 0x7810,
    QMK_QK_LED_MATRIX_OFF                               = 0x7811,
    QMK_QK_LED_MATRIX_TOGGLE                            = 0x7812,
    QMK_QK_LED_MATRIX_MODE_NEXT                         = 0x7813,
    QMK_QK_LED_MATRIX_MODE_PREVIOUS                     = 0x7814,
    QMK_QK_LED_MATRIX_BRIGHTNESS_UP                     = 0x7815,
    QMK_QK_LED_MATRIX_BRIGHTNESS_DOWN                   = 0x7816,
    QMK_QK_LED_MATRIX_SPEED_UP                          = 0x7817,
    QMK_QK_LED_MATRIX_SPEED_DOWN                        = 0x7818,
    QMK_QK_UNDERGLOW_TOGGLE                             = 0x7820,
    QMK_QK_UNDERGLOW_MODE_NEXT                          = 0x7821,
    QMK_QK_UNDERGLOW_MODE_PREVIOUS                      = 0x7822,
    QMK_QK_UNDERGLOW_HUE_UP                             = 0x7823,
    QMK_QK_UNDERGLOW_HUE_DOWN                           = 0x7824,
    QMK_QK_UNDERGLOW_SATURATION_UP                      = 0x7825,
    QMK_QK_UNDERGLOW_SATURATION_DOWN                    = 0x7826,
    QMK_QK_UNDERGLOW_VALUE_UP                           = 0x7827,
    QMK_QK_UNDERGLOW_VALUE_DOWN                         = 0x7828,
    QMK_QK_UNDERGLOW_SPEED_UP                           = 0x7829,
    QMK_QK_UNDERGLOW_SPEED_DOWN                         = 0x782A,
    QMK_RGB_MODE_PLAIN                                  = 0x782B,
    QMK_RGB_MODE_BREATHE                                = 0x782C,
    QMK_RGB_MODE_RAINBOW                                = 0x782D,
    QMK_RGB_MODE_SWIRL                                  = 0x782E,
    QMK_RGB_MODE_SNAKE                                  = 0x782F,
    QMK_RGB_MODE_KNIGHT                                 = 0x7830,
    QMK_RGB_MODE_XMAS                                   = 0x7831,
    QMK_RGB_MODE_GRADIENT                               = 0x7832,
    QMK_RGB_MODE_RGBTEST                                = 0x7833,
    QMK_RGB_MODE_TWINKLE                                = 0x7834,
    QMK_QK_RGB_MATRIX_ON                                = 0x7840,
    QMK_QK_RGB_MATRIX_OFF                               = 0x7841,
    QMK_QK_RGB_MATRIX_TOGGLE                            = 0x7842,
    QMK_QK_RGB_MATRIX_MODE_NEXT                         = 0x7843,
    QMK_QK_RGB_MATRIX_MODE_PREVIOUS                     = 0x7844,
    QMK_QK_RGB_MATRIX_HUE_UP                            = 0x7845,
    QMK_QK_RGB_MATRIX_HUE_DOWN                          = 0x7846,
    QMK_QK_RGB_MATRIX_SATURATION_UP                     = 0x7847,
    QMK_QK_RGB_MATRIX_SATURATION_DOWN                   = 0x7848,
    QMK_QK_RGB_MATRIX_VALUE_UP                          = 0x7849,
    QMK_QK_RGB_MATRIX_VALUE_DOWN                        = 0x784A,
    QMK_QK_RGB_MATRIX_SPEED_UP                          = 0x784B,
    QMK_QK_RGB_MATRIX_SPEED_DOWN                        = 0x784C,
    QMK_QK_BOOTLOADER                                   = 0x7C00,
    QMK_QK_REBOOT                                       = 0x7C01,
    QMK_QK_DEBUG_TOGGLE                                 = 0x7C02,
    QMK_QK_CLEAR_EEPROM                                 = 0x7C03,
    QMK_QK_MAKE                                         = 0x7C04,
    QMK_QK_AUTO_SHIFT_DOWN                              = 0x7C10,
    QMK_QK_AUTO_SHIFT_UP                                = 0x7C11,
    QMK_QK_AUTO_SHIFT_REPORT                            = 0x7C12,
    QMK_QK_AUTO_SHIFT_ON                                = 0x7C13,
    QMK_QK_AUTO_SHIFT_OFF                               = 0x7C14,
    QMK_QK_AUTO_SHIFT_TOGGLE                            = 0x7C15,
    QMK_QK_GRAVE_ESCAPE                                 = 0x7C16,
    QMK_QK_VELOCIKEY_TOGGLE                             = 0x7C17,
    QMK_QK_SPACE_CADET_LEFT_CTRL_PARENTHESIS_OPEN       = 0x7C18,
    QMK_QK_SPACE_CADET_RIGHT_CTRL_PARENTHESIS_CLOSE     = 0x7C19,
    QMK_QK_SPACE_CADET_LEFT_SHIFT_PARENTHESIS_OPEN      = 0x7C1A,
    QMK_QK_SPACE_CADET_RIGHT_SHIFT_PARENTHESIS_CLOSE    = 0x7C1B,
    QMK_QK_SPACE_CADET_LEFT_ALT_PARENTHESIS_OPEN        = 0x7C1C,
    QMK_QK_SPACE_CADET_RIGHT_ALT_PARENTHESIS_CLOSE      = 0x7C1D,
    QMK_QK_SPACE_CADET_RIGHT_SHIFT_ENTER                = 0x7C1E,
    QMK_QK_UNICODE_MODE_NEXT                            = 0x7C30,
    QMK_QK_UNICODE_MODE_PREVIOUS                        = 0x7C31,
    QMK_QK_UNICODE_MODE_MACOS                           = 0x7C32,
    QMK_QK_UNICODE_MODE_LINUX                           = 0x7C33,
    QMK_QK_UNICODE_MODE_WINDOWS                         = 0x7C34,
    QMK_QK_UNICODE_MODE_BSD                             = 0x7C35,
    QMK_QK_UNICODE_MODE_WINCOMPOSE                      = 0x7C36,
    QMK_QK_UNICODE_MODE_EMACS                           = 0x7C37,
    QMK_QK_HAPTIC_ON                                    = 0x7C40,
    QMK_QK_HAPTIC_OFF                                   = 0x7C41,
    QMK_QK_HAPTIC_TOGGLE                                = 0x7C42,
    QMK_QK_HAPTIC_RESET                                 = 0x7C43,
    QMK_QK_HAPTIC_FEEDBACK_TOGGLE                       = 0x7C44,
    QMK_QK_HAPTIC_BUZZ_TOGGLE                           = 0x7C45,
    QMK_QK_HAPTIC_MODE_NEXT                             = 0x7C46,
    QMK_QK_HAPTIC_MODE_PREVIOUS                         = 0x7C47,
    QMK_QK_HAPTIC_CONTINUOUS_TOGGLE                     = 0x7C48,
    QMK_QK_HAPTIC_CONTINUOUS_UP                         = 0x7C49,
    QMK_QK_HAPTIC_CONTINUOUS_DOWN                       = 0x7C4A,
    QMK_QK_HAPTIC_DWELL_UP                              = 0x7C4B,
    QMK_QK_HAPTIC_DWELL_DOWN                            = 0x7C4C,
    QMK_QK_COMBO_ON                                     = 0x7C50,
    QMK_QK_COMBO_OFF                                    = 0x7C51,
    QMK_QK_COMBO_TOGGLE                                 = 0x7C52,
    QMK_QK_DYNAMIC_MACRO_RECORD_START_1                 = 0x7C53,
    QMK_QK_DYNAMIC_MACRO_RECORD_START_2                 = 0x7C54,
    QMK_QK_DYNAMIC_MACRO_RECORD_STOP                    = 0x7C55,
    QMK_QK_DYNAMIC_MACRO_PLAY_1                         = 0x7C56,
    QMK_QK_DYNAMIC_MACRO_PLAY_2                         = 0x7C57,
    QMK_QK_LEADER                                       = 0x7C58,
    QMK_QK_LOCK                                         = 0x7C59,
    QMK_QK_ONE_SHOT_ON                                  = 0x7C5A,
    QMK_QK_ONE_SHOT_OFF                                 = 0x7C5B,
    QMK_QK_ONE_SHOT_TOGGLE                              = 0x7C5C,
    QMK_QK_KEY_OVERRIDE_TOGGLE                          = 0x7C5D,
    QMK_QK_KEY_OVERRIDE_ON                              = 0x7C5E,
    QMK_QK_KEY_OVERRIDE_OFF                             = 0x7C5F,
    QMK_QK_SECURE_LOCK                                  = 0x7C60,
    QMK_QK_SECURE_UNLOCK                                = 0x7C61,
    QMK_QK_SECURE_TOGGLE                                = 0x7C62,
    QMK_QK_SECURE_REQUEST                               = 0x7C63,
    QMK_QK_DYNAMIC_TAPPING_TERM_PRINT                   = 0x7C70,
    QMK_QK_DYNAMIC_TAPPING_TERM_UP                      = 0x7C71,
    QMK_QK_DYNAMIC_TAPPING_TERM_DOWN                    = 0x7C72,
    QMK_QK_CAPS_WORD_TOGGLE                             = 0x7C73,
    QMK_QK_AUTOCORRECT_ON                               = 0x7C74,
    QMK_QK_AUTOCORRECT_OFF                              = 0x7C75,
    QMK_QK_AUTOCORRECT_TOGGLE                           = 0x7C76,
    QMK_QK_TRI_LAYER_LOWER                              = 0x7C77,
    QMK_QK_TRI_LAYER_UPPER                              = 0x7C78,
    QMK_QK_REPEAT_KEY                                   = 0x7C79,
    QMK_QK_ALT_REPEAT_KEY                               = 0x7C7A,
    QMK_QK_LAYER_LOCK                                   = 0x7C7B,
    QMK_QK_KB_0                                         = 0x7E00,
    QMK_QK_KB_1                                         = 0x7E01,
    QMK_QK_KB_2                                         = 0x7E02,
    QMK_QK_KB_3                                         = 0x7E03,
    QMK_QK_KB_4                                         = 0x7E04,
    QMK_QK_KB_5                                         = 0x7E05,
    QMK_QK_KB_6                                         = 0x7E06,
    QMK_QK_KB_7                                         = 0x7E07,
    QMK_QK_KB_8                                         = 0x7E08,
    QMK_QK_KB_9                                         = 0x7E09,
    QMK_QK_KB_10                                        = 0x7E0A,
    QMK_QK_KB_11                                        = 0x7E0B,
    QMK_QK_KB_12                                        = 0x7E0C,
    QMK_QK_KB_13                                        = 0x7E0D,
    QMK_QK_KB_14                                        = 0x7E0E,
    QMK_QK_KB_15                                        = 0x7E0F,
    QMK_QK_KB_16                                        = 0x7E10,
    QMK_QK_KB_17                                        = 0x7E11,
    QMK_QK_KB_18                                        = 0x7E12,
    QMK_QK_KB_19                                        = 0x7E13,
    QMK_QK_KB_20                                        = 0x7E14,
    QMK_QK_KB_21                                        = 0x7E15,
    QMK_QK_KB_22                                        = 0x7E16,
    QMK_QK_KB_23                                        = 0x7E17,
    QMK_QK_KB_24                                        = 0x7E18,
    QMK_QK_KB_25                                        = 0x7E19,
    QMK_QK_KB_26                                        = 0x7E1A,
    QMK_QK_KB_27                                        = 0x7E1B,
    QMK_QK_KB_28                                        = 0x7E1C,
    QMK_QK_KB_29                                        = 0x7E1D,
    QMK_QK_KB_30                                        = 0x7E1E,
    QMK_QK_KB_31                                        = 0x7E1F,
    QMK_QK_USER_0                                       = 0x7E40,
    QMK_QK_USER_1                                       = 0x7E41,
    QMK_QK_USER_2                                       = 0x7E42,
    QMK_QK_USER_3                                       = 0x7E43,
    QMK_QK_USER_4                                       = 0x7E44,
    QMK_QK_USER_5                                       = 0x7E45,
    QMK_QK_USER_6                                       = 0x7E46,
    QMK_QK_USER_7                                       = 0x7E47,
    QMK_QK_USER_8                                       = 0x7E48,
    QMK_QK_USER_9                                       = 0x7E49,
    QMK_QK_USER_10                                      = 0x7E4A,
    QMK_QK_USER_11                                      = 0x7E4B,
    QMK_QK_USER_12                                      = 0x7E4C,
    QMK_QK_USER_13                                      = 0x7E4D,
    QMK_QK_USER_14                                      = 0x7E4E,
    QMK_QK_USER_15                                      = 0x7E4F,
    QMK_QK_USER_16                                      = 0x7E50,
    QMK_QK_USER_17                                      = 0x7E51,
    QMK_QK_USER_18                                      = 0x7E52,
    QMK_QK_USER_19                                      = 0x7E53,
    QMK_QK_USER_20                                      = 0x7E54,
    QMK_QK_USER_21                                      = 0x7E55,
    QMK_QK_USER_22                                      = 0x7E56,
    QMK_QK_USER_23                                      = 0x7E57,
    QMK_QK_USER_24                                      = 0x7E58,
    QMK_QK_USER_25                                      = 0x7E59,
    QMK_QK_USER_26                                      = 0x7E5A,
    QMK_QK_USER_27                                      = 0x7E5B,
    QMK_QK_USER_28                                      = 0x7E5C,
    QMK_QK_USER_29                                      = 0x7E5D,
    QMK_QK_USER_30                                      = 0x7E5E,
    QMK_QK_USER_31                                      = 0x7E5F,
};

extern std::map<qmk_keycode, std::string> qmk_keynames;
