# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.storagecache import StorageCacheManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestStorageCacheManagementAutoExportJobsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(StorageCacheManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_auto_export_jobs_begin_delete(self, resource_group):
        response = self.client.auto_export_jobs.begin_delete(
            resource_group_name=resource_group.name,
            aml_filesystem_name="str",
            auto_export_job_name="str",
            api_version="2025-07-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_auto_export_jobs_get(self, resource_group):
        response = self.client.auto_export_jobs.get(
            resource_group_name=resource_group.name,
            aml_filesystem_name="str",
            auto_export_job_name="str",
            api_version="2025-07-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_auto_export_jobs_begin_create_or_update(self, resource_group):
        response = self.client.auto_export_jobs.begin_create_or_update(
            resource_group_name=resource_group.name,
            aml_filesystem_name="str",
            auto_export_job_name="str",
            auto_export_job={
                "location": "str",
                "adminStatus": "str",
                "autoExportPrefixes": ["str"],
                "currentIterationFilesDiscovered": 0,
                "currentIterationFilesExported": 0,
                "currentIterationFilesFailed": 0,
                "currentIterationMiBDiscovered": 0,
                "currentIterationMiBExported": 0,
                "exportIterationCount": 0,
                "id": "str",
                "lastCompletionTimeUTC": "2020-02-20 00:00:00",
                "lastStartedTimeUTC": "2020-02-20 00:00:00",
                "lastSuccessfulIterationCompletionTimeUTC": "2020-02-20 00:00:00",
                "name": "str",
                "provisioningState": "str",
                "state": "str",
                "statusCode": "str",
                "statusMessage": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "totalFilesExported": 0,
                "totalFilesFailed": 0,
                "totalMiBExported": 0,
                "type": "str",
            },
            api_version="2025-07-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_auto_export_jobs_begin_update(self, resource_group):
        response = self.client.auto_export_jobs.begin_update(
            resource_group_name=resource_group.name,
            aml_filesystem_name="str",
            auto_export_job_name="str",
            auto_export_job={"adminStatus": "str", "tags": {"str": "str"}},
            api_version="2025-07-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_auto_export_jobs_list_by_aml_filesystem(self, resource_group):
        response = self.client.auto_export_jobs.list_by_aml_filesystem(
            resource_group_name=resource_group.name,
            aml_filesystem_name="str",
            api_version="2025-07-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
