% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Topology.R
\name{plotEdgeTest}
\alias{plotEdgeTest}
\title{Plot the results of an edge permutation test}
\usage{
plotEdgeTest(
  data,
  color = "black",
  main_title = "Edge Test",
  style = c("histogram", "cdf"),
  silent = FALSE,
  ...
)
}
\arguments{
\item{data}{\link{EdgeTest} object returned by \link{testEdges}.}

\item{color}{color of the histogram or lines.}

\item{main_title}{string specifying the plot title.}

\item{style}{type of plot to draw. One of:
\itemize{
  \item \code{"histogram"}:  histogram of the edge count 
                             distribution with a red dotted line
                             denoting the observed value.
  \item \code{"cdf"}:        cumulative distribution function 
                             of edge counts with a red dotted 
                             line denoting the observed value and
                             a blue dotted line indicating the 
                             p-value.
}}

\item{silent}{if \code{TRUE} do not draw the plot and just return the ggplot2 
object; if \code{FALSE} draw the plot.}

\item{...}{additional arguments to pass to ggplot2::theme.}
}
\value{
A \code{ggplot} object defining the plot.
}
\description{
\code{plotEdgeTest} plots the results of an edge permutation test performed with 
\code{testEdges} as either a histogram or cumulative distribution function.
}
\examples{
\donttest{
# Define example tree set
graphs <- ExampleTrees[1-10]

# Perform edge test on isotypes
x <- testEdges(graphs, "c_call", nperm=10)

# Plot
plotEdgeTest(x, color="steelblue", style="hist")
plotEdgeTest(x, style="cdf")
}

}
\seealso{
See \link{testEdges} for performing the test.
}
