% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chunkutil.R
\name{bbatch}
\alias{bbatch}
\title{Balanced Batch sizes}
\usage{
bbatch(N, B)
}
\arguments{
\item{N}{total size in 0..integer_max}

\item{B}{desired batch size in 1..integer_max}
}
\value{
a list with components:
\itemize{
\item b: the batch size
\item nb: the number of batches
\item rb: the size of the rest
}
}
\description{
\code{bbatch} calculates batch sizes in 1..N so that they have rather balanced
sizes than very different sizes.
}
\details{
Tries to have \code{rb == 0} or \code{rb} as close to \code{b} as possible
while guaranteeing that \code{rb < b && (b - rb) <= min(nb, b)}
}
\examples{

  bbatch(100, 24)

}
\seealso{
\code{\link[=repfromto]{repfromto()}}, \code{\link[ff:ffapply]{ff::ffvecapply()}}
}
\author{
Jens Oehlschlägel
}
\keyword{IO}
\keyword{data}
