% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/client.R
\name{cli_it}
\alias{cli_it}
\title{CLI list item(s)}
\usage{
cli_it(
  items = NULL,
  id = NULL,
  class = NULL,
  .auto_close = TRUE,
  .envir = parent.frame()
)
}
\arguments{
\item{items}{Character vector of items, or \code{NULL}.}

\item{id}{Id of the new container. Can be used for closing it with
\code{\link[=cli_end]{cli_end()}} or in themes. If \code{NULL}, then an id is generated and
retuned invisibly.}

\item{class}{Class of the item container. Can be used in themes.}

\item{.auto_close}{Whether to close the container, when the calling
function finishes (or \code{.envir} is removed, if specified).}

\item{.envir}{Environment to evaluate the glue expressions in. It is
also used to auto-close the container if \code{.auto_close} is \code{TRUE}.}
}
\value{
The id of the new container element, invisibly.
}
\description{
A list item is a container, see \link{containers}.
}
\examples{
## Adding items one by one
cli_ul()
cli_it("one")
cli_it("two")
cli_it("three")
cli_end()

## Complex item, added gradually.
cli_ul()
cli_it()
cli_verbatim("Beginning of the {emph first} item")
cli_text("Still the first item")
cli_end()
cli_it("Second item")
cli_end()
}
