% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colwise-select.R
\name{select_all}
\alias{select_all}
\alias{rename_all}
\alias{select_if}
\alias{rename_if}
\alias{select_at}
\alias{rename_at}
\title{Select and rename a selection of variables}
\usage{
select_all(.tbl, .funs = list(), ...)

rename_all(.tbl, .funs = list(), ...)

select_if(.tbl, .predicate, .funs = list(), ...)

rename_if(.tbl, .predicate, .funs = list(), ...)

select_at(.tbl, .vars, .funs = list(), ...)

rename_at(.tbl, .vars, .funs = list(), ...)
}
\arguments{
\item{.tbl}{A \code{tbl} object.}

\item{.funs}{A function \code{fun}, a purrr style lambda \code{~ fun(.)} or a list of either form.}

\item{...}{Additional arguments for the function calls in
\code{.funs}. These are evaluated only once, with \link[rlang:dyn-dots]{tidy dots} support.}

\item{.predicate}{A predicate function to be applied to the columns
or a logical vector. The variables for which \code{.predicate} is or
returns \code{TRUE} are selected. This argument is passed to
\code{\link[rlang:as_function]{rlang::as_function()}} and thus supports quosure-style lambda
functions and strings representing function names.}

\item{.vars}{A list of columns generated by \code{\link[=vars]{vars()}},
a character vector of column names, a numeric vector of column
positions, or \code{NULL}.}
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("superseded")}

\code{rename_if()}, \code{rename_at()}, and \code{rename_all()} have been superseded by
\code{rename_with()}. The matching select statements have been superseded by the
combination of a \code{select()} + \code{rename_with()}.

These functions were superseded because \code{mutate_if()} and friends were
superseded by \code{across()}. \code{select_if()} and \code{rename_if()} already use tidy
selection so they can't be replaced by \code{across()} and instead we need a new
function.
}
\examples{
mtcars <- as_tibble(mtcars) # for nicer printing

mtcars \%>\% rename_all(toupper)
# ->
mtcars \%>\% rename_with(toupper)

# NB: the transformation comes first in rename_with
is_whole <- function(x) all(floor(x) == x)
mtcars \%>\% rename_if(is_whole, toupper)
# ->
mtcars \%>\% rename_with(toupper, where(is_whole))

mtcars \%>\% rename_at(vars(mpg:hp), toupper)
# ->
mtcars \%>\% rename_with(toupper, mpg:hp)

# You now must select() and then rename

mtcars \%>\% select_all(toupper)
# ->
mtcars \%>\% rename_with(toupper)

# Selection drops unselected variables:
mtcars \%>\% select_if(is_whole, toupper)
# ->
mtcars \%>\% select(where(is_whole)) \%>\% rename_with(toupper)

mtcars \%>\% select_at(vars(-contains("ar"), starts_with("c")), toupper)
# ->
mtcars \%>\%
  select(!contains("ar") | starts_with("c")) \%>\%
  rename_with(toupper)
}
\keyword{internal}
