% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ls_means.R
\name{as.data.frame.ls_means}
\alias{as.data.frame.ls_means}
\title{Coerce \code{ls_means} Objects to \code{data.frame}s}
\usage{
\method{as.data.frame}{ls_means}(x, ..., add_levels = TRUE)
}
\arguments{
\item{x}{an \code{\link{ls_means}} object.}

\item{...}{currently not used.}

\item{add_levels}{add \code{term} and \code{levels} columns to returned
\code{data.frame}?}
}
\description{
Coerce \code{ls_means} Objects to \code{data.frame}s
}
\examples{

# Fit example model:
data("cake", package="lme4")
cake$Temp <- factor(cake$temperature, ordered = FALSE)
model <- lmer(angle ~ recipe + Temp + (1|recipe:replicate), cake)

# Extract LS-means:
head(lsm <- ls_means(model))

# Coerce LS-means objects to data.frames:
head(as.data.frame(lsm))
head(as.data.frame(lsm, add_levels=FALSE))

}
\seealso{
\code{\link{ls_means.lmerModLmerTest}}
}
\author{
Rune Haubo B. Christensen
}
\keyword{internal}
