% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Classification.R
\name{LogLoss}
\alias{LogLoss}
\title{Log loss / Cross-Entropy Loss}
\usage{
LogLoss(y_pred, y_true)
}
\arguments{
\item{y_pred}{Predicted probabilities vector, as returned by a classifier}

\item{y_true}{Ground truth (correct) 0-1 labels vector}
}
\value{
Log loss/Cross-Entropy Loss
}
\description{
Compute the log loss/cross-entropy loss.
}
\examples{
data(cars)
logreg <- glm(formula = vs ~ hp + wt,
              family = binomial(link = "logit"), data = mtcars)
LogLoss(y_pred = logreg$fitted.values, y_true = mtcars$vs)
}

