% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nanoperiod.R
\name{nanoperiod.month,nanoperiod-method}
\alias{nanoperiod.month,nanoperiod-method}
\alias{nanoperiod.month}
\alias{nanoperiod.day}
\alias{nanoperiod.nanoduration}
\alias{nanoperiod.day,nanoperiod-method}
\alias{nanoperiod.nanoduration,nanoperiod-method}
\title{Nanoperiod accessors}
\usage{
\S4method{nanoperiod.month}{nanoperiod}(x)

\S4method{nanoperiod.day}{nanoperiod}(x)

\S4method{nanoperiod.nanoduration}{nanoperiod}(x)
}
\arguments{
\item{x}{A \code{nanoperiod}}
}
\value{
\code{nanoperiod.month} and \code{nanoperiod.day} return
    an \code{integer64} whereas \code{nanoperiod.nanoduration}
    returns a \code{nanoduration}
}
\description{
These functions allow access to the components of a \code{nanoperiod}
}
\examples{
p <- as.nanoperiod("2y1m1d/12:00:00")
nanoperiod.month(p)
nanoperiod.day(p)
nanoperiod.nanoduration(p)
}
\seealso{
\code{\link{nanoduration}}
}
\author{
Dirk Eddelbuettel

Leonardo Silvestri
}
