% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_performance.R
\name{model_performance}
\alias{model_performance}
\alias{performance}
\title{Model Performance}
\usage{
model_performance(model, ...)

performance(model, ...)
}
\arguments{
\item{model}{Statistical model.}

\item{...}{Arguments passed to or from other methods, resp. for
\code{compare_performance()}, one or multiple model objects (also of
different classes).}
}
\value{
A data frame (with one row) and one column per "index" (see \code{metrics}).
}
\description{
See the documentation for your object's class:
\itemize{
  \item \link[=model_performance.lm]{Frequentist Regressions}
  \item \link[=model_performance.merMod]{Mixed models}
  \item \link[=model_performance.stanreg]{Bayesian models}
  \item \link[=model_performance.lavaan]{CFA / SEM lavaan models}
  \item \link[=model_performance.rma]{Meta-analysis models}
}
}
\examples{
model <- lm(mpg ~ wt + cyl, data = mtcars)
model_performance(model)

model <- glm(vs ~ wt + mpg, data = mtcars, family = "binomial")
model_performance(model)
}
\seealso{
\code{\link[=compare_performance]{compare_performance()}} to compare performance of many different models.
}
