% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auth.R
\name{rtweet_user}
\alias{rtweet_user}
\alias{rtweet_bot}
\alias{rtweet_app}
\alias{rtweet_bearer}
\alias{rtweet_oauth2}
\title{Authentication options}
\usage{
rtweet_user(
  client_id = NULL,
  client_secret = NULL,
  api_key = client_id,
  api_secret = client_secret
)

rtweet_bot(api_key, api_secret, access_token, access_secret, app = "rtweet")

rtweet_app(bearer_token)

rtweet_bearer(client = NULL, scopes = NULL)

rtweet_oauth2(client = NULL, scopes = NULL)
}
\arguments{
\item{client_id, client_secret}{Application OAuth client ID and client Secret.
These are generally not required for \code{rtweet_user()} since the defaults will use
the built-in rtweet app.}

\item{api_key, api_secret}{API key and secret. Deprecated in favor of \verb{client_*} arguments.}

\item{access_token, access_secret}{Access token and secret.}

\item{app}{Name of the application you are building.}

\item{bearer_token}{App bearer token.}

\item{client}{Which client app will be used, see \code{\link[=rtweet_client]{rtweet_client()}} for details.}

\item{scopes}{The permissions of the app, see \code{\link[=set_scopes]{set_scopes()}} for details.
By default it uses the client's scopes. Provided here in case you want to modify them.}
}
\value{
If the validation is successful the OAuth token.
For \code{rtweet_app()} a \code{rtweet_bearer}.
}
\description{
Authenticate methods to use the Twitter API.
See the instructions in \code{vignette("auth", package = "rtweet")}.
}
\details{
There are four ways that you can authenticate with the Twitter API:
\itemize{
\item \code{rtweet_user()} interactively authenticates an existing Twitter user.
This form is most appropriate if you want rtweet to control your
Twitter account.
\item \code{rtweet_app()} authenticates as a Twitter application. An application can't
perform actions (i.e. it can't tweet) but otherwise has generally higher
rate limits (i.e. you can do more searches). See details
at \url{https://developer.twitter.com/en/docs/twitter-api/v1/rate-limits}.
This form is most appropriate if you are collecting data.
\item \code{rtweet_bot()} authenticates as bot that takes actions on behalf of an app.
This form is most appropriate if you want to create a Twitter account that
is run by a computer, rather than a human.
\item \code{rtweet_oauth2()} authenticates as a user using a client.
This authentication is required in some endpoints.
}

To use \code{rtweet_app()}, \code{rtweet_bot()}  or \code{rtweet_oauth2()} you will need to
create your own Twitter app following the instructions in
\code{vignette("auth", package = "rtweet")}.
\code{rtweet_user()} \emph{can be} used with your own app, but generally there is
no need to because it uses the Twitter app provided by rtweet.

Use \code{\link[=auth_as]{auth_as()}} to set the default auth mechanism for the current session,
and \code{\link[=auth_save]{auth_save()}} to save an auth mechanism for use in future sessions.
}
\section{Security}{
All of the arguments to these functions are roughly equivalent to
passwords so should generally not be typed into the console (where they
the will be recorded in \code{.Rhistory}) or recorded in a script (which is
easy to accidentally share). Instead, call these functions without arguments
since the default behaviour is to use ask_pass that if possible uses
\code{\link[askpass:askpass]{askpass::askpass()}} to interactively safely prompt you for the values.
}

\examples{
\dontrun{
rtweet_app()
}
}
\references{
\url{https://developer.twitter.com/en/docs/authentication/oauth-2-0/authorization-code}
}
\seealso{
\code{\link[=rtweet_client]{rtweet_client()}}

Other authentication: 
\code{\link{auth_as}()},
\code{\link{auth_get}()},
\code{\link{auth_save}()},
\code{\link{auth_setup_default}()}
}
\concept{authentication}
